package software.amazon.awscdk.services.batch;

/**
 * The <code>AWS::Batch::JobDefinition</code> resource specifies the parameters for an AWS Batch job definition.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/job_definitions.html">Job Definitions</a> in the ** .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:20.182Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition")
public class CfnJobDefinition extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnJobDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnJobDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.batch.CfnJobDefinition.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnJobDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.CfnJobDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The type of job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * Contains a list of consumable resources required by the job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConsumableResourceProperties() {
        return software.amazon.jsii.Kernel.get(this, "consumableResourceProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains a list of consumable resources required by the job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConsumableResourceProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "consumableResourceProperties", value);
    }

    /**
     * Contains a list of consumable resources required by the job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConsumableResourceProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.CfnJobDefinition.ConsumableResourcePropertiesProperty value) {
        software.amazon.jsii.Kernel.set(this, "consumableResourceProperties", value);
    }

    /**
     * An object with properties specific to Amazon ECS-based jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getContainerProperties() {
        return software.amazon.jsii.Kernel.get(this, "containerProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object with properties specific to Amazon ECS-based jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContainerProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "containerProperties", value);
    }

    /**
     * An object with properties specific to Amazon ECS-based jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContainerProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.CfnJobDefinition.ContainerPropertiesProperty value) {
        software.amazon.jsii.Kernel.set(this, "containerProperties", value);
    }

    /**
     * An object that contains the properties for the Amazon ECS resources of a job.When <code>ecsProperties</code> is used in the job definition, it can't be used in addition to <code>containerProperties</code> , <code>eksProperties</code> , or <code>nodeProperties</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEcsProperties() {
        return software.amazon.jsii.Kernel.get(this, "ecsProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that contains the properties for the Amazon ECS resources of a job.When <code>ecsProperties</code> is used in the job definition, it can't be used in addition to <code>containerProperties</code> , <code>eksProperties</code> , or <code>nodeProperties</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEcsProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ecsProperties", value);
    }

    /**
     * An object that contains the properties for the Amazon ECS resources of a job.When <code>ecsProperties</code> is used in the job definition, it can't be used in addition to <code>containerProperties</code> , <code>eksProperties</code> , or <code>nodeProperties</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEcsProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.CfnJobDefinition.EcsPropertiesProperty value) {
        software.amazon.jsii.Kernel.set(this, "ecsProperties", value);
    }

    /**
     * An object with properties that are specific to Amazon EKS-based jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEksProperties() {
        return software.amazon.jsii.Kernel.get(this, "eksProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object with properties that are specific to Amazon EKS-based jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEksProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "eksProperties", value);
    }

    /**
     * An object with properties that are specific to Amazon EKS-based jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEksProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.CfnJobDefinition.EksPropertiesProperty value) {
        software.amazon.jsii.Kernel.set(this, "eksProperties", value);
    }

    /**
     * The name of the job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getJobDefinitionName() {
        return software.amazon.jsii.Kernel.get(this, "jobDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobDefinitionName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "jobDefinitionName", value);
    }

    /**
     * An object with properties that are specific to multi-node parallel jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNodeProperties() {
        return software.amazon.jsii.Kernel.get(this, "nodeProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object with properties that are specific to multi-node parallel jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNodeProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "nodeProperties", value);
    }

    /**
     * An object with properties that are specific to multi-node parallel jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNodeProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.CfnJobDefinition.NodePropertiesProperty value) {
        software.amazon.jsii.Kernel.set(this, "nodeProperties", value);
    }

    /**
     * Default parameters or parameter substitution placeholders that are set in the job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Default parameters or parameter substitution placeholders that are set in the job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "parameters", value);
    }

    /**
     * The platform capabilities required by the job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPlatformCapabilities() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "platformCapabilities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The platform capabilities required by the job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlatformCapabilities(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "platformCapabilities", value);
    }

    /**
     * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPropagateTags() {
        return software.amazon.jsii.Kernel.get(this, "propagateTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPropagateTags(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "propagateTags", value);
    }

    /**
     * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPropagateTags(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "propagateTags", value);
    }

    /**
     * The retry strategy to use for failed jobs that are submitted with this job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRetryStrategy() {
        return software.amazon.jsii.Kernel.get(this, "retryStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The retry strategy to use for failed jobs that are submitted with this job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRetryStrategy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "retryStrategy", value);
    }

    /**
     * The retry strategy to use for failed jobs that are submitted with this job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRetryStrategy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.CfnJobDefinition.RetryStrategyProperty value) {
        software.amazon.jsii.Kernel.set(this, "retryStrategy", value);
    }

    /**
     * The scheduling priority of the job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getSchedulingPriority() {
        return software.amazon.jsii.Kernel.get(this, "schedulingPriority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The scheduling priority of the job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedulingPriority(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "schedulingPriority", value);
    }

    /**
     * The tags that are applied to the job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTagsRaw() {
        return software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The tags that are applied to the job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The timeout time for jobs that are submitted with this job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTimeout() {
        return software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The timeout time for jobs that are submitted with this job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeout(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "timeout", value);
    }

    /**
     * The timeout time for jobs that are submitted with this job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeout(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.CfnJobDefinition.TimeoutProperty value) {
        software.amazon.jsii.Kernel.set(this, "timeout", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * AuthorizationConfigProperty authorizationConfigProperty = AuthorizationConfigProperty.builder()
     *         .accessPointId("accessPointId")
     *         .iam("iam")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-authorizationconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-authorizationconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.AuthorizationConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthorizationConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthorizationConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-authorizationconfig.html#cfn-batch-jobdefinition-authorizationconfig-accesspointid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-authorizationconfig.html#cfn-batch-jobdefinition-authorizationconfig-accesspointid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessPointId() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-authorizationconfig.html#cfn-batch-jobdefinition-authorizationconfig-iam">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-authorizationconfig.html#cfn-batch-jobdefinition-authorizationconfig-iam</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIam() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthorizationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthorizationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthorizationConfigProperty> {
            java.lang.String accessPointId;
            java.lang.String iam;

            /**
             * Sets the value of {@link AuthorizationConfigProperty#getAccessPointId}
             * @param accessPointId the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessPointId(java.lang.String accessPointId) {
                this.accessPointId = accessPointId;
                return this;
            }

            /**
             * Sets the value of {@link AuthorizationConfigProperty#getIam}
             * @param iam the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iam(java.lang.String iam) {
                this.iam = iam;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthorizationConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthorizationConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthorizationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthorizationConfigProperty {
            private final java.lang.String accessPointId;
            private final java.lang.String iam;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessPointId = software.amazon.jsii.Kernel.get(this, "accessPointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.iam = software.amazon.jsii.Kernel.get(this, "iam", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessPointId = builder.accessPointId;
                this.iam = builder.iam;
            }

            @Override
            public final java.lang.String getAccessPointId() {
                return this.accessPointId;
            }

            @Override
            public final java.lang.String getIam() {
                return this.iam;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessPointId() != null) {
                    data.set("accessPointId", om.valueToTree(this.getAccessPointId()));
                }
                if (this.getIam() != null) {
                    data.set("iam", om.valueToTree(this.getIam()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.AuthorizationConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthorizationConfigProperty.Jsii$Proxy that = (AuthorizationConfigProperty.Jsii$Proxy) o;

                if (this.accessPointId != null ? !this.accessPointId.equals(that.accessPointId) : that.accessPointId != null) return false;
                return this.iam != null ? this.iam.equals(that.iam) : that.iam == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessPointId != null ? this.accessPointId.hashCode() : 0;
                result = 31 * result + (this.iam != null ? this.iam.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains a list of consumable resources required by a job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * ConsumableResourcePropertiesProperty consumableResourcePropertiesProperty = ConsumableResourcePropertiesProperty.builder()
     *         .consumableResourceList(List.of(ConsumableResourceRequirementProperty.builder()
     *                 .consumableResource("consumableResource")
     *                 .quantity(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-consumableresourceproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-consumableresourceproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.ConsumableResourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ConsumableResourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConsumableResourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of consumable resources required by a job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-consumableresourceproperties.html#cfn-batch-jobdefinition-consumableresourceproperties-consumableresourcelist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-consumableresourceproperties.html#cfn-batch-jobdefinition-consumableresourceproperties-consumableresourcelist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getConsumableResourceList();

        /**
         * @return a {@link Builder} of {@link ConsumableResourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConsumableResourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConsumableResourcePropertiesProperty> {
            java.lang.Object consumableResourceList;

            /**
             * Sets the value of {@link ConsumableResourcePropertiesProperty#getConsumableResourceList}
             * @param consumableResourceList The list of consumable resources required by a job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder consumableResourceList(software.amazon.awscdk.IResolvable consumableResourceList) {
                this.consumableResourceList = consumableResourceList;
                return this;
            }

            /**
             * Sets the value of {@link ConsumableResourcePropertiesProperty#getConsumableResourceList}
             * @param consumableResourceList The list of consumable resources required by a job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder consumableResourceList(java.util.List<? extends java.lang.Object> consumableResourceList) {
                this.consumableResourceList = consumableResourceList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConsumableResourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConsumableResourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConsumableResourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConsumableResourcePropertiesProperty {
            private final java.lang.Object consumableResourceList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.consumableResourceList = software.amazon.jsii.Kernel.get(this, "consumableResourceList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.consumableResourceList = java.util.Objects.requireNonNull(builder.consumableResourceList, "consumableResourceList is required");
            }

            @Override
            public final java.lang.Object getConsumableResourceList() {
                return this.consumableResourceList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("consumableResourceList", om.valueToTree(this.getConsumableResourceList()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.ConsumableResourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConsumableResourcePropertiesProperty.Jsii$Proxy that = (ConsumableResourcePropertiesProperty.Jsii$Proxy) o;

                return this.consumableResourceList.equals(that.consumableResourceList);
            }

            @Override
            public final int hashCode() {
                int result = this.consumableResourceList.hashCode();
                return result;
            }
        }
    }
    /**
     * Information about a consumable resource required to run a job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * ConsumableResourceRequirementProperty consumableResourceRequirementProperty = ConsumableResourceRequirementProperty.builder()
     *         .consumableResource("consumableResource")
     *         .quantity(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-consumableresourcerequirement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-consumableresourcerequirement.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.ConsumableResourceRequirementProperty")
    @software.amazon.jsii.Jsii.Proxy(ConsumableResourceRequirementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConsumableResourceRequirementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name or ARN of the consumable resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-consumableresourcerequirement.html#cfn-batch-jobdefinition-consumableresourcerequirement-consumableresource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-consumableresourcerequirement.html#cfn-batch-jobdefinition-consumableresourcerequirement-consumableresource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConsumableResource();

        /**
         * The quantity of the consumable resource that is needed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-consumableresourcerequirement.html#cfn-batch-jobdefinition-consumableresourcerequirement-quantity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-consumableresourcerequirement.html#cfn-batch-jobdefinition-consumableresourcerequirement-quantity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getQuantity();

        /**
         * @return a {@link Builder} of {@link ConsumableResourceRequirementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConsumableResourceRequirementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConsumableResourceRequirementProperty> {
            java.lang.String consumableResource;
            java.lang.Number quantity;

            /**
             * Sets the value of {@link ConsumableResourceRequirementProperty#getConsumableResource}
             * @param consumableResource The name or ARN of the consumable resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder consumableResource(java.lang.String consumableResource) {
                this.consumableResource = consumableResource;
                return this;
            }

            /**
             * Sets the value of {@link ConsumableResourceRequirementProperty#getQuantity}
             * @param quantity The quantity of the consumable resource that is needed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder quantity(java.lang.Number quantity) {
                this.quantity = quantity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConsumableResourceRequirementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConsumableResourceRequirementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConsumableResourceRequirementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConsumableResourceRequirementProperty {
            private final java.lang.String consumableResource;
            private final java.lang.Number quantity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.consumableResource = software.amazon.jsii.Kernel.get(this, "consumableResource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.quantity = software.amazon.jsii.Kernel.get(this, "quantity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.consumableResource = java.util.Objects.requireNonNull(builder.consumableResource, "consumableResource is required");
                this.quantity = java.util.Objects.requireNonNull(builder.quantity, "quantity is required");
            }

            @Override
            public final java.lang.String getConsumableResource() {
                return this.consumableResource;
            }

            @Override
            public final java.lang.Number getQuantity() {
                return this.quantity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("consumableResource", om.valueToTree(this.getConsumableResource()));
                data.set("quantity", om.valueToTree(this.getQuantity()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.ConsumableResourceRequirementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConsumableResourceRequirementProperty.Jsii$Proxy that = (ConsumableResourceRequirementProperty.Jsii$Proxy) o;

                if (!consumableResource.equals(that.consumableResource)) return false;
                return this.quantity.equals(that.quantity);
            }

            @Override
            public final int hashCode() {
                int result = this.consumableResource.hashCode();
                result = 31 * result + (this.quantity.hashCode());
                return result;
            }
        }
    }
    /**
     * Container properties are used for Amazon ECS based job definitions.
     * <p>
     * These properties to describe the container that's launched as part of a job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * Object options;
     * ContainerPropertiesProperty containerPropertiesProperty = ContainerPropertiesProperty.builder()
     *         .image("image")
     *         // the properties below are optional
     *         .command(List.of("command"))
     *         .environment(List.of(EnvironmentProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .ephemeralStorage(EphemeralStorageProperty.builder()
     *                 .sizeInGiB(123)
     *                 .build())
     *         .executionRoleArn("executionRoleArn")
     *         .fargatePlatformConfiguration(FargatePlatformConfigurationProperty.builder()
     *                 .platformVersion("platformVersion")
     *                 .build())
     *         .instanceType("instanceType")
     *         .jobRoleArn("jobRoleArn")
     *         .linuxParameters(LinuxParametersProperty.builder()
     *                 .devices(List.of(DeviceProperty.builder()
     *                         .containerPath("containerPath")
     *                         .hostPath("hostPath")
     *                         .permissions(List.of("permissions"))
     *                         .build()))
     *                 .initProcessEnabled(false)
     *                 .maxSwap(123)
     *                 .sharedMemorySize(123)
     *                 .swappiness(123)
     *                 .tmpfs(List.of(TmpfsProperty.builder()
     *                         .containerPath("containerPath")
     *                         .size(123)
     *                         // the properties below are optional
     *                         .mountOptions(List.of("mountOptions"))
     *                         .build()))
     *                 .build())
     *         .logConfiguration(LogConfigurationProperty.builder()
     *                 .logDriver("logDriver")
     *                 // the properties below are optional
     *                 .options(options)
     *                 .secretOptions(List.of(SecretProperty.builder()
     *                         .name("name")
     *                         .valueFrom("valueFrom")
     *                         .build()))
     *                 .build())
     *         .memory(123)
     *         .mountPoints(List.of(MountPointsProperty.builder()
     *                 .containerPath("containerPath")
     *                 .readOnly(false)
     *                 .sourceVolume("sourceVolume")
     *                 .build()))
     *         .networkConfiguration(NetworkConfigurationProperty.builder()
     *                 .assignPublicIp("assignPublicIp")
     *                 .build())
     *         .privileged(false)
     *         .readonlyRootFilesystem(false)
     *         .repositoryCredentials(RepositoryCredentialsProperty.builder()
     *                 .credentialsParameter("credentialsParameter")
     *                 .build())
     *         .resourceRequirements(List.of(ResourceRequirementProperty.builder()
     *                 .type("type")
     *                 .value("value")
     *                 .build()))
     *         .runtimePlatform(RuntimePlatformProperty.builder()
     *                 .cpuArchitecture("cpuArchitecture")
     *                 .operatingSystemFamily("operatingSystemFamily")
     *                 .build())
     *         .secrets(List.of(SecretProperty.builder()
     *                 .name("name")
     *                 .valueFrom("valueFrom")
     *                 .build()))
     *         .ulimits(List.of(UlimitProperty.builder()
     *                 .hardLimit(123)
     *                 .name("name")
     *                 .softLimit(123)
     *                 .build()))
     *         .user("user")
     *         .vcpus(123)
     *         .volumes(List.of(VolumesProperty.builder()
     *                 .efsVolumeConfiguration(EfsVolumeConfigurationProperty.builder()
     *                         .fileSystemId("fileSystemId")
     *                         // the properties below are optional
     *                         .authorizationConfig(AuthorizationConfigProperty.builder()
     *                                 .accessPointId("accessPointId")
     *                                 .iam("iam")
     *                                 .build())
     *                         .rootDirectory("rootDirectory")
     *                         .transitEncryption("transitEncryption")
     *                         .transitEncryptionPort(123)
     *                         .build())
     *                 .host(VolumesHostProperty.builder()
     *                         .sourcePath("sourcePath")
     *                         .build())
     *                 .name("name")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.ContainerPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ContainerPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContainerPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Required.
         * <p>
         * The image used to start a container. This string is passed directly to the Docker daemon. Images in the Docker Hub registry are available by default. Other repositories are specified with <code>*repository-url* / *image* : *tag*</code> . It can be 255 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), underscores (_), colons (:), periods (.), forward slashes (/), and number signs (#). This parameter maps to <code>Image</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>IMAGE</code> parameter of <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
         * <p>
         * <blockquote>
         * <p>
         * Docker image architecture must match the processor architecture of the compute resources that they're scheduled on. For example, ARM-based Docker images can only run on ARM-based compute resources.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li>Images in Amazon ECR Public repositories use the full <code>registry/repository[:tag]</code> or <code>registry/repository[&#64;digest]</code> naming conventions. For example, <code>public.ecr.aws/ *registry_alias* / *my-web-app* : *latest*</code> .</li>
         * <li>Images in Amazon ECR repositories use the full registry and repository URI (for example, <code>123456789012.dkr.ecr.&lt;region-name&gt;.amazonaws.com/&lt;repository-name&gt;</code> ).</li>
         * <li>Images in official repositories on Docker Hub use a single name (for example, <code>ubuntu</code> or <code>mongo</code> ).</li>
         * <li>Images in other repositories on Docker Hub are qualified with an organization name (for example, <code>amazon/amazon-ecs-agent</code> ).</li>
         * <li>Images in other online repositories are qualified further by a domain name (for example, <code>quay.io/assemblyline/ubuntu</code> ).</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-image">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-image</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImage();

        /**
         * The command that's passed to the container.
         * <p>
         * This parameter maps to <code>Cmd</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>COMMAND</code> parameter to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd">https://docs.docker.com/engine/reference/builder/#cmd</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-command">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-command</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
            return null;
        }

        /**
         * The environment variables to pass to a container.
         * <p>
         * This parameter maps to <code>Env</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--env</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
         * <p>
         * <blockquote>
         * <p>
         * We don't recommend using plaintext environment variables for sensitive information, such as credential data. &gt; Environment variables cannot start with " <code>AWS_BATCH</code> ". This naming convention is reserved for variables that AWS Batch sets.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-environment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-environment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
            return null;
        }

        /**
         * The amount of ephemeral storage to allocate for the task.
         * <p>
         * This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-ephemeralstorage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-ephemeralstorage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEphemeralStorage() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume.
         * <p>
         * For jobs that run on Fargate resources, you must provide an execution role. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html">AWS Batch execution IAM role</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-executionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-executionrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExecutionRoleArn() {
            return null;
        }

        /**
         * The platform configuration for jobs that are running on Fargate resources.
         * <p>
         * Jobs that are running on Amazon EC2 resources must not specify this parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-fargateplatformconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-fargateplatformconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFargatePlatformConfiguration() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-instancetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role that the container can assume for AWS permissions.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM roles for tasks</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-jobrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-jobrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getJobRoleArn() {
            return null;
        }

        /**
         * Linux-specific modifications that are applied to the container, such as details for device mappings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-linuxparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-linuxparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLinuxParameters() {
            return null;
        }

        /**
         * The log configuration specification for the container.
         * <p>
         * This parameter maps to <code>LogConfig</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--log-driver</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . By default, containers use the same logging driver that the Docker daemon uses. However the container might use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information on the options for different supported log drivers, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the Docker documentation.
         * <p>
         * <blockquote>
         * <p>
         * AWS Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html">LogConfiguration</a> data type).
         * <p>
         * </blockquote>
         * <p>
         * This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code>
         * <p>
         * <blockquote>
         * <p>
         * The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before containers placed on that instance can use these log configuration options. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS container agent configuration</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-logconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-logconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLogConfiguration() {
            return null;
        }

        /**
         * This parameter is deprecated, use <code>resourceRequirements</code> to specify the memory requirements for the job definition.
         * <p>
         * It's not supported for jobs running on Fargate resources. For jobs that run on Amazon EC2 resources, it specifies the memory hard limit (in MiB) for a container. If your container attempts to exceed the specified number, it's terminated. You must specify at least 4 MiB of memory for a job using this parameter. The memory hard limit can be specified in several places. It must be specified for each node at least once.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-memory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-memory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMemory() {
            return null;
        }

        /**
         * The mount points for data volumes in your container.
         * <p>
         * This parameter maps to <code>Volumes</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--volume</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-mountpoints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-mountpoints</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMountPoints() {
            return null;
        }

        /**
         * The network configuration for jobs that are running on Fargate resources.
         * <p>
         * Jobs that are running on Amazon EC2 resources must not specify this parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-networkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-networkconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfiguration() {
            return null;
        }

        /**
         * When this parameter is true, the container is given elevated permissions on the host container instance (similar to the <code>root</code> user).
         * <p>
         * This parameter maps to <code>Privileged</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--privileged</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . The default value is false.
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided, or specified as false.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-privileged">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-privileged</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrivileged() {
            return null;
        }

        /**
         * When this parameter is true, the container is given read-only access to its root file system.
         * <p>
         * This parameter maps to <code>ReadonlyRootfs</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--read-only</code> option to <code>docker run</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-readonlyrootfilesystem">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-readonlyrootfilesystem</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadonlyRootFilesystem() {
            return null;
        }

        /**
         * The private repository authentication credentials to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-repositorycredentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-repositorycredentials</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRepositoryCredentials() {
            return null;
        }

        /**
         * The type and amount of resources to assign to a container.
         * <p>
         * The supported resources include <code>GPU</code> , <code>MEMORY</code> , and <code>VCPU</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-resourcerequirements">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-resourcerequirements</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceRequirements() {
            return null;
        }

        /**
         * An object that represents the compute environment architecture for AWS Batch jobs on Fargate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-runtimeplatform">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-runtimeplatform</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRuntimePlatform() {
            return null;
        }

        /**
         * The secrets for the container.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-secrets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-secrets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecrets() {
            return null;
        }

        /**
         * A list of <code>ulimits</code> to set in the container.
         * <p>
         * This parameter maps to <code>Ulimits</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--ulimit</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-ulimits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-ulimits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUlimits() {
            return null;
        }

        /**
         * The user name to use inside the container.
         * <p>
         * This parameter maps to <code>User</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--user</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-user">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-user</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUser() {
            return null;
        }

        /**
         * This parameter is deprecated, use <code>resourceRequirements</code> to specify the vCPU requirements for the job definition.
         * <p>
         * It's not supported for jobs running on Fargate resources. For jobs running on Amazon EC2 resources, it specifies the number of vCPUs reserved for the job.
         * <p>
         * Each vCPU is equivalent to 1,024 CPU shares. This parameter maps to <code>CpuShares</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--cpu-shares</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . The number of vCPUs must be specified but can be specified in several places. You must specify it at least once for each node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-vcpus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-vcpus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVcpus() {
            return null;
        }

        /**
         * A list of data volumes used in a job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-volumes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-volumes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVolumes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ContainerPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContainerPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContainerPropertiesProperty> {
            java.lang.String image;
            java.util.List<java.lang.String> command;
            java.lang.Object environment;
            java.lang.Object ephemeralStorage;
            java.lang.String executionRoleArn;
            java.lang.Object fargatePlatformConfiguration;
            java.lang.String instanceType;
            java.lang.String jobRoleArn;
            java.lang.Object linuxParameters;
            java.lang.Object logConfiguration;
            java.lang.Number memory;
            java.lang.Object mountPoints;
            java.lang.Object networkConfiguration;
            java.lang.Object privileged;
            java.lang.Object readonlyRootFilesystem;
            java.lang.Object repositoryCredentials;
            java.lang.Object resourceRequirements;
            java.lang.Object runtimePlatform;
            java.lang.Object secrets;
            java.lang.Object ulimits;
            java.lang.String user;
            java.lang.Number vcpus;
            java.lang.Object volumes;

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getImage}
             * @param image Required. This parameter is required.
             *              The image used to start a container. This string is passed directly to the Docker daemon. Images in the Docker Hub registry are available by default. Other repositories are specified with <code>*repository-url* / *image* : *tag*</code> . It can be 255 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), underscores (_), colons (:), periods (.), forward slashes (/), and number signs (#). This parameter maps to <code>Image</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>IMAGE</code> parameter of <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             *              <p>
             *              <blockquote>
             *              <p>
             *              Docker image architecture must match the processor architecture of the compute resources that they're scheduled on. For example, ARM-based Docker images can only run on ARM-based compute resources.
             *              <p>
             *              </blockquote>
             *              <p>
             *              <ul>
             *              <li>Images in Amazon ECR Public repositories use the full <code>registry/repository[:tag]</code> or <code>registry/repository[&#64;digest]</code> naming conventions. For example, <code>public.ecr.aws/ *registry_alias* / *my-web-app* : *latest*</code> .</li>
             *              <li>Images in Amazon ECR repositories use the full registry and repository URI (for example, <code>123456789012.dkr.ecr.&lt;region-name&gt;.amazonaws.com/&lt;repository-name&gt;</code> ).</li>
             *              <li>Images in official repositories on Docker Hub use a single name (for example, <code>ubuntu</code> or <code>mongo</code> ).</li>
             *              <li>Images in other repositories on Docker Hub are qualified with an organization name (for example, <code>amazon/amazon-ecs-agent</code> ).</li>
             *              <li>Images in other online repositories are qualified further by a domain name (for example, <code>quay.io/assemblyline/ubuntu</code> ).</li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder image(java.lang.String image) {
                this.image = image;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getCommand}
             * @param command The command that's passed to the container.
             *                This parameter maps to <code>Cmd</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>COMMAND</code> parameter to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd">https://docs.docker.com/engine/reference/builder/#cmd</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder command(java.util.List<java.lang.String> command) {
                this.command = command;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getEnvironment}
             * @param environment The environment variables to pass to a container.
             *                    This parameter maps to <code>Env</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--env</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             *                    <p>
             *                    <blockquote>
             *                    <p>
             *                    We don't recommend using plaintext environment variables for sensitive information, such as credential data. &gt; Environment variables cannot start with " <code>AWS_BATCH</code> ". This naming convention is reserved for variables that AWS Batch sets.
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(software.amazon.awscdk.IResolvable environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getEnvironment}
             * @param environment The environment variables to pass to a container.
             *                    This parameter maps to <code>Env</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--env</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             *                    <p>
             *                    <blockquote>
             *                    <p>
             *                    We don't recommend using plaintext environment variables for sensitive information, such as credential data. &gt; Environment variables cannot start with " <code>AWS_BATCH</code> ". This naming convention is reserved for variables that AWS Batch sets.
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(java.util.List<? extends java.lang.Object> environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getEphemeralStorage}
             * @param ephemeralStorage The amount of ephemeral storage to allocate for the task.
             *                         This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ephemeralStorage(software.amazon.awscdk.IResolvable ephemeralStorage) {
                this.ephemeralStorage = ephemeralStorage;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getEphemeralStorage}
             * @param ephemeralStorage The amount of ephemeral storage to allocate for the task.
             *                         This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ephemeralStorage(software.amazon.awscdk.services.batch.CfnJobDefinition.EphemeralStorageProperty ephemeralStorage) {
                this.ephemeralStorage = ephemeralStorage;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getExecutionRoleArn}
             * @param executionRoleArn The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume.
             *                         For jobs that run on Fargate resources, you must provide an execution role. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html">AWS Batch execution IAM role</a> in the <em>AWS Batch User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionRoleArn(java.lang.String executionRoleArn) {
                this.executionRoleArn = executionRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getFargatePlatformConfiguration}
             * @param fargatePlatformConfiguration The platform configuration for jobs that are running on Fargate resources.
             *                                     Jobs that are running on Amazon EC2 resources must not specify this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fargatePlatformConfiguration(software.amazon.awscdk.IResolvable fargatePlatformConfiguration) {
                this.fargatePlatformConfiguration = fargatePlatformConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getFargatePlatformConfiguration}
             * @param fargatePlatformConfiguration The platform configuration for jobs that are running on Fargate resources.
             *                                     Jobs that are running on Amazon EC2 resources must not specify this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fargatePlatformConfiguration(software.amazon.awscdk.services.batch.CfnJobDefinition.FargatePlatformConfigurationProperty fargatePlatformConfiguration) {
                this.fargatePlatformConfiguration = fargatePlatformConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getInstanceType}
             * @param instanceType the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getJobRoleArn}
             * @param jobRoleArn The Amazon Resource Name (ARN) of the IAM role that the container can assume for AWS permissions.
             *                   For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM roles for tasks</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jobRoleArn(java.lang.String jobRoleArn) {
                this.jobRoleArn = jobRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getLinuxParameters}
             * @param linuxParameters Linux-specific modifications that are applied to the container, such as details for device mappings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder linuxParameters(software.amazon.awscdk.IResolvable linuxParameters) {
                this.linuxParameters = linuxParameters;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getLinuxParameters}
             * @param linuxParameters Linux-specific modifications that are applied to the container, such as details for device mappings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder linuxParameters(software.amazon.awscdk.services.batch.CfnJobDefinition.LinuxParametersProperty linuxParameters) {
                this.linuxParameters = linuxParameters;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getLogConfiguration}
             * @param logConfiguration The log configuration specification for the container.
             *                         This parameter maps to <code>LogConfig</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--log-driver</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . By default, containers use the same logging driver that the Docker daemon uses. However the container might use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information on the options for different supported log drivers, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the Docker documentation.
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         AWS Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html">LogConfiguration</a> data type).
             *                         <p>
             *                         </blockquote>
             *                         <p>
             *                         This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code>
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before containers placed on that instance can use these log configuration options. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS container agent configuration</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logConfiguration(software.amazon.awscdk.IResolvable logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getLogConfiguration}
             * @param logConfiguration The log configuration specification for the container.
             *                         This parameter maps to <code>LogConfig</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--log-driver</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . By default, containers use the same logging driver that the Docker daemon uses. However the container might use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information on the options for different supported log drivers, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the Docker documentation.
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         AWS Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html">LogConfiguration</a> data type).
             *                         <p>
             *                         </blockquote>
             *                         <p>
             *                         This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code>
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before containers placed on that instance can use these log configuration options. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS container agent configuration</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logConfiguration(software.amazon.awscdk.services.batch.CfnJobDefinition.LogConfigurationProperty logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getMemory}
             * @param memory This parameter is deprecated, use <code>resourceRequirements</code> to specify the memory requirements for the job definition.
             *               It's not supported for jobs running on Fargate resources. For jobs that run on Amazon EC2 resources, it specifies the memory hard limit (in MiB) for a container. If your container attempts to exceed the specified number, it's terminated. You must specify at least 4 MiB of memory for a job using this parameter. The memory hard limit can be specified in several places. It must be specified for each node at least once.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memory(java.lang.Number memory) {
                this.memory = memory;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getMountPoints}
             * @param mountPoints The mount points for data volumes in your container.
             *                    This parameter maps to <code>Volumes</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--volume</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountPoints(software.amazon.awscdk.IResolvable mountPoints) {
                this.mountPoints = mountPoints;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getMountPoints}
             * @param mountPoints The mount points for data volumes in your container.
             *                    This parameter maps to <code>Volumes</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--volume</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountPoints(java.util.List<? extends java.lang.Object> mountPoints) {
                this.mountPoints = mountPoints;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getNetworkConfiguration}
             * @param networkConfiguration The network configuration for jobs that are running on Fargate resources.
             *                             Jobs that are running on Amazon EC2 resources must not specify this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkConfiguration(software.amazon.awscdk.IResolvable networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getNetworkConfiguration}
             * @param networkConfiguration The network configuration for jobs that are running on Fargate resources.
             *                             Jobs that are running on Amazon EC2 resources must not specify this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkConfiguration(software.amazon.awscdk.services.batch.CfnJobDefinition.NetworkConfigurationProperty networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getPrivileged}
             * @param privileged When this parameter is true, the container is given elevated permissions on the host container instance (similar to the <code>root</code> user).
             *                   This parameter maps to <code>Privileged</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--privileged</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . The default value is false.
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided, or specified as false.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privileged(java.lang.Boolean privileged) {
                this.privileged = privileged;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getPrivileged}
             * @param privileged When this parameter is true, the container is given elevated permissions on the host container instance (similar to the <code>root</code> user).
             *                   This parameter maps to <code>Privileged</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--privileged</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . The default value is false.
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided, or specified as false.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privileged(software.amazon.awscdk.IResolvable privileged) {
                this.privileged = privileged;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getReadonlyRootFilesystem}
             * @param readonlyRootFilesystem When this parameter is true, the container is given read-only access to its root file system.
             *                               This parameter maps to <code>ReadonlyRootfs</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--read-only</code> option to <code>docker run</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readonlyRootFilesystem(java.lang.Boolean readonlyRootFilesystem) {
                this.readonlyRootFilesystem = readonlyRootFilesystem;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getReadonlyRootFilesystem}
             * @param readonlyRootFilesystem When this parameter is true, the container is given read-only access to its root file system.
             *                               This parameter maps to <code>ReadonlyRootfs</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--read-only</code> option to <code>docker run</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readonlyRootFilesystem(software.amazon.awscdk.IResolvable readonlyRootFilesystem) {
                this.readonlyRootFilesystem = readonlyRootFilesystem;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getRepositoryCredentials}
             * @param repositoryCredentials The private repository authentication credentials to use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repositoryCredentials(software.amazon.awscdk.IResolvable repositoryCredentials) {
                this.repositoryCredentials = repositoryCredentials;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getRepositoryCredentials}
             * @param repositoryCredentials The private repository authentication credentials to use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repositoryCredentials(software.amazon.awscdk.services.batch.CfnJobDefinition.RepositoryCredentialsProperty repositoryCredentials) {
                this.repositoryCredentials = repositoryCredentials;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getResourceRequirements}
             * @param resourceRequirements The type and amount of resources to assign to a container.
             *                             The supported resources include <code>GPU</code> , <code>MEMORY</code> , and <code>VCPU</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceRequirements(software.amazon.awscdk.IResolvable resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getResourceRequirements}
             * @param resourceRequirements The type and amount of resources to assign to a container.
             *                             The supported resources include <code>GPU</code> , <code>MEMORY</code> , and <code>VCPU</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceRequirements(java.util.List<? extends java.lang.Object> resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getRuntimePlatform}
             * @param runtimePlatform An object that represents the compute environment architecture for AWS Batch jobs on Fargate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runtimePlatform(software.amazon.awscdk.IResolvable runtimePlatform) {
                this.runtimePlatform = runtimePlatform;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getRuntimePlatform}
             * @param runtimePlatform An object that represents the compute environment architecture for AWS Batch jobs on Fargate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runtimePlatform(software.amazon.awscdk.services.batch.CfnJobDefinition.RuntimePlatformProperty runtimePlatform) {
                this.runtimePlatform = runtimePlatform;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getSecrets}
             * @param secrets The secrets for the container.
             *                For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <em>AWS Batch User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secrets(software.amazon.awscdk.IResolvable secrets) {
                this.secrets = secrets;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getSecrets}
             * @param secrets The secrets for the container.
             *                For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <em>AWS Batch User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secrets(java.util.List<? extends java.lang.Object> secrets) {
                this.secrets = secrets;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getUlimits}
             * @param ulimits A list of <code>ulimits</code> to set in the container.
             *                This parameter maps to <code>Ulimits</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--ulimit</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             *                <p>
             *                <blockquote>
             *                <p>
             *                This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ulimits(software.amazon.awscdk.IResolvable ulimits) {
                this.ulimits = ulimits;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getUlimits}
             * @param ulimits A list of <code>ulimits</code> to set in the container.
             *                This parameter maps to <code>Ulimits</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--ulimit</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             *                <p>
             *                <blockquote>
             *                <p>
             *                This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ulimits(java.util.List<? extends java.lang.Object> ulimits) {
                this.ulimits = ulimits;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getUser}
             * @param user The user name to use inside the container.
             *             This parameter maps to <code>User</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--user</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder user(java.lang.String user) {
                this.user = user;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getVcpus}
             * @param vcpus This parameter is deprecated, use <code>resourceRequirements</code> to specify the vCPU requirements for the job definition.
             *              It's not supported for jobs running on Fargate resources. For jobs running on Amazon EC2 resources, it specifies the number of vCPUs reserved for the job.
             *              <p>
             *              Each vCPU is equivalent to 1,024 CPU shares. This parameter maps to <code>CpuShares</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--cpu-shares</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . The number of vCPUs must be specified but can be specified in several places. You must specify it at least once for each node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vcpus(java.lang.Number vcpus) {
                this.vcpus = vcpus;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getVolumes}
             * @param volumes A list of data volumes used in a job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumes(software.amazon.awscdk.IResolvable volumes) {
                this.volumes = volumes;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getVolumes}
             * @param volumes A list of data volumes used in a job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumes(java.util.List<? extends java.lang.Object> volumes) {
                this.volumes = volumes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContainerPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContainerPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContainerPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerPropertiesProperty {
            private final java.lang.String image;
            private final java.util.List<java.lang.String> command;
            private final java.lang.Object environment;
            private final java.lang.Object ephemeralStorage;
            private final java.lang.String executionRoleArn;
            private final java.lang.Object fargatePlatformConfiguration;
            private final java.lang.String instanceType;
            private final java.lang.String jobRoleArn;
            private final java.lang.Object linuxParameters;
            private final java.lang.Object logConfiguration;
            private final java.lang.Number memory;
            private final java.lang.Object mountPoints;
            private final java.lang.Object networkConfiguration;
            private final java.lang.Object privileged;
            private final java.lang.Object readonlyRootFilesystem;
            private final java.lang.Object repositoryCredentials;
            private final java.lang.Object resourceRequirements;
            private final java.lang.Object runtimePlatform;
            private final java.lang.Object secrets;
            private final java.lang.Object ulimits;
            private final java.lang.String user;
            private final java.lang.Number vcpus;
            private final java.lang.Object volumes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ephemeralStorage = software.amazon.jsii.Kernel.get(this, "ephemeralStorage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.executionRoleArn = software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fargatePlatformConfiguration = software.amazon.jsii.Kernel.get(this, "fargatePlatformConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.jobRoleArn = software.amazon.jsii.Kernel.get(this, "jobRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.linuxParameters = software.amazon.jsii.Kernel.get(this, "linuxParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logConfiguration = software.amazon.jsii.Kernel.get(this, "logConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.memory = software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.mountPoints = software.amazon.jsii.Kernel.get(this, "mountPoints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkConfiguration = software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.privileged = software.amazon.jsii.Kernel.get(this, "privileged", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.readonlyRootFilesystem = software.amazon.jsii.Kernel.get(this, "readonlyRootFilesystem", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.repositoryCredentials = software.amazon.jsii.Kernel.get(this, "repositoryCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceRequirements = software.amazon.jsii.Kernel.get(this, "resourceRequirements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.runtimePlatform = software.amazon.jsii.Kernel.get(this, "runtimePlatform", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secrets = software.amazon.jsii.Kernel.get(this, "secrets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ulimits = software.amazon.jsii.Kernel.get(this, "ulimits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vcpus = software.amazon.jsii.Kernel.get(this, "vcpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.image = java.util.Objects.requireNonNull(builder.image, "image is required");
                this.command = builder.command;
                this.environment = builder.environment;
                this.ephemeralStorage = builder.ephemeralStorage;
                this.executionRoleArn = builder.executionRoleArn;
                this.fargatePlatformConfiguration = builder.fargatePlatformConfiguration;
                this.instanceType = builder.instanceType;
                this.jobRoleArn = builder.jobRoleArn;
                this.linuxParameters = builder.linuxParameters;
                this.logConfiguration = builder.logConfiguration;
                this.memory = builder.memory;
                this.mountPoints = builder.mountPoints;
                this.networkConfiguration = builder.networkConfiguration;
                this.privileged = builder.privileged;
                this.readonlyRootFilesystem = builder.readonlyRootFilesystem;
                this.repositoryCredentials = builder.repositoryCredentials;
                this.resourceRequirements = builder.resourceRequirements;
                this.runtimePlatform = builder.runtimePlatform;
                this.secrets = builder.secrets;
                this.ulimits = builder.ulimits;
                this.user = builder.user;
                this.vcpus = builder.vcpus;
                this.volumes = builder.volumes;
            }

            @Override
            public final java.lang.String getImage() {
                return this.image;
            }

            @Override
            public final java.util.List<java.lang.String> getCommand() {
                return this.command;
            }

            @Override
            public final java.lang.Object getEnvironment() {
                return this.environment;
            }

            @Override
            public final java.lang.Object getEphemeralStorage() {
                return this.ephemeralStorage;
            }

            @Override
            public final java.lang.String getExecutionRoleArn() {
                return this.executionRoleArn;
            }

            @Override
            public final java.lang.Object getFargatePlatformConfiguration() {
                return this.fargatePlatformConfiguration;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.String getJobRoleArn() {
                return this.jobRoleArn;
            }

            @Override
            public final java.lang.Object getLinuxParameters() {
                return this.linuxParameters;
            }

            @Override
            public final java.lang.Object getLogConfiguration() {
                return this.logConfiguration;
            }

            @Override
            public final java.lang.Number getMemory() {
                return this.memory;
            }

            @Override
            public final java.lang.Object getMountPoints() {
                return this.mountPoints;
            }

            @Override
            public final java.lang.Object getNetworkConfiguration() {
                return this.networkConfiguration;
            }

            @Override
            public final java.lang.Object getPrivileged() {
                return this.privileged;
            }

            @Override
            public final java.lang.Object getReadonlyRootFilesystem() {
                return this.readonlyRootFilesystem;
            }

            @Override
            public final java.lang.Object getRepositoryCredentials() {
                return this.repositoryCredentials;
            }

            @Override
            public final java.lang.Object getResourceRequirements() {
                return this.resourceRequirements;
            }

            @Override
            public final java.lang.Object getRuntimePlatform() {
                return this.runtimePlatform;
            }

            @Override
            public final java.lang.Object getSecrets() {
                return this.secrets;
            }

            @Override
            public final java.lang.Object getUlimits() {
                return this.ulimits;
            }

            @Override
            public final java.lang.String getUser() {
                return this.user;
            }

            @Override
            public final java.lang.Number getVcpus() {
                return this.vcpus;
            }

            @Override
            public final java.lang.Object getVolumes() {
                return this.volumes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("image", om.valueToTree(this.getImage()));
                if (this.getCommand() != null) {
                    data.set("command", om.valueToTree(this.getCommand()));
                }
                if (this.getEnvironment() != null) {
                    data.set("environment", om.valueToTree(this.getEnvironment()));
                }
                if (this.getEphemeralStorage() != null) {
                    data.set("ephemeralStorage", om.valueToTree(this.getEphemeralStorage()));
                }
                if (this.getExecutionRoleArn() != null) {
                    data.set("executionRoleArn", om.valueToTree(this.getExecutionRoleArn()));
                }
                if (this.getFargatePlatformConfiguration() != null) {
                    data.set("fargatePlatformConfiguration", om.valueToTree(this.getFargatePlatformConfiguration()));
                }
                if (this.getInstanceType() != null) {
                    data.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getJobRoleArn() != null) {
                    data.set("jobRoleArn", om.valueToTree(this.getJobRoleArn()));
                }
                if (this.getLinuxParameters() != null) {
                    data.set("linuxParameters", om.valueToTree(this.getLinuxParameters()));
                }
                if (this.getLogConfiguration() != null) {
                    data.set("logConfiguration", om.valueToTree(this.getLogConfiguration()));
                }
                if (this.getMemory() != null) {
                    data.set("memory", om.valueToTree(this.getMemory()));
                }
                if (this.getMountPoints() != null) {
                    data.set("mountPoints", om.valueToTree(this.getMountPoints()));
                }
                if (this.getNetworkConfiguration() != null) {
                    data.set("networkConfiguration", om.valueToTree(this.getNetworkConfiguration()));
                }
                if (this.getPrivileged() != null) {
                    data.set("privileged", om.valueToTree(this.getPrivileged()));
                }
                if (this.getReadonlyRootFilesystem() != null) {
                    data.set("readonlyRootFilesystem", om.valueToTree(this.getReadonlyRootFilesystem()));
                }
                if (this.getRepositoryCredentials() != null) {
                    data.set("repositoryCredentials", om.valueToTree(this.getRepositoryCredentials()));
                }
                if (this.getResourceRequirements() != null) {
                    data.set("resourceRequirements", om.valueToTree(this.getResourceRequirements()));
                }
                if (this.getRuntimePlatform() != null) {
                    data.set("runtimePlatform", om.valueToTree(this.getRuntimePlatform()));
                }
                if (this.getSecrets() != null) {
                    data.set("secrets", om.valueToTree(this.getSecrets()));
                }
                if (this.getUlimits() != null) {
                    data.set("ulimits", om.valueToTree(this.getUlimits()));
                }
                if (this.getUser() != null) {
                    data.set("user", om.valueToTree(this.getUser()));
                }
                if (this.getVcpus() != null) {
                    data.set("vcpus", om.valueToTree(this.getVcpus()));
                }
                if (this.getVolumes() != null) {
                    data.set("volumes", om.valueToTree(this.getVolumes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.ContainerPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContainerPropertiesProperty.Jsii$Proxy that = (ContainerPropertiesProperty.Jsii$Proxy) o;

                if (!image.equals(that.image)) return false;
                if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
                if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
                if (this.ephemeralStorage != null ? !this.ephemeralStorage.equals(that.ephemeralStorage) : that.ephemeralStorage != null) return false;
                if (this.executionRoleArn != null ? !this.executionRoleArn.equals(that.executionRoleArn) : that.executionRoleArn != null) return false;
                if (this.fargatePlatformConfiguration != null ? !this.fargatePlatformConfiguration.equals(that.fargatePlatformConfiguration) : that.fargatePlatformConfiguration != null) return false;
                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                if (this.jobRoleArn != null ? !this.jobRoleArn.equals(that.jobRoleArn) : that.jobRoleArn != null) return false;
                if (this.linuxParameters != null ? !this.linuxParameters.equals(that.linuxParameters) : that.linuxParameters != null) return false;
                if (this.logConfiguration != null ? !this.logConfiguration.equals(that.logConfiguration) : that.logConfiguration != null) return false;
                if (this.memory != null ? !this.memory.equals(that.memory) : that.memory != null) return false;
                if (this.mountPoints != null ? !this.mountPoints.equals(that.mountPoints) : that.mountPoints != null) return false;
                if (this.networkConfiguration != null ? !this.networkConfiguration.equals(that.networkConfiguration) : that.networkConfiguration != null) return false;
                if (this.privileged != null ? !this.privileged.equals(that.privileged) : that.privileged != null) return false;
                if (this.readonlyRootFilesystem != null ? !this.readonlyRootFilesystem.equals(that.readonlyRootFilesystem) : that.readonlyRootFilesystem != null) return false;
                if (this.repositoryCredentials != null ? !this.repositoryCredentials.equals(that.repositoryCredentials) : that.repositoryCredentials != null) return false;
                if (this.resourceRequirements != null ? !this.resourceRequirements.equals(that.resourceRequirements) : that.resourceRequirements != null) return false;
                if (this.runtimePlatform != null ? !this.runtimePlatform.equals(that.runtimePlatform) : that.runtimePlatform != null) return false;
                if (this.secrets != null ? !this.secrets.equals(that.secrets) : that.secrets != null) return false;
                if (this.ulimits != null ? !this.ulimits.equals(that.ulimits) : that.ulimits != null) return false;
                if (this.user != null ? !this.user.equals(that.user) : that.user != null) return false;
                if (this.vcpus != null ? !this.vcpus.equals(that.vcpus) : that.vcpus != null) return false;
                return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.image.hashCode();
                result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
                result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
                result = 31 * result + (this.ephemeralStorage != null ? this.ephemeralStorage.hashCode() : 0);
                result = 31 * result + (this.executionRoleArn != null ? this.executionRoleArn.hashCode() : 0);
                result = 31 * result + (this.fargatePlatformConfiguration != null ? this.fargatePlatformConfiguration.hashCode() : 0);
                result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
                result = 31 * result + (this.jobRoleArn != null ? this.jobRoleArn.hashCode() : 0);
                result = 31 * result + (this.linuxParameters != null ? this.linuxParameters.hashCode() : 0);
                result = 31 * result + (this.logConfiguration != null ? this.logConfiguration.hashCode() : 0);
                result = 31 * result + (this.memory != null ? this.memory.hashCode() : 0);
                result = 31 * result + (this.mountPoints != null ? this.mountPoints.hashCode() : 0);
                result = 31 * result + (this.networkConfiguration != null ? this.networkConfiguration.hashCode() : 0);
                result = 31 * result + (this.privileged != null ? this.privileged.hashCode() : 0);
                result = 31 * result + (this.readonlyRootFilesystem != null ? this.readonlyRootFilesystem.hashCode() : 0);
                result = 31 * result + (this.repositoryCredentials != null ? this.repositoryCredentials.hashCode() : 0);
                result = 31 * result + (this.resourceRequirements != null ? this.resourceRequirements.hashCode() : 0);
                result = 31 * result + (this.runtimePlatform != null ? this.runtimePlatform.hashCode() : 0);
                result = 31 * result + (this.secrets != null ? this.secrets.hashCode() : 0);
                result = 31 * result + (this.ulimits != null ? this.ulimits.hashCode() : 0);
                result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
                result = 31 * result + (this.vcpus != null ? this.vcpus.hashCode() : 0);
                result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents a container instance host device.
     * <p>
     * <blockquote>
     * <p>
     * This object isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * DeviceProperty deviceProperty = DeviceProperty.builder()
     *         .containerPath("containerPath")
     *         .hostPath("hostPath")
     *         .permissions(List.of("permissions"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-device.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-device.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.DeviceProperty")
    @software.amazon.jsii.Jsii.Proxy(DeviceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeviceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The path inside the container that's used to expose the host device.
         * <p>
         * By default, the <code>hostPath</code> value is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-device.html#cfn-batch-jobdefinition-device-containerpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-device.html#cfn-batch-jobdefinition-device-containerpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContainerPath() {
            return null;
        }

        /**
         * The path for the device on the host container instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-device.html#cfn-batch-jobdefinition-device-hostpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-device.html#cfn-batch-jobdefinition-device-hostpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostPath() {
            return null;
        }

        /**
         * The explicit permissions to provide to the container for the device.
         * <p>
         * By default, the container has permissions for <code>read</code> , <code>write</code> , and <code>mknod</code> for the device.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-device.html#cfn-batch-jobdefinition-device-permissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-device.html#cfn-batch-jobdefinition-device-permissions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPermissions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeviceProperty> {
            java.lang.String containerPath;
            java.lang.String hostPath;
            java.util.List<java.lang.String> permissions;

            /**
             * Sets the value of {@link DeviceProperty#getContainerPath}
             * @param containerPath The path inside the container that's used to expose the host device.
             *                      By default, the <code>hostPath</code> value is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPath(java.lang.String containerPath) {
                this.containerPath = containerPath;
                return this;
            }

            /**
             * Sets the value of {@link DeviceProperty#getHostPath}
             * @param hostPath The path for the device on the host container instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostPath(java.lang.String hostPath) {
                this.hostPath = hostPath;
                return this;
            }

            /**
             * Sets the value of {@link DeviceProperty#getPermissions}
             * @param permissions The explicit permissions to provide to the container for the device.
             *                    By default, the container has permissions for <code>read</code> , <code>write</code> , and <code>mknod</code> for the device.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder permissions(java.util.List<java.lang.String> permissions) {
                this.permissions = permissions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeviceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeviceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeviceProperty {
            private final java.lang.String containerPath;
            private final java.lang.String hostPath;
            private final java.util.List<java.lang.String> permissions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerPath = software.amazon.jsii.Kernel.get(this, "containerPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostPath = software.amazon.jsii.Kernel.get(this, "hostPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.permissions = software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerPath = builder.containerPath;
                this.hostPath = builder.hostPath;
                this.permissions = builder.permissions;
            }

            @Override
            public final java.lang.String getContainerPath() {
                return this.containerPath;
            }

            @Override
            public final java.lang.String getHostPath() {
                return this.hostPath;
            }

            @Override
            public final java.util.List<java.lang.String> getPermissions() {
                return this.permissions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainerPath() != null) {
                    data.set("containerPath", om.valueToTree(this.getContainerPath()));
                }
                if (this.getHostPath() != null) {
                    data.set("hostPath", om.valueToTree(this.getHostPath()));
                }
                if (this.getPermissions() != null) {
                    data.set("permissions", om.valueToTree(this.getPermissions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.DeviceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeviceProperty.Jsii$Proxy that = (DeviceProperty.Jsii$Proxy) o;

                if (this.containerPath != null ? !this.containerPath.equals(that.containerPath) : that.containerPath != null) return false;
                if (this.hostPath != null ? !this.hostPath.equals(that.hostPath) : that.hostPath != null) return false;
                return this.permissions != null ? this.permissions.equals(that.permissions) : that.permissions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerPath != null ? this.containerPath.hashCode() : 0;
                result = 31 * result + (this.hostPath != null ? this.hostPath.hashCode() : 0);
                result = 31 * result + (this.permissions != null ? this.permissions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that contains the properties for the Amazon ECS resources of a job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * Object options;
     * EcsPropertiesProperty ecsPropertiesProperty = EcsPropertiesProperty.builder()
     *         .taskProperties(List.of(EcsTaskPropertiesProperty.builder()
     *                 .containers(List.of(TaskContainerPropertiesProperty.builder()
     *                         .image("image")
     *                         // the properties below are optional
     *                         .command(List.of("command"))
     *                         .dependsOn(List.of(TaskContainerDependencyProperty.builder()
     *                                 .condition("condition")
     *                                 .containerName("containerName")
     *                                 .build()))
     *                         .environment(List.of(EnvironmentProperty.builder()
     *                                 .name("name")
     *                                 .value("value")
     *                                 .build()))
     *                         .essential(false)
     *                         .linuxParameters(LinuxParametersProperty.builder()
     *                                 .devices(List.of(DeviceProperty.builder()
     *                                         .containerPath("containerPath")
     *                                         .hostPath("hostPath")
     *                                         .permissions(List.of("permissions"))
     *                                         .build()))
     *                                 .initProcessEnabled(false)
     *                                 .maxSwap(123)
     *                                 .sharedMemorySize(123)
     *                                 .swappiness(123)
     *                                 .tmpfs(List.of(TmpfsProperty.builder()
     *                                         .containerPath("containerPath")
     *                                         .size(123)
     *                                         // the properties below are optional
     *                                         .mountOptions(List.of("mountOptions"))
     *                                         .build()))
     *                                 .build())
     *                         .logConfiguration(LogConfigurationProperty.builder()
     *                                 .logDriver("logDriver")
     *                                 // the properties below are optional
     *                                 .options(options)
     *                                 .secretOptions(List.of(SecretProperty.builder()
     *                                         .name("name")
     *                                         .valueFrom("valueFrom")
     *                                         .build()))
     *                                 .build())
     *                         .mountPoints(List.of(MountPointProperty.builder()
     *                                 .containerPath("containerPath")
     *                                 .readOnly(false)
     *                                 .sourceVolume("sourceVolume")
     *                                 .build()))
     *                         .name("name")
     *                         .privileged(false)
     *                         .readonlyRootFilesystem(false)
     *                         .repositoryCredentials(RepositoryCredentialsProperty.builder()
     *                                 .credentialsParameter("credentialsParameter")
     *                                 .build())
     *                         .resourceRequirements(List.of(ResourceRequirementProperty.builder()
     *                                 .type("type")
     *                                 .value("value")
     *                                 .build()))
     *                         .secrets(List.of(SecretProperty.builder()
     *                                 .name("name")
     *                                 .valueFrom("valueFrom")
     *                                 .build()))
     *                         .ulimits(List.of(UlimitProperty.builder()
     *                                 .hardLimit(123)
     *                                 .name("name")
     *                                 .softLimit(123)
     *                                 .build()))
     *                         .user("user")
     *                         .build()))
     *                 .ephemeralStorage(EphemeralStorageProperty.builder()
     *                         .sizeInGiB(123)
     *                         .build())
     *                 .executionRoleArn("executionRoleArn")
     *                 .ipcMode("ipcMode")
     *                 .networkConfiguration(NetworkConfigurationProperty.builder()
     *                         .assignPublicIp("assignPublicIp")
     *                         .build())
     *                 .pidMode("pidMode")
     *                 .platformVersion("platformVersion")
     *                 .runtimePlatform(RuntimePlatformProperty.builder()
     *                         .cpuArchitecture("cpuArchitecture")
     *                         .operatingSystemFamily("operatingSystemFamily")
     *                         .build())
     *                 .taskRoleArn("taskRoleArn")
     *                 .volumes(List.of(VolumesProperty.builder()
     *                         .efsVolumeConfiguration(EfsVolumeConfigurationProperty.builder()
     *                                 .fileSystemId("fileSystemId")
     *                                 // the properties below are optional
     *                                 .authorizationConfig(AuthorizationConfigProperty.builder()
     *                                         .accessPointId("accessPointId")
     *                                         .iam("iam")
     *                                         .build())
     *                                 .rootDirectory("rootDirectory")
     *                                 .transitEncryption("transitEncryption")
     *                                 .transitEncryptionPort(123)
     *                                 .build())
     *                         .host(VolumesHostProperty.builder()
     *                                 .sourcePath("sourcePath")
     *                                 .build())
     *                         .name("name")
     *                         .build()))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecsproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecsproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.EcsPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(EcsPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EcsPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that contains the properties for the Amazon ECS task definition of a job.
         * <p>
         * <blockquote>
         * <p>
         * This object is currently limited to one task element. However, the task element can run up to 10 containers.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecsproperties.html#cfn-batch-jobdefinition-ecsproperties-taskproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecsproperties.html#cfn-batch-jobdefinition-ecsproperties-taskproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTaskProperties();

        /**
         * @return a {@link Builder} of {@link EcsPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EcsPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EcsPropertiesProperty> {
            java.lang.Object taskProperties;

            /**
             * Sets the value of {@link EcsPropertiesProperty#getTaskProperties}
             * @param taskProperties An object that contains the properties for the Amazon ECS task definition of a job. This parameter is required.
             *                       <blockquote>
             *                       <p>
             *                       This object is currently limited to one task element. However, the task element can run up to 10 containers.
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskProperties(software.amazon.awscdk.IResolvable taskProperties) {
                this.taskProperties = taskProperties;
                return this;
            }

            /**
             * Sets the value of {@link EcsPropertiesProperty#getTaskProperties}
             * @param taskProperties An object that contains the properties for the Amazon ECS task definition of a job. This parameter is required.
             *                       <blockquote>
             *                       <p>
             *                       This object is currently limited to one task element. However, the task element can run up to 10 containers.
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskProperties(java.util.List<? extends java.lang.Object> taskProperties) {
                this.taskProperties = taskProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EcsPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EcsPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EcsPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsPropertiesProperty {
            private final java.lang.Object taskProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.taskProperties = software.amazon.jsii.Kernel.get(this, "taskProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.taskProperties = java.util.Objects.requireNonNull(builder.taskProperties, "taskProperties is required");
            }

            @Override
            public final java.lang.Object getTaskProperties() {
                return this.taskProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("taskProperties", om.valueToTree(this.getTaskProperties()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.EcsPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EcsPropertiesProperty.Jsii$Proxy that = (EcsPropertiesProperty.Jsii$Proxy) o;

                return this.taskProperties.equals(that.taskProperties);
            }

            @Override
            public final int hashCode() {
                int result = this.taskProperties.hashCode();
                return result;
            }
        }
    }
    /**
     * The properties for a task definition that describes the container and volume definitions of an Amazon ECS task.
     * <p>
     * You can specify which Docker images to use, the required resources, and other configurations related to launching the task definition through an Amazon ECS service or task.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * Object options;
     * EcsTaskPropertiesProperty ecsTaskPropertiesProperty = EcsTaskPropertiesProperty.builder()
     *         .containers(List.of(TaskContainerPropertiesProperty.builder()
     *                 .image("image")
     *                 // the properties below are optional
     *                 .command(List.of("command"))
     *                 .dependsOn(List.of(TaskContainerDependencyProperty.builder()
     *                         .condition("condition")
     *                         .containerName("containerName")
     *                         .build()))
     *                 .environment(List.of(EnvironmentProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .essential(false)
     *                 .linuxParameters(LinuxParametersProperty.builder()
     *                         .devices(List.of(DeviceProperty.builder()
     *                                 .containerPath("containerPath")
     *                                 .hostPath("hostPath")
     *                                 .permissions(List.of("permissions"))
     *                                 .build()))
     *                         .initProcessEnabled(false)
     *                         .maxSwap(123)
     *                         .sharedMemorySize(123)
     *                         .swappiness(123)
     *                         .tmpfs(List.of(TmpfsProperty.builder()
     *                                 .containerPath("containerPath")
     *                                 .size(123)
     *                                 // the properties below are optional
     *                                 .mountOptions(List.of("mountOptions"))
     *                                 .build()))
     *                         .build())
     *                 .logConfiguration(LogConfigurationProperty.builder()
     *                         .logDriver("logDriver")
     *                         // the properties below are optional
     *                         .options(options)
     *                         .secretOptions(List.of(SecretProperty.builder()
     *                                 .name("name")
     *                                 .valueFrom("valueFrom")
     *                                 .build()))
     *                         .build())
     *                 .mountPoints(List.of(MountPointProperty.builder()
     *                         .containerPath("containerPath")
     *                         .readOnly(false)
     *                         .sourceVolume("sourceVolume")
     *                         .build()))
     *                 .name("name")
     *                 .privileged(false)
     *                 .readonlyRootFilesystem(false)
     *                 .repositoryCredentials(RepositoryCredentialsProperty.builder()
     *                         .credentialsParameter("credentialsParameter")
     *                         .build())
     *                 .resourceRequirements(List.of(ResourceRequirementProperty.builder()
     *                         .type("type")
     *                         .value("value")
     *                         .build()))
     *                 .secrets(List.of(SecretProperty.builder()
     *                         .name("name")
     *                         .valueFrom("valueFrom")
     *                         .build()))
     *                 .ulimits(List.of(UlimitProperty.builder()
     *                         .hardLimit(123)
     *                         .name("name")
     *                         .softLimit(123)
     *                         .build()))
     *                 .user("user")
     *                 .build()))
     *         .ephemeralStorage(EphemeralStorageProperty.builder()
     *                 .sizeInGiB(123)
     *                 .build())
     *         .executionRoleArn("executionRoleArn")
     *         .ipcMode("ipcMode")
     *         .networkConfiguration(NetworkConfigurationProperty.builder()
     *                 .assignPublicIp("assignPublicIp")
     *                 .build())
     *         .pidMode("pidMode")
     *         .platformVersion("platformVersion")
     *         .runtimePlatform(RuntimePlatformProperty.builder()
     *                 .cpuArchitecture("cpuArchitecture")
     *                 .operatingSystemFamily("operatingSystemFamily")
     *                 .build())
     *         .taskRoleArn("taskRoleArn")
     *         .volumes(List.of(VolumesProperty.builder()
     *                 .efsVolumeConfiguration(EfsVolumeConfigurationProperty.builder()
     *                         .fileSystemId("fileSystemId")
     *                         // the properties below are optional
     *                         .authorizationConfig(AuthorizationConfigProperty.builder()
     *                                 .accessPointId("accessPointId")
     *                                 .iam("iam")
     *                                 .build())
     *                         .rootDirectory("rootDirectory")
     *                         .transitEncryption("transitEncryption")
     *                         .transitEncryptionPort(123)
     *                         .build())
     *                 .host(VolumesHostProperty.builder()
     *                         .sourcePath("sourcePath")
     *                         .build())
     *                 .name("name")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecstaskproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecstaskproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.EcsTaskPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(EcsTaskPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EcsTaskPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This object is a list of containers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecstaskproperties.html#cfn-batch-jobdefinition-ecstaskproperties-containers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecstaskproperties.html#cfn-batch-jobdefinition-ecstaskproperties-containers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContainers() {
            return null;
        }

        /**
         * The amount of ephemeral storage to allocate for the task.
         * <p>
         * This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecstaskproperties.html#cfn-batch-jobdefinition-ecstaskproperties-ephemeralstorage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecstaskproperties.html#cfn-batch-jobdefinition-ecstaskproperties-ephemeralstorage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEphemeralStorage() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume.
         * <p>
         * For jobs that run on Fargate resources, you must provide an execution role. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html">AWS Batch execution IAM role</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecstaskproperties.html#cfn-batch-jobdefinition-ecstaskproperties-executionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecstaskproperties.html#cfn-batch-jobdefinition-ecstaskproperties-executionrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExecutionRoleArn() {
            return null;
        }

        /**
         * The IPC resource namespace to use for the containers in the task.
         * <p>
         * The valid values are <code>host</code> , <code>task</code> , or <code>none</code> .
         * <p>
         * If <code>host</code> is specified, all containers within the tasks that specified the <code>host</code> IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance.
         * <p>
         * If <code>task</code> is specified, all containers within the specified <code>task</code> share the same IPC resources.
         * <p>
         * If <code>none</code> is specified, the IPC resources within the containers of a task are private, and are not shared with other containers in a task or on the container instance.
         * <p>
         * If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#ipc-settings---ipc">IPC settings</a> in the Docker run reference.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecstaskproperties.html#cfn-batch-jobdefinition-ecstaskproperties-ipcmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecstaskproperties.html#cfn-batch-jobdefinition-ecstaskproperties-ipcmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIpcMode() {
            return null;
        }

        /**
         * The network configuration for jobs that are running on Fargate resources.
         * <p>
         * Jobs that are running on Amazon EC2 resources must not specify this parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecstaskproperties.html#cfn-batch-jobdefinition-ecstaskproperties-networkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecstaskproperties.html#cfn-batch-jobdefinition-ecstaskproperties-networkconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfiguration() {
            return null;
        }

        /**
         * The process namespace to use for the containers in the task.
         * <p>
         * The valid values are <code>host</code> or <code>task</code> . For example, monitoring sidecars might need <code>pidMode</code> to access information about other containers running in the same task.
         * <p>
         * If <code>host</code> is specified, all containers within the tasks that specified the <code>host</code> PID mode on the same container instance share the process namespace with the host Amazon EC2 instance.
         * <p>
         * If <code>task</code> is specified, all containers within the specified task share the same process namespace.
         * <p>
         * If no value is specified, the default is a private namespace for each container. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#pid-settings---pid">PID settings</a> in the Docker run reference.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecstaskproperties.html#cfn-batch-jobdefinition-ecstaskproperties-pidmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecstaskproperties.html#cfn-batch-jobdefinition-ecstaskproperties-pidmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPidMode() {
            return null;
        }

        /**
         * The Fargate platform version where the jobs are running.
         * <p>
         * A platform version is specified only for jobs that are running on Fargate resources. If one isn't specified, the <code>LATEST</code> platform version is used by default. This uses a recent, approved version of the Fargate platform for compute resources. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate platform versions</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecstaskproperties.html#cfn-batch-jobdefinition-ecstaskproperties-platformversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecstaskproperties.html#cfn-batch-jobdefinition-ecstaskproperties-platformversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPlatformVersion() {
            return null;
        }

        /**
         * An object that represents the compute environment architecture for AWS Batch jobs on Fargate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecstaskproperties.html#cfn-batch-jobdefinition-ecstaskproperties-runtimeplatform">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecstaskproperties.html#cfn-batch-jobdefinition-ecstaskproperties-runtimeplatform</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRuntimePlatform() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) that's associated with the Amazon ECS task.
         * <p>
         * <blockquote>
         * <p>
         * This is object is comparable to <a href="https://docs.aws.amazon.com/batch/latest/APIReference/API_ContainerProperties.html">ContainerProperties:jobRoleArn</a> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecstaskproperties.html#cfn-batch-jobdefinition-ecstaskproperties-taskrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecstaskproperties.html#cfn-batch-jobdefinition-ecstaskproperties-taskrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTaskRoleArn() {
            return null;
        }

        /**
         * A list of volumes that are associated with the job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecstaskproperties.html#cfn-batch-jobdefinition-ecstaskproperties-volumes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ecstaskproperties.html#cfn-batch-jobdefinition-ecstaskproperties-volumes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVolumes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EcsTaskPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EcsTaskPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EcsTaskPropertiesProperty> {
            java.lang.Object containers;
            java.lang.Object ephemeralStorage;
            java.lang.String executionRoleArn;
            java.lang.String ipcMode;
            java.lang.Object networkConfiguration;
            java.lang.String pidMode;
            java.lang.String platformVersion;
            java.lang.Object runtimePlatform;
            java.lang.String taskRoleArn;
            java.lang.Object volumes;

            /**
             * Sets the value of {@link EcsTaskPropertiesProperty#getContainers}
             * @param containers This object is a list of containers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containers(software.amazon.awscdk.IResolvable containers) {
                this.containers = containers;
                return this;
            }

            /**
             * Sets the value of {@link EcsTaskPropertiesProperty#getContainers}
             * @param containers This object is a list of containers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containers(java.util.List<? extends java.lang.Object> containers) {
                this.containers = containers;
                return this;
            }

            /**
             * Sets the value of {@link EcsTaskPropertiesProperty#getEphemeralStorage}
             * @param ephemeralStorage The amount of ephemeral storage to allocate for the task.
             *                         This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ephemeralStorage(software.amazon.awscdk.IResolvable ephemeralStorage) {
                this.ephemeralStorage = ephemeralStorage;
                return this;
            }

            /**
             * Sets the value of {@link EcsTaskPropertiesProperty#getEphemeralStorage}
             * @param ephemeralStorage The amount of ephemeral storage to allocate for the task.
             *                         This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ephemeralStorage(software.amazon.awscdk.services.batch.CfnJobDefinition.EphemeralStorageProperty ephemeralStorage) {
                this.ephemeralStorage = ephemeralStorage;
                return this;
            }

            /**
             * Sets the value of {@link EcsTaskPropertiesProperty#getExecutionRoleArn}
             * @param executionRoleArn The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume.
             *                         For jobs that run on Fargate resources, you must provide an execution role. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html">AWS Batch execution IAM role</a> in the <em>AWS Batch User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionRoleArn(java.lang.String executionRoleArn) {
                this.executionRoleArn = executionRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link EcsTaskPropertiesProperty#getIpcMode}
             * @param ipcMode The IPC resource namespace to use for the containers in the task.
             *                The valid values are <code>host</code> , <code>task</code> , or <code>none</code> .
             *                <p>
             *                If <code>host</code> is specified, all containers within the tasks that specified the <code>host</code> IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance.
             *                <p>
             *                If <code>task</code> is specified, all containers within the specified <code>task</code> share the same IPC resources.
             *                <p>
             *                If <code>none</code> is specified, the IPC resources within the containers of a task are private, and are not shared with other containers in a task or on the container instance.
             *                <p>
             *                If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#ipc-settings---ipc">IPC settings</a> in the Docker run reference.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipcMode(java.lang.String ipcMode) {
                this.ipcMode = ipcMode;
                return this;
            }

            /**
             * Sets the value of {@link EcsTaskPropertiesProperty#getNetworkConfiguration}
             * @param networkConfiguration The network configuration for jobs that are running on Fargate resources.
             *                             Jobs that are running on Amazon EC2 resources must not specify this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkConfiguration(software.amazon.awscdk.IResolvable networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link EcsTaskPropertiesProperty#getNetworkConfiguration}
             * @param networkConfiguration The network configuration for jobs that are running on Fargate resources.
             *                             Jobs that are running on Amazon EC2 resources must not specify this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkConfiguration(software.amazon.awscdk.services.batch.CfnJobDefinition.NetworkConfigurationProperty networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link EcsTaskPropertiesProperty#getPidMode}
             * @param pidMode The process namespace to use for the containers in the task.
             *                The valid values are <code>host</code> or <code>task</code> . For example, monitoring sidecars might need <code>pidMode</code> to access information about other containers running in the same task.
             *                <p>
             *                If <code>host</code> is specified, all containers within the tasks that specified the <code>host</code> PID mode on the same container instance share the process namespace with the host Amazon EC2 instance.
             *                <p>
             *                If <code>task</code> is specified, all containers within the specified task share the same process namespace.
             *                <p>
             *                If no value is specified, the default is a private namespace for each container. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#pid-settings---pid">PID settings</a> in the Docker run reference.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pidMode(java.lang.String pidMode) {
                this.pidMode = pidMode;
                return this;
            }

            /**
             * Sets the value of {@link EcsTaskPropertiesProperty#getPlatformVersion}
             * @param platformVersion The Fargate platform version where the jobs are running.
             *                        A platform version is specified only for jobs that are running on Fargate resources. If one isn't specified, the <code>LATEST</code> platform version is used by default. This uses a recent, approved version of the Fargate platform for compute resources. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate platform versions</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder platformVersion(java.lang.String platformVersion) {
                this.platformVersion = platformVersion;
                return this;
            }

            /**
             * Sets the value of {@link EcsTaskPropertiesProperty#getRuntimePlatform}
             * @param runtimePlatform An object that represents the compute environment architecture for AWS Batch jobs on Fargate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runtimePlatform(software.amazon.awscdk.IResolvable runtimePlatform) {
                this.runtimePlatform = runtimePlatform;
                return this;
            }

            /**
             * Sets the value of {@link EcsTaskPropertiesProperty#getRuntimePlatform}
             * @param runtimePlatform An object that represents the compute environment architecture for AWS Batch jobs on Fargate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runtimePlatform(software.amazon.awscdk.services.batch.CfnJobDefinition.RuntimePlatformProperty runtimePlatform) {
                this.runtimePlatform = runtimePlatform;
                return this;
            }

            /**
             * Sets the value of {@link EcsTaskPropertiesProperty#getTaskRoleArn}
             * @param taskRoleArn The Amazon Resource Name (ARN) that's associated with the Amazon ECS task.
             *                    <blockquote>
             *                    <p>
             *                    This is object is comparable to <a href="https://docs.aws.amazon.com/batch/latest/APIReference/API_ContainerProperties.html">ContainerProperties:jobRoleArn</a> .
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskRoleArn(java.lang.String taskRoleArn) {
                this.taskRoleArn = taskRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link EcsTaskPropertiesProperty#getVolumes}
             * @param volumes A list of volumes that are associated with the job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumes(software.amazon.awscdk.IResolvable volumes) {
                this.volumes = volumes;
                return this;
            }

            /**
             * Sets the value of {@link EcsTaskPropertiesProperty#getVolumes}
             * @param volumes A list of volumes that are associated with the job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumes(java.util.List<? extends java.lang.Object> volumes) {
                this.volumes = volumes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EcsTaskPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EcsTaskPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EcsTaskPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsTaskPropertiesProperty {
            private final java.lang.Object containers;
            private final java.lang.Object ephemeralStorage;
            private final java.lang.String executionRoleArn;
            private final java.lang.String ipcMode;
            private final java.lang.Object networkConfiguration;
            private final java.lang.String pidMode;
            private final java.lang.String platformVersion;
            private final java.lang.Object runtimePlatform;
            private final java.lang.String taskRoleArn;
            private final java.lang.Object volumes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containers = software.amazon.jsii.Kernel.get(this, "containers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ephemeralStorage = software.amazon.jsii.Kernel.get(this, "ephemeralStorage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.executionRoleArn = software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ipcMode = software.amazon.jsii.Kernel.get(this, "ipcMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.networkConfiguration = software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.pidMode = software.amazon.jsii.Kernel.get(this, "pidMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.platformVersion = software.amazon.jsii.Kernel.get(this, "platformVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.runtimePlatform = software.amazon.jsii.Kernel.get(this, "runtimePlatform", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.taskRoleArn = software.amazon.jsii.Kernel.get(this, "taskRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containers = builder.containers;
                this.ephemeralStorage = builder.ephemeralStorage;
                this.executionRoleArn = builder.executionRoleArn;
                this.ipcMode = builder.ipcMode;
                this.networkConfiguration = builder.networkConfiguration;
                this.pidMode = builder.pidMode;
                this.platformVersion = builder.platformVersion;
                this.runtimePlatform = builder.runtimePlatform;
                this.taskRoleArn = builder.taskRoleArn;
                this.volumes = builder.volumes;
            }

            @Override
            public final java.lang.Object getContainers() {
                return this.containers;
            }

            @Override
            public final java.lang.Object getEphemeralStorage() {
                return this.ephemeralStorage;
            }

            @Override
            public final java.lang.String getExecutionRoleArn() {
                return this.executionRoleArn;
            }

            @Override
            public final java.lang.String getIpcMode() {
                return this.ipcMode;
            }

            @Override
            public final java.lang.Object getNetworkConfiguration() {
                return this.networkConfiguration;
            }

            @Override
            public final java.lang.String getPidMode() {
                return this.pidMode;
            }

            @Override
            public final java.lang.String getPlatformVersion() {
                return this.platformVersion;
            }

            @Override
            public final java.lang.Object getRuntimePlatform() {
                return this.runtimePlatform;
            }

            @Override
            public final java.lang.String getTaskRoleArn() {
                return this.taskRoleArn;
            }

            @Override
            public final java.lang.Object getVolumes() {
                return this.volumes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainers() != null) {
                    data.set("containers", om.valueToTree(this.getContainers()));
                }
                if (this.getEphemeralStorage() != null) {
                    data.set("ephemeralStorage", om.valueToTree(this.getEphemeralStorage()));
                }
                if (this.getExecutionRoleArn() != null) {
                    data.set("executionRoleArn", om.valueToTree(this.getExecutionRoleArn()));
                }
                if (this.getIpcMode() != null) {
                    data.set("ipcMode", om.valueToTree(this.getIpcMode()));
                }
                if (this.getNetworkConfiguration() != null) {
                    data.set("networkConfiguration", om.valueToTree(this.getNetworkConfiguration()));
                }
                if (this.getPidMode() != null) {
                    data.set("pidMode", om.valueToTree(this.getPidMode()));
                }
                if (this.getPlatformVersion() != null) {
                    data.set("platformVersion", om.valueToTree(this.getPlatformVersion()));
                }
                if (this.getRuntimePlatform() != null) {
                    data.set("runtimePlatform", om.valueToTree(this.getRuntimePlatform()));
                }
                if (this.getTaskRoleArn() != null) {
                    data.set("taskRoleArn", om.valueToTree(this.getTaskRoleArn()));
                }
                if (this.getVolumes() != null) {
                    data.set("volumes", om.valueToTree(this.getVolumes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.EcsTaskPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EcsTaskPropertiesProperty.Jsii$Proxy that = (EcsTaskPropertiesProperty.Jsii$Proxy) o;

                if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) return false;
                if (this.ephemeralStorage != null ? !this.ephemeralStorage.equals(that.ephemeralStorage) : that.ephemeralStorage != null) return false;
                if (this.executionRoleArn != null ? !this.executionRoleArn.equals(that.executionRoleArn) : that.executionRoleArn != null) return false;
                if (this.ipcMode != null ? !this.ipcMode.equals(that.ipcMode) : that.ipcMode != null) return false;
                if (this.networkConfiguration != null ? !this.networkConfiguration.equals(that.networkConfiguration) : that.networkConfiguration != null) return false;
                if (this.pidMode != null ? !this.pidMode.equals(that.pidMode) : that.pidMode != null) return false;
                if (this.platformVersion != null ? !this.platformVersion.equals(that.platformVersion) : that.platformVersion != null) return false;
                if (this.runtimePlatform != null ? !this.runtimePlatform.equals(that.runtimePlatform) : that.runtimePlatform != null) return false;
                if (this.taskRoleArn != null ? !this.taskRoleArn.equals(that.taskRoleArn) : that.taskRoleArn != null) return false;
                return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containers != null ? this.containers.hashCode() : 0;
                result = 31 * result + (this.ephemeralStorage != null ? this.ephemeralStorage.hashCode() : 0);
                result = 31 * result + (this.executionRoleArn != null ? this.executionRoleArn.hashCode() : 0);
                result = 31 * result + (this.ipcMode != null ? this.ipcMode.hashCode() : 0);
                result = 31 * result + (this.networkConfiguration != null ? this.networkConfiguration.hashCode() : 0);
                result = 31 * result + (this.pidMode != null ? this.pidMode.hashCode() : 0);
                result = 31 * result + (this.platformVersion != null ? this.platformVersion.hashCode() : 0);
                result = 31 * result + (this.runtimePlatform != null ? this.runtimePlatform.hashCode() : 0);
                result = 31 * result + (this.taskRoleArn != null ? this.taskRoleArn.hashCode() : 0);
                result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * EfsVolumeConfigurationProperty efsVolumeConfigurationProperty = EfsVolumeConfigurationProperty.builder()
     *         .fileSystemId("fileSystemId")
     *         // the properties below are optional
     *         .authorizationConfig(AuthorizationConfigProperty.builder()
     *                 .accessPointId("accessPointId")
     *                 .iam("iam")
     *                 .build())
     *         .rootDirectory("rootDirectory")
     *         .transitEncryption("transitEncryption")
     *         .transitEncryptionPort(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-efsvolumeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-efsvolumeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.EfsVolumeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EfsVolumeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EfsVolumeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-efsvolumeconfiguration.html#cfn-batch-jobdefinition-efsvolumeconfiguration-filesystemid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-efsvolumeconfiguration.html#cfn-batch-jobdefinition-efsvolumeconfiguration-filesystemid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFileSystemId();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-efsvolumeconfiguration.html#cfn-batch-jobdefinition-efsvolumeconfiguration-authorizationconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-efsvolumeconfiguration.html#cfn-batch-jobdefinition-efsvolumeconfiguration-authorizationconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthorizationConfig() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-efsvolumeconfiguration.html#cfn-batch-jobdefinition-efsvolumeconfiguration-rootdirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-efsvolumeconfiguration.html#cfn-batch-jobdefinition-efsvolumeconfiguration-rootdirectory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRootDirectory() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-efsvolumeconfiguration.html#cfn-batch-jobdefinition-efsvolumeconfiguration-transitencryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-efsvolumeconfiguration.html#cfn-batch-jobdefinition-efsvolumeconfiguration-transitencryption</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTransitEncryption() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-efsvolumeconfiguration.html#cfn-batch-jobdefinition-efsvolumeconfiguration-transitencryptionport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-efsvolumeconfiguration.html#cfn-batch-jobdefinition-efsvolumeconfiguration-transitencryptionport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTransitEncryptionPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EfsVolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EfsVolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EfsVolumeConfigurationProperty> {
            java.lang.String fileSystemId;
            java.lang.Object authorizationConfig;
            java.lang.String rootDirectory;
            java.lang.String transitEncryption;
            java.lang.Number transitEncryptionPort;

            /**
             * Sets the value of {@link EfsVolumeConfigurationProperty#getFileSystemId}
             * @param fileSystemId the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileSystemId(java.lang.String fileSystemId) {
                this.fileSystemId = fileSystemId;
                return this;
            }

            /**
             * Sets the value of {@link EfsVolumeConfigurationProperty#getAuthorizationConfig}
             * @param authorizationConfig the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationConfig(software.amazon.awscdk.IResolvable authorizationConfig) {
                this.authorizationConfig = authorizationConfig;
                return this;
            }

            /**
             * Sets the value of {@link EfsVolumeConfigurationProperty#getAuthorizationConfig}
             * @param authorizationConfig the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationConfig(software.amazon.awscdk.services.batch.CfnJobDefinition.AuthorizationConfigProperty authorizationConfig) {
                this.authorizationConfig = authorizationConfig;
                return this;
            }

            /**
             * Sets the value of {@link EfsVolumeConfigurationProperty#getRootDirectory}
             * @param rootDirectory the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rootDirectory(java.lang.String rootDirectory) {
                this.rootDirectory = rootDirectory;
                return this;
            }

            /**
             * Sets the value of {@link EfsVolumeConfigurationProperty#getTransitEncryption}
             * @param transitEncryption the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitEncryption(java.lang.String transitEncryption) {
                this.transitEncryption = transitEncryption;
                return this;
            }

            /**
             * Sets the value of {@link EfsVolumeConfigurationProperty#getTransitEncryptionPort}
             * @param transitEncryptionPort the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitEncryptionPort(java.lang.Number transitEncryptionPort) {
                this.transitEncryptionPort = transitEncryptionPort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EfsVolumeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EfsVolumeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EfsVolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EfsVolumeConfigurationProperty {
            private final java.lang.String fileSystemId;
            private final java.lang.Object authorizationConfig;
            private final java.lang.String rootDirectory;
            private final java.lang.String transitEncryption;
            private final java.lang.Number transitEncryptionPort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fileSystemId = software.amazon.jsii.Kernel.get(this, "fileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authorizationConfig = software.amazon.jsii.Kernel.get(this, "authorizationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rootDirectory = software.amazon.jsii.Kernel.get(this, "rootDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.transitEncryption = software.amazon.jsii.Kernel.get(this, "transitEncryption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.transitEncryptionPort = software.amazon.jsii.Kernel.get(this, "transitEncryptionPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fileSystemId = java.util.Objects.requireNonNull(builder.fileSystemId, "fileSystemId is required");
                this.authorizationConfig = builder.authorizationConfig;
                this.rootDirectory = builder.rootDirectory;
                this.transitEncryption = builder.transitEncryption;
                this.transitEncryptionPort = builder.transitEncryptionPort;
            }

            @Override
            public final java.lang.String getFileSystemId() {
                return this.fileSystemId;
            }

            @Override
            public final java.lang.Object getAuthorizationConfig() {
                return this.authorizationConfig;
            }

            @Override
            public final java.lang.String getRootDirectory() {
                return this.rootDirectory;
            }

            @Override
            public final java.lang.String getTransitEncryption() {
                return this.transitEncryption;
            }

            @Override
            public final java.lang.Number getTransitEncryptionPort() {
                return this.transitEncryptionPort;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fileSystemId", om.valueToTree(this.getFileSystemId()));
                if (this.getAuthorizationConfig() != null) {
                    data.set("authorizationConfig", om.valueToTree(this.getAuthorizationConfig()));
                }
                if (this.getRootDirectory() != null) {
                    data.set("rootDirectory", om.valueToTree(this.getRootDirectory()));
                }
                if (this.getTransitEncryption() != null) {
                    data.set("transitEncryption", om.valueToTree(this.getTransitEncryption()));
                }
                if (this.getTransitEncryptionPort() != null) {
                    data.set("transitEncryptionPort", om.valueToTree(this.getTransitEncryptionPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.EfsVolumeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EfsVolumeConfigurationProperty.Jsii$Proxy that = (EfsVolumeConfigurationProperty.Jsii$Proxy) o;

                if (!fileSystemId.equals(that.fileSystemId)) return false;
                if (this.authorizationConfig != null ? !this.authorizationConfig.equals(that.authorizationConfig) : that.authorizationConfig != null) return false;
                if (this.rootDirectory != null ? !this.rootDirectory.equals(that.rootDirectory) : that.rootDirectory != null) return false;
                if (this.transitEncryption != null ? !this.transitEncryption.equals(that.transitEncryption) : that.transitEncryption != null) return false;
                return this.transitEncryptionPort != null ? this.transitEncryptionPort.equals(that.transitEncryptionPort) : that.transitEncryptionPort == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fileSystemId.hashCode();
                result = 31 * result + (this.authorizationConfig != null ? this.authorizationConfig.hashCode() : 0);
                result = 31 * result + (this.rootDirectory != null ? this.rootDirectory.hashCode() : 0);
                result = 31 * result + (this.transitEncryption != null ? this.transitEncryption.hashCode() : 0);
                result = 31 * result + (this.transitEncryptionPort != null ? this.transitEncryptionPort.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An environment variable.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * EksContainerEnvironmentVariableProperty eksContainerEnvironmentVariableProperty = EksContainerEnvironmentVariableProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainerenvironmentvariable.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainerenvironmentvariable.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.EksContainerEnvironmentVariableProperty")
    @software.amazon.jsii.Jsii.Proxy(EksContainerEnvironmentVariableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EksContainerEnvironmentVariableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the environment variable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainerenvironmentvariable.html#cfn-batch-jobdefinition-ekscontainerenvironmentvariable-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainerenvironmentvariable.html#cfn-batch-jobdefinition-ekscontainerenvironmentvariable-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The value of the environment variable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainerenvironmentvariable.html#cfn-batch-jobdefinition-ekscontainerenvironmentvariable-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainerenvironmentvariable.html#cfn-batch-jobdefinition-ekscontainerenvironmentvariable-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EksContainerEnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EksContainerEnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EksContainerEnvironmentVariableProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link EksContainerEnvironmentVariableProperty#getName}
             * @param name The name of the environment variable. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerEnvironmentVariableProperty#getValue}
             * @param value The value of the environment variable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EksContainerEnvironmentVariableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EksContainerEnvironmentVariableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EksContainerEnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EksContainerEnvironmentVariableProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.EksContainerEnvironmentVariableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EksContainerEnvironmentVariableProperty.Jsii$Proxy that = (EksContainerEnvironmentVariableProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * EKS container properties are used in job definitions for Amazon EKS based job definitions to describe the properties for a container node in the pod that's launched as part of a job.
     * <p>
     * This can't be specified for Amazon ECS based job definitions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * Object limits;
     * Object requests;
     * EksContainerProperty eksContainerProperty = EksContainerProperty.builder()
     *         .image("image")
     *         // the properties below are optional
     *         .args(List.of("args"))
     *         .command(List.of("command"))
     *         .env(List.of(EksContainerEnvironmentVariableProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .value("value")
     *                 .build()))
     *         .imagePullPolicy("imagePullPolicy")
     *         .name("name")
     *         .resources(ResourcesProperty.builder()
     *                 .limits(limits)
     *                 .requests(requests)
     *                 .build())
     *         .securityContext(SecurityContextProperty.builder()
     *                 .allowPrivilegeEscalation(false)
     *                 .privileged(false)
     *                 .readOnlyRootFilesystem(false)
     *                 .runAsGroup(123)
     *                 .runAsNonRoot(false)
     *                 .runAsUser(123)
     *                 .build())
     *         .volumeMounts(List.of(EksContainerVolumeMountProperty.builder()
     *                 .mountPath("mountPath")
     *                 .name("name")
     *                 .readOnly(false)
     *                 .subPath("subPath")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainer.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.EksContainerProperty")
    @software.amazon.jsii.Jsii.Proxy(EksContainerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EksContainerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Docker image used to start the container.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainer.html#cfn-batch-jobdefinition-ekscontainer-image">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainer.html#cfn-batch-jobdefinition-ekscontainer-image</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImage();

        /**
         * An array of arguments to the entrypoint.
         * <p>
         * If this isn't specified, the <code>CMD</code> of the container image is used. This corresponds to the <code>args</code> member in the <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint">Entrypoint</a> portion of the <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/">Pod</a> in Kubernetes. Environment variable references are expanded using the container's environment.
         * <p>
         * If the referenced environment variable doesn't exist, the reference in the command isn't changed. For example, if the reference is to " <code>$(NAME1)</code> " and the <code>NAME1</code> environment variable doesn't exist, the command string will remain " <code>$(NAME1)</code> ." <code>$$</code> is replaced with <code>$</code> , and the resulting string isn't expanded. For example, <code>$$(VAR_NAME)</code> is passed as <code>$(VAR_NAME)</code> whether or not the <code>VAR_NAME</code> environment variable exists. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd">Dockerfile reference: CMD</a> and <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/">Define a command and arguments for a pod</a> in the <em>Kubernetes documentation</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainer.html#cfn-batch-jobdefinition-ekscontainer-args">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainer.html#cfn-batch-jobdefinition-ekscontainer-args</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArgs() {
            return null;
        }

        /**
         * The entrypoint for the container.
         * <p>
         * This isn't run within a shell. If this isn't specified, the <code>ENTRYPOINT</code> of the container image is used. Environment variable references are expanded using the container's environment.
         * <p>
         * If the referenced environment variable doesn't exist, the reference in the command isn't changed. For example, if the reference is to " <code>$(NAME1)</code> " and the <code>NAME1</code> environment variable doesn't exist, the command string will remain " <code>$(NAME1)</code> ." <code>$$</code> is replaced with <code>$</code> and the resulting string isn't expanded. For example, <code>$$(VAR_NAME)</code> will be passed as <code>$(VAR_NAME)</code> whether or not the <code>VAR_NAME</code> environment variable exists. The entrypoint can't be updated. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#entrypoint">ENTRYPOINT</a> in the <em>Dockerfile reference</em> and <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/">Define a command and arguments for a container</a> and <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint">Entrypoint</a> in the <em>Kubernetes documentation</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainer.html#cfn-batch-jobdefinition-ekscontainer-command">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainer.html#cfn-batch-jobdefinition-ekscontainer-command</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
            return null;
        }

        /**
         * The environment variables to pass to a container.
         * <p>
         * <blockquote>
         * <p>
         * Environment variables cannot start with " <code>AWS_BATCH</code> ". This naming convention is reserved for variables that AWS Batch sets.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainer.html#cfn-batch-jobdefinition-ekscontainer-env">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainer.html#cfn-batch-jobdefinition-ekscontainer-env</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnv() {
            return null;
        }

        /**
         * The image pull policy for the container.
         * <p>
         * Supported values are <code>Always</code> , <code>IfNotPresent</code> , and <code>Never</code> . This parameter defaults to <code>IfNotPresent</code> . However, if the <code>:latest</code> tag is specified, it defaults to <code>Always</code> . For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/containers/images/#updating-images">Updating images</a> in the <em>Kubernetes documentation</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainer.html#cfn-batch-jobdefinition-ekscontainer-imagepullpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainer.html#cfn-batch-jobdefinition-ekscontainer-imagepullpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImagePullPolicy() {
            return null;
        }

        /**
         * The name of the container.
         * <p>
         * If the name isn't specified, the default name " <code>Default</code> " is used. Each container in a pod must have a unique name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainer.html#cfn-batch-jobdefinition-ekscontainer-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainer.html#cfn-batch-jobdefinition-ekscontainer-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The type and amount of resources to assign to a container.
         * <p>
         * The supported resources include <code>memory</code> , <code>cpu</code> , and <code>nvidia.com/gpu</code> . For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">Resource management for pods and containers</a> in the <em>Kubernetes documentation</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainer.html#cfn-batch-jobdefinition-ekscontainer-resources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainer.html#cfn-batch-jobdefinition-ekscontainer-resources</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResources() {
            return null;
        }

        /**
         * The security context for a job.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/configure-pod-container/security-context/">Configure a security context for a pod or container</a> in the <em>Kubernetes documentation</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainer.html#cfn-batch-jobdefinition-ekscontainer-securitycontext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainer.html#cfn-batch-jobdefinition-ekscontainer-securitycontext</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecurityContext() {
            return null;
        }

        /**
         * The volume mounts for the container.
         * <p>
         * AWS Batch supports <code>emptyDir</code> , <code>hostPath</code> , and <code>secret</code> volume types. For more information about volumes and volume mounts in Kubernetes, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/">Volumes</a> in the <em>Kubernetes documentation</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainer.html#cfn-batch-jobdefinition-ekscontainer-volumemounts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainer.html#cfn-batch-jobdefinition-ekscontainer-volumemounts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVolumeMounts() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EksContainerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EksContainerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EksContainerProperty> {
            java.lang.String image;
            java.util.List<java.lang.String> args;
            java.util.List<java.lang.String> command;
            java.lang.Object env;
            java.lang.String imagePullPolicy;
            java.lang.String name;
            java.lang.Object resources;
            java.lang.Object securityContext;
            java.lang.Object volumeMounts;

            /**
             * Sets the value of {@link EksContainerProperty#getImage}
             * @param image The Docker image used to start the container. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder image(java.lang.String image) {
                this.image = image;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerProperty#getArgs}
             * @param args An array of arguments to the entrypoint.
             *             If this isn't specified, the <code>CMD</code> of the container image is used. This corresponds to the <code>args</code> member in the <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint">Entrypoint</a> portion of the <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/">Pod</a> in Kubernetes. Environment variable references are expanded using the container's environment.
             *             <p>
             *             If the referenced environment variable doesn't exist, the reference in the command isn't changed. For example, if the reference is to " <code>$(NAME1)</code> " and the <code>NAME1</code> environment variable doesn't exist, the command string will remain " <code>$(NAME1)</code> ." <code>$$</code> is replaced with <code>$</code> , and the resulting string isn't expanded. For example, <code>$$(VAR_NAME)</code> is passed as <code>$(VAR_NAME)</code> whether or not the <code>VAR_NAME</code> environment variable exists. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd">Dockerfile reference: CMD</a> and <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/">Define a command and arguments for a pod</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder args(java.util.List<java.lang.String> args) {
                this.args = args;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerProperty#getCommand}
             * @param command The entrypoint for the container.
             *                This isn't run within a shell. If this isn't specified, the <code>ENTRYPOINT</code> of the container image is used. Environment variable references are expanded using the container's environment.
             *                <p>
             *                If the referenced environment variable doesn't exist, the reference in the command isn't changed. For example, if the reference is to " <code>$(NAME1)</code> " and the <code>NAME1</code> environment variable doesn't exist, the command string will remain " <code>$(NAME1)</code> ." <code>$$</code> is replaced with <code>$</code> and the resulting string isn't expanded. For example, <code>$$(VAR_NAME)</code> will be passed as <code>$(VAR_NAME)</code> whether or not the <code>VAR_NAME</code> environment variable exists. The entrypoint can't be updated. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#entrypoint">ENTRYPOINT</a> in the <em>Dockerfile reference</em> and <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/">Define a command and arguments for a container</a> and <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint">Entrypoint</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder command(java.util.List<java.lang.String> command) {
                this.command = command;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerProperty#getEnv}
             * @param env The environment variables to pass to a container.
             *            <blockquote>
             *            <p>
             *            Environment variables cannot start with " <code>AWS_BATCH</code> ". This naming convention is reserved for variables that AWS Batch sets.
             *            <p>
             *            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder env(software.amazon.awscdk.IResolvable env) {
                this.env = env;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerProperty#getEnv}
             * @param env The environment variables to pass to a container.
             *            <blockquote>
             *            <p>
             *            Environment variables cannot start with " <code>AWS_BATCH</code> ". This naming convention is reserved for variables that AWS Batch sets.
             *            <p>
             *            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder env(java.util.List<? extends java.lang.Object> env) {
                this.env = env;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerProperty#getImagePullPolicy}
             * @param imagePullPolicy The image pull policy for the container.
             *                        Supported values are <code>Always</code> , <code>IfNotPresent</code> , and <code>Never</code> . This parameter defaults to <code>IfNotPresent</code> . However, if the <code>:latest</code> tag is specified, it defaults to <code>Always</code> . For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/containers/images/#updating-images">Updating images</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imagePullPolicy(java.lang.String imagePullPolicy) {
                this.imagePullPolicy = imagePullPolicy;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerProperty#getName}
             * @param name The name of the container.
             *             If the name isn't specified, the default name " <code>Default</code> " is used. Each container in a pod must have a unique name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerProperty#getResources}
             * @param resources The type and amount of resources to assign to a container.
             *                  The supported resources include <code>memory</code> , <code>cpu</code> , and <code>nvidia.com/gpu</code> . For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">Resource management for pods and containers</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resources(software.amazon.awscdk.IResolvable resources) {
                this.resources = resources;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerProperty#getResources}
             * @param resources The type and amount of resources to assign to a container.
             *                  The supported resources include <code>memory</code> , <code>cpu</code> , and <code>nvidia.com/gpu</code> . For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">Resource management for pods and containers</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resources(software.amazon.awscdk.services.batch.CfnJobDefinition.ResourcesProperty resources) {
                this.resources = resources;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerProperty#getSecurityContext}
             * @param securityContext The security context for a job.
             *                        For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/configure-pod-container/security-context/">Configure a security context for a pod or container</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityContext(software.amazon.awscdk.IResolvable securityContext) {
                this.securityContext = securityContext;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerProperty#getSecurityContext}
             * @param securityContext The security context for a job.
             *                        For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/configure-pod-container/security-context/">Configure a security context for a pod or container</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityContext(software.amazon.awscdk.services.batch.CfnJobDefinition.SecurityContextProperty securityContext) {
                this.securityContext = securityContext;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerProperty#getVolumeMounts}
             * @param volumeMounts The volume mounts for the container.
             *                     AWS Batch supports <code>emptyDir</code> , <code>hostPath</code> , and <code>secret</code> volume types. For more information about volumes and volume mounts in Kubernetes, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/">Volumes</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeMounts(software.amazon.awscdk.IResolvable volumeMounts) {
                this.volumeMounts = volumeMounts;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerProperty#getVolumeMounts}
             * @param volumeMounts The volume mounts for the container.
             *                     AWS Batch supports <code>emptyDir</code> , <code>hostPath</code> , and <code>secret</code> volume types. For more information about volumes and volume mounts in Kubernetes, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/">Volumes</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeMounts(java.util.List<? extends java.lang.Object> volumeMounts) {
                this.volumeMounts = volumeMounts;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EksContainerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EksContainerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EksContainerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EksContainerProperty {
            private final java.lang.String image;
            private final java.util.List<java.lang.String> args;
            private final java.util.List<java.lang.String> command;
            private final java.lang.Object env;
            private final java.lang.String imagePullPolicy;
            private final java.lang.String name;
            private final java.lang.Object resources;
            private final java.lang.Object securityContext;
            private final java.lang.Object volumeMounts;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.args = software.amazon.jsii.Kernel.get(this, "args", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.env = software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.imagePullPolicy = software.amazon.jsii.Kernel.get(this, "imagePullPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resources = software.amazon.jsii.Kernel.get(this, "resources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.securityContext = software.amazon.jsii.Kernel.get(this, "securityContext", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.volumeMounts = software.amazon.jsii.Kernel.get(this, "volumeMounts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.image = java.util.Objects.requireNonNull(builder.image, "image is required");
                this.args = builder.args;
                this.command = builder.command;
                this.env = builder.env;
                this.imagePullPolicy = builder.imagePullPolicy;
                this.name = builder.name;
                this.resources = builder.resources;
                this.securityContext = builder.securityContext;
                this.volumeMounts = builder.volumeMounts;
            }

            @Override
            public final java.lang.String getImage() {
                return this.image;
            }

            @Override
            public final java.util.List<java.lang.String> getArgs() {
                return this.args;
            }

            @Override
            public final java.util.List<java.lang.String> getCommand() {
                return this.command;
            }

            @Override
            public final java.lang.Object getEnv() {
                return this.env;
            }

            @Override
            public final java.lang.String getImagePullPolicy() {
                return this.imagePullPolicy;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getResources() {
                return this.resources;
            }

            @Override
            public final java.lang.Object getSecurityContext() {
                return this.securityContext;
            }

            @Override
            public final java.lang.Object getVolumeMounts() {
                return this.volumeMounts;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("image", om.valueToTree(this.getImage()));
                if (this.getArgs() != null) {
                    data.set("args", om.valueToTree(this.getArgs()));
                }
                if (this.getCommand() != null) {
                    data.set("command", om.valueToTree(this.getCommand()));
                }
                if (this.getEnv() != null) {
                    data.set("env", om.valueToTree(this.getEnv()));
                }
                if (this.getImagePullPolicy() != null) {
                    data.set("imagePullPolicy", om.valueToTree(this.getImagePullPolicy()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getResources() != null) {
                    data.set("resources", om.valueToTree(this.getResources()));
                }
                if (this.getSecurityContext() != null) {
                    data.set("securityContext", om.valueToTree(this.getSecurityContext()));
                }
                if (this.getVolumeMounts() != null) {
                    data.set("volumeMounts", om.valueToTree(this.getVolumeMounts()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.EksContainerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EksContainerProperty.Jsii$Proxy that = (EksContainerProperty.Jsii$Proxy) o;

                if (!image.equals(that.image)) return false;
                if (this.args != null ? !this.args.equals(that.args) : that.args != null) return false;
                if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
                if (this.env != null ? !this.env.equals(that.env) : that.env != null) return false;
                if (this.imagePullPolicy != null ? !this.imagePullPolicy.equals(that.imagePullPolicy) : that.imagePullPolicy != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) return false;
                if (this.securityContext != null ? !this.securityContext.equals(that.securityContext) : that.securityContext != null) return false;
                return this.volumeMounts != null ? this.volumeMounts.equals(that.volumeMounts) : that.volumeMounts == null;
            }

            @Override
            public final int hashCode() {
                int result = this.image.hashCode();
                result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
                result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
                result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
                result = 31 * result + (this.imagePullPolicy != null ? this.imagePullPolicy.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.resources != null ? this.resources.hashCode() : 0);
                result = 31 * result + (this.securityContext != null ? this.securityContext.hashCode() : 0);
                result = 31 * result + (this.volumeMounts != null ? this.volumeMounts.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The volume mounts for a container for an Amazon EKS job.
     * <p>
     * For more information about volumes and volume mounts in Kubernetes, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/">Volumes</a> in the <em>Kubernetes documentation</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * EksContainerVolumeMountProperty eksContainerVolumeMountProperty = EksContainerVolumeMountProperty.builder()
     *         .mountPath("mountPath")
     *         .name("name")
     *         .readOnly(false)
     *         .subPath("subPath")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainervolumemount.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainervolumemount.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.EksContainerVolumeMountProperty")
    @software.amazon.jsii.Jsii.Proxy(EksContainerVolumeMountProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EksContainerVolumeMountProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The path on the container where the volume is mounted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainervolumemount.html#cfn-batch-jobdefinition-ekscontainervolumemount-mountpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainervolumemount.html#cfn-batch-jobdefinition-ekscontainervolumemount-mountpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMountPath() {
            return null;
        }

        /**
         * The name the volume mount.
         * <p>
         * This must match the name of one of the volumes in the pod.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainervolumemount.html#cfn-batch-jobdefinition-ekscontainervolumemount-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainervolumemount.html#cfn-batch-jobdefinition-ekscontainervolumemount-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * If this value is <code>true</code> , the container has read-only access to the volume.
         * <p>
         * Otherwise, the container can write to the volume. The default value is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainervolumemount.html#cfn-batch-jobdefinition-ekscontainervolumemount-readonly">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainervolumemount.html#cfn-batch-jobdefinition-ekscontainervolumemount-readonly</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadOnly() {
            return null;
        }

        /**
         * A sub-path inside the referenced volume instead of its root.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainervolumemount.html#cfn-batch-jobdefinition-ekscontainervolumemount-subpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekscontainervolumemount.html#cfn-batch-jobdefinition-ekscontainervolumemount-subpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EksContainerVolumeMountProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EksContainerVolumeMountProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EksContainerVolumeMountProperty> {
            java.lang.String mountPath;
            java.lang.String name;
            java.lang.Object readOnly;
            java.lang.String subPath;

            /**
             * Sets the value of {@link EksContainerVolumeMountProperty#getMountPath}
             * @param mountPath The path on the container where the volume is mounted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountPath(java.lang.String mountPath) {
                this.mountPath = mountPath;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerVolumeMountProperty#getName}
             * @param name The name the volume mount.
             *             This must match the name of one of the volumes in the pod.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerVolumeMountProperty#getReadOnly}
             * @param readOnly If this value is <code>true</code> , the container has read-only access to the volume.
             *                 Otherwise, the container can write to the volume. The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(java.lang.Boolean readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerVolumeMountProperty#getReadOnly}
             * @param readOnly If this value is <code>true</code> , the container has read-only access to the volume.
             *                 Otherwise, the container can write to the volume. The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(software.amazon.awscdk.IResolvable readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerVolumeMountProperty#getSubPath}
             * @param subPath A sub-path inside the referenced volume instead of its root.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subPath(java.lang.String subPath) {
                this.subPath = subPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EksContainerVolumeMountProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EksContainerVolumeMountProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EksContainerVolumeMountProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EksContainerVolumeMountProperty {
            private final java.lang.String mountPath;
            private final java.lang.String name;
            private final java.lang.Object readOnly;
            private final java.lang.String subPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mountPath = software.amazon.jsii.Kernel.get(this, "mountPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.readOnly = software.amazon.jsii.Kernel.get(this, "readOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.subPath = software.amazon.jsii.Kernel.get(this, "subPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mountPath = builder.mountPath;
                this.name = builder.name;
                this.readOnly = builder.readOnly;
                this.subPath = builder.subPath;
            }

            @Override
            public final java.lang.String getMountPath() {
                return this.mountPath;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getReadOnly() {
                return this.readOnly;
            }

            @Override
            public final java.lang.String getSubPath() {
                return this.subPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMountPath() != null) {
                    data.set("mountPath", om.valueToTree(this.getMountPath()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getReadOnly() != null) {
                    data.set("readOnly", om.valueToTree(this.getReadOnly()));
                }
                if (this.getSubPath() != null) {
                    data.set("subPath", om.valueToTree(this.getSubPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.EksContainerVolumeMountProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EksContainerVolumeMountProperty.Jsii$Proxy that = (EksContainerVolumeMountProperty.Jsii$Proxy) o;

                if (this.mountPath != null ? !this.mountPath.equals(that.mountPath) : that.mountPath != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) return false;
                return this.subPath != null ? this.subPath.equals(that.subPath) : that.subPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.mountPath != null ? this.mountPath.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.readOnly != null ? this.readOnly.hashCode() : 0);
                result = 31 * result + (this.subPath != null ? this.subPath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A <code>persistentVolumeClaim</code> volume is used to mount a <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/persistent-volumes/">PersistentVolume</a> into a Pod. PersistentVolumeClaims are a way for users to "claim" durable storage without knowing the details of the particular cloud environment. See the information about <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/persistent-volumes/">PersistentVolumes</a> in the <em>Kubernetes documentation</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * EksPersistentVolumeClaimProperty eksPersistentVolumeClaimProperty = EksPersistentVolumeClaimProperty.builder()
     *         .claimName("claimName")
     *         // the properties below are optional
     *         .readOnly(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekspersistentvolumeclaim.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekspersistentvolumeclaim.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.EksPersistentVolumeClaimProperty")
    @software.amazon.jsii.Jsii.Proxy(EksPersistentVolumeClaimProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EksPersistentVolumeClaimProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the <code>persistentVolumeClaim</code> bounded to a <code>persistentVolume</code> .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/persistent-volumes/#persistentvolumeclaims">Persistent Volume Claims</a> in the <em>Kubernetes documentation</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekspersistentvolumeclaim.html#cfn-batch-jobdefinition-ekspersistentvolumeclaim-claimname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekspersistentvolumeclaim.html#cfn-batch-jobdefinition-ekspersistentvolumeclaim-claimname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClaimName();

        /**
         * An optional boolean value indicating if the mount is read only.
         * <p>
         * Default is false. For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#read-only-mounts">Read Only Mounts</a> in the <em>Kubernetes documentation</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekspersistentvolumeclaim.html#cfn-batch-jobdefinition-ekspersistentvolumeclaim-readonly">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekspersistentvolumeclaim.html#cfn-batch-jobdefinition-ekspersistentvolumeclaim-readonly</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadOnly() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EksPersistentVolumeClaimProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EksPersistentVolumeClaimProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EksPersistentVolumeClaimProperty> {
            java.lang.String claimName;
            java.lang.Object readOnly;

            /**
             * Sets the value of {@link EksPersistentVolumeClaimProperty#getClaimName}
             * @param claimName The name of the <code>persistentVolumeClaim</code> bounded to a <code>persistentVolume</code> . This parameter is required.
             *                  For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/persistent-volumes/#persistentvolumeclaims">Persistent Volume Claims</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder claimName(java.lang.String claimName) {
                this.claimName = claimName;
                return this;
            }

            /**
             * Sets the value of {@link EksPersistentVolumeClaimProperty#getReadOnly}
             * @param readOnly An optional boolean value indicating if the mount is read only.
             *                 Default is false. For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#read-only-mounts">Read Only Mounts</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(java.lang.Boolean readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Sets the value of {@link EksPersistentVolumeClaimProperty#getReadOnly}
             * @param readOnly An optional boolean value indicating if the mount is read only.
             *                 Default is false. For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#read-only-mounts">Read Only Mounts</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(software.amazon.awscdk.IResolvable readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EksPersistentVolumeClaimProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EksPersistentVolumeClaimProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EksPersistentVolumeClaimProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EksPersistentVolumeClaimProperty {
            private final java.lang.String claimName;
            private final java.lang.Object readOnly;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.claimName = software.amazon.jsii.Kernel.get(this, "claimName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.readOnly = software.amazon.jsii.Kernel.get(this, "readOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.claimName = java.util.Objects.requireNonNull(builder.claimName, "claimName is required");
                this.readOnly = builder.readOnly;
            }

            @Override
            public final java.lang.String getClaimName() {
                return this.claimName;
            }

            @Override
            public final java.lang.Object getReadOnly() {
                return this.readOnly;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("claimName", om.valueToTree(this.getClaimName()));
                if (this.getReadOnly() != null) {
                    data.set("readOnly", om.valueToTree(this.getReadOnly()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.EksPersistentVolumeClaimProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EksPersistentVolumeClaimProperty.Jsii$Proxy that = (EksPersistentVolumeClaimProperty.Jsii$Proxy) o;

                if (!claimName.equals(that.claimName)) return false;
                return this.readOnly != null ? this.readOnly.equals(that.readOnly) : that.readOnly == null;
            }

            @Override
            public final int hashCode() {
                int result = this.claimName.hashCode();
                result = 31 * result + (this.readOnly != null ? this.readOnly.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that contains the properties for the Kubernetes resources of a job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * Object labels;
     * Object limits;
     * Object requests;
     * EksPropertiesProperty eksPropertiesProperty = EksPropertiesProperty.builder()
     *         .podProperties(PodPropertiesProperty.builder()
     *                 .containers(List.of(EksContainerProperty.builder()
     *                         .image("image")
     *                         // the properties below are optional
     *                         .args(List.of("args"))
     *                         .command(List.of("command"))
     *                         .env(List.of(EksContainerEnvironmentVariableProperty.builder()
     *                                 .name("name")
     *                                 // the properties below are optional
     *                                 .value("value")
     *                                 .build()))
     *                         .imagePullPolicy("imagePullPolicy")
     *                         .name("name")
     *                         .resources(ResourcesProperty.builder()
     *                                 .limits(limits)
     *                                 .requests(requests)
     *                                 .build())
     *                         .securityContext(SecurityContextProperty.builder()
     *                                 .allowPrivilegeEscalation(false)
     *                                 .privileged(false)
     *                                 .readOnlyRootFilesystem(false)
     *                                 .runAsGroup(123)
     *                                 .runAsNonRoot(false)
     *                                 .runAsUser(123)
     *                                 .build())
     *                         .volumeMounts(List.of(EksContainerVolumeMountProperty.builder()
     *                                 .mountPath("mountPath")
     *                                 .name("name")
     *                                 .readOnly(false)
     *                                 .subPath("subPath")
     *                                 .build()))
     *                         .build()))
     *                 .dnsPolicy("dnsPolicy")
     *                 .hostNetwork(false)
     *                 .imagePullSecrets(List.of(ImagePullSecretProperty.builder()
     *                         .name("name")
     *                         .build()))
     *                 .initContainers(List.of(EksContainerProperty.builder()
     *                         .image("image")
     *                         // the properties below are optional
     *                         .args(List.of("args"))
     *                         .command(List.of("command"))
     *                         .env(List.of(EksContainerEnvironmentVariableProperty.builder()
     *                                 .name("name")
     *                                 // the properties below are optional
     *                                 .value("value")
     *                                 .build()))
     *                         .imagePullPolicy("imagePullPolicy")
     *                         .name("name")
     *                         .resources(ResourcesProperty.builder()
     *                                 .limits(limits)
     *                                 .requests(requests)
     *                                 .build())
     *                         .securityContext(SecurityContextProperty.builder()
     *                                 .allowPrivilegeEscalation(false)
     *                                 .privileged(false)
     *                                 .readOnlyRootFilesystem(false)
     *                                 .runAsGroup(123)
     *                                 .runAsNonRoot(false)
     *                                 .runAsUser(123)
     *                                 .build())
     *                         .volumeMounts(List.of(EksContainerVolumeMountProperty.builder()
     *                                 .mountPath("mountPath")
     *                                 .name("name")
     *                                 .readOnly(false)
     *                                 .subPath("subPath")
     *                                 .build()))
     *                         .build()))
     *                 .metadata(MetadataProperty.builder()
     *                         .labels(labels)
     *                         .build())
     *                 .serviceAccountName("serviceAccountName")
     *                 .shareProcessNamespace(false)
     *                 .volumes(List.of(EksVolumeProperty.builder()
     *                         .name("name")
     *                         // the properties below are optional
     *                         .emptyDir(EmptyDirProperty.builder()
     *                                 .medium("medium")
     *                                 .sizeLimit("sizeLimit")
     *                                 .build())
     *                         .hostPath(HostPathProperty.builder()
     *                                 .path("path")
     *                                 .build())
     *                         .persistentVolumeClaim(EksPersistentVolumeClaimProperty.builder()
     *                                 .claimName("claimName")
     *                                 // the properties below are optional
     *                                 .readOnly(false)
     *                                 .build())
     *                         .secret(EksSecretProperty.builder()
     *                                 .secretName("secretName")
     *                                 // the properties below are optional
     *                                 .optional(false)
     *                                 .build())
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-eksproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-eksproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.EksPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(EksPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EksPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The properties for the Kubernetes pod resources of a job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-eksproperties.html#cfn-batch-jobdefinition-eksproperties-podproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-eksproperties.html#cfn-batch-jobdefinition-eksproperties-podproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPodProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EksPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EksPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EksPropertiesProperty> {
            java.lang.Object podProperties;

            /**
             * Sets the value of {@link EksPropertiesProperty#getPodProperties}
             * @param podProperties The properties for the Kubernetes pod resources of a job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder podProperties(software.amazon.awscdk.IResolvable podProperties) {
                this.podProperties = podProperties;
                return this;
            }

            /**
             * Sets the value of {@link EksPropertiesProperty#getPodProperties}
             * @param podProperties The properties for the Kubernetes pod resources of a job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder podProperties(software.amazon.awscdk.services.batch.CfnJobDefinition.PodPropertiesProperty podProperties) {
                this.podProperties = podProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EksPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EksPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EksPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EksPropertiesProperty {
            private final java.lang.Object podProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.podProperties = software.amazon.jsii.Kernel.get(this, "podProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.podProperties = builder.podProperties;
            }

            @Override
            public final java.lang.Object getPodProperties() {
                return this.podProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPodProperties() != null) {
                    data.set("podProperties", om.valueToTree(this.getPodProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.EksPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EksPropertiesProperty.Jsii$Proxy that = (EksPropertiesProperty.Jsii$Proxy) o;

                return this.podProperties != null ? this.podProperties.equals(that.podProperties) : that.podProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.podProperties != null ? this.podProperties.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies the configuration of a Kubernetes <code>secret</code> volume.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#secret">secret</a> in the <em>Kubernetes documentation</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * EksSecretProperty eksSecretProperty = EksSecretProperty.builder()
     *         .secretName("secretName")
     *         // the properties below are optional
     *         .optional(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekssecret.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekssecret.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.EksSecretProperty")
    @software.amazon.jsii.Jsii.Proxy(EksSecretProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EksSecretProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the secret.
         * <p>
         * The name must be allowed as a DNS subdomain name. For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names">DNS subdomain names</a> in the <em>Kubernetes documentation</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekssecret.html#cfn-batch-jobdefinition-ekssecret-secretname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekssecret.html#cfn-batch-jobdefinition-ekssecret-secretname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretName();

        /**
         * Specifies whether the secret or the secret's keys must be defined.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekssecret.html#cfn-batch-jobdefinition-ekssecret-optional">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ekssecret.html#cfn-batch-jobdefinition-ekssecret-optional</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOptional() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EksSecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EksSecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EksSecretProperty> {
            java.lang.String secretName;
            java.lang.Object optional;

            /**
             * Sets the value of {@link EksSecretProperty#getSecretName}
             * @param secretName The name of the secret. This parameter is required.
             *                   The name must be allowed as a DNS subdomain name. For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names">DNS subdomain names</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretName(java.lang.String secretName) {
                this.secretName = secretName;
                return this;
            }

            /**
             * Sets the value of {@link EksSecretProperty#getOptional}
             * @param optional Specifies whether the secret or the secret's keys must be defined.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder optional(java.lang.Boolean optional) {
                this.optional = optional;
                return this;
            }

            /**
             * Sets the value of {@link EksSecretProperty#getOptional}
             * @param optional Specifies whether the secret or the secret's keys must be defined.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder optional(software.amazon.awscdk.IResolvable optional) {
                this.optional = optional;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EksSecretProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EksSecretProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EksSecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EksSecretProperty {
            private final java.lang.String secretName;
            private final java.lang.Object optional;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretName = software.amazon.jsii.Kernel.get(this, "secretName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.optional = software.amazon.jsii.Kernel.get(this, "optional", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretName = java.util.Objects.requireNonNull(builder.secretName, "secretName is required");
                this.optional = builder.optional;
            }

            @Override
            public final java.lang.String getSecretName() {
                return this.secretName;
            }

            @Override
            public final java.lang.Object getOptional() {
                return this.optional;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("secretName", om.valueToTree(this.getSecretName()));
                if (this.getOptional() != null) {
                    data.set("optional", om.valueToTree(this.getOptional()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.EksSecretProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EksSecretProperty.Jsii$Proxy that = (EksSecretProperty.Jsii$Proxy) o;

                if (!secretName.equals(that.secretName)) return false;
                return this.optional != null ? this.optional.equals(that.optional) : that.optional == null;
            }

            @Override
            public final int hashCode() {
                int result = this.secretName.hashCode();
                result = 31 * result + (this.optional != null ? this.optional.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an Amazon EKS volume for a job definition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * EksVolumeProperty eksVolumeProperty = EksVolumeProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .emptyDir(EmptyDirProperty.builder()
     *                 .medium("medium")
     *                 .sizeLimit("sizeLimit")
     *                 .build())
     *         .hostPath(HostPathProperty.builder()
     *                 .path("path")
     *                 .build())
     *         .persistentVolumeClaim(EksPersistentVolumeClaimProperty.builder()
     *                 .claimName("claimName")
     *                 // the properties below are optional
     *                 .readOnly(false)
     *                 .build())
     *         .secret(EksSecretProperty.builder()
     *                 .secretName("secretName")
     *                 // the properties below are optional
     *                 .optional(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-eksvolume.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-eksvolume.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.EksVolumeProperty")
    @software.amazon.jsii.Jsii.Proxy(EksVolumeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EksVolumeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the volume.
         * <p>
         * The name must be allowed as a DNS subdomain name. For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names">DNS subdomain names</a> in the <em>Kubernetes documentation</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-eksvolume.html#cfn-batch-jobdefinition-eksvolume-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-eksvolume.html#cfn-batch-jobdefinition-eksvolume-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Specifies the configuration of a Kubernetes <code>emptyDir</code> volume.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#emptydir">emptyDir</a> in the <em>Kubernetes documentation</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-eksvolume.html#cfn-batch-jobdefinition-eksvolume-emptydir">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-eksvolume.html#cfn-batch-jobdefinition-eksvolume-emptydir</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEmptyDir() {
            return null;
        }

        /**
         * Specifies the configuration of a Kubernetes <code>hostPath</code> volume.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#hostpath">hostPath</a> in the <em>Kubernetes documentation</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-eksvolume.html#cfn-batch-jobdefinition-eksvolume-hostpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-eksvolume.html#cfn-batch-jobdefinition-eksvolume-hostpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHostPath() {
            return null;
        }

        /**
         * Specifies the configuration of a Kubernetes <code>persistentVolumeClaim</code> bounded to a <code>persistentVolume</code> .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/persistent-volumes/#persistentvolumeclaims">Persistent Volume Claims</a> in the <em>Kubernetes documentation</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-eksvolume.html#cfn-batch-jobdefinition-eksvolume-persistentvolumeclaim">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-eksvolume.html#cfn-batch-jobdefinition-eksvolume-persistentvolumeclaim</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPersistentVolumeClaim() {
            return null;
        }

        /**
         * Specifies the configuration of a Kubernetes <code>secret</code> volume.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#secret">secret</a> in the <em>Kubernetes documentation</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-eksvolume.html#cfn-batch-jobdefinition-eksvolume-secret">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-eksvolume.html#cfn-batch-jobdefinition-eksvolume-secret</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecret() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EksVolumeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EksVolumeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EksVolumeProperty> {
            java.lang.String name;
            java.lang.Object emptyDir;
            java.lang.Object hostPath;
            java.lang.Object persistentVolumeClaim;
            java.lang.Object secret;

            /**
             * Sets the value of {@link EksVolumeProperty#getName}
             * @param name The name of the volume. This parameter is required.
             *             The name must be allowed as a DNS subdomain name. For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names">DNS subdomain names</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link EksVolumeProperty#getEmptyDir}
             * @param emptyDir Specifies the configuration of a Kubernetes <code>emptyDir</code> volume.
             *                 For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#emptydir">emptyDir</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emptyDir(software.amazon.awscdk.IResolvable emptyDir) {
                this.emptyDir = emptyDir;
                return this;
            }

            /**
             * Sets the value of {@link EksVolumeProperty#getEmptyDir}
             * @param emptyDir Specifies the configuration of a Kubernetes <code>emptyDir</code> volume.
             *                 For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#emptydir">emptyDir</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emptyDir(software.amazon.awscdk.services.batch.CfnJobDefinition.EmptyDirProperty emptyDir) {
                this.emptyDir = emptyDir;
                return this;
            }

            /**
             * Sets the value of {@link EksVolumeProperty#getHostPath}
             * @param hostPath Specifies the configuration of a Kubernetes <code>hostPath</code> volume.
             *                 For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#hostpath">hostPath</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostPath(software.amazon.awscdk.IResolvable hostPath) {
                this.hostPath = hostPath;
                return this;
            }

            /**
             * Sets the value of {@link EksVolumeProperty#getHostPath}
             * @param hostPath Specifies the configuration of a Kubernetes <code>hostPath</code> volume.
             *                 For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#hostpath">hostPath</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostPath(software.amazon.awscdk.services.batch.CfnJobDefinition.HostPathProperty hostPath) {
                this.hostPath = hostPath;
                return this;
            }

            /**
             * Sets the value of {@link EksVolumeProperty#getPersistentVolumeClaim}
             * @param persistentVolumeClaim Specifies the configuration of a Kubernetes <code>persistentVolumeClaim</code> bounded to a <code>persistentVolume</code> .
             *                              For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/persistent-volumes/#persistentvolumeclaims">Persistent Volume Claims</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder persistentVolumeClaim(software.amazon.awscdk.IResolvable persistentVolumeClaim) {
                this.persistentVolumeClaim = persistentVolumeClaim;
                return this;
            }

            /**
             * Sets the value of {@link EksVolumeProperty#getPersistentVolumeClaim}
             * @param persistentVolumeClaim Specifies the configuration of a Kubernetes <code>persistentVolumeClaim</code> bounded to a <code>persistentVolume</code> .
             *                              For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/persistent-volumes/#persistentvolumeclaims">Persistent Volume Claims</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder persistentVolumeClaim(software.amazon.awscdk.services.batch.CfnJobDefinition.EksPersistentVolumeClaimProperty persistentVolumeClaim) {
                this.persistentVolumeClaim = persistentVolumeClaim;
                return this;
            }

            /**
             * Sets the value of {@link EksVolumeProperty#getSecret}
             * @param secret Specifies the configuration of a Kubernetes <code>secret</code> volume.
             *               For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#secret">secret</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secret(software.amazon.awscdk.IResolvable secret) {
                this.secret = secret;
                return this;
            }

            /**
             * Sets the value of {@link EksVolumeProperty#getSecret}
             * @param secret Specifies the configuration of a Kubernetes <code>secret</code> volume.
             *               For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#secret">secret</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secret(software.amazon.awscdk.services.batch.CfnJobDefinition.EksSecretProperty secret) {
                this.secret = secret;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EksVolumeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EksVolumeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EksVolumeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EksVolumeProperty {
            private final java.lang.String name;
            private final java.lang.Object emptyDir;
            private final java.lang.Object hostPath;
            private final java.lang.Object persistentVolumeClaim;
            private final java.lang.Object secret;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.emptyDir = software.amazon.jsii.Kernel.get(this, "emptyDir", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hostPath = software.amazon.jsii.Kernel.get(this, "hostPath", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.persistentVolumeClaim = software.amazon.jsii.Kernel.get(this, "persistentVolumeClaim", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secret = software.amazon.jsii.Kernel.get(this, "secret", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.emptyDir = builder.emptyDir;
                this.hostPath = builder.hostPath;
                this.persistentVolumeClaim = builder.persistentVolumeClaim;
                this.secret = builder.secret;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getEmptyDir() {
                return this.emptyDir;
            }

            @Override
            public final java.lang.Object getHostPath() {
                return this.hostPath;
            }

            @Override
            public final java.lang.Object getPersistentVolumeClaim() {
                return this.persistentVolumeClaim;
            }

            @Override
            public final java.lang.Object getSecret() {
                return this.secret;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getEmptyDir() != null) {
                    data.set("emptyDir", om.valueToTree(this.getEmptyDir()));
                }
                if (this.getHostPath() != null) {
                    data.set("hostPath", om.valueToTree(this.getHostPath()));
                }
                if (this.getPersistentVolumeClaim() != null) {
                    data.set("persistentVolumeClaim", om.valueToTree(this.getPersistentVolumeClaim()));
                }
                if (this.getSecret() != null) {
                    data.set("secret", om.valueToTree(this.getSecret()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.EksVolumeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EksVolumeProperty.Jsii$Proxy that = (EksVolumeProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.emptyDir != null ? !this.emptyDir.equals(that.emptyDir) : that.emptyDir != null) return false;
                if (this.hostPath != null ? !this.hostPath.equals(that.hostPath) : that.hostPath != null) return false;
                if (this.persistentVolumeClaim != null ? !this.persistentVolumeClaim.equals(that.persistentVolumeClaim) : that.persistentVolumeClaim != null) return false;
                return this.secret != null ? this.secret.equals(that.secret) : that.secret == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.emptyDir != null ? this.emptyDir.hashCode() : 0);
                result = 31 * result + (this.hostPath != null ? this.hostPath.hashCode() : 0);
                result = 31 * result + (this.persistentVolumeClaim != null ? this.persistentVolumeClaim.hashCode() : 0);
                result = 31 * result + (this.secret != null ? this.secret.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * EmptyDirProperty emptyDirProperty = EmptyDirProperty.builder()
     *         .medium("medium")
     *         .sizeLimit("sizeLimit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-emptydir.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-emptydir.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.EmptyDirProperty")
    @software.amazon.jsii.Jsii.Proxy(EmptyDirProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EmptyDirProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-emptydir.html#cfn-batch-jobdefinition-emptydir-medium">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-emptydir.html#cfn-batch-jobdefinition-emptydir-medium</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMedium() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-emptydir.html#cfn-batch-jobdefinition-emptydir-sizelimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-emptydir.html#cfn-batch-jobdefinition-emptydir-sizelimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSizeLimit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EmptyDirProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EmptyDirProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EmptyDirProperty> {
            java.lang.String medium;
            java.lang.String sizeLimit;

            /**
             * Sets the value of {@link EmptyDirProperty#getMedium}
             * @param medium the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder medium(java.lang.String medium) {
                this.medium = medium;
                return this;
            }

            /**
             * Sets the value of {@link EmptyDirProperty#getSizeLimit}
             * @param sizeLimit the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeLimit(java.lang.String sizeLimit) {
                this.sizeLimit = sizeLimit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EmptyDirProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EmptyDirProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EmptyDirProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmptyDirProperty {
            private final java.lang.String medium;
            private final java.lang.String sizeLimit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.medium = software.amazon.jsii.Kernel.get(this, "medium", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sizeLimit = software.amazon.jsii.Kernel.get(this, "sizeLimit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.medium = builder.medium;
                this.sizeLimit = builder.sizeLimit;
            }

            @Override
            public final java.lang.String getMedium() {
                return this.medium;
            }

            @Override
            public final java.lang.String getSizeLimit() {
                return this.sizeLimit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMedium() != null) {
                    data.set("medium", om.valueToTree(this.getMedium()));
                }
                if (this.getSizeLimit() != null) {
                    data.set("sizeLimit", om.valueToTree(this.getSizeLimit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.EmptyDirProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EmptyDirProperty.Jsii$Proxy that = (EmptyDirProperty.Jsii$Proxy) o;

                if (this.medium != null ? !this.medium.equals(that.medium) : that.medium != null) return false;
                return this.sizeLimit != null ? this.sizeLimit.equals(that.sizeLimit) : that.sizeLimit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.medium != null ? this.medium.hashCode() : 0;
                result = 31 * result + (this.sizeLimit != null ? this.sizeLimit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Environment property type specifies environment variables to use in a job definition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * EnvironmentProperty environmentProperty = EnvironmentProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-environment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-environment.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.EnvironmentProperty")
    @software.amazon.jsii.Jsii.Proxy(EnvironmentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnvironmentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the environment variable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-environment.html#cfn-batch-jobdefinition-environment-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-environment.html#cfn-batch-jobdefinition-environment-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The value of the environment variable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-environment.html#cfn-batch-jobdefinition-environment-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-environment.html#cfn-batch-jobdefinition-environment-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EnvironmentProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link EnvironmentProperty#getName}
             * @param name The name of the environment variable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getValue}
             * @param value The value of the environment variable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnvironmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EnvironmentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnvironmentProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.EnvironmentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EnvironmentProperty.Jsii$Proxy that = (EnvironmentProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The amount of ephemeral storage to allocate for the task.
     * <p>
     * This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * EphemeralStorageProperty ephemeralStorageProperty = EphemeralStorageProperty.builder()
     *         .sizeInGiB(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ephemeralstorage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ephemeralstorage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.EphemeralStorageProperty")
    @software.amazon.jsii.Jsii.Proxy(EphemeralStorageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EphemeralStorageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The total amount, in GiB, of ephemeral storage to set for the task.
         * <p>
         * The minimum supported value is <code>21</code> GiB and the maximum supported value is <code>200</code> GiB.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ephemeralstorage.html#cfn-batch-jobdefinition-ephemeralstorage-sizeingib">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ephemeralstorage.html#cfn-batch-jobdefinition-ephemeralstorage-sizeingib</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getSizeInGiB();

        /**
         * @return a {@link Builder} of {@link EphemeralStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EphemeralStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EphemeralStorageProperty> {
            java.lang.Number sizeInGiB;

            /**
             * Sets the value of {@link EphemeralStorageProperty#getSizeInGiB}
             * @param sizeInGiB The total amount, in GiB, of ephemeral storage to set for the task. This parameter is required.
             *                  The minimum supported value is <code>21</code> GiB and the maximum supported value is <code>200</code> GiB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeInGiB(java.lang.Number sizeInGiB) {
                this.sizeInGiB = sizeInGiB;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EphemeralStorageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EphemeralStorageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EphemeralStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EphemeralStorageProperty {
            private final java.lang.Number sizeInGiB;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sizeInGiB = software.amazon.jsii.Kernel.get(this, "sizeInGiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sizeInGiB = java.util.Objects.requireNonNull(builder.sizeInGiB, "sizeInGiB is required");
            }

            @Override
            public final java.lang.Number getSizeInGiB() {
                return this.sizeInGiB;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sizeInGiB", om.valueToTree(this.getSizeInGiB()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.EphemeralStorageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EphemeralStorageProperty.Jsii$Proxy that = (EphemeralStorageProperty.Jsii$Proxy) o;

                return this.sizeInGiB.equals(that.sizeInGiB);
            }

            @Override
            public final int hashCode() {
                int result = this.sizeInGiB.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies an array of up to 5 conditions to be met, and an action to take ( <code>RETRY</code> or <code>EXIT</code> ) if all conditions are met.
     * <p>
     * If none of the <code>EvaluateOnExit</code> conditions in a <code>RetryStrategy</code> match, then the job is retried.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * EvaluateOnExitProperty evaluateOnExitProperty = EvaluateOnExitProperty.builder()
     *         .action("action")
     *         // the properties below are optional
     *         .onExitCode("onExitCode")
     *         .onReason("onReason")
     *         .onStatusReason("onStatusReason")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-evaluateonexit.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-evaluateonexit.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.EvaluateOnExitProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluateOnExitProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluateOnExitProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the action to take if all of the specified conditions ( <code>onStatusReason</code> , <code>onReason</code> , and <code>onExitCode</code> ) are met.
         * <p>
         * The values aren't case sensitive.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-evaluateonexit.html#cfn-batch-jobdefinition-evaluateonexit-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-evaluateonexit.html#cfn-batch-jobdefinition-evaluateonexit-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAction();

        /**
         * Contains a glob pattern to match against the decimal representation of the <code>ExitCode</code> returned for a job.
         * <p>
         * The pattern can be up to 512 characters long. It can contain only numbers, and can end with an asterisk (*) so that only the start of the string needs to be an exact match.
         * <p>
         * The string can contain up to 512 characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-evaluateonexit.html#cfn-batch-jobdefinition-evaluateonexit-onexitcode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-evaluateonexit.html#cfn-batch-jobdefinition-evaluateonexit-onexitcode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOnExitCode() {
            return null;
        }

        /**
         * Contains a glob pattern to match against the <code>Reason</code> returned for a job.
         * <p>
         * The pattern can contain up to 512 characters. It can contain letters, numbers, periods (.), colons (:), and white space (including spaces and tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-evaluateonexit.html#cfn-batch-jobdefinition-evaluateonexit-onreason">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-evaluateonexit.html#cfn-batch-jobdefinition-evaluateonexit-onreason</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOnReason() {
            return null;
        }

        /**
         * Contains a glob pattern to match against the <code>StatusReason</code> returned for a job.
         * <p>
         * The pattern can contain up to 512 characters. It can contain letters, numbers, periods (.), colons (:), and white spaces (including spaces or tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-evaluateonexit.html#cfn-batch-jobdefinition-evaluateonexit-onstatusreason">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-evaluateonexit.html#cfn-batch-jobdefinition-evaluateonexit-onstatusreason</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOnStatusReason() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluateOnExitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluateOnExitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluateOnExitProperty> {
            java.lang.String action;
            java.lang.String onExitCode;
            java.lang.String onReason;
            java.lang.String onStatusReason;

            /**
             * Sets the value of {@link EvaluateOnExitProperty#getAction}
             * @param action Specifies the action to take if all of the specified conditions ( <code>onStatusReason</code> , <code>onReason</code> , and <code>onExitCode</code> ) are met. This parameter is required.
             *               The values aren't case sensitive.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link EvaluateOnExitProperty#getOnExitCode}
             * @param onExitCode Contains a glob pattern to match against the decimal representation of the <code>ExitCode</code> returned for a job.
             *                   The pattern can be up to 512 characters long. It can contain only numbers, and can end with an asterisk (*) so that only the start of the string needs to be an exact match.
             *                   <p>
             *                   The string can contain up to 512 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onExitCode(java.lang.String onExitCode) {
                this.onExitCode = onExitCode;
                return this;
            }

            /**
             * Sets the value of {@link EvaluateOnExitProperty#getOnReason}
             * @param onReason Contains a glob pattern to match against the <code>Reason</code> returned for a job.
             *                 The pattern can contain up to 512 characters. It can contain letters, numbers, periods (.), colons (:), and white space (including spaces and tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onReason(java.lang.String onReason) {
                this.onReason = onReason;
                return this;
            }

            /**
             * Sets the value of {@link EvaluateOnExitProperty#getOnStatusReason}
             * @param onStatusReason Contains a glob pattern to match against the <code>StatusReason</code> returned for a job.
             *                       The pattern can contain up to 512 characters. It can contain letters, numbers, periods (.), colons (:), and white spaces (including spaces or tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onStatusReason(java.lang.String onStatusReason) {
                this.onStatusReason = onStatusReason;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluateOnExitProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluateOnExitProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluateOnExitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluateOnExitProperty {
            private final java.lang.String action;
            private final java.lang.String onExitCode;
            private final java.lang.String onReason;
            private final java.lang.String onStatusReason;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.onExitCode = software.amazon.jsii.Kernel.get(this, "onExitCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.onReason = software.amazon.jsii.Kernel.get(this, "onReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.onStatusReason = software.amazon.jsii.Kernel.get(this, "onStatusReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.onExitCode = builder.onExitCode;
                this.onReason = builder.onReason;
                this.onStatusReason = builder.onStatusReason;
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.String getOnExitCode() {
                return this.onExitCode;
            }

            @Override
            public final java.lang.String getOnReason() {
                return this.onReason;
            }

            @Override
            public final java.lang.String getOnStatusReason() {
                return this.onStatusReason;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                if (this.getOnExitCode() != null) {
                    data.set("onExitCode", om.valueToTree(this.getOnExitCode()));
                }
                if (this.getOnReason() != null) {
                    data.set("onReason", om.valueToTree(this.getOnReason()));
                }
                if (this.getOnStatusReason() != null) {
                    data.set("onStatusReason", om.valueToTree(this.getOnStatusReason()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.EvaluateOnExitProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluateOnExitProperty.Jsii$Proxy that = (EvaluateOnExitProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                if (this.onExitCode != null ? !this.onExitCode.equals(that.onExitCode) : that.onExitCode != null) return false;
                if (this.onReason != null ? !this.onReason.equals(that.onReason) : that.onReason != null) return false;
                return this.onStatusReason != null ? this.onStatusReason.equals(that.onStatusReason) : that.onStatusReason == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.onExitCode != null ? this.onExitCode.hashCode() : 0);
                result = 31 * result + (this.onReason != null ? this.onReason.hashCode() : 0);
                result = 31 * result + (this.onStatusReason != null ? this.onStatusReason.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The platform configuration for jobs that are running on Fargate resources.
     * <p>
     * Jobs that run on Amazon EC2 resources must not specify this parameter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * FargatePlatformConfigurationProperty fargatePlatformConfigurationProperty = FargatePlatformConfigurationProperty.builder()
     *         .platformVersion("platformVersion")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-fargateplatformconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-fargateplatformconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.FargatePlatformConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FargatePlatformConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FargatePlatformConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS Fargate platform version where the jobs are running.
         * <p>
         * A platform version is specified only for jobs that are running on Fargate resources. If one isn't specified, the <code>LATEST</code> platform version is used by default. This uses a recent, approved version of the AWS Fargate platform for compute resources. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate platform versions</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-fargateplatformconfiguration.html#cfn-batch-jobdefinition-fargateplatformconfiguration-platformversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-fargateplatformconfiguration.html#cfn-batch-jobdefinition-fargateplatformconfiguration-platformversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPlatformVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FargatePlatformConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FargatePlatformConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FargatePlatformConfigurationProperty> {
            java.lang.String platformVersion;

            /**
             * Sets the value of {@link FargatePlatformConfigurationProperty#getPlatformVersion}
             * @param platformVersion The AWS Fargate platform version where the jobs are running.
             *                        A platform version is specified only for jobs that are running on Fargate resources. If one isn't specified, the <code>LATEST</code> platform version is used by default. This uses a recent, approved version of the AWS Fargate platform for compute resources. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate platform versions</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder platformVersion(java.lang.String platformVersion) {
                this.platformVersion = platformVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FargatePlatformConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FargatePlatformConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FargatePlatformConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FargatePlatformConfigurationProperty {
            private final java.lang.String platformVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.platformVersion = software.amazon.jsii.Kernel.get(this, "platformVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.platformVersion = builder.platformVersion;
            }

            @Override
            public final java.lang.String getPlatformVersion() {
                return this.platformVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPlatformVersion() != null) {
                    data.set("platformVersion", om.valueToTree(this.getPlatformVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.FargatePlatformConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FargatePlatformConfigurationProperty.Jsii$Proxy that = (FargatePlatformConfigurationProperty.Jsii$Proxy) o;

                return this.platformVersion != null ? this.platformVersion.equals(that.platformVersion) : that.platformVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.platformVersion != null ? this.platformVersion.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * HostPathProperty hostPathProperty = HostPathProperty.builder()
     *         .path("path")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-hostpath.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-hostpath.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.HostPathProperty")
    @software.amazon.jsii.Jsii.Proxy(HostPathProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HostPathProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-hostpath.html#cfn-batch-jobdefinition-hostpath-path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-hostpath.html#cfn-batch-jobdefinition-hostpath-path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HostPathProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HostPathProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HostPathProperty> {
            java.lang.String path;

            /**
             * Sets the value of {@link HostPathProperty#getPath}
             * @param path the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HostPathProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HostPathProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HostPathProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HostPathProperty {
            private final java.lang.String path;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.path = builder.path;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.HostPathProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HostPathProperty.Jsii$Proxy that = (HostPathProperty.Jsii$Proxy) o;

                return this.path != null ? this.path.equals(that.path) : that.path == null;
            }

            @Override
            public final int hashCode() {
                int result = this.path != null ? this.path.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * References a Kubernetes secret resource.
     * <p>
     * This name of the secret must start and end with an alphanumeric character, is required to be lowercase, can include periods (.) and hyphens (-), and can't contain more than 253 characters.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * ImagePullSecretProperty imagePullSecretProperty = ImagePullSecretProperty.builder()
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-imagepullsecret.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-imagepullsecret.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.ImagePullSecretProperty")
    @software.amazon.jsii.Jsii.Proxy(ImagePullSecretProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImagePullSecretProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Provides a unique identifier for the <code>ImagePullSecret</code> .
         * <p>
         * This object is required when <code>EksPodProperties$imagePullSecrets</code> is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-imagepullsecret.html#cfn-batch-jobdefinition-imagepullsecret-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-imagepullsecret.html#cfn-batch-jobdefinition-imagepullsecret-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ImagePullSecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImagePullSecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImagePullSecretProperty> {
            java.lang.String name;

            /**
             * Sets the value of {@link ImagePullSecretProperty#getName}
             * @param name Provides a unique identifier for the <code>ImagePullSecret</code> .
             *             This object is required when <code>EksPodProperties$imagePullSecrets</code> is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImagePullSecretProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImagePullSecretProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ImagePullSecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImagePullSecretProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.ImagePullSecretProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImagePullSecretProperty.Jsii$Proxy that = (ImagePullSecretProperty.Jsii$Proxy) o;

                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that represents a job timeout configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * JobTimeoutProperty jobTimeoutProperty = JobTimeoutProperty.builder()
     *         .attemptDurationSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-jobtimeout.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-jobtimeout.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.JobTimeoutProperty")
    @software.amazon.jsii.Jsii.Proxy(JobTimeoutProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JobTimeoutProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The job timeout time (in seconds) that's measured from the job attempt's <code>startedAt</code> timestamp.
         * <p>
         * After this time passes, AWS Batch terminates your jobs if they aren't finished. The minimum value for the timeout is 60 seconds.
         * <p>
         * For array jobs, the timeout applies to the child jobs, not to the parent array job.
         * <p>
         * For multi-node parallel (MNP) jobs, the timeout applies to the whole job, not to the individual nodes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-jobtimeout.html#cfn-batch-jobdefinition-jobtimeout-attemptdurationseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-jobtimeout.html#cfn-batch-jobdefinition-jobtimeout-attemptdurationseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAttemptDurationSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JobTimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JobTimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JobTimeoutProperty> {
            java.lang.Number attemptDurationSeconds;

            /**
             * Sets the value of {@link JobTimeoutProperty#getAttemptDurationSeconds}
             * @param attemptDurationSeconds The job timeout time (in seconds) that's measured from the job attempt's <code>startedAt</code> timestamp.
             *                               After this time passes, AWS Batch terminates your jobs if they aren't finished. The minimum value for the timeout is 60 seconds.
             *                               <p>
             *                               For array jobs, the timeout applies to the child jobs, not to the parent array job.
             *                               <p>
             *                               For multi-node parallel (MNP) jobs, the timeout applies to the whole job, not to the individual nodes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attemptDurationSeconds(java.lang.Number attemptDurationSeconds) {
                this.attemptDurationSeconds = attemptDurationSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JobTimeoutProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JobTimeoutProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JobTimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JobTimeoutProperty {
            private final java.lang.Number attemptDurationSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attemptDurationSeconds = software.amazon.jsii.Kernel.get(this, "attemptDurationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attemptDurationSeconds = builder.attemptDurationSeconds;
            }

            @Override
            public final java.lang.Number getAttemptDurationSeconds() {
                return this.attemptDurationSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttemptDurationSeconds() != null) {
                    data.set("attemptDurationSeconds", om.valueToTree(this.getAttemptDurationSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.JobTimeoutProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JobTimeoutProperty.Jsii$Proxy that = (JobTimeoutProperty.Jsii$Proxy) o;

                return this.attemptDurationSeconds != null ? this.attemptDurationSeconds.equals(that.attemptDurationSeconds) : that.attemptDurationSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attemptDurationSeconds != null ? this.attemptDurationSeconds.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Linux-specific modifications that are applied to the container, such as details for device mappings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * LinuxParametersProperty linuxParametersProperty = LinuxParametersProperty.builder()
     *         .devices(List.of(DeviceProperty.builder()
     *                 .containerPath("containerPath")
     *                 .hostPath("hostPath")
     *                 .permissions(List.of("permissions"))
     *                 .build()))
     *         .initProcessEnabled(false)
     *         .maxSwap(123)
     *         .sharedMemorySize(123)
     *         .swappiness(123)
     *         .tmpfs(List.of(TmpfsProperty.builder()
     *                 .containerPath("containerPath")
     *                 .size(123)
     *                 // the properties below are optional
     *                 .mountOptions(List.of("mountOptions"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-linuxparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-linuxparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.LinuxParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(LinuxParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LinuxParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Any of the host devices to expose to the container.
         * <p>
         * This parameter maps to <code>Devices</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--device</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-linuxparameters.html#cfn-batch-jobdefinition-linuxparameters-devices">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-linuxparameters.html#cfn-batch-jobdefinition-linuxparameters-devices</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDevices() {
            return null;
        }

        /**
         * If true, run an <code>init</code> process inside the container that forwards signals and reaps processes.
         * <p>
         * This parameter maps to the <code>--init</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . This parameter requires version 1.25 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-linuxparameters.html#cfn-batch-jobdefinition-linuxparameters-initprocessenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-linuxparameters.html#cfn-batch-jobdefinition-linuxparameters-initprocessenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInitProcessEnabled() {
            return null;
        }

        /**
         * The total amount of swap memory (in MiB) a container can use.
         * <p>
         * This parameter is translated to the <code>--memory-swap</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> where the value is the sum of the container memory plus the <code>maxSwap</code> value. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/resource_constraints/#--memory-swap-details"><code>--memory-swap</code> details</a> in the Docker documentation.
         * <p>
         * If a <code>maxSwap</code> value of <code>0</code> is specified, the container doesn't use swap. Accepted values are <code>0</code> or any positive integer. If the <code>maxSwap</code> parameter is omitted, the container doesn't use the swap configuration for the container instance on which it runs. A <code>maxSwap</code> value must be set for the <code>swappiness</code> parameter to be used.
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-linuxparameters.html#cfn-batch-jobdefinition-linuxparameters-maxswap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-linuxparameters.html#cfn-batch-jobdefinition-linuxparameters-maxswap</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxSwap() {
            return null;
        }

        /**
         * The value for the size (in MiB) of the <code>/dev/shm</code> volume.
         * <p>
         * This parameter maps to the <code>--shm-size</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-linuxparameters.html#cfn-batch-jobdefinition-linuxparameters-sharedmemorysize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-linuxparameters.html#cfn-batch-jobdefinition-linuxparameters-sharedmemorysize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSharedMemorySize() {
            return null;
        }

        /**
         * You can use this parameter to tune a container's memory swappiness behavior.
         * <p>
         * A <code>swappiness</code> value of <code>0</code> causes swapping to not occur unless absolutely necessary. A <code>swappiness</code> value of <code>100</code> causes pages to be swapped aggressively. Valid values are whole numbers between <code>0</code> and <code>100</code> . If the <code>swappiness</code> parameter isn't specified, a default value of <code>60</code> is used. If a value isn't specified for <code>maxSwap</code> , then this parameter is ignored. If <code>maxSwap</code> is set to 0, the container doesn't use swap. This parameter maps to the <code>--memory-swappiness</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
         * <p>
         * Consider the following when you use a per-container swap configuration.
         * <p>
         * <ul>
         * <li>Swap space must be enabled and allocated on the container instance for the containers to use.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * By default, the Amazon ECS optimized AMIs don't have swap enabled. You must enable swap on the instance to use this feature. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-store-swap-volumes.html">Instance store swap volumes</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> or <a href="https://docs.aws.amazon.com/premiumsupport/knowledge-center/ec2-memory-swap-file/">How do I allocate memory to work as swap space in an Amazon EC2 instance by using a swap file?</a>
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li>The swap space parameters are only supported for job definitions using EC2 resources.</li>
         * <li>If the <code>maxSwap</code> and <code>swappiness</code> parameters are omitted from a job definition, each container has a default <code>swappiness</code> value of 60. Moreover, the total swap usage is limited to two times the memory reservation of the container.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-linuxparameters.html#cfn-batch-jobdefinition-linuxparameters-swappiness">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-linuxparameters.html#cfn-batch-jobdefinition-linuxparameters-swappiness</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSwappiness() {
            return null;
        }

        /**
         * The container path, mount options, and size (in MiB) of the <code>tmpfs</code> mount.
         * <p>
         * This parameter maps to the <code>--tmpfs</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide this parameter for this resource type.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-linuxparameters.html#cfn-batch-jobdefinition-linuxparameters-tmpfs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-linuxparameters.html#cfn-batch-jobdefinition-linuxparameters-tmpfs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTmpfs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LinuxParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LinuxParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LinuxParametersProperty> {
            java.lang.Object devices;
            java.lang.Object initProcessEnabled;
            java.lang.Number maxSwap;
            java.lang.Number sharedMemorySize;
            java.lang.Number swappiness;
            java.lang.Object tmpfs;

            /**
             * Sets the value of {@link LinuxParametersProperty#getDevices}
             * @param devices Any of the host devices to expose to the container.
             *                This parameter maps to <code>Devices</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--device</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             *                <p>
             *                <blockquote>
             *                <p>
             *                This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder devices(software.amazon.awscdk.IResolvable devices) {
                this.devices = devices;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getDevices}
             * @param devices Any of the host devices to expose to the container.
             *                This parameter maps to <code>Devices</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--device</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             *                <p>
             *                <blockquote>
             *                <p>
             *                This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder devices(java.util.List<? extends java.lang.Object> devices) {
                this.devices = devices;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getInitProcessEnabled}
             * @param initProcessEnabled If true, run an <code>init</code> process inside the container that forwards signals and reaps processes.
             *                           This parameter maps to the <code>--init</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . This parameter requires version 1.25 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initProcessEnabled(java.lang.Boolean initProcessEnabled) {
                this.initProcessEnabled = initProcessEnabled;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getInitProcessEnabled}
             * @param initProcessEnabled If true, run an <code>init</code> process inside the container that forwards signals and reaps processes.
             *                           This parameter maps to the <code>--init</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . This parameter requires version 1.25 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initProcessEnabled(software.amazon.awscdk.IResolvable initProcessEnabled) {
                this.initProcessEnabled = initProcessEnabled;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getMaxSwap}
             * @param maxSwap The total amount of swap memory (in MiB) a container can use.
             *                This parameter is translated to the <code>--memory-swap</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> where the value is the sum of the container memory plus the <code>maxSwap</code> value. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/resource_constraints/#--memory-swap-details"><code>--memory-swap</code> details</a> in the Docker documentation.
             *                <p>
             *                If a <code>maxSwap</code> value of <code>0</code> is specified, the container doesn't use swap. Accepted values are <code>0</code> or any positive integer. If the <code>maxSwap</code> parameter is omitted, the container doesn't use the swap configuration for the container instance on which it runs. A <code>maxSwap</code> value must be set for the <code>swappiness</code> parameter to be used.
             *                <p>
             *                <blockquote>
             *                <p>
             *                This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxSwap(java.lang.Number maxSwap) {
                this.maxSwap = maxSwap;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getSharedMemorySize}
             * @param sharedMemorySize The value for the size (in MiB) of the <code>/dev/shm</code> volume.
             *                         This parameter maps to the <code>--shm-size</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sharedMemorySize(java.lang.Number sharedMemorySize) {
                this.sharedMemorySize = sharedMemorySize;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getSwappiness}
             * @param swappiness You can use this parameter to tune a container's memory swappiness behavior.
             *                   A <code>swappiness</code> value of <code>0</code> causes swapping to not occur unless absolutely necessary. A <code>swappiness</code> value of <code>100</code> causes pages to be swapped aggressively. Valid values are whole numbers between <code>0</code> and <code>100</code> . If the <code>swappiness</code> parameter isn't specified, a default value of <code>60</code> is used. If a value isn't specified for <code>maxSwap</code> , then this parameter is ignored. If <code>maxSwap</code> is set to 0, the container doesn't use swap. This parameter maps to the <code>--memory-swappiness</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             *                   <p>
             *                   Consider the following when you use a per-container swap configuration.
             *                   <p>
             *                   <ul>
             *                   <li>Swap space must be enabled and allocated on the container instance for the containers to use.</li>
             *                   </ul>
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   By default, the Amazon ECS optimized AMIs don't have swap enabled. You must enable swap on the instance to use this feature. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-store-swap-volumes.html">Instance store swap volumes</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> or <a href="https://docs.aws.amazon.com/premiumsupport/knowledge-center/ec2-memory-swap-file/">How do I allocate memory to work as swap space in an Amazon EC2 instance by using a swap file?</a>
             *                   <p>
             *                   </blockquote>
             *                   <p>
             *                   <ul>
             *                   <li>The swap space parameters are only supported for job definitions using EC2 resources.</li>
             *                   <li>If the <code>maxSwap</code> and <code>swappiness</code> parameters are omitted from a job definition, each container has a default <code>swappiness</code> value of 60. Moreover, the total swap usage is limited to two times the memory reservation of the container.</li>
             *                   </ul>
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder swappiness(java.lang.Number swappiness) {
                this.swappiness = swappiness;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getTmpfs}
             * @param tmpfs The container path, mount options, and size (in MiB) of the <code>tmpfs</code> mount.
             *              This parameter maps to the <code>--tmpfs</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             *              <p>
             *              <blockquote>
             *              <p>
             *              This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide this parameter for this resource type.
             *              <p>
             *              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tmpfs(software.amazon.awscdk.IResolvable tmpfs) {
                this.tmpfs = tmpfs;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getTmpfs}
             * @param tmpfs The container path, mount options, and size (in MiB) of the <code>tmpfs</code> mount.
             *              This parameter maps to the <code>--tmpfs</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             *              <p>
             *              <blockquote>
             *              <p>
             *              This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide this parameter for this resource type.
             *              <p>
             *              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tmpfs(java.util.List<? extends java.lang.Object> tmpfs) {
                this.tmpfs = tmpfs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LinuxParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LinuxParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LinuxParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LinuxParametersProperty {
            private final java.lang.Object devices;
            private final java.lang.Object initProcessEnabled;
            private final java.lang.Number maxSwap;
            private final java.lang.Number sharedMemorySize;
            private final java.lang.Number swappiness;
            private final java.lang.Object tmpfs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.devices = software.amazon.jsii.Kernel.get(this, "devices", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.initProcessEnabled = software.amazon.jsii.Kernel.get(this, "initProcessEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxSwap = software.amazon.jsii.Kernel.get(this, "maxSwap", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sharedMemorySize = software.amazon.jsii.Kernel.get(this, "sharedMemorySize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.swappiness = software.amazon.jsii.Kernel.get(this, "swappiness", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.tmpfs = software.amazon.jsii.Kernel.get(this, "tmpfs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.devices = builder.devices;
                this.initProcessEnabled = builder.initProcessEnabled;
                this.maxSwap = builder.maxSwap;
                this.sharedMemorySize = builder.sharedMemorySize;
                this.swappiness = builder.swappiness;
                this.tmpfs = builder.tmpfs;
            }

            @Override
            public final java.lang.Object getDevices() {
                return this.devices;
            }

            @Override
            public final java.lang.Object getInitProcessEnabled() {
                return this.initProcessEnabled;
            }

            @Override
            public final java.lang.Number getMaxSwap() {
                return this.maxSwap;
            }

            @Override
            public final java.lang.Number getSharedMemorySize() {
                return this.sharedMemorySize;
            }

            @Override
            public final java.lang.Number getSwappiness() {
                return this.swappiness;
            }

            @Override
            public final java.lang.Object getTmpfs() {
                return this.tmpfs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDevices() != null) {
                    data.set("devices", om.valueToTree(this.getDevices()));
                }
                if (this.getInitProcessEnabled() != null) {
                    data.set("initProcessEnabled", om.valueToTree(this.getInitProcessEnabled()));
                }
                if (this.getMaxSwap() != null) {
                    data.set("maxSwap", om.valueToTree(this.getMaxSwap()));
                }
                if (this.getSharedMemorySize() != null) {
                    data.set("sharedMemorySize", om.valueToTree(this.getSharedMemorySize()));
                }
                if (this.getSwappiness() != null) {
                    data.set("swappiness", om.valueToTree(this.getSwappiness()));
                }
                if (this.getTmpfs() != null) {
                    data.set("tmpfs", om.valueToTree(this.getTmpfs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.LinuxParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LinuxParametersProperty.Jsii$Proxy that = (LinuxParametersProperty.Jsii$Proxy) o;

                if (this.devices != null ? !this.devices.equals(that.devices) : that.devices != null) return false;
                if (this.initProcessEnabled != null ? !this.initProcessEnabled.equals(that.initProcessEnabled) : that.initProcessEnabled != null) return false;
                if (this.maxSwap != null ? !this.maxSwap.equals(that.maxSwap) : that.maxSwap != null) return false;
                if (this.sharedMemorySize != null ? !this.sharedMemorySize.equals(that.sharedMemorySize) : that.sharedMemorySize != null) return false;
                if (this.swappiness != null ? !this.swappiness.equals(that.swappiness) : that.swappiness != null) return false;
                return this.tmpfs != null ? this.tmpfs.equals(that.tmpfs) : that.tmpfs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.devices != null ? this.devices.hashCode() : 0;
                result = 31 * result + (this.initProcessEnabled != null ? this.initProcessEnabled.hashCode() : 0);
                result = 31 * result + (this.maxSwap != null ? this.maxSwap.hashCode() : 0);
                result = 31 * result + (this.sharedMemorySize != null ? this.sharedMemorySize.hashCode() : 0);
                result = 31 * result + (this.swappiness != null ? this.swappiness.hashCode() : 0);
                result = 31 * result + (this.tmpfs != null ? this.tmpfs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Log configuration options to send to a custom log driver for the container.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * Object options;
     * LogConfigurationProperty logConfigurationProperty = LogConfigurationProperty.builder()
     *         .logDriver("logDriver")
     *         // the properties below are optional
     *         .options(options)
     *         .secretOptions(List.of(SecretProperty.builder()
     *                 .name("name")
     *                 .valueFrom("valueFrom")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-logconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-logconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.LogConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LogConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The log driver to use for the container.
         * <p>
         * The valid values that are listed for this parameter are log drivers that the Amazon ECS container agent can communicate with by default.
         * <p>
         * The supported log drivers are <code>awslogs</code> , <code>fluentd</code> , <code>gelf</code> , <code>json-file</code> , <code>journald</code> , <code>logentries</code> , <code>syslog</code> , and <code>splunk</code> .
         * <p>
         * <blockquote>
         * <p>
         * Jobs that are running on Fargate resources are restricted to the <code>awslogs</code> and <code>splunk</code> log drivers.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><strong>awslogs</strong> - Specifies the Amazon CloudWatch Logs logging driver. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/using_awslogs.html">Using the awslogs log driver</a> in the <em>AWS Batch User Guide</em> and <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/awslogs/">Amazon CloudWatch Logs logging driver</a> in the Docker documentation.</li>
         * <li><strong>fluentd</strong> - Specifies the Fluentd logging driver. For more information including usage and options, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/fluentd/">Fluentd logging driver</a> in the <em>Docker documentation</em> .</li>
         * <li><strong>gelf</strong> - Specifies the Graylog Extended Format (GELF) logging driver. For more information including usage and options, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/gelf/">Graylog Extended Format logging driver</a> in the <em>Docker documentation</em> .</li>
         * <li><strong>journald</strong> - Specifies the journald logging driver. For more information including usage and options, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/journald/">Journald logging driver</a> in the <em>Docker documentation</em> .</li>
         * <li><strong>json-file</strong> - Specifies the JSON file logging driver. For more information including usage and options, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/json-file/">JSON File logging driver</a> in the <em>Docker documentation</em> .</li>
         * <li><strong>splunk</strong> - Specifies the Splunk logging driver. For more information including usage and options, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/splunk/">Splunk logging driver</a> in the <em>Docker documentation</em> .</li>
         * <li><strong>syslog</strong> - Specifies the syslog logging driver. For more information including usage and options, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/syslog/">Syslog logging driver</a> in the <em>Docker documentation</em> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you have a custom driver that's not listed earlier that you want to work with the Amazon ECS container agent, you can fork the Amazon ECS container agent project that's <a href="https://docs.aws.amazon.com/https://github.com/aws/amazon-ecs-agent">available on GitHub</a> and customize it to work with that driver. We encourage you to submit pull requests for changes that you want to have included. However, Amazon Web Services doesn't currently support running modified copies of this software.
         * <p>
         * </blockquote>
         * <p>
         * This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-logconfiguration.html#cfn-batch-jobdefinition-logconfiguration-logdriver">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-logconfiguration.html#cfn-batch-jobdefinition-logconfiguration-logdriver</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogDriver();

        /**
         * The configuration options to send to the log driver.
         * <p>
         * This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-logconfiguration.html#cfn-batch-jobdefinition-logconfiguration-options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-logconfiguration.html#cfn-batch-jobdefinition-logconfiguration-options</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOptions() {
            return null;
        }

        /**
         * The secrets to pass to the log configuration.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-logconfiguration.html#cfn-batch-jobdefinition-logconfiguration-secretoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-logconfiguration.html#cfn-batch-jobdefinition-logconfiguration-secretoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecretOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogConfigurationProperty> {
            java.lang.String logDriver;
            java.lang.Object options;
            java.lang.Object secretOptions;

            /**
             * Sets the value of {@link LogConfigurationProperty#getLogDriver}
             * @param logDriver The log driver to use for the container. This parameter is required.
             *                  The valid values that are listed for this parameter are log drivers that the Amazon ECS container agent can communicate with by default.
             *                  <p>
             *                  The supported log drivers are <code>awslogs</code> , <code>fluentd</code> , <code>gelf</code> , <code>json-file</code> , <code>journald</code> , <code>logentries</code> , <code>syslog</code> , and <code>splunk</code> .
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  Jobs that are running on Fargate resources are restricted to the <code>awslogs</code> and <code>splunk</code> log drivers.
             *                  <p>
             *                  </blockquote>
             *                  <p>
             *                  <ul>
             *                  <li><strong>awslogs</strong> - Specifies the Amazon CloudWatch Logs logging driver. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/using_awslogs.html">Using the awslogs log driver</a> in the <em>AWS Batch User Guide</em> and <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/awslogs/">Amazon CloudWatch Logs logging driver</a> in the Docker documentation.</li>
             *                  <li><strong>fluentd</strong> - Specifies the Fluentd logging driver. For more information including usage and options, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/fluentd/">Fluentd logging driver</a> in the <em>Docker documentation</em> .</li>
             *                  <li><strong>gelf</strong> - Specifies the Graylog Extended Format (GELF) logging driver. For more information including usage and options, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/gelf/">Graylog Extended Format logging driver</a> in the <em>Docker documentation</em> .</li>
             *                  <li><strong>journald</strong> - Specifies the journald logging driver. For more information including usage and options, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/journald/">Journald logging driver</a> in the <em>Docker documentation</em> .</li>
             *                  <li><strong>json-file</strong> - Specifies the JSON file logging driver. For more information including usage and options, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/json-file/">JSON File logging driver</a> in the <em>Docker documentation</em> .</li>
             *                  <li><strong>splunk</strong> - Specifies the Splunk logging driver. For more information including usage and options, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/splunk/">Splunk logging driver</a> in the <em>Docker documentation</em> .</li>
             *                  <li><strong>syslog</strong> - Specifies the syslog logging driver. For more information including usage and options, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/syslog/">Syslog logging driver</a> in the <em>Docker documentation</em> .</li>
             *                  </ul>
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  If you have a custom driver that's not listed earlier that you want to work with the Amazon ECS container agent, you can fork the Amazon ECS container agent project that's <a href="https://docs.aws.amazon.com/https://github.com/aws/amazon-ecs-agent">available on GitHub</a> and customize it to work with that driver. We encourage you to submit pull requests for changes that you want to have included. However, Amazon Web Services doesn't currently support running modified copies of this software.
             *                  <p>
             *                  </blockquote>
             *                  <p>
             *                  This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logDriver(java.lang.String logDriver) {
                this.logDriver = logDriver;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigurationProperty#getOptions}
             * @param options The configuration options to send to the log driver.
             *                This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(java.lang.Object options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigurationProperty#getSecretOptions}
             * @param secretOptions The secrets to pass to the log configuration.
             *                      For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <em>AWS Batch User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretOptions(software.amazon.awscdk.IResolvable secretOptions) {
                this.secretOptions = secretOptions;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigurationProperty#getSecretOptions}
             * @param secretOptions The secrets to pass to the log configuration.
             *                      For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <em>AWS Batch User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretOptions(java.util.List<? extends java.lang.Object> secretOptions) {
                this.secretOptions = secretOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogConfigurationProperty {
            private final java.lang.String logDriver;
            private final java.lang.Object options;
            private final java.lang.Object secretOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logDriver = software.amazon.jsii.Kernel.get(this, "logDriver", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secretOptions = software.amazon.jsii.Kernel.get(this, "secretOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logDriver = java.util.Objects.requireNonNull(builder.logDriver, "logDriver is required");
                this.options = builder.options;
                this.secretOptions = builder.secretOptions;
            }

            @Override
            public final java.lang.String getLogDriver() {
                return this.logDriver;
            }

            @Override
            public final java.lang.Object getOptions() {
                return this.options;
            }

            @Override
            public final java.lang.Object getSecretOptions() {
                return this.secretOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("logDriver", om.valueToTree(this.getLogDriver()));
                if (this.getOptions() != null) {
                    data.set("options", om.valueToTree(this.getOptions()));
                }
                if (this.getSecretOptions() != null) {
                    data.set("secretOptions", om.valueToTree(this.getSecretOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.LogConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogConfigurationProperty.Jsii$Proxy that = (LogConfigurationProperty.Jsii$Proxy) o;

                if (!logDriver.equals(that.logDriver)) return false;
                if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
                return this.secretOptions != null ? this.secretOptions.equals(that.secretOptions) : that.secretOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.logDriver.hashCode();
                result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
                result = 31 * result + (this.secretOptions != null ? this.secretOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * Object labels;
     * MetadataProperty metadataProperty = MetadataProperty.builder()
     *         .labels(labels)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-metadata.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-metadata.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.MetadataProperty")
    @software.amazon.jsii.Jsii.Proxy(MetadataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetadataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-metadata.html#cfn-batch-jobdefinition-metadata-labels">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-metadata.html#cfn-batch-jobdefinition-metadata-labels</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLabels() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetadataProperty> {
            java.lang.Object labels;

            /**
             * Sets the value of {@link MetadataProperty#getLabels}
             * @param labels the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder labels(java.lang.Object labels) {
                this.labels = labels;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetadataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetadataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetadataProperty {
            private final java.lang.Object labels;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.labels = software.amazon.jsii.Kernel.get(this, "labels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.labels = builder.labels;
            }

            @Override
            public final java.lang.Object getLabels() {
                return this.labels;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLabels() != null) {
                    data.set("labels", om.valueToTree(this.getLabels()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.MetadataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetadataProperty.Jsii$Proxy that = (MetadataProperty.Jsii$Proxy) o;

                return this.labels != null ? this.labels.equals(that.labels) : that.labels == null;
            }

            @Override
            public final int hashCode() {
                int result = this.labels != null ? this.labels.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Details for a Docker volume mount point that's used in a job's container properties.
     * <p>
     * This parameter maps to <code>Volumes</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.43/#tag/Container/operation/ContainerCreate">Create a container</a> section of the <em>Docker Remote API</em> and the <code>--volume</code> option to docker run.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * MountPointProperty mountPointProperty = MountPointProperty.builder()
     *         .containerPath("containerPath")
     *         .readOnly(false)
     *         .sourceVolume("sourceVolume")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoint.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.MountPointProperty")
    @software.amazon.jsii.Jsii.Proxy(MountPointProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MountPointProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The path on the container where the host volume is mounted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoint.html#cfn-batch-jobdefinition-mountpoint-containerpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoint.html#cfn-batch-jobdefinition-mountpoint-containerpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContainerPath() {
            return null;
        }

        /**
         * If this value is <code>true</code> , the container has read-only access to the volume.
         * <p>
         * Otherwise, the container can write to the volume. The default value is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoint.html#cfn-batch-jobdefinition-mountpoint-readonly">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoint.html#cfn-batch-jobdefinition-mountpoint-readonly</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadOnly() {
            return null;
        }

        /**
         * The name of the volume to mount.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoint.html#cfn-batch-jobdefinition-mountpoint-sourcevolume">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoint.html#cfn-batch-jobdefinition-mountpoint-sourcevolume</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceVolume() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MountPointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MountPointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MountPointProperty> {
            java.lang.String containerPath;
            java.lang.Object readOnly;
            java.lang.String sourceVolume;

            /**
             * Sets the value of {@link MountPointProperty#getContainerPath}
             * @param containerPath The path on the container where the host volume is mounted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPath(java.lang.String containerPath) {
                this.containerPath = containerPath;
                return this;
            }

            /**
             * Sets the value of {@link MountPointProperty#getReadOnly}
             * @param readOnly If this value is <code>true</code> , the container has read-only access to the volume.
             *                 Otherwise, the container can write to the volume. The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(java.lang.Boolean readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Sets the value of {@link MountPointProperty#getReadOnly}
             * @param readOnly If this value is <code>true</code> , the container has read-only access to the volume.
             *                 Otherwise, the container can write to the volume. The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(software.amazon.awscdk.IResolvable readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Sets the value of {@link MountPointProperty#getSourceVolume}
             * @param sourceVolume The name of the volume to mount.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceVolume(java.lang.String sourceVolume) {
                this.sourceVolume = sourceVolume;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MountPointProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MountPointProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MountPointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MountPointProperty {
            private final java.lang.String containerPath;
            private final java.lang.Object readOnly;
            private final java.lang.String sourceVolume;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerPath = software.amazon.jsii.Kernel.get(this, "containerPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.readOnly = software.amazon.jsii.Kernel.get(this, "readOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceVolume = software.amazon.jsii.Kernel.get(this, "sourceVolume", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerPath = builder.containerPath;
                this.readOnly = builder.readOnly;
                this.sourceVolume = builder.sourceVolume;
            }

            @Override
            public final java.lang.String getContainerPath() {
                return this.containerPath;
            }

            @Override
            public final java.lang.Object getReadOnly() {
                return this.readOnly;
            }

            @Override
            public final java.lang.String getSourceVolume() {
                return this.sourceVolume;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainerPath() != null) {
                    data.set("containerPath", om.valueToTree(this.getContainerPath()));
                }
                if (this.getReadOnly() != null) {
                    data.set("readOnly", om.valueToTree(this.getReadOnly()));
                }
                if (this.getSourceVolume() != null) {
                    data.set("sourceVolume", om.valueToTree(this.getSourceVolume()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.MountPointProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MountPointProperty.Jsii$Proxy that = (MountPointProperty.Jsii$Proxy) o;

                if (this.containerPath != null ? !this.containerPath.equals(that.containerPath) : that.containerPath != null) return false;
                if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) return false;
                return this.sourceVolume != null ? this.sourceVolume.equals(that.sourceVolume) : that.sourceVolume == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerPath != null ? this.containerPath.hashCode() : 0;
                result = 31 * result + (this.readOnly != null ? this.readOnly.hashCode() : 0);
                result = 31 * result + (this.sourceVolume != null ? this.sourceVolume.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * MountPointsProperty mountPointsProperty = MountPointsProperty.builder()
     *         .containerPath("containerPath")
     *         .readOnly(false)
     *         .sourceVolume("sourceVolume")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoints.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoints.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.MountPointsProperty")
    @software.amazon.jsii.Jsii.Proxy(MountPointsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MountPointsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoints.html#cfn-batch-jobdefinition-mountpoints-containerpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoints.html#cfn-batch-jobdefinition-mountpoints-containerpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContainerPath() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoints.html#cfn-batch-jobdefinition-mountpoints-readonly">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoints.html#cfn-batch-jobdefinition-mountpoints-readonly</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadOnly() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoints.html#cfn-batch-jobdefinition-mountpoints-sourcevolume">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoints.html#cfn-batch-jobdefinition-mountpoints-sourcevolume</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceVolume() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MountPointsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MountPointsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MountPointsProperty> {
            java.lang.String containerPath;
            java.lang.Object readOnly;
            java.lang.String sourceVolume;

            /**
             * Sets the value of {@link MountPointsProperty#getContainerPath}
             * @param containerPath the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPath(java.lang.String containerPath) {
                this.containerPath = containerPath;
                return this;
            }

            /**
             * Sets the value of {@link MountPointsProperty#getReadOnly}
             * @param readOnly the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(java.lang.Boolean readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Sets the value of {@link MountPointsProperty#getReadOnly}
             * @param readOnly the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(software.amazon.awscdk.IResolvable readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Sets the value of {@link MountPointsProperty#getSourceVolume}
             * @param sourceVolume the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceVolume(java.lang.String sourceVolume) {
                this.sourceVolume = sourceVolume;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MountPointsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MountPointsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MountPointsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MountPointsProperty {
            private final java.lang.String containerPath;
            private final java.lang.Object readOnly;
            private final java.lang.String sourceVolume;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerPath = software.amazon.jsii.Kernel.get(this, "containerPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.readOnly = software.amazon.jsii.Kernel.get(this, "readOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceVolume = software.amazon.jsii.Kernel.get(this, "sourceVolume", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerPath = builder.containerPath;
                this.readOnly = builder.readOnly;
                this.sourceVolume = builder.sourceVolume;
            }

            @Override
            public final java.lang.String getContainerPath() {
                return this.containerPath;
            }

            @Override
            public final java.lang.Object getReadOnly() {
                return this.readOnly;
            }

            @Override
            public final java.lang.String getSourceVolume() {
                return this.sourceVolume;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainerPath() != null) {
                    data.set("containerPath", om.valueToTree(this.getContainerPath()));
                }
                if (this.getReadOnly() != null) {
                    data.set("readOnly", om.valueToTree(this.getReadOnly()));
                }
                if (this.getSourceVolume() != null) {
                    data.set("sourceVolume", om.valueToTree(this.getSourceVolume()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.MountPointsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MountPointsProperty.Jsii$Proxy that = (MountPointsProperty.Jsii$Proxy) o;

                if (this.containerPath != null ? !this.containerPath.equals(that.containerPath) : that.containerPath != null) return false;
                if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) return false;
                return this.sourceVolume != null ? this.sourceVolume.equals(that.sourceVolume) : that.sourceVolume == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerPath != null ? this.containerPath.hashCode() : 0;
                result = 31 * result + (this.readOnly != null ? this.readOnly.hashCode() : 0);
                result = 31 * result + (this.sourceVolume != null ? this.sourceVolume.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that contains the properties for the Amazon ECS resources of a job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * Object options;
     * MultiNodeEcsPropertiesProperty multiNodeEcsPropertiesProperty = MultiNodeEcsPropertiesProperty.builder()
     *         .taskProperties(List.of(MultiNodeEcsTaskPropertiesProperty.builder()
     *                 .containers(List.of(TaskContainerPropertiesProperty.builder()
     *                         .image("image")
     *                         // the properties below are optional
     *                         .command(List.of("command"))
     *                         .dependsOn(List.of(TaskContainerDependencyProperty.builder()
     *                                 .condition("condition")
     *                                 .containerName("containerName")
     *                                 .build()))
     *                         .environment(List.of(EnvironmentProperty.builder()
     *                                 .name("name")
     *                                 .value("value")
     *                                 .build()))
     *                         .essential(false)
     *                         .linuxParameters(LinuxParametersProperty.builder()
     *                                 .devices(List.of(DeviceProperty.builder()
     *                                         .containerPath("containerPath")
     *                                         .hostPath("hostPath")
     *                                         .permissions(List.of("permissions"))
     *                                         .build()))
     *                                 .initProcessEnabled(false)
     *                                 .maxSwap(123)
     *                                 .sharedMemorySize(123)
     *                                 .swappiness(123)
     *                                 .tmpfs(List.of(TmpfsProperty.builder()
     *                                         .containerPath("containerPath")
     *                                         .size(123)
     *                                         // the properties below are optional
     *                                         .mountOptions(List.of("mountOptions"))
     *                                         .build()))
     *                                 .build())
     *                         .logConfiguration(LogConfigurationProperty.builder()
     *                                 .logDriver("logDriver")
     *                                 // the properties below are optional
     *                                 .options(options)
     *                                 .secretOptions(List.of(SecretProperty.builder()
     *                                         .name("name")
     *                                         .valueFrom("valueFrom")
     *                                         .build()))
     *                                 .build())
     *                         .mountPoints(List.of(MountPointProperty.builder()
     *                                 .containerPath("containerPath")
     *                                 .readOnly(false)
     *                                 .sourceVolume("sourceVolume")
     *                                 .build()))
     *                         .name("name")
     *                         .privileged(false)
     *                         .readonlyRootFilesystem(false)
     *                         .repositoryCredentials(RepositoryCredentialsProperty.builder()
     *                                 .credentialsParameter("credentialsParameter")
     *                                 .build())
     *                         .resourceRequirements(List.of(ResourceRequirementProperty.builder()
     *                                 .type("type")
     *                                 .value("value")
     *                                 .build()))
     *                         .secrets(List.of(SecretProperty.builder()
     *                                 .name("name")
     *                                 .valueFrom("valueFrom")
     *                                 .build()))
     *                         .ulimits(List.of(UlimitProperty.builder()
     *                                 .hardLimit(123)
     *                                 .name("name")
     *                                 .softLimit(123)
     *                                 .build()))
     *                         .user("user")
     *                         .build()))
     *                 .executionRoleArn("executionRoleArn")
     *                 .ipcMode("ipcMode")
     *                 .pidMode("pidMode")
     *                 .taskRoleArn("taskRoleArn")
     *                 .volumes(List.of(VolumesProperty.builder()
     *                         .efsVolumeConfiguration(EfsVolumeConfigurationProperty.builder()
     *                                 .fileSystemId("fileSystemId")
     *                                 // the properties below are optional
     *                                 .authorizationConfig(AuthorizationConfigProperty.builder()
     *                                         .accessPointId("accessPointId")
     *                                         .iam("iam")
     *                                         .build())
     *                                 .rootDirectory("rootDirectory")
     *                                 .transitEncryption("transitEncryption")
     *                                 .transitEncryptionPort(123)
     *                                 .build())
     *                         .host(VolumesHostProperty.builder()
     *                                 .sourcePath("sourcePath")
     *                                 .build())
     *                         .name("name")
     *                         .build()))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-multinodeecsproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-multinodeecsproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.MultiNodeEcsPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(MultiNodeEcsPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MultiNodeEcsPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that contains the properties for the Amazon ECS task definition of a job.
         * <p>
         * <blockquote>
         * <p>
         * This object is currently limited to one task element. However, the task element can run up to 10 containers.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-multinodeecsproperties.html#cfn-batch-jobdefinition-multinodeecsproperties-taskproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-multinodeecsproperties.html#cfn-batch-jobdefinition-multinodeecsproperties-taskproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTaskProperties();

        /**
         * @return a {@link Builder} of {@link MultiNodeEcsPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MultiNodeEcsPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MultiNodeEcsPropertiesProperty> {
            java.lang.Object taskProperties;

            /**
             * Sets the value of {@link MultiNodeEcsPropertiesProperty#getTaskProperties}
             * @param taskProperties An object that contains the properties for the Amazon ECS task definition of a job. This parameter is required.
             *                       <blockquote>
             *                       <p>
             *                       This object is currently limited to one task element. However, the task element can run up to 10 containers.
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskProperties(software.amazon.awscdk.IResolvable taskProperties) {
                this.taskProperties = taskProperties;
                return this;
            }

            /**
             * Sets the value of {@link MultiNodeEcsPropertiesProperty#getTaskProperties}
             * @param taskProperties An object that contains the properties for the Amazon ECS task definition of a job. This parameter is required.
             *                       <blockquote>
             *                       <p>
             *                       This object is currently limited to one task element. However, the task element can run up to 10 containers.
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskProperties(java.util.List<? extends java.lang.Object> taskProperties) {
                this.taskProperties = taskProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MultiNodeEcsPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MultiNodeEcsPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MultiNodeEcsPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MultiNodeEcsPropertiesProperty {
            private final java.lang.Object taskProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.taskProperties = software.amazon.jsii.Kernel.get(this, "taskProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.taskProperties = java.util.Objects.requireNonNull(builder.taskProperties, "taskProperties is required");
            }

            @Override
            public final java.lang.Object getTaskProperties() {
                return this.taskProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("taskProperties", om.valueToTree(this.getTaskProperties()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.MultiNodeEcsPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MultiNodeEcsPropertiesProperty.Jsii$Proxy that = (MultiNodeEcsPropertiesProperty.Jsii$Proxy) o;

                return this.taskProperties.equals(that.taskProperties);
            }

            @Override
            public final int hashCode() {
                int result = this.taskProperties.hashCode();
                return result;
            }
        }
    }
    /**
     * The properties for a task definition that describes the container and volume definitions of an Amazon ECS task.
     * <p>
     * You can specify which Docker images to use, the required resources, and other configurations related to launching the task definition through an Amazon ECS service or task.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * Object options;
     * MultiNodeEcsTaskPropertiesProperty multiNodeEcsTaskPropertiesProperty = MultiNodeEcsTaskPropertiesProperty.builder()
     *         .containers(List.of(TaskContainerPropertiesProperty.builder()
     *                 .image("image")
     *                 // the properties below are optional
     *                 .command(List.of("command"))
     *                 .dependsOn(List.of(TaskContainerDependencyProperty.builder()
     *                         .condition("condition")
     *                         .containerName("containerName")
     *                         .build()))
     *                 .environment(List.of(EnvironmentProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .essential(false)
     *                 .linuxParameters(LinuxParametersProperty.builder()
     *                         .devices(List.of(DeviceProperty.builder()
     *                                 .containerPath("containerPath")
     *                                 .hostPath("hostPath")
     *                                 .permissions(List.of("permissions"))
     *                                 .build()))
     *                         .initProcessEnabled(false)
     *                         .maxSwap(123)
     *                         .sharedMemorySize(123)
     *                         .swappiness(123)
     *                         .tmpfs(List.of(TmpfsProperty.builder()
     *                                 .containerPath("containerPath")
     *                                 .size(123)
     *                                 // the properties below are optional
     *                                 .mountOptions(List.of("mountOptions"))
     *                                 .build()))
     *                         .build())
     *                 .logConfiguration(LogConfigurationProperty.builder()
     *                         .logDriver("logDriver")
     *                         // the properties below are optional
     *                         .options(options)
     *                         .secretOptions(List.of(SecretProperty.builder()
     *                                 .name("name")
     *                                 .valueFrom("valueFrom")
     *                                 .build()))
     *                         .build())
     *                 .mountPoints(List.of(MountPointProperty.builder()
     *                         .containerPath("containerPath")
     *                         .readOnly(false)
     *                         .sourceVolume("sourceVolume")
     *                         .build()))
     *                 .name("name")
     *                 .privileged(false)
     *                 .readonlyRootFilesystem(false)
     *                 .repositoryCredentials(RepositoryCredentialsProperty.builder()
     *                         .credentialsParameter("credentialsParameter")
     *                         .build())
     *                 .resourceRequirements(List.of(ResourceRequirementProperty.builder()
     *                         .type("type")
     *                         .value("value")
     *                         .build()))
     *                 .secrets(List.of(SecretProperty.builder()
     *                         .name("name")
     *                         .valueFrom("valueFrom")
     *                         .build()))
     *                 .ulimits(List.of(UlimitProperty.builder()
     *                         .hardLimit(123)
     *                         .name("name")
     *                         .softLimit(123)
     *                         .build()))
     *                 .user("user")
     *                 .build()))
     *         .executionRoleArn("executionRoleArn")
     *         .ipcMode("ipcMode")
     *         .pidMode("pidMode")
     *         .taskRoleArn("taskRoleArn")
     *         .volumes(List.of(VolumesProperty.builder()
     *                 .efsVolumeConfiguration(EfsVolumeConfigurationProperty.builder()
     *                         .fileSystemId("fileSystemId")
     *                         // the properties below are optional
     *                         .authorizationConfig(AuthorizationConfigProperty.builder()
     *                                 .accessPointId("accessPointId")
     *                                 .iam("iam")
     *                                 .build())
     *                         .rootDirectory("rootDirectory")
     *                         .transitEncryption("transitEncryption")
     *                         .transitEncryptionPort(123)
     *                         .build())
     *                 .host(VolumesHostProperty.builder()
     *                         .sourcePath("sourcePath")
     *                         .build())
     *                 .name("name")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-multinodeecstaskproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-multinodeecstaskproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.MultiNodeEcsTaskPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(MultiNodeEcsTaskPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MultiNodeEcsTaskPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This object is a list of containers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-multinodeecstaskproperties.html#cfn-batch-jobdefinition-multinodeecstaskproperties-containers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-multinodeecstaskproperties.html#cfn-batch-jobdefinition-multinodeecstaskproperties-containers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContainers() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume.
         * <p>
         * For jobs that run on Fargate resources, you must provide an execution role. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html">AWS Batch execution IAM role</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-multinodeecstaskproperties.html#cfn-batch-jobdefinition-multinodeecstaskproperties-executionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-multinodeecstaskproperties.html#cfn-batch-jobdefinition-multinodeecstaskproperties-executionrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExecutionRoleArn() {
            return null;
        }

        /**
         * The IPC resource namespace to use for the containers in the task.
         * <p>
         * The valid values are <code>host</code> , <code>task</code> , or <code>none</code> .
         * <p>
         * If <code>host</code> is specified, all containers within the tasks that specified the <code>host</code> IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance.
         * <p>
         * If <code>task</code> is specified, all containers within the specified <code>task</code> share the same IPC resources.
         * <p>
         * If <code>none</code> is specified, the IPC resources within the containers of a task are private, and are not shared with other containers in a task or on the container instance.
         * <p>
         * If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#ipc-settings---ipc">IPC settings</a> in the Docker run reference.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-multinodeecstaskproperties.html#cfn-batch-jobdefinition-multinodeecstaskproperties-ipcmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-multinodeecstaskproperties.html#cfn-batch-jobdefinition-multinodeecstaskproperties-ipcmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIpcMode() {
            return null;
        }

        /**
         * The process namespace to use for the containers in the task.
         * <p>
         * The valid values are <code>host</code> or <code>task</code> . For example, monitoring sidecars might need <code>pidMode</code> to access information about other containers running in the same task.
         * <p>
         * If <code>host</code> is specified, all containers within the tasks that specified the <code>host</code> PID mode on the same container instance share the process namespace with the host Amazon EC2 instance.
         * <p>
         * If <code>task</code> is specified, all containers within the specified task share the same process namespace.
         * <p>
         * If no value is specified, the default is a private namespace for each container. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#pid-settings---pid">PID settings</a> in the Docker run reference.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-multinodeecstaskproperties.html#cfn-batch-jobdefinition-multinodeecstaskproperties-pidmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-multinodeecstaskproperties.html#cfn-batch-jobdefinition-multinodeecstaskproperties-pidmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPidMode() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) that's associated with the Amazon ECS task.
         * <p>
         * <blockquote>
         * <p>
         * This is object is comparable to <a href="https://docs.aws.amazon.com/batch/latest/APIReference/API_ContainerProperties.html">ContainerProperties:jobRoleArn</a> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-multinodeecstaskproperties.html#cfn-batch-jobdefinition-multinodeecstaskproperties-taskrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-multinodeecstaskproperties.html#cfn-batch-jobdefinition-multinodeecstaskproperties-taskrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTaskRoleArn() {
            return null;
        }

        /**
         * A list of volumes that are associated with the job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-multinodeecstaskproperties.html#cfn-batch-jobdefinition-multinodeecstaskproperties-volumes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-multinodeecstaskproperties.html#cfn-batch-jobdefinition-multinodeecstaskproperties-volumes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVolumes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MultiNodeEcsTaskPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MultiNodeEcsTaskPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MultiNodeEcsTaskPropertiesProperty> {
            java.lang.Object containers;
            java.lang.String executionRoleArn;
            java.lang.String ipcMode;
            java.lang.String pidMode;
            java.lang.String taskRoleArn;
            java.lang.Object volumes;

            /**
             * Sets the value of {@link MultiNodeEcsTaskPropertiesProperty#getContainers}
             * @param containers This object is a list of containers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containers(software.amazon.awscdk.IResolvable containers) {
                this.containers = containers;
                return this;
            }

            /**
             * Sets the value of {@link MultiNodeEcsTaskPropertiesProperty#getContainers}
             * @param containers This object is a list of containers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containers(java.util.List<? extends java.lang.Object> containers) {
                this.containers = containers;
                return this;
            }

            /**
             * Sets the value of {@link MultiNodeEcsTaskPropertiesProperty#getExecutionRoleArn}
             * @param executionRoleArn The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume.
             *                         For jobs that run on Fargate resources, you must provide an execution role. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html">AWS Batch execution IAM role</a> in the <em>AWS Batch User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionRoleArn(java.lang.String executionRoleArn) {
                this.executionRoleArn = executionRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link MultiNodeEcsTaskPropertiesProperty#getIpcMode}
             * @param ipcMode The IPC resource namespace to use for the containers in the task.
             *                The valid values are <code>host</code> , <code>task</code> , or <code>none</code> .
             *                <p>
             *                If <code>host</code> is specified, all containers within the tasks that specified the <code>host</code> IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance.
             *                <p>
             *                If <code>task</code> is specified, all containers within the specified <code>task</code> share the same IPC resources.
             *                <p>
             *                If <code>none</code> is specified, the IPC resources within the containers of a task are private, and are not shared with other containers in a task or on the container instance.
             *                <p>
             *                If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#ipc-settings---ipc">IPC settings</a> in the Docker run reference.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipcMode(java.lang.String ipcMode) {
                this.ipcMode = ipcMode;
                return this;
            }

            /**
             * Sets the value of {@link MultiNodeEcsTaskPropertiesProperty#getPidMode}
             * @param pidMode The process namespace to use for the containers in the task.
             *                The valid values are <code>host</code> or <code>task</code> . For example, monitoring sidecars might need <code>pidMode</code> to access information about other containers running in the same task.
             *                <p>
             *                If <code>host</code> is specified, all containers within the tasks that specified the <code>host</code> PID mode on the same container instance share the process namespace with the host Amazon EC2 instance.
             *                <p>
             *                If <code>task</code> is specified, all containers within the specified task share the same process namespace.
             *                <p>
             *                If no value is specified, the default is a private namespace for each container. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#pid-settings---pid">PID settings</a> in the Docker run reference.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pidMode(java.lang.String pidMode) {
                this.pidMode = pidMode;
                return this;
            }

            /**
             * Sets the value of {@link MultiNodeEcsTaskPropertiesProperty#getTaskRoleArn}
             * @param taskRoleArn The Amazon Resource Name (ARN) that's associated with the Amazon ECS task.
             *                    <blockquote>
             *                    <p>
             *                    This is object is comparable to <a href="https://docs.aws.amazon.com/batch/latest/APIReference/API_ContainerProperties.html">ContainerProperties:jobRoleArn</a> .
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskRoleArn(java.lang.String taskRoleArn) {
                this.taskRoleArn = taskRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link MultiNodeEcsTaskPropertiesProperty#getVolumes}
             * @param volumes A list of volumes that are associated with the job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumes(software.amazon.awscdk.IResolvable volumes) {
                this.volumes = volumes;
                return this;
            }

            /**
             * Sets the value of {@link MultiNodeEcsTaskPropertiesProperty#getVolumes}
             * @param volumes A list of volumes that are associated with the job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumes(java.util.List<? extends java.lang.Object> volumes) {
                this.volumes = volumes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MultiNodeEcsTaskPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MultiNodeEcsTaskPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MultiNodeEcsTaskPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MultiNodeEcsTaskPropertiesProperty {
            private final java.lang.Object containers;
            private final java.lang.String executionRoleArn;
            private final java.lang.String ipcMode;
            private final java.lang.String pidMode;
            private final java.lang.String taskRoleArn;
            private final java.lang.Object volumes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containers = software.amazon.jsii.Kernel.get(this, "containers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.executionRoleArn = software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ipcMode = software.amazon.jsii.Kernel.get(this, "ipcMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.pidMode = software.amazon.jsii.Kernel.get(this, "pidMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.taskRoleArn = software.amazon.jsii.Kernel.get(this, "taskRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containers = builder.containers;
                this.executionRoleArn = builder.executionRoleArn;
                this.ipcMode = builder.ipcMode;
                this.pidMode = builder.pidMode;
                this.taskRoleArn = builder.taskRoleArn;
                this.volumes = builder.volumes;
            }

            @Override
            public final java.lang.Object getContainers() {
                return this.containers;
            }

            @Override
            public final java.lang.String getExecutionRoleArn() {
                return this.executionRoleArn;
            }

            @Override
            public final java.lang.String getIpcMode() {
                return this.ipcMode;
            }

            @Override
            public final java.lang.String getPidMode() {
                return this.pidMode;
            }

            @Override
            public final java.lang.String getTaskRoleArn() {
                return this.taskRoleArn;
            }

            @Override
            public final java.lang.Object getVolumes() {
                return this.volumes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainers() != null) {
                    data.set("containers", om.valueToTree(this.getContainers()));
                }
                if (this.getExecutionRoleArn() != null) {
                    data.set("executionRoleArn", om.valueToTree(this.getExecutionRoleArn()));
                }
                if (this.getIpcMode() != null) {
                    data.set("ipcMode", om.valueToTree(this.getIpcMode()));
                }
                if (this.getPidMode() != null) {
                    data.set("pidMode", om.valueToTree(this.getPidMode()));
                }
                if (this.getTaskRoleArn() != null) {
                    data.set("taskRoleArn", om.valueToTree(this.getTaskRoleArn()));
                }
                if (this.getVolumes() != null) {
                    data.set("volumes", om.valueToTree(this.getVolumes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.MultiNodeEcsTaskPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MultiNodeEcsTaskPropertiesProperty.Jsii$Proxy that = (MultiNodeEcsTaskPropertiesProperty.Jsii$Proxy) o;

                if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) return false;
                if (this.executionRoleArn != null ? !this.executionRoleArn.equals(that.executionRoleArn) : that.executionRoleArn != null) return false;
                if (this.ipcMode != null ? !this.ipcMode.equals(that.ipcMode) : that.ipcMode != null) return false;
                if (this.pidMode != null ? !this.pidMode.equals(that.pidMode) : that.pidMode != null) return false;
                if (this.taskRoleArn != null ? !this.taskRoleArn.equals(that.taskRoleArn) : that.taskRoleArn != null) return false;
                return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containers != null ? this.containers.hashCode() : 0;
                result = 31 * result + (this.executionRoleArn != null ? this.executionRoleArn.hashCode() : 0);
                result = 31 * result + (this.ipcMode != null ? this.ipcMode.hashCode() : 0);
                result = 31 * result + (this.pidMode != null ? this.pidMode.hashCode() : 0);
                result = 31 * result + (this.taskRoleArn != null ? this.taskRoleArn.hashCode() : 0);
                result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The network configuration for jobs that are running on Fargate resources.
     * <p>
     * Jobs that are running on Amazon EC2 resources must not specify this parameter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * NetworkConfigurationProperty networkConfigurationProperty = NetworkConfigurationProperty.builder()
     *         .assignPublicIp("assignPublicIp")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-networkconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-networkconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.NetworkConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether the job has a public IP address.
         * <p>
         * For a job that's running on Fargate resources in a private subnet to send outbound traffic to the internet (for example, to pull container images), the private subnet requires a NAT gateway be attached to route requests to the internet. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Amazon ECS task networking</a> in the <em>Amazon Elastic Container Service Developer Guide</em> . The default value is " <code>DISABLED</code> ".
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-networkconfiguration.html#cfn-batch-jobdefinition-networkconfiguration-assignpublicip">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-networkconfiguration.html#cfn-batch-jobdefinition-networkconfiguration-assignpublicip</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAssignPublicIp() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkConfigurationProperty> {
            java.lang.String assignPublicIp;

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getAssignPublicIp}
             * @param assignPublicIp Indicates whether the job has a public IP address.
             *                       For a job that's running on Fargate resources in a private subnet to send outbound traffic to the internet (for example, to pull container images), the private subnet requires a NAT gateway be attached to route requests to the internet. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Amazon ECS task networking</a> in the <em>Amazon Elastic Container Service Developer Guide</em> . The default value is " <code>DISABLED</code> ".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assignPublicIp(java.lang.String assignPublicIp) {
                this.assignPublicIp = assignPublicIp;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkConfigurationProperty {
            private final java.lang.String assignPublicIp;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.assignPublicIp = software.amazon.jsii.Kernel.get(this, "assignPublicIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.assignPublicIp = builder.assignPublicIp;
            }

            @Override
            public final java.lang.String getAssignPublicIp() {
                return this.assignPublicIp;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAssignPublicIp() != null) {
                    data.set("assignPublicIp", om.valueToTree(this.getAssignPublicIp()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.NetworkConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkConfigurationProperty.Jsii$Proxy that = (NetworkConfigurationProperty.Jsii$Proxy) o;

                return this.assignPublicIp != null ? this.assignPublicIp.equals(that.assignPublicIp) : that.assignPublicIp == null;
            }

            @Override
            public final int hashCode() {
                int result = this.assignPublicIp != null ? this.assignPublicIp.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that represents the node properties of a multi-node parallel job.
     * <p>
     * <blockquote>
     * <p>
     * Node properties can't be specified for Amazon EKS based job definitions.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * Object labels;
     * Object limits;
     * Object options;
     * Object requests;
     * NodePropertiesProperty nodePropertiesProperty = NodePropertiesProperty.builder()
     *         .mainNode(123)
     *         .nodeRangeProperties(List.of(NodeRangePropertyProperty.builder()
     *                 .targetNodes("targetNodes")
     *                 // the properties below are optional
     *                 .consumableResourceProperties(ConsumableResourcePropertiesProperty.builder()
     *                         .consumableResourceList(List.of(ConsumableResourceRequirementProperty.builder()
     *                                 .consumableResource("consumableResource")
     *                                 .quantity(123)
     *                                 .build()))
     *                         .build())
     *                 .container(ContainerPropertiesProperty.builder()
     *                         .image("image")
     *                         // the properties below are optional
     *                         .command(List.of("command"))
     *                         .environment(List.of(EnvironmentProperty.builder()
     *                                 .name("name")
     *                                 .value("value")
     *                                 .build()))
     *                         .ephemeralStorage(EphemeralStorageProperty.builder()
     *                                 .sizeInGiB(123)
     *                                 .build())
     *                         .executionRoleArn("executionRoleArn")
     *                         .fargatePlatformConfiguration(FargatePlatformConfigurationProperty.builder()
     *                                 .platformVersion("platformVersion")
     *                                 .build())
     *                         .instanceType("instanceType")
     *                         .jobRoleArn("jobRoleArn")
     *                         .linuxParameters(LinuxParametersProperty.builder()
     *                                 .devices(List.of(DeviceProperty.builder()
     *                                         .containerPath("containerPath")
     *                                         .hostPath("hostPath")
     *                                         .permissions(List.of("permissions"))
     *                                         .build()))
     *                                 .initProcessEnabled(false)
     *                                 .maxSwap(123)
     *                                 .sharedMemorySize(123)
     *                                 .swappiness(123)
     *                                 .tmpfs(List.of(TmpfsProperty.builder()
     *                                         .containerPath("containerPath")
     *                                         .size(123)
     *                                         // the properties below are optional
     *                                         .mountOptions(List.of("mountOptions"))
     *                                         .build()))
     *                                 .build())
     *                         .logConfiguration(LogConfigurationProperty.builder()
     *                                 .logDriver("logDriver")
     *                                 // the properties below are optional
     *                                 .options(options)
     *                                 .secretOptions(List.of(SecretProperty.builder()
     *                                         .name("name")
     *                                         .valueFrom("valueFrom")
     *                                         .build()))
     *                                 .build())
     *                         .memory(123)
     *                         .mountPoints(List.of(MountPointsProperty.builder()
     *                                 .containerPath("containerPath")
     *                                 .readOnly(false)
     *                                 .sourceVolume("sourceVolume")
     *                                 .build()))
     *                         .networkConfiguration(NetworkConfigurationProperty.builder()
     *                                 .assignPublicIp("assignPublicIp")
     *                                 .build())
     *                         .privileged(false)
     *                         .readonlyRootFilesystem(false)
     *                         .repositoryCredentials(RepositoryCredentialsProperty.builder()
     *                                 .credentialsParameter("credentialsParameter")
     *                                 .build())
     *                         .resourceRequirements(List.of(ResourceRequirementProperty.builder()
     *                                 .type("type")
     *                                 .value("value")
     *                                 .build()))
     *                         .runtimePlatform(RuntimePlatformProperty.builder()
     *                                 .cpuArchitecture("cpuArchitecture")
     *                                 .operatingSystemFamily("operatingSystemFamily")
     *                                 .build())
     *                         .secrets(List.of(SecretProperty.builder()
     *                                 .name("name")
     *                                 .valueFrom("valueFrom")
     *                                 .build()))
     *                         .ulimits(List.of(UlimitProperty.builder()
     *                                 .hardLimit(123)
     *                                 .name("name")
     *                                 .softLimit(123)
     *                                 .build()))
     *                         .user("user")
     *                         .vcpus(123)
     *                         .volumes(List.of(VolumesProperty.builder()
     *                                 .efsVolumeConfiguration(EfsVolumeConfigurationProperty.builder()
     *                                         .fileSystemId("fileSystemId")
     *                                         // the properties below are optional
     *                                         .authorizationConfig(AuthorizationConfigProperty.builder()
     *                                                 .accessPointId("accessPointId")
     *                                                 .iam("iam")
     *                                                 .build())
     *                                         .rootDirectory("rootDirectory")
     *                                         .transitEncryption("transitEncryption")
     *                                         .transitEncryptionPort(123)
     *                                         .build())
     *                                 .host(VolumesHostProperty.builder()
     *                                         .sourcePath("sourcePath")
     *                                         .build())
     *                                 .name("name")
     *                                 .build()))
     *                         .build())
     *                 .ecsProperties(MultiNodeEcsPropertiesProperty.builder()
     *                         .taskProperties(List.of(MultiNodeEcsTaskPropertiesProperty.builder()
     *                                 .containers(List.of(TaskContainerPropertiesProperty.builder()
     *                                         .image("image")
     *                                         // the properties below are optional
     *                                         .command(List.of("command"))
     *                                         .dependsOn(List.of(TaskContainerDependencyProperty.builder()
     *                                                 .condition("condition")
     *                                                 .containerName("containerName")
     *                                                 .build()))
     *                                         .environment(List.of(EnvironmentProperty.builder()
     *                                                 .name("name")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .essential(false)
     *                                         .linuxParameters(LinuxParametersProperty.builder()
     *                                                 .devices(List.of(DeviceProperty.builder()
     *                                                         .containerPath("containerPath")
     *                                                         .hostPath("hostPath")
     *                                                         .permissions(List.of("permissions"))
     *                                                         .build()))
     *                                                 .initProcessEnabled(false)
     *                                                 .maxSwap(123)
     *                                                 .sharedMemorySize(123)
     *                                                 .swappiness(123)
     *                                                 .tmpfs(List.of(TmpfsProperty.builder()
     *                                                         .containerPath("containerPath")
     *                                                         .size(123)
     *                                                         // the properties below are optional
     *                                                         .mountOptions(List.of("mountOptions"))
     *                                                         .build()))
     *                                                 .build())
     *                                         .logConfiguration(LogConfigurationProperty.builder()
     *                                                 .logDriver("logDriver")
     *                                                 // the properties below are optional
     *                                                 .options(options)
     *                                                 .secretOptions(List.of(SecretProperty.builder()
     *                                                         .name("name")
     *                                                         .valueFrom("valueFrom")
     *                                                         .build()))
     *                                                 .build())
     *                                         .mountPoints(List.of(MountPointProperty.builder()
     *                                                 .containerPath("containerPath")
     *                                                 .readOnly(false)
     *                                                 .sourceVolume("sourceVolume")
     *                                                 .build()))
     *                                         .name("name")
     *                                         .privileged(false)
     *                                         .readonlyRootFilesystem(false)
     *                                         .repositoryCredentials(RepositoryCredentialsProperty.builder()
     *                                                 .credentialsParameter("credentialsParameter")
     *                                                 .build())
     *                                         .resourceRequirements(List.of(ResourceRequirementProperty.builder()
     *                                                 .type("type")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .secrets(List.of(SecretProperty.builder()
     *                                                 .name("name")
     *                                                 .valueFrom("valueFrom")
     *                                                 .build()))
     *                                         .ulimits(List.of(UlimitProperty.builder()
     *                                                 .hardLimit(123)
     *                                                 .name("name")
     *                                                 .softLimit(123)
     *                                                 .build()))
     *                                         .user("user")
     *                                         .build()))
     *                                 .executionRoleArn("executionRoleArn")
     *                                 .ipcMode("ipcMode")
     *                                 .pidMode("pidMode")
     *                                 .taskRoleArn("taskRoleArn")
     *                                 .volumes(List.of(VolumesProperty.builder()
     *                                         .efsVolumeConfiguration(EfsVolumeConfigurationProperty.builder()
     *                                                 .fileSystemId("fileSystemId")
     *                                                 // the properties below are optional
     *                                                 .authorizationConfig(AuthorizationConfigProperty.builder()
     *                                                         .accessPointId("accessPointId")
     *                                                         .iam("iam")
     *                                                         .build())
     *                                                 .rootDirectory("rootDirectory")
     *                                                 .transitEncryption("transitEncryption")
     *                                                 .transitEncryptionPort(123)
     *                                                 .build())
     *                                         .host(VolumesHostProperty.builder()
     *                                                 .sourcePath("sourcePath")
     *                                                 .build())
     *                                         .name("name")
     *                                         .build()))
     *                                 .build()))
     *                         .build())
     *                 .eksProperties(EksPropertiesProperty.builder()
     *                         .podProperties(PodPropertiesProperty.builder()
     *                                 .containers(List.of(EksContainerProperty.builder()
     *                                         .image("image")
     *                                         // the properties below are optional
     *                                         .args(List.of("args"))
     *                                         .command(List.of("command"))
     *                                         .env(List.of(EksContainerEnvironmentVariableProperty.builder()
     *                                                 .name("name")
     *                                                 // the properties below are optional
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imagePullPolicy("imagePullPolicy")
     *                                         .name("name")
     *                                         .resources(ResourcesProperty.builder()
     *                                                 .limits(limits)
     *                                                 .requests(requests)
     *                                                 .build())
     *                                         .securityContext(SecurityContextProperty.builder()
     *                                                 .allowPrivilegeEscalation(false)
     *                                                 .privileged(false)
     *                                                 .readOnlyRootFilesystem(false)
     *                                                 .runAsGroup(123)
     *                                                 .runAsNonRoot(false)
     *                                                 .runAsUser(123)
     *                                                 .build())
     *                                         .volumeMounts(List.of(EksContainerVolumeMountProperty.builder()
     *                                                 .mountPath("mountPath")
     *                                                 .name("name")
     *                                                 .readOnly(false)
     *                                                 .subPath("subPath")
     *                                                 .build()))
     *                                         .build()))
     *                                 .dnsPolicy("dnsPolicy")
     *                                 .hostNetwork(false)
     *                                 .imagePullSecrets(List.of(ImagePullSecretProperty.builder()
     *                                         .name("name")
     *                                         .build()))
     *                                 .initContainers(List.of(EksContainerProperty.builder()
     *                                         .image("image")
     *                                         // the properties below are optional
     *                                         .args(List.of("args"))
     *                                         .command(List.of("command"))
     *                                         .env(List.of(EksContainerEnvironmentVariableProperty.builder()
     *                                                 .name("name")
     *                                                 // the properties below are optional
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imagePullPolicy("imagePullPolicy")
     *                                         .name("name")
     *                                         .resources(ResourcesProperty.builder()
     *                                                 .limits(limits)
     *                                                 .requests(requests)
     *                                                 .build())
     *                                         .securityContext(SecurityContextProperty.builder()
     *                                                 .allowPrivilegeEscalation(false)
     *                                                 .privileged(false)
     *                                                 .readOnlyRootFilesystem(false)
     *                                                 .runAsGroup(123)
     *                                                 .runAsNonRoot(false)
     *                                                 .runAsUser(123)
     *                                                 .build())
     *                                         .volumeMounts(List.of(EksContainerVolumeMountProperty.builder()
     *                                                 .mountPath("mountPath")
     *                                                 .name("name")
     *                                                 .readOnly(false)
     *                                                 .subPath("subPath")
     *                                                 .build()))
     *                                         .build()))
     *                                 .metadata(MetadataProperty.builder()
     *                                         .labels(labels)
     *                                         .build())
     *                                 .serviceAccountName("serviceAccountName")
     *                                 .shareProcessNamespace(false)
     *                                 .volumes(List.of(EksVolumeProperty.builder()
     *                                         .name("name")
     *                                         // the properties below are optional
     *                                         .emptyDir(EmptyDirProperty.builder()
     *                                                 .medium("medium")
     *                                                 .sizeLimit("sizeLimit")
     *                                                 .build())
     *                                         .hostPath(HostPathProperty.builder()
     *                                                 .path("path")
     *                                                 .build())
     *                                         .persistentVolumeClaim(EksPersistentVolumeClaimProperty.builder()
     *                                                 .claimName("claimName")
     *                                                 // the properties below are optional
     *                                                 .readOnly(false)
     *                                                 .build())
     *                                         .secret(EksSecretProperty.builder()
     *                                                 .secretName("secretName")
     *                                                 // the properties below are optional
     *                                                 .optional(false)
     *                                                 .build())
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 .instanceTypes(List.of("instanceTypes"))
     *                 .build()))
     *         .numNodes(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-nodeproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-nodeproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.NodePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(NodePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NodePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the node index for the main node of a multi-node parallel job.
         * <p>
         * This node index value must be fewer than the number of nodes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-nodeproperties.html#cfn-batch-jobdefinition-nodeproperties-mainnode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-nodeproperties.html#cfn-batch-jobdefinition-nodeproperties-mainnode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMainNode();

        /**
         * A list of node ranges and their properties that are associated with a multi-node parallel job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-nodeproperties.html#cfn-batch-jobdefinition-nodeproperties-noderangeproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-nodeproperties.html#cfn-batch-jobdefinition-nodeproperties-noderangeproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getNodeRangeProperties();

        /**
         * The number of nodes that are associated with a multi-node parallel job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-nodeproperties.html#cfn-batch-jobdefinition-nodeproperties-numnodes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-nodeproperties.html#cfn-batch-jobdefinition-nodeproperties-numnodes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getNumNodes();

        /**
         * @return a {@link Builder} of {@link NodePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NodePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NodePropertiesProperty> {
            java.lang.Number mainNode;
            java.lang.Object nodeRangeProperties;
            java.lang.Number numNodes;

            /**
             * Sets the value of {@link NodePropertiesProperty#getMainNode}
             * @param mainNode Specifies the node index for the main node of a multi-node parallel job. This parameter is required.
             *                 This node index value must be fewer than the number of nodes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mainNode(java.lang.Number mainNode) {
                this.mainNode = mainNode;
                return this;
            }

            /**
             * Sets the value of {@link NodePropertiesProperty#getNodeRangeProperties}
             * @param nodeRangeProperties A list of node ranges and their properties that are associated with a multi-node parallel job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nodeRangeProperties(software.amazon.awscdk.IResolvable nodeRangeProperties) {
                this.nodeRangeProperties = nodeRangeProperties;
                return this;
            }

            /**
             * Sets the value of {@link NodePropertiesProperty#getNodeRangeProperties}
             * @param nodeRangeProperties A list of node ranges and their properties that are associated with a multi-node parallel job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nodeRangeProperties(java.util.List<? extends java.lang.Object> nodeRangeProperties) {
                this.nodeRangeProperties = nodeRangeProperties;
                return this;
            }

            /**
             * Sets the value of {@link NodePropertiesProperty#getNumNodes}
             * @param numNodes The number of nodes that are associated with a multi-node parallel job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numNodes(java.lang.Number numNodes) {
                this.numNodes = numNodes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NodePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NodePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NodePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NodePropertiesProperty {
            private final java.lang.Number mainNode;
            private final java.lang.Object nodeRangeProperties;
            private final java.lang.Number numNodes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mainNode = software.amazon.jsii.Kernel.get(this, "mainNode", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.nodeRangeProperties = software.amazon.jsii.Kernel.get(this, "nodeRangeProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.numNodes = software.amazon.jsii.Kernel.get(this, "numNodes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mainNode = java.util.Objects.requireNonNull(builder.mainNode, "mainNode is required");
                this.nodeRangeProperties = java.util.Objects.requireNonNull(builder.nodeRangeProperties, "nodeRangeProperties is required");
                this.numNodes = java.util.Objects.requireNonNull(builder.numNodes, "numNodes is required");
            }

            @Override
            public final java.lang.Number getMainNode() {
                return this.mainNode;
            }

            @Override
            public final java.lang.Object getNodeRangeProperties() {
                return this.nodeRangeProperties;
            }

            @Override
            public final java.lang.Number getNumNodes() {
                return this.numNodes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mainNode", om.valueToTree(this.getMainNode()));
                data.set("nodeRangeProperties", om.valueToTree(this.getNodeRangeProperties()));
                data.set("numNodes", om.valueToTree(this.getNumNodes()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.NodePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NodePropertiesProperty.Jsii$Proxy that = (NodePropertiesProperty.Jsii$Proxy) o;

                if (!mainNode.equals(that.mainNode)) return false;
                if (!nodeRangeProperties.equals(that.nodeRangeProperties)) return false;
                return this.numNodes.equals(that.numNodes);
            }

            @Override
            public final int hashCode() {
                int result = this.mainNode.hashCode();
                result = 31 * result + (this.nodeRangeProperties.hashCode());
                result = 31 * result + (this.numNodes.hashCode());
                return result;
            }
        }
    }
    /**
     * This is an object that represents the properties of the node range for a multi-node parallel job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * Object labels;
     * Object limits;
     * Object options;
     * Object requests;
     * NodeRangePropertyProperty nodeRangePropertyProperty = NodeRangePropertyProperty.builder()
     *         .targetNodes("targetNodes")
     *         // the properties below are optional
     *         .consumableResourceProperties(ConsumableResourcePropertiesProperty.builder()
     *                 .consumableResourceList(List.of(ConsumableResourceRequirementProperty.builder()
     *                         .consumableResource("consumableResource")
     *                         .quantity(123)
     *                         .build()))
     *                 .build())
     *         .container(ContainerPropertiesProperty.builder()
     *                 .image("image")
     *                 // the properties below are optional
     *                 .command(List.of("command"))
     *                 .environment(List.of(EnvironmentProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .ephemeralStorage(EphemeralStorageProperty.builder()
     *                         .sizeInGiB(123)
     *                         .build())
     *                 .executionRoleArn("executionRoleArn")
     *                 .fargatePlatformConfiguration(FargatePlatformConfigurationProperty.builder()
     *                         .platformVersion("platformVersion")
     *                         .build())
     *                 .instanceType("instanceType")
     *                 .jobRoleArn("jobRoleArn")
     *                 .linuxParameters(LinuxParametersProperty.builder()
     *                         .devices(List.of(DeviceProperty.builder()
     *                                 .containerPath("containerPath")
     *                                 .hostPath("hostPath")
     *                                 .permissions(List.of("permissions"))
     *                                 .build()))
     *                         .initProcessEnabled(false)
     *                         .maxSwap(123)
     *                         .sharedMemorySize(123)
     *                         .swappiness(123)
     *                         .tmpfs(List.of(TmpfsProperty.builder()
     *                                 .containerPath("containerPath")
     *                                 .size(123)
     *                                 // the properties below are optional
     *                                 .mountOptions(List.of("mountOptions"))
     *                                 .build()))
     *                         .build())
     *                 .logConfiguration(LogConfigurationProperty.builder()
     *                         .logDriver("logDriver")
     *                         // the properties below are optional
     *                         .options(options)
     *                         .secretOptions(List.of(SecretProperty.builder()
     *                                 .name("name")
     *                                 .valueFrom("valueFrom")
     *                                 .build()))
     *                         .build())
     *                 .memory(123)
     *                 .mountPoints(List.of(MountPointsProperty.builder()
     *                         .containerPath("containerPath")
     *                         .readOnly(false)
     *                         .sourceVolume("sourceVolume")
     *                         .build()))
     *                 .networkConfiguration(NetworkConfigurationProperty.builder()
     *                         .assignPublicIp("assignPublicIp")
     *                         .build())
     *                 .privileged(false)
     *                 .readonlyRootFilesystem(false)
     *                 .repositoryCredentials(RepositoryCredentialsProperty.builder()
     *                         .credentialsParameter("credentialsParameter")
     *                         .build())
     *                 .resourceRequirements(List.of(ResourceRequirementProperty.builder()
     *                         .type("type")
     *                         .value("value")
     *                         .build()))
     *                 .runtimePlatform(RuntimePlatformProperty.builder()
     *                         .cpuArchitecture("cpuArchitecture")
     *                         .operatingSystemFamily("operatingSystemFamily")
     *                         .build())
     *                 .secrets(List.of(SecretProperty.builder()
     *                         .name("name")
     *                         .valueFrom("valueFrom")
     *                         .build()))
     *                 .ulimits(List.of(UlimitProperty.builder()
     *                         .hardLimit(123)
     *                         .name("name")
     *                         .softLimit(123)
     *                         .build()))
     *                 .user("user")
     *                 .vcpus(123)
     *                 .volumes(List.of(VolumesProperty.builder()
     *                         .efsVolumeConfiguration(EfsVolumeConfigurationProperty.builder()
     *                                 .fileSystemId("fileSystemId")
     *                                 // the properties below are optional
     *                                 .authorizationConfig(AuthorizationConfigProperty.builder()
     *                                         .accessPointId("accessPointId")
     *                                         .iam("iam")
     *                                         .build())
     *                                 .rootDirectory("rootDirectory")
     *                                 .transitEncryption("transitEncryption")
     *                                 .transitEncryptionPort(123)
     *                                 .build())
     *                         .host(VolumesHostProperty.builder()
     *                                 .sourcePath("sourcePath")
     *                                 .build())
     *                         .name("name")
     *                         .build()))
     *                 .build())
     *         .ecsProperties(MultiNodeEcsPropertiesProperty.builder()
     *                 .taskProperties(List.of(MultiNodeEcsTaskPropertiesProperty.builder()
     *                         .containers(List.of(TaskContainerPropertiesProperty.builder()
     *                                 .image("image")
     *                                 // the properties below are optional
     *                                 .command(List.of("command"))
     *                                 .dependsOn(List.of(TaskContainerDependencyProperty.builder()
     *                                         .condition("condition")
     *                                         .containerName("containerName")
     *                                         .build()))
     *                                 .environment(List.of(EnvironmentProperty.builder()
     *                                         .name("name")
     *                                         .value("value")
     *                                         .build()))
     *                                 .essential(false)
     *                                 .linuxParameters(LinuxParametersProperty.builder()
     *                                         .devices(List.of(DeviceProperty.builder()
     *                                                 .containerPath("containerPath")
     *                                                 .hostPath("hostPath")
     *                                                 .permissions(List.of("permissions"))
     *                                                 .build()))
     *                                         .initProcessEnabled(false)
     *                                         .maxSwap(123)
     *                                         .sharedMemorySize(123)
     *                                         .swappiness(123)
     *                                         .tmpfs(List.of(TmpfsProperty.builder()
     *                                                 .containerPath("containerPath")
     *                                                 .size(123)
     *                                                 // the properties below are optional
     *                                                 .mountOptions(List.of("mountOptions"))
     *                                                 .build()))
     *                                         .build())
     *                                 .logConfiguration(LogConfigurationProperty.builder()
     *                                         .logDriver("logDriver")
     *                                         // the properties below are optional
     *                                         .options(options)
     *                                         .secretOptions(List.of(SecretProperty.builder()
     *                                                 .name("name")
     *                                                 .valueFrom("valueFrom")
     *                                                 .build()))
     *                                         .build())
     *                                 .mountPoints(List.of(MountPointProperty.builder()
     *                                         .containerPath("containerPath")
     *                                         .readOnly(false)
     *                                         .sourceVolume("sourceVolume")
     *                                         .build()))
     *                                 .name("name")
     *                                 .privileged(false)
     *                                 .readonlyRootFilesystem(false)
     *                                 .repositoryCredentials(RepositoryCredentialsProperty.builder()
     *                                         .credentialsParameter("credentialsParameter")
     *                                         .build())
     *                                 .resourceRequirements(List.of(ResourceRequirementProperty.builder()
     *                                         .type("type")
     *                                         .value("value")
     *                                         .build()))
     *                                 .secrets(List.of(SecretProperty.builder()
     *                                         .name("name")
     *                                         .valueFrom("valueFrom")
     *                                         .build()))
     *                                 .ulimits(List.of(UlimitProperty.builder()
     *                                         .hardLimit(123)
     *                                         .name("name")
     *                                         .softLimit(123)
     *                                         .build()))
     *                                 .user("user")
     *                                 .build()))
     *                         .executionRoleArn("executionRoleArn")
     *                         .ipcMode("ipcMode")
     *                         .pidMode("pidMode")
     *                         .taskRoleArn("taskRoleArn")
     *                         .volumes(List.of(VolumesProperty.builder()
     *                                 .efsVolumeConfiguration(EfsVolumeConfigurationProperty.builder()
     *                                         .fileSystemId("fileSystemId")
     *                                         // the properties below are optional
     *                                         .authorizationConfig(AuthorizationConfigProperty.builder()
     *                                                 .accessPointId("accessPointId")
     *                                                 .iam("iam")
     *                                                 .build())
     *                                         .rootDirectory("rootDirectory")
     *                                         .transitEncryption("transitEncryption")
     *                                         .transitEncryptionPort(123)
     *                                         .build())
     *                                 .host(VolumesHostProperty.builder()
     *                                         .sourcePath("sourcePath")
     *                                         .build())
     *                                 .name("name")
     *                                 .build()))
     *                         .build()))
     *                 .build())
     *         .eksProperties(EksPropertiesProperty.builder()
     *                 .podProperties(PodPropertiesProperty.builder()
     *                         .containers(List.of(EksContainerProperty.builder()
     *                                 .image("image")
     *                                 // the properties below are optional
     *                                 .args(List.of("args"))
     *                                 .command(List.of("command"))
     *                                 .env(List.of(EksContainerEnvironmentVariableProperty.builder()
     *                                         .name("name")
     *                                         // the properties below are optional
     *                                         .value("value")
     *                                         .build()))
     *                                 .imagePullPolicy("imagePullPolicy")
     *                                 .name("name")
     *                                 .resources(ResourcesProperty.builder()
     *                                         .limits(limits)
     *                                         .requests(requests)
     *                                         .build())
     *                                 .securityContext(SecurityContextProperty.builder()
     *                                         .allowPrivilegeEscalation(false)
     *                                         .privileged(false)
     *                                         .readOnlyRootFilesystem(false)
     *                                         .runAsGroup(123)
     *                                         .runAsNonRoot(false)
     *                                         .runAsUser(123)
     *                                         .build())
     *                                 .volumeMounts(List.of(EksContainerVolumeMountProperty.builder()
     *                                         .mountPath("mountPath")
     *                                         .name("name")
     *                                         .readOnly(false)
     *                                         .subPath("subPath")
     *                                         .build()))
     *                                 .build()))
     *                         .dnsPolicy("dnsPolicy")
     *                         .hostNetwork(false)
     *                         .imagePullSecrets(List.of(ImagePullSecretProperty.builder()
     *                                 .name("name")
     *                                 .build()))
     *                         .initContainers(List.of(EksContainerProperty.builder()
     *                                 .image("image")
     *                                 // the properties below are optional
     *                                 .args(List.of("args"))
     *                                 .command(List.of("command"))
     *                                 .env(List.of(EksContainerEnvironmentVariableProperty.builder()
     *                                         .name("name")
     *                                         // the properties below are optional
     *                                         .value("value")
     *                                         .build()))
     *                                 .imagePullPolicy("imagePullPolicy")
     *                                 .name("name")
     *                                 .resources(ResourcesProperty.builder()
     *                                         .limits(limits)
     *                                         .requests(requests)
     *                                         .build())
     *                                 .securityContext(SecurityContextProperty.builder()
     *                                         .allowPrivilegeEscalation(false)
     *                                         .privileged(false)
     *                                         .readOnlyRootFilesystem(false)
     *                                         .runAsGroup(123)
     *                                         .runAsNonRoot(false)
     *                                         .runAsUser(123)
     *                                         .build())
     *                                 .volumeMounts(List.of(EksContainerVolumeMountProperty.builder()
     *                                         .mountPath("mountPath")
     *                                         .name("name")
     *                                         .readOnly(false)
     *                                         .subPath("subPath")
     *                                         .build()))
     *                                 .build()))
     *                         .metadata(MetadataProperty.builder()
     *                                 .labels(labels)
     *                                 .build())
     *                         .serviceAccountName("serviceAccountName")
     *                         .shareProcessNamespace(false)
     *                         .volumes(List.of(EksVolumeProperty.builder()
     *                                 .name("name")
     *                                 // the properties below are optional
     *                                 .emptyDir(EmptyDirProperty.builder()
     *                                         .medium("medium")
     *                                         .sizeLimit("sizeLimit")
     *                                         .build())
     *                                 .hostPath(HostPathProperty.builder()
     *                                         .path("path")
     *                                         .build())
     *                                 .persistentVolumeClaim(EksPersistentVolumeClaimProperty.builder()
     *                                         .claimName("claimName")
     *                                         // the properties below are optional
     *                                         .readOnly(false)
     *                                         .build())
     *                                 .secret(EksSecretProperty.builder()
     *                                         .secretName("secretName")
     *                                         // the properties below are optional
     *                                         .optional(false)
     *                                         .build())
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .instanceTypes(List.of("instanceTypes"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.NodeRangePropertyProperty")
    @software.amazon.jsii.Jsii.Proxy(NodeRangePropertyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NodeRangePropertyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The range of nodes, using node index values.
         * <p>
         * A range of <code>0:3</code> indicates nodes with index values of <code>0</code> through <code>3</code> . If the starting range value is omitted ( <code>:n</code> ), then <code>0</code> is used to start the range. If the ending range value is omitted ( <code>n:</code> ), then the highest possible node index is used to end the range. Your accumulative node ranges must account for all nodes ( <code>0:n</code> ). You can nest node ranges (for example, <code>0:10</code> and <code>4:5</code> ). In this case, the <code>4:5</code> range properties override the <code>0:10</code> properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html#cfn-batch-jobdefinition-noderangeproperty-targetnodes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html#cfn-batch-jobdefinition-noderangeproperty-targetnodes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetNodes();

        /**
         * Contains a list of consumable resources required by a job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html#cfn-batch-jobdefinition-noderangeproperty-consumableresourceproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html#cfn-batch-jobdefinition-noderangeproperty-consumableresourceproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConsumableResourceProperties() {
            return null;
        }

        /**
         * The container details for the node range.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html#cfn-batch-jobdefinition-noderangeproperty-container">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html#cfn-batch-jobdefinition-noderangeproperty-container</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContainer() {
            return null;
        }

        /**
         * This is an object that represents the properties of the node range for a multi-node parallel job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html#cfn-batch-jobdefinition-noderangeproperty-ecsproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html#cfn-batch-jobdefinition-noderangeproperty-ecsproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEcsProperties() {
            return null;
        }

        /**
         * This is an object that represents the properties of the node range for a multi-node parallel job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html#cfn-batch-jobdefinition-noderangeproperty-eksproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html#cfn-batch-jobdefinition-noderangeproperty-eksproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEksProperties() {
            return null;
        }

        /**
         * The instance types of the underlying host infrastructure of a multi-node parallel job.
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources.
         * <p>
         * In addition, this list object is currently limited to one element.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html#cfn-batch-jobdefinition-noderangeproperty-instancetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html#cfn-batch-jobdefinition-noderangeproperty-instancetypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstanceTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NodeRangePropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NodeRangePropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NodeRangePropertyProperty> {
            java.lang.String targetNodes;
            java.lang.Object consumableResourceProperties;
            java.lang.Object container;
            java.lang.Object ecsProperties;
            java.lang.Object eksProperties;
            java.util.List<java.lang.String> instanceTypes;

            /**
             * Sets the value of {@link NodeRangePropertyProperty#getTargetNodes}
             * @param targetNodes The range of nodes, using node index values. This parameter is required.
             *                    A range of <code>0:3</code> indicates nodes with index values of <code>0</code> through <code>3</code> . If the starting range value is omitted ( <code>:n</code> ), then <code>0</code> is used to start the range. If the ending range value is omitted ( <code>n:</code> ), then the highest possible node index is used to end the range. Your accumulative node ranges must account for all nodes ( <code>0:n</code> ). You can nest node ranges (for example, <code>0:10</code> and <code>4:5</code> ). In this case, the <code>4:5</code> range properties override the <code>0:10</code> properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetNodes(java.lang.String targetNodes) {
                this.targetNodes = targetNodes;
                return this;
            }

            /**
             * Sets the value of {@link NodeRangePropertyProperty#getConsumableResourceProperties}
             * @param consumableResourceProperties Contains a list of consumable resources required by a job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder consumableResourceProperties(software.amazon.awscdk.IResolvable consumableResourceProperties) {
                this.consumableResourceProperties = consumableResourceProperties;
                return this;
            }

            /**
             * Sets the value of {@link NodeRangePropertyProperty#getConsumableResourceProperties}
             * @param consumableResourceProperties Contains a list of consumable resources required by a job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder consumableResourceProperties(software.amazon.awscdk.services.batch.CfnJobDefinition.ConsumableResourcePropertiesProperty consumableResourceProperties) {
                this.consumableResourceProperties = consumableResourceProperties;
                return this;
            }

            /**
             * Sets the value of {@link NodeRangePropertyProperty#getContainer}
             * @param container The container details for the node range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder container(software.amazon.awscdk.IResolvable container) {
                this.container = container;
                return this;
            }

            /**
             * Sets the value of {@link NodeRangePropertyProperty#getContainer}
             * @param container The container details for the node range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder container(software.amazon.awscdk.services.batch.CfnJobDefinition.ContainerPropertiesProperty container) {
                this.container = container;
                return this;
            }

            /**
             * Sets the value of {@link NodeRangePropertyProperty#getEcsProperties}
             * @param ecsProperties This is an object that represents the properties of the node range for a multi-node parallel job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecsProperties(software.amazon.awscdk.IResolvable ecsProperties) {
                this.ecsProperties = ecsProperties;
                return this;
            }

            /**
             * Sets the value of {@link NodeRangePropertyProperty#getEcsProperties}
             * @param ecsProperties This is an object that represents the properties of the node range for a multi-node parallel job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecsProperties(software.amazon.awscdk.services.batch.CfnJobDefinition.MultiNodeEcsPropertiesProperty ecsProperties) {
                this.ecsProperties = ecsProperties;
                return this;
            }

            /**
             * Sets the value of {@link NodeRangePropertyProperty#getEksProperties}
             * @param eksProperties This is an object that represents the properties of the node range for a multi-node parallel job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eksProperties(software.amazon.awscdk.IResolvable eksProperties) {
                this.eksProperties = eksProperties;
                return this;
            }

            /**
             * Sets the value of {@link NodeRangePropertyProperty#getEksProperties}
             * @param eksProperties This is an object that represents the properties of the node range for a multi-node parallel job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eksProperties(software.amazon.awscdk.services.batch.CfnJobDefinition.EksPropertiesProperty eksProperties) {
                this.eksProperties = eksProperties;
                return this;
            }

            /**
             * Sets the value of {@link NodeRangePropertyProperty#getInstanceTypes}
             * @param instanceTypes The instance types of the underlying host infrastructure of a multi-node parallel job.
             *                      <blockquote>
             *                      <p>
             *                      This parameter isn't applicable to jobs that are running on Fargate resources.
             *                      <p>
             *                      In addition, this list object is currently limited to one element.
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceTypes(java.util.List<java.lang.String> instanceTypes) {
                this.instanceTypes = instanceTypes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NodeRangePropertyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NodeRangePropertyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NodeRangePropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NodeRangePropertyProperty {
            private final java.lang.String targetNodes;
            private final java.lang.Object consumableResourceProperties;
            private final java.lang.Object container;
            private final java.lang.Object ecsProperties;
            private final java.lang.Object eksProperties;
            private final java.util.List<java.lang.String> instanceTypes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetNodes = software.amazon.jsii.Kernel.get(this, "targetNodes", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.consumableResourceProperties = software.amazon.jsii.Kernel.get(this, "consumableResourceProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.container = software.amazon.jsii.Kernel.get(this, "container", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ecsProperties = software.amazon.jsii.Kernel.get(this, "ecsProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eksProperties = software.amazon.jsii.Kernel.get(this, "eksProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.instanceTypes = software.amazon.jsii.Kernel.get(this, "instanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetNodes = java.util.Objects.requireNonNull(builder.targetNodes, "targetNodes is required");
                this.consumableResourceProperties = builder.consumableResourceProperties;
                this.container = builder.container;
                this.ecsProperties = builder.ecsProperties;
                this.eksProperties = builder.eksProperties;
                this.instanceTypes = builder.instanceTypes;
            }

            @Override
            public final java.lang.String getTargetNodes() {
                return this.targetNodes;
            }

            @Override
            public final java.lang.Object getConsumableResourceProperties() {
                return this.consumableResourceProperties;
            }

            @Override
            public final java.lang.Object getContainer() {
                return this.container;
            }

            @Override
            public final java.lang.Object getEcsProperties() {
                return this.ecsProperties;
            }

            @Override
            public final java.lang.Object getEksProperties() {
                return this.eksProperties;
            }

            @Override
            public final java.util.List<java.lang.String> getInstanceTypes() {
                return this.instanceTypes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetNodes", om.valueToTree(this.getTargetNodes()));
                if (this.getConsumableResourceProperties() != null) {
                    data.set("consumableResourceProperties", om.valueToTree(this.getConsumableResourceProperties()));
                }
                if (this.getContainer() != null) {
                    data.set("container", om.valueToTree(this.getContainer()));
                }
                if (this.getEcsProperties() != null) {
                    data.set("ecsProperties", om.valueToTree(this.getEcsProperties()));
                }
                if (this.getEksProperties() != null) {
                    data.set("eksProperties", om.valueToTree(this.getEksProperties()));
                }
                if (this.getInstanceTypes() != null) {
                    data.set("instanceTypes", om.valueToTree(this.getInstanceTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.NodeRangePropertyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NodeRangePropertyProperty.Jsii$Proxy that = (NodeRangePropertyProperty.Jsii$Proxy) o;

                if (!targetNodes.equals(that.targetNodes)) return false;
                if (this.consumableResourceProperties != null ? !this.consumableResourceProperties.equals(that.consumableResourceProperties) : that.consumableResourceProperties != null) return false;
                if (this.container != null ? !this.container.equals(that.container) : that.container != null) return false;
                if (this.ecsProperties != null ? !this.ecsProperties.equals(that.ecsProperties) : that.ecsProperties != null) return false;
                if (this.eksProperties != null ? !this.eksProperties.equals(that.eksProperties) : that.eksProperties != null) return false;
                return this.instanceTypes != null ? this.instanceTypes.equals(that.instanceTypes) : that.instanceTypes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetNodes.hashCode();
                result = 31 * result + (this.consumableResourceProperties != null ? this.consumableResourceProperties.hashCode() : 0);
                result = 31 * result + (this.container != null ? this.container.hashCode() : 0);
                result = 31 * result + (this.ecsProperties != null ? this.ecsProperties.hashCode() : 0);
                result = 31 * result + (this.eksProperties != null ? this.eksProperties.hashCode() : 0);
                result = 31 * result + (this.instanceTypes != null ? this.instanceTypes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * Object labels;
     * Object limits;
     * Object requests;
     * PodPropertiesProperty podPropertiesProperty = PodPropertiesProperty.builder()
     *         .containers(List.of(EksContainerProperty.builder()
     *                 .image("image")
     *                 // the properties below are optional
     *                 .args(List.of("args"))
     *                 .command(List.of("command"))
     *                 .env(List.of(EksContainerEnvironmentVariableProperty.builder()
     *                         .name("name")
     *                         // the properties below are optional
     *                         .value("value")
     *                         .build()))
     *                 .imagePullPolicy("imagePullPolicy")
     *                 .name("name")
     *                 .resources(ResourcesProperty.builder()
     *                         .limits(limits)
     *                         .requests(requests)
     *                         .build())
     *                 .securityContext(SecurityContextProperty.builder()
     *                         .allowPrivilegeEscalation(false)
     *                         .privileged(false)
     *                         .readOnlyRootFilesystem(false)
     *                         .runAsGroup(123)
     *                         .runAsNonRoot(false)
     *                         .runAsUser(123)
     *                         .build())
     *                 .volumeMounts(List.of(EksContainerVolumeMountProperty.builder()
     *                         .mountPath("mountPath")
     *                         .name("name")
     *                         .readOnly(false)
     *                         .subPath("subPath")
     *                         .build()))
     *                 .build()))
     *         .dnsPolicy("dnsPolicy")
     *         .hostNetwork(false)
     *         .imagePullSecrets(List.of(ImagePullSecretProperty.builder()
     *                 .name("name")
     *                 .build()))
     *         .initContainers(List.of(EksContainerProperty.builder()
     *                 .image("image")
     *                 // the properties below are optional
     *                 .args(List.of("args"))
     *                 .command(List.of("command"))
     *                 .env(List.of(EksContainerEnvironmentVariableProperty.builder()
     *                         .name("name")
     *                         // the properties below are optional
     *                         .value("value")
     *                         .build()))
     *                 .imagePullPolicy("imagePullPolicy")
     *                 .name("name")
     *                 .resources(ResourcesProperty.builder()
     *                         .limits(limits)
     *                         .requests(requests)
     *                         .build())
     *                 .securityContext(SecurityContextProperty.builder()
     *                         .allowPrivilegeEscalation(false)
     *                         .privileged(false)
     *                         .readOnlyRootFilesystem(false)
     *                         .runAsGroup(123)
     *                         .runAsNonRoot(false)
     *                         .runAsUser(123)
     *                         .build())
     *                 .volumeMounts(List.of(EksContainerVolumeMountProperty.builder()
     *                         .mountPath("mountPath")
     *                         .name("name")
     *                         .readOnly(false)
     *                         .subPath("subPath")
     *                         .build()))
     *                 .build()))
     *         .metadata(MetadataProperty.builder()
     *                 .labels(labels)
     *                 .build())
     *         .serviceAccountName("serviceAccountName")
     *         .shareProcessNamespace(false)
     *         .volumes(List.of(EksVolumeProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .emptyDir(EmptyDirProperty.builder()
     *                         .medium("medium")
     *                         .sizeLimit("sizeLimit")
     *                         .build())
     *                 .hostPath(HostPathProperty.builder()
     *                         .path("path")
     *                         .build())
     *                 .persistentVolumeClaim(EksPersistentVolumeClaimProperty.builder()
     *                         .claimName("claimName")
     *                         // the properties below are optional
     *                         .readOnly(false)
     *                         .build())
     *                 .secret(EksSecretProperty.builder()
     *                         .secretName("secretName")
     *                         // the properties below are optional
     *                         .optional(false)
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-podproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-podproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.PodPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(PodPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PodPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-podproperties.html#cfn-batch-jobdefinition-podproperties-containers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-podproperties.html#cfn-batch-jobdefinition-podproperties-containers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContainers() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-podproperties.html#cfn-batch-jobdefinition-podproperties-dnspolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-podproperties.html#cfn-batch-jobdefinition-podproperties-dnspolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDnsPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-podproperties.html#cfn-batch-jobdefinition-podproperties-hostnetwork">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-podproperties.html#cfn-batch-jobdefinition-podproperties-hostnetwork</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHostNetwork() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-podproperties.html#cfn-batch-jobdefinition-podproperties-imagepullsecrets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-podproperties.html#cfn-batch-jobdefinition-podproperties-imagepullsecrets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getImagePullSecrets() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-podproperties.html#cfn-batch-jobdefinition-podproperties-initcontainers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-podproperties.html#cfn-batch-jobdefinition-podproperties-initcontainers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInitContainers() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-podproperties.html#cfn-batch-jobdefinition-podproperties-metadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-podproperties.html#cfn-batch-jobdefinition-podproperties-metadata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetadata() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-podproperties.html#cfn-batch-jobdefinition-podproperties-serviceaccountname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-podproperties.html#cfn-batch-jobdefinition-podproperties-serviceaccountname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccountName() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-podproperties.html#cfn-batch-jobdefinition-podproperties-shareprocessnamespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-podproperties.html#cfn-batch-jobdefinition-podproperties-shareprocessnamespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getShareProcessNamespace() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-podproperties.html#cfn-batch-jobdefinition-podproperties-volumes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-podproperties.html#cfn-batch-jobdefinition-podproperties-volumes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVolumes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PodPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PodPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PodPropertiesProperty> {
            java.lang.Object containers;
            java.lang.String dnsPolicy;
            java.lang.Object hostNetwork;
            java.lang.Object imagePullSecrets;
            java.lang.Object initContainers;
            java.lang.Object metadata;
            java.lang.String serviceAccountName;
            java.lang.Object shareProcessNamespace;
            java.lang.Object volumes;

            /**
             * Sets the value of {@link PodPropertiesProperty#getContainers}
             * @param containers the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containers(software.amazon.awscdk.IResolvable containers) {
                this.containers = containers;
                return this;
            }

            /**
             * Sets the value of {@link PodPropertiesProperty#getContainers}
             * @param containers the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containers(java.util.List<? extends java.lang.Object> containers) {
                this.containers = containers;
                return this;
            }

            /**
             * Sets the value of {@link PodPropertiesProperty#getDnsPolicy}
             * @param dnsPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsPolicy(java.lang.String dnsPolicy) {
                this.dnsPolicy = dnsPolicy;
                return this;
            }

            /**
             * Sets the value of {@link PodPropertiesProperty#getHostNetwork}
             * @param hostNetwork the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostNetwork(java.lang.Boolean hostNetwork) {
                this.hostNetwork = hostNetwork;
                return this;
            }

            /**
             * Sets the value of {@link PodPropertiesProperty#getHostNetwork}
             * @param hostNetwork the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostNetwork(software.amazon.awscdk.IResolvable hostNetwork) {
                this.hostNetwork = hostNetwork;
                return this;
            }

            /**
             * Sets the value of {@link PodPropertiesProperty#getImagePullSecrets}
             * @param imagePullSecrets the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imagePullSecrets(software.amazon.awscdk.IResolvable imagePullSecrets) {
                this.imagePullSecrets = imagePullSecrets;
                return this;
            }

            /**
             * Sets the value of {@link PodPropertiesProperty#getImagePullSecrets}
             * @param imagePullSecrets the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imagePullSecrets(java.util.List<? extends java.lang.Object> imagePullSecrets) {
                this.imagePullSecrets = imagePullSecrets;
                return this;
            }

            /**
             * Sets the value of {@link PodPropertiesProperty#getInitContainers}
             * @param initContainers the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initContainers(software.amazon.awscdk.IResolvable initContainers) {
                this.initContainers = initContainers;
                return this;
            }

            /**
             * Sets the value of {@link PodPropertiesProperty#getInitContainers}
             * @param initContainers the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initContainers(java.util.List<? extends java.lang.Object> initContainers) {
                this.initContainers = initContainers;
                return this;
            }

            /**
             * Sets the value of {@link PodPropertiesProperty#getMetadata}
             * @param metadata the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadata(software.amazon.awscdk.IResolvable metadata) {
                this.metadata = metadata;
                return this;
            }

            /**
             * Sets the value of {@link PodPropertiesProperty#getMetadata}
             * @param metadata the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadata(software.amazon.awscdk.services.batch.CfnJobDefinition.MetadataProperty metadata) {
                this.metadata = metadata;
                return this;
            }

            /**
             * Sets the value of {@link PodPropertiesProperty#getServiceAccountName}
             * @param serviceAccountName the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceAccountName(java.lang.String serviceAccountName) {
                this.serviceAccountName = serviceAccountName;
                return this;
            }

            /**
             * Sets the value of {@link PodPropertiesProperty#getShareProcessNamespace}
             * @param shareProcessNamespace the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shareProcessNamespace(java.lang.Boolean shareProcessNamespace) {
                this.shareProcessNamespace = shareProcessNamespace;
                return this;
            }

            /**
             * Sets the value of {@link PodPropertiesProperty#getShareProcessNamespace}
             * @param shareProcessNamespace the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shareProcessNamespace(software.amazon.awscdk.IResolvable shareProcessNamespace) {
                this.shareProcessNamespace = shareProcessNamespace;
                return this;
            }

            /**
             * Sets the value of {@link PodPropertiesProperty#getVolumes}
             * @param volumes the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumes(software.amazon.awscdk.IResolvable volumes) {
                this.volumes = volumes;
                return this;
            }

            /**
             * Sets the value of {@link PodPropertiesProperty#getVolumes}
             * @param volumes the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumes(java.util.List<? extends java.lang.Object> volumes) {
                this.volumes = volumes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PodPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PodPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PodPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PodPropertiesProperty {
            private final java.lang.Object containers;
            private final java.lang.String dnsPolicy;
            private final java.lang.Object hostNetwork;
            private final java.lang.Object imagePullSecrets;
            private final java.lang.Object initContainers;
            private final java.lang.Object metadata;
            private final java.lang.String serviceAccountName;
            private final java.lang.Object shareProcessNamespace;
            private final java.lang.Object volumes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containers = software.amazon.jsii.Kernel.get(this, "containers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dnsPolicy = software.amazon.jsii.Kernel.get(this, "dnsPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostNetwork = software.amazon.jsii.Kernel.get(this, "hostNetwork", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.imagePullSecrets = software.amazon.jsii.Kernel.get(this, "imagePullSecrets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.initContainers = software.amazon.jsii.Kernel.get(this, "initContainers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metadata = software.amazon.jsii.Kernel.get(this, "metadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceAccountName = software.amazon.jsii.Kernel.get(this, "serviceAccountName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.shareProcessNamespace = software.amazon.jsii.Kernel.get(this, "shareProcessNamespace", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containers = builder.containers;
                this.dnsPolicy = builder.dnsPolicy;
                this.hostNetwork = builder.hostNetwork;
                this.imagePullSecrets = builder.imagePullSecrets;
                this.initContainers = builder.initContainers;
                this.metadata = builder.metadata;
                this.serviceAccountName = builder.serviceAccountName;
                this.shareProcessNamespace = builder.shareProcessNamespace;
                this.volumes = builder.volumes;
            }

            @Override
            public final java.lang.Object getContainers() {
                return this.containers;
            }

            @Override
            public final java.lang.String getDnsPolicy() {
                return this.dnsPolicy;
            }

            @Override
            public final java.lang.Object getHostNetwork() {
                return this.hostNetwork;
            }

            @Override
            public final java.lang.Object getImagePullSecrets() {
                return this.imagePullSecrets;
            }

            @Override
            public final java.lang.Object getInitContainers() {
                return this.initContainers;
            }

            @Override
            public final java.lang.Object getMetadata() {
                return this.metadata;
            }

            @Override
            public final java.lang.String getServiceAccountName() {
                return this.serviceAccountName;
            }

            @Override
            public final java.lang.Object getShareProcessNamespace() {
                return this.shareProcessNamespace;
            }

            @Override
            public final java.lang.Object getVolumes() {
                return this.volumes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainers() != null) {
                    data.set("containers", om.valueToTree(this.getContainers()));
                }
                if (this.getDnsPolicy() != null) {
                    data.set("dnsPolicy", om.valueToTree(this.getDnsPolicy()));
                }
                if (this.getHostNetwork() != null) {
                    data.set("hostNetwork", om.valueToTree(this.getHostNetwork()));
                }
                if (this.getImagePullSecrets() != null) {
                    data.set("imagePullSecrets", om.valueToTree(this.getImagePullSecrets()));
                }
                if (this.getInitContainers() != null) {
                    data.set("initContainers", om.valueToTree(this.getInitContainers()));
                }
                if (this.getMetadata() != null) {
                    data.set("metadata", om.valueToTree(this.getMetadata()));
                }
                if (this.getServiceAccountName() != null) {
                    data.set("serviceAccountName", om.valueToTree(this.getServiceAccountName()));
                }
                if (this.getShareProcessNamespace() != null) {
                    data.set("shareProcessNamespace", om.valueToTree(this.getShareProcessNamespace()));
                }
                if (this.getVolumes() != null) {
                    data.set("volumes", om.valueToTree(this.getVolumes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.PodPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PodPropertiesProperty.Jsii$Proxy that = (PodPropertiesProperty.Jsii$Proxy) o;

                if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) return false;
                if (this.dnsPolicy != null ? !this.dnsPolicy.equals(that.dnsPolicy) : that.dnsPolicy != null) return false;
                if (this.hostNetwork != null ? !this.hostNetwork.equals(that.hostNetwork) : that.hostNetwork != null) return false;
                if (this.imagePullSecrets != null ? !this.imagePullSecrets.equals(that.imagePullSecrets) : that.imagePullSecrets != null) return false;
                if (this.initContainers != null ? !this.initContainers.equals(that.initContainers) : that.initContainers != null) return false;
                if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) return false;
                if (this.serviceAccountName != null ? !this.serviceAccountName.equals(that.serviceAccountName) : that.serviceAccountName != null) return false;
                if (this.shareProcessNamespace != null ? !this.shareProcessNamespace.equals(that.shareProcessNamespace) : that.shareProcessNamespace != null) return false;
                return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containers != null ? this.containers.hashCode() : 0;
                result = 31 * result + (this.dnsPolicy != null ? this.dnsPolicy.hashCode() : 0);
                result = 31 * result + (this.hostNetwork != null ? this.hostNetwork.hashCode() : 0);
                result = 31 * result + (this.imagePullSecrets != null ? this.imagePullSecrets.hashCode() : 0);
                result = 31 * result + (this.initContainers != null ? this.initContainers.hashCode() : 0);
                result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
                result = 31 * result + (this.serviceAccountName != null ? this.serviceAccountName.hashCode() : 0);
                result = 31 * result + (this.shareProcessNamespace != null ? this.shareProcessNamespace.hashCode() : 0);
                result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The repository credentials for private registry authentication.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * RepositoryCredentialsProperty repositoryCredentialsProperty = RepositoryCredentialsProperty.builder()
     *         .credentialsParameter("credentialsParameter")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-repositorycredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-repositorycredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.RepositoryCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(RepositoryCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RepositoryCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the secret containing the private repository credentials.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-repositorycredentials.html#cfn-batch-jobdefinition-repositorycredentials-credentialsparameter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-repositorycredentials.html#cfn-batch-jobdefinition-repositorycredentials-credentialsparameter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCredentialsParameter();

        /**
         * @return a {@link Builder} of {@link RepositoryCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RepositoryCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RepositoryCredentialsProperty> {
            java.lang.String credentialsParameter;

            /**
             * Sets the value of {@link RepositoryCredentialsProperty#getCredentialsParameter}
             * @param credentialsParameter The Amazon Resource Name (ARN) of the secret containing the private repository credentials. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialsParameter(java.lang.String credentialsParameter) {
                this.credentialsParameter = credentialsParameter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RepositoryCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RepositoryCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RepositoryCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RepositoryCredentialsProperty {
            private final java.lang.String credentialsParameter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.credentialsParameter = software.amazon.jsii.Kernel.get(this, "credentialsParameter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.credentialsParameter = java.util.Objects.requireNonNull(builder.credentialsParameter, "credentialsParameter is required");
            }

            @Override
            public final java.lang.String getCredentialsParameter() {
                return this.credentialsParameter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("credentialsParameter", om.valueToTree(this.getCredentialsParameter()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.RepositoryCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RepositoryCredentialsProperty.Jsii$Proxy that = (RepositoryCredentialsProperty.Jsii$Proxy) o;

                return this.credentialsParameter.equals(that.credentialsParameter);
            }

            @Override
            public final int hashCode() {
                int result = this.credentialsParameter.hashCode();
                return result;
            }
        }
    }
    /**
     * The type and amount of a resource to assign to a container.
     * <p>
     * The supported resources include <code>GPU</code> , <code>MEMORY</code> , and <code>VCPU</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * ResourceRequirementProperty resourceRequirementProperty = ResourceRequirementProperty.builder()
     *         .type("type")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-resourcerequirement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-resourcerequirement.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.ResourceRequirementProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceRequirementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceRequirementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of resource to assign to a container.
         * <p>
         * The supported resources include <code>GPU</code> , <code>MEMORY</code> , and <code>VCPU</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-resourcerequirement.html#cfn-batch-jobdefinition-resourcerequirement-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-resourcerequirement.html#cfn-batch-jobdefinition-resourcerequirement-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * The quantity of the specified resource to reserve for the container. The values vary based on the <code>type</code> specified.
         * <p>
         * <ul>
         * <li><strong>type="GPU"</strong> - The number of physical GPUs to reserve for the container. Make sure that the number of GPUs reserved for all containers in a job doesn't exceed the number of available GPUs on the compute resource that the job is launched on.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * GPUs aren't available for jobs that are running on Fargate resources.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><strong>type="MEMORY"</strong> - The memory hard limit (in MiB) present to the container. This parameter is supported for jobs that are running on Amazon EC2 resources. If your container attempts to exceed the memory specified, the container is terminated. This parameter maps to <code>Memory</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--memory</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . You must specify at least 4 MiB of memory for a job. This is required but can be specified in several places for multi-node parallel (MNP) jobs. It must be specified for each node at least once. This parameter maps to <code>Memory</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--memory</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for a particular instance type, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory management</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * For jobs that are running on Fargate resources, then <code>value</code> is the hard limit (in MiB), and must match one of the supported values and the <code>VCPU</code> values must be one of the values supported for that memory value.
         * <p>
         * <ul>
         * <li><strong>value = 512</strong> - <code>VCPU</code> = 0.25</li>
         * <li><strong>value = 1024</strong> - <code>VCPU</code> = 0.25 or 0.5</li>
         * <li><strong>value = 2048</strong> - <code>VCPU</code> = 0.25, 0.5, or 1</li>
         * <li><strong>value = 3072</strong> - <code>VCPU</code> = 0.5, or 1</li>
         * <li><strong>value = 4096</strong> - <code>VCPU</code> = 0.5, 1, or 2</li>
         * <li><strong>value = 5120, 6144, or 7168</strong> - <code>VCPU</code> = 1 or 2</li>
         * <li><strong>value = 8192</strong> - <code>VCPU</code> = 1, 2, or 4</li>
         * <li><strong>value = 9216, 10240, 11264, 12288, 13312, 14336, or 15360</strong> - <code>VCPU</code> = 2 or 4</li>
         * <li><strong>value = 16384</strong> - <code>VCPU</code> = 2, 4, or 8</li>
         * <li><strong>value = 17408, 18432, 19456, 21504, 22528, 23552, 25600, 26624, 27648, 29696, or 30720</strong> - <code>VCPU</code> = 4</li>
         * <li><strong>value = 20480, 24576, or 28672</strong> - <code>VCPU</code> = 4 or 8</li>
         * <li><strong>value = 36864, 45056, 53248, or 61440</strong> - <code>VCPU</code> = 8</li>
         * <li><strong>value = 32768, 40960, 49152, or 57344</strong> - <code>VCPU</code> = 8 or 16</li>
         * <li><strong>value = 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880</strong> - <code>VCPU</code> = 16</li>
         * <li><strong>type="VCPU"</strong> - The number of vCPUs reserved for the container. This parameter maps to <code>CpuShares</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--cpu-shares</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . Each vCPU is equivalent to 1,024 CPU shares. For Amazon EC2 resources, you must specify at least one vCPU. This is required but can be specified in several places; it must be specified for each node at least once.</li>
         * </ul>
         * <p>
         * The default for the Fargate On-Demand vCPU resource count quota is 6 vCPUs. For more information about Fargate quotas, see <a href="https://docs.aws.amazon.com/general/latest/gr/ecs-service.html#service-quotas-fargate">AWS Fargate quotas</a> in the <em>AWS General Reference</em> .
         * <p>
         * For jobs that are running on Fargate resources, then <code>value</code> must match one of the supported values and the <code>MEMORY</code> values must be one of the values supported for that <code>VCPU</code> value. The supported values are 0.25, 0.5, 1, 2, 4, 8, and 16
         * <p>
         * <ul>
         * <li><strong>value = 0.25</strong> - <code>MEMORY</code> = 512, 1024, or 2048</li>
         * <li><strong>value = 0.5</strong> - <code>MEMORY</code> = 1024, 2048, 3072, or 4096</li>
         * <li><strong>value = 1</strong> - <code>MEMORY</code> = 2048, 3072, 4096, 5120, 6144, 7168, or 8192</li>
         * <li><strong>value = 2</strong> - <code>MEMORY</code> = 4096, 5120, 6144, 7168, 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, or 16384</li>
         * <li><strong>value = 4</strong> - <code>MEMORY</code> = 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, 16384, 17408, 18432, 19456, 20480, 21504, 22528, 23552, 24576, 25600, 26624, 27648, 28672, 29696, or 30720</li>
         * <li><strong>value = 8</strong> - <code>MEMORY</code> = 16384, 20480, 24576, 28672, 32768, 36864, 40960, 45056, 49152, 53248, 57344, or 61440</li>
         * <li><strong>value = 16</strong> - <code>MEMORY</code> = 32768, 40960, 49152, 57344, 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-resourcerequirement.html#cfn-batch-jobdefinition-resourcerequirement-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-resourcerequirement.html#cfn-batch-jobdefinition-resourcerequirement-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceRequirementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceRequirementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceRequirementProperty> {
            java.lang.String type;
            java.lang.String value;

            /**
             * Sets the value of {@link ResourceRequirementProperty#getType}
             * @param type The type of resource to assign to a container.
             *             The supported resources include <code>GPU</code> , <code>MEMORY</code> , and <code>VCPU</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ResourceRequirementProperty#getValue}
             * @param value The quantity of the specified resource to reserve for the container. The values vary based on the <code>type</code> specified.
             *              <ul>
             *              <li><strong>type="GPU"</strong> - The number of physical GPUs to reserve for the container. Make sure that the number of GPUs reserved for all containers in a job doesn't exceed the number of available GPUs on the compute resource that the job is launched on.</li>
             *              </ul>
             *              <p>
             *              <blockquote>
             *              <p>
             *              GPUs aren't available for jobs that are running on Fargate resources.
             *              <p>
             *              </blockquote>
             *              <p>
             *              <ul>
             *              <li><strong>type="MEMORY"</strong> - The memory hard limit (in MiB) present to the container. This parameter is supported for jobs that are running on Amazon EC2 resources. If your container attempts to exceed the memory specified, the container is terminated. This parameter maps to <code>Memory</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--memory</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . You must specify at least 4 MiB of memory for a job. This is required but can be specified in several places for multi-node parallel (MNP) jobs. It must be specified for each node at least once. This parameter maps to <code>Memory</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--memory</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .</li>
             *              </ul>
             *              <p>
             *              <blockquote>
             *              <p>
             *              If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for a particular instance type, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory management</a> in the <em>AWS Batch User Guide</em> .
             *              <p>
             *              </blockquote>
             *              <p>
             *              For jobs that are running on Fargate resources, then <code>value</code> is the hard limit (in MiB), and must match one of the supported values and the <code>VCPU</code> values must be one of the values supported for that memory value.
             *              <p>
             *              <ul>
             *              <li><strong>value = 512</strong> - <code>VCPU</code> = 0.25</li>
             *              <li><strong>value = 1024</strong> - <code>VCPU</code> = 0.25 or 0.5</li>
             *              <li><strong>value = 2048</strong> - <code>VCPU</code> = 0.25, 0.5, or 1</li>
             *              <li><strong>value = 3072</strong> - <code>VCPU</code> = 0.5, or 1</li>
             *              <li><strong>value = 4096</strong> - <code>VCPU</code> = 0.5, 1, or 2</li>
             *              <li><strong>value = 5120, 6144, or 7168</strong> - <code>VCPU</code> = 1 or 2</li>
             *              <li><strong>value = 8192</strong> - <code>VCPU</code> = 1, 2, or 4</li>
             *              <li><strong>value = 9216, 10240, 11264, 12288, 13312, 14336, or 15360</strong> - <code>VCPU</code> = 2 or 4</li>
             *              <li><strong>value = 16384</strong> - <code>VCPU</code> = 2, 4, or 8</li>
             *              <li><strong>value = 17408, 18432, 19456, 21504, 22528, 23552, 25600, 26624, 27648, 29696, or 30720</strong> - <code>VCPU</code> = 4</li>
             *              <li><strong>value = 20480, 24576, or 28672</strong> - <code>VCPU</code> = 4 or 8</li>
             *              <li><strong>value = 36864, 45056, 53248, or 61440</strong> - <code>VCPU</code> = 8</li>
             *              <li><strong>value = 32768, 40960, 49152, or 57344</strong> - <code>VCPU</code> = 8 or 16</li>
             *              <li><strong>value = 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880</strong> - <code>VCPU</code> = 16</li>
             *              <li><strong>type="VCPU"</strong> - The number of vCPUs reserved for the container. This parameter maps to <code>CpuShares</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--cpu-shares</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . Each vCPU is equivalent to 1,024 CPU shares. For Amazon EC2 resources, you must specify at least one vCPU. This is required but can be specified in several places; it must be specified for each node at least once.</li>
             *              </ul>
             *              <p>
             *              The default for the Fargate On-Demand vCPU resource count quota is 6 vCPUs. For more information about Fargate quotas, see <a href="https://docs.aws.amazon.com/general/latest/gr/ecs-service.html#service-quotas-fargate">AWS Fargate quotas</a> in the <em>AWS General Reference</em> .
             *              <p>
             *              For jobs that are running on Fargate resources, then <code>value</code> must match one of the supported values and the <code>MEMORY</code> values must be one of the values supported for that <code>VCPU</code> value. The supported values are 0.25, 0.5, 1, 2, 4, 8, and 16
             *              <p>
             *              <ul>
             *              <li><strong>value = 0.25</strong> - <code>MEMORY</code> = 512, 1024, or 2048</li>
             *              <li><strong>value = 0.5</strong> - <code>MEMORY</code> = 1024, 2048, 3072, or 4096</li>
             *              <li><strong>value = 1</strong> - <code>MEMORY</code> = 2048, 3072, 4096, 5120, 6144, 7168, or 8192</li>
             *              <li><strong>value = 2</strong> - <code>MEMORY</code> = 4096, 5120, 6144, 7168, 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, or 16384</li>
             *              <li><strong>value = 4</strong> - <code>MEMORY</code> = 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, 16384, 17408, 18432, 19456, 20480, 21504, 22528, 23552, 24576, 25600, 26624, 27648, 28672, 29696, or 30720</li>
             *              <li><strong>value = 8</strong> - <code>MEMORY</code> = 16384, 20480, 24576, 28672, 32768, 36864, 40960, 45056, 49152, 53248, 57344, or 61440</li>
             *              <li><strong>value = 16</strong> - <code>MEMORY</code> = 32768, 40960, 49152, 57344, 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880</li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceRequirementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceRequirementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceRequirementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceRequirementProperty {
            private final java.lang.String type;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = builder.type;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.ResourceRequirementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceRequirementProperty.Jsii$Proxy that = (ResourceRequirementProperty.Jsii$Proxy) o;

                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type != null ? this.type.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * Object limits;
     * Object requests;
     * ResourcesProperty resourcesProperty = ResourcesProperty.builder()
     *         .limits(limits)
     *         .requests(requests)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-resources.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-resources.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.ResourcesProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourcesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourcesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-resources.html#cfn-batch-jobdefinition-resources-limits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-resources.html#cfn-batch-jobdefinition-resources-limits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLimits() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-resources.html#cfn-batch-jobdefinition-resources-requests">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-resources.html#cfn-batch-jobdefinition-resources-requests</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequests() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourcesProperty> {
            java.lang.Object limits;
            java.lang.Object requests;

            /**
             * Sets the value of {@link ResourcesProperty#getLimits}
             * @param limits the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder limits(java.lang.Object limits) {
                this.limits = limits;
                return this;
            }

            /**
             * Sets the value of {@link ResourcesProperty#getRequests}
             * @param requests the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requests(java.lang.Object requests) {
                this.requests = requests;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourcesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourcesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourcesProperty {
            private final java.lang.Object limits;
            private final java.lang.Object requests;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.limits = software.amazon.jsii.Kernel.get(this, "limits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requests = software.amazon.jsii.Kernel.get(this, "requests", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.limits = builder.limits;
                this.requests = builder.requests;
            }

            @Override
            public final java.lang.Object getLimits() {
                return this.limits;
            }

            @Override
            public final java.lang.Object getRequests() {
                return this.requests;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLimits() != null) {
                    data.set("limits", om.valueToTree(this.getLimits()));
                }
                if (this.getRequests() != null) {
                    data.set("requests", om.valueToTree(this.getRequests()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.ResourcesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourcesProperty.Jsii$Proxy that = (ResourcesProperty.Jsii$Proxy) o;

                if (this.limits != null ? !this.limits.equals(that.limits) : that.limits != null) return false;
                return this.requests != null ? this.requests.equals(that.requests) : that.requests == null;
            }

            @Override
            public final int hashCode() {
                int result = this.limits != null ? this.limits.hashCode() : 0;
                result = 31 * result + (this.requests != null ? this.requests.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The retry strategy that's associated with a job.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/job_retries.html">Automated job retries</a> in the <em>AWS Batch User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * RetryStrategyProperty retryStrategyProperty = RetryStrategyProperty.builder()
     *         .attempts(123)
     *         .evaluateOnExit(List.of(EvaluateOnExitProperty.builder()
     *                 .action("action")
     *                 // the properties below are optional
     *                 .onExitCode("onExitCode")
     *                 .onReason("onReason")
     *                 .onStatusReason("onStatusReason")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-retrystrategy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-retrystrategy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.RetryStrategyProperty")
    @software.amazon.jsii.Jsii.Proxy(RetryStrategyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetryStrategyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of times to move a job to the <code>RUNNABLE</code> status.
         * <p>
         * You can specify between 1 and 10 attempts. If the value of <code>attempts</code> is greater than one, the job is retried on failure the same number of attempts as the value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-retrystrategy.html#cfn-batch-jobdefinition-retrystrategy-attempts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-retrystrategy.html#cfn-batch-jobdefinition-retrystrategy-attempts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAttempts() {
            return null;
        }

        /**
         * Array of up to 5 objects that specify the conditions where jobs are retried or failed.
         * <p>
         * If this parameter is specified, then the <code>attempts</code> parameter must also be specified. If none of the listed conditions match, then the job is retried.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-retrystrategy.html#cfn-batch-jobdefinition-retrystrategy-evaluateonexit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-retrystrategy.html#cfn-batch-jobdefinition-retrystrategy-evaluateonexit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEvaluateOnExit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RetryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetryStrategyProperty> {
            java.lang.Number attempts;
            java.lang.Object evaluateOnExit;

            /**
             * Sets the value of {@link RetryStrategyProperty#getAttempts}
             * @param attempts The number of times to move a job to the <code>RUNNABLE</code> status.
             *                 You can specify between 1 and 10 attempts. If the value of <code>attempts</code> is greater than one, the job is retried on failure the same number of attempts as the value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attempts(java.lang.Number attempts) {
                this.attempts = attempts;
                return this;
            }

            /**
             * Sets the value of {@link RetryStrategyProperty#getEvaluateOnExit}
             * @param evaluateOnExit Array of up to 5 objects that specify the conditions where jobs are retried or failed.
             *                       If this parameter is specified, then the <code>attempts</code> parameter must also be specified. If none of the listed conditions match, then the job is retried.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluateOnExit(software.amazon.awscdk.IResolvable evaluateOnExit) {
                this.evaluateOnExit = evaluateOnExit;
                return this;
            }

            /**
             * Sets the value of {@link RetryStrategyProperty#getEvaluateOnExit}
             * @param evaluateOnExit Array of up to 5 objects that specify the conditions where jobs are retried or failed.
             *                       If this parameter is specified, then the <code>attempts</code> parameter must also be specified. If none of the listed conditions match, then the job is retried.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluateOnExit(java.util.List<? extends java.lang.Object> evaluateOnExit) {
                this.evaluateOnExit = evaluateOnExit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetryStrategyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetryStrategyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RetryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetryStrategyProperty {
            private final java.lang.Number attempts;
            private final java.lang.Object evaluateOnExit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attempts = software.amazon.jsii.Kernel.get(this, "attempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.evaluateOnExit = software.amazon.jsii.Kernel.get(this, "evaluateOnExit", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attempts = builder.attempts;
                this.evaluateOnExit = builder.evaluateOnExit;
            }

            @Override
            public final java.lang.Number getAttempts() {
                return this.attempts;
            }

            @Override
            public final java.lang.Object getEvaluateOnExit() {
                return this.evaluateOnExit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttempts() != null) {
                    data.set("attempts", om.valueToTree(this.getAttempts()));
                }
                if (this.getEvaluateOnExit() != null) {
                    data.set("evaluateOnExit", om.valueToTree(this.getEvaluateOnExit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.RetryStrategyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetryStrategyProperty.Jsii$Proxy that = (RetryStrategyProperty.Jsii$Proxy) o;

                if (this.attempts != null ? !this.attempts.equals(that.attempts) : that.attempts != null) return false;
                return this.evaluateOnExit != null ? this.evaluateOnExit.equals(that.evaluateOnExit) : that.evaluateOnExit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attempts != null ? this.attempts.hashCode() : 0;
                result = 31 * result + (this.evaluateOnExit != null ? this.evaluateOnExit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the compute environment architecture for AWS Batch jobs on Fargate.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * RuntimePlatformProperty runtimePlatformProperty = RuntimePlatformProperty.builder()
     *         .cpuArchitecture("cpuArchitecture")
     *         .operatingSystemFamily("operatingSystemFamily")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-runtimeplatform.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-runtimeplatform.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.RuntimePlatformProperty")
    @software.amazon.jsii.Jsii.Proxy(RuntimePlatformProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuntimePlatformProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The vCPU architecture. The default value is <code>X86_64</code> . Valid values are <code>X86_64</code> and <code>ARM64</code> .
         * <p>
         * <blockquote>
         * <p>
         * This parameter must be set to <code>X86_64</code> for Windows containers. &gt; Fargate Spot is not supported for <code>ARM64</code> and Windows-based containers on Fargate. A job queue will be blocked if a Fargate <code>ARM64</code> or Windows job is submitted to a job queue with only Fargate Spot compute environments. However, you can attach both <code>FARGATE</code> and <code>FARGATE_SPOT</code> compute environments to the same job queue.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-runtimeplatform.html#cfn-batch-jobdefinition-runtimeplatform-cpuarchitecture">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-runtimeplatform.html#cfn-batch-jobdefinition-runtimeplatform-cpuarchitecture</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCpuArchitecture() {
            return null;
        }

        /**
         * The operating system for the compute environment.
         * <p>
         * Valid values are: <code>LINUX</code> (default), <code>WINDOWS_SERVER_2019_CORE</code> , <code>WINDOWS_SERVER_2019_FULL</code> , <code>WINDOWS_SERVER_2022_CORE</code> , and <code>WINDOWS_SERVER_2022_FULL</code> .
         * <p>
         * <blockquote>
         * <p>
         * The following parameters can’t be set for Windows containers: <code>linuxParameters</code> , <code>privileged</code> , <code>user</code> , <code>ulimits</code> , <code>readonlyRootFilesystem</code> , and <code>efsVolumeConfiguration</code> . &gt; The AWS Batch Scheduler checks the compute environments that are attached to the job queue before registering a task definition with Fargate. In this scenario, the job queue is where the job is submitted. If the job requires a Windows container and the first compute environment is <code>LINUX</code> , the compute environment is skipped and the next compute environment is checked until a Windows-based compute environment is found. &gt; Fargate Spot is not supported for <code>ARM64</code> and Windows-based containers on Fargate. A job queue will be blocked if a Fargate <code>ARM64</code> or Windows job is submitted to a job queue with only Fargate Spot compute environments. However, you can attach both <code>FARGATE</code> and <code>FARGATE_SPOT</code> compute environments to the same job queue.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-runtimeplatform.html#cfn-batch-jobdefinition-runtimeplatform-operatingsystemfamily">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-runtimeplatform.html#cfn-batch-jobdefinition-runtimeplatform-operatingsystemfamily</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOperatingSystemFamily() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuntimePlatformProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuntimePlatformProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuntimePlatformProperty> {
            java.lang.String cpuArchitecture;
            java.lang.String operatingSystemFamily;

            /**
             * Sets the value of {@link RuntimePlatformProperty#getCpuArchitecture}
             * @param cpuArchitecture The vCPU architecture. The default value is <code>X86_64</code> . Valid values are <code>X86_64</code> and <code>ARM64</code> .
             *                        <blockquote>
             *                        <p>
             *                        This parameter must be set to <code>X86_64</code> for Windows containers. &gt; Fargate Spot is not supported for <code>ARM64</code> and Windows-based containers on Fargate. A job queue will be blocked if a Fargate <code>ARM64</code> or Windows job is submitted to a job queue with only Fargate Spot compute environments. However, you can attach both <code>FARGATE</code> and <code>FARGATE_SPOT</code> compute environments to the same job queue.
             *                        <p>
             *                        </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpuArchitecture(java.lang.String cpuArchitecture) {
                this.cpuArchitecture = cpuArchitecture;
                return this;
            }

            /**
             * Sets the value of {@link RuntimePlatformProperty#getOperatingSystemFamily}
             * @param operatingSystemFamily The operating system for the compute environment.
             *                              Valid values are: <code>LINUX</code> (default), <code>WINDOWS_SERVER_2019_CORE</code> , <code>WINDOWS_SERVER_2019_FULL</code> , <code>WINDOWS_SERVER_2022_CORE</code> , and <code>WINDOWS_SERVER_2022_FULL</code> .
             *                              <p>
             *                              <blockquote>
             *                              <p>
             *                              The following parameters can’t be set for Windows containers: <code>linuxParameters</code> , <code>privileged</code> , <code>user</code> , <code>ulimits</code> , <code>readonlyRootFilesystem</code> , and <code>efsVolumeConfiguration</code> . &gt; The AWS Batch Scheduler checks the compute environments that are attached to the job queue before registering a task definition with Fargate. In this scenario, the job queue is where the job is submitted. If the job requires a Windows container and the first compute environment is <code>LINUX</code> , the compute environment is skipped and the next compute environment is checked until a Windows-based compute environment is found. &gt; Fargate Spot is not supported for <code>ARM64</code> and Windows-based containers on Fargate. A job queue will be blocked if a Fargate <code>ARM64</code> or Windows job is submitted to a job queue with only Fargate Spot compute environments. However, you can attach both <code>FARGATE</code> and <code>FARGATE_SPOT</code> compute environments to the same job queue.
             *                              <p>
             *                              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operatingSystemFamily(java.lang.String operatingSystemFamily) {
                this.operatingSystemFamily = operatingSystemFamily;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuntimePlatformProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuntimePlatformProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuntimePlatformProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuntimePlatformProperty {
            private final java.lang.String cpuArchitecture;
            private final java.lang.String operatingSystemFamily;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cpuArchitecture = software.amazon.jsii.Kernel.get(this, "cpuArchitecture", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.operatingSystemFamily = software.amazon.jsii.Kernel.get(this, "operatingSystemFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cpuArchitecture = builder.cpuArchitecture;
                this.operatingSystemFamily = builder.operatingSystemFamily;
            }

            @Override
            public final java.lang.String getCpuArchitecture() {
                return this.cpuArchitecture;
            }

            @Override
            public final java.lang.String getOperatingSystemFamily() {
                return this.operatingSystemFamily;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCpuArchitecture() != null) {
                    data.set("cpuArchitecture", om.valueToTree(this.getCpuArchitecture()));
                }
                if (this.getOperatingSystemFamily() != null) {
                    data.set("operatingSystemFamily", om.valueToTree(this.getOperatingSystemFamily()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.RuntimePlatformProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuntimePlatformProperty.Jsii$Proxy that = (RuntimePlatformProperty.Jsii$Proxy) o;

                if (this.cpuArchitecture != null ? !this.cpuArchitecture.equals(that.cpuArchitecture) : that.cpuArchitecture != null) return false;
                return this.operatingSystemFamily != null ? this.operatingSystemFamily.equals(that.operatingSystemFamily) : that.operatingSystemFamily == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cpuArchitecture != null ? this.cpuArchitecture.hashCode() : 0;
                result = 31 * result + (this.operatingSystemFamily != null ? this.operatingSystemFamily.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the secret to expose to your container.
     * <p>
     * Secrets can be exposed to a container in the following ways:
     * <p>
     * <ul>
     * <li>To inject sensitive data into your containers as environment variables, use the <code>secrets</code> container definition parameter.</li>
     * <li>To reference sensitive information in the log configuration of a container, use the <code>secretOptions</code> container definition parameter.</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <em>AWS Batch User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * SecretProperty secretProperty = SecretProperty.builder()
     *         .name("name")
     *         .valueFrom("valueFrom")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-secret.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-secret.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.SecretProperty")
    @software.amazon.jsii.Jsii.Proxy(SecretProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SecretProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the secret.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-secret.html#cfn-batch-jobdefinition-secret-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-secret.html#cfn-batch-jobdefinition-secret-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The secret to expose to the container.
         * <p>
         * The supported values are either the full Amazon Resource Name (ARN) of the AWS Secrets Manager secret or the full ARN of the parameter in the AWS Systems Manager Parameter Store.
         * <p>
         * <blockquote>
         * <p>
         * If the AWS Systems Manager Parameter Store parameter exists in the same Region as the job you're launching, then you can use either the full Amazon Resource Name (ARN) or name of the parameter. If the parameter exists in a different Region, then the full ARN must be specified.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-secret.html#cfn-batch-jobdefinition-secret-valuefrom">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-secret.html#cfn-batch-jobdefinition-secret-valuefrom</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValueFrom();

        /**
         * @return a {@link Builder} of {@link SecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SecretProperty> {
            java.lang.String name;
            java.lang.String valueFrom;

            /**
             * Sets the value of {@link SecretProperty#getName}
             * @param name The name of the secret. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SecretProperty#getValueFrom}
             * @param valueFrom The secret to expose to the container. This parameter is required.
             *                  The supported values are either the full Amazon Resource Name (ARN) of the AWS Secrets Manager secret or the full ARN of the parameter in the AWS Systems Manager Parameter Store.
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  If the AWS Systems Manager Parameter Store parameter exists in the same Region as the job you're launching, then you can use either the full Amazon Resource Name (ARN) or name of the parameter. If the parameter exists in a different Region, then the full ARN must be specified.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueFrom(java.lang.String valueFrom) {
                this.valueFrom = valueFrom;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SecretProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SecretProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecretProperty {
            private final java.lang.String name;
            private final java.lang.String valueFrom;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.valueFrom = software.amazon.jsii.Kernel.get(this, "valueFrom", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.valueFrom = java.util.Objects.requireNonNull(builder.valueFrom, "valueFrom is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValueFrom() {
                return this.valueFrom;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("valueFrom", om.valueToTree(this.getValueFrom()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.SecretProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SecretProperty.Jsii$Proxy that = (SecretProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.valueFrom.equals(that.valueFrom);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.valueFrom.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * SecurityContextProperty securityContextProperty = SecurityContextProperty.builder()
     *         .allowPrivilegeEscalation(false)
     *         .privileged(false)
     *         .readOnlyRootFilesystem(false)
     *         .runAsGroup(123)
     *         .runAsNonRoot(false)
     *         .runAsUser(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-securitycontext.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-securitycontext.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.SecurityContextProperty")
    @software.amazon.jsii.Jsii.Proxy(SecurityContextProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SecurityContextProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-securitycontext.html#cfn-batch-jobdefinition-securitycontext-allowprivilegeescalation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-securitycontext.html#cfn-batch-jobdefinition-securitycontext-allowprivilegeescalation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowPrivilegeEscalation() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-securitycontext.html#cfn-batch-jobdefinition-securitycontext-privileged">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-securitycontext.html#cfn-batch-jobdefinition-securitycontext-privileged</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrivileged() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-securitycontext.html#cfn-batch-jobdefinition-securitycontext-readonlyrootfilesystem">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-securitycontext.html#cfn-batch-jobdefinition-securitycontext-readonlyrootfilesystem</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadOnlyRootFilesystem() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-securitycontext.html#cfn-batch-jobdefinition-securitycontext-runasgroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-securitycontext.html#cfn-batch-jobdefinition-securitycontext-runasgroup</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRunAsGroup() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-securitycontext.html#cfn-batch-jobdefinition-securitycontext-runasnonroot">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-securitycontext.html#cfn-batch-jobdefinition-securitycontext-runasnonroot</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRunAsNonRoot() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-securitycontext.html#cfn-batch-jobdefinition-securitycontext-runasuser">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-securitycontext.html#cfn-batch-jobdefinition-securitycontext-runasuser</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRunAsUser() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SecurityContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SecurityContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SecurityContextProperty> {
            java.lang.Object allowPrivilegeEscalation;
            java.lang.Object privileged;
            java.lang.Object readOnlyRootFilesystem;
            java.lang.Number runAsGroup;
            java.lang.Object runAsNonRoot;
            java.lang.Number runAsUser;

            /**
             * Sets the value of {@link SecurityContextProperty#getAllowPrivilegeEscalation}
             * @param allowPrivilegeEscalation the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowPrivilegeEscalation(java.lang.Boolean allowPrivilegeEscalation) {
                this.allowPrivilegeEscalation = allowPrivilegeEscalation;
                return this;
            }

            /**
             * Sets the value of {@link SecurityContextProperty#getAllowPrivilegeEscalation}
             * @param allowPrivilegeEscalation the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowPrivilegeEscalation(software.amazon.awscdk.IResolvable allowPrivilegeEscalation) {
                this.allowPrivilegeEscalation = allowPrivilegeEscalation;
                return this;
            }

            /**
             * Sets the value of {@link SecurityContextProperty#getPrivileged}
             * @param privileged the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privileged(java.lang.Boolean privileged) {
                this.privileged = privileged;
                return this;
            }

            /**
             * Sets the value of {@link SecurityContextProperty#getPrivileged}
             * @param privileged the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privileged(software.amazon.awscdk.IResolvable privileged) {
                this.privileged = privileged;
                return this;
            }

            /**
             * Sets the value of {@link SecurityContextProperty#getReadOnlyRootFilesystem}
             * @param readOnlyRootFilesystem the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnlyRootFilesystem(java.lang.Boolean readOnlyRootFilesystem) {
                this.readOnlyRootFilesystem = readOnlyRootFilesystem;
                return this;
            }

            /**
             * Sets the value of {@link SecurityContextProperty#getReadOnlyRootFilesystem}
             * @param readOnlyRootFilesystem the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnlyRootFilesystem(software.amazon.awscdk.IResolvable readOnlyRootFilesystem) {
                this.readOnlyRootFilesystem = readOnlyRootFilesystem;
                return this;
            }

            /**
             * Sets the value of {@link SecurityContextProperty#getRunAsGroup}
             * @param runAsGroup the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runAsGroup(java.lang.Number runAsGroup) {
                this.runAsGroup = runAsGroup;
                return this;
            }

            /**
             * Sets the value of {@link SecurityContextProperty#getRunAsNonRoot}
             * @param runAsNonRoot the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runAsNonRoot(java.lang.Boolean runAsNonRoot) {
                this.runAsNonRoot = runAsNonRoot;
                return this;
            }

            /**
             * Sets the value of {@link SecurityContextProperty#getRunAsNonRoot}
             * @param runAsNonRoot the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runAsNonRoot(software.amazon.awscdk.IResolvable runAsNonRoot) {
                this.runAsNonRoot = runAsNonRoot;
                return this;
            }

            /**
             * Sets the value of {@link SecurityContextProperty#getRunAsUser}
             * @param runAsUser the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runAsUser(java.lang.Number runAsUser) {
                this.runAsUser = runAsUser;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SecurityContextProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SecurityContextProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SecurityContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecurityContextProperty {
            private final java.lang.Object allowPrivilegeEscalation;
            private final java.lang.Object privileged;
            private final java.lang.Object readOnlyRootFilesystem;
            private final java.lang.Number runAsGroup;
            private final java.lang.Object runAsNonRoot;
            private final java.lang.Number runAsUser;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowPrivilegeEscalation = software.amazon.jsii.Kernel.get(this, "allowPrivilegeEscalation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.privileged = software.amazon.jsii.Kernel.get(this, "privileged", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.readOnlyRootFilesystem = software.amazon.jsii.Kernel.get(this, "readOnlyRootFilesystem", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.runAsGroup = software.amazon.jsii.Kernel.get(this, "runAsGroup", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.runAsNonRoot = software.amazon.jsii.Kernel.get(this, "runAsNonRoot", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.runAsUser = software.amazon.jsii.Kernel.get(this, "runAsUser", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowPrivilegeEscalation = builder.allowPrivilegeEscalation;
                this.privileged = builder.privileged;
                this.readOnlyRootFilesystem = builder.readOnlyRootFilesystem;
                this.runAsGroup = builder.runAsGroup;
                this.runAsNonRoot = builder.runAsNonRoot;
                this.runAsUser = builder.runAsUser;
            }

            @Override
            public final java.lang.Object getAllowPrivilegeEscalation() {
                return this.allowPrivilegeEscalation;
            }

            @Override
            public final java.lang.Object getPrivileged() {
                return this.privileged;
            }

            @Override
            public final java.lang.Object getReadOnlyRootFilesystem() {
                return this.readOnlyRootFilesystem;
            }

            @Override
            public final java.lang.Number getRunAsGroup() {
                return this.runAsGroup;
            }

            @Override
            public final java.lang.Object getRunAsNonRoot() {
                return this.runAsNonRoot;
            }

            @Override
            public final java.lang.Number getRunAsUser() {
                return this.runAsUser;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllowPrivilegeEscalation() != null) {
                    data.set("allowPrivilegeEscalation", om.valueToTree(this.getAllowPrivilegeEscalation()));
                }
                if (this.getPrivileged() != null) {
                    data.set("privileged", om.valueToTree(this.getPrivileged()));
                }
                if (this.getReadOnlyRootFilesystem() != null) {
                    data.set("readOnlyRootFilesystem", om.valueToTree(this.getReadOnlyRootFilesystem()));
                }
                if (this.getRunAsGroup() != null) {
                    data.set("runAsGroup", om.valueToTree(this.getRunAsGroup()));
                }
                if (this.getRunAsNonRoot() != null) {
                    data.set("runAsNonRoot", om.valueToTree(this.getRunAsNonRoot()));
                }
                if (this.getRunAsUser() != null) {
                    data.set("runAsUser", om.valueToTree(this.getRunAsUser()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.SecurityContextProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SecurityContextProperty.Jsii$Proxy that = (SecurityContextProperty.Jsii$Proxy) o;

                if (this.allowPrivilegeEscalation != null ? !this.allowPrivilegeEscalation.equals(that.allowPrivilegeEscalation) : that.allowPrivilegeEscalation != null) return false;
                if (this.privileged != null ? !this.privileged.equals(that.privileged) : that.privileged != null) return false;
                if (this.readOnlyRootFilesystem != null ? !this.readOnlyRootFilesystem.equals(that.readOnlyRootFilesystem) : that.readOnlyRootFilesystem != null) return false;
                if (this.runAsGroup != null ? !this.runAsGroup.equals(that.runAsGroup) : that.runAsGroup != null) return false;
                if (this.runAsNonRoot != null ? !this.runAsNonRoot.equals(that.runAsNonRoot) : that.runAsNonRoot != null) return false;
                return this.runAsUser != null ? this.runAsUser.equals(that.runAsUser) : that.runAsUser == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowPrivilegeEscalation != null ? this.allowPrivilegeEscalation.hashCode() : 0;
                result = 31 * result + (this.privileged != null ? this.privileged.hashCode() : 0);
                result = 31 * result + (this.readOnlyRootFilesystem != null ? this.readOnlyRootFilesystem.hashCode() : 0);
                result = 31 * result + (this.runAsGroup != null ? this.runAsGroup.hashCode() : 0);
                result = 31 * result + (this.runAsNonRoot != null ? this.runAsNonRoot.hashCode() : 0);
                result = 31 * result + (this.runAsUser != null ? this.runAsUser.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A list of containers that this task depends on.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * TaskContainerDependencyProperty taskContainerDependencyProperty = TaskContainerDependencyProperty.builder()
     *         .condition("condition")
     *         .containerName("containerName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerdependency.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerdependency.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.TaskContainerDependencyProperty")
    @software.amazon.jsii.Jsii.Proxy(TaskContainerDependencyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TaskContainerDependencyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The dependency condition of the container. The following are the available conditions and their behavior:.
         * <p>
         * <ul>
         * <li><code>START</code> - This condition emulates the behavior of links and volumes today. It validates that a dependent container is started before permitting other containers to start.</li>
         * <li><code>COMPLETE</code> - This condition validates that a dependent container runs to completion (exits) before permitting other containers to start. This can be useful for nonessential containers that run a script and then exit. This condition can't be set on an essential container.</li>
         * <li><code>SUCCESS</code> - This condition is the same as <code>COMPLETE</code> , but it also requires that the container exits with a zero status. This condition can't be set on an essential container.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerdependency.html#cfn-batch-jobdefinition-taskcontainerdependency-condition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerdependency.html#cfn-batch-jobdefinition-taskcontainerdependency-condition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCondition();

        /**
         * A unique identifier for the container.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerdependency.html#cfn-batch-jobdefinition-taskcontainerdependency-containername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerdependency.html#cfn-batch-jobdefinition-taskcontainerdependency-containername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getContainerName();

        /**
         * @return a {@link Builder} of {@link TaskContainerDependencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TaskContainerDependencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TaskContainerDependencyProperty> {
            java.lang.String condition;
            java.lang.String containerName;

            /**
             * Sets the value of {@link TaskContainerDependencyProperty#getCondition}
             * @param condition The dependency condition of the container. The following are the available conditions and their behavior:. This parameter is required.
             *                  <ul>
             *                  <li><code>START</code> - This condition emulates the behavior of links and volumes today. It validates that a dependent container is started before permitting other containers to start.</li>
             *                  <li><code>COMPLETE</code> - This condition validates that a dependent container runs to completion (exits) before permitting other containers to start. This can be useful for nonessential containers that run a script and then exit. This condition can't be set on an essential container.</li>
             *                  <li><code>SUCCESS</code> - This condition is the same as <code>COMPLETE</code> , but it also requires that the container exits with a zero status. This condition can't be set on an essential container.</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(java.lang.String condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerDependencyProperty#getContainerName}
             * @param containerName A unique identifier for the container. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerName(java.lang.String containerName) {
                this.containerName = containerName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TaskContainerDependencyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TaskContainerDependencyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TaskContainerDependencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TaskContainerDependencyProperty {
            private final java.lang.String condition;
            private final java.lang.String containerName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.containerName = software.amazon.jsii.Kernel.get(this, "containerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.condition = java.util.Objects.requireNonNull(builder.condition, "condition is required");
                this.containerName = java.util.Objects.requireNonNull(builder.containerName, "containerName is required");
            }

            @Override
            public final java.lang.String getCondition() {
                return this.condition;
            }

            @Override
            public final java.lang.String getContainerName() {
                return this.containerName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("condition", om.valueToTree(this.getCondition()));
                data.set("containerName", om.valueToTree(this.getContainerName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.TaskContainerDependencyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TaskContainerDependencyProperty.Jsii$Proxy that = (TaskContainerDependencyProperty.Jsii$Proxy) o;

                if (!condition.equals(that.condition)) return false;
                return this.containerName.equals(that.containerName);
            }

            @Override
            public final int hashCode() {
                int result = this.condition.hashCode();
                result = 31 * result + (this.containerName.hashCode());
                return result;
            }
        }
    }
    /**
     * Container properties are used for Amazon ECS-based job definitions.
     * <p>
     * These properties to describe the container that's launched as part of a job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * Object options;
     * TaskContainerPropertiesProperty taskContainerPropertiesProperty = TaskContainerPropertiesProperty.builder()
     *         .image("image")
     *         // the properties below are optional
     *         .command(List.of("command"))
     *         .dependsOn(List.of(TaskContainerDependencyProperty.builder()
     *                 .condition("condition")
     *                 .containerName("containerName")
     *                 .build()))
     *         .environment(List.of(EnvironmentProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .essential(false)
     *         .linuxParameters(LinuxParametersProperty.builder()
     *                 .devices(List.of(DeviceProperty.builder()
     *                         .containerPath("containerPath")
     *                         .hostPath("hostPath")
     *                         .permissions(List.of("permissions"))
     *                         .build()))
     *                 .initProcessEnabled(false)
     *                 .maxSwap(123)
     *                 .sharedMemorySize(123)
     *                 .swappiness(123)
     *                 .tmpfs(List.of(TmpfsProperty.builder()
     *                         .containerPath("containerPath")
     *                         .size(123)
     *                         // the properties below are optional
     *                         .mountOptions(List.of("mountOptions"))
     *                         .build()))
     *                 .build())
     *         .logConfiguration(LogConfigurationProperty.builder()
     *                 .logDriver("logDriver")
     *                 // the properties below are optional
     *                 .options(options)
     *                 .secretOptions(List.of(SecretProperty.builder()
     *                         .name("name")
     *                         .valueFrom("valueFrom")
     *                         .build()))
     *                 .build())
     *         .mountPoints(List.of(MountPointProperty.builder()
     *                 .containerPath("containerPath")
     *                 .readOnly(false)
     *                 .sourceVolume("sourceVolume")
     *                 .build()))
     *         .name("name")
     *         .privileged(false)
     *         .readonlyRootFilesystem(false)
     *         .repositoryCredentials(RepositoryCredentialsProperty.builder()
     *                 .credentialsParameter("credentialsParameter")
     *                 .build())
     *         .resourceRequirements(List.of(ResourceRequirementProperty.builder()
     *                 .type("type")
     *                 .value("value")
     *                 .build()))
     *         .secrets(List.of(SecretProperty.builder()
     *                 .name("name")
     *                 .valueFrom("valueFrom")
     *                 .build()))
     *         .ulimits(List.of(UlimitProperty.builder()
     *                 .hardLimit(123)
     *                 .name("name")
     *                 .softLimit(123)
     *                 .build()))
     *         .user("user")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.TaskContainerPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(TaskContainerPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TaskContainerPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The image used to start a container.
         * <p>
         * This string is passed directly to the Docker daemon. By default, images in the Docker Hub registry are available. Other repositories are specified with either <code>repository-url/image:tag</code> or <code>repository-url/image&#64;digest</code> . Up to 255 letters (uppercase and lowercase), numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are allowed. This parameter maps to <code>Image</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>IMAGE</code> parameter of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration"><em>docker run</em></a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-image">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-image</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImage();

        /**
         * The command that's passed to the container.
         * <p>
         * This parameter maps to <code>Cmd</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>COMMAND</code> parameter to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd">Dockerfile reference: CMD</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-command">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-command</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
            return null;
        }

        /**
         * A list of containers that this container depends on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-dependson">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-dependson</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDependsOn() {
            return null;
        }

        /**
         * The environment variables to pass to a container.
         * <p>
         * This parameter maps to Env in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--env</code> parameter to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
         * <p>
         * <blockquote>
         * <p>
         * We don't recommend using plaintext environment variables for sensitive information, such as credential data. &gt; Environment variables cannot start with <code>AWS_BATCH</code> . This naming convention is reserved for variables that AWS Batch sets.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-environment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-environment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
            return null;
        }

        /**
         * If the essential parameter of a container is marked as <code>true</code> , and that container fails or stops for any reason, all other containers that are part of the task are stopped.
         * <p>
         * If the <code>essential</code> parameter of a container is marked as false, its failure doesn't affect the rest of the containers in a task. If this parameter is omitted, a container is assumed to be essential.
         * <p>
         * All jobs must have at least one essential container. If you have an application that's composed of multiple containers, group containers that are used for a common purpose into components, and separate the different components into multiple task definitions. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html">Application Architecture</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-essential">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-essential</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEssential() {
            return null;
        }

        /**
         * Linux-specific modifications that are applied to the container, such as Linux kernel capabilities.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html">KernelCapabilities</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-linuxparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-linuxparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLinuxParameters() {
            return null;
        }

        /**
         * The log configuration specification for the container.
         * <p>
         * This parameter maps to <code>LogConfig</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--log-driver</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a> .
         * <p>
         * By default, containers use the same logging driver that the Docker daemon uses. However the container can use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information about the options for different supported log drivers, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the <em>Docker documentation</em> .
         * <p>
         * <blockquote>
         * <p>
         * Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon (shown in the <code>LogConfiguration</code> data type). Additional log drivers may be available in future releases of the Amazon ECS container agent.
         * <p>
         * </blockquote>
         * <p>
         * This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: sudo docker version <code>--format '{{.Server.APIVersion}}'</code>
         * <p>
         * <blockquote>
         * <p>
         * The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before containers placed on that instance can use these log configuration options. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS container agent configuration</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-logconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-logconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLogConfiguration() {
            return null;
        }

        /**
         * The mount points for data volumes in your container.
         * <p>
         * This parameter maps to <code>Volumes</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <a href="https://docs.aws.amazon.com/">--volume</a> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a> .
         * <p>
         * Windows containers can mount whole directories on the same drive as <code>$env:ProgramData</code> . Windows containers can't mount directories on a different drive, and mount point can't be across drives.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-mountpoints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-mountpoints</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMountPoints() {
            return null;
        }

        /**
         * The name of a container.
         * <p>
         * The name can be used as a unique identifier to target your <code>dependsOn</code> and <code>Overrides</code> objects.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * When this parameter is <code>true</code> , the container is given elevated privileges on the host container instance (similar to the <code>root</code> user).
         * <p>
         * This parameter maps to <code>Privileged</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--privileged</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a> .
         * <p>
         * <blockquote>
         * <p>
         * This parameter is not supported for Windows containers or tasks run on Fargate.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-privileged">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-privileged</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrivileged() {
            return null;
        }

        /**
         * When this parameter is true, the container is given read-only access to its root file system.
         * <p>
         * This parameter maps to <code>ReadonlyRootfs</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--read-only</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a> .
         * <p>
         * <blockquote>
         * <p>
         * This parameter is not supported for Windows containers.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-readonlyrootfilesystem">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-readonlyrootfilesystem</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadonlyRootFilesystem() {
            return null;
        }

        /**
         * The private repository authentication credentials to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-repositorycredentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-repositorycredentials</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRepositoryCredentials() {
            return null;
        }

        /**
         * The type and amount of a resource to assign to a container.
         * <p>
         * The only supported resource is a GPU.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-resourcerequirements">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-resourcerequirements</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceRequirements() {
            return null;
        }

        /**
         * The secrets to pass to the container.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying Sensitive Data</a> in the Amazon Elastic Container Service Developer Guide.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-secrets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-secrets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecrets() {
            return null;
        }

        /**
         * A list of <code>ulimits</code> to set in the container.
         * <p>
         * If a <code>ulimit</code> value is specified in a task definition, it overrides the default values set by Docker. This parameter maps to <code>Ulimits</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--ulimit</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a> .
         * <p>
         * Amazon ECS tasks hosted on Fargate use the default resource limit values set by the operating system with the exception of the nofile resource limit parameter which Fargate overrides. The <code>nofile</code> resource limit sets a restriction on the number of open files that a container can use. The default <code>nofile</code> soft limit is <code>1024</code> and the default hard limit is <code>65535</code> .
         * <p>
         * This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: sudo docker version <code>--format '{{.Server.APIVersion}}'</code>
         * <p>
         * <blockquote>
         * <p>
         * This parameter is not supported for Windows containers.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-ulimits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-ulimits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUlimits() {
            return null;
        }

        /**
         * The user to use inside the container.
         * <p>
         * This parameter maps to User in the Create a container section of the Docker Remote API and the --user option to docker run.
         * <p>
         * <blockquote>
         * <p>
         * When running tasks using the <code>host</code> network mode, don't run containers using the <code>root user (UID 0)</code> . We recommend using a non-root user for better security.
         * <p>
         * </blockquote>
         * <p>
         * You can specify the <code>user</code> using the following formats. If specifying a UID or GID, you must specify it as a positive integer.
         * <p>
         * <ul>
         * <li><code>user</code></li>
         * <li><code>user:group</code></li>
         * <li><code>uid</code></li>
         * <li><code>uid:gid</code></li>
         * <li><code>user:gi</code></li>
         * <li><code>uid:group</code></li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * This parameter is not supported for Windows containers.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-user">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-taskcontainerproperties.html#cfn-batch-jobdefinition-taskcontainerproperties-user</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUser() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TaskContainerPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TaskContainerPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TaskContainerPropertiesProperty> {
            java.lang.String image;
            java.util.List<java.lang.String> command;
            java.lang.Object dependsOn;
            java.lang.Object environment;
            java.lang.Object essential;
            java.lang.Object linuxParameters;
            java.lang.Object logConfiguration;
            java.lang.Object mountPoints;
            java.lang.String name;
            java.lang.Object privileged;
            java.lang.Object readonlyRootFilesystem;
            java.lang.Object repositoryCredentials;
            java.lang.Object resourceRequirements;
            java.lang.Object secrets;
            java.lang.Object ulimits;
            java.lang.String user;

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getImage}
             * @param image The image used to start a container. This parameter is required.
             *              This string is passed directly to the Docker daemon. By default, images in the Docker Hub registry are available. Other repositories are specified with either <code>repository-url/image:tag</code> or <code>repository-url/image&#64;digest</code> . Up to 255 letters (uppercase and lowercase), numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are allowed. This parameter maps to <code>Image</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>IMAGE</code> parameter of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration"><em>docker run</em></a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder image(java.lang.String image) {
                this.image = image;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getCommand}
             * @param command The command that's passed to the container.
             *                This parameter maps to <code>Cmd</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>COMMAND</code> parameter to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd">Dockerfile reference: CMD</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder command(java.util.List<java.lang.String> command) {
                this.command = command;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getDependsOn}
             * @param dependsOn A list of containers that this container depends on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dependsOn(software.amazon.awscdk.IResolvable dependsOn) {
                this.dependsOn = dependsOn;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getDependsOn}
             * @param dependsOn A list of containers that this container depends on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dependsOn(java.util.List<? extends java.lang.Object> dependsOn) {
                this.dependsOn = dependsOn;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getEnvironment}
             * @param environment The environment variables to pass to a container.
             *                    This parameter maps to Env in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--env</code> parameter to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             *                    <p>
             *                    <blockquote>
             *                    <p>
             *                    We don't recommend using plaintext environment variables for sensitive information, such as credential data. &gt; Environment variables cannot start with <code>AWS_BATCH</code> . This naming convention is reserved for variables that AWS Batch sets.
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(software.amazon.awscdk.IResolvable environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getEnvironment}
             * @param environment The environment variables to pass to a container.
             *                    This parameter maps to Env in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--env</code> parameter to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             *                    <p>
             *                    <blockquote>
             *                    <p>
             *                    We don't recommend using plaintext environment variables for sensitive information, such as credential data. &gt; Environment variables cannot start with <code>AWS_BATCH</code> . This naming convention is reserved for variables that AWS Batch sets.
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(java.util.List<? extends java.lang.Object> environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getEssential}
             * @param essential If the essential parameter of a container is marked as <code>true</code> , and that container fails or stops for any reason, all other containers that are part of the task are stopped.
             *                  If the <code>essential</code> parameter of a container is marked as false, its failure doesn't affect the rest of the containers in a task. If this parameter is omitted, a container is assumed to be essential.
             *                  <p>
             *                  All jobs must have at least one essential container. If you have an application that's composed of multiple containers, group containers that are used for a common purpose into components, and separate the different components into multiple task definitions. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html">Application Architecture</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder essential(java.lang.Boolean essential) {
                this.essential = essential;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getEssential}
             * @param essential If the essential parameter of a container is marked as <code>true</code> , and that container fails or stops for any reason, all other containers that are part of the task are stopped.
             *                  If the <code>essential</code> parameter of a container is marked as false, its failure doesn't affect the rest of the containers in a task. If this parameter is omitted, a container is assumed to be essential.
             *                  <p>
             *                  All jobs must have at least one essential container. If you have an application that's composed of multiple containers, group containers that are used for a common purpose into components, and separate the different components into multiple task definitions. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html">Application Architecture</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder essential(software.amazon.awscdk.IResolvable essential) {
                this.essential = essential;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getLinuxParameters}
             * @param linuxParameters Linux-specific modifications that are applied to the container, such as Linux kernel capabilities.
             *                        For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html">KernelCapabilities</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder linuxParameters(software.amazon.awscdk.IResolvable linuxParameters) {
                this.linuxParameters = linuxParameters;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getLinuxParameters}
             * @param linuxParameters Linux-specific modifications that are applied to the container, such as Linux kernel capabilities.
             *                        For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html">KernelCapabilities</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder linuxParameters(software.amazon.awscdk.services.batch.CfnJobDefinition.LinuxParametersProperty linuxParameters) {
                this.linuxParameters = linuxParameters;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getLogConfiguration}
             * @param logConfiguration The log configuration specification for the container.
             *                         This parameter maps to <code>LogConfig</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--log-driver</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a> .
             *                         <p>
             *                         By default, containers use the same logging driver that the Docker daemon uses. However the container can use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information about the options for different supported log drivers, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the <em>Docker documentation</em> .
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon (shown in the <code>LogConfiguration</code> data type). Additional log drivers may be available in future releases of the Amazon ECS container agent.
             *                         <p>
             *                         </blockquote>
             *                         <p>
             *                         This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: sudo docker version <code>--format '{{.Server.APIVersion}}'</code>
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before containers placed on that instance can use these log configuration options. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS container agent configuration</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logConfiguration(software.amazon.awscdk.IResolvable logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getLogConfiguration}
             * @param logConfiguration The log configuration specification for the container.
             *                         This parameter maps to <code>LogConfig</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--log-driver</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a> .
             *                         <p>
             *                         By default, containers use the same logging driver that the Docker daemon uses. However the container can use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information about the options for different supported log drivers, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the <em>Docker documentation</em> .
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon (shown in the <code>LogConfiguration</code> data type). Additional log drivers may be available in future releases of the Amazon ECS container agent.
             *                         <p>
             *                         </blockquote>
             *                         <p>
             *                         This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: sudo docker version <code>--format '{{.Server.APIVersion}}'</code>
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before containers placed on that instance can use these log configuration options. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS container agent configuration</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logConfiguration(software.amazon.awscdk.services.batch.CfnJobDefinition.LogConfigurationProperty logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getMountPoints}
             * @param mountPoints The mount points for data volumes in your container.
             *                    This parameter maps to <code>Volumes</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <a href="https://docs.aws.amazon.com/">--volume</a> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a> .
             *                    <p>
             *                    Windows containers can mount whole directories on the same drive as <code>$env:ProgramData</code> . Windows containers can't mount directories on a different drive, and mount point can't be across drives.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountPoints(software.amazon.awscdk.IResolvable mountPoints) {
                this.mountPoints = mountPoints;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getMountPoints}
             * @param mountPoints The mount points for data volumes in your container.
             *                    This parameter maps to <code>Volumes</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <a href="https://docs.aws.amazon.com/">--volume</a> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a> .
             *                    <p>
             *                    Windows containers can mount whole directories on the same drive as <code>$env:ProgramData</code> . Windows containers can't mount directories on a different drive, and mount point can't be across drives.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountPoints(java.util.List<? extends java.lang.Object> mountPoints) {
                this.mountPoints = mountPoints;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getName}
             * @param name The name of a container.
             *             The name can be used as a unique identifier to target your <code>dependsOn</code> and <code>Overrides</code> objects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getPrivileged}
             * @param privileged When this parameter is <code>true</code> , the container is given elevated privileges on the host container instance (similar to the <code>root</code> user).
             *                   This parameter maps to <code>Privileged</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--privileged</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a> .
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   This parameter is not supported for Windows containers or tasks run on Fargate.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privileged(java.lang.Boolean privileged) {
                this.privileged = privileged;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getPrivileged}
             * @param privileged When this parameter is <code>true</code> , the container is given elevated privileges on the host container instance (similar to the <code>root</code> user).
             *                   This parameter maps to <code>Privileged</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--privileged</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a> .
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   This parameter is not supported for Windows containers or tasks run on Fargate.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privileged(software.amazon.awscdk.IResolvable privileged) {
                this.privileged = privileged;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getReadonlyRootFilesystem}
             * @param readonlyRootFilesystem When this parameter is true, the container is given read-only access to its root file system.
             *                               This parameter maps to <code>ReadonlyRootfs</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--read-only</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a> .
             *                               <p>
             *                               <blockquote>
             *                               <p>
             *                               This parameter is not supported for Windows containers.
             *                               <p>
             *                               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readonlyRootFilesystem(java.lang.Boolean readonlyRootFilesystem) {
                this.readonlyRootFilesystem = readonlyRootFilesystem;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getReadonlyRootFilesystem}
             * @param readonlyRootFilesystem When this parameter is true, the container is given read-only access to its root file system.
             *                               This parameter maps to <code>ReadonlyRootfs</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--read-only</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a> .
             *                               <p>
             *                               <blockquote>
             *                               <p>
             *                               This parameter is not supported for Windows containers.
             *                               <p>
             *                               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readonlyRootFilesystem(software.amazon.awscdk.IResolvable readonlyRootFilesystem) {
                this.readonlyRootFilesystem = readonlyRootFilesystem;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getRepositoryCredentials}
             * @param repositoryCredentials The private repository authentication credentials to use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repositoryCredentials(software.amazon.awscdk.IResolvable repositoryCredentials) {
                this.repositoryCredentials = repositoryCredentials;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getRepositoryCredentials}
             * @param repositoryCredentials The private repository authentication credentials to use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repositoryCredentials(software.amazon.awscdk.services.batch.CfnJobDefinition.RepositoryCredentialsProperty repositoryCredentials) {
                this.repositoryCredentials = repositoryCredentials;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getResourceRequirements}
             * @param resourceRequirements The type and amount of a resource to assign to a container.
             *                             The only supported resource is a GPU.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceRequirements(software.amazon.awscdk.IResolvable resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getResourceRequirements}
             * @param resourceRequirements The type and amount of a resource to assign to a container.
             *                             The only supported resource is a GPU.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceRequirements(java.util.List<? extends java.lang.Object> resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getSecrets}
             * @param secrets The secrets to pass to the container.
             *                For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying Sensitive Data</a> in the Amazon Elastic Container Service Developer Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secrets(software.amazon.awscdk.IResolvable secrets) {
                this.secrets = secrets;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getSecrets}
             * @param secrets The secrets to pass to the container.
             *                For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying Sensitive Data</a> in the Amazon Elastic Container Service Developer Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secrets(java.util.List<? extends java.lang.Object> secrets) {
                this.secrets = secrets;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getUlimits}
             * @param ulimits A list of <code>ulimits</code> to set in the container.
             *                If a <code>ulimit</code> value is specified in a task definition, it overrides the default values set by Docker. This parameter maps to <code>Ulimits</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--ulimit</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a> .
             *                <p>
             *                Amazon ECS tasks hosted on Fargate use the default resource limit values set by the operating system with the exception of the nofile resource limit parameter which Fargate overrides. The <code>nofile</code> resource limit sets a restriction on the number of open files that a container can use. The default <code>nofile</code> soft limit is <code>1024</code> and the default hard limit is <code>65535</code> .
             *                <p>
             *                This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: sudo docker version <code>--format '{{.Server.APIVersion}}'</code>
             *                <p>
             *                <blockquote>
             *                <p>
             *                This parameter is not supported for Windows containers.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ulimits(software.amazon.awscdk.IResolvable ulimits) {
                this.ulimits = ulimits;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getUlimits}
             * @param ulimits A list of <code>ulimits</code> to set in the container.
             *                If a <code>ulimit</code> value is specified in a task definition, it overrides the default values set by Docker. This parameter maps to <code>Ulimits</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--ulimit</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a> .
             *                <p>
             *                Amazon ECS tasks hosted on Fargate use the default resource limit values set by the operating system with the exception of the nofile resource limit parameter which Fargate overrides. The <code>nofile</code> resource limit sets a restriction on the number of open files that a container can use. The default <code>nofile</code> soft limit is <code>1024</code> and the default hard limit is <code>65535</code> .
             *                <p>
             *                This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: sudo docker version <code>--format '{{.Server.APIVersion}}'</code>
             *                <p>
             *                <blockquote>
             *                <p>
             *                This parameter is not supported for Windows containers.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ulimits(java.util.List<? extends java.lang.Object> ulimits) {
                this.ulimits = ulimits;
                return this;
            }

            /**
             * Sets the value of {@link TaskContainerPropertiesProperty#getUser}
             * @param user The user to use inside the container.
             *             This parameter maps to User in the Create a container section of the Docker Remote API and the --user option to docker run.
             *             <p>
             *             <blockquote>
             *             <p>
             *             When running tasks using the <code>host</code> network mode, don't run containers using the <code>root user (UID 0)</code> . We recommend using a non-root user for better security.
             *             <p>
             *             </blockquote>
             *             <p>
             *             You can specify the <code>user</code> using the following formats. If specifying a UID or GID, you must specify it as a positive integer.
             *             <p>
             *             <ul>
             *             <li><code>user</code></li>
             *             <li><code>user:group</code></li>
             *             <li><code>uid</code></li>
             *             <li><code>uid:gid</code></li>
             *             <li><code>user:gi</code></li>
             *             <li><code>uid:group</code></li>
             *             </ul>
             *             <p>
             *             <blockquote>
             *             <p>
             *             This parameter is not supported for Windows containers.
             *             <p>
             *             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder user(java.lang.String user) {
                this.user = user;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TaskContainerPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TaskContainerPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TaskContainerPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TaskContainerPropertiesProperty {
            private final java.lang.String image;
            private final java.util.List<java.lang.String> command;
            private final java.lang.Object dependsOn;
            private final java.lang.Object environment;
            private final java.lang.Object essential;
            private final java.lang.Object linuxParameters;
            private final java.lang.Object logConfiguration;
            private final java.lang.Object mountPoints;
            private final java.lang.String name;
            private final java.lang.Object privileged;
            private final java.lang.Object readonlyRootFilesystem;
            private final java.lang.Object repositoryCredentials;
            private final java.lang.Object resourceRequirements;
            private final java.lang.Object secrets;
            private final java.lang.Object ulimits;
            private final java.lang.String user;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.dependsOn = software.amazon.jsii.Kernel.get(this, "dependsOn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.essential = software.amazon.jsii.Kernel.get(this, "essential", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.linuxParameters = software.amazon.jsii.Kernel.get(this, "linuxParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logConfiguration = software.amazon.jsii.Kernel.get(this, "logConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mountPoints = software.amazon.jsii.Kernel.get(this, "mountPoints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.privileged = software.amazon.jsii.Kernel.get(this, "privileged", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.readonlyRootFilesystem = software.amazon.jsii.Kernel.get(this, "readonlyRootFilesystem", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.repositoryCredentials = software.amazon.jsii.Kernel.get(this, "repositoryCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceRequirements = software.amazon.jsii.Kernel.get(this, "resourceRequirements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secrets = software.amazon.jsii.Kernel.get(this, "secrets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ulimits = software.amazon.jsii.Kernel.get(this, "ulimits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.image = java.util.Objects.requireNonNull(builder.image, "image is required");
                this.command = builder.command;
                this.dependsOn = builder.dependsOn;
                this.environment = builder.environment;
                this.essential = builder.essential;
                this.linuxParameters = builder.linuxParameters;
                this.logConfiguration = builder.logConfiguration;
                this.mountPoints = builder.mountPoints;
                this.name = builder.name;
                this.privileged = builder.privileged;
                this.readonlyRootFilesystem = builder.readonlyRootFilesystem;
                this.repositoryCredentials = builder.repositoryCredentials;
                this.resourceRequirements = builder.resourceRequirements;
                this.secrets = builder.secrets;
                this.ulimits = builder.ulimits;
                this.user = builder.user;
            }

            @Override
            public final java.lang.String getImage() {
                return this.image;
            }

            @Override
            public final java.util.List<java.lang.String> getCommand() {
                return this.command;
            }

            @Override
            public final java.lang.Object getDependsOn() {
                return this.dependsOn;
            }

            @Override
            public final java.lang.Object getEnvironment() {
                return this.environment;
            }

            @Override
            public final java.lang.Object getEssential() {
                return this.essential;
            }

            @Override
            public final java.lang.Object getLinuxParameters() {
                return this.linuxParameters;
            }

            @Override
            public final java.lang.Object getLogConfiguration() {
                return this.logConfiguration;
            }

            @Override
            public final java.lang.Object getMountPoints() {
                return this.mountPoints;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getPrivileged() {
                return this.privileged;
            }

            @Override
            public final java.lang.Object getReadonlyRootFilesystem() {
                return this.readonlyRootFilesystem;
            }

            @Override
            public final java.lang.Object getRepositoryCredentials() {
                return this.repositoryCredentials;
            }

            @Override
            public final java.lang.Object getResourceRequirements() {
                return this.resourceRequirements;
            }

            @Override
            public final java.lang.Object getSecrets() {
                return this.secrets;
            }

            @Override
            public final java.lang.Object getUlimits() {
                return this.ulimits;
            }

            @Override
            public final java.lang.String getUser() {
                return this.user;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("image", om.valueToTree(this.getImage()));
                if (this.getCommand() != null) {
                    data.set("command", om.valueToTree(this.getCommand()));
                }
                if (this.getDependsOn() != null) {
                    data.set("dependsOn", om.valueToTree(this.getDependsOn()));
                }
                if (this.getEnvironment() != null) {
                    data.set("environment", om.valueToTree(this.getEnvironment()));
                }
                if (this.getEssential() != null) {
                    data.set("essential", om.valueToTree(this.getEssential()));
                }
                if (this.getLinuxParameters() != null) {
                    data.set("linuxParameters", om.valueToTree(this.getLinuxParameters()));
                }
                if (this.getLogConfiguration() != null) {
                    data.set("logConfiguration", om.valueToTree(this.getLogConfiguration()));
                }
                if (this.getMountPoints() != null) {
                    data.set("mountPoints", om.valueToTree(this.getMountPoints()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getPrivileged() != null) {
                    data.set("privileged", om.valueToTree(this.getPrivileged()));
                }
                if (this.getReadonlyRootFilesystem() != null) {
                    data.set("readonlyRootFilesystem", om.valueToTree(this.getReadonlyRootFilesystem()));
                }
                if (this.getRepositoryCredentials() != null) {
                    data.set("repositoryCredentials", om.valueToTree(this.getRepositoryCredentials()));
                }
                if (this.getResourceRequirements() != null) {
                    data.set("resourceRequirements", om.valueToTree(this.getResourceRequirements()));
                }
                if (this.getSecrets() != null) {
                    data.set("secrets", om.valueToTree(this.getSecrets()));
                }
                if (this.getUlimits() != null) {
                    data.set("ulimits", om.valueToTree(this.getUlimits()));
                }
                if (this.getUser() != null) {
                    data.set("user", om.valueToTree(this.getUser()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.TaskContainerPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TaskContainerPropertiesProperty.Jsii$Proxy that = (TaskContainerPropertiesProperty.Jsii$Proxy) o;

                if (!image.equals(that.image)) return false;
                if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
                if (this.dependsOn != null ? !this.dependsOn.equals(that.dependsOn) : that.dependsOn != null) return false;
                if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
                if (this.essential != null ? !this.essential.equals(that.essential) : that.essential != null) return false;
                if (this.linuxParameters != null ? !this.linuxParameters.equals(that.linuxParameters) : that.linuxParameters != null) return false;
                if (this.logConfiguration != null ? !this.logConfiguration.equals(that.logConfiguration) : that.logConfiguration != null) return false;
                if (this.mountPoints != null ? !this.mountPoints.equals(that.mountPoints) : that.mountPoints != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.privileged != null ? !this.privileged.equals(that.privileged) : that.privileged != null) return false;
                if (this.readonlyRootFilesystem != null ? !this.readonlyRootFilesystem.equals(that.readonlyRootFilesystem) : that.readonlyRootFilesystem != null) return false;
                if (this.repositoryCredentials != null ? !this.repositoryCredentials.equals(that.repositoryCredentials) : that.repositoryCredentials != null) return false;
                if (this.resourceRequirements != null ? !this.resourceRequirements.equals(that.resourceRequirements) : that.resourceRequirements != null) return false;
                if (this.secrets != null ? !this.secrets.equals(that.secrets) : that.secrets != null) return false;
                if (this.ulimits != null ? !this.ulimits.equals(that.ulimits) : that.ulimits != null) return false;
                return this.user != null ? this.user.equals(that.user) : that.user == null;
            }

            @Override
            public final int hashCode() {
                int result = this.image.hashCode();
                result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
                result = 31 * result + (this.dependsOn != null ? this.dependsOn.hashCode() : 0);
                result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
                result = 31 * result + (this.essential != null ? this.essential.hashCode() : 0);
                result = 31 * result + (this.linuxParameters != null ? this.linuxParameters.hashCode() : 0);
                result = 31 * result + (this.logConfiguration != null ? this.logConfiguration.hashCode() : 0);
                result = 31 * result + (this.mountPoints != null ? this.mountPoints.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.privileged != null ? this.privileged.hashCode() : 0);
                result = 31 * result + (this.readonlyRootFilesystem != null ? this.readonlyRootFilesystem.hashCode() : 0);
                result = 31 * result + (this.repositoryCredentials != null ? this.repositoryCredentials.hashCode() : 0);
                result = 31 * result + (this.resourceRequirements != null ? this.resourceRequirements.hashCode() : 0);
                result = 31 * result + (this.secrets != null ? this.secrets.hashCode() : 0);
                result = 31 * result + (this.ulimits != null ? this.ulimits.hashCode() : 0);
                result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * TimeoutProperty timeoutProperty = TimeoutProperty.builder()
     *         .attemptDurationSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-timeout.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-timeout.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.TimeoutProperty")
    @software.amazon.jsii.Jsii.Proxy(TimeoutProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimeoutProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-timeout.html#cfn-batch-jobdefinition-timeout-attemptdurationseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-timeout.html#cfn-batch-jobdefinition-timeout-attemptdurationseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAttemptDurationSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimeoutProperty> {
            java.lang.Number attemptDurationSeconds;

            /**
             * Sets the value of {@link TimeoutProperty#getAttemptDurationSeconds}
             * @param attemptDurationSeconds the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attemptDurationSeconds(java.lang.Number attemptDurationSeconds) {
                this.attemptDurationSeconds = attemptDurationSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimeoutProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimeoutProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimeoutProperty {
            private final java.lang.Number attemptDurationSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attemptDurationSeconds = software.amazon.jsii.Kernel.get(this, "attemptDurationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attemptDurationSeconds = builder.attemptDurationSeconds;
            }

            @Override
            public final java.lang.Number getAttemptDurationSeconds() {
                return this.attemptDurationSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttemptDurationSeconds() != null) {
                    data.set("attemptDurationSeconds", om.valueToTree(this.getAttemptDurationSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.TimeoutProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimeoutProperty.Jsii$Proxy that = (TimeoutProperty.Jsii$Proxy) o;

                return this.attemptDurationSeconds != null ? this.attemptDurationSeconds.equals(that.attemptDurationSeconds) : that.attemptDurationSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attemptDurationSeconds != null ? this.attemptDurationSeconds.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The container path, mount options, and size of the <code>tmpfs</code> mount.
     * <p>
     * <blockquote>
     * <p>
     * This object isn't applicable to jobs that are running on Fargate resources.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * TmpfsProperty tmpfsProperty = TmpfsProperty.builder()
     *         .containerPath("containerPath")
     *         .size(123)
     *         // the properties below are optional
     *         .mountOptions(List.of("mountOptions"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-tmpfs.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-tmpfs.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.TmpfsProperty")
    @software.amazon.jsii.Jsii.Proxy(TmpfsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TmpfsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The absolute file path in the container where the <code>tmpfs</code> volume is mounted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-tmpfs.html#cfn-batch-jobdefinition-tmpfs-containerpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-tmpfs.html#cfn-batch-jobdefinition-tmpfs-containerpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getContainerPath();

        /**
         * The size (in MiB) of the <code>tmpfs</code> volume.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-tmpfs.html#cfn-batch-jobdefinition-tmpfs-size">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-tmpfs.html#cfn-batch-jobdefinition-tmpfs-size</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getSize();

        /**
         * The list of <code>tmpfs</code> volume mount options.
         * <p>
         * Valid values: " <code>defaults</code> " | " <code>ro</code> " | " <code>rw</code> " | " <code>suid</code> " | " <code>nosuid</code> " | " <code>dev</code> " | " <code>nodev</code> " | " <code>exec</code> " | " <code>noexec</code> " | " <code>sync</code> " | " <code>async</code> " | " <code>dirsync</code> " | " <code>remount</code> " | " <code>mand</code> " | " <code>nomand</code> " | " <code>atime</code> " | " <code>noatime</code> " | " <code>diratime</code> " | " <code>nodiratime</code> " | " <code>bind</code> " | " <code>rbind" | "unbindable" | "runbindable" | "private" | "rprivate" | "shared" | "rshared" | "slave" | "rslave" | "relatime</code> " | " <code>norelatime</code> " | " <code>strictatime</code> " | " <code>nostrictatime</code> " | " <code>mode</code> " | " <code>uid</code> " | " <code>gid</code> " | " <code>nr_inodes</code> " | " <code>nr_blocks</code> " | " <code>mpol</code> "
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-tmpfs.html#cfn-batch-jobdefinition-tmpfs-mountoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-tmpfs.html#cfn-batch-jobdefinition-tmpfs-mountoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMountOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TmpfsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TmpfsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TmpfsProperty> {
            java.lang.String containerPath;
            java.lang.Number size;
            java.util.List<java.lang.String> mountOptions;

            /**
             * Sets the value of {@link TmpfsProperty#getContainerPath}
             * @param containerPath The absolute file path in the container where the <code>tmpfs</code> volume is mounted. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPath(java.lang.String containerPath) {
                this.containerPath = containerPath;
                return this;
            }

            /**
             * Sets the value of {@link TmpfsProperty#getSize}
             * @param size The size (in MiB) of the <code>tmpfs</code> volume. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder size(java.lang.Number size) {
                this.size = size;
                return this;
            }

            /**
             * Sets the value of {@link TmpfsProperty#getMountOptions}
             * @param mountOptions The list of <code>tmpfs</code> volume mount options.
             *                     Valid values: " <code>defaults</code> " | " <code>ro</code> " | " <code>rw</code> " | " <code>suid</code> " | " <code>nosuid</code> " | " <code>dev</code> " | " <code>nodev</code> " | " <code>exec</code> " | " <code>noexec</code> " | " <code>sync</code> " | " <code>async</code> " | " <code>dirsync</code> " | " <code>remount</code> " | " <code>mand</code> " | " <code>nomand</code> " | " <code>atime</code> " | " <code>noatime</code> " | " <code>diratime</code> " | " <code>nodiratime</code> " | " <code>bind</code> " | " <code>rbind" | "unbindable" | "runbindable" | "private" | "rprivate" | "shared" | "rshared" | "slave" | "rslave" | "relatime</code> " | " <code>norelatime</code> " | " <code>strictatime</code> " | " <code>nostrictatime</code> " | " <code>mode</code> " | " <code>uid</code> " | " <code>gid</code> " | " <code>nr_inodes</code> " | " <code>nr_blocks</code> " | " <code>mpol</code> "
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountOptions(java.util.List<java.lang.String> mountOptions) {
                this.mountOptions = mountOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TmpfsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TmpfsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TmpfsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TmpfsProperty {
            private final java.lang.String containerPath;
            private final java.lang.Number size;
            private final java.util.List<java.lang.String> mountOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerPath = software.amazon.jsii.Kernel.get(this, "containerPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.size = software.amazon.jsii.Kernel.get(this, "size", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.mountOptions = software.amazon.jsii.Kernel.get(this, "mountOptions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerPath = java.util.Objects.requireNonNull(builder.containerPath, "containerPath is required");
                this.size = java.util.Objects.requireNonNull(builder.size, "size is required");
                this.mountOptions = builder.mountOptions;
            }

            @Override
            public final java.lang.String getContainerPath() {
                return this.containerPath;
            }

            @Override
            public final java.lang.Number getSize() {
                return this.size;
            }

            @Override
            public final java.util.List<java.lang.String> getMountOptions() {
                return this.mountOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("containerPath", om.valueToTree(this.getContainerPath()));
                data.set("size", om.valueToTree(this.getSize()));
                if (this.getMountOptions() != null) {
                    data.set("mountOptions", om.valueToTree(this.getMountOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.TmpfsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TmpfsProperty.Jsii$Proxy that = (TmpfsProperty.Jsii$Proxy) o;

                if (!containerPath.equals(that.containerPath)) return false;
                if (!size.equals(that.size)) return false;
                return this.mountOptions != null ? this.mountOptions.equals(that.mountOptions) : that.mountOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerPath.hashCode();
                result = 31 * result + (this.size.hashCode());
                result = 31 * result + (this.mountOptions != null ? this.mountOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>ulimit</code> settings to pass to the container. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_Ulimit.html">Ulimit</a> .
     * <p>
     * <blockquote>
     * <p>
     * This object isn't applicable to jobs that are running on Fargate resources.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * UlimitProperty ulimitProperty = UlimitProperty.builder()
     *         .hardLimit(123)
     *         .name("name")
     *         .softLimit(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ulimit.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ulimit.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.UlimitProperty")
    @software.amazon.jsii.Jsii.Proxy(UlimitProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UlimitProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The hard limit for the <code>ulimit</code> type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ulimit.html#cfn-batch-jobdefinition-ulimit-hardlimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ulimit.html#cfn-batch-jobdefinition-ulimit-hardlimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getHardLimit();

        /**
         * The <code>type</code> of the <code>ulimit</code> .
         * <p>
         * Valid values are: <code>core</code> | <code>cpu</code> | <code>data</code> | <code>fsize</code> | <code>locks</code> | <code>memlock</code> | <code>msgqueue</code> | <code>nice</code> | <code>nofile</code> | <code>nproc</code> | <code>rss</code> | <code>rtprio</code> | <code>rttime</code> | <code>sigpending</code> | <code>stack</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ulimit.html#cfn-batch-jobdefinition-ulimit-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ulimit.html#cfn-batch-jobdefinition-ulimit-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The soft limit for the <code>ulimit</code> type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ulimit.html#cfn-batch-jobdefinition-ulimit-softlimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ulimit.html#cfn-batch-jobdefinition-ulimit-softlimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getSoftLimit();

        /**
         * @return a {@link Builder} of {@link UlimitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UlimitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UlimitProperty> {
            java.lang.Number hardLimit;
            java.lang.String name;
            java.lang.Number softLimit;

            /**
             * Sets the value of {@link UlimitProperty#getHardLimit}
             * @param hardLimit The hard limit for the <code>ulimit</code> type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hardLimit(java.lang.Number hardLimit) {
                this.hardLimit = hardLimit;
                return this;
            }

            /**
             * Sets the value of {@link UlimitProperty#getName}
             * @param name The <code>type</code> of the <code>ulimit</code> . This parameter is required.
             *             Valid values are: <code>core</code> | <code>cpu</code> | <code>data</code> | <code>fsize</code> | <code>locks</code> | <code>memlock</code> | <code>msgqueue</code> | <code>nice</code> | <code>nofile</code> | <code>nproc</code> | <code>rss</code> | <code>rtprio</code> | <code>rttime</code> | <code>sigpending</code> | <code>stack</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link UlimitProperty#getSoftLimit}
             * @param softLimit The soft limit for the <code>ulimit</code> type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder softLimit(java.lang.Number softLimit) {
                this.softLimit = softLimit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UlimitProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UlimitProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UlimitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UlimitProperty {
            private final java.lang.Number hardLimit;
            private final java.lang.String name;
            private final java.lang.Number softLimit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hardLimit = software.amazon.jsii.Kernel.get(this, "hardLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.softLimit = software.amazon.jsii.Kernel.get(this, "softLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hardLimit = java.util.Objects.requireNonNull(builder.hardLimit, "hardLimit is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.softLimit = java.util.Objects.requireNonNull(builder.softLimit, "softLimit is required");
            }

            @Override
            public final java.lang.Number getHardLimit() {
                return this.hardLimit;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Number getSoftLimit() {
                return this.softLimit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("hardLimit", om.valueToTree(this.getHardLimit()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("softLimit", om.valueToTree(this.getSoftLimit()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.UlimitProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UlimitProperty.Jsii$Proxy that = (UlimitProperty.Jsii$Proxy) o;

                if (!hardLimit.equals(that.hardLimit)) return false;
                if (!name.equals(that.name)) return false;
                return this.softLimit.equals(that.softLimit);
            }

            @Override
            public final int hashCode() {
                int result = this.hardLimit.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.softLimit.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * VolumesHostProperty volumesHostProperty = VolumesHostProperty.builder()
     *         .sourcePath("sourcePath")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumeshost.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumeshost.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.VolumesHostProperty")
    @software.amazon.jsii.Jsii.Proxy(VolumesHostProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VolumesHostProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumeshost.html#cfn-batch-jobdefinition-volumeshost-sourcepath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumeshost.html#cfn-batch-jobdefinition-volumeshost-sourcepath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourcePath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VolumesHostProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VolumesHostProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VolumesHostProperty> {
            java.lang.String sourcePath;

            /**
             * Sets the value of {@link VolumesHostProperty#getSourcePath}
             * @param sourcePath the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourcePath(java.lang.String sourcePath) {
                this.sourcePath = sourcePath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VolumesHostProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VolumesHostProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VolumesHostProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VolumesHostProperty {
            private final java.lang.String sourcePath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourcePath = software.amazon.jsii.Kernel.get(this, "sourcePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourcePath = builder.sourcePath;
            }

            @Override
            public final java.lang.String getSourcePath() {
                return this.sourcePath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSourcePath() != null) {
                    data.set("sourcePath", om.valueToTree(this.getSourcePath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.VolumesHostProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VolumesHostProperty.Jsii$Proxy that = (VolumesHostProperty.Jsii$Proxy) o;

                return this.sourcePath != null ? this.sourcePath.equals(that.sourcePath) : that.sourcePath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourcePath != null ? this.sourcePath.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * VolumesProperty volumesProperty = VolumesProperty.builder()
     *         .efsVolumeConfiguration(EfsVolumeConfigurationProperty.builder()
     *                 .fileSystemId("fileSystemId")
     *                 // the properties below are optional
     *                 .authorizationConfig(AuthorizationConfigProperty.builder()
     *                         .accessPointId("accessPointId")
     *                         .iam("iam")
     *                         .build())
     *                 .rootDirectory("rootDirectory")
     *                 .transitEncryption("transitEncryption")
     *                 .transitEncryptionPort(123)
     *                 .build())
     *         .host(VolumesHostProperty.builder()
     *                 .sourcePath("sourcePath")
     *                 .build())
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinition.VolumesProperty")
    @software.amazon.jsii.Jsii.Proxy(VolumesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VolumesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumes.html#cfn-batch-jobdefinition-volumes-efsvolumeconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumes.html#cfn-batch-jobdefinition-volumes-efsvolumeconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEfsVolumeConfiguration() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumes.html#cfn-batch-jobdefinition-volumes-host">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumes.html#cfn-batch-jobdefinition-volumes-host</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHost() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumes.html#cfn-batch-jobdefinition-volumes-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumes.html#cfn-batch-jobdefinition-volumes-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VolumesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VolumesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VolumesProperty> {
            java.lang.Object efsVolumeConfiguration;
            java.lang.Object host;
            java.lang.String name;

            /**
             * Sets the value of {@link VolumesProperty#getEfsVolumeConfiguration}
             * @param efsVolumeConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder efsVolumeConfiguration(software.amazon.awscdk.IResolvable efsVolumeConfiguration) {
                this.efsVolumeConfiguration = efsVolumeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VolumesProperty#getEfsVolumeConfiguration}
             * @param efsVolumeConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder efsVolumeConfiguration(software.amazon.awscdk.services.batch.CfnJobDefinition.EfsVolumeConfigurationProperty efsVolumeConfiguration) {
                this.efsVolumeConfiguration = efsVolumeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VolumesProperty#getHost}
             * @param host the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(software.amazon.awscdk.IResolvable host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link VolumesProperty#getHost}
             * @param host the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(software.amazon.awscdk.services.batch.CfnJobDefinition.VolumesHostProperty host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link VolumesProperty#getName}
             * @param name the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VolumesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VolumesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VolumesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VolumesProperty {
            private final java.lang.Object efsVolumeConfiguration;
            private final java.lang.Object host;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.efsVolumeConfiguration = software.amazon.jsii.Kernel.get(this, "efsVolumeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.efsVolumeConfiguration = builder.efsVolumeConfiguration;
                this.host = builder.host;
                this.name = builder.name;
            }

            @Override
            public final java.lang.Object getEfsVolumeConfiguration() {
                return this.efsVolumeConfiguration;
            }

            @Override
            public final java.lang.Object getHost() {
                return this.host;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEfsVolumeConfiguration() != null) {
                    data.set("efsVolumeConfiguration", om.valueToTree(this.getEfsVolumeConfiguration()));
                }
                if (this.getHost() != null) {
                    data.set("host", om.valueToTree(this.getHost()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinition.VolumesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VolumesProperty.Jsii$Proxy that = (VolumesProperty.Jsii$Proxy) o;

                if (this.efsVolumeConfiguration != null ? !this.efsVolumeConfiguration.equals(that.efsVolumeConfiguration) : that.efsVolumeConfiguration != null) return false;
                if (this.host != null ? !this.host.equals(that.host) : that.host != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.efsVolumeConfiguration != null ? this.efsVolumeConfiguration.hashCode() : 0;
                result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.CfnJobDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.CfnJobDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.batch.CfnJobDefinitionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.batch.CfnJobDefinitionProps.Builder();
        }

        /**
         * The type of job definition.
         * <p>
         * For more information about multi-node parallel jobs, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/multi-node-job-def.html">Creating a multi-node parallel job definition</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * <ul>
         * <li>If the value is <code>container</code> , then one of the following is required: <code>containerProperties</code> , <code>ecsProperties</code> , or <code>eksProperties</code> .</li>
         * <li>If the value is <code>multinode</code> , then <code>nodeProperties</code> is required.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If the job is run on Fargate resources, then <code>multinode</code> isn't supported.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-type</a>
         * @param type The type of job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * Contains a list of consumable resources required by the job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-consumableresourceproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-consumableresourceproperties</a>
         * @param consumableResourceProperties Contains a list of consumable resources required by the job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder consumableResourceProperties(final software.amazon.awscdk.IResolvable consumableResourceProperties) {
            this.props.consumableResourceProperties(consumableResourceProperties);
            return this;
        }
        /**
         * Contains a list of consumable resources required by the job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-consumableresourceproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-consumableresourceproperties</a>
         * @param consumableResourceProperties Contains a list of consumable resources required by the job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder consumableResourceProperties(final software.amazon.awscdk.services.batch.CfnJobDefinition.ConsumableResourcePropertiesProperty consumableResourceProperties) {
            this.props.consumableResourceProperties(consumableResourceProperties);
            return this;
        }

        /**
         * An object with properties specific to Amazon ECS-based jobs.
         * <p>
         * When <code>containerProperties</code> is used in the job definition, it can't be used in addition to <code>eksProperties</code> , <code>ecsProperties</code> , or <code>nodeProperties</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-containerproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-containerproperties</a>
         * @param containerProperties An object with properties specific to Amazon ECS-based jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerProperties(final software.amazon.awscdk.IResolvable containerProperties) {
            this.props.containerProperties(containerProperties);
            return this;
        }
        /**
         * An object with properties specific to Amazon ECS-based jobs.
         * <p>
         * When <code>containerProperties</code> is used in the job definition, it can't be used in addition to <code>eksProperties</code> , <code>ecsProperties</code> , or <code>nodeProperties</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-containerproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-containerproperties</a>
         * @param containerProperties An object with properties specific to Amazon ECS-based jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerProperties(final software.amazon.awscdk.services.batch.CfnJobDefinition.ContainerPropertiesProperty containerProperties) {
            this.props.containerProperties(containerProperties);
            return this;
        }

        /**
         * An object that contains the properties for the Amazon ECS resources of a job.When <code>ecsProperties</code> is used in the job definition, it can't be used in addition to <code>containerProperties</code> , <code>eksProperties</code> , or <code>nodeProperties</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-ecsproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-ecsproperties</a>
         * @param ecsProperties An object that contains the properties for the Amazon ECS resources of a job.When <code>ecsProperties</code> is used in the job definition, it can't be used in addition to <code>containerProperties</code> , <code>eksProperties</code> , or <code>nodeProperties</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ecsProperties(final software.amazon.awscdk.IResolvable ecsProperties) {
            this.props.ecsProperties(ecsProperties);
            return this;
        }
        /**
         * An object that contains the properties for the Amazon ECS resources of a job.When <code>ecsProperties</code> is used in the job definition, it can't be used in addition to <code>containerProperties</code> , <code>eksProperties</code> , or <code>nodeProperties</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-ecsproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-ecsproperties</a>
         * @param ecsProperties An object that contains the properties for the Amazon ECS resources of a job.When <code>ecsProperties</code> is used in the job definition, it can't be used in addition to <code>containerProperties</code> , <code>eksProperties</code> , or <code>nodeProperties</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ecsProperties(final software.amazon.awscdk.services.batch.CfnJobDefinition.EcsPropertiesProperty ecsProperties) {
            this.props.ecsProperties(ecsProperties);
            return this;
        }

        /**
         * An object with properties that are specific to Amazon EKS-based jobs.
         * <p>
         * When <code>eksProperties</code> is used in the job definition, it can't be used in addition to <code>containerProperties</code> , <code>ecsProperties</code> , or <code>nodeProperties</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-eksproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-eksproperties</a>
         * @param eksProperties An object with properties that are specific to Amazon EKS-based jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eksProperties(final software.amazon.awscdk.IResolvable eksProperties) {
            this.props.eksProperties(eksProperties);
            return this;
        }
        /**
         * An object with properties that are specific to Amazon EKS-based jobs.
         * <p>
         * When <code>eksProperties</code> is used in the job definition, it can't be used in addition to <code>containerProperties</code> , <code>ecsProperties</code> , or <code>nodeProperties</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-eksproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-eksproperties</a>
         * @param eksProperties An object with properties that are specific to Amazon EKS-based jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eksProperties(final software.amazon.awscdk.services.batch.CfnJobDefinition.EksPropertiesProperty eksProperties) {
            this.props.eksProperties(eksProperties);
            return this;
        }

        /**
         * The name of the job definition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-jobdefinitionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-jobdefinitionname</a>
         * @param jobDefinitionName The name of the job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobDefinitionName(final java.lang.String jobDefinitionName) {
            this.props.jobDefinitionName(jobDefinitionName);
            return this;
        }

        /**
         * An object with properties that are specific to multi-node parallel jobs.
         * <p>
         * When <code>nodeProperties</code> is used in the job definition, it can't be used in addition to <code>containerProperties</code> , <code>ecsProperties</code> , or <code>eksProperties</code> .
         * <p>
         * <blockquote>
         * <p>
         * If the job runs on Fargate resources, don't specify <code>nodeProperties</code> . Use <code>containerProperties</code> instead.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-nodeproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-nodeproperties</a>
         * @param nodeProperties An object with properties that are specific to multi-node parallel jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeProperties(final software.amazon.awscdk.IResolvable nodeProperties) {
            this.props.nodeProperties(nodeProperties);
            return this;
        }
        /**
         * An object with properties that are specific to multi-node parallel jobs.
         * <p>
         * When <code>nodeProperties</code> is used in the job definition, it can't be used in addition to <code>containerProperties</code> , <code>ecsProperties</code> , or <code>eksProperties</code> .
         * <p>
         * <blockquote>
         * <p>
         * If the job runs on Fargate resources, don't specify <code>nodeProperties</code> . Use <code>containerProperties</code> instead.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-nodeproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-nodeproperties</a>
         * @param nodeProperties An object with properties that are specific to multi-node parallel jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeProperties(final software.amazon.awscdk.services.batch.CfnJobDefinition.NodePropertiesProperty nodeProperties) {
            this.props.nodeProperties(nodeProperties);
            return this;
        }

        /**
         * Default parameters or parameter substitution placeholders that are set in the job definition.
         * <p>
         * Parameters are specified as a key-value pair mapping. Parameters in a <code>SubmitJob</code> request override any corresponding parameter defaults from the job definition. For more information about specifying parameters, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html">Job definition parameters</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-parameters</a>
         * @param parameters Default parameters or parameter substitution placeholders that are set in the job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.lang.Object parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * The platform capabilities required by the job definition.
         * <p>
         * If no value is specified, it defaults to <code>EC2</code> . Jobs run on Fargate resources specify <code>FARGATE</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-platformcapabilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-platformcapabilities</a>
         * @param platformCapabilities The platform capabilities required by the job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformCapabilities(final java.util.List<java.lang.String> platformCapabilities) {
            this.props.platformCapabilities(platformCapabilities);
            return this;
        }

        /**
         * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task.
         * <p>
         * If no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks when the tasks are created. For tags with the same name, job tags are given priority over job definitions tags. If the total number of combined tags from the job and job definition is over 50, the job is moved to the <code>FAILED</code> state.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-propagatetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-propagatetags</a>
         * @param propagateTags Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(final java.lang.Boolean propagateTags) {
            this.props.propagateTags(propagateTags);
            return this;
        }
        /**
         * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task.
         * <p>
         * If no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks when the tasks are created. For tags with the same name, job tags are given priority over job definitions tags. If the total number of combined tags from the job and job definition is over 50, the job is moved to the <code>FAILED</code> state.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-propagatetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-propagatetags</a>
         * @param propagateTags Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(final software.amazon.awscdk.IResolvable propagateTags) {
            this.props.propagateTags(propagateTags);
            return this;
        }

        /**
         * The retry strategy to use for failed jobs that are submitted with this job definition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-retrystrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-retrystrategy</a>
         * @param retryStrategy The retry strategy to use for failed jobs that are submitted with this job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryStrategy(final software.amazon.awscdk.IResolvable retryStrategy) {
            this.props.retryStrategy(retryStrategy);
            return this;
        }
        /**
         * The retry strategy to use for failed jobs that are submitted with this job definition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-retrystrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-retrystrategy</a>
         * @param retryStrategy The retry strategy to use for failed jobs that are submitted with this job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryStrategy(final software.amazon.awscdk.services.batch.CfnJobDefinition.RetryStrategyProperty retryStrategy) {
            this.props.retryStrategy(retryStrategy);
            return this;
        }

        /**
         * The scheduling priority of the job definition.
         * <p>
         * This only affects jobs in job queues with a fair-share policy. Jobs with a higher scheduling priority are scheduled before jobs with a lower scheduling priority.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-schedulingpriority">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-schedulingpriority</a>
         * @param schedulingPriority The scheduling priority of the job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedulingPriority(final java.lang.Number schedulingPriority) {
            this.props.schedulingPriority(schedulingPriority);
            return this;
        }

        /**
         * The tags that are applied to the job definition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-tags</a>
         * @param tags The tags that are applied to the job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.lang.Object tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The timeout time for jobs that are submitted with this job definition.
         * <p>
         * After the amount of time you specify passes, AWS Batch terminates your jobs if they aren't finished.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-timeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-timeout</a>
         * @param timeout The timeout time for jobs that are submitted with this job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.IResolvable timeout) {
            this.props.timeout(timeout);
            return this;
        }
        /**
         * The timeout time for jobs that are submitted with this job definition.
         * <p>
         * After the amount of time you specify passes, AWS Batch terminates your jobs if they aren't finished.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-timeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-timeout</a>
         * @param timeout The timeout time for jobs that are submitted with this job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.services.batch.CfnJobDefinition.TimeoutProperty timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.batch.CfnJobDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.batch.CfnJobDefinition build() {
            return new software.amazon.awscdk.services.batch.CfnJobDefinition(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
