package software.amazon.awscdk.services.batch;

/**
 * Props to configure an EcsFargateContainerDefinition.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EcsJobDefinition jobDefn = EcsJobDefinition.Builder.create(this, "JobDefn")
 *         .container(EcsFargateContainerDefinition.Builder.create(this, "myFargateContainer")
 *                 .image(ContainerImage.fromRegistry("public.ecr.aws/amazonlinux/amazonlinux:latest"))
 *                 .memory(Size.mebibytes(2048))
 *                 .cpu(256)
 *                 .ephemeralStorageSize(Size.gibibytes(100))
 *                 .fargateCpuArchitecture(CpuArchitecture.ARM64)
 *                 .fargateOperatingSystemFamily(OperatingSystemFamily.LINUX)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:20.259Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.EcsFargateContainerDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(EcsFargateContainerDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EcsFargateContainerDefinitionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.batch.EcsContainerDefinitionProps {

    /**
     * Indicates whether the job has a public IP address.
     * <p>
     * For a job that's running on Fargate resources in a private subnet to send outbound traffic to the internet
     * (for example, to pull container images), the private subnet requires a NAT gateway be attached to route requests to the internet.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAssignPublicIp() {
        return null;
    }

    /**
     * The size for ephemeral storage.
     * <p>
     * Default: - 20 GiB
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getEphemeralStorageSize() {
        return null;
    }

    /**
     * The vCPU architecture of Fargate Runtime.
     * <p>
     * Default: - X86_64
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CpuArchitecture getFargateCpuArchitecture() {
        return null;
    }

    /**
     * The operating system for the compute environment.
     * <p>
     * Default: - LINUX
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.OperatingSystemFamily getFargateOperatingSystemFamily() {
        return null;
    }

    /**
     * Which version of Fargate to use when running this container.
     * <p>
     * Default: LATEST
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.FargatePlatformVersion getFargatePlatformVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EcsFargateContainerDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EcsFargateContainerDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EcsFargateContainerDefinitionProps> {
        java.lang.Boolean assignPublicIp;
        software.amazon.awscdk.Size ephemeralStorageSize;
        software.amazon.awscdk.services.ecs.CpuArchitecture fargateCpuArchitecture;
        software.amazon.awscdk.services.ecs.OperatingSystemFamily fargateOperatingSystemFamily;
        software.amazon.awscdk.services.ecs.FargatePlatformVersion fargatePlatformVersion;
        java.lang.Number cpu;
        software.amazon.awscdk.services.ecs.ContainerImage image;
        software.amazon.awscdk.Size memory;
        java.util.List<java.lang.String> command;
        java.util.Map<java.lang.String, java.lang.String> environment;
        software.amazon.awscdk.services.iam.IRole executionRole;
        software.amazon.awscdk.services.iam.IRole jobRole;
        software.amazon.awscdk.services.batch.LinuxParameters linuxParameters;
        software.amazon.awscdk.services.ecs.LogDriver logging;
        java.lang.Boolean readonlyRootFilesystem;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.batch.Secret> secrets;
        java.lang.String user;
        java.util.List<software.amazon.awscdk.services.batch.EcsVolume> volumes;

        /**
         * Sets the value of {@link EcsFargateContainerDefinitionProps#getAssignPublicIp}
         * @param assignPublicIp Indicates whether the job has a public IP address.
         *                       For a job that's running on Fargate resources in a private subnet to send outbound traffic to the internet
         *                       (for example, to pull container images), the private subnet requires a NAT gateway be attached to route requests to the internet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assignPublicIp(java.lang.Boolean assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
            return this;
        }

        /**
         * Sets the value of {@link EcsFargateContainerDefinitionProps#getEphemeralStorageSize}
         * @param ephemeralStorageSize The size for ephemeral storage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorageSize(software.amazon.awscdk.Size ephemeralStorageSize) {
            this.ephemeralStorageSize = ephemeralStorageSize;
            return this;
        }

        /**
         * Sets the value of {@link EcsFargateContainerDefinitionProps#getFargateCpuArchitecture}
         * @param fargateCpuArchitecture The vCPU architecture of Fargate Runtime.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fargateCpuArchitecture(software.amazon.awscdk.services.ecs.CpuArchitecture fargateCpuArchitecture) {
            this.fargateCpuArchitecture = fargateCpuArchitecture;
            return this;
        }

        /**
         * Sets the value of {@link EcsFargateContainerDefinitionProps#getFargateOperatingSystemFamily}
         * @param fargateOperatingSystemFamily The operating system for the compute environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fargateOperatingSystemFamily(software.amazon.awscdk.services.ecs.OperatingSystemFamily fargateOperatingSystemFamily) {
            this.fargateOperatingSystemFamily = fargateOperatingSystemFamily;
            return this;
        }

        /**
         * Sets the value of {@link EcsFargateContainerDefinitionProps#getFargatePlatformVersion}
         * @param fargatePlatformVersion Which version of Fargate to use when running this container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fargatePlatformVersion(software.amazon.awscdk.services.ecs.FargatePlatformVersion fargatePlatformVersion) {
            this.fargatePlatformVersion = fargatePlatformVersion;
            return this;
        }

        /**
         * Sets the value of {@link EcsFargateContainerDefinitionProps#getCpu}
         * @param cpu The number of vCPUs reserved for the container. This parameter is required.
         *            Each vCPU is equivalent to 1,024 CPU shares.
         *            For containers running on EC2 resources, you must specify at least one vCPU.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(java.lang.Number cpu) {
            this.cpu = cpu;
            return this;
        }

        /**
         * Sets the value of {@link EcsFargateContainerDefinitionProps#getImage}
         * @param image The image that this container will run. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder image(software.amazon.awscdk.services.ecs.ContainerImage image) {
            this.image = image;
            return this;
        }

        /**
         * Sets the value of {@link EcsFargateContainerDefinitionProps#getMemory}
         * @param memory The memory hard limit present to the container. This parameter is required.
         *               If your container attempts to exceed the memory specified, the container is terminated.
         *               You must specify at least 4 MiB of memory for a job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memory(software.amazon.awscdk.Size memory) {
            this.memory = memory;
            return this;
        }

        /**
         * Sets the value of {@link EcsFargateContainerDefinitionProps#getCommand}
         * @param command The command that's passed to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(java.util.List<java.lang.String> command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link EcsFargateContainerDefinitionProps#getEnvironment}
         * @param environment The environment variables to pass to a container.
         *                    Cannot start with <code>AWS_BATCH</code>.
         *                    We don't recommend using plaintext environment variables for sensitive information, such as credential data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link EcsFargateContainerDefinitionProps#getExecutionRole}
         * @param executionRole The role used by Amazon ECS container and AWS Fargate agents to make AWS API calls on your behalf.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(software.amazon.awscdk.services.iam.IRole executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        /**
         * Sets the value of {@link EcsFargateContainerDefinitionProps#getJobRole}
         * @param jobRole The role that the container can assume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobRole(software.amazon.awscdk.services.iam.IRole jobRole) {
            this.jobRole = jobRole;
            return this;
        }

        /**
         * Sets the value of {@link EcsFargateContainerDefinitionProps#getLinuxParameters}
         * @param linuxParameters Linux-specific modifications that are applied to the container, such as details for device mappings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linuxParameters(software.amazon.awscdk.services.batch.LinuxParameters linuxParameters) {
            this.linuxParameters = linuxParameters;
            return this;
        }

        /**
         * Sets the value of {@link EcsFargateContainerDefinitionProps#getLogging}
         * @param logging The loging configuration for this Job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(software.amazon.awscdk.services.ecs.LogDriver logging) {
            this.logging = logging;
            return this;
        }

        /**
         * Sets the value of {@link EcsFargateContainerDefinitionProps#getReadonlyRootFilesystem}
         * @param readonlyRootFilesystem Gives the container readonly access to its root filesystem.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readonlyRootFilesystem(java.lang.Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
            return this;
        }

        /**
         * Sets the value of {@link EcsFargateContainerDefinitionProps#getSecrets}
         * @param secrets A map from environment variable names to the secrets for the container.
         *                Allows your job definitions
         *                to reference the secret by the environment variable name defined in this property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder secrets(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.batch.Secret> secrets) {
            this.secrets = (java.util.Map<java.lang.String, software.amazon.awscdk.services.batch.Secret>)secrets;
            return this;
        }

        /**
         * Sets the value of {@link EcsFargateContainerDefinitionProps#getUser}
         * @param user The user name to use inside the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder user(java.lang.String user) {
            this.user = user;
            return this;
        }

        /**
         * Sets the value of {@link EcsFargateContainerDefinitionProps#getVolumes}
         * @param volumes The volumes to mount to this container.
         *                Automatically added to the job definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder volumes(java.util.List<? extends software.amazon.awscdk.services.batch.EcsVolume> volumes) {
            this.volumes = (java.util.List<software.amazon.awscdk.services.batch.EcsVolume>)volumes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EcsFargateContainerDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EcsFargateContainerDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EcsFargateContainerDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsFargateContainerDefinitionProps {
        private final java.lang.Boolean assignPublicIp;
        private final software.amazon.awscdk.Size ephemeralStorageSize;
        private final software.amazon.awscdk.services.ecs.CpuArchitecture fargateCpuArchitecture;
        private final software.amazon.awscdk.services.ecs.OperatingSystemFamily fargateOperatingSystemFamily;
        private final software.amazon.awscdk.services.ecs.FargatePlatformVersion fargatePlatformVersion;
        private final java.lang.Number cpu;
        private final software.amazon.awscdk.services.ecs.ContainerImage image;
        private final software.amazon.awscdk.Size memory;
        private final java.util.List<java.lang.String> command;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final software.amazon.awscdk.services.iam.IRole executionRole;
        private final software.amazon.awscdk.services.iam.IRole jobRole;
        private final software.amazon.awscdk.services.batch.LinuxParameters linuxParameters;
        private final software.amazon.awscdk.services.ecs.LogDriver logging;
        private final java.lang.Boolean readonlyRootFilesystem;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.batch.Secret> secrets;
        private final java.lang.String user;
        private final java.util.List<software.amazon.awscdk.services.batch.EcsVolume> volumes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assignPublicIp = software.amazon.jsii.Kernel.get(this, "assignPublicIp", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ephemeralStorageSize = software.amazon.jsii.Kernel.get(this, "ephemeralStorageSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.fargateCpuArchitecture = software.amazon.jsii.Kernel.get(this, "fargateCpuArchitecture", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CpuArchitecture.class));
            this.fargateOperatingSystemFamily = software.amazon.jsii.Kernel.get(this, "fargateOperatingSystemFamily", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.OperatingSystemFamily.class));
            this.fargatePlatformVersion = software.amazon.jsii.Kernel.get(this, "fargatePlatformVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FargatePlatformVersion.class));
            this.cpu = software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImage.class));
            this.memory = software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.jobRole = software.amazon.jsii.Kernel.get(this, "jobRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.linuxParameters = software.amazon.jsii.Kernel.get(this, "linuxParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.LinuxParameters.class));
            this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriver.class));
            this.readonlyRootFilesystem = software.amazon.jsii.Kernel.get(this, "readonlyRootFilesystem", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.secrets = software.amazon.jsii.Kernel.get(this, "secrets", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Secret.class)));
            this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.EcsVolume.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assignPublicIp = builder.assignPublicIp;
            this.ephemeralStorageSize = builder.ephemeralStorageSize;
            this.fargateCpuArchitecture = builder.fargateCpuArchitecture;
            this.fargateOperatingSystemFamily = builder.fargateOperatingSystemFamily;
            this.fargatePlatformVersion = builder.fargatePlatformVersion;
            this.cpu = java.util.Objects.requireNonNull(builder.cpu, "cpu is required");
            this.image = java.util.Objects.requireNonNull(builder.image, "image is required");
            this.memory = java.util.Objects.requireNonNull(builder.memory, "memory is required");
            this.command = builder.command;
            this.environment = builder.environment;
            this.executionRole = builder.executionRole;
            this.jobRole = builder.jobRole;
            this.linuxParameters = builder.linuxParameters;
            this.logging = builder.logging;
            this.readonlyRootFilesystem = builder.readonlyRootFilesystem;
            this.secrets = (java.util.Map<java.lang.String, software.amazon.awscdk.services.batch.Secret>)builder.secrets;
            this.user = builder.user;
            this.volumes = (java.util.List<software.amazon.awscdk.services.batch.EcsVolume>)builder.volumes;
        }

        @Override
        public final java.lang.Boolean getAssignPublicIp() {
            return this.assignPublicIp;
        }

        @Override
        public final software.amazon.awscdk.Size getEphemeralStorageSize() {
            return this.ephemeralStorageSize;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.CpuArchitecture getFargateCpuArchitecture() {
            return this.fargateCpuArchitecture;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.OperatingSystemFamily getFargateOperatingSystemFamily() {
            return this.fargateOperatingSystemFamily;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.FargatePlatformVersion getFargatePlatformVersion() {
            return this.fargatePlatformVersion;
        }

        @Override
        public final java.lang.Number getCpu() {
            return this.cpu;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ContainerImage getImage() {
            return this.image;
        }

        @Override
        public final software.amazon.awscdk.Size getMemory() {
            return this.memory;
        }

        @Override
        public final java.util.List<java.lang.String> getCommand() {
            return this.command;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getExecutionRole() {
            return this.executionRole;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getJobRole() {
            return this.jobRole;
        }

        @Override
        public final software.amazon.awscdk.services.batch.LinuxParameters getLinuxParameters() {
            return this.linuxParameters;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.LogDriver getLogging() {
            return this.logging;
        }

        @Override
        public final java.lang.Boolean getReadonlyRootFilesystem() {
            return this.readonlyRootFilesystem;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.batch.Secret> getSecrets() {
            return this.secrets;
        }

        @Override
        public final java.lang.String getUser() {
            return this.user;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.batch.EcsVolume> getVolumes() {
            return this.volumes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAssignPublicIp() != null) {
                data.set("assignPublicIp", om.valueToTree(this.getAssignPublicIp()));
            }
            if (this.getEphemeralStorageSize() != null) {
                data.set("ephemeralStorageSize", om.valueToTree(this.getEphemeralStorageSize()));
            }
            if (this.getFargateCpuArchitecture() != null) {
                data.set("fargateCpuArchitecture", om.valueToTree(this.getFargateCpuArchitecture()));
            }
            if (this.getFargateOperatingSystemFamily() != null) {
                data.set("fargateOperatingSystemFamily", om.valueToTree(this.getFargateOperatingSystemFamily()));
            }
            if (this.getFargatePlatformVersion() != null) {
                data.set("fargatePlatformVersion", om.valueToTree(this.getFargatePlatformVersion()));
            }
            data.set("cpu", om.valueToTree(this.getCpu()));
            data.set("image", om.valueToTree(this.getImage()));
            data.set("memory", om.valueToTree(this.getMemory()));
            if (this.getCommand() != null) {
                data.set("command", om.valueToTree(this.getCommand()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getExecutionRole() != null) {
                data.set("executionRole", om.valueToTree(this.getExecutionRole()));
            }
            if (this.getJobRole() != null) {
                data.set("jobRole", om.valueToTree(this.getJobRole()));
            }
            if (this.getLinuxParameters() != null) {
                data.set("linuxParameters", om.valueToTree(this.getLinuxParameters()));
            }
            if (this.getLogging() != null) {
                data.set("logging", om.valueToTree(this.getLogging()));
            }
            if (this.getReadonlyRootFilesystem() != null) {
                data.set("readonlyRootFilesystem", om.valueToTree(this.getReadonlyRootFilesystem()));
            }
            if (this.getSecrets() != null) {
                data.set("secrets", om.valueToTree(this.getSecrets()));
            }
            if (this.getUser() != null) {
                data.set("user", om.valueToTree(this.getUser()));
            }
            if (this.getVolumes() != null) {
                data.set("volumes", om.valueToTree(this.getVolumes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.EcsFargateContainerDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EcsFargateContainerDefinitionProps.Jsii$Proxy that = (EcsFargateContainerDefinitionProps.Jsii$Proxy) o;

            if (this.assignPublicIp != null ? !this.assignPublicIp.equals(that.assignPublicIp) : that.assignPublicIp != null) return false;
            if (this.ephemeralStorageSize != null ? !this.ephemeralStorageSize.equals(that.ephemeralStorageSize) : that.ephemeralStorageSize != null) return false;
            if (this.fargateCpuArchitecture != null ? !this.fargateCpuArchitecture.equals(that.fargateCpuArchitecture) : that.fargateCpuArchitecture != null) return false;
            if (this.fargateOperatingSystemFamily != null ? !this.fargateOperatingSystemFamily.equals(that.fargateOperatingSystemFamily) : that.fargateOperatingSystemFamily != null) return false;
            if (this.fargatePlatformVersion != null ? !this.fargatePlatformVersion.equals(that.fargatePlatformVersion) : that.fargatePlatformVersion != null) return false;
            if (!cpu.equals(that.cpu)) return false;
            if (!image.equals(that.image)) return false;
            if (!memory.equals(that.memory)) return false;
            if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.executionRole != null ? !this.executionRole.equals(that.executionRole) : that.executionRole != null) return false;
            if (this.jobRole != null ? !this.jobRole.equals(that.jobRole) : that.jobRole != null) return false;
            if (this.linuxParameters != null ? !this.linuxParameters.equals(that.linuxParameters) : that.linuxParameters != null) return false;
            if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) return false;
            if (this.readonlyRootFilesystem != null ? !this.readonlyRootFilesystem.equals(that.readonlyRootFilesystem) : that.readonlyRootFilesystem != null) return false;
            if (this.secrets != null ? !this.secrets.equals(that.secrets) : that.secrets != null) return false;
            if (this.user != null ? !this.user.equals(that.user) : that.user != null) return false;
            return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assignPublicIp != null ? this.assignPublicIp.hashCode() : 0;
            result = 31 * result + (this.ephemeralStorageSize != null ? this.ephemeralStorageSize.hashCode() : 0);
            result = 31 * result + (this.fargateCpuArchitecture != null ? this.fargateCpuArchitecture.hashCode() : 0);
            result = 31 * result + (this.fargateOperatingSystemFamily != null ? this.fargateOperatingSystemFamily.hashCode() : 0);
            result = 31 * result + (this.fargatePlatformVersion != null ? this.fargatePlatformVersion.hashCode() : 0);
            result = 31 * result + (this.cpu.hashCode());
            result = 31 * result + (this.image.hashCode());
            result = 31 * result + (this.memory.hashCode());
            result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.executionRole != null ? this.executionRole.hashCode() : 0);
            result = 31 * result + (this.jobRole != null ? this.jobRole.hashCode() : 0);
            result = 31 * result + (this.linuxParameters != null ? this.linuxParameters.hashCode() : 0);
            result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
            result = 31 * result + (this.readonlyRootFilesystem != null ? this.readonlyRootFilesystem.hashCode() : 0);
            result = 31 * result + (this.secrets != null ? this.secrets.hashCode() : 0);
            result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
            result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
            return result;
        }
    }
}
