package software.amazon.awscdk.services.batch;

/**
 * Options for a Kubernetes EmptyDir volume.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EksJobDefinition jobDefn = EksJobDefinition.Builder.create(this, "eksf2")
 *         .container(EksContainerDefinition.Builder.create(this, "container")
 *                 .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *                 .volumes(List.of(EksVolume.emptyDir(EmptyDirVolumeOptions.builder()
 *                         .name("myEmptyDirVolume")
 *                         .mountPath("/mount/path")
 *                         .medium(EmptyDirMediumType.MEMORY)
 *                         .readonly(true)
 *                         .sizeLimit(Size.mebibytes(2048))
 *                         .build())))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://kubernetes.io/docs/concepts/storage/volumes/#emptydir">https://kubernetes.io/docs/concepts/storage/volumes/#emptydir</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:20.283Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.EmptyDirVolumeOptions")
@software.amazon.jsii.Jsii.Proxy(EmptyDirVolumeOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EmptyDirVolumeOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.batch.EksVolumeOptions {

    /**
     * The storage type to use for this Volume.
     * <p>
     * Default: `EmptyDirMediumType.DISK`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.EmptyDirMediumType getMedium() {
        return null;
    }

    /**
     * The maximum size for this Volume.
     * <p>
     * Default: - no size limit
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getSizeLimit() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EmptyDirVolumeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EmptyDirVolumeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EmptyDirVolumeOptions> {
        software.amazon.awscdk.services.batch.EmptyDirMediumType medium;
        software.amazon.awscdk.Size sizeLimit;
        java.lang.String name;
        java.lang.String mountPath;
        java.lang.Boolean readonly;

        /**
         * Sets the value of {@link EmptyDirVolumeOptions#getMedium}
         * @param medium The storage type to use for this Volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder medium(software.amazon.awscdk.services.batch.EmptyDirMediumType medium) {
            this.medium = medium;
            return this;
        }

        /**
         * Sets the value of {@link EmptyDirVolumeOptions#getSizeLimit}
         * @param sizeLimit The maximum size for this Volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sizeLimit(software.amazon.awscdk.Size sizeLimit) {
            this.sizeLimit = sizeLimit;
            return this;
        }

        /**
         * Sets the value of {@link EmptyDirVolumeOptions#getName}
         * @param name The name of this volume. This parameter is required.
         *             The name must be a valid DNS subdomain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link EmptyDirVolumeOptions#getMountPath}
         * @param mountPath The path on the container where the volume is mounted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mountPath(java.lang.String mountPath) {
            this.mountPath = mountPath;
            return this;
        }

        /**
         * Sets the value of {@link EmptyDirVolumeOptions#getReadonly}
         * @param readonly If specified, the container has readonly access to the volume.
         *                 Otherwise, the container has read/write access.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readonly(java.lang.Boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EmptyDirVolumeOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EmptyDirVolumeOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EmptyDirVolumeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmptyDirVolumeOptions {
        private final software.amazon.awscdk.services.batch.EmptyDirMediumType medium;
        private final software.amazon.awscdk.Size sizeLimit;
        private final java.lang.String name;
        private final java.lang.String mountPath;
        private final java.lang.Boolean readonly;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.medium = software.amazon.jsii.Kernel.get(this, "medium", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.EmptyDirMediumType.class));
            this.sizeLimit = software.amazon.jsii.Kernel.get(this, "sizeLimit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mountPath = software.amazon.jsii.Kernel.get(this, "mountPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.readonly = software.amazon.jsii.Kernel.get(this, "readonly", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.medium = builder.medium;
            this.sizeLimit = builder.sizeLimit;
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.mountPath = builder.mountPath;
            this.readonly = builder.readonly;
        }

        @Override
        public final software.amazon.awscdk.services.batch.EmptyDirMediumType getMedium() {
            return this.medium;
        }

        @Override
        public final software.amazon.awscdk.Size getSizeLimit() {
            return this.sizeLimit;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getMountPath() {
            return this.mountPath;
        }

        @Override
        public final java.lang.Boolean getReadonly() {
            return this.readonly;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMedium() != null) {
                data.set("medium", om.valueToTree(this.getMedium()));
            }
            if (this.getSizeLimit() != null) {
                data.set("sizeLimit", om.valueToTree(this.getSizeLimit()));
            }
            data.set("name", om.valueToTree(this.getName()));
            if (this.getMountPath() != null) {
                data.set("mountPath", om.valueToTree(this.getMountPath()));
            }
            if (this.getReadonly() != null) {
                data.set("readonly", om.valueToTree(this.getReadonly()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.EmptyDirVolumeOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EmptyDirVolumeOptions.Jsii$Proxy that = (EmptyDirVolumeOptions.Jsii$Proxy) o;

            if (this.medium != null ? !this.medium.equals(that.medium) : that.medium != null) return false;
            if (this.sizeLimit != null ? !this.sizeLimit.equals(that.sizeLimit) : that.sizeLimit != null) return false;
            if (!name.equals(that.name)) return false;
            if (this.mountPath != null ? !this.mountPath.equals(that.mountPath) : that.mountPath != null) return false;
            return this.readonly != null ? this.readonly.equals(that.readonly) : that.readonly == null;
        }

        @Override
        public final int hashCode() {
            int result = this.medium != null ? this.medium.hashCode() : 0;
            result = 31 * result + (this.sizeLimit != null ? this.sizeLimit.hashCode() : 0);
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.mountPath != null ? this.mountPath.hashCode() : 0);
            result = 31 * result + (this.readonly != null ? this.readonly.hashCode() : 0);
            return result;
        }
    }
}
