package software.amazon.awscdk.services.batch;

/**
 * Linux-specific options that are applied to the container.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.batch.*;
 * Size size;
 * LinuxParameters linuxParameters = LinuxParameters.Builder.create(this, "MyLinuxParameters")
 *         .initProcessEnabled(false)
 *         .maxSwap(size)
 *         .sharedMemorySize(size)
 *         .swappiness(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:20.323Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.LinuxParameters")
public class LinuxParameters extends software.constructs.Construct {

    protected LinuxParameters(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LinuxParameters(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the LinuxParameters class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LinuxParameters(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.LinuxParametersProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Constructs a new instance of the LinuxParameters class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LinuxParameters(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Adds one or more host devices to a container.
     * <p>
     * @param device This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDevices(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.Device... device) {
        software.amazon.jsii.Kernel.call(this, "addDevices", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(device).toArray(Object[]::new));
    }

    /**
     * Specifies the container path, mount options, and size (in MiB) of the tmpfs mount for a container.
     * <p>
     * Only works with EC2 launch type.
     * <p>
     * @param tmpfs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addTmpfs(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.Tmpfs... tmpfs) {
        software.amazon.jsii.Kernel.call(this, "addTmpfs", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(tmpfs).toArray(Object[]::new));
    }

    /**
     * Renders the Linux parameters to the Batch version of this resource, which does not have 'capabilities' and requires tmpfs.containerPath to be defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.CfnJobDefinition.LinuxParametersProperty renderLinuxParameters() {
        return software.amazon.jsii.Kernel.call(this, "renderLinuxParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.CfnJobDefinition.LinuxParametersProperty.class));
    }

    /**
     * Device mounts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.Device> getDevices() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "devices", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Device.class))));
    }

    /**
     * TmpFs mounts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.Tmpfs> getTmpfs() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "tmpfs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Tmpfs.class))));
    }

    /**
     * Whether the init process is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.lang.Boolean getInitProcessEnabled() {
        return software.amazon.jsii.Kernel.get(this, "initProcessEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The max swap memory.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getMaxSwap() {
        return software.amazon.jsii.Kernel.get(this, "maxSwap", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
    }

    /**
     * The shared memory size (in MiB).
     * <p>
     * Not valid for Fargate launch type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getSharedMemorySize() {
        return software.amazon.jsii.Kernel.get(this, "sharedMemorySize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
    }

    /**
     * The swappiness behavior.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.lang.Number getSwappiness() {
        return software.amazon.jsii.Kernel.get(this, "swappiness", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.LinuxParameters}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.LinuxParameters> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.batch.LinuxParametersProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Specifies whether to run an init process inside the container that forwards signals and reaps processes.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param initProcessEnabled Specifies whether to run an init process inside the container that forwards signals and reaps processes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initProcessEnabled(final java.lang.Boolean initProcessEnabled) {
            this.props().initProcessEnabled(initProcessEnabled);
            return this;
        }

        /**
         * The total amount of swap memory a container can use.
         * <p>
         * This parameter
         * will be translated to the --memory-swap option to docker run.
         * <p>
         * This parameter is only supported when you are using the EC2 launch type.
         * Accepted values are positive integers.
         * <p>
         * Default: No swap.
         * <p>
         * @return {@code this}
         * @param maxSwap The total amount of swap memory a container can use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxSwap(final software.amazon.awscdk.Size maxSwap) {
            this.props().maxSwap(maxSwap);
            return this;
        }

        /**
         * The value for the size of the /dev/shm volume.
         * <p>
         * Default: No shared memory.
         * <p>
         * @return {@code this}
         * @param sharedMemorySize The value for the size of the /dev/shm volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sharedMemorySize(final software.amazon.awscdk.Size sharedMemorySize) {
            this.props().sharedMemorySize(sharedMemorySize);
            return this;
        }

        /**
         * This allows you to tune a container's memory swappiness behavior.
         * <p>
         * This parameter
         * maps to the --memory-swappiness option to docker run. The swappiness relates
         * to the kernel's tendency to swap memory. A value of 0 will cause swapping to
         * not happen unless absolutely necessary. A value of 100 will cause pages to
         * be swapped very aggressively.
         * <p>
         * This parameter is only supported when you are using the EC2 launch type.
         * Accepted values are whole numbers between 0 and 100. If a value is not
         * specified for maxSwap then this parameter is ignored.
         * <p>
         * Default: 60
         * <p>
         * @return {@code this}
         * @param swappiness This allows you to tune a container's memory swappiness behavior. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder swappiness(final java.lang.Number swappiness) {
            this.props().swappiness(swappiness);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.batch.LinuxParameters}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.batch.LinuxParameters build() {
            return new software.amazon.awscdk.services.batch.LinuxParameters(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.batch.LinuxParametersProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.batch.LinuxParametersProps.Builder();
            }
            return this.props;
        }
    }
}
