package software.amazon.awscdk.services.bcmdataexports;

/**
 * Properties for defining a <code>CfnExport</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bcmdataexports.*;
 * CfnExportProps cfnExportProps = CfnExportProps.builder()
 *         .export(ExportProperty.builder()
 *                 .dataQuery(DataQueryProperty.builder()
 *                         .queryStatement("queryStatement")
 *                         // the properties below are optional
 *                         .tableConfigurations(Map.of(
 *                                 "tableConfigurationsKey", Map.of(
 *                                         "tableConfigurationsKey", "tableConfigurations")))
 *                         .build())
 *                 .destinationConfigurations(DestinationConfigurationsProperty.builder()
 *                         .s3Destination(S3DestinationProperty.builder()
 *                                 .s3Bucket("s3Bucket")
 *                                 .s3OutputConfigurations(S3OutputConfigurationsProperty.builder()
 *                                         .compression("compression")
 *                                         .format("format")
 *                                         .outputType("outputType")
 *                                         .overwrite("overwrite")
 *                                         .build())
 *                                 .s3Prefix("s3Prefix")
 *                                 .s3Region("s3Region")
 *                                 .build())
 *                         .build())
 *                 .name("name")
 *                 .refreshCadence(RefreshCadenceProperty.builder()
 *                         .frequency("frequency")
 *                         .build())
 *                 // the properties below are optional
 *                 .description("description")
 *                 .exportArn("exportArn")
 *                 .build())
 *         // the properties below are optional
 *         .tags(List.of(ResourceTagProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bcmdataexports-export.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bcmdataexports-export.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:20.358Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bcmdataexports.CfnExportProps")
@software.amazon.jsii.Jsii.Proxy(CfnExportProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnExportProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The details that are available for an export.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bcmdataexports-export.html#cfn-bcmdataexports-export-export">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bcmdataexports-export.html#cfn-bcmdataexports-export-export</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getExport();

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bcmdataexports-export.html#cfn-bcmdataexports-export-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bcmdataexports-export.html#cfn-bcmdataexports-export-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.bcmdataexports.CfnExport.ResourceTagProperty> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnExportProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnExportProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnExportProps> {
        java.lang.Object export;
        java.util.List<software.amazon.awscdk.services.bcmdataexports.CfnExport.ResourceTagProperty> tags;

        /**
         * Sets the value of {@link CfnExportProps#getExport}
         * @param export The details that are available for an export. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder export(software.amazon.awscdk.IResolvable export) {
            this.export = export;
            return this;
        }

        /**
         * Sets the value of {@link CfnExportProps#getExport}
         * @param export The details that are available for an export. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder export(software.amazon.awscdk.services.bcmdataexports.CfnExport.ExportProperty export) {
            this.export = export;
            return this;
        }

        /**
         * Sets the value of {@link CfnExportProps#getTags}
         * @param tags the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.services.bcmdataexports.CfnExport.ResourceTagProperty> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.services.bcmdataexports.CfnExport.ResourceTagProperty>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnExportProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnExportProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnExportProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnExportProps {
        private final java.lang.Object export;
        private final java.util.List<software.amazon.awscdk.services.bcmdataexports.CfnExport.ResourceTagProperty> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.export = software.amazon.jsii.Kernel.get(this, "export", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bcmdataexports.CfnExport.ResourceTagProperty.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.export = java.util.Objects.requireNonNull(builder.export, "export is required");
            this.tags = (java.util.List<software.amazon.awscdk.services.bcmdataexports.CfnExport.ResourceTagProperty>)builder.tags;
        }

        @Override
        public final java.lang.Object getExport() {
            return this.export;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.bcmdataexports.CfnExport.ResourceTagProperty> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("export", om.valueToTree(this.getExport()));
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bcmdataexports.CfnExportProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnExportProps.Jsii$Proxy that = (CfnExportProps.Jsii$Proxy) o;

            if (!export.equals(that.export)) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.export.hashCode();
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
