package software.amazon.awscdk.services.bedrock;

/**
 * Specifies a data source as a resource in a top-level template. Minimally, you must specify the following properties:.
 * <p>
 * <ul>
 * <li>Name – Specify a name for the data source.</li>
 * <li>KnowledgeBaseId – Specify the ID of the knowledge base for the data source to belong to.</li>
 * <li>DataSourceConfiguration – Specify information about the Amazon S3 bucket containing the data source. The following sub-properties are required:</li>
 * <li>Type – Specify the value <code>S3</code> .</li>
 * </ul>
 * <p>
 * For more information about setting up data sources in Amazon Bedrock , see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-ds.html">Set up a data source for your knowledge base</a> .
 * <p>
 * See the <em>Properties</em> section below for descriptions of both the required and optional properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrock.*;
 * CfnDataSource cfnDataSource = CfnDataSource.Builder.create(this, "MyCfnDataSource")
 *         .dataSourceConfiguration(DataSourceConfigurationProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .confluenceConfiguration(ConfluenceDataSourceConfigurationProperty.builder()
 *                         .sourceConfiguration(ConfluenceSourceConfigurationProperty.builder()
 *                                 .authType("authType")
 *                                 .credentialsSecretArn("credentialsSecretArn")
 *                                 .hostType("hostType")
 *                                 .hostUrl("hostUrl")
 *                                 .build())
 *                         // the properties below are optional
 *                         .crawlerConfiguration(ConfluenceCrawlerConfigurationProperty.builder()
 *                                 .filterConfiguration(CrawlFilterConfigurationProperty.builder()
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .patternObjectFilter(PatternObjectFilterConfigurationProperty.builder()
 *                                                 .filters(List.of(PatternObjectFilterProperty.builder()
 *                                                         .objectType("objectType")
 *                                                         // the properties below are optional
 *                                                         .exclusionFilters(List.of("exclusionFilters"))
 *                                                         .inclusionFilters(List.of("inclusionFilters"))
 *                                                         .build()))
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .s3Configuration(S3DataSourceConfigurationProperty.builder()
 *                         .bucketArn("bucketArn")
 *                         // the properties below are optional
 *                         .bucketOwnerAccountId("bucketOwnerAccountId")
 *                         .inclusionPrefixes(List.of("inclusionPrefixes"))
 *                         .build())
 *                 .salesforceConfiguration(SalesforceDataSourceConfigurationProperty.builder()
 *                         .sourceConfiguration(SalesforceSourceConfigurationProperty.builder()
 *                                 .authType("authType")
 *                                 .credentialsSecretArn("credentialsSecretArn")
 *                                 .hostUrl("hostUrl")
 *                                 .build())
 *                         // the properties below are optional
 *                         .crawlerConfiguration(SalesforceCrawlerConfigurationProperty.builder()
 *                                 .filterConfiguration(CrawlFilterConfigurationProperty.builder()
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .patternObjectFilter(PatternObjectFilterConfigurationProperty.builder()
 *                                                 .filters(List.of(PatternObjectFilterProperty.builder()
 *                                                         .objectType("objectType")
 *                                                         // the properties below are optional
 *                                                         .exclusionFilters(List.of("exclusionFilters"))
 *                                                         .inclusionFilters(List.of("inclusionFilters"))
 *                                                         .build()))
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .sharePointConfiguration(SharePointDataSourceConfigurationProperty.builder()
 *                         .sourceConfiguration(SharePointSourceConfigurationProperty.builder()
 *                                 .authType("authType")
 *                                 .credentialsSecretArn("credentialsSecretArn")
 *                                 .domain("domain")
 *                                 .hostType("hostType")
 *                                 .siteUrls(List.of("siteUrls"))
 *                                 // the properties below are optional
 *                                 .tenantId("tenantId")
 *                                 .build())
 *                         // the properties below are optional
 *                         .crawlerConfiguration(SharePointCrawlerConfigurationProperty.builder()
 *                                 .filterConfiguration(CrawlFilterConfigurationProperty.builder()
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .patternObjectFilter(PatternObjectFilterConfigurationProperty.builder()
 *                                                 .filters(List.of(PatternObjectFilterProperty.builder()
 *                                                         .objectType("objectType")
 *                                                         // the properties below are optional
 *                                                         .exclusionFilters(List.of("exclusionFilters"))
 *                                                         .inclusionFilters(List.of("inclusionFilters"))
 *                                                         .build()))
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .webConfiguration(WebDataSourceConfigurationProperty.builder()
 *                         .sourceConfiguration(WebSourceConfigurationProperty.builder()
 *                                 .urlConfiguration(UrlConfigurationProperty.builder()
 *                                         .seedUrls(List.of(SeedUrlProperty.builder()
 *                                                 .url("url")
 *                                                 .build()))
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .crawlerConfiguration(WebCrawlerConfigurationProperty.builder()
 *                                 .crawlerLimits(WebCrawlerLimitsProperty.builder()
 *                                         .rateLimit(123)
 *                                         .build())
 *                                 .exclusionFilters(List.of("exclusionFilters"))
 *                                 .inclusionFilters(List.of("inclusionFilters"))
 *                                 .scope("scope")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .knowledgeBaseId("knowledgeBaseId")
 *         .name("name")
 *         // the properties below are optional
 *         .dataDeletionPolicy("dataDeletionPolicy")
 *         .description("description")
 *         .serverSideEncryptionConfiguration(ServerSideEncryptionConfigurationProperty.builder()
 *                 .kmsKeyArn("kmsKeyArn")
 *                 .build())
 *         .vectorIngestionConfiguration(VectorIngestionConfigurationProperty.builder()
 *                 .chunkingConfiguration(ChunkingConfigurationProperty.builder()
 *                         .chunkingStrategy("chunkingStrategy")
 *                         // the properties below are optional
 *                         .fixedSizeChunkingConfiguration(FixedSizeChunkingConfigurationProperty.builder()
 *                                 .maxTokens(123)
 *                                 .overlapPercentage(123)
 *                                 .build())
 *                         .hierarchicalChunkingConfiguration(HierarchicalChunkingConfigurationProperty.builder()
 *                                 .levelConfigurations(List.of(HierarchicalChunkingLevelConfigurationProperty.builder()
 *                                         .maxTokens(123)
 *                                         .build()))
 *                                 .overlapTokens(123)
 *                                 .build())
 *                         .semanticChunkingConfiguration(SemanticChunkingConfigurationProperty.builder()
 *                                 .breakpointPercentileThreshold(123)
 *                                 .bufferSize(123)
 *                                 .maxTokens(123)
 *                                 .build())
 *                         .build())
 *                 .customTransformationConfiguration(CustomTransformationConfigurationProperty.builder()
 *                         .intermediateStorage(IntermediateStorageProperty.builder()
 *                                 .s3Location(S3LocationProperty.builder()
 *                                         .uri("uri")
 *                                         .build())
 *                                 .build())
 *                         .transformations(List.of(TransformationProperty.builder()
 *                                 .stepToApply("stepToApply")
 *                                 .transformationFunction(TransformationFunctionProperty.builder()
 *                                         .transformationLambdaConfiguration(TransformationLambdaConfigurationProperty.builder()
 *                                                 .lambdaArn("lambdaArn")
 *                                                 .build())
 *                                         .build())
 *                                 .build()))
 *                         .build())
 *                 .parsingConfiguration(ParsingConfigurationProperty.builder()
 *                         .parsingStrategy("parsingStrategy")
 *                         // the properties below are optional
 *                         .bedrockDataAutomationConfiguration(BedrockDataAutomationConfigurationProperty.builder()
 *                                 .parsingModality("parsingModality")
 *                                 .build())
 *                         .bedrockFoundationModelConfiguration(BedrockFoundationModelConfigurationProperty.builder()
 *                                 .modelArn("modelArn")
 *                                 // the properties below are optional
 *                                 .parsingModality("parsingModality")
 *                                 .parsingPrompt(ParsingPromptProperty.builder()
 *                                         .parsingPromptText("parsingPromptText")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:20.390Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource")
public class CfnDataSource extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDataSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.CfnDataSource.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bedrock.CfnDataSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The time at which the data source was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDataSourceId() {
        return software.amazon.jsii.Kernel.get(this, "attrDataSourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the data source. The following statuses are possible:.
     * <p>
     * <ul>
     * <li>Available – The data source has been created and is ready for ingestion into the knowledge base.</li>
     * <li>Deleting – The data source is being deleted.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDataSourceStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrDataSourceStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The detailed reasons on the failure to delete a data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrFailureReasons() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrFailureReasons", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The time at which the data source was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The connection configuration for the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDataSourceConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "dataSourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The connection configuration for the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSourceConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataSourceConfiguration", java.util.Objects.requireNonNull(value, "dataSourceConfiguration is required"));
    }

    /**
     * The connection configuration for the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSourceConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bedrock.CfnDataSource.DataSourceConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "dataSourceConfiguration", java.util.Objects.requireNonNull(value, "dataSourceConfiguration is required"));
    }

    /**
     * The unique identifier of the knowledge base to which the data source belongs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKnowledgeBaseId() {
        return software.amazon.jsii.Kernel.get(this, "knowledgeBaseId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the knowledge base to which the data source belongs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKnowledgeBaseId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "knowledgeBaseId", java.util.Objects.requireNonNull(value, "knowledgeBaseId is required"));
    }

    /**
     * The name of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The data deletion policy for the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDataDeletionPolicy() {
        return software.amazon.jsii.Kernel.get(this, "dataDeletionPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The data deletion policy for the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataDeletionPolicy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dataDeletionPolicy", value);
    }

    /**
     * The description of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Contains details about the configuration of the server-side encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getServerSideEncryptionConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "serverSideEncryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains details about the configuration of the server-side encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerSideEncryptionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "serverSideEncryptionConfiguration", value);
    }

    /**
     * Contains details about the configuration of the server-side encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerSideEncryptionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.bedrock.CfnDataSource.ServerSideEncryptionConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "serverSideEncryptionConfiguration", value);
    }

    /**
     * Contains details about how to ingest the documents in the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVectorIngestionConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "vectorIngestionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains details about how to ingest the documents in the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVectorIngestionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vectorIngestionConfiguration", value);
    }

    /**
     * Contains details about how to ingest the documents in the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVectorIngestionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.bedrock.CfnDataSource.VectorIngestionConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "vectorIngestionConfiguration", value);
    }
    /**
     * Contains configurations for using Amazon Bedrock Data Automation as the parser for ingesting your data sources.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * BedrockDataAutomationConfigurationProperty bedrockDataAutomationConfigurationProperty = BedrockDataAutomationConfigurationProperty.builder()
     *         .parsingModality("parsingModality")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-bedrockdataautomationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-bedrockdataautomationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.BedrockDataAutomationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(BedrockDataAutomationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BedrockDataAutomationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether to enable parsing of multimodal data, including both text and/or images.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-bedrockdataautomationconfiguration.html#cfn-bedrock-datasource-bedrockdataautomationconfiguration-parsingmodality">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-bedrockdataautomationconfiguration.html#cfn-bedrock-datasource-bedrockdataautomationconfiguration-parsingmodality</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getParsingModality() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BedrockDataAutomationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BedrockDataAutomationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BedrockDataAutomationConfigurationProperty> {
            java.lang.String parsingModality;

            /**
             * Sets the value of {@link BedrockDataAutomationConfigurationProperty#getParsingModality}
             * @param parsingModality Specifies whether to enable parsing of multimodal data, including both text and/or images.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parsingModality(java.lang.String parsingModality) {
                this.parsingModality = parsingModality;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BedrockDataAutomationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BedrockDataAutomationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BedrockDataAutomationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BedrockDataAutomationConfigurationProperty {
            private final java.lang.String parsingModality;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.parsingModality = software.amazon.jsii.Kernel.get(this, "parsingModality", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.parsingModality = builder.parsingModality;
            }

            @Override
            public final java.lang.String getParsingModality() {
                return this.parsingModality;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getParsingModality() != null) {
                    data.set("parsingModality", om.valueToTree(this.getParsingModality()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.BedrockDataAutomationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BedrockDataAutomationConfigurationProperty.Jsii$Proxy that = (BedrockDataAutomationConfigurationProperty.Jsii$Proxy) o;

                return this.parsingModality != null ? this.parsingModality.equals(that.parsingModality) : that.parsingModality == null;
            }

            @Override
            public final int hashCode() {
                int result = this.parsingModality != null ? this.parsingModality.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Settings for a foundation model used to parse documents for a data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * BedrockFoundationModelConfigurationProperty bedrockFoundationModelConfigurationProperty = BedrockFoundationModelConfigurationProperty.builder()
     *         .modelArn("modelArn")
     *         // the properties below are optional
     *         .parsingModality("parsingModality")
     *         .parsingPrompt(ParsingPromptProperty.builder()
     *                 .parsingPromptText("parsingPromptText")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-bedrockfoundationmodelconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-bedrockfoundationmodelconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.BedrockFoundationModelConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(BedrockFoundationModelConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BedrockFoundationModelConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the foundation model to use for parsing.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-bedrockfoundationmodelconfiguration.html#cfn-bedrock-datasource-bedrockfoundationmodelconfiguration-modelarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-bedrockfoundationmodelconfiguration.html#cfn-bedrock-datasource-bedrockfoundationmodelconfiguration-modelarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getModelArn();

        /**
         * Specifies whether to enable parsing of multimodal data, including both text and/or images.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-bedrockfoundationmodelconfiguration.html#cfn-bedrock-datasource-bedrockfoundationmodelconfiguration-parsingmodality">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-bedrockfoundationmodelconfiguration.html#cfn-bedrock-datasource-bedrockfoundationmodelconfiguration-parsingmodality</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getParsingModality() {
            return null;
        }

        /**
         * Instructions for interpreting the contents of a document.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-bedrockfoundationmodelconfiguration.html#cfn-bedrock-datasource-bedrockfoundationmodelconfiguration-parsingprompt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-bedrockfoundationmodelconfiguration.html#cfn-bedrock-datasource-bedrockfoundationmodelconfiguration-parsingprompt</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParsingPrompt() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BedrockFoundationModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BedrockFoundationModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BedrockFoundationModelConfigurationProperty> {
            java.lang.String modelArn;
            java.lang.String parsingModality;
            java.lang.Object parsingPrompt;

            /**
             * Sets the value of {@link BedrockFoundationModelConfigurationProperty#getModelArn}
             * @param modelArn The ARN of the foundation model to use for parsing. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelArn(java.lang.String modelArn) {
                this.modelArn = modelArn;
                return this;
            }

            /**
             * Sets the value of {@link BedrockFoundationModelConfigurationProperty#getParsingModality}
             * @param parsingModality Specifies whether to enable parsing of multimodal data, including both text and/or images.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parsingModality(java.lang.String parsingModality) {
                this.parsingModality = parsingModality;
                return this;
            }

            /**
             * Sets the value of {@link BedrockFoundationModelConfigurationProperty#getParsingPrompt}
             * @param parsingPrompt Instructions for interpreting the contents of a document.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parsingPrompt(software.amazon.awscdk.IResolvable parsingPrompt) {
                this.parsingPrompt = parsingPrompt;
                return this;
            }

            /**
             * Sets the value of {@link BedrockFoundationModelConfigurationProperty#getParsingPrompt}
             * @param parsingPrompt Instructions for interpreting the contents of a document.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parsingPrompt(software.amazon.awscdk.services.bedrock.CfnDataSource.ParsingPromptProperty parsingPrompt) {
                this.parsingPrompt = parsingPrompt;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BedrockFoundationModelConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BedrockFoundationModelConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BedrockFoundationModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BedrockFoundationModelConfigurationProperty {
            private final java.lang.String modelArn;
            private final java.lang.String parsingModality;
            private final java.lang.Object parsingPrompt;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.modelArn = software.amazon.jsii.Kernel.get(this, "modelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parsingModality = software.amazon.jsii.Kernel.get(this, "parsingModality", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parsingPrompt = software.amazon.jsii.Kernel.get(this, "parsingPrompt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.modelArn = java.util.Objects.requireNonNull(builder.modelArn, "modelArn is required");
                this.parsingModality = builder.parsingModality;
                this.parsingPrompt = builder.parsingPrompt;
            }

            @Override
            public final java.lang.String getModelArn() {
                return this.modelArn;
            }

            @Override
            public final java.lang.String getParsingModality() {
                return this.parsingModality;
            }

            @Override
            public final java.lang.Object getParsingPrompt() {
                return this.parsingPrompt;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("modelArn", om.valueToTree(this.getModelArn()));
                if (this.getParsingModality() != null) {
                    data.set("parsingModality", om.valueToTree(this.getParsingModality()));
                }
                if (this.getParsingPrompt() != null) {
                    data.set("parsingPrompt", om.valueToTree(this.getParsingPrompt()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.BedrockFoundationModelConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BedrockFoundationModelConfigurationProperty.Jsii$Proxy that = (BedrockFoundationModelConfigurationProperty.Jsii$Proxy) o;

                if (!modelArn.equals(that.modelArn)) return false;
                if (this.parsingModality != null ? !this.parsingModality.equals(that.parsingModality) : that.parsingModality != null) return false;
                return this.parsingPrompt != null ? this.parsingPrompt.equals(that.parsingPrompt) : that.parsingPrompt == null;
            }

            @Override
            public final int hashCode() {
                int result = this.modelArn.hashCode();
                result = 31 * result + (this.parsingModality != null ? this.parsingModality.hashCode() : 0);
                result = 31 * result + (this.parsingPrompt != null ? this.parsingPrompt.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Details about how to chunk the documents in the data source.
     * <p>
     * A <em>chunk</em> refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ChunkingConfigurationProperty chunkingConfigurationProperty = ChunkingConfigurationProperty.builder()
     *         .chunkingStrategy("chunkingStrategy")
     *         // the properties below are optional
     *         .fixedSizeChunkingConfiguration(FixedSizeChunkingConfigurationProperty.builder()
     *                 .maxTokens(123)
     *                 .overlapPercentage(123)
     *                 .build())
     *         .hierarchicalChunkingConfiguration(HierarchicalChunkingConfigurationProperty.builder()
     *                 .levelConfigurations(List.of(HierarchicalChunkingLevelConfigurationProperty.builder()
     *                         .maxTokens(123)
     *                         .build()))
     *                 .overlapTokens(123)
     *                 .build())
     *         .semanticChunkingConfiguration(SemanticChunkingConfigurationProperty.builder()
     *                 .breakpointPercentileThreshold(123)
     *                 .bufferSize(123)
     *                 .maxTokens(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-chunkingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-chunkingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.ChunkingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ChunkingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ChunkingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Knowledge base can split your source data into chunks.
         * <p>
         * A <em>chunk</em> refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried. You have the following options for chunking your data. If you opt for <code>NONE</code> , then you may want to pre-process your files by splitting them up such that each file corresponds to a chunk.
         * <p>
         * <ul>
         * <li><code>FIXED_SIZE</code> – Amazon Bedrock splits your source data into chunks of the approximate size that you set in the <code>fixedSizeChunkingConfiguration</code> .</li>
         * <li><code>HIERARCHICAL</code> – Split documents into layers of chunks where the first layer contains large chunks, and the second layer contains smaller chunks derived from the first layer.</li>
         * <li><code>SEMANTIC</code> – Split documents into chunks based on groups of similar content derived with natural language processing.</li>
         * <li><code>NONE</code> – Amazon Bedrock treats each file as one chunk. If you choose this option, you may want to pre-process your documents by splitting them into separate files.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-chunkingconfiguration.html#cfn-bedrock-datasource-chunkingconfiguration-chunkingstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-chunkingconfiguration.html#cfn-bedrock-datasource-chunkingconfiguration-chunkingstrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getChunkingStrategy();

        /**
         * Configurations for when you choose fixed-size chunking.
         * <p>
         * If you set the <code>chunkingStrategy</code> as <code>NONE</code> , exclude this field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-chunkingconfiguration.html#cfn-bedrock-datasource-chunkingconfiguration-fixedsizechunkingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-chunkingconfiguration.html#cfn-bedrock-datasource-chunkingconfiguration-fixedsizechunkingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFixedSizeChunkingConfiguration() {
            return null;
        }

        /**
         * Settings for hierarchical document chunking for a data source.
         * <p>
         * Hierarchical chunking splits documents into layers of chunks where the first layer contains large chunks, and the second layer contains smaller chunks derived from the first layer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-chunkingconfiguration.html#cfn-bedrock-datasource-chunkingconfiguration-hierarchicalchunkingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-chunkingconfiguration.html#cfn-bedrock-datasource-chunkingconfiguration-hierarchicalchunkingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHierarchicalChunkingConfiguration() {
            return null;
        }

        /**
         * Settings for semantic document chunking for a data source.
         * <p>
         * Semantic chunking splits a document into into smaller documents based on groups of similar content derived from the text with natural language processing.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-chunkingconfiguration.html#cfn-bedrock-datasource-chunkingconfiguration-semanticchunkingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-chunkingconfiguration.html#cfn-bedrock-datasource-chunkingconfiguration-semanticchunkingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSemanticChunkingConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ChunkingConfigurationProperty> {
            java.lang.String chunkingStrategy;
            java.lang.Object fixedSizeChunkingConfiguration;
            java.lang.Object hierarchicalChunkingConfiguration;
            java.lang.Object semanticChunkingConfiguration;

            /**
             * Sets the value of {@link ChunkingConfigurationProperty#getChunkingStrategy}
             * @param chunkingStrategy Knowledge base can split your source data into chunks. This parameter is required.
             *                         A <em>chunk</em> refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried. You have the following options for chunking your data. If you opt for <code>NONE</code> , then you may want to pre-process your files by splitting them up such that each file corresponds to a chunk.
             *                         <p>
             *                         <ul>
             *                         <li><code>FIXED_SIZE</code> – Amazon Bedrock splits your source data into chunks of the approximate size that you set in the <code>fixedSizeChunkingConfiguration</code> .</li>
             *                         <li><code>HIERARCHICAL</code> – Split documents into layers of chunks where the first layer contains large chunks, and the second layer contains smaller chunks derived from the first layer.</li>
             *                         <li><code>SEMANTIC</code> – Split documents into chunks based on groups of similar content derived with natural language processing.</li>
             *                         <li><code>NONE</code> – Amazon Bedrock treats each file as one chunk. If you choose this option, you may want to pre-process your documents by splitting them into separate files.</li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder chunkingStrategy(java.lang.String chunkingStrategy) {
                this.chunkingStrategy = chunkingStrategy;
                return this;
            }

            /**
             * Sets the value of {@link ChunkingConfigurationProperty#getFixedSizeChunkingConfiguration}
             * @param fixedSizeChunkingConfiguration Configurations for when you choose fixed-size chunking.
             *                                       If you set the <code>chunkingStrategy</code> as <code>NONE</code> , exclude this field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fixedSizeChunkingConfiguration(software.amazon.awscdk.IResolvable fixedSizeChunkingConfiguration) {
                this.fixedSizeChunkingConfiguration = fixedSizeChunkingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ChunkingConfigurationProperty#getFixedSizeChunkingConfiguration}
             * @param fixedSizeChunkingConfiguration Configurations for when you choose fixed-size chunking.
             *                                       If you set the <code>chunkingStrategy</code> as <code>NONE</code> , exclude this field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fixedSizeChunkingConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.FixedSizeChunkingConfigurationProperty fixedSizeChunkingConfiguration) {
                this.fixedSizeChunkingConfiguration = fixedSizeChunkingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ChunkingConfigurationProperty#getHierarchicalChunkingConfiguration}
             * @param hierarchicalChunkingConfiguration Settings for hierarchical document chunking for a data source.
             *                                          Hierarchical chunking splits documents into layers of chunks where the first layer contains large chunks, and the second layer contains smaller chunks derived from the first layer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hierarchicalChunkingConfiguration(software.amazon.awscdk.IResolvable hierarchicalChunkingConfiguration) {
                this.hierarchicalChunkingConfiguration = hierarchicalChunkingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ChunkingConfigurationProperty#getHierarchicalChunkingConfiguration}
             * @param hierarchicalChunkingConfiguration Settings for hierarchical document chunking for a data source.
             *                                          Hierarchical chunking splits documents into layers of chunks where the first layer contains large chunks, and the second layer contains smaller chunks derived from the first layer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hierarchicalChunkingConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.HierarchicalChunkingConfigurationProperty hierarchicalChunkingConfiguration) {
                this.hierarchicalChunkingConfiguration = hierarchicalChunkingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ChunkingConfigurationProperty#getSemanticChunkingConfiguration}
             * @param semanticChunkingConfiguration Settings for semantic document chunking for a data source.
             *                                      Semantic chunking splits a document into into smaller documents based on groups of similar content derived from the text with natural language processing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder semanticChunkingConfiguration(software.amazon.awscdk.IResolvable semanticChunkingConfiguration) {
                this.semanticChunkingConfiguration = semanticChunkingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ChunkingConfigurationProperty#getSemanticChunkingConfiguration}
             * @param semanticChunkingConfiguration Settings for semantic document chunking for a data source.
             *                                      Semantic chunking splits a document into into smaller documents based on groups of similar content derived from the text with natural language processing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder semanticChunkingConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.SemanticChunkingConfigurationProperty semanticChunkingConfiguration) {
                this.semanticChunkingConfiguration = semanticChunkingConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ChunkingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ChunkingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ChunkingConfigurationProperty {
            private final java.lang.String chunkingStrategy;
            private final java.lang.Object fixedSizeChunkingConfiguration;
            private final java.lang.Object hierarchicalChunkingConfiguration;
            private final java.lang.Object semanticChunkingConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.chunkingStrategy = software.amazon.jsii.Kernel.get(this, "chunkingStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fixedSizeChunkingConfiguration = software.amazon.jsii.Kernel.get(this, "fixedSizeChunkingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hierarchicalChunkingConfiguration = software.amazon.jsii.Kernel.get(this, "hierarchicalChunkingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.semanticChunkingConfiguration = software.amazon.jsii.Kernel.get(this, "semanticChunkingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.chunkingStrategy = java.util.Objects.requireNonNull(builder.chunkingStrategy, "chunkingStrategy is required");
                this.fixedSizeChunkingConfiguration = builder.fixedSizeChunkingConfiguration;
                this.hierarchicalChunkingConfiguration = builder.hierarchicalChunkingConfiguration;
                this.semanticChunkingConfiguration = builder.semanticChunkingConfiguration;
            }

            @Override
            public final java.lang.String getChunkingStrategy() {
                return this.chunkingStrategy;
            }

            @Override
            public final java.lang.Object getFixedSizeChunkingConfiguration() {
                return this.fixedSizeChunkingConfiguration;
            }

            @Override
            public final java.lang.Object getHierarchicalChunkingConfiguration() {
                return this.hierarchicalChunkingConfiguration;
            }

            @Override
            public final java.lang.Object getSemanticChunkingConfiguration() {
                return this.semanticChunkingConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("chunkingStrategy", om.valueToTree(this.getChunkingStrategy()));
                if (this.getFixedSizeChunkingConfiguration() != null) {
                    data.set("fixedSizeChunkingConfiguration", om.valueToTree(this.getFixedSizeChunkingConfiguration()));
                }
                if (this.getHierarchicalChunkingConfiguration() != null) {
                    data.set("hierarchicalChunkingConfiguration", om.valueToTree(this.getHierarchicalChunkingConfiguration()));
                }
                if (this.getSemanticChunkingConfiguration() != null) {
                    data.set("semanticChunkingConfiguration", om.valueToTree(this.getSemanticChunkingConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.ChunkingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ChunkingConfigurationProperty.Jsii$Proxy that = (ChunkingConfigurationProperty.Jsii$Proxy) o;

                if (!chunkingStrategy.equals(that.chunkingStrategy)) return false;
                if (this.fixedSizeChunkingConfiguration != null ? !this.fixedSizeChunkingConfiguration.equals(that.fixedSizeChunkingConfiguration) : that.fixedSizeChunkingConfiguration != null) return false;
                if (this.hierarchicalChunkingConfiguration != null ? !this.hierarchicalChunkingConfiguration.equals(that.hierarchicalChunkingConfiguration) : that.hierarchicalChunkingConfiguration != null) return false;
                return this.semanticChunkingConfiguration != null ? this.semanticChunkingConfiguration.equals(that.semanticChunkingConfiguration) : that.semanticChunkingConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.chunkingStrategy.hashCode();
                result = 31 * result + (this.fixedSizeChunkingConfiguration != null ? this.fixedSizeChunkingConfiguration.hashCode() : 0);
                result = 31 * result + (this.hierarchicalChunkingConfiguration != null ? this.hierarchicalChunkingConfiguration.hashCode() : 0);
                result = 31 * result + (this.semanticChunkingConfiguration != null ? this.semanticChunkingConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of the Confluence content.
     * <p>
     * For example, configuring specific types of Confluence content.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ConfluenceCrawlerConfigurationProperty confluenceCrawlerConfigurationProperty = ConfluenceCrawlerConfigurationProperty.builder()
     *         .filterConfiguration(CrawlFilterConfigurationProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .patternObjectFilter(PatternObjectFilterConfigurationProperty.builder()
     *                         .filters(List.of(PatternObjectFilterProperty.builder()
     *                                 .objectType("objectType")
     *                                 // the properties below are optional
     *                                 .exclusionFilters(List.of("exclusionFilters"))
     *                                 .inclusionFilters(List.of("inclusionFilters"))
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-confluencecrawlerconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-confluencecrawlerconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.ConfluenceCrawlerConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfluenceCrawlerConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfluenceCrawlerConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration of filtering the Confluence content.
         * <p>
         * For example, configuring regular expression patterns to include or exclude certain content.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-confluencecrawlerconfiguration.html#cfn-bedrock-datasource-confluencecrawlerconfiguration-filterconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-confluencecrawlerconfiguration.html#cfn-bedrock-datasource-confluencecrawlerconfiguration-filterconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilterConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfluenceCrawlerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfluenceCrawlerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfluenceCrawlerConfigurationProperty> {
            java.lang.Object filterConfiguration;

            /**
             * Sets the value of {@link ConfluenceCrawlerConfigurationProperty#getFilterConfiguration}
             * @param filterConfiguration The configuration of filtering the Confluence content.
             *                            For example, configuring regular expression patterns to include or exclude certain content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterConfiguration(software.amazon.awscdk.IResolvable filterConfiguration) {
                this.filterConfiguration = filterConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceCrawlerConfigurationProperty#getFilterConfiguration}
             * @param filterConfiguration The configuration of filtering the Confluence content.
             *                            For example, configuring regular expression patterns to include or exclude certain content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.CrawlFilterConfigurationProperty filterConfiguration) {
                this.filterConfiguration = filterConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfluenceCrawlerConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfluenceCrawlerConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfluenceCrawlerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfluenceCrawlerConfigurationProperty {
            private final java.lang.Object filterConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.filterConfiguration = software.amazon.jsii.Kernel.get(this, "filterConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.filterConfiguration = builder.filterConfiguration;
            }

            @Override
            public final java.lang.Object getFilterConfiguration() {
                return this.filterConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFilterConfiguration() != null) {
                    data.set("filterConfiguration", om.valueToTree(this.getFilterConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.ConfluenceCrawlerConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfluenceCrawlerConfigurationProperty.Jsii$Proxy that = (ConfluenceCrawlerConfigurationProperty.Jsii$Proxy) o;

                return this.filterConfiguration != null ? this.filterConfiguration.equals(that.filterConfiguration) : that.filterConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.filterConfiguration != null ? this.filterConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The configuration information to connect to Confluence as your data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ConfluenceDataSourceConfigurationProperty confluenceDataSourceConfigurationProperty = ConfluenceDataSourceConfigurationProperty.builder()
     *         .sourceConfiguration(ConfluenceSourceConfigurationProperty.builder()
     *                 .authType("authType")
     *                 .credentialsSecretArn("credentialsSecretArn")
     *                 .hostType("hostType")
     *                 .hostUrl("hostUrl")
     *                 .build())
     *         // the properties below are optional
     *         .crawlerConfiguration(ConfluenceCrawlerConfigurationProperty.builder()
     *                 .filterConfiguration(CrawlFilterConfigurationProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .patternObjectFilter(PatternObjectFilterConfigurationProperty.builder()
     *                                 .filters(List.of(PatternObjectFilterProperty.builder()
     *                                         .objectType("objectType")
     *                                         // the properties below are optional
     *                                         .exclusionFilters(List.of("exclusionFilters"))
     *                                         .inclusionFilters(List.of("inclusionFilters"))
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-confluencedatasourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-confluencedatasourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.ConfluenceDataSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfluenceDataSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfluenceDataSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The endpoint information to connect to your Confluence data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-confluencedatasourceconfiguration.html#cfn-bedrock-datasource-confluencedatasourceconfiguration-sourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-confluencedatasourceconfiguration.html#cfn-bedrock-datasource-confluencedatasourceconfiguration-sourceconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSourceConfiguration();

        /**
         * The configuration of the Confluence content.
         * <p>
         * For example, configuring specific types of Confluence content.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-confluencedatasourceconfiguration.html#cfn-bedrock-datasource-confluencedatasourceconfiguration-crawlerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-confluencedatasourceconfiguration.html#cfn-bedrock-datasource-confluencedatasourceconfiguration-crawlerconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCrawlerConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfluenceDataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfluenceDataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfluenceDataSourceConfigurationProperty> {
            java.lang.Object sourceConfiguration;
            java.lang.Object crawlerConfiguration;

            /**
             * Sets the value of {@link ConfluenceDataSourceConfigurationProperty#getSourceConfiguration}
             * @param sourceConfiguration The endpoint information to connect to your Confluence data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceConfiguration(software.amazon.awscdk.IResolvable sourceConfiguration) {
                this.sourceConfiguration = sourceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceDataSourceConfigurationProperty#getSourceConfiguration}
             * @param sourceConfiguration The endpoint information to connect to your Confluence data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.ConfluenceSourceConfigurationProperty sourceConfiguration) {
                this.sourceConfiguration = sourceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceDataSourceConfigurationProperty#getCrawlerConfiguration}
             * @param crawlerConfiguration The configuration of the Confluence content.
             *                             For example, configuring specific types of Confluence content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlerConfiguration(software.amazon.awscdk.IResolvable crawlerConfiguration) {
                this.crawlerConfiguration = crawlerConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceDataSourceConfigurationProperty#getCrawlerConfiguration}
             * @param crawlerConfiguration The configuration of the Confluence content.
             *                             For example, configuring specific types of Confluence content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlerConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.ConfluenceCrawlerConfigurationProperty crawlerConfiguration) {
                this.crawlerConfiguration = crawlerConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfluenceDataSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfluenceDataSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfluenceDataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfluenceDataSourceConfigurationProperty {
            private final java.lang.Object sourceConfiguration;
            private final java.lang.Object crawlerConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceConfiguration = software.amazon.jsii.Kernel.get(this, "sourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.crawlerConfiguration = software.amazon.jsii.Kernel.get(this, "crawlerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceConfiguration = java.util.Objects.requireNonNull(builder.sourceConfiguration, "sourceConfiguration is required");
                this.crawlerConfiguration = builder.crawlerConfiguration;
            }

            @Override
            public final java.lang.Object getSourceConfiguration() {
                return this.sourceConfiguration;
            }

            @Override
            public final java.lang.Object getCrawlerConfiguration() {
                return this.crawlerConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sourceConfiguration", om.valueToTree(this.getSourceConfiguration()));
                if (this.getCrawlerConfiguration() != null) {
                    data.set("crawlerConfiguration", om.valueToTree(this.getCrawlerConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.ConfluenceDataSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfluenceDataSourceConfigurationProperty.Jsii$Proxy that = (ConfluenceDataSourceConfigurationProperty.Jsii$Proxy) o;

                if (!sourceConfiguration.equals(that.sourceConfiguration)) return false;
                return this.crawlerConfiguration != null ? this.crawlerConfiguration.equals(that.crawlerConfiguration) : that.crawlerConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourceConfiguration.hashCode();
                result = 31 * result + (this.crawlerConfiguration != null ? this.crawlerConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The endpoint information to connect to your Confluence data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ConfluenceSourceConfigurationProperty confluenceSourceConfigurationProperty = ConfluenceSourceConfigurationProperty.builder()
     *         .authType("authType")
     *         .credentialsSecretArn("credentialsSecretArn")
     *         .hostType("hostType")
     *         .hostUrl("hostUrl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-confluencesourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-confluencesourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.ConfluenceSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfluenceSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfluenceSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The supported authentication type to authenticate and connect to your Confluence instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-confluencesourceconfiguration.html#cfn-bedrock-datasource-confluencesourceconfiguration-authtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-confluencesourceconfiguration.html#cfn-bedrock-datasource-confluencesourceconfiguration-authtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAuthType();

        /**
         * The Amazon Resource Name of an AWS Secrets Manager secret that stores your authentication credentials for your Confluence instance URL.
         * <p>
         * For more information on the key-value pairs that must be included in your secret, depending on your authentication type, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/confluence-data-source-connector.html#configuration-confluence-connector">Confluence connection configuration</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-confluencesourceconfiguration.html#cfn-bedrock-datasource-confluencesourceconfiguration-credentialssecretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-confluencesourceconfiguration.html#cfn-bedrock-datasource-confluencesourceconfiguration-credentialssecretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCredentialsSecretArn();

        /**
         * The supported host type, whether online/cloud or server/on-premises.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-confluencesourceconfiguration.html#cfn-bedrock-datasource-confluencesourceconfiguration-hosttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-confluencesourceconfiguration.html#cfn-bedrock-datasource-confluencesourceconfiguration-hosttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHostType();

        /**
         * The Confluence host URL or instance URL.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-confluencesourceconfiguration.html#cfn-bedrock-datasource-confluencesourceconfiguration-hosturl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-confluencesourceconfiguration.html#cfn-bedrock-datasource-confluencesourceconfiguration-hosturl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHostUrl();

        /**
         * @return a {@link Builder} of {@link ConfluenceSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfluenceSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfluenceSourceConfigurationProperty> {
            java.lang.String authType;
            java.lang.String credentialsSecretArn;
            java.lang.String hostType;
            java.lang.String hostUrl;

            /**
             * Sets the value of {@link ConfluenceSourceConfigurationProperty#getAuthType}
             * @param authType The supported authentication type to authenticate and connect to your Confluence instance. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authType(java.lang.String authType) {
                this.authType = authType;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceSourceConfigurationProperty#getCredentialsSecretArn}
             * @param credentialsSecretArn The Amazon Resource Name of an AWS Secrets Manager secret that stores your authentication credentials for your Confluence instance URL. This parameter is required.
             *                             For more information on the key-value pairs that must be included in your secret, depending on your authentication type, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/confluence-data-source-connector.html#configuration-confluence-connector">Confluence connection configuration</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialsSecretArn(java.lang.String credentialsSecretArn) {
                this.credentialsSecretArn = credentialsSecretArn;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceSourceConfigurationProperty#getHostType}
             * @param hostType The supported host type, whether online/cloud or server/on-premises. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostType(java.lang.String hostType) {
                this.hostType = hostType;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceSourceConfigurationProperty#getHostUrl}
             * @param hostUrl The Confluence host URL or instance URL. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostUrl(java.lang.String hostUrl) {
                this.hostUrl = hostUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfluenceSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfluenceSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfluenceSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfluenceSourceConfigurationProperty {
            private final java.lang.String authType;
            private final java.lang.String credentialsSecretArn;
            private final java.lang.String hostType;
            private final java.lang.String hostUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authType = software.amazon.jsii.Kernel.get(this, "authType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.credentialsSecretArn = software.amazon.jsii.Kernel.get(this, "credentialsSecretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostType = software.amazon.jsii.Kernel.get(this, "hostType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostUrl = software.amazon.jsii.Kernel.get(this, "hostUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authType = java.util.Objects.requireNonNull(builder.authType, "authType is required");
                this.credentialsSecretArn = java.util.Objects.requireNonNull(builder.credentialsSecretArn, "credentialsSecretArn is required");
                this.hostType = java.util.Objects.requireNonNull(builder.hostType, "hostType is required");
                this.hostUrl = java.util.Objects.requireNonNull(builder.hostUrl, "hostUrl is required");
            }

            @Override
            public final java.lang.String getAuthType() {
                return this.authType;
            }

            @Override
            public final java.lang.String getCredentialsSecretArn() {
                return this.credentialsSecretArn;
            }

            @Override
            public final java.lang.String getHostType() {
                return this.hostType;
            }

            @Override
            public final java.lang.String getHostUrl() {
                return this.hostUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("authType", om.valueToTree(this.getAuthType()));
                data.set("credentialsSecretArn", om.valueToTree(this.getCredentialsSecretArn()));
                data.set("hostType", om.valueToTree(this.getHostType()));
                data.set("hostUrl", om.valueToTree(this.getHostUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.ConfluenceSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfluenceSourceConfigurationProperty.Jsii$Proxy that = (ConfluenceSourceConfigurationProperty.Jsii$Proxy) o;

                if (!authType.equals(that.authType)) return false;
                if (!credentialsSecretArn.equals(that.credentialsSecretArn)) return false;
                if (!hostType.equals(that.hostType)) return false;
                return this.hostUrl.equals(that.hostUrl);
            }

            @Override
            public final int hashCode() {
                int result = this.authType.hashCode();
                result = 31 * result + (this.credentialsSecretArn.hashCode());
                result = 31 * result + (this.hostType.hashCode());
                result = 31 * result + (this.hostUrl.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration of filtering the data source content.
     * <p>
     * For example, configuring regular expression patterns to include or exclude certain content.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * CrawlFilterConfigurationProperty crawlFilterConfigurationProperty = CrawlFilterConfigurationProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .patternObjectFilter(PatternObjectFilterConfigurationProperty.builder()
     *                 .filters(List.of(PatternObjectFilterProperty.builder()
     *                         .objectType("objectType")
     *                         // the properties below are optional
     *                         .exclusionFilters(List.of("exclusionFilters"))
     *                         .inclusionFilters(List.of("inclusionFilters"))
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-crawlfilterconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-crawlfilterconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.CrawlFilterConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CrawlFilterConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CrawlFilterConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of filtering that you want to apply to certain objects or content of the data source.
         * <p>
         * For example, the <code>PATTERN</code> type is regular expression patterns you can apply to filter your content.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-crawlfilterconfiguration.html#cfn-bedrock-datasource-crawlfilterconfiguration-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-crawlfilterconfiguration.html#cfn-bedrock-datasource-crawlfilterconfiguration-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The configuration of filtering certain objects or content types of the data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-crawlfilterconfiguration.html#cfn-bedrock-datasource-crawlfilterconfiguration-patternobjectfilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-crawlfilterconfiguration.html#cfn-bedrock-datasource-crawlfilterconfiguration-patternobjectfilter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPatternObjectFilter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CrawlFilterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CrawlFilterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CrawlFilterConfigurationProperty> {
            java.lang.String type;
            java.lang.Object patternObjectFilter;

            /**
             * Sets the value of {@link CrawlFilterConfigurationProperty#getType}
             * @param type The type of filtering that you want to apply to certain objects or content of the data source. This parameter is required.
             *             For example, the <code>PATTERN</code> type is regular expression patterns you can apply to filter your content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link CrawlFilterConfigurationProperty#getPatternObjectFilter}
             * @param patternObjectFilter The configuration of filtering certain objects or content types of the data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder patternObjectFilter(software.amazon.awscdk.IResolvable patternObjectFilter) {
                this.patternObjectFilter = patternObjectFilter;
                return this;
            }

            /**
             * Sets the value of {@link CrawlFilterConfigurationProperty#getPatternObjectFilter}
             * @param patternObjectFilter The configuration of filtering certain objects or content types of the data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder patternObjectFilter(software.amazon.awscdk.services.bedrock.CfnDataSource.PatternObjectFilterConfigurationProperty patternObjectFilter) {
                this.patternObjectFilter = patternObjectFilter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CrawlFilterConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CrawlFilterConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CrawlFilterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CrawlFilterConfigurationProperty {
            private final java.lang.String type;
            private final java.lang.Object patternObjectFilter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.patternObjectFilter = software.amazon.jsii.Kernel.get(this, "patternObjectFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.patternObjectFilter = builder.patternObjectFilter;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getPatternObjectFilter() {
                return this.patternObjectFilter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getPatternObjectFilter() != null) {
                    data.set("patternObjectFilter", om.valueToTree(this.getPatternObjectFilter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.CrawlFilterConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CrawlFilterConfigurationProperty.Jsii$Proxy that = (CrawlFilterConfigurationProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.patternObjectFilter != null ? this.patternObjectFilter.equals(that.patternObjectFilter) : that.patternObjectFilter == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.patternObjectFilter != null ? this.patternObjectFilter.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings for customizing steps in the data source content ingestion pipeline.
     * <p>
     * You can configure the data source to process documents with a Lambda function after they are parsed and converted into chunks. When you add a post-chunking transformation, the service stores chunked documents in an S3 bucket and invokes a Lambda function to process them.
     * <p>
     * To process chunked documents with a Lambda function, define an S3 bucket path for input and output objects, and a transformation that specifies the Lambda function to invoke. You can use the Lambda function to customize how chunks are split, and the metadata for each chunk.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * CustomTransformationConfigurationProperty customTransformationConfigurationProperty = CustomTransformationConfigurationProperty.builder()
     *         .intermediateStorage(IntermediateStorageProperty.builder()
     *                 .s3Location(S3LocationProperty.builder()
     *                         .uri("uri")
     *                         .build())
     *                 .build())
     *         .transformations(List.of(TransformationProperty.builder()
     *                 .stepToApply("stepToApply")
     *                 .transformationFunction(TransformationFunctionProperty.builder()
     *                         .transformationLambdaConfiguration(TransformationLambdaConfigurationProperty.builder()
     *                                 .lambdaArn("lambdaArn")
     *                                 .build())
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-customtransformationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-customtransformationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.CustomTransformationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomTransformationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomTransformationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An S3 bucket path for input and output objects.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-customtransformationconfiguration.html#cfn-bedrock-datasource-customtransformationconfiguration-intermediatestorage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-customtransformationconfiguration.html#cfn-bedrock-datasource-customtransformationconfiguration-intermediatestorage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIntermediateStorage();

        /**
         * A Lambda function that processes documents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-customtransformationconfiguration.html#cfn-bedrock-datasource-customtransformationconfiguration-transformations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-customtransformationconfiguration.html#cfn-bedrock-datasource-customtransformationconfiguration-transformations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTransformations();

        /**
         * @return a {@link Builder} of {@link CustomTransformationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomTransformationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomTransformationConfigurationProperty> {
            java.lang.Object intermediateStorage;
            java.lang.Object transformations;

            /**
             * Sets the value of {@link CustomTransformationConfigurationProperty#getIntermediateStorage}
             * @param intermediateStorage An S3 bucket path for input and output objects. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intermediateStorage(software.amazon.awscdk.IResolvable intermediateStorage) {
                this.intermediateStorage = intermediateStorage;
                return this;
            }

            /**
             * Sets the value of {@link CustomTransformationConfigurationProperty#getIntermediateStorage}
             * @param intermediateStorage An S3 bucket path for input and output objects. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intermediateStorage(software.amazon.awscdk.services.bedrock.CfnDataSource.IntermediateStorageProperty intermediateStorage) {
                this.intermediateStorage = intermediateStorage;
                return this;
            }

            /**
             * Sets the value of {@link CustomTransformationConfigurationProperty#getTransformations}
             * @param transformations A Lambda function that processes documents. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transformations(software.amazon.awscdk.IResolvable transformations) {
                this.transformations = transformations;
                return this;
            }

            /**
             * Sets the value of {@link CustomTransformationConfigurationProperty#getTransformations}
             * @param transformations A Lambda function that processes documents. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transformations(java.util.List<? extends java.lang.Object> transformations) {
                this.transformations = transformations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomTransformationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomTransformationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomTransformationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomTransformationConfigurationProperty {
            private final java.lang.Object intermediateStorage;
            private final java.lang.Object transformations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.intermediateStorage = software.amazon.jsii.Kernel.get(this, "intermediateStorage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.transformations = software.amazon.jsii.Kernel.get(this, "transformations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.intermediateStorage = java.util.Objects.requireNonNull(builder.intermediateStorage, "intermediateStorage is required");
                this.transformations = java.util.Objects.requireNonNull(builder.transformations, "transformations is required");
            }

            @Override
            public final java.lang.Object getIntermediateStorage() {
                return this.intermediateStorage;
            }

            @Override
            public final java.lang.Object getTransformations() {
                return this.transformations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("intermediateStorage", om.valueToTree(this.getIntermediateStorage()));
                data.set("transformations", om.valueToTree(this.getTransformations()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.CustomTransformationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomTransformationConfigurationProperty.Jsii$Proxy that = (CustomTransformationConfigurationProperty.Jsii$Proxy) o;

                if (!intermediateStorage.equals(that.intermediateStorage)) return false;
                return this.transformations.equals(that.transformations);
            }

            @Override
            public final int hashCode() {
                int result = this.intermediateStorage.hashCode();
                result = 31 * result + (this.transformations.hashCode());
                return result;
            }
        }
    }
    /**
     * The connection configuration for the data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * DataSourceConfigurationProperty dataSourceConfigurationProperty = DataSourceConfigurationProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .confluenceConfiguration(ConfluenceDataSourceConfigurationProperty.builder()
     *                 .sourceConfiguration(ConfluenceSourceConfigurationProperty.builder()
     *                         .authType("authType")
     *                         .credentialsSecretArn("credentialsSecretArn")
     *                         .hostType("hostType")
     *                         .hostUrl("hostUrl")
     *                         .build())
     *                 // the properties below are optional
     *                 .crawlerConfiguration(ConfluenceCrawlerConfigurationProperty.builder()
     *                         .filterConfiguration(CrawlFilterConfigurationProperty.builder()
     *                                 .type("type")
     *                                 // the properties below are optional
     *                                 .patternObjectFilter(PatternObjectFilterConfigurationProperty.builder()
     *                                         .filters(List.of(PatternObjectFilterProperty.builder()
     *                                                 .objectType("objectType")
     *                                                 // the properties below are optional
     *                                                 .exclusionFilters(List.of("exclusionFilters"))
     *                                                 .inclusionFilters(List.of("inclusionFilters"))
     *                                                 .build()))
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .s3Configuration(S3DataSourceConfigurationProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 // the properties below are optional
     *                 .bucketOwnerAccountId("bucketOwnerAccountId")
     *                 .inclusionPrefixes(List.of("inclusionPrefixes"))
     *                 .build())
     *         .salesforceConfiguration(SalesforceDataSourceConfigurationProperty.builder()
     *                 .sourceConfiguration(SalesforceSourceConfigurationProperty.builder()
     *                         .authType("authType")
     *                         .credentialsSecretArn("credentialsSecretArn")
     *                         .hostUrl("hostUrl")
     *                         .build())
     *                 // the properties below are optional
     *                 .crawlerConfiguration(SalesforceCrawlerConfigurationProperty.builder()
     *                         .filterConfiguration(CrawlFilterConfigurationProperty.builder()
     *                                 .type("type")
     *                                 // the properties below are optional
     *                                 .patternObjectFilter(PatternObjectFilterConfigurationProperty.builder()
     *                                         .filters(List.of(PatternObjectFilterProperty.builder()
     *                                                 .objectType("objectType")
     *                                                 // the properties below are optional
     *                                                 .exclusionFilters(List.of("exclusionFilters"))
     *                                                 .inclusionFilters(List.of("inclusionFilters"))
     *                                                 .build()))
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .sharePointConfiguration(SharePointDataSourceConfigurationProperty.builder()
     *                 .sourceConfiguration(SharePointSourceConfigurationProperty.builder()
     *                         .authType("authType")
     *                         .credentialsSecretArn("credentialsSecretArn")
     *                         .domain("domain")
     *                         .hostType("hostType")
     *                         .siteUrls(List.of("siteUrls"))
     *                         // the properties below are optional
     *                         .tenantId("tenantId")
     *                         .build())
     *                 // the properties below are optional
     *                 .crawlerConfiguration(SharePointCrawlerConfigurationProperty.builder()
     *                         .filterConfiguration(CrawlFilterConfigurationProperty.builder()
     *                                 .type("type")
     *                                 // the properties below are optional
     *                                 .patternObjectFilter(PatternObjectFilterConfigurationProperty.builder()
     *                                         .filters(List.of(PatternObjectFilterProperty.builder()
     *                                                 .objectType("objectType")
     *                                                 // the properties below are optional
     *                                                 .exclusionFilters(List.of("exclusionFilters"))
     *                                                 .inclusionFilters(List.of("inclusionFilters"))
     *                                                 .build()))
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .webConfiguration(WebDataSourceConfigurationProperty.builder()
     *                 .sourceConfiguration(WebSourceConfigurationProperty.builder()
     *                         .urlConfiguration(UrlConfigurationProperty.builder()
     *                                 .seedUrls(List.of(SeedUrlProperty.builder()
     *                                         .url("url")
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .crawlerConfiguration(WebCrawlerConfigurationProperty.builder()
     *                         .crawlerLimits(WebCrawlerLimitsProperty.builder()
     *                                 .rateLimit(123)
     *                                 .build())
     *                         .exclusionFilters(List.of("exclusionFilters"))
     *                         .inclusionFilters(List.of("inclusionFilters"))
     *                         .scope("scope")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-datasourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-datasourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.DataSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-datasourceconfiguration.html#cfn-bedrock-datasource-datasourceconfiguration-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-datasourceconfiguration.html#cfn-bedrock-datasource-datasourceconfiguration-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The configuration information to connect to Confluence as your data source.
         * <p>
         * <blockquote>
         * <p>
         * Confluence data source connector is in preview release and is subject to change.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-datasourceconfiguration.html#cfn-bedrock-datasource-datasourceconfiguration-confluenceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-datasourceconfiguration.html#cfn-bedrock-datasource-datasourceconfiguration-confluenceconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfluenceConfiguration() {
            return null;
        }

        /**
         * The configuration information to connect to Amazon S3 as your data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-datasourceconfiguration.html#cfn-bedrock-datasource-datasourceconfiguration-s3configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-datasourceconfiguration.html#cfn-bedrock-datasource-datasourceconfiguration-s3configuration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Configuration() {
            return null;
        }

        /**
         * The configuration information to connect to Salesforce as your data source.
         * <p>
         * <blockquote>
         * <p>
         * Salesforce data source connector is in preview release and is subject to change.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-datasourceconfiguration.html#cfn-bedrock-datasource-datasourceconfiguration-salesforceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-datasourceconfiguration.html#cfn-bedrock-datasource-datasourceconfiguration-salesforceconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSalesforceConfiguration() {
            return null;
        }

        /**
         * The configuration information to connect to SharePoint as your data source.
         * <p>
         * <blockquote>
         * <p>
         * SharePoint data source connector is in preview release and is subject to change.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-datasourceconfiguration.html#cfn-bedrock-datasource-datasourceconfiguration-sharepointconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-datasourceconfiguration.html#cfn-bedrock-datasource-datasourceconfiguration-sharepointconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSharePointConfiguration() {
            return null;
        }

        /**
         * The configuration of web URLs to crawl for your data source. You should be authorized to crawl the URLs.
         * <p>
         * <blockquote>
         * <p>
         * Crawling web URLs as your data source is in preview release and is subject to change.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-datasourceconfiguration.html#cfn-bedrock-datasource-datasourceconfiguration-webconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-datasourceconfiguration.html#cfn-bedrock-datasource-datasourceconfiguration-webconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWebConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSourceConfigurationProperty> {
            java.lang.String type;
            java.lang.Object confluenceConfiguration;
            java.lang.Object s3Configuration;
            java.lang.Object salesforceConfiguration;
            java.lang.Object sharePointConfiguration;
            java.lang.Object webConfiguration;

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getType}
             * @param type The type of data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getConfluenceConfiguration}
             * @param confluenceConfiguration The configuration information to connect to Confluence as your data source.
             *                                <blockquote>
             *                                <p>
             *                                Confluence data source connector is in preview release and is subject to change.
             *                                <p>
             *                                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder confluenceConfiguration(software.amazon.awscdk.IResolvable confluenceConfiguration) {
                this.confluenceConfiguration = confluenceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getConfluenceConfiguration}
             * @param confluenceConfiguration The configuration information to connect to Confluence as your data source.
             *                                <blockquote>
             *                                <p>
             *                                Confluence data source connector is in preview release and is subject to change.
             *                                <p>
             *                                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder confluenceConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.ConfluenceDataSourceConfigurationProperty confluenceConfiguration) {
                this.confluenceConfiguration = confluenceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getS3Configuration}
             * @param s3Configuration The configuration information to connect to Amazon S3 as your data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getS3Configuration}
             * @param s3Configuration The configuration information to connect to Amazon S3 as your data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.services.bedrock.CfnDataSource.S3DataSourceConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getSalesforceConfiguration}
             * @param salesforceConfiguration The configuration information to connect to Salesforce as your data source.
             *                                <blockquote>
             *                                <p>
             *                                Salesforce data source connector is in preview release and is subject to change.
             *                                <p>
             *                                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforceConfiguration(software.amazon.awscdk.IResolvable salesforceConfiguration) {
                this.salesforceConfiguration = salesforceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getSalesforceConfiguration}
             * @param salesforceConfiguration The configuration information to connect to Salesforce as your data source.
             *                                <blockquote>
             *                                <p>
             *                                Salesforce data source connector is in preview release and is subject to change.
             *                                <p>
             *                                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforceConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.SalesforceDataSourceConfigurationProperty salesforceConfiguration) {
                this.salesforceConfiguration = salesforceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getSharePointConfiguration}
             * @param sharePointConfiguration The configuration information to connect to SharePoint as your data source.
             *                                <blockquote>
             *                                <p>
             *                                SharePoint data source connector is in preview release and is subject to change.
             *                                <p>
             *                                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sharePointConfiguration(software.amazon.awscdk.IResolvable sharePointConfiguration) {
                this.sharePointConfiguration = sharePointConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getSharePointConfiguration}
             * @param sharePointConfiguration The configuration information to connect to SharePoint as your data source.
             *                                <blockquote>
             *                                <p>
             *                                SharePoint data source connector is in preview release and is subject to change.
             *                                <p>
             *                                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sharePointConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.SharePointDataSourceConfigurationProperty sharePointConfiguration) {
                this.sharePointConfiguration = sharePointConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getWebConfiguration}
             * @param webConfiguration The configuration of web URLs to crawl for your data source. You should be authorized to crawl the URLs.
             *                         <blockquote>
             *                         <p>
             *                         Crawling web URLs as your data source is in preview release and is subject to change.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder webConfiguration(software.amazon.awscdk.IResolvable webConfiguration) {
                this.webConfiguration = webConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getWebConfiguration}
             * @param webConfiguration The configuration of web URLs to crawl for your data source. You should be authorized to crawl the URLs.
             *                         <blockquote>
             *                         <p>
             *                         Crawling web URLs as your data source is in preview release and is subject to change.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder webConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.WebDataSourceConfigurationProperty webConfiguration) {
                this.webConfiguration = webConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSourceConfigurationProperty {
            private final java.lang.String type;
            private final java.lang.Object confluenceConfiguration;
            private final java.lang.Object s3Configuration;
            private final java.lang.Object salesforceConfiguration;
            private final java.lang.Object sharePointConfiguration;
            private final java.lang.Object webConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.confluenceConfiguration = software.amazon.jsii.Kernel.get(this, "confluenceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3Configuration = software.amazon.jsii.Kernel.get(this, "s3Configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.salesforceConfiguration = software.amazon.jsii.Kernel.get(this, "salesforceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sharePointConfiguration = software.amazon.jsii.Kernel.get(this, "sharePointConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.webConfiguration = software.amazon.jsii.Kernel.get(this, "webConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.confluenceConfiguration = builder.confluenceConfiguration;
                this.s3Configuration = builder.s3Configuration;
                this.salesforceConfiguration = builder.salesforceConfiguration;
                this.sharePointConfiguration = builder.sharePointConfiguration;
                this.webConfiguration = builder.webConfiguration;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getConfluenceConfiguration() {
                return this.confluenceConfiguration;
            }

            @Override
            public final java.lang.Object getS3Configuration() {
                return this.s3Configuration;
            }

            @Override
            public final java.lang.Object getSalesforceConfiguration() {
                return this.salesforceConfiguration;
            }

            @Override
            public final java.lang.Object getSharePointConfiguration() {
                return this.sharePointConfiguration;
            }

            @Override
            public final java.lang.Object getWebConfiguration() {
                return this.webConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getConfluenceConfiguration() != null) {
                    data.set("confluenceConfiguration", om.valueToTree(this.getConfluenceConfiguration()));
                }
                if (this.getS3Configuration() != null) {
                    data.set("s3Configuration", om.valueToTree(this.getS3Configuration()));
                }
                if (this.getSalesforceConfiguration() != null) {
                    data.set("salesforceConfiguration", om.valueToTree(this.getSalesforceConfiguration()));
                }
                if (this.getSharePointConfiguration() != null) {
                    data.set("sharePointConfiguration", om.valueToTree(this.getSharePointConfiguration()));
                }
                if (this.getWebConfiguration() != null) {
                    data.set("webConfiguration", om.valueToTree(this.getWebConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.DataSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSourceConfigurationProperty.Jsii$Proxy that = (DataSourceConfigurationProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.confluenceConfiguration != null ? !this.confluenceConfiguration.equals(that.confluenceConfiguration) : that.confluenceConfiguration != null) return false;
                if (this.s3Configuration != null ? !this.s3Configuration.equals(that.s3Configuration) : that.s3Configuration != null) return false;
                if (this.salesforceConfiguration != null ? !this.salesforceConfiguration.equals(that.salesforceConfiguration) : that.salesforceConfiguration != null) return false;
                if (this.sharePointConfiguration != null ? !this.sharePointConfiguration.equals(that.sharePointConfiguration) : that.sharePointConfiguration != null) return false;
                return this.webConfiguration != null ? this.webConfiguration.equals(that.webConfiguration) : that.webConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.confluenceConfiguration != null ? this.confluenceConfiguration.hashCode() : 0);
                result = 31 * result + (this.s3Configuration != null ? this.s3Configuration.hashCode() : 0);
                result = 31 * result + (this.salesforceConfiguration != null ? this.salesforceConfiguration.hashCode() : 0);
                result = 31 * result + (this.sharePointConfiguration != null ? this.sharePointConfiguration.hashCode() : 0);
                result = 31 * result + (this.webConfiguration != null ? this.webConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configurations for when you choose fixed-size chunking.
     * <p>
     * If you set the <code>chunkingStrategy</code> as <code>NONE</code> , exclude this field.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * FixedSizeChunkingConfigurationProperty fixedSizeChunkingConfigurationProperty = FixedSizeChunkingConfigurationProperty.builder()
     *         .maxTokens(123)
     *         .overlapPercentage(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-fixedsizechunkingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-fixedsizechunkingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.FixedSizeChunkingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FixedSizeChunkingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FixedSizeChunkingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of tokens to include in a chunk.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-fixedsizechunkingconfiguration.html#cfn-bedrock-datasource-fixedsizechunkingconfiguration-maxtokens">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-fixedsizechunkingconfiguration.html#cfn-bedrock-datasource-fixedsizechunkingconfiguration-maxtokens</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxTokens();

        /**
         * The percentage of overlap between adjacent chunks of a data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-fixedsizechunkingconfiguration.html#cfn-bedrock-datasource-fixedsizechunkingconfiguration-overlappercentage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-fixedsizechunkingconfiguration.html#cfn-bedrock-datasource-fixedsizechunkingconfiguration-overlappercentage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getOverlapPercentage();

        /**
         * @return a {@link Builder} of {@link FixedSizeChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FixedSizeChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FixedSizeChunkingConfigurationProperty> {
            java.lang.Number maxTokens;
            java.lang.Number overlapPercentage;

            /**
             * Sets the value of {@link FixedSizeChunkingConfigurationProperty#getMaxTokens}
             * @param maxTokens The maximum number of tokens to include in a chunk. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTokens(java.lang.Number maxTokens) {
                this.maxTokens = maxTokens;
                return this;
            }

            /**
             * Sets the value of {@link FixedSizeChunkingConfigurationProperty#getOverlapPercentage}
             * @param overlapPercentage The percentage of overlap between adjacent chunks of a data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overlapPercentage(java.lang.Number overlapPercentage) {
                this.overlapPercentage = overlapPercentage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FixedSizeChunkingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FixedSizeChunkingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FixedSizeChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FixedSizeChunkingConfigurationProperty {
            private final java.lang.Number maxTokens;
            private final java.lang.Number overlapPercentage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxTokens = software.amazon.jsii.Kernel.get(this, "maxTokens", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.overlapPercentage = software.amazon.jsii.Kernel.get(this, "overlapPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxTokens = java.util.Objects.requireNonNull(builder.maxTokens, "maxTokens is required");
                this.overlapPercentage = java.util.Objects.requireNonNull(builder.overlapPercentage, "overlapPercentage is required");
            }

            @Override
            public final java.lang.Number getMaxTokens() {
                return this.maxTokens;
            }

            @Override
            public final java.lang.Number getOverlapPercentage() {
                return this.overlapPercentage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxTokens", om.valueToTree(this.getMaxTokens()));
                data.set("overlapPercentage", om.valueToTree(this.getOverlapPercentage()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.FixedSizeChunkingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FixedSizeChunkingConfigurationProperty.Jsii$Proxy that = (FixedSizeChunkingConfigurationProperty.Jsii$Proxy) o;

                if (!maxTokens.equals(that.maxTokens)) return false;
                return this.overlapPercentage.equals(that.overlapPercentage);
            }

            @Override
            public final int hashCode() {
                int result = this.maxTokens.hashCode();
                result = 31 * result + (this.overlapPercentage.hashCode());
                return result;
            }
        }
    }
    /**
     * Settings for hierarchical document chunking for a data source.
     * <p>
     * Hierarchical chunking splits documents into layers of chunks where the first layer contains large chunks, and the second layer contains smaller chunks derived from the first layer.
     * <p>
     * You configure the number of tokens to overlap, or repeat across adjacent chunks. For example, if you set overlap tokens to 60, the last 60 tokens in the first chunk are also included at the beginning of the second chunk. For each layer, you must also configure the maximum number of tokens in a chunk.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * HierarchicalChunkingConfigurationProperty hierarchicalChunkingConfigurationProperty = HierarchicalChunkingConfigurationProperty.builder()
     *         .levelConfigurations(List.of(HierarchicalChunkingLevelConfigurationProperty.builder()
     *                 .maxTokens(123)
     *                 .build()))
     *         .overlapTokens(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-hierarchicalchunkingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-hierarchicalchunkingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.HierarchicalChunkingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(HierarchicalChunkingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HierarchicalChunkingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Token settings for each layer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-hierarchicalchunkingconfiguration.html#cfn-bedrock-datasource-hierarchicalchunkingconfiguration-levelconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-hierarchicalchunkingconfiguration.html#cfn-bedrock-datasource-hierarchicalchunkingconfiguration-levelconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getLevelConfigurations();

        /**
         * The number of tokens to repeat across chunks in the same layer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-hierarchicalchunkingconfiguration.html#cfn-bedrock-datasource-hierarchicalchunkingconfiguration-overlaptokens">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-hierarchicalchunkingconfiguration.html#cfn-bedrock-datasource-hierarchicalchunkingconfiguration-overlaptokens</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getOverlapTokens();

        /**
         * @return a {@link Builder} of {@link HierarchicalChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HierarchicalChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HierarchicalChunkingConfigurationProperty> {
            java.lang.Object levelConfigurations;
            java.lang.Number overlapTokens;

            /**
             * Sets the value of {@link HierarchicalChunkingConfigurationProperty#getLevelConfigurations}
             * @param levelConfigurations Token settings for each layer. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder levelConfigurations(software.amazon.awscdk.IResolvable levelConfigurations) {
                this.levelConfigurations = levelConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link HierarchicalChunkingConfigurationProperty#getLevelConfigurations}
             * @param levelConfigurations Token settings for each layer. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder levelConfigurations(java.util.List<? extends java.lang.Object> levelConfigurations) {
                this.levelConfigurations = levelConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link HierarchicalChunkingConfigurationProperty#getOverlapTokens}
             * @param overlapTokens The number of tokens to repeat across chunks in the same layer. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overlapTokens(java.lang.Number overlapTokens) {
                this.overlapTokens = overlapTokens;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HierarchicalChunkingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HierarchicalChunkingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HierarchicalChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HierarchicalChunkingConfigurationProperty {
            private final java.lang.Object levelConfigurations;
            private final java.lang.Number overlapTokens;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.levelConfigurations = software.amazon.jsii.Kernel.get(this, "levelConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.overlapTokens = software.amazon.jsii.Kernel.get(this, "overlapTokens", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.levelConfigurations = java.util.Objects.requireNonNull(builder.levelConfigurations, "levelConfigurations is required");
                this.overlapTokens = java.util.Objects.requireNonNull(builder.overlapTokens, "overlapTokens is required");
            }

            @Override
            public final java.lang.Object getLevelConfigurations() {
                return this.levelConfigurations;
            }

            @Override
            public final java.lang.Number getOverlapTokens() {
                return this.overlapTokens;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("levelConfigurations", om.valueToTree(this.getLevelConfigurations()));
                data.set("overlapTokens", om.valueToTree(this.getOverlapTokens()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.HierarchicalChunkingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HierarchicalChunkingConfigurationProperty.Jsii$Proxy that = (HierarchicalChunkingConfigurationProperty.Jsii$Proxy) o;

                if (!levelConfigurations.equals(that.levelConfigurations)) return false;
                return this.overlapTokens.equals(that.overlapTokens);
            }

            @Override
            public final int hashCode() {
                int result = this.levelConfigurations.hashCode();
                result = 31 * result + (this.overlapTokens.hashCode());
                return result;
            }
        }
    }
    /**
     * Token settings for a layer in a hierarchical chunking configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * HierarchicalChunkingLevelConfigurationProperty hierarchicalChunkingLevelConfigurationProperty = HierarchicalChunkingLevelConfigurationProperty.builder()
     *         .maxTokens(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-hierarchicalchunkinglevelconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-hierarchicalchunkinglevelconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.HierarchicalChunkingLevelConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(HierarchicalChunkingLevelConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HierarchicalChunkingLevelConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of tokens that a chunk can contain in this layer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-hierarchicalchunkinglevelconfiguration.html#cfn-bedrock-datasource-hierarchicalchunkinglevelconfiguration-maxtokens">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-hierarchicalchunkinglevelconfiguration.html#cfn-bedrock-datasource-hierarchicalchunkinglevelconfiguration-maxtokens</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxTokens();

        /**
         * @return a {@link Builder} of {@link HierarchicalChunkingLevelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HierarchicalChunkingLevelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HierarchicalChunkingLevelConfigurationProperty> {
            java.lang.Number maxTokens;

            /**
             * Sets the value of {@link HierarchicalChunkingLevelConfigurationProperty#getMaxTokens}
             * @param maxTokens The maximum number of tokens that a chunk can contain in this layer. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTokens(java.lang.Number maxTokens) {
                this.maxTokens = maxTokens;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HierarchicalChunkingLevelConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HierarchicalChunkingLevelConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HierarchicalChunkingLevelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HierarchicalChunkingLevelConfigurationProperty {
            private final java.lang.Number maxTokens;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxTokens = software.amazon.jsii.Kernel.get(this, "maxTokens", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxTokens = java.util.Objects.requireNonNull(builder.maxTokens, "maxTokens is required");
            }

            @Override
            public final java.lang.Number getMaxTokens() {
                return this.maxTokens;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxTokens", om.valueToTree(this.getMaxTokens()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.HierarchicalChunkingLevelConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HierarchicalChunkingLevelConfigurationProperty.Jsii$Proxy that = (HierarchicalChunkingLevelConfigurationProperty.Jsii$Proxy) o;

                return this.maxTokens.equals(that.maxTokens);
            }

            @Override
            public final int hashCode() {
                int result = this.maxTokens.hashCode();
                return result;
            }
        }
    }
    /**
     * A location for storing content from data sources temporarily as it is processed by custom components in the ingestion pipeline.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * IntermediateStorageProperty intermediateStorageProperty = IntermediateStorageProperty.builder()
     *         .s3Location(S3LocationProperty.builder()
     *                 .uri("uri")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-intermediatestorage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-intermediatestorage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.IntermediateStorageProperty")
    @software.amazon.jsii.Jsii.Proxy(IntermediateStorageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IntermediateStorageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An S3 bucket path.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-intermediatestorage.html#cfn-bedrock-datasource-intermediatestorage-s3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-intermediatestorage.html#cfn-bedrock-datasource-intermediatestorage-s3location</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Location();

        /**
         * @return a {@link Builder} of {@link IntermediateStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntermediateStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IntermediateStorageProperty> {
            java.lang.Object s3Location;

            /**
             * Sets the value of {@link IntermediateStorageProperty#getS3Location}
             * @param s3Location An S3 bucket path. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Location(software.amazon.awscdk.IResolvable s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            /**
             * Sets the value of {@link IntermediateStorageProperty#getS3Location}
             * @param s3Location An S3 bucket path. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Location(software.amazon.awscdk.services.bedrock.CfnDataSource.S3LocationProperty s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntermediateStorageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IntermediateStorageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IntermediateStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntermediateStorageProperty {
            private final java.lang.Object s3Location;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Location = software.amazon.jsii.Kernel.get(this, "s3Location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Location = java.util.Objects.requireNonNull(builder.s3Location, "s3Location is required");
            }

            @Override
            public final java.lang.Object getS3Location() {
                return this.s3Location;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Location", om.valueToTree(this.getS3Location()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.IntermediateStorageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntermediateStorageProperty.Jsii$Proxy that = (IntermediateStorageProperty.Jsii$Proxy) o;

                return this.s3Location.equals(that.s3Location);
            }

            @Override
            public final int hashCode() {
                int result = this.s3Location.hashCode();
                return result;
            }
        }
    }
    /**
     * Settings for parsing document contents.
     * <p>
     * If you exclude this field, the default parser converts the contents of each document into text before splitting it into chunks. Specify the parsing strategy to use in the <code>parsingStrategy</code> field and include the relevant configuration, or omit it to use the Amazon Bedrock default parser. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-advanced-parsing.html">Parsing options for your data source</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify <code>BEDROCK_DATA_AUTOMATION</code> or <code>BEDROCK_FOUNDATION_MODEL</code> and it fails to parse a file, the Amazon Bedrock default parser will be used instead.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ParsingConfigurationProperty parsingConfigurationProperty = ParsingConfigurationProperty.builder()
     *         .parsingStrategy("parsingStrategy")
     *         // the properties below are optional
     *         .bedrockDataAutomationConfiguration(BedrockDataAutomationConfigurationProperty.builder()
     *                 .parsingModality("parsingModality")
     *                 .build())
     *         .bedrockFoundationModelConfiguration(BedrockFoundationModelConfigurationProperty.builder()
     *                 .modelArn("modelArn")
     *                 // the properties below are optional
     *                 .parsingModality("parsingModality")
     *                 .parsingPrompt(ParsingPromptProperty.builder()
     *                         .parsingPromptText("parsingPromptText")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-parsingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-parsingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.ParsingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ParsingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParsingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The parsing strategy for the data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-parsingconfiguration.html#cfn-bedrock-datasource-parsingconfiguration-parsingstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-parsingconfiguration.html#cfn-bedrock-datasource-parsingconfiguration-parsingstrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getParsingStrategy();

        /**
         * If you specify <code>BEDROCK_DATA_AUTOMATION</code> as the parsing strategy for ingesting your data source, use this object to modify configurations for using the Amazon Bedrock Data Automation parser.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-parsingconfiguration.html#cfn-bedrock-datasource-parsingconfiguration-bedrockdataautomationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-parsingconfiguration.html#cfn-bedrock-datasource-parsingconfiguration-bedrockdataautomationconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBedrockDataAutomationConfiguration() {
            return null;
        }

        /**
         * If you specify <code>BEDROCK_FOUNDATION_MODEL</code> as the parsing strategy for ingesting your data source, use this object to modify configurations for using a foundation model to parse documents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-parsingconfiguration.html#cfn-bedrock-datasource-parsingconfiguration-bedrockfoundationmodelconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-parsingconfiguration.html#cfn-bedrock-datasource-parsingconfiguration-bedrockfoundationmodelconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBedrockFoundationModelConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParsingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParsingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParsingConfigurationProperty> {
            java.lang.String parsingStrategy;
            java.lang.Object bedrockDataAutomationConfiguration;
            java.lang.Object bedrockFoundationModelConfiguration;

            /**
             * Sets the value of {@link ParsingConfigurationProperty#getParsingStrategy}
             * @param parsingStrategy The parsing strategy for the data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parsingStrategy(java.lang.String parsingStrategy) {
                this.parsingStrategy = parsingStrategy;
                return this;
            }

            /**
             * Sets the value of {@link ParsingConfigurationProperty#getBedrockDataAutomationConfiguration}
             * @param bedrockDataAutomationConfiguration If you specify <code>BEDROCK_DATA_AUTOMATION</code> as the parsing strategy for ingesting your data source, use this object to modify configurations for using the Amazon Bedrock Data Automation parser.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bedrockDataAutomationConfiguration(software.amazon.awscdk.IResolvable bedrockDataAutomationConfiguration) {
                this.bedrockDataAutomationConfiguration = bedrockDataAutomationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ParsingConfigurationProperty#getBedrockDataAutomationConfiguration}
             * @param bedrockDataAutomationConfiguration If you specify <code>BEDROCK_DATA_AUTOMATION</code> as the parsing strategy for ingesting your data source, use this object to modify configurations for using the Amazon Bedrock Data Automation parser.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bedrockDataAutomationConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.BedrockDataAutomationConfigurationProperty bedrockDataAutomationConfiguration) {
                this.bedrockDataAutomationConfiguration = bedrockDataAutomationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ParsingConfigurationProperty#getBedrockFoundationModelConfiguration}
             * @param bedrockFoundationModelConfiguration If you specify <code>BEDROCK_FOUNDATION_MODEL</code> as the parsing strategy for ingesting your data source, use this object to modify configurations for using a foundation model to parse documents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bedrockFoundationModelConfiguration(software.amazon.awscdk.IResolvable bedrockFoundationModelConfiguration) {
                this.bedrockFoundationModelConfiguration = bedrockFoundationModelConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ParsingConfigurationProperty#getBedrockFoundationModelConfiguration}
             * @param bedrockFoundationModelConfiguration If you specify <code>BEDROCK_FOUNDATION_MODEL</code> as the parsing strategy for ingesting your data source, use this object to modify configurations for using a foundation model to parse documents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bedrockFoundationModelConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.BedrockFoundationModelConfigurationProperty bedrockFoundationModelConfiguration) {
                this.bedrockFoundationModelConfiguration = bedrockFoundationModelConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParsingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParsingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParsingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParsingConfigurationProperty {
            private final java.lang.String parsingStrategy;
            private final java.lang.Object bedrockDataAutomationConfiguration;
            private final java.lang.Object bedrockFoundationModelConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.parsingStrategy = software.amazon.jsii.Kernel.get(this, "parsingStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bedrockDataAutomationConfiguration = software.amazon.jsii.Kernel.get(this, "bedrockDataAutomationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.bedrockFoundationModelConfiguration = software.amazon.jsii.Kernel.get(this, "bedrockFoundationModelConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.parsingStrategy = java.util.Objects.requireNonNull(builder.parsingStrategy, "parsingStrategy is required");
                this.bedrockDataAutomationConfiguration = builder.bedrockDataAutomationConfiguration;
                this.bedrockFoundationModelConfiguration = builder.bedrockFoundationModelConfiguration;
            }

            @Override
            public final java.lang.String getParsingStrategy() {
                return this.parsingStrategy;
            }

            @Override
            public final java.lang.Object getBedrockDataAutomationConfiguration() {
                return this.bedrockDataAutomationConfiguration;
            }

            @Override
            public final java.lang.Object getBedrockFoundationModelConfiguration() {
                return this.bedrockFoundationModelConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("parsingStrategy", om.valueToTree(this.getParsingStrategy()));
                if (this.getBedrockDataAutomationConfiguration() != null) {
                    data.set("bedrockDataAutomationConfiguration", om.valueToTree(this.getBedrockDataAutomationConfiguration()));
                }
                if (this.getBedrockFoundationModelConfiguration() != null) {
                    data.set("bedrockFoundationModelConfiguration", om.valueToTree(this.getBedrockFoundationModelConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.ParsingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParsingConfigurationProperty.Jsii$Proxy that = (ParsingConfigurationProperty.Jsii$Proxy) o;

                if (!parsingStrategy.equals(that.parsingStrategy)) return false;
                if (this.bedrockDataAutomationConfiguration != null ? !this.bedrockDataAutomationConfiguration.equals(that.bedrockDataAutomationConfiguration) : that.bedrockDataAutomationConfiguration != null) return false;
                return this.bedrockFoundationModelConfiguration != null ? this.bedrockFoundationModelConfiguration.equals(that.bedrockFoundationModelConfiguration) : that.bedrockFoundationModelConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.parsingStrategy.hashCode();
                result = 31 * result + (this.bedrockDataAutomationConfiguration != null ? this.bedrockDataAutomationConfiguration.hashCode() : 0);
                result = 31 * result + (this.bedrockFoundationModelConfiguration != null ? this.bedrockFoundationModelConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Instructions for interpreting the contents of a document.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ParsingPromptProperty parsingPromptProperty = ParsingPromptProperty.builder()
     *         .parsingPromptText("parsingPromptText")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-parsingprompt.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-parsingprompt.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.ParsingPromptProperty")
    @software.amazon.jsii.Jsii.Proxy(ParsingPromptProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParsingPromptProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Instructions for interpreting the contents of a document.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-parsingprompt.html#cfn-bedrock-datasource-parsingprompt-parsingprompttext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-parsingprompt.html#cfn-bedrock-datasource-parsingprompt-parsingprompttext</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getParsingPromptText();

        /**
         * @return a {@link Builder} of {@link ParsingPromptProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParsingPromptProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParsingPromptProperty> {
            java.lang.String parsingPromptText;

            /**
             * Sets the value of {@link ParsingPromptProperty#getParsingPromptText}
             * @param parsingPromptText Instructions for interpreting the contents of a document. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parsingPromptText(java.lang.String parsingPromptText) {
                this.parsingPromptText = parsingPromptText;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParsingPromptProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParsingPromptProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParsingPromptProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParsingPromptProperty {
            private final java.lang.String parsingPromptText;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.parsingPromptText = software.amazon.jsii.Kernel.get(this, "parsingPromptText", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.parsingPromptText = java.util.Objects.requireNonNull(builder.parsingPromptText, "parsingPromptText is required");
            }

            @Override
            public final java.lang.String getParsingPromptText() {
                return this.parsingPromptText;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("parsingPromptText", om.valueToTree(this.getParsingPromptText()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.ParsingPromptProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParsingPromptProperty.Jsii$Proxy that = (ParsingPromptProperty.Jsii$Proxy) o;

                return this.parsingPromptText.equals(that.parsingPromptText);
            }

            @Override
            public final int hashCode() {
                int result = this.parsingPromptText.hashCode();
                return result;
            }
        }
    }
    /**
     * The configuration of filtering certain objects or content types of the data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PatternObjectFilterConfigurationProperty patternObjectFilterConfigurationProperty = PatternObjectFilterConfigurationProperty.builder()
     *         .filters(List.of(PatternObjectFilterProperty.builder()
     *                 .objectType("objectType")
     *                 // the properties below are optional
     *                 .exclusionFilters(List.of("exclusionFilters"))
     *                 .inclusionFilters(List.of("inclusionFilters"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-patternobjectfilterconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-patternobjectfilterconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.PatternObjectFilterConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PatternObjectFilterConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PatternObjectFilterConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration of specific filters applied to your data source content.
         * <p>
         * You can filter out or include certain content.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-patternobjectfilterconfiguration.html#cfn-bedrock-datasource-patternobjectfilterconfiguration-filters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-patternobjectfilterconfiguration.html#cfn-bedrock-datasource-patternobjectfilterconfiguration-filters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFilters();

        /**
         * @return a {@link Builder} of {@link PatternObjectFilterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PatternObjectFilterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PatternObjectFilterConfigurationProperty> {
            java.lang.Object filters;

            /**
             * Sets the value of {@link PatternObjectFilterConfigurationProperty#getFilters}
             * @param filters The configuration of specific filters applied to your data source content. This parameter is required.
             *                You can filter out or include certain content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filters(software.amazon.awscdk.IResolvable filters) {
                this.filters = filters;
                return this;
            }

            /**
             * Sets the value of {@link PatternObjectFilterConfigurationProperty#getFilters}
             * @param filters The configuration of specific filters applied to your data source content. This parameter is required.
             *                You can filter out or include certain content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filters(java.util.List<? extends java.lang.Object> filters) {
                this.filters = filters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PatternObjectFilterConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PatternObjectFilterConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PatternObjectFilterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PatternObjectFilterConfigurationProperty {
            private final java.lang.Object filters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.filters = software.amazon.jsii.Kernel.get(this, "filters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.filters = java.util.Objects.requireNonNull(builder.filters, "filters is required");
            }

            @Override
            public final java.lang.Object getFilters() {
                return this.filters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("filters", om.valueToTree(this.getFilters()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.PatternObjectFilterConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PatternObjectFilterConfigurationProperty.Jsii$Proxy that = (PatternObjectFilterConfigurationProperty.Jsii$Proxy) o;

                return this.filters.equals(that.filters);
            }

            @Override
            public final int hashCode() {
                int result = this.filters.hashCode();
                return result;
            }
        }
    }
    /**
     * The specific filters applied to your data source content.
     * <p>
     * You can filter out or include certain content.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PatternObjectFilterProperty patternObjectFilterProperty = PatternObjectFilterProperty.builder()
     *         .objectType("objectType")
     *         // the properties below are optional
     *         .exclusionFilters(List.of("exclusionFilters"))
     *         .inclusionFilters(List.of("inclusionFilters"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-patternobjectfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-patternobjectfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.PatternObjectFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(PatternObjectFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PatternObjectFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The supported object type or content type of the data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-patternobjectfilter.html#cfn-bedrock-datasource-patternobjectfilter-objecttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-patternobjectfilter.html#cfn-bedrock-datasource-patternobjectfilter-objecttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObjectType();

        /**
         * A list of one or more exclusion regular expression patterns to exclude certain object types that adhere to the pattern.
         * <p>
         * If you specify an inclusion and exclusion filter/pattern and both match a document, the exclusion filter takes precedence and the document isn’t crawled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-patternobjectfilter.html#cfn-bedrock-datasource-patternobjectfilter-exclusionfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-patternobjectfilter.html#cfn-bedrock-datasource-patternobjectfilter-exclusionfilters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExclusionFilters() {
            return null;
        }

        /**
         * A list of one or more inclusion regular expression patterns to include certain object types that adhere to the pattern.
         * <p>
         * If you specify an inclusion and exclusion filter/pattern and both match a document, the exclusion filter takes precedence and the document isn’t crawled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-patternobjectfilter.html#cfn-bedrock-datasource-patternobjectfilter-inclusionfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-patternobjectfilter.html#cfn-bedrock-datasource-patternobjectfilter-inclusionfilters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInclusionFilters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PatternObjectFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PatternObjectFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PatternObjectFilterProperty> {
            java.lang.String objectType;
            java.util.List<java.lang.String> exclusionFilters;
            java.util.List<java.lang.String> inclusionFilters;

            /**
             * Sets the value of {@link PatternObjectFilterProperty#getObjectType}
             * @param objectType The supported object type or content type of the data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectType(java.lang.String objectType) {
                this.objectType = objectType;
                return this;
            }

            /**
             * Sets the value of {@link PatternObjectFilterProperty#getExclusionFilters}
             * @param exclusionFilters A list of one or more exclusion regular expression patterns to exclude certain object types that adhere to the pattern.
             *                         If you specify an inclusion and exclusion filter/pattern and both match a document, the exclusion filter takes precedence and the document isn’t crawled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclusionFilters(java.util.List<java.lang.String> exclusionFilters) {
                this.exclusionFilters = exclusionFilters;
                return this;
            }

            /**
             * Sets the value of {@link PatternObjectFilterProperty#getInclusionFilters}
             * @param inclusionFilters A list of one or more inclusion regular expression patterns to include certain object types that adhere to the pattern.
             *                         If you specify an inclusion and exclusion filter/pattern and both match a document, the exclusion filter takes precedence and the document isn’t crawled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inclusionFilters(java.util.List<java.lang.String> inclusionFilters) {
                this.inclusionFilters = inclusionFilters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PatternObjectFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PatternObjectFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PatternObjectFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PatternObjectFilterProperty {
            private final java.lang.String objectType;
            private final java.util.List<java.lang.String> exclusionFilters;
            private final java.util.List<java.lang.String> inclusionFilters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.objectType = software.amazon.jsii.Kernel.get(this, "objectType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.exclusionFilters = software.amazon.jsii.Kernel.get(this, "exclusionFilters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.inclusionFilters = software.amazon.jsii.Kernel.get(this, "inclusionFilters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.objectType = java.util.Objects.requireNonNull(builder.objectType, "objectType is required");
                this.exclusionFilters = builder.exclusionFilters;
                this.inclusionFilters = builder.inclusionFilters;
            }

            @Override
            public final java.lang.String getObjectType() {
                return this.objectType;
            }

            @Override
            public final java.util.List<java.lang.String> getExclusionFilters() {
                return this.exclusionFilters;
            }

            @Override
            public final java.util.List<java.lang.String> getInclusionFilters() {
                return this.inclusionFilters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("objectType", om.valueToTree(this.getObjectType()));
                if (this.getExclusionFilters() != null) {
                    data.set("exclusionFilters", om.valueToTree(this.getExclusionFilters()));
                }
                if (this.getInclusionFilters() != null) {
                    data.set("inclusionFilters", om.valueToTree(this.getInclusionFilters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.PatternObjectFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PatternObjectFilterProperty.Jsii$Proxy that = (PatternObjectFilterProperty.Jsii$Proxy) o;

                if (!objectType.equals(that.objectType)) return false;
                if (this.exclusionFilters != null ? !this.exclusionFilters.equals(that.exclusionFilters) : that.exclusionFilters != null) return false;
                return this.inclusionFilters != null ? this.inclusionFilters.equals(that.inclusionFilters) : that.inclusionFilters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.objectType.hashCode();
                result = 31 * result + (this.exclusionFilters != null ? this.exclusionFilters.hashCode() : 0);
                result = 31 * result + (this.inclusionFilters != null ? this.inclusionFilters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration information to connect to Amazon S3 as your data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * S3DataSourceConfigurationProperty s3DataSourceConfigurationProperty = S3DataSourceConfigurationProperty.builder()
     *         .bucketArn("bucketArn")
     *         // the properties below are optional
     *         .bucketOwnerAccountId("bucketOwnerAccountId")
     *         .inclusionPrefixes(List.of("inclusionPrefixes"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-s3datasourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-s3datasourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.S3DataSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3DataSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3DataSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the S3 bucket that contains your data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-s3datasourceconfiguration.html#cfn-bedrock-datasource-s3datasourceconfiguration-bucketarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-s3datasourceconfiguration.html#cfn-bedrock-datasource-s3datasourceconfiguration-bucketarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketArn();

        /**
         * The account ID for the owner of the S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-s3datasourceconfiguration.html#cfn-bedrock-datasource-s3datasourceconfiguration-bucketowneraccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-s3datasourceconfiguration.html#cfn-bedrock-datasource-s3datasourceconfiguration-bucketowneraccountid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketOwnerAccountId() {
            return null;
        }

        /**
         * A list of S3 prefixes to include certain files or content.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html">Organizing objects using prefixes</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-s3datasourceconfiguration.html#cfn-bedrock-datasource-s3datasourceconfiguration-inclusionprefixes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-s3datasourceconfiguration.html#cfn-bedrock-datasource-s3datasourceconfiguration-inclusionprefixes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInclusionPrefixes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3DataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3DataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3DataSourceConfigurationProperty> {
            java.lang.String bucketArn;
            java.lang.String bucketOwnerAccountId;
            java.util.List<java.lang.String> inclusionPrefixes;

            /**
             * Sets the value of {@link S3DataSourceConfigurationProperty#getBucketArn}
             * @param bucketArn The Amazon Resource Name (ARN) of the S3 bucket that contains your data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketArn(java.lang.String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            /**
             * Sets the value of {@link S3DataSourceConfigurationProperty#getBucketOwnerAccountId}
             * @param bucketOwnerAccountId The account ID for the owner of the S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketOwnerAccountId(java.lang.String bucketOwnerAccountId) {
                this.bucketOwnerAccountId = bucketOwnerAccountId;
                return this;
            }

            /**
             * Sets the value of {@link S3DataSourceConfigurationProperty#getInclusionPrefixes}
             * @param inclusionPrefixes A list of S3 prefixes to include certain files or content.
             *                          For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html">Organizing objects using prefixes</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inclusionPrefixes(java.util.List<java.lang.String> inclusionPrefixes) {
                this.inclusionPrefixes = inclusionPrefixes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3DataSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3DataSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3DataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3DataSourceConfigurationProperty {
            private final java.lang.String bucketArn;
            private final java.lang.String bucketOwnerAccountId;
            private final java.util.List<java.lang.String> inclusionPrefixes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketArn = software.amazon.jsii.Kernel.get(this, "bucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketOwnerAccountId = software.amazon.jsii.Kernel.get(this, "bucketOwnerAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inclusionPrefixes = software.amazon.jsii.Kernel.get(this, "inclusionPrefixes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketArn = java.util.Objects.requireNonNull(builder.bucketArn, "bucketArn is required");
                this.bucketOwnerAccountId = builder.bucketOwnerAccountId;
                this.inclusionPrefixes = builder.inclusionPrefixes;
            }

            @Override
            public final java.lang.String getBucketArn() {
                return this.bucketArn;
            }

            @Override
            public final java.lang.String getBucketOwnerAccountId() {
                return this.bucketOwnerAccountId;
            }

            @Override
            public final java.util.List<java.lang.String> getInclusionPrefixes() {
                return this.inclusionPrefixes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketArn", om.valueToTree(this.getBucketArn()));
                if (this.getBucketOwnerAccountId() != null) {
                    data.set("bucketOwnerAccountId", om.valueToTree(this.getBucketOwnerAccountId()));
                }
                if (this.getInclusionPrefixes() != null) {
                    data.set("inclusionPrefixes", om.valueToTree(this.getInclusionPrefixes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.S3DataSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3DataSourceConfigurationProperty.Jsii$Proxy that = (S3DataSourceConfigurationProperty.Jsii$Proxy) o;

                if (!bucketArn.equals(that.bucketArn)) return false;
                if (this.bucketOwnerAccountId != null ? !this.bucketOwnerAccountId.equals(that.bucketOwnerAccountId) : that.bucketOwnerAccountId != null) return false;
                return this.inclusionPrefixes != null ? this.inclusionPrefixes.equals(that.inclusionPrefixes) : that.inclusionPrefixes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketArn.hashCode();
                result = 31 * result + (this.bucketOwnerAccountId != null ? this.bucketOwnerAccountId.hashCode() : 0);
                result = 31 * result + (this.inclusionPrefixes != null ? this.inclusionPrefixes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A storage location in an S3 bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * S3LocationProperty s3LocationProperty = S3LocationProperty.builder()
     *         .uri("uri")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-s3location.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-s3location.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.S3LocationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3LocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object URI starting with <code>s3://</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-s3location.html#cfn-bedrock-datasource-s3location-uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-s3location.html#cfn-bedrock-datasource-s3location-uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUri();

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3LocationProperty> {
            java.lang.String uri;

            /**
             * Sets the value of {@link S3LocationProperty#getUri}
             * @param uri An object URI starting with <code>s3://</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uri(java.lang.String uri) {
                this.uri = uri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3LocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LocationProperty {
            private final java.lang.String uri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.uri = software.amazon.jsii.Kernel.get(this, "uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.uri = java.util.Objects.requireNonNull(builder.uri, "uri is required");
            }

            @Override
            public final java.lang.String getUri() {
                return this.uri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("uri", om.valueToTree(this.getUri()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.S3LocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LocationProperty.Jsii$Proxy that = (S3LocationProperty.Jsii$Proxy) o;

                return this.uri.equals(that.uri);
            }

            @Override
            public final int hashCode() {
                int result = this.uri.hashCode();
                return result;
            }
        }
    }
    /**
     * The configuration of the Salesforce content.
     * <p>
     * For example, configuring specific types of Salesforce content.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * SalesforceCrawlerConfigurationProperty salesforceCrawlerConfigurationProperty = SalesforceCrawlerConfigurationProperty.builder()
     *         .filterConfiguration(CrawlFilterConfigurationProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .patternObjectFilter(PatternObjectFilterConfigurationProperty.builder()
     *                         .filters(List.of(PatternObjectFilterProperty.builder()
     *                                 .objectType("objectType")
     *                                 // the properties below are optional
     *                                 .exclusionFilters(List.of("exclusionFilters"))
     *                                 .inclusionFilters(List.of("inclusionFilters"))
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-salesforcecrawlerconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-salesforcecrawlerconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.SalesforceCrawlerConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SalesforceCrawlerConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SalesforceCrawlerConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration of filtering the Salesforce content.
         * <p>
         * For example, configuring regular expression patterns to include or exclude certain content.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-salesforcecrawlerconfiguration.html#cfn-bedrock-datasource-salesforcecrawlerconfiguration-filterconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-salesforcecrawlerconfiguration.html#cfn-bedrock-datasource-salesforcecrawlerconfiguration-filterconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilterConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SalesforceCrawlerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SalesforceCrawlerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SalesforceCrawlerConfigurationProperty> {
            java.lang.Object filterConfiguration;

            /**
             * Sets the value of {@link SalesforceCrawlerConfigurationProperty#getFilterConfiguration}
             * @param filterConfiguration The configuration of filtering the Salesforce content.
             *                            For example, configuring regular expression patterns to include or exclude certain content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterConfiguration(software.amazon.awscdk.IResolvable filterConfiguration) {
                this.filterConfiguration = filterConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceCrawlerConfigurationProperty#getFilterConfiguration}
             * @param filterConfiguration The configuration of filtering the Salesforce content.
             *                            For example, configuring regular expression patterns to include or exclude certain content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.CrawlFilterConfigurationProperty filterConfiguration) {
                this.filterConfiguration = filterConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SalesforceCrawlerConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SalesforceCrawlerConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SalesforceCrawlerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SalesforceCrawlerConfigurationProperty {
            private final java.lang.Object filterConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.filterConfiguration = software.amazon.jsii.Kernel.get(this, "filterConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.filterConfiguration = builder.filterConfiguration;
            }

            @Override
            public final java.lang.Object getFilterConfiguration() {
                return this.filterConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFilterConfiguration() != null) {
                    data.set("filterConfiguration", om.valueToTree(this.getFilterConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.SalesforceCrawlerConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SalesforceCrawlerConfigurationProperty.Jsii$Proxy that = (SalesforceCrawlerConfigurationProperty.Jsii$Proxy) o;

                return this.filterConfiguration != null ? this.filterConfiguration.equals(that.filterConfiguration) : that.filterConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.filterConfiguration != null ? this.filterConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The configuration information to connect to Salesforce as your data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * SalesforceDataSourceConfigurationProperty salesforceDataSourceConfigurationProperty = SalesforceDataSourceConfigurationProperty.builder()
     *         .sourceConfiguration(SalesforceSourceConfigurationProperty.builder()
     *                 .authType("authType")
     *                 .credentialsSecretArn("credentialsSecretArn")
     *                 .hostUrl("hostUrl")
     *                 .build())
     *         // the properties below are optional
     *         .crawlerConfiguration(SalesforceCrawlerConfigurationProperty.builder()
     *                 .filterConfiguration(CrawlFilterConfigurationProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .patternObjectFilter(PatternObjectFilterConfigurationProperty.builder()
     *                                 .filters(List.of(PatternObjectFilterProperty.builder()
     *                                         .objectType("objectType")
     *                                         // the properties below are optional
     *                                         .exclusionFilters(List.of("exclusionFilters"))
     *                                         .inclusionFilters(List.of("inclusionFilters"))
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-salesforcedatasourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-salesforcedatasourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.SalesforceDataSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SalesforceDataSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SalesforceDataSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The endpoint information to connect to your Salesforce data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-salesforcedatasourceconfiguration.html#cfn-bedrock-datasource-salesforcedatasourceconfiguration-sourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-salesforcedatasourceconfiguration.html#cfn-bedrock-datasource-salesforcedatasourceconfiguration-sourceconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSourceConfiguration();

        /**
         * The configuration of the Salesforce content.
         * <p>
         * For example, configuring specific types of Salesforce content.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-salesforcedatasourceconfiguration.html#cfn-bedrock-datasource-salesforcedatasourceconfiguration-crawlerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-salesforcedatasourceconfiguration.html#cfn-bedrock-datasource-salesforcedatasourceconfiguration-crawlerconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCrawlerConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SalesforceDataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SalesforceDataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SalesforceDataSourceConfigurationProperty> {
            java.lang.Object sourceConfiguration;
            java.lang.Object crawlerConfiguration;

            /**
             * Sets the value of {@link SalesforceDataSourceConfigurationProperty#getSourceConfiguration}
             * @param sourceConfiguration The endpoint information to connect to your Salesforce data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceConfiguration(software.amazon.awscdk.IResolvable sourceConfiguration) {
                this.sourceConfiguration = sourceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceDataSourceConfigurationProperty#getSourceConfiguration}
             * @param sourceConfiguration The endpoint information to connect to your Salesforce data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.SalesforceSourceConfigurationProperty sourceConfiguration) {
                this.sourceConfiguration = sourceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceDataSourceConfigurationProperty#getCrawlerConfiguration}
             * @param crawlerConfiguration The configuration of the Salesforce content.
             *                             For example, configuring specific types of Salesforce content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlerConfiguration(software.amazon.awscdk.IResolvable crawlerConfiguration) {
                this.crawlerConfiguration = crawlerConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceDataSourceConfigurationProperty#getCrawlerConfiguration}
             * @param crawlerConfiguration The configuration of the Salesforce content.
             *                             For example, configuring specific types of Salesforce content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlerConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.SalesforceCrawlerConfigurationProperty crawlerConfiguration) {
                this.crawlerConfiguration = crawlerConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SalesforceDataSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SalesforceDataSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SalesforceDataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SalesforceDataSourceConfigurationProperty {
            private final java.lang.Object sourceConfiguration;
            private final java.lang.Object crawlerConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceConfiguration = software.amazon.jsii.Kernel.get(this, "sourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.crawlerConfiguration = software.amazon.jsii.Kernel.get(this, "crawlerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceConfiguration = java.util.Objects.requireNonNull(builder.sourceConfiguration, "sourceConfiguration is required");
                this.crawlerConfiguration = builder.crawlerConfiguration;
            }

            @Override
            public final java.lang.Object getSourceConfiguration() {
                return this.sourceConfiguration;
            }

            @Override
            public final java.lang.Object getCrawlerConfiguration() {
                return this.crawlerConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sourceConfiguration", om.valueToTree(this.getSourceConfiguration()));
                if (this.getCrawlerConfiguration() != null) {
                    data.set("crawlerConfiguration", om.valueToTree(this.getCrawlerConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.SalesforceDataSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SalesforceDataSourceConfigurationProperty.Jsii$Proxy that = (SalesforceDataSourceConfigurationProperty.Jsii$Proxy) o;

                if (!sourceConfiguration.equals(that.sourceConfiguration)) return false;
                return this.crawlerConfiguration != null ? this.crawlerConfiguration.equals(that.crawlerConfiguration) : that.crawlerConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourceConfiguration.hashCode();
                result = 31 * result + (this.crawlerConfiguration != null ? this.crawlerConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The endpoint information to connect to your Salesforce data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * SalesforceSourceConfigurationProperty salesforceSourceConfigurationProperty = SalesforceSourceConfigurationProperty.builder()
     *         .authType("authType")
     *         .credentialsSecretArn("credentialsSecretArn")
     *         .hostUrl("hostUrl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-salesforcesourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-salesforcesourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.SalesforceSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SalesforceSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SalesforceSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The supported authentication type to authenticate and connect to your Salesforce instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-salesforcesourceconfiguration.html#cfn-bedrock-datasource-salesforcesourceconfiguration-authtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-salesforcesourceconfiguration.html#cfn-bedrock-datasource-salesforcesourceconfiguration-authtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAuthType();

        /**
         * The Amazon Resource Name of an AWS Secrets Manager secret that stores your authentication credentials for your Salesforce instance URL.
         * <p>
         * For more information on the key-value pairs that must be included in your secret, depending on your authentication type, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/salesforce-data-source-connector.html#configuration-salesforce-connector">Salesforce connection configuration</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-salesforcesourceconfiguration.html#cfn-bedrock-datasource-salesforcesourceconfiguration-credentialssecretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-salesforcesourceconfiguration.html#cfn-bedrock-datasource-salesforcesourceconfiguration-credentialssecretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCredentialsSecretArn();

        /**
         * The Salesforce host URL or instance URL.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-salesforcesourceconfiguration.html#cfn-bedrock-datasource-salesforcesourceconfiguration-hosturl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-salesforcesourceconfiguration.html#cfn-bedrock-datasource-salesforcesourceconfiguration-hosturl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHostUrl();

        /**
         * @return a {@link Builder} of {@link SalesforceSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SalesforceSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SalesforceSourceConfigurationProperty> {
            java.lang.String authType;
            java.lang.String credentialsSecretArn;
            java.lang.String hostUrl;

            /**
             * Sets the value of {@link SalesforceSourceConfigurationProperty#getAuthType}
             * @param authType The supported authentication type to authenticate and connect to your Salesforce instance. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authType(java.lang.String authType) {
                this.authType = authType;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceSourceConfigurationProperty#getCredentialsSecretArn}
             * @param credentialsSecretArn The Amazon Resource Name of an AWS Secrets Manager secret that stores your authentication credentials for your Salesforce instance URL. This parameter is required.
             *                             For more information on the key-value pairs that must be included in your secret, depending on your authentication type, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/salesforce-data-source-connector.html#configuration-salesforce-connector">Salesforce connection configuration</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialsSecretArn(java.lang.String credentialsSecretArn) {
                this.credentialsSecretArn = credentialsSecretArn;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceSourceConfigurationProperty#getHostUrl}
             * @param hostUrl The Salesforce host URL or instance URL. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostUrl(java.lang.String hostUrl) {
                this.hostUrl = hostUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SalesforceSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SalesforceSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SalesforceSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SalesforceSourceConfigurationProperty {
            private final java.lang.String authType;
            private final java.lang.String credentialsSecretArn;
            private final java.lang.String hostUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authType = software.amazon.jsii.Kernel.get(this, "authType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.credentialsSecretArn = software.amazon.jsii.Kernel.get(this, "credentialsSecretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostUrl = software.amazon.jsii.Kernel.get(this, "hostUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authType = java.util.Objects.requireNonNull(builder.authType, "authType is required");
                this.credentialsSecretArn = java.util.Objects.requireNonNull(builder.credentialsSecretArn, "credentialsSecretArn is required");
                this.hostUrl = java.util.Objects.requireNonNull(builder.hostUrl, "hostUrl is required");
            }

            @Override
            public final java.lang.String getAuthType() {
                return this.authType;
            }

            @Override
            public final java.lang.String getCredentialsSecretArn() {
                return this.credentialsSecretArn;
            }

            @Override
            public final java.lang.String getHostUrl() {
                return this.hostUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("authType", om.valueToTree(this.getAuthType()));
                data.set("credentialsSecretArn", om.valueToTree(this.getCredentialsSecretArn()));
                data.set("hostUrl", om.valueToTree(this.getHostUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.SalesforceSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SalesforceSourceConfigurationProperty.Jsii$Proxy that = (SalesforceSourceConfigurationProperty.Jsii$Proxy) o;

                if (!authType.equals(that.authType)) return false;
                if (!credentialsSecretArn.equals(that.credentialsSecretArn)) return false;
                return this.hostUrl.equals(that.hostUrl);
            }

            @Override
            public final int hashCode() {
                int result = this.authType.hashCode();
                result = 31 * result + (this.credentialsSecretArn.hashCode());
                result = 31 * result + (this.hostUrl.hashCode());
                return result;
            }
        }
    }
    /**
     * The seed or starting point URL.
     * <p>
     * You should be authorized to crawl the URL.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * SeedUrlProperty seedUrlProperty = SeedUrlProperty.builder()
     *         .url("url")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-seedurl.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-seedurl.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.SeedUrlProperty")
    @software.amazon.jsii.Jsii.Proxy(SeedUrlProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SeedUrlProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A seed or starting point URL.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-seedurl.html#cfn-bedrock-datasource-seedurl-url">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-seedurl.html#cfn-bedrock-datasource-seedurl-url</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUrl();

        /**
         * @return a {@link Builder} of {@link SeedUrlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SeedUrlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SeedUrlProperty> {
            java.lang.String url;

            /**
             * Sets the value of {@link SeedUrlProperty#getUrl}
             * @param url A seed or starting point URL. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SeedUrlProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SeedUrlProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SeedUrlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SeedUrlProperty {
            private final java.lang.String url;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.url = java.util.Objects.requireNonNull(builder.url, "url is required");
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("url", om.valueToTree(this.getUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.SeedUrlProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SeedUrlProperty.Jsii$Proxy that = (SeedUrlProperty.Jsii$Proxy) o;

                return this.url.equals(that.url);
            }

            @Override
            public final int hashCode() {
                int result = this.url.hashCode();
                return result;
            }
        }
    }
    /**
     * Settings for semantic document chunking for a data source.
     * <p>
     * Semantic chunking splits a document into into smaller documents based on groups of similar content derived from the text with natural language processing.
     * <p>
     * With semantic chunking, each sentence is compared to the next to determine how similar they are. You specify a threshold in the form of a percentile, where adjacent sentences that are less similar than that percentage of sentence pairs are divided into separate chunks. For example, if you set the threshold to 90, then the 10 percent of sentence pairs that are least similar are split. So if you have 101 sentences, 100 sentence pairs are compared, and the 10 with the least similarity are split, creating 11 chunks. These chunks are further split if they exceed the max token size.
     * <p>
     * You must also specify a buffer size, which determines whether sentences are compared in isolation, or within a moving context window that includes the previous and following sentence. For example, if you set the buffer size to <code>1</code> , the embedding for sentence 10 is derived from sentences 9, 10, and 11 combined.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * SemanticChunkingConfigurationProperty semanticChunkingConfigurationProperty = SemanticChunkingConfigurationProperty.builder()
     *         .breakpointPercentileThreshold(123)
     *         .bufferSize(123)
     *         .maxTokens(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-semanticchunkingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-semanticchunkingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.SemanticChunkingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SemanticChunkingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SemanticChunkingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The dissimilarity threshold for splitting chunks.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-semanticchunkingconfiguration.html#cfn-bedrock-datasource-semanticchunkingconfiguration-breakpointpercentilethreshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-semanticchunkingconfiguration.html#cfn-bedrock-datasource-semanticchunkingconfiguration-breakpointpercentilethreshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getBreakpointPercentileThreshold();

        /**
         * The buffer size.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-semanticchunkingconfiguration.html#cfn-bedrock-datasource-semanticchunkingconfiguration-buffersize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-semanticchunkingconfiguration.html#cfn-bedrock-datasource-semanticchunkingconfiguration-buffersize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getBufferSize();

        /**
         * The maximum number of tokens that a chunk can contain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-semanticchunkingconfiguration.html#cfn-bedrock-datasource-semanticchunkingconfiguration-maxtokens">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-semanticchunkingconfiguration.html#cfn-bedrock-datasource-semanticchunkingconfiguration-maxtokens</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxTokens();

        /**
         * @return a {@link Builder} of {@link SemanticChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SemanticChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SemanticChunkingConfigurationProperty> {
            java.lang.Number breakpointPercentileThreshold;
            java.lang.Number bufferSize;
            java.lang.Number maxTokens;

            /**
             * Sets the value of {@link SemanticChunkingConfigurationProperty#getBreakpointPercentileThreshold}
             * @param breakpointPercentileThreshold The dissimilarity threshold for splitting chunks. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder breakpointPercentileThreshold(java.lang.Number breakpointPercentileThreshold) {
                this.breakpointPercentileThreshold = breakpointPercentileThreshold;
                return this;
            }

            /**
             * Sets the value of {@link SemanticChunkingConfigurationProperty#getBufferSize}
             * @param bufferSize The buffer size. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferSize(java.lang.Number bufferSize) {
                this.bufferSize = bufferSize;
                return this;
            }

            /**
             * Sets the value of {@link SemanticChunkingConfigurationProperty#getMaxTokens}
             * @param maxTokens The maximum number of tokens that a chunk can contain. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTokens(java.lang.Number maxTokens) {
                this.maxTokens = maxTokens;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SemanticChunkingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SemanticChunkingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SemanticChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SemanticChunkingConfigurationProperty {
            private final java.lang.Number breakpointPercentileThreshold;
            private final java.lang.Number bufferSize;
            private final java.lang.Number maxTokens;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.breakpointPercentileThreshold = software.amazon.jsii.Kernel.get(this, "breakpointPercentileThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.bufferSize = software.amazon.jsii.Kernel.get(this, "bufferSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxTokens = software.amazon.jsii.Kernel.get(this, "maxTokens", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.breakpointPercentileThreshold = java.util.Objects.requireNonNull(builder.breakpointPercentileThreshold, "breakpointPercentileThreshold is required");
                this.bufferSize = java.util.Objects.requireNonNull(builder.bufferSize, "bufferSize is required");
                this.maxTokens = java.util.Objects.requireNonNull(builder.maxTokens, "maxTokens is required");
            }

            @Override
            public final java.lang.Number getBreakpointPercentileThreshold() {
                return this.breakpointPercentileThreshold;
            }

            @Override
            public final java.lang.Number getBufferSize() {
                return this.bufferSize;
            }

            @Override
            public final java.lang.Number getMaxTokens() {
                return this.maxTokens;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("breakpointPercentileThreshold", om.valueToTree(this.getBreakpointPercentileThreshold()));
                data.set("bufferSize", om.valueToTree(this.getBufferSize()));
                data.set("maxTokens", om.valueToTree(this.getMaxTokens()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.SemanticChunkingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SemanticChunkingConfigurationProperty.Jsii$Proxy that = (SemanticChunkingConfigurationProperty.Jsii$Proxy) o;

                if (!breakpointPercentileThreshold.equals(that.breakpointPercentileThreshold)) return false;
                if (!bufferSize.equals(that.bufferSize)) return false;
                return this.maxTokens.equals(that.maxTokens);
            }

            @Override
            public final int hashCode() {
                int result = this.breakpointPercentileThreshold.hashCode();
                result = 31 * result + (this.bufferSize.hashCode());
                result = 31 * result + (this.maxTokens.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains the configuration for server-side encryption.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ServerSideEncryptionConfigurationProperty serverSideEncryptionConfigurationProperty = ServerSideEncryptionConfigurationProperty.builder()
     *         .kmsKeyArn("kmsKeyArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-serversideencryptionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-serversideencryptionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.ServerSideEncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ServerSideEncryptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServerSideEncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the AWS KMS key used to encrypt the resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-serversideencryptionconfiguration.html#cfn-bedrock-datasource-serversideencryptionconfiguration-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-serversideencryptionconfiguration.html#cfn-bedrock-datasource-serversideencryptionconfiguration-kmskeyarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServerSideEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServerSideEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServerSideEncryptionConfigurationProperty> {
            java.lang.String kmsKeyArn;

            /**
             * Sets the value of {@link ServerSideEncryptionConfigurationProperty#getKmsKeyArn}
             * @param kmsKeyArn The Amazon Resource Name (ARN) of the AWS KMS key used to encrypt the resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerSideEncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServerSideEncryptionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServerSideEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerSideEncryptionConfigurationProperty {
            private final java.lang.String kmsKeyArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kmsKeyArn = builder.kmsKeyArn;
            }

            @Override
            public final java.lang.String getKmsKeyArn() {
                return this.kmsKeyArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKmsKeyArn() != null) {
                    data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.ServerSideEncryptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServerSideEncryptionConfigurationProperty.Jsii$Proxy that = (ServerSideEncryptionConfigurationProperty.Jsii$Proxy) o;

                return this.kmsKeyArn != null ? this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The configuration of the SharePoint content.
     * <p>
     * For example, configuring specific types of SharePoint content.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * SharePointCrawlerConfigurationProperty sharePointCrawlerConfigurationProperty = SharePointCrawlerConfigurationProperty.builder()
     *         .filterConfiguration(CrawlFilterConfigurationProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .patternObjectFilter(PatternObjectFilterConfigurationProperty.builder()
     *                         .filters(List.of(PatternObjectFilterProperty.builder()
     *                                 .objectType("objectType")
     *                                 // the properties below are optional
     *                                 .exclusionFilters(List.of("exclusionFilters"))
     *                                 .inclusionFilters(List.of("inclusionFilters"))
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-sharepointcrawlerconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-sharepointcrawlerconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.SharePointCrawlerConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SharePointCrawlerConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SharePointCrawlerConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration of filtering the SharePoint content.
         * <p>
         * For example, configuring regular expression patterns to include or exclude certain content.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-sharepointcrawlerconfiguration.html#cfn-bedrock-datasource-sharepointcrawlerconfiguration-filterconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-sharepointcrawlerconfiguration.html#cfn-bedrock-datasource-sharepointcrawlerconfiguration-filterconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilterConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SharePointCrawlerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SharePointCrawlerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SharePointCrawlerConfigurationProperty> {
            java.lang.Object filterConfiguration;

            /**
             * Sets the value of {@link SharePointCrawlerConfigurationProperty#getFilterConfiguration}
             * @param filterConfiguration The configuration of filtering the SharePoint content.
             *                            For example, configuring regular expression patterns to include or exclude certain content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterConfiguration(software.amazon.awscdk.IResolvable filterConfiguration) {
                this.filterConfiguration = filterConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SharePointCrawlerConfigurationProperty#getFilterConfiguration}
             * @param filterConfiguration The configuration of filtering the SharePoint content.
             *                            For example, configuring regular expression patterns to include or exclude certain content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.CrawlFilterConfigurationProperty filterConfiguration) {
                this.filterConfiguration = filterConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SharePointCrawlerConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SharePointCrawlerConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SharePointCrawlerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SharePointCrawlerConfigurationProperty {
            private final java.lang.Object filterConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.filterConfiguration = software.amazon.jsii.Kernel.get(this, "filterConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.filterConfiguration = builder.filterConfiguration;
            }

            @Override
            public final java.lang.Object getFilterConfiguration() {
                return this.filterConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFilterConfiguration() != null) {
                    data.set("filterConfiguration", om.valueToTree(this.getFilterConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.SharePointCrawlerConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SharePointCrawlerConfigurationProperty.Jsii$Proxy that = (SharePointCrawlerConfigurationProperty.Jsii$Proxy) o;

                return this.filterConfiguration != null ? this.filterConfiguration.equals(that.filterConfiguration) : that.filterConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.filterConfiguration != null ? this.filterConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The configuration information to connect to SharePoint as your data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * SharePointDataSourceConfigurationProperty sharePointDataSourceConfigurationProperty = SharePointDataSourceConfigurationProperty.builder()
     *         .sourceConfiguration(SharePointSourceConfigurationProperty.builder()
     *                 .authType("authType")
     *                 .credentialsSecretArn("credentialsSecretArn")
     *                 .domain("domain")
     *                 .hostType("hostType")
     *                 .siteUrls(List.of("siteUrls"))
     *                 // the properties below are optional
     *                 .tenantId("tenantId")
     *                 .build())
     *         // the properties below are optional
     *         .crawlerConfiguration(SharePointCrawlerConfigurationProperty.builder()
     *                 .filterConfiguration(CrawlFilterConfigurationProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .patternObjectFilter(PatternObjectFilterConfigurationProperty.builder()
     *                                 .filters(List.of(PatternObjectFilterProperty.builder()
     *                                         .objectType("objectType")
     *                                         // the properties below are optional
     *                                         .exclusionFilters(List.of("exclusionFilters"))
     *                                         .inclusionFilters(List.of("inclusionFilters"))
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-sharepointdatasourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-sharepointdatasourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.SharePointDataSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SharePointDataSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SharePointDataSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The endpoint information to connect to your SharePoint data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-sharepointdatasourceconfiguration.html#cfn-bedrock-datasource-sharepointdatasourceconfiguration-sourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-sharepointdatasourceconfiguration.html#cfn-bedrock-datasource-sharepointdatasourceconfiguration-sourceconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSourceConfiguration();

        /**
         * The configuration of the SharePoint content.
         * <p>
         * For example, configuring specific types of SharePoint content.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-sharepointdatasourceconfiguration.html#cfn-bedrock-datasource-sharepointdatasourceconfiguration-crawlerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-sharepointdatasourceconfiguration.html#cfn-bedrock-datasource-sharepointdatasourceconfiguration-crawlerconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCrawlerConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SharePointDataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SharePointDataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SharePointDataSourceConfigurationProperty> {
            java.lang.Object sourceConfiguration;
            java.lang.Object crawlerConfiguration;

            /**
             * Sets the value of {@link SharePointDataSourceConfigurationProperty#getSourceConfiguration}
             * @param sourceConfiguration The endpoint information to connect to your SharePoint data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceConfiguration(software.amazon.awscdk.IResolvable sourceConfiguration) {
                this.sourceConfiguration = sourceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SharePointDataSourceConfigurationProperty#getSourceConfiguration}
             * @param sourceConfiguration The endpoint information to connect to your SharePoint data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.SharePointSourceConfigurationProperty sourceConfiguration) {
                this.sourceConfiguration = sourceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SharePointDataSourceConfigurationProperty#getCrawlerConfiguration}
             * @param crawlerConfiguration The configuration of the SharePoint content.
             *                             For example, configuring specific types of SharePoint content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlerConfiguration(software.amazon.awscdk.IResolvable crawlerConfiguration) {
                this.crawlerConfiguration = crawlerConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SharePointDataSourceConfigurationProperty#getCrawlerConfiguration}
             * @param crawlerConfiguration The configuration of the SharePoint content.
             *                             For example, configuring specific types of SharePoint content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlerConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.SharePointCrawlerConfigurationProperty crawlerConfiguration) {
                this.crawlerConfiguration = crawlerConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SharePointDataSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SharePointDataSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SharePointDataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SharePointDataSourceConfigurationProperty {
            private final java.lang.Object sourceConfiguration;
            private final java.lang.Object crawlerConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceConfiguration = software.amazon.jsii.Kernel.get(this, "sourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.crawlerConfiguration = software.amazon.jsii.Kernel.get(this, "crawlerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceConfiguration = java.util.Objects.requireNonNull(builder.sourceConfiguration, "sourceConfiguration is required");
                this.crawlerConfiguration = builder.crawlerConfiguration;
            }

            @Override
            public final java.lang.Object getSourceConfiguration() {
                return this.sourceConfiguration;
            }

            @Override
            public final java.lang.Object getCrawlerConfiguration() {
                return this.crawlerConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sourceConfiguration", om.valueToTree(this.getSourceConfiguration()));
                if (this.getCrawlerConfiguration() != null) {
                    data.set("crawlerConfiguration", om.valueToTree(this.getCrawlerConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.SharePointDataSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SharePointDataSourceConfigurationProperty.Jsii$Proxy that = (SharePointDataSourceConfigurationProperty.Jsii$Proxy) o;

                if (!sourceConfiguration.equals(that.sourceConfiguration)) return false;
                return this.crawlerConfiguration != null ? this.crawlerConfiguration.equals(that.crawlerConfiguration) : that.crawlerConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourceConfiguration.hashCode();
                result = 31 * result + (this.crawlerConfiguration != null ? this.crawlerConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The endpoint information to connect to your SharePoint data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * SharePointSourceConfigurationProperty sharePointSourceConfigurationProperty = SharePointSourceConfigurationProperty.builder()
     *         .authType("authType")
     *         .credentialsSecretArn("credentialsSecretArn")
     *         .domain("domain")
     *         .hostType("hostType")
     *         .siteUrls(List.of("siteUrls"))
     *         // the properties below are optional
     *         .tenantId("tenantId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-sharepointsourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-sharepointsourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.SharePointSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SharePointSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SharePointSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The supported authentication type to authenticate and connect to your SharePoint site/sites.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-sharepointsourceconfiguration.html#cfn-bedrock-datasource-sharepointsourceconfiguration-authtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-sharepointsourceconfiguration.html#cfn-bedrock-datasource-sharepointsourceconfiguration-authtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAuthType();

        /**
         * The Amazon Resource Name of an AWS Secrets Manager secret that stores your authentication credentials for your SharePoint site/sites.
         * <p>
         * For more information on the key-value pairs that must be included in your secret, depending on your authentication type, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/sharepoint-data-source-connector.html#configuration-sharepoint-connector">SharePoint connection configuration</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-sharepointsourceconfiguration.html#cfn-bedrock-datasource-sharepointsourceconfiguration-credentialssecretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-sharepointsourceconfiguration.html#cfn-bedrock-datasource-sharepointsourceconfiguration-credentialssecretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCredentialsSecretArn();

        /**
         * The domain of your SharePoint instance or site URL/URLs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-sharepointsourceconfiguration.html#cfn-bedrock-datasource-sharepointsourceconfiguration-domain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-sharepointsourceconfiguration.html#cfn-bedrock-datasource-sharepointsourceconfiguration-domain</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDomain();

        /**
         * The supported host type, whether online/cloud or server/on-premises.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-sharepointsourceconfiguration.html#cfn-bedrock-datasource-sharepointsourceconfiguration-hosttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-sharepointsourceconfiguration.html#cfn-bedrock-datasource-sharepointsourceconfiguration-hosttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHostType();

        /**
         * A list of one or more SharePoint site URLs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-sharepointsourceconfiguration.html#cfn-bedrock-datasource-sharepointsourceconfiguration-siteurls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-sharepointsourceconfiguration.html#cfn-bedrock-datasource-sharepointsourceconfiguration-siteurls</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSiteUrls();

        /**
         * The identifier of your Microsoft 365 tenant.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-sharepointsourceconfiguration.html#cfn-bedrock-datasource-sharepointsourceconfiguration-tenantid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-sharepointsourceconfiguration.html#cfn-bedrock-datasource-sharepointsourceconfiguration-tenantid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTenantId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SharePointSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SharePointSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SharePointSourceConfigurationProperty> {
            java.lang.String authType;
            java.lang.String credentialsSecretArn;
            java.lang.String domain;
            java.lang.String hostType;
            java.util.List<java.lang.String> siteUrls;
            java.lang.String tenantId;

            /**
             * Sets the value of {@link SharePointSourceConfigurationProperty#getAuthType}
             * @param authType The supported authentication type to authenticate and connect to your SharePoint site/sites. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authType(java.lang.String authType) {
                this.authType = authType;
                return this;
            }

            /**
             * Sets the value of {@link SharePointSourceConfigurationProperty#getCredentialsSecretArn}
             * @param credentialsSecretArn The Amazon Resource Name of an AWS Secrets Manager secret that stores your authentication credentials for your SharePoint site/sites. This parameter is required.
             *                             For more information on the key-value pairs that must be included in your secret, depending on your authentication type, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/sharepoint-data-source-connector.html#configuration-sharepoint-connector">SharePoint connection configuration</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialsSecretArn(java.lang.String credentialsSecretArn) {
                this.credentialsSecretArn = credentialsSecretArn;
                return this;
            }

            /**
             * Sets the value of {@link SharePointSourceConfigurationProperty#getDomain}
             * @param domain The domain of your SharePoint instance or site URL/URLs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domain(java.lang.String domain) {
                this.domain = domain;
                return this;
            }

            /**
             * Sets the value of {@link SharePointSourceConfigurationProperty#getHostType}
             * @param hostType The supported host type, whether online/cloud or server/on-premises. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostType(java.lang.String hostType) {
                this.hostType = hostType;
                return this;
            }

            /**
             * Sets the value of {@link SharePointSourceConfigurationProperty#getSiteUrls}
             * @param siteUrls A list of one or more SharePoint site URLs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder siteUrls(java.util.List<java.lang.String> siteUrls) {
                this.siteUrls = siteUrls;
                return this;
            }

            /**
             * Sets the value of {@link SharePointSourceConfigurationProperty#getTenantId}
             * @param tenantId The identifier of your Microsoft 365 tenant.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tenantId(java.lang.String tenantId) {
                this.tenantId = tenantId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SharePointSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SharePointSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SharePointSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SharePointSourceConfigurationProperty {
            private final java.lang.String authType;
            private final java.lang.String credentialsSecretArn;
            private final java.lang.String domain;
            private final java.lang.String hostType;
            private final java.util.List<java.lang.String> siteUrls;
            private final java.lang.String tenantId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authType = software.amazon.jsii.Kernel.get(this, "authType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.credentialsSecretArn = software.amazon.jsii.Kernel.get(this, "credentialsSecretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.domain = software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostType = software.amazon.jsii.Kernel.get(this, "hostType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.siteUrls = software.amazon.jsii.Kernel.get(this, "siteUrls", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.tenantId = software.amazon.jsii.Kernel.get(this, "tenantId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authType = java.util.Objects.requireNonNull(builder.authType, "authType is required");
                this.credentialsSecretArn = java.util.Objects.requireNonNull(builder.credentialsSecretArn, "credentialsSecretArn is required");
                this.domain = java.util.Objects.requireNonNull(builder.domain, "domain is required");
                this.hostType = java.util.Objects.requireNonNull(builder.hostType, "hostType is required");
                this.siteUrls = java.util.Objects.requireNonNull(builder.siteUrls, "siteUrls is required");
                this.tenantId = builder.tenantId;
            }

            @Override
            public final java.lang.String getAuthType() {
                return this.authType;
            }

            @Override
            public final java.lang.String getCredentialsSecretArn() {
                return this.credentialsSecretArn;
            }

            @Override
            public final java.lang.String getDomain() {
                return this.domain;
            }

            @Override
            public final java.lang.String getHostType() {
                return this.hostType;
            }

            @Override
            public final java.util.List<java.lang.String> getSiteUrls() {
                return this.siteUrls;
            }

            @Override
            public final java.lang.String getTenantId() {
                return this.tenantId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("authType", om.valueToTree(this.getAuthType()));
                data.set("credentialsSecretArn", om.valueToTree(this.getCredentialsSecretArn()));
                data.set("domain", om.valueToTree(this.getDomain()));
                data.set("hostType", om.valueToTree(this.getHostType()));
                data.set("siteUrls", om.valueToTree(this.getSiteUrls()));
                if (this.getTenantId() != null) {
                    data.set("tenantId", om.valueToTree(this.getTenantId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.SharePointSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SharePointSourceConfigurationProperty.Jsii$Proxy that = (SharePointSourceConfigurationProperty.Jsii$Proxy) o;

                if (!authType.equals(that.authType)) return false;
                if (!credentialsSecretArn.equals(that.credentialsSecretArn)) return false;
                if (!domain.equals(that.domain)) return false;
                if (!hostType.equals(that.hostType)) return false;
                if (!siteUrls.equals(that.siteUrls)) return false;
                return this.tenantId != null ? this.tenantId.equals(that.tenantId) : that.tenantId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authType.hashCode();
                result = 31 * result + (this.credentialsSecretArn.hashCode());
                result = 31 * result + (this.domain.hashCode());
                result = 31 * result + (this.hostType.hashCode());
                result = 31 * result + (this.siteUrls.hashCode());
                result = 31 * result + (this.tenantId != null ? this.tenantId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A Lambda function that processes documents.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * TransformationFunctionProperty transformationFunctionProperty = TransformationFunctionProperty.builder()
     *         .transformationLambdaConfiguration(TransformationLambdaConfigurationProperty.builder()
     *                 .lambdaArn("lambdaArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-transformationfunction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-transformationfunction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.TransformationFunctionProperty")
    @software.amazon.jsii.Jsii.Proxy(TransformationFunctionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TransformationFunctionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Lambda function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-transformationfunction.html#cfn-bedrock-datasource-transformationfunction-transformationlambdaconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-transformationfunction.html#cfn-bedrock-datasource-transformationfunction-transformationlambdaconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTransformationLambdaConfiguration();

        /**
         * @return a {@link Builder} of {@link TransformationFunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TransformationFunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TransformationFunctionProperty> {
            java.lang.Object transformationLambdaConfiguration;

            /**
             * Sets the value of {@link TransformationFunctionProperty#getTransformationLambdaConfiguration}
             * @param transformationLambdaConfiguration The Lambda function. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transformationLambdaConfiguration(software.amazon.awscdk.IResolvable transformationLambdaConfiguration) {
                this.transformationLambdaConfiguration = transformationLambdaConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link TransformationFunctionProperty#getTransformationLambdaConfiguration}
             * @param transformationLambdaConfiguration The Lambda function. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transformationLambdaConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.TransformationLambdaConfigurationProperty transformationLambdaConfiguration) {
                this.transformationLambdaConfiguration = transformationLambdaConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransformationFunctionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TransformationFunctionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TransformationFunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransformationFunctionProperty {
            private final java.lang.Object transformationLambdaConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.transformationLambdaConfiguration = software.amazon.jsii.Kernel.get(this, "transformationLambdaConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.transformationLambdaConfiguration = java.util.Objects.requireNonNull(builder.transformationLambdaConfiguration, "transformationLambdaConfiguration is required");
            }

            @Override
            public final java.lang.Object getTransformationLambdaConfiguration() {
                return this.transformationLambdaConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("transformationLambdaConfiguration", om.valueToTree(this.getTransformationLambdaConfiguration()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.TransformationFunctionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TransformationFunctionProperty.Jsii$Proxy that = (TransformationFunctionProperty.Jsii$Proxy) o;

                return this.transformationLambdaConfiguration.equals(that.transformationLambdaConfiguration);
            }

            @Override
            public final int hashCode() {
                int result = this.transformationLambdaConfiguration.hashCode();
                return result;
            }
        }
    }
    /**
     * A Lambda function that processes documents.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * TransformationLambdaConfigurationProperty transformationLambdaConfigurationProperty = TransformationLambdaConfigurationProperty.builder()
     *         .lambdaArn("lambdaArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-transformationlambdaconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-transformationlambdaconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.TransformationLambdaConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TransformationLambdaConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TransformationLambdaConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The function's ARN identifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-transformationlambdaconfiguration.html#cfn-bedrock-datasource-transformationlambdaconfiguration-lambdaarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-transformationlambdaconfiguration.html#cfn-bedrock-datasource-transformationlambdaconfiguration-lambdaarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLambdaArn();

        /**
         * @return a {@link Builder} of {@link TransformationLambdaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TransformationLambdaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TransformationLambdaConfigurationProperty> {
            java.lang.String lambdaArn;

            /**
             * Sets the value of {@link TransformationLambdaConfigurationProperty#getLambdaArn}
             * @param lambdaArn The function's ARN identifier. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaArn(java.lang.String lambdaArn) {
                this.lambdaArn = lambdaArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransformationLambdaConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TransformationLambdaConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TransformationLambdaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransformationLambdaConfigurationProperty {
            private final java.lang.String lambdaArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lambdaArn = software.amazon.jsii.Kernel.get(this, "lambdaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lambdaArn = java.util.Objects.requireNonNull(builder.lambdaArn, "lambdaArn is required");
            }

            @Override
            public final java.lang.String getLambdaArn() {
                return this.lambdaArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("lambdaArn", om.valueToTree(this.getLambdaArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.TransformationLambdaConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TransformationLambdaConfigurationProperty.Jsii$Proxy that = (TransformationLambdaConfigurationProperty.Jsii$Proxy) o;

                return this.lambdaArn.equals(that.lambdaArn);
            }

            @Override
            public final int hashCode() {
                int result = this.lambdaArn.hashCode();
                return result;
            }
        }
    }
    /**
     * A custom processing step for documents moving through a data source ingestion pipeline.
     * <p>
     * To process documents after they have been converted into chunks, set the step to apply to <code>POST_CHUNKING</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * TransformationProperty transformationProperty = TransformationProperty.builder()
     *         .stepToApply("stepToApply")
     *         .transformationFunction(TransformationFunctionProperty.builder()
     *                 .transformationLambdaConfiguration(TransformationLambdaConfigurationProperty.builder()
     *                         .lambdaArn("lambdaArn")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-transformation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-transformation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.TransformationProperty")
    @software.amazon.jsii.Jsii.Proxy(TransformationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TransformationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * When the service applies the transformation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-transformation.html#cfn-bedrock-datasource-transformation-steptoapply">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-transformation.html#cfn-bedrock-datasource-transformation-steptoapply</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStepToApply();

        /**
         * A Lambda function that processes documents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-transformation.html#cfn-bedrock-datasource-transformation-transformationfunction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-transformation.html#cfn-bedrock-datasource-transformation-transformationfunction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTransformationFunction();

        /**
         * @return a {@link Builder} of {@link TransformationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TransformationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TransformationProperty> {
            java.lang.String stepToApply;
            java.lang.Object transformationFunction;

            /**
             * Sets the value of {@link TransformationProperty#getStepToApply}
             * @param stepToApply When the service applies the transformation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stepToApply(java.lang.String stepToApply) {
                this.stepToApply = stepToApply;
                return this;
            }

            /**
             * Sets the value of {@link TransformationProperty#getTransformationFunction}
             * @param transformationFunction A Lambda function that processes documents. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transformationFunction(software.amazon.awscdk.IResolvable transformationFunction) {
                this.transformationFunction = transformationFunction;
                return this;
            }

            /**
             * Sets the value of {@link TransformationProperty#getTransformationFunction}
             * @param transformationFunction A Lambda function that processes documents. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transformationFunction(software.amazon.awscdk.services.bedrock.CfnDataSource.TransformationFunctionProperty transformationFunction) {
                this.transformationFunction = transformationFunction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransformationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TransformationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TransformationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransformationProperty {
            private final java.lang.String stepToApply;
            private final java.lang.Object transformationFunction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.stepToApply = software.amazon.jsii.Kernel.get(this, "stepToApply", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.transformationFunction = software.amazon.jsii.Kernel.get(this, "transformationFunction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.stepToApply = java.util.Objects.requireNonNull(builder.stepToApply, "stepToApply is required");
                this.transformationFunction = java.util.Objects.requireNonNull(builder.transformationFunction, "transformationFunction is required");
            }

            @Override
            public final java.lang.String getStepToApply() {
                return this.stepToApply;
            }

            @Override
            public final java.lang.Object getTransformationFunction() {
                return this.transformationFunction;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("stepToApply", om.valueToTree(this.getStepToApply()));
                data.set("transformationFunction", om.valueToTree(this.getTransformationFunction()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.TransformationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TransformationProperty.Jsii$Proxy that = (TransformationProperty.Jsii$Proxy) o;

                if (!stepToApply.equals(that.stepToApply)) return false;
                return this.transformationFunction.equals(that.transformationFunction);
            }

            @Override
            public final int hashCode() {
                int result = this.stepToApply.hashCode();
                result = 31 * result + (this.transformationFunction.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration of web URLs that you want to crawl.
     * <p>
     * You should be authorized to crawl the URLs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * UrlConfigurationProperty urlConfigurationProperty = UrlConfigurationProperty.builder()
     *         .seedUrls(List.of(SeedUrlProperty.builder()
     *                 .url("url")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-urlconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-urlconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.UrlConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(UrlConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UrlConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * One or more seed or starting point URLs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-urlconfiguration.html#cfn-bedrock-datasource-urlconfiguration-seedurls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-urlconfiguration.html#cfn-bedrock-datasource-urlconfiguration-seedurls</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSeedUrls();

        /**
         * @return a {@link Builder} of {@link UrlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UrlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UrlConfigurationProperty> {
            java.lang.Object seedUrls;

            /**
             * Sets the value of {@link UrlConfigurationProperty#getSeedUrls}
             * @param seedUrls One or more seed or starting point URLs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder seedUrls(software.amazon.awscdk.IResolvable seedUrls) {
                this.seedUrls = seedUrls;
                return this;
            }

            /**
             * Sets the value of {@link UrlConfigurationProperty#getSeedUrls}
             * @param seedUrls One or more seed or starting point URLs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder seedUrls(java.util.List<? extends java.lang.Object> seedUrls) {
                this.seedUrls = seedUrls;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UrlConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UrlConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UrlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UrlConfigurationProperty {
            private final java.lang.Object seedUrls;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.seedUrls = software.amazon.jsii.Kernel.get(this, "seedUrls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.seedUrls = java.util.Objects.requireNonNull(builder.seedUrls, "seedUrls is required");
            }

            @Override
            public final java.lang.Object getSeedUrls() {
                return this.seedUrls;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("seedUrls", om.valueToTree(this.getSeedUrls()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.UrlConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UrlConfigurationProperty.Jsii$Proxy that = (UrlConfigurationProperty.Jsii$Proxy) o;

                return this.seedUrls.equals(that.seedUrls);
            }

            @Override
            public final int hashCode() {
                int result = this.seedUrls.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains details about how to ingest the documents in a data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * VectorIngestionConfigurationProperty vectorIngestionConfigurationProperty = VectorIngestionConfigurationProperty.builder()
     *         .chunkingConfiguration(ChunkingConfigurationProperty.builder()
     *                 .chunkingStrategy("chunkingStrategy")
     *                 // the properties below are optional
     *                 .fixedSizeChunkingConfiguration(FixedSizeChunkingConfigurationProperty.builder()
     *                         .maxTokens(123)
     *                         .overlapPercentage(123)
     *                         .build())
     *                 .hierarchicalChunkingConfiguration(HierarchicalChunkingConfigurationProperty.builder()
     *                         .levelConfigurations(List.of(HierarchicalChunkingLevelConfigurationProperty.builder()
     *                                 .maxTokens(123)
     *                                 .build()))
     *                         .overlapTokens(123)
     *                         .build())
     *                 .semanticChunkingConfiguration(SemanticChunkingConfigurationProperty.builder()
     *                         .breakpointPercentileThreshold(123)
     *                         .bufferSize(123)
     *                         .maxTokens(123)
     *                         .build())
     *                 .build())
     *         .customTransformationConfiguration(CustomTransformationConfigurationProperty.builder()
     *                 .intermediateStorage(IntermediateStorageProperty.builder()
     *                         .s3Location(S3LocationProperty.builder()
     *                                 .uri("uri")
     *                                 .build())
     *                         .build())
     *                 .transformations(List.of(TransformationProperty.builder()
     *                         .stepToApply("stepToApply")
     *                         .transformationFunction(TransformationFunctionProperty.builder()
     *                                 .transformationLambdaConfiguration(TransformationLambdaConfigurationProperty.builder()
     *                                         .lambdaArn("lambdaArn")
     *                                         .build())
     *                                 .build())
     *                         .build()))
     *                 .build())
     *         .parsingConfiguration(ParsingConfigurationProperty.builder()
     *                 .parsingStrategy("parsingStrategy")
     *                 // the properties below are optional
     *                 .bedrockDataAutomationConfiguration(BedrockDataAutomationConfigurationProperty.builder()
     *                         .parsingModality("parsingModality")
     *                         .build())
     *                 .bedrockFoundationModelConfiguration(BedrockFoundationModelConfigurationProperty.builder()
     *                         .modelArn("modelArn")
     *                         // the properties below are optional
     *                         .parsingModality("parsingModality")
     *                         .parsingPrompt(ParsingPromptProperty.builder()
     *                                 .parsingPromptText("parsingPromptText")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-vectoringestionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-vectoringestionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.VectorIngestionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(VectorIngestionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VectorIngestionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Details about how to chunk the documents in the data source.
         * <p>
         * A <em>chunk</em> refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-vectoringestionconfiguration.html#cfn-bedrock-datasource-vectoringestionconfiguration-chunkingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-vectoringestionconfiguration.html#cfn-bedrock-datasource-vectoringestionconfiguration-chunkingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getChunkingConfiguration() {
            return null;
        }

        /**
         * A custom document transformer for parsed data source documents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-vectoringestionconfiguration.html#cfn-bedrock-datasource-vectoringestionconfiguration-customtransformationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-vectoringestionconfiguration.html#cfn-bedrock-datasource-vectoringestionconfiguration-customtransformationconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomTransformationConfiguration() {
            return null;
        }

        /**
         * Configurations for a parser to use for parsing documents in your data source.
         * <p>
         * If you exclude this field, the default parser will be used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-vectoringestionconfiguration.html#cfn-bedrock-datasource-vectoringestionconfiguration-parsingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-vectoringestionconfiguration.html#cfn-bedrock-datasource-vectoringestionconfiguration-parsingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParsingConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VectorIngestionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VectorIngestionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VectorIngestionConfigurationProperty> {
            java.lang.Object chunkingConfiguration;
            java.lang.Object customTransformationConfiguration;
            java.lang.Object parsingConfiguration;

            /**
             * Sets the value of {@link VectorIngestionConfigurationProperty#getChunkingConfiguration}
             * @param chunkingConfiguration Details about how to chunk the documents in the data source.
             *                              A <em>chunk</em> refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder chunkingConfiguration(software.amazon.awscdk.IResolvable chunkingConfiguration) {
                this.chunkingConfiguration = chunkingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VectorIngestionConfigurationProperty#getChunkingConfiguration}
             * @param chunkingConfiguration Details about how to chunk the documents in the data source.
             *                              A <em>chunk</em> refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder chunkingConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.ChunkingConfigurationProperty chunkingConfiguration) {
                this.chunkingConfiguration = chunkingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VectorIngestionConfigurationProperty#getCustomTransformationConfiguration}
             * @param customTransformationConfiguration A custom document transformer for parsed data source documents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customTransformationConfiguration(software.amazon.awscdk.IResolvable customTransformationConfiguration) {
                this.customTransformationConfiguration = customTransformationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VectorIngestionConfigurationProperty#getCustomTransformationConfiguration}
             * @param customTransformationConfiguration A custom document transformer for parsed data source documents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customTransformationConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.CustomTransformationConfigurationProperty customTransformationConfiguration) {
                this.customTransformationConfiguration = customTransformationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VectorIngestionConfigurationProperty#getParsingConfiguration}
             * @param parsingConfiguration Configurations for a parser to use for parsing documents in your data source.
             *                             If you exclude this field, the default parser will be used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parsingConfiguration(software.amazon.awscdk.IResolvable parsingConfiguration) {
                this.parsingConfiguration = parsingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VectorIngestionConfigurationProperty#getParsingConfiguration}
             * @param parsingConfiguration Configurations for a parser to use for parsing documents in your data source.
             *                             If you exclude this field, the default parser will be used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parsingConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.ParsingConfigurationProperty parsingConfiguration) {
                this.parsingConfiguration = parsingConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VectorIngestionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VectorIngestionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VectorIngestionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VectorIngestionConfigurationProperty {
            private final java.lang.Object chunkingConfiguration;
            private final java.lang.Object customTransformationConfiguration;
            private final java.lang.Object parsingConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.chunkingConfiguration = software.amazon.jsii.Kernel.get(this, "chunkingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customTransformationConfiguration = software.amazon.jsii.Kernel.get(this, "customTransformationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parsingConfiguration = software.amazon.jsii.Kernel.get(this, "parsingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.chunkingConfiguration = builder.chunkingConfiguration;
                this.customTransformationConfiguration = builder.customTransformationConfiguration;
                this.parsingConfiguration = builder.parsingConfiguration;
            }

            @Override
            public final java.lang.Object getChunkingConfiguration() {
                return this.chunkingConfiguration;
            }

            @Override
            public final java.lang.Object getCustomTransformationConfiguration() {
                return this.customTransformationConfiguration;
            }

            @Override
            public final java.lang.Object getParsingConfiguration() {
                return this.parsingConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getChunkingConfiguration() != null) {
                    data.set("chunkingConfiguration", om.valueToTree(this.getChunkingConfiguration()));
                }
                if (this.getCustomTransformationConfiguration() != null) {
                    data.set("customTransformationConfiguration", om.valueToTree(this.getCustomTransformationConfiguration()));
                }
                if (this.getParsingConfiguration() != null) {
                    data.set("parsingConfiguration", om.valueToTree(this.getParsingConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.VectorIngestionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VectorIngestionConfigurationProperty.Jsii$Proxy that = (VectorIngestionConfigurationProperty.Jsii$Proxy) o;

                if (this.chunkingConfiguration != null ? !this.chunkingConfiguration.equals(that.chunkingConfiguration) : that.chunkingConfiguration != null) return false;
                if (this.customTransformationConfiguration != null ? !this.customTransformationConfiguration.equals(that.customTransformationConfiguration) : that.customTransformationConfiguration != null) return false;
                return this.parsingConfiguration != null ? this.parsingConfiguration.equals(that.parsingConfiguration) : that.parsingConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.chunkingConfiguration != null ? this.chunkingConfiguration.hashCode() : 0;
                result = 31 * result + (this.customTransformationConfiguration != null ? this.customTransformationConfiguration.hashCode() : 0);
                result = 31 * result + (this.parsingConfiguration != null ? this.parsingConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of web URLs that you want to crawl.
     * <p>
     * You should be authorized to crawl the URLs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * WebCrawlerConfigurationProperty webCrawlerConfigurationProperty = WebCrawlerConfigurationProperty.builder()
     *         .crawlerLimits(WebCrawlerLimitsProperty.builder()
     *                 .rateLimit(123)
     *                 .build())
     *         .exclusionFilters(List.of("exclusionFilters"))
     *         .inclusionFilters(List.of("inclusionFilters"))
     *         .scope("scope")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-webcrawlerconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-webcrawlerconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.WebCrawlerConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(WebCrawlerConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WebCrawlerConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration of crawl limits for the web URLs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-webcrawlerconfiguration.html#cfn-bedrock-datasource-webcrawlerconfiguration-crawlerlimits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-webcrawlerconfiguration.html#cfn-bedrock-datasource-webcrawlerconfiguration-crawlerlimits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCrawlerLimits() {
            return null;
        }

        /**
         * A list of one or more exclusion regular expression patterns to exclude certain URLs.
         * <p>
         * If you specify an inclusion and exclusion filter/pattern and both match a URL, the exclusion filter takes precedence and the web content of the URL isn’t crawled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-webcrawlerconfiguration.html#cfn-bedrock-datasource-webcrawlerconfiguration-exclusionfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-webcrawlerconfiguration.html#cfn-bedrock-datasource-webcrawlerconfiguration-exclusionfilters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExclusionFilters() {
            return null;
        }

        /**
         * A list of one or more inclusion regular expression patterns to include certain URLs.
         * <p>
         * If you specify an inclusion and exclusion filter/pattern and both match a URL, the exclusion filter takes precedence and the web content of the URL isn’t crawled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-webcrawlerconfiguration.html#cfn-bedrock-datasource-webcrawlerconfiguration-inclusionfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-webcrawlerconfiguration.html#cfn-bedrock-datasource-webcrawlerconfiguration-inclusionfilters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInclusionFilters() {
            return null;
        }

        /**
         * The scope of what is crawled for your URLs.
         * <p>
         * You can choose to crawl only web pages that belong to the same host or primary domain. For example, only web pages that contain the seed URL "https://docs.aws.amazon.com/bedrock/latest/userguide/" and no other domains. You can choose to include sub domains in addition to the host or primary domain. For example, web pages that contain "aws.amazon.com" can also include sub domain "docs.aws.amazon.com".
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-webcrawlerconfiguration.html#cfn-bedrock-datasource-webcrawlerconfiguration-scope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-webcrawlerconfiguration.html#cfn-bedrock-datasource-webcrawlerconfiguration-scope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScope() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WebCrawlerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WebCrawlerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WebCrawlerConfigurationProperty> {
            java.lang.Object crawlerLimits;
            java.util.List<java.lang.String> exclusionFilters;
            java.util.List<java.lang.String> inclusionFilters;
            java.lang.String scope;

            /**
             * Sets the value of {@link WebCrawlerConfigurationProperty#getCrawlerLimits}
             * @param crawlerLimits The configuration of crawl limits for the web URLs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlerLimits(software.amazon.awscdk.IResolvable crawlerLimits) {
                this.crawlerLimits = crawlerLimits;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerConfigurationProperty#getCrawlerLimits}
             * @param crawlerLimits The configuration of crawl limits for the web URLs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlerLimits(software.amazon.awscdk.services.bedrock.CfnDataSource.WebCrawlerLimitsProperty crawlerLimits) {
                this.crawlerLimits = crawlerLimits;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerConfigurationProperty#getExclusionFilters}
             * @param exclusionFilters A list of one or more exclusion regular expression patterns to exclude certain URLs.
             *                         If you specify an inclusion and exclusion filter/pattern and both match a URL, the exclusion filter takes precedence and the web content of the URL isn’t crawled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclusionFilters(java.util.List<java.lang.String> exclusionFilters) {
                this.exclusionFilters = exclusionFilters;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerConfigurationProperty#getInclusionFilters}
             * @param inclusionFilters A list of one or more inclusion regular expression patterns to include certain URLs.
             *                         If you specify an inclusion and exclusion filter/pattern and both match a URL, the exclusion filter takes precedence and the web content of the URL isn’t crawled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inclusionFilters(java.util.List<java.lang.String> inclusionFilters) {
                this.inclusionFilters = inclusionFilters;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerConfigurationProperty#getScope}
             * @param scope The scope of what is crawled for your URLs.
             *              You can choose to crawl only web pages that belong to the same host or primary domain. For example, only web pages that contain the seed URL "https://docs.aws.amazon.com/bedrock/latest/userguide/" and no other domains. You can choose to include sub domains in addition to the host or primary domain. For example, web pages that contain "aws.amazon.com" can also include sub domain "docs.aws.amazon.com".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scope(java.lang.String scope) {
                this.scope = scope;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebCrawlerConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WebCrawlerConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WebCrawlerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebCrawlerConfigurationProperty {
            private final java.lang.Object crawlerLimits;
            private final java.util.List<java.lang.String> exclusionFilters;
            private final java.util.List<java.lang.String> inclusionFilters;
            private final java.lang.String scope;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.crawlerLimits = software.amazon.jsii.Kernel.get(this, "crawlerLimits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.exclusionFilters = software.amazon.jsii.Kernel.get(this, "exclusionFilters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.inclusionFilters = software.amazon.jsii.Kernel.get(this, "inclusionFilters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.crawlerLimits = builder.crawlerLimits;
                this.exclusionFilters = builder.exclusionFilters;
                this.inclusionFilters = builder.inclusionFilters;
                this.scope = builder.scope;
            }

            @Override
            public final java.lang.Object getCrawlerLimits() {
                return this.crawlerLimits;
            }

            @Override
            public final java.util.List<java.lang.String> getExclusionFilters() {
                return this.exclusionFilters;
            }

            @Override
            public final java.util.List<java.lang.String> getInclusionFilters() {
                return this.inclusionFilters;
            }

            @Override
            public final java.lang.String getScope() {
                return this.scope;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCrawlerLimits() != null) {
                    data.set("crawlerLimits", om.valueToTree(this.getCrawlerLimits()));
                }
                if (this.getExclusionFilters() != null) {
                    data.set("exclusionFilters", om.valueToTree(this.getExclusionFilters()));
                }
                if (this.getInclusionFilters() != null) {
                    data.set("inclusionFilters", om.valueToTree(this.getInclusionFilters()));
                }
                if (this.getScope() != null) {
                    data.set("scope", om.valueToTree(this.getScope()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.WebCrawlerConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WebCrawlerConfigurationProperty.Jsii$Proxy that = (WebCrawlerConfigurationProperty.Jsii$Proxy) o;

                if (this.crawlerLimits != null ? !this.crawlerLimits.equals(that.crawlerLimits) : that.crawlerLimits != null) return false;
                if (this.exclusionFilters != null ? !this.exclusionFilters.equals(that.exclusionFilters) : that.exclusionFilters != null) return false;
                if (this.inclusionFilters != null ? !this.inclusionFilters.equals(that.inclusionFilters) : that.inclusionFilters != null) return false;
                return this.scope != null ? this.scope.equals(that.scope) : that.scope == null;
            }

            @Override
            public final int hashCode() {
                int result = this.crawlerLimits != null ? this.crawlerLimits.hashCode() : 0;
                result = 31 * result + (this.exclusionFilters != null ? this.exclusionFilters.hashCode() : 0);
                result = 31 * result + (this.inclusionFilters != null ? this.inclusionFilters.hashCode() : 0);
                result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The rate limits for the URLs that you want to crawl.
     * <p>
     * You should be authorized to crawl the URLs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * WebCrawlerLimitsProperty webCrawlerLimitsProperty = WebCrawlerLimitsProperty.builder()
     *         .rateLimit(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-webcrawlerlimits.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-webcrawlerlimits.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.WebCrawlerLimitsProperty")
    @software.amazon.jsii.Jsii.Proxy(WebCrawlerLimitsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WebCrawlerLimitsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The max rate at which pages are crawled, up to 300 per minute per host.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-webcrawlerlimits.html#cfn-bedrock-datasource-webcrawlerlimits-ratelimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-webcrawlerlimits.html#cfn-bedrock-datasource-webcrawlerlimits-ratelimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRateLimit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WebCrawlerLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WebCrawlerLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WebCrawlerLimitsProperty> {
            java.lang.Number rateLimit;

            /**
             * Sets the value of {@link WebCrawlerLimitsProperty#getRateLimit}
             * @param rateLimit The max rate at which pages are crawled, up to 300 per minute per host.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rateLimit(java.lang.Number rateLimit) {
                this.rateLimit = rateLimit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebCrawlerLimitsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WebCrawlerLimitsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WebCrawlerLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebCrawlerLimitsProperty {
            private final java.lang.Number rateLimit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rateLimit = software.amazon.jsii.Kernel.get(this, "rateLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rateLimit = builder.rateLimit;
            }

            @Override
            public final java.lang.Number getRateLimit() {
                return this.rateLimit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRateLimit() != null) {
                    data.set("rateLimit", om.valueToTree(this.getRateLimit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.WebCrawlerLimitsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WebCrawlerLimitsProperty.Jsii$Proxy that = (WebCrawlerLimitsProperty.Jsii$Proxy) o;

                return this.rateLimit != null ? this.rateLimit.equals(that.rateLimit) : that.rateLimit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.rateLimit != null ? this.rateLimit.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The configuration details for the web data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * WebDataSourceConfigurationProperty webDataSourceConfigurationProperty = WebDataSourceConfigurationProperty.builder()
     *         .sourceConfiguration(WebSourceConfigurationProperty.builder()
     *                 .urlConfiguration(UrlConfigurationProperty.builder()
     *                         .seedUrls(List.of(SeedUrlProperty.builder()
     *                                 .url("url")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .crawlerConfiguration(WebCrawlerConfigurationProperty.builder()
     *                 .crawlerLimits(WebCrawlerLimitsProperty.builder()
     *                         .rateLimit(123)
     *                         .build())
     *                 .exclusionFilters(List.of("exclusionFilters"))
     *                 .inclusionFilters(List.of("inclusionFilters"))
     *                 .scope("scope")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-webdatasourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-webdatasourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.WebDataSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(WebDataSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WebDataSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The source configuration details for the web data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-webdatasourceconfiguration.html#cfn-bedrock-datasource-webdatasourceconfiguration-sourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-webdatasourceconfiguration.html#cfn-bedrock-datasource-webdatasourceconfiguration-sourceconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSourceConfiguration();

        /**
         * The Web Crawler configuration details for the web data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-webdatasourceconfiguration.html#cfn-bedrock-datasource-webdatasourceconfiguration-crawlerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-webdatasourceconfiguration.html#cfn-bedrock-datasource-webdatasourceconfiguration-crawlerconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCrawlerConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WebDataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WebDataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WebDataSourceConfigurationProperty> {
            java.lang.Object sourceConfiguration;
            java.lang.Object crawlerConfiguration;

            /**
             * Sets the value of {@link WebDataSourceConfigurationProperty#getSourceConfiguration}
             * @param sourceConfiguration The source configuration details for the web data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceConfiguration(software.amazon.awscdk.IResolvable sourceConfiguration) {
                this.sourceConfiguration = sourceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WebDataSourceConfigurationProperty#getSourceConfiguration}
             * @param sourceConfiguration The source configuration details for the web data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.WebSourceConfigurationProperty sourceConfiguration) {
                this.sourceConfiguration = sourceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WebDataSourceConfigurationProperty#getCrawlerConfiguration}
             * @param crawlerConfiguration The Web Crawler configuration details for the web data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlerConfiguration(software.amazon.awscdk.IResolvable crawlerConfiguration) {
                this.crawlerConfiguration = crawlerConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WebDataSourceConfigurationProperty#getCrawlerConfiguration}
             * @param crawlerConfiguration The Web Crawler configuration details for the web data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlerConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.WebCrawlerConfigurationProperty crawlerConfiguration) {
                this.crawlerConfiguration = crawlerConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebDataSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WebDataSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WebDataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebDataSourceConfigurationProperty {
            private final java.lang.Object sourceConfiguration;
            private final java.lang.Object crawlerConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceConfiguration = software.amazon.jsii.Kernel.get(this, "sourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.crawlerConfiguration = software.amazon.jsii.Kernel.get(this, "crawlerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceConfiguration = java.util.Objects.requireNonNull(builder.sourceConfiguration, "sourceConfiguration is required");
                this.crawlerConfiguration = builder.crawlerConfiguration;
            }

            @Override
            public final java.lang.Object getSourceConfiguration() {
                return this.sourceConfiguration;
            }

            @Override
            public final java.lang.Object getCrawlerConfiguration() {
                return this.crawlerConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sourceConfiguration", om.valueToTree(this.getSourceConfiguration()));
                if (this.getCrawlerConfiguration() != null) {
                    data.set("crawlerConfiguration", om.valueToTree(this.getCrawlerConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.WebDataSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WebDataSourceConfigurationProperty.Jsii$Proxy that = (WebDataSourceConfigurationProperty.Jsii$Proxy) o;

                if (!sourceConfiguration.equals(that.sourceConfiguration)) return false;
                return this.crawlerConfiguration != null ? this.crawlerConfiguration.equals(that.crawlerConfiguration) : that.crawlerConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourceConfiguration.hashCode();
                result = 31 * result + (this.crawlerConfiguration != null ? this.crawlerConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of the URL/URLs for the web content that you want to crawl.
     * <p>
     * You should be authorized to crawl the URLs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * WebSourceConfigurationProperty webSourceConfigurationProperty = WebSourceConfigurationProperty.builder()
     *         .urlConfiguration(UrlConfigurationProperty.builder()
     *                 .seedUrls(List.of(SeedUrlProperty.builder()
     *                         .url("url")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-websourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-websourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.WebSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(WebSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WebSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration of the URL/URLs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-websourceconfiguration.html#cfn-bedrock-datasource-websourceconfiguration-urlconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-websourceconfiguration.html#cfn-bedrock-datasource-websourceconfiguration-urlconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getUrlConfiguration();

        /**
         * @return a {@link Builder} of {@link WebSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WebSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WebSourceConfigurationProperty> {
            java.lang.Object urlConfiguration;

            /**
             * Sets the value of {@link WebSourceConfigurationProperty#getUrlConfiguration}
             * @param urlConfiguration The configuration of the URL/URLs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder urlConfiguration(software.amazon.awscdk.IResolvable urlConfiguration) {
                this.urlConfiguration = urlConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WebSourceConfigurationProperty#getUrlConfiguration}
             * @param urlConfiguration The configuration of the URL/URLs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder urlConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.UrlConfigurationProperty urlConfiguration) {
                this.urlConfiguration = urlConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WebSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WebSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebSourceConfigurationProperty {
            private final java.lang.Object urlConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.urlConfiguration = software.amazon.jsii.Kernel.get(this, "urlConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.urlConfiguration = java.util.Objects.requireNonNull(builder.urlConfiguration, "urlConfiguration is required");
            }

            @Override
            public final java.lang.Object getUrlConfiguration() {
                return this.urlConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("urlConfiguration", om.valueToTree(this.getUrlConfiguration()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.WebSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WebSourceConfigurationProperty.Jsii$Proxy that = (WebSourceConfigurationProperty.Jsii$Proxy) o;

                return this.urlConfiguration.equals(that.urlConfiguration);
            }

            @Override
            public final int hashCode() {
                int result = this.urlConfiguration.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.bedrock.CfnDataSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.bedrock.CfnDataSource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.bedrock.CfnDataSourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.bedrock.CfnDataSourceProps.Builder();
        }

        /**
         * The connection configuration for the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-datasourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-datasourceconfiguration</a>
         * @param dataSourceConfiguration The connection configuration for the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSourceConfiguration(final software.amazon.awscdk.IResolvable dataSourceConfiguration) {
            this.props.dataSourceConfiguration(dataSourceConfiguration);
            return this;
        }
        /**
         * The connection configuration for the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-datasourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-datasourceconfiguration</a>
         * @param dataSourceConfiguration The connection configuration for the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSourceConfiguration(final software.amazon.awscdk.services.bedrock.CfnDataSource.DataSourceConfigurationProperty dataSourceConfiguration) {
            this.props.dataSourceConfiguration(dataSourceConfiguration);
            return this;
        }

        /**
         * The unique identifier of the knowledge base to which the data source belongs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-knowledgebaseid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-knowledgebaseid</a>
         * @param knowledgeBaseId The unique identifier of the knowledge base to which the data source belongs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder knowledgeBaseId(final java.lang.String knowledgeBaseId) {
            this.props.knowledgeBaseId(knowledgeBaseId);
            return this;
        }

        /**
         * The name of the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-name</a>
         * @param name The name of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The data deletion policy for the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-datadeletionpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-datadeletionpolicy</a>
         * @param dataDeletionPolicy The data deletion policy for the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataDeletionPolicy(final java.lang.String dataDeletionPolicy) {
            this.props.dataDeletionPolicy(dataDeletionPolicy);
            return this;
        }

        /**
         * The description of the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-description</a>
         * @param description The description of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Contains details about the configuration of the server-side encryption.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-serversideencryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-serversideencryptionconfiguration</a>
         * @param serverSideEncryptionConfiguration Contains details about the configuration of the server-side encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryptionConfiguration(final software.amazon.awscdk.IResolvable serverSideEncryptionConfiguration) {
            this.props.serverSideEncryptionConfiguration(serverSideEncryptionConfiguration);
            return this;
        }
        /**
         * Contains details about the configuration of the server-side encryption.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-serversideencryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-serversideencryptionconfiguration</a>
         * @param serverSideEncryptionConfiguration Contains details about the configuration of the server-side encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryptionConfiguration(final software.amazon.awscdk.services.bedrock.CfnDataSource.ServerSideEncryptionConfigurationProperty serverSideEncryptionConfiguration) {
            this.props.serverSideEncryptionConfiguration(serverSideEncryptionConfiguration);
            return this;
        }

        /**
         * Contains details about how to ingest the documents in the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-vectoringestionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-vectoringestionconfiguration</a>
         * @param vectorIngestionConfiguration Contains details about how to ingest the documents in the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vectorIngestionConfiguration(final software.amazon.awscdk.IResolvable vectorIngestionConfiguration) {
            this.props.vectorIngestionConfiguration(vectorIngestionConfiguration);
            return this;
        }
        /**
         * Contains details about how to ingest the documents in the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-vectoringestionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-vectoringestionconfiguration</a>
         * @param vectorIngestionConfiguration Contains details about how to ingest the documents in the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vectorIngestionConfiguration(final software.amazon.awscdk.services.bedrock.CfnDataSource.VectorIngestionConfigurationProperty vectorIngestionConfiguration) {
            this.props.vectorIngestionConfiguration(vectorIngestionConfiguration);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.bedrock.CfnDataSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.bedrock.CfnDataSource build() {
            return new software.amazon.awscdk.services.bedrock.CfnDataSource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
