package software.amazon.awscdk.services.cassandra;

/**
 * You can use the <code>AWS::Cassandra::Keyspace</code> resource to create a new keyspace in Amazon Keyspaces (for Apache Cassandra).
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/getting-started.keyspaces.html">Create a keyspace</a> in the <em>Amazon Keyspaces Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cassandra.*;
 * CfnKeyspace cfnKeyspace = CfnKeyspace.Builder.create(this, "MyCfnKeyspace")
 *         .clientSideTimestampsEnabled(false)
 *         .keyspaceName("keyspaceName")
 *         .replicationSpecification(ReplicationSpecificationProperty.builder()
 *                 .regionList(List.of("regionList"))
 *                 .replicationStrategy("replicationStrategy")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:20.593Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cassandra.CfnKeyspace")
public class CfnKeyspace extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnKeyspace(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnKeyspace(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cassandra.CfnKeyspace.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnKeyspace(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cassandra.CfnKeyspaceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnKeyspace(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Indicates whether client-side timestamps are enabled (true) or disabled (false) for all tables in the keyspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getClientSideTimestampsEnabled() {
        return software.amazon.jsii.Kernel.get(this, "clientSideTimestampsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether client-side timestamps are enabled (true) or disabled (false) for all tables in the keyspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientSideTimestampsEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "clientSideTimestampsEnabled", value);
    }

    /**
     * Indicates whether client-side timestamps are enabled (true) or disabled (false) for all tables in the keyspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientSideTimestampsEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "clientSideTimestampsEnabled", value);
    }

    /**
     * The name of the keyspace to be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKeyspaceName() {
        return software.amazon.jsii.Kernel.get(this, "keyspaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the keyspace to be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKeyspaceName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "keyspaceName", value);
    }

    /**
     * Specifies the <code>ReplicationStrategy</code> of a keyspace.
     * <p>
     * The options are:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getReplicationSpecification() {
        return software.amazon.jsii.Kernel.get(this, "replicationSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the <code>ReplicationStrategy</code> of a keyspace.
     * <p>
     * The options are:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicationSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "replicationSpecification", value);
    }

    /**
     * Specifies the <code>ReplicationStrategy</code> of a keyspace.
     * <p>
     * The options are:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicationSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cassandra.CfnKeyspace.ReplicationSpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "replicationSpecification", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * You can use <code>ReplicationSpecification</code> to configure the <code>ReplicationStrategy</code> of a keyspace in Amazon Keyspaces .
     * <p>
     * The <code>ReplicationSpecification</code> property applies automatically to all tables in the keyspace.
     * <p>
     * To review the permissions that are required to add a new Region to a single-Region keyspace, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/howitworks_replication_permissions_addReplica.html">Configure the IAM permissions required to add an AWS Region to a keyspace</a> in the <em>Amazon Keyspaces Developer Guide</em> .
     * <p>
     * For more information about multi-Region replication, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/multiRegion-replication.html">Multi-Region replication</a> in the <em>Amazon Keyspaces Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cassandra.*;
     * ReplicationSpecificationProperty replicationSpecificationProperty = ReplicationSpecificationProperty.builder()
     *         .regionList(List.of("regionList"))
     *         .replicationStrategy("replicationStrategy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-keyspace-replicationspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-keyspace-replicationspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cassandra.CfnKeyspace.ReplicationSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicationSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicationSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the AWS Regions that the keyspace is replicated in.
         * <p>
         * You must specify at least two and up to six Regions, including the Region that the keyspace is being created in.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-keyspace-replicationspecification.html#cfn-cassandra-keyspace-replicationspecification-regionlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-keyspace-replicationspecification.html#cfn-cassandra-keyspace-replicationspecification-regionlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRegionList() {
            return null;
        }

        /**
         * The options are:.
         * <p>
         * <ul>
         * <li><code>SINGLE_REGION</code> (optional)</li>
         * <li><code>MULTI_REGION</code></li>
         * </ul>
         * <p>
         * If no value is specified, the default is <code>SINGLE_REGION</code> . If <code>MULTI_REGION</code> is specified, <code>RegionList</code> is required.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-keyspace-replicationspecification.html#cfn-cassandra-keyspace-replicationspecification-replicationstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-keyspace-replicationspecification.html#cfn-cassandra-keyspace-replicationspecification-replicationstrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReplicationStrategy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReplicationSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicationSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicationSpecificationProperty> {
            java.util.List<java.lang.String> regionList;
            java.lang.String replicationStrategy;

            /**
             * Sets the value of {@link ReplicationSpecificationProperty#getRegionList}
             * @param regionList Specifies the AWS Regions that the keyspace is replicated in.
             *                   You must specify at least two and up to six Regions, including the Region that the keyspace is being created in.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regionList(java.util.List<java.lang.String> regionList) {
                this.regionList = regionList;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationSpecificationProperty#getReplicationStrategy}
             * @param replicationStrategy The options are:.
             *                            <ul>
             *                            <li><code>SINGLE_REGION</code> (optional)</li>
             *                            <li><code>MULTI_REGION</code></li>
             *                            </ul>
             *                            <p>
             *                            If no value is specified, the default is <code>SINGLE_REGION</code> . If <code>MULTI_REGION</code> is specified, <code>RegionList</code> is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replicationStrategy(java.lang.String replicationStrategy) {
                this.replicationStrategy = replicationStrategy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicationSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReplicationSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationSpecificationProperty {
            private final java.util.List<java.lang.String> regionList;
            private final java.lang.String replicationStrategy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.regionList = software.amazon.jsii.Kernel.get(this, "regionList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.replicationStrategy = software.amazon.jsii.Kernel.get(this, "replicationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.regionList = builder.regionList;
                this.replicationStrategy = builder.replicationStrategy;
            }

            @Override
            public final java.util.List<java.lang.String> getRegionList() {
                return this.regionList;
            }

            @Override
            public final java.lang.String getReplicationStrategy() {
                return this.replicationStrategy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRegionList() != null) {
                    data.set("regionList", om.valueToTree(this.getRegionList()));
                }
                if (this.getReplicationStrategy() != null) {
                    data.set("replicationStrategy", om.valueToTree(this.getReplicationStrategy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cassandra.CfnKeyspace.ReplicationSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicationSpecificationProperty.Jsii$Proxy that = (ReplicationSpecificationProperty.Jsii$Proxy) o;

                if (this.regionList != null ? !this.regionList.equals(that.regionList) : that.regionList != null) return false;
                return this.replicationStrategy != null ? this.replicationStrategy.equals(that.replicationStrategy) : that.replicationStrategy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.regionList != null ? this.regionList.hashCode() : 0;
                result = 31 * result + (this.replicationStrategy != null ? this.replicationStrategy.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cassandra.CfnKeyspace}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cassandra.CfnKeyspace> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.cassandra.CfnKeyspaceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Indicates whether client-side timestamps are enabled (true) or disabled (false) for all tables in the keyspace.
         * <p>
         * To add a Region to a single-Region keyspace with at least one table, the value must be set to true. After you've enabled client-side timestamps for a table, you can’t disable it again.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html#cfn-cassandra-keyspace-clientsidetimestampsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html#cfn-cassandra-keyspace-clientsidetimestampsenabled</a>
         * @param clientSideTimestampsEnabled Indicates whether client-side timestamps are enabled (true) or disabled (false) for all tables in the keyspace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientSideTimestampsEnabled(final java.lang.Boolean clientSideTimestampsEnabled) {
            this.props().clientSideTimestampsEnabled(clientSideTimestampsEnabled);
            return this;
        }
        /**
         * Indicates whether client-side timestamps are enabled (true) or disabled (false) for all tables in the keyspace.
         * <p>
         * To add a Region to a single-Region keyspace with at least one table, the value must be set to true. After you've enabled client-side timestamps for a table, you can’t disable it again.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html#cfn-cassandra-keyspace-clientsidetimestampsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html#cfn-cassandra-keyspace-clientsidetimestampsenabled</a>
         * @param clientSideTimestampsEnabled Indicates whether client-side timestamps are enabled (true) or disabled (false) for all tables in the keyspace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientSideTimestampsEnabled(final software.amazon.awscdk.IResolvable clientSideTimestampsEnabled) {
            this.props().clientSideTimestampsEnabled(clientSideTimestampsEnabled);
            return this;
        }

        /**
         * The name of the keyspace to be created.
         * <p>
         * The keyspace name is case sensitive. If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the keyspace name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name type</a> .
         * <p>
         * <em>Length constraints:</em> Minimum length of 3. Maximum length of 255.
         * <p>
         * <em>Pattern:</em> <code>^[a-zA-Z0-9][a-zA-Z0-9_]{1,47}$</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html#cfn-cassandra-keyspace-keyspacename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html#cfn-cassandra-keyspace-keyspacename</a>
         * @param keyspaceName The name of the keyspace to be created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyspaceName(final java.lang.String keyspaceName) {
            this.props().keyspaceName(keyspaceName);
            return this;
        }

        /**
         * Specifies the <code>ReplicationStrategy</code> of a keyspace. The options are:.
         * <p>
         * <ul>
         * <li><code>SINGLE_REGION</code> for a single Region keyspace (optional) or</li>
         * <li><code>MULTI_REGION</code> for a multi-Region keyspace</li>
         * </ul>
         * <p>
         * If no <code>ReplicationStrategy</code> is provided, the default is <code>SINGLE_REGION</code> . If you choose <code>MULTI_REGION</code> , you must also provide a <code>RegionList</code> with the AWS Regions that the keyspace is replicated in.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html#cfn-cassandra-keyspace-replicationspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html#cfn-cassandra-keyspace-replicationspecification</a>
         * @param replicationSpecification Specifies the <code>ReplicationStrategy</code> of a keyspace. The options are:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationSpecification(final software.amazon.awscdk.IResolvable replicationSpecification) {
            this.props().replicationSpecification(replicationSpecification);
            return this;
        }
        /**
         * Specifies the <code>ReplicationStrategy</code> of a keyspace. The options are:.
         * <p>
         * <ul>
         * <li><code>SINGLE_REGION</code> for a single Region keyspace (optional) or</li>
         * <li><code>MULTI_REGION</code> for a multi-Region keyspace</li>
         * </ul>
         * <p>
         * If no <code>ReplicationStrategy</code> is provided, the default is <code>SINGLE_REGION</code> . If you choose <code>MULTI_REGION</code> , you must also provide a <code>RegionList</code> with the AWS Regions that the keyspace is replicated in.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html#cfn-cassandra-keyspace-replicationspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html#cfn-cassandra-keyspace-replicationspecification</a>
         * @param replicationSpecification Specifies the <code>ReplicationStrategy</code> of a keyspace. The options are:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationSpecification(final software.amazon.awscdk.services.cassandra.CfnKeyspace.ReplicationSpecificationProperty replicationSpecification) {
            this.props().replicationSpecification(replicationSpecification);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html#cfn-cassandra-keyspace-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html#cfn-cassandra-keyspace-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cassandra.CfnKeyspace}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cassandra.CfnKeyspace build() {
            return new software.amazon.awscdk.services.cassandra.CfnKeyspace(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cassandra.CfnKeyspaceProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cassandra.CfnKeyspaceProps.Builder();
            }
            return this.props;
        }
    }
}
