package software.amazon.awscdk.services.ce;

/**
 * Properties for defining a <code>CfnCostCategory</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ce.*;
 * CfnCostCategoryProps cfnCostCategoryProps = CfnCostCategoryProps.builder()
 *         .name("name")
 *         .rules("rules")
 *         .ruleVersion("ruleVersion")
 *         // the properties below are optional
 *         .defaultValue("defaultValue")
 *         .splitChargeRules("splitChargeRules")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-costcategory.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-costcategory.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:20.627Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ce.CfnCostCategoryProps")
@software.amazon.jsii.Jsii.Proxy(CfnCostCategoryProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCostCategoryProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique name of the Cost Category.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-costcategory.html#cfn-ce-costcategory-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-costcategory.html#cfn-ce-costcategory-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The array of CostCategoryRule in JSON array format.
     * <p>
     * <blockquote>
     * <p>
     * Rules are processed in order. If there are multiple rules that match the line item, then the first rule to match is used to determine that Cost Category value.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-costcategory.html#cfn-ce-costcategory-rules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-costcategory.html#cfn-ce-costcategory-rules</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRules();

    /**
     * The rule schema version in this particular Cost Category.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-costcategory.html#cfn-ce-costcategory-ruleversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-costcategory.html#cfn-ce-costcategory-ruleversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRuleVersion();

    /**
     * The default value for the cost category.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-costcategory.html#cfn-ce-costcategory-defaultvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-costcategory.html#cfn-ce-costcategory-defaultvalue</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultValue() {
        return null;
    }

    /**
     * The split charge rules that are used to allocate your charges between your Cost Category values.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-costcategory.html#cfn-ce-costcategory-splitchargerules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ce-costcategory.html#cfn-ce-costcategory-splitchargerules</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSplitChargeRules() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCostCategoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCostCategoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCostCategoryProps> {
        java.lang.String name;
        java.lang.String rules;
        java.lang.String ruleVersion;
        java.lang.String defaultValue;
        java.lang.String splitChargeRules;

        /**
         * Sets the value of {@link CfnCostCategoryProps#getName}
         * @param name The unique name of the Cost Category. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnCostCategoryProps#getRules}
         * @param rules The array of CostCategoryRule in JSON array format. This parameter is required.
         *              <blockquote>
         *              <p>
         *              Rules are processed in order. If there are multiple rules that match the line item, then the first rule to match is used to determine that Cost Category value.
         *              <p>
         *              </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rules(java.lang.String rules) {
            this.rules = rules;
            return this;
        }

        /**
         * Sets the value of {@link CfnCostCategoryProps#getRuleVersion}
         * @param ruleVersion The rule schema version in this particular Cost Category. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleVersion(java.lang.String ruleVersion) {
            this.ruleVersion = ruleVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnCostCategoryProps#getDefaultValue}
         * @param defaultValue The default value for the cost category.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultValue(java.lang.String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        /**
         * Sets the value of {@link CfnCostCategoryProps#getSplitChargeRules}
         * @param splitChargeRules The split charge rules that are used to allocate your charges between your Cost Category values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder splitChargeRules(java.lang.String splitChargeRules) {
            this.splitChargeRules = splitChargeRules;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCostCategoryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCostCategoryProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCostCategoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCostCategoryProps {
        private final java.lang.String name;
        private final java.lang.String rules;
        private final java.lang.String ruleVersion;
        private final java.lang.String defaultValue;
        private final java.lang.String splitChargeRules;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ruleVersion = software.amazon.jsii.Kernel.get(this, "ruleVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultValue = software.amazon.jsii.Kernel.get(this, "defaultValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.splitChargeRules = software.amazon.jsii.Kernel.get(this, "splitChargeRules", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.rules = java.util.Objects.requireNonNull(builder.rules, "rules is required");
            this.ruleVersion = java.util.Objects.requireNonNull(builder.ruleVersion, "ruleVersion is required");
            this.defaultValue = builder.defaultValue;
            this.splitChargeRules = builder.splitChargeRules;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getRules() {
            return this.rules;
        }

        @Override
        public final java.lang.String getRuleVersion() {
            return this.ruleVersion;
        }

        @Override
        public final java.lang.String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public final java.lang.String getSplitChargeRules() {
            return this.splitChargeRules;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("rules", om.valueToTree(this.getRules()));
            data.set("ruleVersion", om.valueToTree(this.getRuleVersion()));
            if (this.getDefaultValue() != null) {
                data.set("defaultValue", om.valueToTree(this.getDefaultValue()));
            }
            if (this.getSplitChargeRules() != null) {
                data.set("splitChargeRules", om.valueToTree(this.getSplitChargeRules()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ce.CfnCostCategoryProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCostCategoryProps.Jsii$Proxy that = (CfnCostCategoryProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!rules.equals(that.rules)) return false;
            if (!ruleVersion.equals(that.ruleVersion)) return false;
            if (this.defaultValue != null ? !this.defaultValue.equals(that.defaultValue) : that.defaultValue != null) return false;
            return this.splitChargeRules != null ? this.splitChargeRules.equals(that.splitChargeRules) : that.splitChargeRules == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.rules.hashCode());
            result = 31 * result + (this.ruleVersion.hashCode());
            result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
            result = 31 * result + (this.splitChargeRules != null ? this.splitChargeRules.hashCode() : 0);
            return result;
        }
    }
}
