package software.amazon.awscdk.services.cloudwatch;

/**
 * Options for {@link DashboardVariable}.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cloudwatch.*;
 * Dashboard dashboard = Dashboard.Builder.create(this, "Dash")
 *         .defaultInterval(Duration.days(7))
 *         .variables(List.of(DashboardVariable.Builder.create()
 *                 .id("functionName")
 *                 .type(VariableType.PATTERN)
 *                 .label("Function")
 *                 .inputType(VariableInputType.RADIO)
 *                 .value("originalFuncNameInDashboard")
 *                 // equivalent to cw.Values.fromSearch('{AWS/Lambda,FunctionName} MetricName=\"Duration\"', 'FunctionName')
 *                 .values(Values.fromSearchComponents(SearchComponents.builder()
 *                         .namespace("AWS/Lambda")
 *                         .dimensions(List.of("FunctionName"))
 *                         .metricName("Duration")
 *                         .populateFrom("FunctionName")
 *                         .build()))
 *                 .defaultValue(DefaultValue.FIRST)
 *                 .visible(true)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:21.176Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.DashboardVariableOptions")
@software.amazon.jsii.Jsii.Proxy(DashboardVariableOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DashboardVariableOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Unique id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getId();

    /**
     * The way the variable value is selected.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.VariableInputType getInputType();

    /**
     * Type of the variable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.VariableType getType();

    /**
     * Pattern or property value to replace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getValue();

    /**
     * Optional default value.
     * <p>
     * Default: - no default value is set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.DefaultValue getDefaultValue() {
        return null;
    }

    /**
     * Optional label in the toolbar.
     * <p>
     * Default: - the variable's value
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLabel() {
        return null;
    }

    /**
     * Optional values (required for {@link VariableInputType.RADIO} and {@link VariableInputType.SELECT} dashboard variables).
     * <p>
     * Default: - no values
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.Values getValues() {
        return null;
    }

    /**
     * Whether the variable is visible.
     * <p>
     * Default: - true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getVisible() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DashboardVariableOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DashboardVariableOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DashboardVariableOptions> {
        java.lang.String id;
        software.amazon.awscdk.services.cloudwatch.VariableInputType inputType;
        software.amazon.awscdk.services.cloudwatch.VariableType type;
        java.lang.String value;
        software.amazon.awscdk.services.cloudwatch.DefaultValue defaultValue;
        java.lang.String label;
        software.amazon.awscdk.services.cloudwatch.Values values;
        java.lang.Boolean visible;

        /**
         * Sets the value of {@link DashboardVariableOptions#getId}
         * @param id Unique id. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link DashboardVariableOptions#getInputType}
         * @param inputType The way the variable value is selected. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputType(software.amazon.awscdk.services.cloudwatch.VariableInputType inputType) {
            this.inputType = inputType;
            return this;
        }

        /**
         * Sets the value of {@link DashboardVariableOptions#getType}
         * @param type Type of the variable. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.cloudwatch.VariableType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link DashboardVariableOptions#getValue}
         * @param value Pattern or property value to replace. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder value(java.lang.String value) {
            this.value = value;
            return this;
        }

        /**
         * Sets the value of {@link DashboardVariableOptions#getDefaultValue}
         * @param defaultValue Optional default value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultValue(software.amazon.awscdk.services.cloudwatch.DefaultValue defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        /**
         * Sets the value of {@link DashboardVariableOptions#getLabel}
         * @param label Optional label in the toolbar.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder label(java.lang.String label) {
            this.label = label;
            return this;
        }

        /**
         * Sets the value of {@link DashboardVariableOptions#getValues}
         * @param values Optional values (required for {@link VariableInputType.RADIO} and {@link VariableInputType.SELECT} dashboard variables).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder values(software.amazon.awscdk.services.cloudwatch.Values values) {
            this.values = values;
            return this;
        }

        /**
         * Sets the value of {@link DashboardVariableOptions#getVisible}
         * @param visible Whether the variable is visible.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visible(java.lang.Boolean visible) {
            this.visible = visible;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DashboardVariableOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DashboardVariableOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DashboardVariableOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DashboardVariableOptions {
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudwatch.VariableInputType inputType;
        private final software.amazon.awscdk.services.cloudwatch.VariableType type;
        private final java.lang.String value;
        private final software.amazon.awscdk.services.cloudwatch.DefaultValue defaultValue;
        private final java.lang.String label;
        private final software.amazon.awscdk.services.cloudwatch.Values values;
        private final java.lang.Boolean visible;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.inputType = software.amazon.jsii.Kernel.get(this, "inputType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.VariableInputType.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.VariableType.class));
            this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultValue = software.amazon.jsii.Kernel.get(this, "defaultValue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.DefaultValue.class));
            this.label = software.amazon.jsii.Kernel.get(this, "label", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Values.class));
            this.visible = software.amazon.jsii.Kernel.get(this, "visible", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
            this.inputType = java.util.Objects.requireNonNull(builder.inputType, "inputType is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            this.defaultValue = builder.defaultValue;
            this.label = builder.label;
            this.values = builder.values;
            this.visible = builder.visible;
        }

        @Override
        public final java.lang.String getId() {
            return this.id;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.VariableInputType getInputType() {
            return this.inputType;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.VariableType getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getValue() {
            return this.value;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.DefaultValue getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public final java.lang.String getLabel() {
            return this.label;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.Values getValues() {
            return this.values;
        }

        @Override
        public final java.lang.Boolean getVisible() {
            return this.visible;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("id", om.valueToTree(this.getId()));
            data.set("inputType", om.valueToTree(this.getInputType()));
            data.set("type", om.valueToTree(this.getType()));
            data.set("value", om.valueToTree(this.getValue()));
            if (this.getDefaultValue() != null) {
                data.set("defaultValue", om.valueToTree(this.getDefaultValue()));
            }
            if (this.getLabel() != null) {
                data.set("label", om.valueToTree(this.getLabel()));
            }
            if (this.getValues() != null) {
                data.set("values", om.valueToTree(this.getValues()));
            }
            if (this.getVisible() != null) {
                data.set("visible", om.valueToTree(this.getVisible()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.DashboardVariableOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DashboardVariableOptions.Jsii$Proxy that = (DashboardVariableOptions.Jsii$Proxy) o;

            if (!id.equals(that.id)) return false;
            if (!inputType.equals(that.inputType)) return false;
            if (!type.equals(that.type)) return false;
            if (!value.equals(that.value)) return false;
            if (this.defaultValue != null ? !this.defaultValue.equals(that.defaultValue) : that.defaultValue != null) return false;
            if (this.label != null ? !this.label.equals(that.label) : that.label != null) return false;
            if (this.values != null ? !this.values.equals(that.values) : that.values != null) return false;
            return this.visible != null ? this.visible.equals(that.visible) : that.visible == null;
        }

        @Override
        public final int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + (this.inputType.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.value.hashCode());
            result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
            result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
            result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
            result = 31 * result + (this.visible != null ? this.visible.hashCode() : 0);
            return result;
        }
    }
}
