package software.amazon.awscdk.services.cloudwatch;

/**
 * Default value for use in {@link DashboardVariableOptions}.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cloudwatch.*;
 * Dashboard dashboard = Dashboard.Builder.create(this, "Dash")
 *         .defaultInterval(Duration.days(7))
 *         .variables(List.of(DashboardVariable.Builder.create()
 *                 .id("functionName")
 *                 .type(VariableType.PATTERN)
 *                 .label("Function")
 *                 .inputType(VariableInputType.RADIO)
 *                 .value("originalFuncNameInDashboard")
 *                 // equivalent to cw.Values.fromSearch('{AWS/Lambda,FunctionName} MetricName=\"Duration\"', 'FunctionName')
 *                 .values(Values.fromSearchComponents(SearchComponents.builder()
 *                         .namespace("AWS/Lambda")
 *                         .dimensions(List.of("FunctionName"))
 *                         .metricName("Duration")
 *                         .populateFrom("FunctionName")
 *                         .build()))
 *                 .defaultValue(DefaultValue.FIRST)
 *                 .visible(true)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:21.188Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.DefaultValue")
public class DefaultValue extends software.amazon.jsii.JsiiObject {

    protected DefaultValue(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DefaultValue(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        FIRST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudwatch.DefaultValue.class, "FIRST", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.DefaultValue.class));
    }

    /**
     * Create a default value.
     * <p>
     * @param value the value to be used as default. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.DefaultValue value(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.DefaultValue.class, "value", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.DefaultValue.class), new Object[] { value });
    }

    /**
     * A special value for use with search expressions to have the default value be the first value returned from search.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cloudwatch.DefaultValue FIRST;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getVal() {
        return software.amazon.jsii.Kernel.get(this, "val", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }
}
