package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Construction properties of the <code>GitHubSourceAction GitHub source action</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Read the secret from Secrets Manager
 * Pipeline pipeline = new Pipeline(this, "MyPipeline");
 * Artifact sourceOutput = new Artifact();
 * GitHubSourceAction sourceAction = GitHubSourceAction.Builder.create()
 *         .actionName("GitHub_Source")
 *         .owner("awslabs")
 *         .repo("aws-cdk")
 *         .oauthToken(SecretValue.secretsManager("my-github-token"))
 *         .output(sourceOutput)
 *         .branch("develop")
 *         .build();
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("Source")
 *         .actions(List.of(sourceAction))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:21.672Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.GitHubSourceActionProps")
@software.amazon.jsii.Jsii.Proxy(GitHubSourceActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GitHubSourceActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.CommonActionProps {

    /**
     * A GitHub OAuth token to use for authentication.
     * <p>
     * It is recommended to use a Secrets Manager <code>Secret</code> to obtain the token:
     * <p>
     * const oauth = cdk.SecretValue.secretsManager('my-github-token');
     * new GitHubSourceAction(this, 'GitHubAction', { oauthToken: oauth, ... });
     * <p>
     * If you rotate the value in the Secret, you must also change at least one property
     * of the CodePipeline to force CloudFormation to re-read the secret.
     * <p>
     * The GitHub Personal Access Token should have these scopes:
     * <p>
     * <ul>
     * <li><strong>repo</strong> - to read the repository</li>
     * <li><strong>admin:repo_hook</strong> - if you plan to use webhooks (true by default)</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/appendix-github-oauth.html#GitHub-create-personal-token-CLI">https://docs.aws.amazon.com/codepipeline/latest/userguide/appendix-github-oauth.html#GitHub-create-personal-token-CLI</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue getOauthToken();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact getOutput();

    /**
     * The GitHub account/user that owns the repo.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOwner();

    /**
     * The name of the repo, without the username.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRepo();

    /**
     * The branch to use.
     * <p>
     * Default: "master"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBranch() {
        return null;
    }

    /**
     * How AWS CodePipeline should be triggered.
     * <p>
     * With the default value "WEBHOOK", a webhook is created in GitHub that triggers the action
     * With "POLL", CodePipeline periodically checks the source for changes
     * With "None", the action is not triggered through changes in the source
     * <p>
     * To use <code>WEBHOOK</code>, your GitHub Personal Access Token should have
     * <strong>admin:repo_hook</strong> scope (in addition to the regular <strong>repo</strong> scope).
     * <p>
     * Default: GitHubTrigger.WEBHOOK
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.actions.GitHubTrigger getTrigger() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GitHubSourceActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GitHubSourceActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GitHubSourceActionProps> {
        software.amazon.awscdk.SecretValue oauthToken;
        software.amazon.awscdk.services.codepipeline.Artifact output;
        java.lang.String owner;
        java.lang.String repo;
        java.lang.String branch;
        software.amazon.awscdk.services.codepipeline.actions.GitHubTrigger trigger;
        java.lang.String actionName;
        java.lang.Number runOrder;
        java.lang.String variablesNamespace;

        /**
         * Sets the value of {@link GitHubSourceActionProps#getOauthToken}
         * @param oauthToken A GitHub OAuth token to use for authentication. This parameter is required.
         *                   It is recommended to use a Secrets Manager <code>Secret</code> to obtain the token:
         *                   <p>
         *                   const oauth = cdk.SecretValue.secretsManager('my-github-token');
         *                   new GitHubSourceAction(this, 'GitHubAction', { oauthToken: oauth, ... });
         *                   <p>
         *                   If you rotate the value in the Secret, you must also change at least one property
         *                   of the CodePipeline to force CloudFormation to re-read the secret.
         *                   <p>
         *                   The GitHub Personal Access Token should have these scopes:
         *                   <p>
         *                   <ul>
         *                   <li><strong>repo</strong> - to read the repository</li>
         *                   <li><strong>admin:repo_hook</strong> - if you plan to use webhooks (true by default)</li>
         *                   </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder oauthToken(software.amazon.awscdk.SecretValue oauthToken) {
            this.oauthToken = oauthToken;
            return this;
        }

        /**
         * Sets the value of {@link GitHubSourceActionProps#getOutput}
         * @param output the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder output(software.amazon.awscdk.services.codepipeline.Artifact output) {
            this.output = output;
            return this;
        }

        /**
         * Sets the value of {@link GitHubSourceActionProps#getOwner}
         * @param owner The GitHub account/user that owns the repo. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder owner(java.lang.String owner) {
            this.owner = owner;
            return this;
        }

        /**
         * Sets the value of {@link GitHubSourceActionProps#getRepo}
         * @param repo The name of the repo, without the username. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repo(java.lang.String repo) {
            this.repo = repo;
            return this;
        }

        /**
         * Sets the value of {@link GitHubSourceActionProps#getBranch}
         * @param branch The branch to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder branch(java.lang.String branch) {
            this.branch = branch;
            return this;
        }

        /**
         * Sets the value of {@link GitHubSourceActionProps#getTrigger}
         * @param trigger How AWS CodePipeline should be triggered.
         *                With the default value "WEBHOOK", a webhook is created in GitHub that triggers the action
         *                With "POLL", CodePipeline periodically checks the source for changes
         *                With "None", the action is not triggered through changes in the source
         *                <p>
         *                To use <code>WEBHOOK</code>, your GitHub Personal Access Token should have
         *                <strong>admin:repo_hook</strong> scope (in addition to the regular <strong>repo</strong> scope).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trigger(software.amazon.awscdk.services.codepipeline.actions.GitHubTrigger trigger) {
            this.trigger = trigger;
            return this;
        }

        /**
         * Sets the value of {@link GitHubSourceActionProps#getActionName}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         *                   Note that Action names must be unique within a single Stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link GitHubSourceActionProps#getRunOrder}
         * @param runOrder The runOrder property for this Action.
         *                 RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(java.lang.Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        /**
         * Sets the value of {@link GitHubSourceActionProps#getVariablesNamespace}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(java.lang.String variablesNamespace) {
            this.variablesNamespace = variablesNamespace;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GitHubSourceActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GitHubSourceActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GitHubSourceActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GitHubSourceActionProps {
        private final software.amazon.awscdk.SecretValue oauthToken;
        private final software.amazon.awscdk.services.codepipeline.Artifact output;
        private final java.lang.String owner;
        private final java.lang.String repo;
        private final java.lang.String branch;
        private final software.amazon.awscdk.services.codepipeline.actions.GitHubTrigger trigger;
        private final java.lang.String actionName;
        private final java.lang.Number runOrder;
        private final java.lang.String variablesNamespace;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.oauthToken = software.amazon.jsii.Kernel.get(this, "oauthToken", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class));
            this.output = software.amazon.jsii.Kernel.get(this, "output", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class));
            this.owner = software.amazon.jsii.Kernel.get(this, "owner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.repo = software.amazon.jsii.Kernel.get(this, "repo", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.branch = software.amazon.jsii.Kernel.get(this, "branch", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.trigger = software.amazon.jsii.Kernel.get(this, "trigger", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.GitHubTrigger.class));
            this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runOrder = software.amazon.jsii.Kernel.get(this, "runOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.variablesNamespace = software.amazon.jsii.Kernel.get(this, "variablesNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.oauthToken = java.util.Objects.requireNonNull(builder.oauthToken, "oauthToken is required");
            this.output = java.util.Objects.requireNonNull(builder.output, "output is required");
            this.owner = java.util.Objects.requireNonNull(builder.owner, "owner is required");
            this.repo = java.util.Objects.requireNonNull(builder.repo, "repo is required");
            this.branch = builder.branch;
            this.trigger = builder.trigger;
            this.actionName = java.util.Objects.requireNonNull(builder.actionName, "actionName is required");
            this.runOrder = builder.runOrder;
            this.variablesNamespace = builder.variablesNamespace;
        }

        @Override
        public final software.amazon.awscdk.SecretValue getOauthToken() {
            return this.oauthToken;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Artifact getOutput() {
            return this.output;
        }

        @Override
        public final java.lang.String getOwner() {
            return this.owner;
        }

        @Override
        public final java.lang.String getRepo() {
            return this.repo;
        }

        @Override
        public final java.lang.String getBranch() {
            return this.branch;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.actions.GitHubTrigger getTrigger() {
            return this.trigger;
        }

        @Override
        public final java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public final java.lang.Number getRunOrder() {
            return this.runOrder;
        }

        @Override
        public final java.lang.String getVariablesNamespace() {
            return this.variablesNamespace;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("oauthToken", om.valueToTree(this.getOauthToken()));
            data.set("output", om.valueToTree(this.getOutput()));
            data.set("owner", om.valueToTree(this.getOwner()));
            data.set("repo", om.valueToTree(this.getRepo()));
            if (this.getBranch() != null) {
                data.set("branch", om.valueToTree(this.getBranch()));
            }
            if (this.getTrigger() != null) {
                data.set("trigger", om.valueToTree(this.getTrigger()));
            }
            data.set("actionName", om.valueToTree(this.getActionName()));
            if (this.getRunOrder() != null) {
                data.set("runOrder", om.valueToTree(this.getRunOrder()));
            }
            if (this.getVariablesNamespace() != null) {
                data.set("variablesNamespace", om.valueToTree(this.getVariablesNamespace()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.GitHubSourceActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GitHubSourceActionProps.Jsii$Proxy that = (GitHubSourceActionProps.Jsii$Proxy) o;

            if (!oauthToken.equals(that.oauthToken)) return false;
            if (!output.equals(that.output)) return false;
            if (!owner.equals(that.owner)) return false;
            if (!repo.equals(that.repo)) return false;
            if (this.branch != null ? !this.branch.equals(that.branch) : that.branch != null) return false;
            if (this.trigger != null ? !this.trigger.equals(that.trigger) : that.trigger != null) return false;
            if (!actionName.equals(that.actionName)) return false;
            if (this.runOrder != null ? !this.runOrder.equals(that.runOrder) : that.runOrder != null) return false;
            return this.variablesNamespace != null ? this.variablesNamespace.equals(that.variablesNamespace) : that.variablesNamespace == null;
        }

        @Override
        public final int hashCode() {
            int result = this.oauthToken.hashCode();
            result = 31 * result + (this.output.hashCode());
            result = 31 * result + (this.owner.hashCode());
            result = 31 * result + (this.repo.hashCode());
            result = 31 * result + (this.branch != null ? this.branch.hashCode() : 0);
            result = 31 * result + (this.trigger != null ? this.trigger.hashCode() : 0);
            result = 31 * result + (this.actionName.hashCode());
            result = 31 * result + (this.runOrder != null ? this.runOrder.hashCode() : 0);
            result = 31 * result + (this.variablesNamespace != null ? this.variablesNamespace.hashCode() : 0);
            return result;
        }
    }
}
