package software.amazon.awscdk.services.cognito;

/**
 * Properties to initialize UserPoolIdentityProviderOidc.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * ProviderAttribute providerAttribute;
 * UserPool userPool;
 * UserPoolIdentityProviderOidcProps userPoolIdentityProviderOidcProps = UserPoolIdentityProviderOidcProps.builder()
 *         .clientId("clientId")
 *         .clientSecret("clientSecret")
 *         .issuerUrl("issuerUrl")
 *         .userPool(userPool)
 *         // the properties below are optional
 *         .attributeMapping(AttributeMapping.builder()
 *                 .address(providerAttribute)
 *                 .birthdate(providerAttribute)
 *                 .custom(Map.of(
 *                         "customKey", providerAttribute))
 *                 .email(providerAttribute)
 *                 .emailVerified(providerAttribute)
 *                 .familyName(providerAttribute)
 *                 .fullname(providerAttribute)
 *                 .gender(providerAttribute)
 *                 .givenName(providerAttribute)
 *                 .lastUpdateTime(providerAttribute)
 *                 .locale(providerAttribute)
 *                 .middleName(providerAttribute)
 *                 .nickname(providerAttribute)
 *                 .phoneNumber(providerAttribute)
 *                 .preferredUsername(providerAttribute)
 *                 .profilePage(providerAttribute)
 *                 .profilePicture(providerAttribute)
 *                 .timezone(providerAttribute)
 *                 .website(providerAttribute)
 *                 .build())
 *         .attributeRequestMethod(OidcAttributeRequestMethod.GET)
 *         .endpoints(OidcEndpoints.builder()
 *                 .authorization("authorization")
 *                 .jwksUri("jwksUri")
 *                 .token("token")
 *                 .userInfo("userInfo")
 *                 .build())
 *         .identifiers(List.of("identifiers"))
 *         .name("name")
 *         .scopes(List.of("scopes"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:21.897Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserPoolIdentityProviderOidcProps")
@software.amazon.jsii.Jsii.Proxy(UserPoolIdentityProviderOidcProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UserPoolIdentityProviderOidcProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cognito.UserPoolIdentityProviderProps {

    /**
     * The client id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClientId();

    /**
     * The client secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClientSecret();

    /**
     * Issuer URL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIssuerUrl();

    /**
     * The method to use to request attributes.
     * <p>
     * Default: OidcAttributeRequestMethod.GET
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.OidcAttributeRequestMethod getAttributeRequestMethod() {
        return null;
    }

    /**
     * OpenID connect endpoints.
     * <p>
     * Default: - auto discovered with issuer URL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.OidcEndpoints getEndpoints() {
        return null;
    }

    /**
     * Identifiers.
     * <p>
     * Identifiers can be used to redirect users to the correct IdP in multitenant apps.
     * <p>
     * Default: - no identifiers used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIdentifiers() {
        return null;
    }

    /**
     * The name of the provider.
     * <p>
     * Default: - the unique ID of the construct
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The OAuth 2.0 scopes that you will request from OpenID Connect. Scopes are groups of OpenID Connect user attributes to exchange with your app.
     * <p>
     * Default: ['openid']
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getScopes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UserPoolIdentityProviderOidcProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserPoolIdentityProviderOidcProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UserPoolIdentityProviderOidcProps> {
        java.lang.String clientId;
        java.lang.String clientSecret;
        java.lang.String issuerUrl;
        software.amazon.awscdk.services.cognito.OidcAttributeRequestMethod attributeRequestMethod;
        software.amazon.awscdk.services.cognito.OidcEndpoints endpoints;
        java.util.List<java.lang.String> identifiers;
        java.lang.String name;
        java.util.List<java.lang.String> scopes;
        software.amazon.awscdk.services.cognito.IUserPool userPool;
        software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping;

        /**
         * Sets the value of {@link UserPoolIdentityProviderOidcProps#getClientId}
         * @param clientId The client id. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientId(java.lang.String clientId) {
            this.clientId = clientId;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderOidcProps#getClientSecret}
         * @param clientSecret The client secret. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientSecret(java.lang.String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderOidcProps#getIssuerUrl}
         * @param issuerUrl Issuer URL. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder issuerUrl(java.lang.String issuerUrl) {
            this.issuerUrl = issuerUrl;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderOidcProps#getAttributeRequestMethod}
         * @param attributeRequestMethod The method to use to request attributes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributeRequestMethod(software.amazon.awscdk.services.cognito.OidcAttributeRequestMethod attributeRequestMethod) {
            this.attributeRequestMethod = attributeRequestMethod;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderOidcProps#getEndpoints}
         * @param endpoints OpenID connect endpoints.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoints(software.amazon.awscdk.services.cognito.OidcEndpoints endpoints) {
            this.endpoints = endpoints;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderOidcProps#getIdentifiers}
         * @param identifiers Identifiers.
         *                    Identifiers can be used to redirect users to the correct IdP in multitenant apps.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identifiers(java.util.List<java.lang.String> identifiers) {
            this.identifiers = identifiers;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderOidcProps#getName}
         * @param name The name of the provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderOidcProps#getScopes}
         * @param scopes The OAuth 2.0 scopes that you will request from OpenID Connect. Scopes are groups of OpenID Connect user attributes to exchange with your app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scopes(java.util.List<java.lang.String> scopes) {
            this.scopes = scopes;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderOidcProps#getUserPool}
         * @param userPool The user pool to which this construct provides identities. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPool(software.amazon.awscdk.services.cognito.IUserPool userPool) {
            this.userPool = userPool;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderOidcProps#getAttributeMapping}
         * @param attributeMapping Mapping attributes from the identity provider to standard and custom attributes of the user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributeMapping(software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping) {
            this.attributeMapping = attributeMapping;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserPoolIdentityProviderOidcProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UserPoolIdentityProviderOidcProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UserPoolIdentityProviderOidcProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolIdentityProviderOidcProps {
        private final java.lang.String clientId;
        private final java.lang.String clientSecret;
        private final java.lang.String issuerUrl;
        private final software.amazon.awscdk.services.cognito.OidcAttributeRequestMethod attributeRequestMethod;
        private final software.amazon.awscdk.services.cognito.OidcEndpoints endpoints;
        private final java.util.List<java.lang.String> identifiers;
        private final java.lang.String name;
        private final java.util.List<java.lang.String> scopes;
        private final software.amazon.awscdk.services.cognito.IUserPool userPool;
        private final software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clientSecret = software.amazon.jsii.Kernel.get(this, "clientSecret", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.issuerUrl = software.amazon.jsii.Kernel.get(this, "issuerUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.attributeRequestMethod = software.amazon.jsii.Kernel.get(this, "attributeRequestMethod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.OidcAttributeRequestMethod.class));
            this.endpoints = software.amazon.jsii.Kernel.get(this, "endpoints", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.OidcEndpoints.class));
            this.identifiers = software.amazon.jsii.Kernel.get(this, "identifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scopes = software.amazon.jsii.Kernel.get(this, "scopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.userPool = software.amazon.jsii.Kernel.get(this, "userPool", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.IUserPool.class));
            this.attributeMapping = software.amazon.jsii.Kernel.get(this, "attributeMapping", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.AttributeMapping.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clientId = java.util.Objects.requireNonNull(builder.clientId, "clientId is required");
            this.clientSecret = java.util.Objects.requireNonNull(builder.clientSecret, "clientSecret is required");
            this.issuerUrl = java.util.Objects.requireNonNull(builder.issuerUrl, "issuerUrl is required");
            this.attributeRequestMethod = builder.attributeRequestMethod;
            this.endpoints = builder.endpoints;
            this.identifiers = builder.identifiers;
            this.name = builder.name;
            this.scopes = builder.scopes;
            this.userPool = java.util.Objects.requireNonNull(builder.userPool, "userPool is required");
            this.attributeMapping = builder.attributeMapping;
        }

        @Override
        public final java.lang.String getClientId() {
            return this.clientId;
        }

        @Override
        public final java.lang.String getClientSecret() {
            return this.clientSecret;
        }

        @Override
        public final java.lang.String getIssuerUrl() {
            return this.issuerUrl;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.OidcAttributeRequestMethod getAttributeRequestMethod() {
            return this.attributeRequestMethod;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.OidcEndpoints getEndpoints() {
            return this.endpoints;
        }

        @Override
        public final java.util.List<java.lang.String> getIdentifiers() {
            return this.identifiers;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<java.lang.String> getScopes() {
            return this.scopes;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.IUserPool getUserPool() {
            return this.userPool;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.AttributeMapping getAttributeMapping() {
            return this.attributeMapping;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clientId", om.valueToTree(this.getClientId()));
            data.set("clientSecret", om.valueToTree(this.getClientSecret()));
            data.set("issuerUrl", om.valueToTree(this.getIssuerUrl()));
            if (this.getAttributeRequestMethod() != null) {
                data.set("attributeRequestMethod", om.valueToTree(this.getAttributeRequestMethod()));
            }
            if (this.getEndpoints() != null) {
                data.set("endpoints", om.valueToTree(this.getEndpoints()));
            }
            if (this.getIdentifiers() != null) {
                data.set("identifiers", om.valueToTree(this.getIdentifiers()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getScopes() != null) {
                data.set("scopes", om.valueToTree(this.getScopes()));
            }
            data.set("userPool", om.valueToTree(this.getUserPool()));
            if (this.getAttributeMapping() != null) {
                data.set("attributeMapping", om.valueToTree(this.getAttributeMapping()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.UserPoolIdentityProviderOidcProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserPoolIdentityProviderOidcProps.Jsii$Proxy that = (UserPoolIdentityProviderOidcProps.Jsii$Proxy) o;

            if (!clientId.equals(that.clientId)) return false;
            if (!clientSecret.equals(that.clientSecret)) return false;
            if (!issuerUrl.equals(that.issuerUrl)) return false;
            if (this.attributeRequestMethod != null ? !this.attributeRequestMethod.equals(that.attributeRequestMethod) : that.attributeRequestMethod != null) return false;
            if (this.endpoints != null ? !this.endpoints.equals(that.endpoints) : that.endpoints != null) return false;
            if (this.identifiers != null ? !this.identifiers.equals(that.identifiers) : that.identifiers != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.scopes != null ? !this.scopes.equals(that.scopes) : that.scopes != null) return false;
            if (!userPool.equals(that.userPool)) return false;
            return this.attributeMapping != null ? this.attributeMapping.equals(that.attributeMapping) : that.attributeMapping == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clientId.hashCode();
            result = 31 * result + (this.clientSecret.hashCode());
            result = 31 * result + (this.issuerUrl.hashCode());
            result = 31 * result + (this.attributeRequestMethod != null ? this.attributeRequestMethod.hashCode() : 0);
            result = 31 * result + (this.endpoints != null ? this.endpoints.hashCode() : 0);
            result = 31 * result + (this.identifiers != null ? this.identifiers.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.scopes != null ? this.scopes.hashCode() : 0);
            result = 31 * result + (this.userPool.hashCode());
            result = 31 * result + (this.attributeMapping != null ? this.attributeMapping.hashCode() : 0);
            return result;
        }
    }
}
