package software.amazon.awscdk.services.datazone;

/**
 * The <code>AWS::DataZone::DataSource</code> resource specifies an Amazon DataZone data source that is used to import technical metadata of assets (data) from the source databases or data warehouses into Amazon DataZone.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datazone.*;
 * CfnDataSource cfnDataSource = CfnDataSource.Builder.create(this, "MyCfnDataSource")
 *         .domainIdentifier("domainIdentifier")
 *         .name("name")
 *         .projectIdentifier("projectIdentifier")
 *         .type("type")
 *         // the properties below are optional
 *         .assetFormsInput(List.of(FormInputProperty.builder()
 *                 .formName("formName")
 *                 // the properties below are optional
 *                 .content("content")
 *                 .typeIdentifier("typeIdentifier")
 *                 .typeRevision("typeRevision")
 *                 .build()))
 *         .configuration(DataSourceConfigurationInputProperty.builder()
 *                 .glueRunConfiguration(GlueRunConfigurationInputProperty.builder()
 *                         .relationalFilterConfigurations(List.of(RelationalFilterConfigurationProperty.builder()
 *                                 .databaseName("databaseName")
 *                                 // the properties below are optional
 *                                 .filterExpressions(List.of(FilterExpressionProperty.builder()
 *                                         .expression("expression")
 *                                         .type("type")
 *                                         .build()))
 *                                 .schemaName("schemaName")
 *                                 .build()))
 *                         // the properties below are optional
 *                         .autoImportDataQualityResult(false)
 *                         .catalogName("catalogName")
 *                         .dataAccessRole("dataAccessRole")
 *                         .build())
 *                 .redshiftRunConfiguration(RedshiftRunConfigurationInputProperty.builder()
 *                         .relationalFilterConfigurations(List.of(RelationalFilterConfigurationProperty.builder()
 *                                 .databaseName("databaseName")
 *                                 // the properties below are optional
 *                                 .filterExpressions(List.of(FilterExpressionProperty.builder()
 *                                         .expression("expression")
 *                                         .type("type")
 *                                         .build()))
 *                                 .schemaName("schemaName")
 *                                 .build()))
 *                         // the properties below are optional
 *                         .dataAccessRole("dataAccessRole")
 *                         .redshiftCredentialConfiguration(RedshiftCredentialConfigurationProperty.builder()
 *                                 .secretManagerArn("secretManagerArn")
 *                                 .build())
 *                         .redshiftStorage(RedshiftStorageProperty.builder()
 *                                 .redshiftClusterSource(RedshiftClusterStorageProperty.builder()
 *                                         .clusterName("clusterName")
 *                                         .build())
 *                                 .redshiftServerlessSource(RedshiftServerlessStorageProperty.builder()
 *                                         .workgroupName("workgroupName")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .sageMakerRunConfiguration(SageMakerRunConfigurationInputProperty.builder()
 *                         .trackingAssets(Map.of(
 *                                 "trackingAssetsKey", List.of("trackingAssets")))
 *                         .build())
 *                 .build())
 *         .connectionIdentifier("connectionIdentifier")
 *         .description("description")
 *         .enableSetting("enableSetting")
 *         .environmentIdentifier("environmentIdentifier")
 *         .publishOnImport(false)
 *         .recommendation(RecommendationConfigurationProperty.builder()
 *                 .enableBusinessNameGeneration(false)
 *                 .build())
 *         .schedule(ScheduleConfigurationProperty.builder()
 *                 .schedule("schedule")
 *                 .timezone("timezone")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:22.393Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnDataSource")
public class CfnDataSource extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDataSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.datazone.CfnDataSource.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.datazone.CfnDataSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The connection ID that's part of the data source summary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConnectionId() {
        return software.amazon.jsii.Kernel.get(this, "attrConnectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp of when the data source was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the Amazon DataZone domain in which the data source exists.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDomainId() {
        return software.amazon.jsii.Kernel.get(this, "attrDomainId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the environment in which the data source exists.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEnvironmentId() {
        return software.amazon.jsii.Kernel.get(this, "attrEnvironmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the data source run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The count of the assets created during the last data source run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrLastRunAssetCount() {
        return software.amazon.jsii.Kernel.get(this, "attrLastRunAssetCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The timestamp of when the data source run was last performed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastRunAt() {
        return software.amazon.jsii.Kernel.get(this, "attrLastRunAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the last data source run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastRunStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrLastRunStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The project ID included in the data source run activity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrProjectId() {
        return software.amazon.jsii.Kernel.get(this, "attrProjectId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp of when the data source was updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The ID of the Amazon DataZone domain where the data source is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "domainIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the Amazon DataZone domain where the data source is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainIdentifier(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainIdentifier", java.util.Objects.requireNonNull(value, "domainIdentifier is required"));
    }

    /**
     * The name of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The identifier of the Amazon DataZone project in which you want to add this data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProjectIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "projectIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the Amazon DataZone project in which you want to add this data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProjectIdentifier(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "projectIdentifier", java.util.Objects.requireNonNull(value, "projectIdentifier is required"));
    }

    /**
     * The type of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * The metadata forms attached to the assets that the data source works with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAssetFormsInput() {
        return software.amazon.jsii.Kernel.get(this, "assetFormsInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The metadata forms attached to the assets that the data source works with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetFormsInput(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "assetFormsInput", value);
    }

    /**
     * The metadata forms attached to the assets that the data source works with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetFormsInput(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.datazone.CfnDataSource.FormInputProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.datazone.CfnDataSource.FormInputProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "assetFormsInput", value);
    }

    /**
     * The configuration of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configuration", value);
    }

    /**
     * The configuration of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.datazone.CfnDataSource.DataSourceConfigurationInputProperty value) {
        software.amazon.jsii.Kernel.set(this, "configuration", value);
    }

    /**
     * The unique identifier of a connection used to fetch relevant parameters from connection during Datasource run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getConnectionIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "connectionIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of a connection used to fetch relevant parameters from connection during Datasource run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectionIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "connectionIdentifier", value);
    }

    /**
     * The description of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Specifies whether the data source is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEnableSetting() {
        return software.amazon.jsii.Kernel.get(this, "enableSetting", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether the data source is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableSetting(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "enableSetting", value);
    }

    /**
     * The unique identifier of the Amazon DataZone environment to which the data source publishes assets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEnvironmentIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "environmentIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the Amazon DataZone environment to which the data source publishes assets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironmentIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "environmentIdentifier", value);
    }

    /**
     * Specifies whether the assets that this data source creates in the inventory are to be also automatically published to the catalog.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPublishOnImport() {
        return software.amazon.jsii.Kernel.get(this, "publishOnImport", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the assets that this data source creates in the inventory are to be also automatically published to the catalog.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPublishOnImport(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "publishOnImport", value);
    }

    /**
     * Specifies whether the assets that this data source creates in the inventory are to be also automatically published to the catalog.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPublishOnImport(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "publishOnImport", value);
    }

    /**
     * Specifies whether the business name generation is to be enabled for this data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRecommendation() {
        return software.amazon.jsii.Kernel.get(this, "recommendation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the business name generation is to be enabled for this data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecommendation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "recommendation", value);
    }

    /**
     * Specifies whether the business name generation is to be enabled for this data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecommendation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.datazone.CfnDataSource.RecommendationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "recommendation", value);
    }

    /**
     * The schedule of the data source runs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSchedule() {
        return software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The schedule of the data source runs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "schedule", value);
    }

    /**
     * The schedule of the data source runs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.datazone.CfnDataSource.ScheduleConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "schedule", value);
    }
    /**
     * The configuration of the data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * DataSourceConfigurationInputProperty dataSourceConfigurationInputProperty = DataSourceConfigurationInputProperty.builder()
     *         .glueRunConfiguration(GlueRunConfigurationInputProperty.builder()
     *                 .relationalFilterConfigurations(List.of(RelationalFilterConfigurationProperty.builder()
     *                         .databaseName("databaseName")
     *                         // the properties below are optional
     *                         .filterExpressions(List.of(FilterExpressionProperty.builder()
     *                                 .expression("expression")
     *                                 .type("type")
     *                                 .build()))
     *                         .schemaName("schemaName")
     *                         .build()))
     *                 // the properties below are optional
     *                 .autoImportDataQualityResult(false)
     *                 .catalogName("catalogName")
     *                 .dataAccessRole("dataAccessRole")
     *                 .build())
     *         .redshiftRunConfiguration(RedshiftRunConfigurationInputProperty.builder()
     *                 .relationalFilterConfigurations(List.of(RelationalFilterConfigurationProperty.builder()
     *                         .databaseName("databaseName")
     *                         // the properties below are optional
     *                         .filterExpressions(List.of(FilterExpressionProperty.builder()
     *                                 .expression("expression")
     *                                 .type("type")
     *                                 .build()))
     *                         .schemaName("schemaName")
     *                         .build()))
     *                 // the properties below are optional
     *                 .dataAccessRole("dataAccessRole")
     *                 .redshiftCredentialConfiguration(RedshiftCredentialConfigurationProperty.builder()
     *                         .secretManagerArn("secretManagerArn")
     *                         .build())
     *                 .redshiftStorage(RedshiftStorageProperty.builder()
     *                         .redshiftClusterSource(RedshiftClusterStorageProperty.builder()
     *                                 .clusterName("clusterName")
     *                                 .build())
     *                         .redshiftServerlessSource(RedshiftServerlessStorageProperty.builder()
     *                                 .workgroupName("workgroupName")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .sageMakerRunConfiguration(SageMakerRunConfigurationInputProperty.builder()
     *                 .trackingAssets(Map.of(
     *                         "trackingAssetsKey", List.of("trackingAssets")))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-datasourceconfigurationinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-datasourceconfigurationinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnDataSource.DataSourceConfigurationInputProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSourceConfigurationInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSourceConfigurationInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration of the AWS Glue data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-datasourceconfigurationinput.html#cfn-datazone-datasource-datasourceconfigurationinput-gluerunconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-datasourceconfigurationinput.html#cfn-datazone-datasource-datasourceconfigurationinput-gluerunconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGlueRunConfiguration() {
            return null;
        }

        /**
         * The configuration of the Amazon Redshift data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-datasourceconfigurationinput.html#cfn-datazone-datasource-datasourceconfigurationinput-redshiftrunconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-datasourceconfigurationinput.html#cfn-datazone-datasource-datasourceconfigurationinput-redshiftrunconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedshiftRunConfiguration() {
            return null;
        }

        /**
         * The configuration details of the Amazon SageMaker data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-datasourceconfigurationinput.html#cfn-datazone-datasource-datasourceconfigurationinput-sagemakerrunconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-datasourceconfigurationinput.html#cfn-datazone-datasource-datasourceconfigurationinput-sagemakerrunconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSageMakerRunConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSourceConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSourceConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSourceConfigurationInputProperty> {
            java.lang.Object glueRunConfiguration;
            java.lang.Object redshiftRunConfiguration;
            java.lang.Object sageMakerRunConfiguration;

            /**
             * Sets the value of {@link DataSourceConfigurationInputProperty#getGlueRunConfiguration}
             * @param glueRunConfiguration The configuration of the AWS Glue data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glueRunConfiguration(software.amazon.awscdk.IResolvable glueRunConfiguration) {
                this.glueRunConfiguration = glueRunConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationInputProperty#getGlueRunConfiguration}
             * @param glueRunConfiguration The configuration of the AWS Glue data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glueRunConfiguration(software.amazon.awscdk.services.datazone.CfnDataSource.GlueRunConfigurationInputProperty glueRunConfiguration) {
                this.glueRunConfiguration = glueRunConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationInputProperty#getRedshiftRunConfiguration}
             * @param redshiftRunConfiguration The configuration of the Amazon Redshift data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftRunConfiguration(software.amazon.awscdk.IResolvable redshiftRunConfiguration) {
                this.redshiftRunConfiguration = redshiftRunConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationInputProperty#getRedshiftRunConfiguration}
             * @param redshiftRunConfiguration The configuration of the Amazon Redshift data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftRunConfiguration(software.amazon.awscdk.services.datazone.CfnDataSource.RedshiftRunConfigurationInputProperty redshiftRunConfiguration) {
                this.redshiftRunConfiguration = redshiftRunConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationInputProperty#getSageMakerRunConfiguration}
             * @param sageMakerRunConfiguration The configuration details of the Amazon SageMaker data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sageMakerRunConfiguration(software.amazon.awscdk.IResolvable sageMakerRunConfiguration) {
                this.sageMakerRunConfiguration = sageMakerRunConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationInputProperty#getSageMakerRunConfiguration}
             * @param sageMakerRunConfiguration The configuration details of the Amazon SageMaker data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sageMakerRunConfiguration(software.amazon.awscdk.services.datazone.CfnDataSource.SageMakerRunConfigurationInputProperty sageMakerRunConfiguration) {
                this.sageMakerRunConfiguration = sageMakerRunConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSourceConfigurationInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSourceConfigurationInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSourceConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSourceConfigurationInputProperty {
            private final java.lang.Object glueRunConfiguration;
            private final java.lang.Object redshiftRunConfiguration;
            private final java.lang.Object sageMakerRunConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.glueRunConfiguration = software.amazon.jsii.Kernel.get(this, "glueRunConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.redshiftRunConfiguration = software.amazon.jsii.Kernel.get(this, "redshiftRunConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sageMakerRunConfiguration = software.amazon.jsii.Kernel.get(this, "sageMakerRunConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.glueRunConfiguration = builder.glueRunConfiguration;
                this.redshiftRunConfiguration = builder.redshiftRunConfiguration;
                this.sageMakerRunConfiguration = builder.sageMakerRunConfiguration;
            }

            @Override
            public final java.lang.Object getGlueRunConfiguration() {
                return this.glueRunConfiguration;
            }

            @Override
            public final java.lang.Object getRedshiftRunConfiguration() {
                return this.redshiftRunConfiguration;
            }

            @Override
            public final java.lang.Object getSageMakerRunConfiguration() {
                return this.sageMakerRunConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGlueRunConfiguration() != null) {
                    data.set("glueRunConfiguration", om.valueToTree(this.getGlueRunConfiguration()));
                }
                if (this.getRedshiftRunConfiguration() != null) {
                    data.set("redshiftRunConfiguration", om.valueToTree(this.getRedshiftRunConfiguration()));
                }
                if (this.getSageMakerRunConfiguration() != null) {
                    data.set("sageMakerRunConfiguration", om.valueToTree(this.getSageMakerRunConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnDataSource.DataSourceConfigurationInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSourceConfigurationInputProperty.Jsii$Proxy that = (DataSourceConfigurationInputProperty.Jsii$Proxy) o;

                if (this.glueRunConfiguration != null ? !this.glueRunConfiguration.equals(that.glueRunConfiguration) : that.glueRunConfiguration != null) return false;
                if (this.redshiftRunConfiguration != null ? !this.redshiftRunConfiguration.equals(that.redshiftRunConfiguration) : that.redshiftRunConfiguration != null) return false;
                return this.sageMakerRunConfiguration != null ? this.sageMakerRunConfiguration.equals(that.sageMakerRunConfiguration) : that.sageMakerRunConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.glueRunConfiguration != null ? this.glueRunConfiguration.hashCode() : 0;
                result = 31 * result + (this.redshiftRunConfiguration != null ? this.redshiftRunConfiguration.hashCode() : 0);
                result = 31 * result + (this.sageMakerRunConfiguration != null ? this.sageMakerRunConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A filter expression in Amazon DataZone.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * FilterExpressionProperty filterExpressionProperty = FilterExpressionProperty.builder()
     *         .expression("expression")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-filterexpression.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-filterexpression.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnDataSource.FilterExpressionProperty")
    @software.amazon.jsii.Jsii.Proxy(FilterExpressionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FilterExpressionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The search filter expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-filterexpression.html#cfn-datazone-datasource-filterexpression-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-filterexpression.html#cfn-datazone-datasource-filterexpression-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExpression();

        /**
         * The search filter explresison type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-filterexpression.html#cfn-datazone-datasource-filterexpression-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-filterexpression.html#cfn-datazone-datasource-filterexpression-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link FilterExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FilterExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FilterExpressionProperty> {
            java.lang.String expression;
            java.lang.String type;

            /**
             * Sets the value of {@link FilterExpressionProperty#getExpression}
             * @param expression The search filter expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link FilterExpressionProperty#getType}
             * @param type The search filter explresison type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterExpressionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FilterExpressionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FilterExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FilterExpressionProperty {
            private final java.lang.String expression;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.expression = java.util.Objects.requireNonNull(builder.expression, "expression is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("expression", om.valueToTree(this.getExpression()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnDataSource.FilterExpressionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FilterExpressionProperty.Jsii$Proxy that = (FilterExpressionProperty.Jsii$Proxy) o;

                if (!expression.equals(that.expression)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.expression.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * The details of a metadata form.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * FormInputProperty formInputProperty = FormInputProperty.builder()
     *         .formName("formName")
     *         // the properties below are optional
     *         .content("content")
     *         .typeIdentifier("typeIdentifier")
     *         .typeRevision("typeRevision")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-forminput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-forminput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnDataSource.FormInputProperty")
    @software.amazon.jsii.Jsii.Proxy(FormInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FormInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the metadata form.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-forminput.html#cfn-datazone-datasource-forminput-formname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-forminput.html#cfn-datazone-datasource-forminput-formname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFormName();

        /**
         * The content of the metadata form.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-forminput.html#cfn-datazone-datasource-forminput-content">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-forminput.html#cfn-datazone-datasource-forminput-content</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContent() {
            return null;
        }

        /**
         * The ID of the metadata form type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-forminput.html#cfn-datazone-datasource-forminput-typeidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-forminput.html#cfn-datazone-datasource-forminput-typeidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTypeIdentifier() {
            return null;
        }

        /**
         * The revision of the metadata form type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-forminput.html#cfn-datazone-datasource-forminput-typerevision">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-forminput.html#cfn-datazone-datasource-forminput-typerevision</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTypeRevision() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FormInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FormInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FormInputProperty> {
            java.lang.String formName;
            java.lang.String content;
            java.lang.String typeIdentifier;
            java.lang.String typeRevision;

            /**
             * Sets the value of {@link FormInputProperty#getFormName}
             * @param formName The name of the metadata form. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder formName(java.lang.String formName) {
                this.formName = formName;
                return this;
            }

            /**
             * Sets the value of {@link FormInputProperty#getContent}
             * @param content The content of the metadata form.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder content(java.lang.String content) {
                this.content = content;
                return this;
            }

            /**
             * Sets the value of {@link FormInputProperty#getTypeIdentifier}
             * @param typeIdentifier The ID of the metadata form type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder typeIdentifier(java.lang.String typeIdentifier) {
                this.typeIdentifier = typeIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link FormInputProperty#getTypeRevision}
             * @param typeRevision The revision of the metadata form type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder typeRevision(java.lang.String typeRevision) {
                this.typeRevision = typeRevision;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FormInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FormInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FormInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FormInputProperty {
            private final java.lang.String formName;
            private final java.lang.String content;
            private final java.lang.String typeIdentifier;
            private final java.lang.String typeRevision;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.formName = software.amazon.jsii.Kernel.get(this, "formName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.content = software.amazon.jsii.Kernel.get(this, "content", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.typeIdentifier = software.amazon.jsii.Kernel.get(this, "typeIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.typeRevision = software.amazon.jsii.Kernel.get(this, "typeRevision", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.formName = java.util.Objects.requireNonNull(builder.formName, "formName is required");
                this.content = builder.content;
                this.typeIdentifier = builder.typeIdentifier;
                this.typeRevision = builder.typeRevision;
            }

            @Override
            public final java.lang.String getFormName() {
                return this.formName;
            }

            @Override
            public final java.lang.String getContent() {
                return this.content;
            }

            @Override
            public final java.lang.String getTypeIdentifier() {
                return this.typeIdentifier;
            }

            @Override
            public final java.lang.String getTypeRevision() {
                return this.typeRevision;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("formName", om.valueToTree(this.getFormName()));
                if (this.getContent() != null) {
                    data.set("content", om.valueToTree(this.getContent()));
                }
                if (this.getTypeIdentifier() != null) {
                    data.set("typeIdentifier", om.valueToTree(this.getTypeIdentifier()));
                }
                if (this.getTypeRevision() != null) {
                    data.set("typeRevision", om.valueToTree(this.getTypeRevision()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnDataSource.FormInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FormInputProperty.Jsii$Proxy that = (FormInputProperty.Jsii$Proxy) o;

                if (!formName.equals(that.formName)) return false;
                if (this.content != null ? !this.content.equals(that.content) : that.content != null) return false;
                if (this.typeIdentifier != null ? !this.typeIdentifier.equals(that.typeIdentifier) : that.typeIdentifier != null) return false;
                return this.typeRevision != null ? this.typeRevision.equals(that.typeRevision) : that.typeRevision == null;
            }

            @Override
            public final int hashCode() {
                int result = this.formName.hashCode();
                result = 31 * result + (this.content != null ? this.content.hashCode() : 0);
                result = 31 * result + (this.typeIdentifier != null ? this.typeIdentifier.hashCode() : 0);
                result = 31 * result + (this.typeRevision != null ? this.typeRevision.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration details of the AWS Glue data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * GlueRunConfigurationInputProperty glueRunConfigurationInputProperty = GlueRunConfigurationInputProperty.builder()
     *         .relationalFilterConfigurations(List.of(RelationalFilterConfigurationProperty.builder()
     *                 .databaseName("databaseName")
     *                 // the properties below are optional
     *                 .filterExpressions(List.of(FilterExpressionProperty.builder()
     *                         .expression("expression")
     *                         .type("type")
     *                         .build()))
     *                 .schemaName("schemaName")
     *                 .build()))
     *         // the properties below are optional
     *         .autoImportDataQualityResult(false)
     *         .catalogName("catalogName")
     *         .dataAccessRole("dataAccessRole")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-gluerunconfigurationinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-gluerunconfigurationinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnDataSource.GlueRunConfigurationInputProperty")
    @software.amazon.jsii.Jsii.Proxy(GlueRunConfigurationInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GlueRunConfigurationInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The relational filter configurations included in the configuration details of the AWS Glue data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-gluerunconfigurationinput.html#cfn-datazone-datasource-gluerunconfigurationinput-relationalfilterconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-gluerunconfigurationinput.html#cfn-datazone-datasource-gluerunconfigurationinput-relationalfilterconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRelationalFilterConfigurations();

        /**
         * Specifies whether to automatically import data quality metrics as part of the data source run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-gluerunconfigurationinput.html#cfn-datazone-datasource-gluerunconfigurationinput-autoimportdataqualityresult">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-gluerunconfigurationinput.html#cfn-datazone-datasource-gluerunconfigurationinput-autoimportdataqualityresult</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoImportDataQualityResult() {
            return null;
        }

        /**
         * The catalog name in the AWS Glue run configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-gluerunconfigurationinput.html#cfn-datazone-datasource-gluerunconfigurationinput-catalogname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-gluerunconfigurationinput.html#cfn-datazone-datasource-gluerunconfigurationinput-catalogname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCatalogName() {
            return null;
        }

        /**
         * The data access role included in the configuration details of the AWS Glue data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-gluerunconfigurationinput.html#cfn-datazone-datasource-gluerunconfigurationinput-dataaccessrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-gluerunconfigurationinput.html#cfn-datazone-datasource-gluerunconfigurationinput-dataaccessrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataAccessRole() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GlueRunConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GlueRunConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GlueRunConfigurationInputProperty> {
            java.lang.Object relationalFilterConfigurations;
            java.lang.Object autoImportDataQualityResult;
            java.lang.String catalogName;
            java.lang.String dataAccessRole;

            /**
             * Sets the value of {@link GlueRunConfigurationInputProperty#getRelationalFilterConfigurations}
             * @param relationalFilterConfigurations The relational filter configurations included in the configuration details of the AWS Glue data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relationalFilterConfigurations(software.amazon.awscdk.IResolvable relationalFilterConfigurations) {
                this.relationalFilterConfigurations = relationalFilterConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link GlueRunConfigurationInputProperty#getRelationalFilterConfigurations}
             * @param relationalFilterConfigurations The relational filter configurations included in the configuration details of the AWS Glue data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relationalFilterConfigurations(java.util.List<? extends java.lang.Object> relationalFilterConfigurations) {
                this.relationalFilterConfigurations = relationalFilterConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link GlueRunConfigurationInputProperty#getAutoImportDataQualityResult}
             * @param autoImportDataQualityResult Specifies whether to automatically import data quality metrics as part of the data source run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoImportDataQualityResult(java.lang.Boolean autoImportDataQualityResult) {
                this.autoImportDataQualityResult = autoImportDataQualityResult;
                return this;
            }

            /**
             * Sets the value of {@link GlueRunConfigurationInputProperty#getAutoImportDataQualityResult}
             * @param autoImportDataQualityResult Specifies whether to automatically import data quality metrics as part of the data source run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoImportDataQualityResult(software.amazon.awscdk.IResolvable autoImportDataQualityResult) {
                this.autoImportDataQualityResult = autoImportDataQualityResult;
                return this;
            }

            /**
             * Sets the value of {@link GlueRunConfigurationInputProperty#getCatalogName}
             * @param catalogName The catalog name in the AWS Glue run configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogName(java.lang.String catalogName) {
                this.catalogName = catalogName;
                return this;
            }

            /**
             * Sets the value of {@link GlueRunConfigurationInputProperty#getDataAccessRole}
             * @param dataAccessRole The data access role included in the configuration details of the AWS Glue data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataAccessRole(java.lang.String dataAccessRole) {
                this.dataAccessRole = dataAccessRole;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GlueRunConfigurationInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GlueRunConfigurationInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GlueRunConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GlueRunConfigurationInputProperty {
            private final java.lang.Object relationalFilterConfigurations;
            private final java.lang.Object autoImportDataQualityResult;
            private final java.lang.String catalogName;
            private final java.lang.String dataAccessRole;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.relationalFilterConfigurations = software.amazon.jsii.Kernel.get(this, "relationalFilterConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.autoImportDataQualityResult = software.amazon.jsii.Kernel.get(this, "autoImportDataQualityResult", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.catalogName = software.amazon.jsii.Kernel.get(this, "catalogName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataAccessRole = software.amazon.jsii.Kernel.get(this, "dataAccessRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.relationalFilterConfigurations = java.util.Objects.requireNonNull(builder.relationalFilterConfigurations, "relationalFilterConfigurations is required");
                this.autoImportDataQualityResult = builder.autoImportDataQualityResult;
                this.catalogName = builder.catalogName;
                this.dataAccessRole = builder.dataAccessRole;
            }

            @Override
            public final java.lang.Object getRelationalFilterConfigurations() {
                return this.relationalFilterConfigurations;
            }

            @Override
            public final java.lang.Object getAutoImportDataQualityResult() {
                return this.autoImportDataQualityResult;
            }

            @Override
            public final java.lang.String getCatalogName() {
                return this.catalogName;
            }

            @Override
            public final java.lang.String getDataAccessRole() {
                return this.dataAccessRole;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("relationalFilterConfigurations", om.valueToTree(this.getRelationalFilterConfigurations()));
                if (this.getAutoImportDataQualityResult() != null) {
                    data.set("autoImportDataQualityResult", om.valueToTree(this.getAutoImportDataQualityResult()));
                }
                if (this.getCatalogName() != null) {
                    data.set("catalogName", om.valueToTree(this.getCatalogName()));
                }
                if (this.getDataAccessRole() != null) {
                    data.set("dataAccessRole", om.valueToTree(this.getDataAccessRole()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnDataSource.GlueRunConfigurationInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GlueRunConfigurationInputProperty.Jsii$Proxy that = (GlueRunConfigurationInputProperty.Jsii$Proxy) o;

                if (!relationalFilterConfigurations.equals(that.relationalFilterConfigurations)) return false;
                if (this.autoImportDataQualityResult != null ? !this.autoImportDataQualityResult.equals(that.autoImportDataQualityResult) : that.autoImportDataQualityResult != null) return false;
                if (this.catalogName != null ? !this.catalogName.equals(that.catalogName) : that.catalogName != null) return false;
                return this.dataAccessRole != null ? this.dataAccessRole.equals(that.dataAccessRole) : that.dataAccessRole == null;
            }

            @Override
            public final int hashCode() {
                int result = this.relationalFilterConfigurations.hashCode();
                result = 31 * result + (this.autoImportDataQualityResult != null ? this.autoImportDataQualityResult.hashCode() : 0);
                result = 31 * result + (this.catalogName != null ? this.catalogName.hashCode() : 0);
                result = 31 * result + (this.dataAccessRole != null ? this.dataAccessRole.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The recommendation configuration for the data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * RecommendationConfigurationProperty recommendationConfigurationProperty = RecommendationConfigurationProperty.builder()
     *         .enableBusinessNameGeneration(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-recommendationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-recommendationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnDataSource.RecommendationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RecommendationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecommendationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether automatic business name generation is to be enabled or not as part of the recommendation configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-recommendationconfiguration.html#cfn-datazone-datasource-recommendationconfiguration-enablebusinessnamegeneration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-recommendationconfiguration.html#cfn-datazone-datasource-recommendationconfiguration-enablebusinessnamegeneration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableBusinessNameGeneration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RecommendationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecommendationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecommendationConfigurationProperty> {
            java.lang.Object enableBusinessNameGeneration;

            /**
             * Sets the value of {@link RecommendationConfigurationProperty#getEnableBusinessNameGeneration}
             * @param enableBusinessNameGeneration Specifies whether automatic business name generation is to be enabled or not as part of the recommendation configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableBusinessNameGeneration(java.lang.Boolean enableBusinessNameGeneration) {
                this.enableBusinessNameGeneration = enableBusinessNameGeneration;
                return this;
            }

            /**
             * Sets the value of {@link RecommendationConfigurationProperty#getEnableBusinessNameGeneration}
             * @param enableBusinessNameGeneration Specifies whether automatic business name generation is to be enabled or not as part of the recommendation configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableBusinessNameGeneration(software.amazon.awscdk.IResolvable enableBusinessNameGeneration) {
                this.enableBusinessNameGeneration = enableBusinessNameGeneration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecommendationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecommendationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RecommendationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecommendationConfigurationProperty {
            private final java.lang.Object enableBusinessNameGeneration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enableBusinessNameGeneration = software.amazon.jsii.Kernel.get(this, "enableBusinessNameGeneration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enableBusinessNameGeneration = builder.enableBusinessNameGeneration;
            }

            @Override
            public final java.lang.Object getEnableBusinessNameGeneration() {
                return this.enableBusinessNameGeneration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnableBusinessNameGeneration() != null) {
                    data.set("enableBusinessNameGeneration", om.valueToTree(this.getEnableBusinessNameGeneration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnDataSource.RecommendationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecommendationConfigurationProperty.Jsii$Proxy that = (RecommendationConfigurationProperty.Jsii$Proxy) o;

                return this.enableBusinessNameGeneration != null ? this.enableBusinessNameGeneration.equals(that.enableBusinessNameGeneration) : that.enableBusinessNameGeneration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enableBusinessNameGeneration != null ? this.enableBusinessNameGeneration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The details of the Amazon Redshift cluster storage.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * RedshiftClusterStorageProperty redshiftClusterStorageProperty = RedshiftClusterStorageProperty.builder()
     *         .clusterName("clusterName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftclusterstorage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftclusterstorage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnDataSource.RedshiftClusterStorageProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftClusterStorageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftClusterStorageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of an Amazon Redshift cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftclusterstorage.html#cfn-datazone-datasource-redshiftclusterstorage-clustername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftclusterstorage.html#cfn-datazone-datasource-redshiftclusterstorage-clustername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClusterName();

        /**
         * @return a {@link Builder} of {@link RedshiftClusterStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftClusterStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftClusterStorageProperty> {
            java.lang.String clusterName;

            /**
             * Sets the value of {@link RedshiftClusterStorageProperty#getClusterName}
             * @param clusterName The name of an Amazon Redshift cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterName(java.lang.String clusterName) {
                this.clusterName = clusterName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftClusterStorageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftClusterStorageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftClusterStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftClusterStorageProperty {
            private final java.lang.String clusterName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clusterName = java.util.Objects.requireNonNull(builder.clusterName, "clusterName is required");
            }

            @Override
            public final java.lang.String getClusterName() {
                return this.clusterName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clusterName", om.valueToTree(this.getClusterName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnDataSource.RedshiftClusterStorageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftClusterStorageProperty.Jsii$Proxy that = (RedshiftClusterStorageProperty.Jsii$Proxy) o;

                return this.clusterName.equals(that.clusterName);
            }

            @Override
            public final int hashCode() {
                int result = this.clusterName.hashCode();
                return result;
            }
        }
    }
    /**
     * The details of the credentials required to access an Amazon Redshift cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * RedshiftCredentialConfigurationProperty redshiftCredentialConfigurationProperty = RedshiftCredentialConfigurationProperty.builder()
     *         .secretManagerArn("secretManagerArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftcredentialconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftcredentialconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnDataSource.RedshiftCredentialConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftCredentialConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftCredentialConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of a secret manager for an Amazon Redshift cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftcredentialconfiguration.html#cfn-datazone-datasource-redshiftcredentialconfiguration-secretmanagerarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftcredentialconfiguration.html#cfn-datazone-datasource-redshiftcredentialconfiguration-secretmanagerarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretManagerArn();

        /**
         * @return a {@link Builder} of {@link RedshiftCredentialConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftCredentialConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftCredentialConfigurationProperty> {
            java.lang.String secretManagerArn;

            /**
             * Sets the value of {@link RedshiftCredentialConfigurationProperty#getSecretManagerArn}
             * @param secretManagerArn The ARN of a secret manager for an Amazon Redshift cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretManagerArn(java.lang.String secretManagerArn) {
                this.secretManagerArn = secretManagerArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftCredentialConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftCredentialConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftCredentialConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftCredentialConfigurationProperty {
            private final java.lang.String secretManagerArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretManagerArn = software.amazon.jsii.Kernel.get(this, "secretManagerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretManagerArn = java.util.Objects.requireNonNull(builder.secretManagerArn, "secretManagerArn is required");
            }

            @Override
            public final java.lang.String getSecretManagerArn() {
                return this.secretManagerArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("secretManagerArn", om.valueToTree(this.getSecretManagerArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnDataSource.RedshiftCredentialConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftCredentialConfigurationProperty.Jsii$Proxy that = (RedshiftCredentialConfigurationProperty.Jsii$Proxy) o;

                return this.secretManagerArn.equals(that.secretManagerArn);
            }

            @Override
            public final int hashCode() {
                int result = this.secretManagerArn.hashCode();
                return result;
            }
        }
    }
    /**
     * The relational filter configurations included in the configuration details of the Amazon Redshift data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * RedshiftRunConfigurationInputProperty redshiftRunConfigurationInputProperty = RedshiftRunConfigurationInputProperty.builder()
     *         .relationalFilterConfigurations(List.of(RelationalFilterConfigurationProperty.builder()
     *                 .databaseName("databaseName")
     *                 // the properties below are optional
     *                 .filterExpressions(List.of(FilterExpressionProperty.builder()
     *                         .expression("expression")
     *                         .type("type")
     *                         .build()))
     *                 .schemaName("schemaName")
     *                 .build()))
     *         // the properties below are optional
     *         .dataAccessRole("dataAccessRole")
     *         .redshiftCredentialConfiguration(RedshiftCredentialConfigurationProperty.builder()
     *                 .secretManagerArn("secretManagerArn")
     *                 .build())
     *         .redshiftStorage(RedshiftStorageProperty.builder()
     *                 .redshiftClusterSource(RedshiftClusterStorageProperty.builder()
     *                         .clusterName("clusterName")
     *                         .build())
     *                 .redshiftServerlessSource(RedshiftServerlessStorageProperty.builder()
     *                         .workgroupName("workgroupName")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftrunconfigurationinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftrunconfigurationinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnDataSource.RedshiftRunConfigurationInputProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftRunConfigurationInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftRunConfigurationInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The relational filter configurations included in the configuration details of the AWS Glue data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftrunconfigurationinput.html#cfn-datazone-datasource-redshiftrunconfigurationinput-relationalfilterconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftrunconfigurationinput.html#cfn-datazone-datasource-redshiftrunconfigurationinput-relationalfilterconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRelationalFilterConfigurations();

        /**
         * The data access role included in the configuration details of the Amazon Redshift data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftrunconfigurationinput.html#cfn-datazone-datasource-redshiftrunconfigurationinput-dataaccessrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftrunconfigurationinput.html#cfn-datazone-datasource-redshiftrunconfigurationinput-dataaccessrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataAccessRole() {
            return null;
        }

        /**
         * The details of the credentials required to access an Amazon Redshift cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftrunconfigurationinput.html#cfn-datazone-datasource-redshiftrunconfigurationinput-redshiftcredentialconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftrunconfigurationinput.html#cfn-datazone-datasource-redshiftrunconfigurationinput-redshiftcredentialconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedshiftCredentialConfiguration() {
            return null;
        }

        /**
         * The details of the Amazon Redshift storage as part of the configuration of an Amazon Redshift data source run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftrunconfigurationinput.html#cfn-datazone-datasource-redshiftrunconfigurationinput-redshiftstorage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftrunconfigurationinput.html#cfn-datazone-datasource-redshiftrunconfigurationinput-redshiftstorage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedshiftStorage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftRunConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftRunConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftRunConfigurationInputProperty> {
            java.lang.Object relationalFilterConfigurations;
            java.lang.String dataAccessRole;
            java.lang.Object redshiftCredentialConfiguration;
            java.lang.Object redshiftStorage;

            /**
             * Sets the value of {@link RedshiftRunConfigurationInputProperty#getRelationalFilterConfigurations}
             * @param relationalFilterConfigurations The relational filter configurations included in the configuration details of the AWS Glue data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relationalFilterConfigurations(software.amazon.awscdk.IResolvable relationalFilterConfigurations) {
                this.relationalFilterConfigurations = relationalFilterConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftRunConfigurationInputProperty#getRelationalFilterConfigurations}
             * @param relationalFilterConfigurations The relational filter configurations included in the configuration details of the AWS Glue data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relationalFilterConfigurations(java.util.List<? extends java.lang.Object> relationalFilterConfigurations) {
                this.relationalFilterConfigurations = relationalFilterConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftRunConfigurationInputProperty#getDataAccessRole}
             * @param dataAccessRole The data access role included in the configuration details of the Amazon Redshift data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataAccessRole(java.lang.String dataAccessRole) {
                this.dataAccessRole = dataAccessRole;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftRunConfigurationInputProperty#getRedshiftCredentialConfiguration}
             * @param redshiftCredentialConfiguration The details of the credentials required to access an Amazon Redshift cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftCredentialConfiguration(software.amazon.awscdk.IResolvable redshiftCredentialConfiguration) {
                this.redshiftCredentialConfiguration = redshiftCredentialConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftRunConfigurationInputProperty#getRedshiftCredentialConfiguration}
             * @param redshiftCredentialConfiguration The details of the credentials required to access an Amazon Redshift cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftCredentialConfiguration(software.amazon.awscdk.services.datazone.CfnDataSource.RedshiftCredentialConfigurationProperty redshiftCredentialConfiguration) {
                this.redshiftCredentialConfiguration = redshiftCredentialConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftRunConfigurationInputProperty#getRedshiftStorage}
             * @param redshiftStorage The details of the Amazon Redshift storage as part of the configuration of an Amazon Redshift data source run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftStorage(software.amazon.awscdk.IResolvable redshiftStorage) {
                this.redshiftStorage = redshiftStorage;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftRunConfigurationInputProperty#getRedshiftStorage}
             * @param redshiftStorage The details of the Amazon Redshift storage as part of the configuration of an Amazon Redshift data source run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftStorage(software.amazon.awscdk.services.datazone.CfnDataSource.RedshiftStorageProperty redshiftStorage) {
                this.redshiftStorage = redshiftStorage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftRunConfigurationInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftRunConfigurationInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftRunConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftRunConfigurationInputProperty {
            private final java.lang.Object relationalFilterConfigurations;
            private final java.lang.String dataAccessRole;
            private final java.lang.Object redshiftCredentialConfiguration;
            private final java.lang.Object redshiftStorage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.relationalFilterConfigurations = software.amazon.jsii.Kernel.get(this, "relationalFilterConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataAccessRole = software.amazon.jsii.Kernel.get(this, "dataAccessRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.redshiftCredentialConfiguration = software.amazon.jsii.Kernel.get(this, "redshiftCredentialConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.redshiftStorage = software.amazon.jsii.Kernel.get(this, "redshiftStorage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.relationalFilterConfigurations = java.util.Objects.requireNonNull(builder.relationalFilterConfigurations, "relationalFilterConfigurations is required");
                this.dataAccessRole = builder.dataAccessRole;
                this.redshiftCredentialConfiguration = builder.redshiftCredentialConfiguration;
                this.redshiftStorage = builder.redshiftStorage;
            }

            @Override
            public final java.lang.Object getRelationalFilterConfigurations() {
                return this.relationalFilterConfigurations;
            }

            @Override
            public final java.lang.String getDataAccessRole() {
                return this.dataAccessRole;
            }

            @Override
            public final java.lang.Object getRedshiftCredentialConfiguration() {
                return this.redshiftCredentialConfiguration;
            }

            @Override
            public final java.lang.Object getRedshiftStorage() {
                return this.redshiftStorage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("relationalFilterConfigurations", om.valueToTree(this.getRelationalFilterConfigurations()));
                if (this.getDataAccessRole() != null) {
                    data.set("dataAccessRole", om.valueToTree(this.getDataAccessRole()));
                }
                if (this.getRedshiftCredentialConfiguration() != null) {
                    data.set("redshiftCredentialConfiguration", om.valueToTree(this.getRedshiftCredentialConfiguration()));
                }
                if (this.getRedshiftStorage() != null) {
                    data.set("redshiftStorage", om.valueToTree(this.getRedshiftStorage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnDataSource.RedshiftRunConfigurationInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftRunConfigurationInputProperty.Jsii$Proxy that = (RedshiftRunConfigurationInputProperty.Jsii$Proxy) o;

                if (!relationalFilterConfigurations.equals(that.relationalFilterConfigurations)) return false;
                if (this.dataAccessRole != null ? !this.dataAccessRole.equals(that.dataAccessRole) : that.dataAccessRole != null) return false;
                if (this.redshiftCredentialConfiguration != null ? !this.redshiftCredentialConfiguration.equals(that.redshiftCredentialConfiguration) : that.redshiftCredentialConfiguration != null) return false;
                return this.redshiftStorage != null ? this.redshiftStorage.equals(that.redshiftStorage) : that.redshiftStorage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.relationalFilterConfigurations.hashCode();
                result = 31 * result + (this.dataAccessRole != null ? this.dataAccessRole.hashCode() : 0);
                result = 31 * result + (this.redshiftCredentialConfiguration != null ? this.redshiftCredentialConfiguration.hashCode() : 0);
                result = 31 * result + (this.redshiftStorage != null ? this.redshiftStorage.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The details of the Amazon Redshift Serverless workgroup storage.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * RedshiftServerlessStorageProperty redshiftServerlessStorageProperty = RedshiftServerlessStorageProperty.builder()
     *         .workgroupName("workgroupName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftserverlessstorage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftserverlessstorage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnDataSource.RedshiftServerlessStorageProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftServerlessStorageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftServerlessStorageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Amazon Redshift Serverless workgroup.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftserverlessstorage.html#cfn-datazone-datasource-redshiftserverlessstorage-workgroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftserverlessstorage.html#cfn-datazone-datasource-redshiftserverlessstorage-workgroupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getWorkgroupName();

        /**
         * @return a {@link Builder} of {@link RedshiftServerlessStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftServerlessStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftServerlessStorageProperty> {
            java.lang.String workgroupName;

            /**
             * Sets the value of {@link RedshiftServerlessStorageProperty#getWorkgroupName}
             * @param workgroupName The name of the Amazon Redshift Serverless workgroup. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workgroupName(java.lang.String workgroupName) {
                this.workgroupName = workgroupName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftServerlessStorageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftServerlessStorageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftServerlessStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftServerlessStorageProperty {
            private final java.lang.String workgroupName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.workgroupName = software.amazon.jsii.Kernel.get(this, "workgroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.workgroupName = java.util.Objects.requireNonNull(builder.workgroupName, "workgroupName is required");
            }

            @Override
            public final java.lang.String getWorkgroupName() {
                return this.workgroupName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("workgroupName", om.valueToTree(this.getWorkgroupName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnDataSource.RedshiftServerlessStorageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftServerlessStorageProperty.Jsii$Proxy that = (RedshiftServerlessStorageProperty.Jsii$Proxy) o;

                return this.workgroupName.equals(that.workgroupName);
            }

            @Override
            public final int hashCode() {
                int result = this.workgroupName.hashCode();
                return result;
            }
        }
    }
    /**
     * The details of the Amazon Redshift storage as part of the configuration of an Amazon Redshift data source run.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * RedshiftStorageProperty redshiftStorageProperty = RedshiftStorageProperty.builder()
     *         .redshiftClusterSource(RedshiftClusterStorageProperty.builder()
     *                 .clusterName("clusterName")
     *                 .build())
     *         .redshiftServerlessSource(RedshiftServerlessStorageProperty.builder()
     *                 .workgroupName("workgroupName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftstorage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftstorage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnDataSource.RedshiftStorageProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftStorageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftStorageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The details of the Amazon Redshift cluster source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftstorage.html#cfn-datazone-datasource-redshiftstorage-redshiftclustersource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftstorage.html#cfn-datazone-datasource-redshiftstorage-redshiftclustersource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedshiftClusterSource() {
            return null;
        }

        /**
         * The details of the Amazon Redshift Serverless workgroup source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftstorage.html#cfn-datazone-datasource-redshiftstorage-redshiftserverlesssource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-redshiftstorage.html#cfn-datazone-datasource-redshiftstorage-redshiftserverlesssource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedshiftServerlessSource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftStorageProperty> {
            java.lang.Object redshiftClusterSource;
            java.lang.Object redshiftServerlessSource;

            /**
             * Sets the value of {@link RedshiftStorageProperty#getRedshiftClusterSource}
             * @param redshiftClusterSource The details of the Amazon Redshift cluster source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftClusterSource(software.amazon.awscdk.IResolvable redshiftClusterSource) {
                this.redshiftClusterSource = redshiftClusterSource;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftStorageProperty#getRedshiftClusterSource}
             * @param redshiftClusterSource The details of the Amazon Redshift cluster source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftClusterSource(software.amazon.awscdk.services.datazone.CfnDataSource.RedshiftClusterStorageProperty redshiftClusterSource) {
                this.redshiftClusterSource = redshiftClusterSource;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftStorageProperty#getRedshiftServerlessSource}
             * @param redshiftServerlessSource The details of the Amazon Redshift Serverless workgroup source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftServerlessSource(software.amazon.awscdk.IResolvable redshiftServerlessSource) {
                this.redshiftServerlessSource = redshiftServerlessSource;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftStorageProperty#getRedshiftServerlessSource}
             * @param redshiftServerlessSource The details of the Amazon Redshift Serverless workgroup source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftServerlessSource(software.amazon.awscdk.services.datazone.CfnDataSource.RedshiftServerlessStorageProperty redshiftServerlessSource) {
                this.redshiftServerlessSource = redshiftServerlessSource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftStorageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftStorageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftStorageProperty {
            private final java.lang.Object redshiftClusterSource;
            private final java.lang.Object redshiftServerlessSource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.redshiftClusterSource = software.amazon.jsii.Kernel.get(this, "redshiftClusterSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.redshiftServerlessSource = software.amazon.jsii.Kernel.get(this, "redshiftServerlessSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.redshiftClusterSource = builder.redshiftClusterSource;
                this.redshiftServerlessSource = builder.redshiftServerlessSource;
            }

            @Override
            public final java.lang.Object getRedshiftClusterSource() {
                return this.redshiftClusterSource;
            }

            @Override
            public final java.lang.Object getRedshiftServerlessSource() {
                return this.redshiftServerlessSource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRedshiftClusterSource() != null) {
                    data.set("redshiftClusterSource", om.valueToTree(this.getRedshiftClusterSource()));
                }
                if (this.getRedshiftServerlessSource() != null) {
                    data.set("redshiftServerlessSource", om.valueToTree(this.getRedshiftServerlessSource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnDataSource.RedshiftStorageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftStorageProperty.Jsii$Proxy that = (RedshiftStorageProperty.Jsii$Proxy) o;

                if (this.redshiftClusterSource != null ? !this.redshiftClusterSource.equals(that.redshiftClusterSource) : that.redshiftClusterSource != null) return false;
                return this.redshiftServerlessSource != null ? this.redshiftServerlessSource.equals(that.redshiftServerlessSource) : that.redshiftServerlessSource == null;
            }

            @Override
            public final int hashCode() {
                int result = this.redshiftClusterSource != null ? this.redshiftClusterSource.hashCode() : 0;
                result = 31 * result + (this.redshiftServerlessSource != null ? this.redshiftServerlessSource.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The relational filter configuration for the data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * RelationalFilterConfigurationProperty relationalFilterConfigurationProperty = RelationalFilterConfigurationProperty.builder()
     *         .databaseName("databaseName")
     *         // the properties below are optional
     *         .filterExpressions(List.of(FilterExpressionProperty.builder()
     *                 .expression("expression")
     *                 .type("type")
     *                 .build()))
     *         .schemaName("schemaName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-relationalfilterconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-relationalfilterconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnDataSource.RelationalFilterConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RelationalFilterConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RelationalFilterConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The database name specified in the relational filter configuration for the data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-relationalfilterconfiguration.html#cfn-datazone-datasource-relationalfilterconfiguration-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-relationalfilterconfiguration.html#cfn-datazone-datasource-relationalfilterconfiguration-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * The filter expressions specified in the relational filter configuration for the data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-relationalfilterconfiguration.html#cfn-datazone-datasource-relationalfilterconfiguration-filterexpressions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-relationalfilterconfiguration.html#cfn-datazone-datasource-relationalfilterconfiguration-filterexpressions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilterExpressions() {
            return null;
        }

        /**
         * The schema name specified in the relational filter configuration for the data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-relationalfilterconfiguration.html#cfn-datazone-datasource-relationalfilterconfiguration-schemaname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-relationalfilterconfiguration.html#cfn-datazone-datasource-relationalfilterconfiguration-schemaname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSchemaName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RelationalFilterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RelationalFilterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RelationalFilterConfigurationProperty> {
            java.lang.String databaseName;
            java.lang.Object filterExpressions;
            java.lang.String schemaName;

            /**
             * Sets the value of {@link RelationalFilterConfigurationProperty#getDatabaseName}
             * @param databaseName The database name specified in the relational filter configuration for the data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link RelationalFilterConfigurationProperty#getFilterExpressions}
             * @param filterExpressions The filter expressions specified in the relational filter configuration for the data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterExpressions(software.amazon.awscdk.IResolvable filterExpressions) {
                this.filterExpressions = filterExpressions;
                return this;
            }

            /**
             * Sets the value of {@link RelationalFilterConfigurationProperty#getFilterExpressions}
             * @param filterExpressions The filter expressions specified in the relational filter configuration for the data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterExpressions(java.util.List<? extends java.lang.Object> filterExpressions) {
                this.filterExpressions = filterExpressions;
                return this;
            }

            /**
             * Sets the value of {@link RelationalFilterConfigurationProperty#getSchemaName}
             * @param schemaName The schema name specified in the relational filter configuration for the data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schemaName(java.lang.String schemaName) {
                this.schemaName = schemaName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RelationalFilterConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RelationalFilterConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RelationalFilterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RelationalFilterConfigurationProperty {
            private final java.lang.String databaseName;
            private final java.lang.Object filterExpressions;
            private final java.lang.String schemaName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.filterExpressions = software.amazon.jsii.Kernel.get(this, "filterExpressions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.schemaName = software.amazon.jsii.Kernel.get(this, "schemaName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.filterExpressions = builder.filterExpressions;
                this.schemaName = builder.schemaName;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.Object getFilterExpressions() {
                return this.filterExpressions;
            }

            @Override
            public final java.lang.String getSchemaName() {
                return this.schemaName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                if (this.getFilterExpressions() != null) {
                    data.set("filterExpressions", om.valueToTree(this.getFilterExpressions()));
                }
                if (this.getSchemaName() != null) {
                    data.set("schemaName", om.valueToTree(this.getSchemaName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnDataSource.RelationalFilterConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RelationalFilterConfigurationProperty.Jsii$Proxy that = (RelationalFilterConfigurationProperty.Jsii$Proxy) o;

                if (!databaseName.equals(that.databaseName)) return false;
                if (this.filterExpressions != null ? !this.filterExpressions.equals(that.filterExpressions) : that.filterExpressions != null) return false;
                return this.schemaName != null ? this.schemaName.equals(that.schemaName) : that.schemaName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.databaseName.hashCode();
                result = 31 * result + (this.filterExpressions != null ? this.filterExpressions.hashCode() : 0);
                result = 31 * result + (this.schemaName != null ? this.schemaName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration details of the Amazon SageMaker data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * SageMakerRunConfigurationInputProperty sageMakerRunConfigurationInputProperty = SageMakerRunConfigurationInputProperty.builder()
     *         .trackingAssets(Map.of(
     *                 "trackingAssetsKey", List.of("trackingAssets")))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-sagemakerrunconfigurationinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-sagemakerrunconfigurationinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnDataSource.SageMakerRunConfigurationInputProperty")
    @software.amazon.jsii.Jsii.Proxy(SageMakerRunConfigurationInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SageMakerRunConfigurationInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The tracking assets of the Amazon SageMaker run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-sagemakerrunconfigurationinput.html#cfn-datazone-datasource-sagemakerrunconfigurationinput-trackingassets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-sagemakerrunconfigurationinput.html#cfn-datazone-datasource-sagemakerrunconfigurationinput-trackingassets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTrackingAssets();

        /**
         * @return a {@link Builder} of {@link SageMakerRunConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SageMakerRunConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SageMakerRunConfigurationInputProperty> {
            java.lang.Object trackingAssets;

            /**
             * Sets the value of {@link SageMakerRunConfigurationInputProperty#getTrackingAssets}
             * @param trackingAssets The tracking assets of the Amazon SageMaker run. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trackingAssets(software.amazon.awscdk.IResolvable trackingAssets) {
                this.trackingAssets = trackingAssets;
                return this;
            }

            /**
             * Sets the value of {@link SageMakerRunConfigurationInputProperty#getTrackingAssets}
             * @param trackingAssets The tracking assets of the Amazon SageMaker run. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trackingAssets(java.util.Map<java.lang.String, ? extends java.util.List<java.lang.String>> trackingAssets) {
                this.trackingAssets = trackingAssets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SageMakerRunConfigurationInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SageMakerRunConfigurationInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SageMakerRunConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SageMakerRunConfigurationInputProperty {
            private final java.lang.Object trackingAssets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.trackingAssets = software.amazon.jsii.Kernel.get(this, "trackingAssets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.trackingAssets = java.util.Objects.requireNonNull(builder.trackingAssets, "trackingAssets is required");
            }

            @Override
            public final java.lang.Object getTrackingAssets() {
                return this.trackingAssets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("trackingAssets", om.valueToTree(this.getTrackingAssets()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnDataSource.SageMakerRunConfigurationInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SageMakerRunConfigurationInputProperty.Jsii$Proxy that = (SageMakerRunConfigurationInputProperty.Jsii$Proxy) o;

                return this.trackingAssets.equals(that.trackingAssets);
            }

            @Override
            public final int hashCode() {
                int result = this.trackingAssets.hashCode();
                return result;
            }
        }
    }
    /**
     * The details of the schedule of the data source runs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * ScheduleConfigurationProperty scheduleConfigurationProperty = ScheduleConfigurationProperty.builder()
     *         .schedule("schedule")
     *         .timezone("timezone")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-scheduleconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-scheduleconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnDataSource.ScheduleConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduleConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduleConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The schedule of the data source runs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-scheduleconfiguration.html#cfn-datazone-datasource-scheduleconfiguration-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-scheduleconfiguration.html#cfn-datazone-datasource-scheduleconfiguration-schedule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSchedule() {
            return null;
        }

        /**
         * The timezone of the data source run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-scheduleconfiguration.html#cfn-datazone-datasource-scheduleconfiguration-timezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-datasource-scheduleconfiguration.html#cfn-datazone-datasource-scheduleconfiguration-timezone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimezone() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScheduleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduleConfigurationProperty> {
            java.lang.String schedule;
            java.lang.String timezone;

            /**
             * Sets the value of {@link ScheduleConfigurationProperty#getSchedule}
             * @param schedule The schedule of the data source runs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schedule(java.lang.String schedule) {
                this.schedule = schedule;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleConfigurationProperty#getTimezone}
             * @param timezone The timezone of the data source run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timezone(java.lang.String timezone) {
                this.timezone = timezone;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduleConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduleConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleConfigurationProperty {
            private final java.lang.String schedule;
            private final java.lang.String timezone;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timezone = software.amazon.jsii.Kernel.get(this, "timezone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.schedule = builder.schedule;
                this.timezone = builder.timezone;
            }

            @Override
            public final java.lang.String getSchedule() {
                return this.schedule;
            }

            @Override
            public final java.lang.String getTimezone() {
                return this.timezone;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSchedule() != null) {
                    data.set("schedule", om.valueToTree(this.getSchedule()));
                }
                if (this.getTimezone() != null) {
                    data.set("timezone", om.valueToTree(this.getTimezone()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnDataSource.ScheduleConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduleConfigurationProperty.Jsii$Proxy that = (ScheduleConfigurationProperty.Jsii$Proxy) o;

                if (this.schedule != null ? !this.schedule.equals(that.schedule) : that.schedule != null) return false;
                return this.timezone != null ? this.timezone.equals(that.timezone) : that.timezone == null;
            }

            @Override
            public final int hashCode() {
                int result = this.schedule != null ? this.schedule.hashCode() : 0;
                result = 31 * result + (this.timezone != null ? this.timezone.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.datazone.CfnDataSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.datazone.CfnDataSource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.datazone.CfnDataSourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.datazone.CfnDataSourceProps.Builder();
        }

        /**
         * The ID of the Amazon DataZone domain where the data source is created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-domainidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-domainidentifier</a>
         * @param domainIdentifier The ID of the Amazon DataZone domain where the data source is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainIdentifier(final java.lang.String domainIdentifier) {
            this.props.domainIdentifier(domainIdentifier);
            return this;
        }

        /**
         * The name of the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-name</a>
         * @param name The name of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The identifier of the Amazon DataZone project in which you want to add this data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-projectidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-projectidentifier</a>
         * @param projectIdentifier The identifier of the Amazon DataZone project in which you want to add this data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectIdentifier(final java.lang.String projectIdentifier) {
            this.props.projectIdentifier(projectIdentifier);
            return this;
        }

        /**
         * The type of the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-type</a>
         * @param type The type of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * The metadata forms attached to the assets that the data source works with.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-assetformsinput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-assetformsinput</a>
         * @param assetFormsInput The metadata forms attached to the assets that the data source works with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetFormsInput(final software.amazon.awscdk.IResolvable assetFormsInput) {
            this.props.assetFormsInput(assetFormsInput);
            return this;
        }
        /**
         * The metadata forms attached to the assets that the data source works with.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-assetformsinput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-assetformsinput</a>
         * @param assetFormsInput The metadata forms attached to the assets that the data source works with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetFormsInput(final java.util.List<? extends java.lang.Object> assetFormsInput) {
            this.props.assetFormsInput(assetFormsInput);
            return this;
        }

        /**
         * The configuration of the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-configuration</a>
         * @param configuration The configuration of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.IResolvable configuration) {
            this.props.configuration(configuration);
            return this;
        }
        /**
         * The configuration of the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-configuration</a>
         * @param configuration The configuration of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.services.datazone.CfnDataSource.DataSourceConfigurationInputProperty configuration) {
            this.props.configuration(configuration);
            return this;
        }

        /**
         * The unique identifier of a connection used to fetch relevant parameters from connection during Datasource run.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-connectionidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-connectionidentifier</a>
         * @param connectionIdentifier The unique identifier of a connection used to fetch relevant parameters from connection during Datasource run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionIdentifier(final java.lang.String connectionIdentifier) {
            this.props.connectionIdentifier(connectionIdentifier);
            return this;
        }

        /**
         * The description of the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-description</a>
         * @param description The description of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Specifies whether the data source is enabled.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-enablesetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-enablesetting</a>
         * @param enableSetting Specifies whether the data source is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableSetting(final java.lang.String enableSetting) {
            this.props.enableSetting(enableSetting);
            return this;
        }

        /**
         * The unique identifier of the Amazon DataZone environment to which the data source publishes assets.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-environmentidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-environmentidentifier</a>
         * @param environmentIdentifier The unique identifier of the Amazon DataZone environment to which the data source publishes assets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentIdentifier(final java.lang.String environmentIdentifier) {
            this.props.environmentIdentifier(environmentIdentifier);
            return this;
        }

        /**
         * Specifies whether the assets that this data source creates in the inventory are to be also automatically published to the catalog.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-publishonimport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-publishonimport</a>
         * @param publishOnImport Specifies whether the assets that this data source creates in the inventory are to be also automatically published to the catalog. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publishOnImport(final java.lang.Boolean publishOnImport) {
            this.props.publishOnImport(publishOnImport);
            return this;
        }
        /**
         * Specifies whether the assets that this data source creates in the inventory are to be also automatically published to the catalog.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-publishonimport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-publishonimport</a>
         * @param publishOnImport Specifies whether the assets that this data source creates in the inventory are to be also automatically published to the catalog. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publishOnImport(final software.amazon.awscdk.IResolvable publishOnImport) {
            this.props.publishOnImport(publishOnImport);
            return this;
        }

        /**
         * Specifies whether the business name generation is to be enabled for this data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-recommendation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-recommendation</a>
         * @param recommendation Specifies whether the business name generation is to be enabled for this data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recommendation(final software.amazon.awscdk.IResolvable recommendation) {
            this.props.recommendation(recommendation);
            return this;
        }
        /**
         * Specifies whether the business name generation is to be enabled for this data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-recommendation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-recommendation</a>
         * @param recommendation Specifies whether the business name generation is to be enabled for this data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recommendation(final software.amazon.awscdk.services.datazone.CfnDataSource.RecommendationConfigurationProperty recommendation) {
            this.props.recommendation(recommendation);
            return this;
        }

        /**
         * The schedule of the data source runs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-schedule</a>
         * @param schedule The schedule of the data source runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.IResolvable schedule) {
            this.props.schedule(schedule);
            return this;
        }
        /**
         * The schedule of the data source runs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-schedule</a>
         * @param schedule The schedule of the data source runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.services.datazone.CfnDataSource.ScheduleConfigurationProperty schedule) {
            this.props.schedule(schedule);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.datazone.CfnDataSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.datazone.CfnDataSource build() {
            return new software.amazon.awscdk.services.datazone.CfnDataSource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
