package software.amazon.awscdk.services.deadline;

/**
 * Creates a fleet.
 * <p>
 * Fleets gather information relating to compute, or capacity, for renders within your farms. You can choose to manage your own capacity or opt to have fleets fully managed by Deadline Cloud.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.deadline.*;
 * CfnFleet cfnFleet = CfnFleet.Builder.create(this, "MyCfnFleet")
 *         .configuration(FleetConfigurationProperty.builder()
 *                 .customerManaged(CustomerManagedFleetConfigurationProperty.builder()
 *                         .mode("mode")
 *                         .workerCapabilities(CustomerManagedWorkerCapabilitiesProperty.builder()
 *                                 .cpuArchitectureType("cpuArchitectureType")
 *                                 .memoryMiB(MemoryMiBRangeProperty.builder()
 *                                         .min(123)
 *                                         // the properties below are optional
 *                                         .max(123)
 *                                         .build())
 *                                 .osFamily("osFamily")
 *                                 .vCpuCount(VCpuCountRangeProperty.builder()
 *                                         .min(123)
 *                                         // the properties below are optional
 *                                         .max(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .acceleratorCount(AcceleratorCountRangeProperty.builder()
 *                                         .min(123)
 *                                         // the properties below are optional
 *                                         .max(123)
 *                                         .build())
 *                                 .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRangeProperty.builder()
 *                                         .min(123)
 *                                         // the properties below are optional
 *                                         .max(123)
 *                                         .build())
 *                                 .acceleratorTypes(List.of("acceleratorTypes"))
 *                                 .customAmounts(List.of(FleetAmountCapabilityProperty.builder()
 *                                         .min(123)
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .max(123)
 *                                         .build()))
 *                                 .customAttributes(List.of(FleetAttributeCapabilityProperty.builder()
 *                                         .name("name")
 *                                         .values(List.of("values"))
 *                                         .build()))
 *                                 .build())
 *                         // the properties below are optional
 *                         .storageProfileId("storageProfileId")
 *                         .build())
 *                 .serviceManagedEc2(ServiceManagedEc2FleetConfigurationProperty.builder()
 *                         .instanceCapabilities(ServiceManagedEc2InstanceCapabilitiesProperty.builder()
 *                                 .cpuArchitectureType("cpuArchitectureType")
 *                                 .memoryMiB(MemoryMiBRangeProperty.builder()
 *                                         .min(123)
 *                                         // the properties below are optional
 *                                         .max(123)
 *                                         .build())
 *                                 .osFamily("osFamily")
 *                                 .vCpuCount(VCpuCountRangeProperty.builder()
 *                                         .min(123)
 *                                         // the properties below are optional
 *                                         .max(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .acceleratorCapabilities(AcceleratorCapabilitiesProperty.builder()
 *                                         .selections(List.of(AcceleratorSelectionProperty.builder()
 *                                                 .name("name")
 *                                                 // the properties below are optional
 *                                                 .runtime("runtime")
 *                                                 .build()))
 *                                         // the properties below are optional
 *                                         .count(AcceleratorCountRangeProperty.builder()
 *                                                 .min(123)
 *                                                 // the properties below are optional
 *                                                 .max(123)
 *                                                 .build())
 *                                         .build())
 *                                 .allowedInstanceTypes(List.of("allowedInstanceTypes"))
 *                                 .customAmounts(List.of(FleetAmountCapabilityProperty.builder()
 *                                         .min(123)
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .max(123)
 *                                         .build()))
 *                                 .customAttributes(List.of(FleetAttributeCapabilityProperty.builder()
 *                                         .name("name")
 *                                         .values(List.of("values"))
 *                                         .build()))
 *                                 .excludedInstanceTypes(List.of("excludedInstanceTypes"))
 *                                 .rootEbsVolume(Ec2EbsVolumeProperty.builder()
 *                                         .iops(123)
 *                                         .sizeGiB(123)
 *                                         .throughputMiB(123)
 *                                         .build())
 *                                 .build())
 *                         .instanceMarketOptions(ServiceManagedEc2InstanceMarketOptionsProperty.builder()
 *                                 .type("type")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .displayName("displayName")
 *         .farmId("farmId")
 *         .maxWorkerCount(123)
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .description("description")
 *         .minWorkerCount(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:22.441Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnFleet")
public class CfnFleet extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnFleet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFleet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.deadline.CfnFleet.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFleet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.deadline.CfnFleetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) assigned to the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrCapabilities() {
        return software.amazon.jsii.Kernel.get(this, "attrCapabilities", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The fleet ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFleetId() {
        return software.amazon.jsii.Kernel.get(this, "attrFleetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The number of workers in the fleet summary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrWorkerCount() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkerCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The configuration details for the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration details for the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configuration", java.util.Objects.requireNonNull(value, "configuration is required"));
    }

    /**
     * The configuration details for the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.deadline.CfnFleet.FleetConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "configuration", java.util.Objects.requireNonNull(value, "configuration is required"));
    }

    /**
     * The display name of the fleet summary to update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDisplayName() {
        return software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The display name of the fleet summary to update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisplayName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "displayName", java.util.Objects.requireNonNull(value, "displayName is required"));
    }

    /**
     * The farm ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFarmId() {
        return software.amazon.jsii.Kernel.get(this, "farmId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The farm ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFarmId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "farmId", java.util.Objects.requireNonNull(value, "farmId is required"));
    }

    /**
     * The maximum number of workers specified in the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getMaxWorkerCount() {
        return software.amazon.jsii.Kernel.get(this, "maxWorkerCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum number of workers specified in the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxWorkerCount(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxWorkerCount", java.util.Objects.requireNonNull(value, "maxWorkerCount is required"));
    }

    /**
     * The IAM role that workers in the fleet use when processing jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IAM role that workers in the fleet use when processing jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * A description that helps identify what the fleet is used for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description that helps identify what the fleet is used for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The minimum number of workers in the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMinWorkerCount() {
        return software.amazon.jsii.Kernel.get(this, "minWorkerCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The minimum number of workers in the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMinWorkerCount(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "minWorkerCount", value);
    }

    /**
     * The tags to add to your fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags to add to your fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Provides information about the GPU accelerators used for jobs processed by a fleet.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.deadline.*;
     * AcceleratorCapabilitiesProperty acceleratorCapabilitiesProperty = AcceleratorCapabilitiesProperty.builder()
     *         .selections(List.of(AcceleratorSelectionProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .runtime("runtime")
     *                 .build()))
     *         // the properties below are optional
     *         .count(AcceleratorCountRangeProperty.builder()
     *                 .min(123)
     *                 // the properties below are optional
     *                 .max(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-acceleratorcapabilities.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-acceleratorcapabilities.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnFleet.AcceleratorCapabilitiesProperty")
    @software.amazon.jsii.Jsii.Proxy(AcceleratorCapabilitiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AcceleratorCapabilitiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of accelerator capabilities requested for this fleet.
         * <p>
         * Only Amazon Elastic Compute Cloud instances that provide these capabilities will be used. For example, if you specify both L4 and T4 chips, Deadline Cloud will use Amazon EC2 instances that have either the L4 or the T4 chip installed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-acceleratorcapabilities.html#cfn-deadline-fleet-acceleratorcapabilities-selections">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-acceleratorcapabilities.html#cfn-deadline-fleet-acceleratorcapabilities-selections</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSelections();

        /**
         * The number of GPU accelerators specified for worker hosts in this fleet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-acceleratorcapabilities.html#cfn-deadline-fleet-acceleratorcapabilities-count">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-acceleratorcapabilities.html#cfn-deadline-fleet-acceleratorcapabilities-count</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCount() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AcceleratorCapabilitiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AcceleratorCapabilitiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AcceleratorCapabilitiesProperty> {
            java.lang.Object selections;
            java.lang.Object count;

            /**
             * Sets the value of {@link AcceleratorCapabilitiesProperty#getSelections}
             * @param selections A list of accelerator capabilities requested for this fleet. This parameter is required.
             *                   Only Amazon Elastic Compute Cloud instances that provide these capabilities will be used. For example, if you specify both L4 and T4 chips, Deadline Cloud will use Amazon EC2 instances that have either the L4 or the T4 chip installed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selections(software.amazon.awscdk.IResolvable selections) {
                this.selections = selections;
                return this;
            }

            /**
             * Sets the value of {@link AcceleratorCapabilitiesProperty#getSelections}
             * @param selections A list of accelerator capabilities requested for this fleet. This parameter is required.
             *                   Only Amazon Elastic Compute Cloud instances that provide these capabilities will be used. For example, if you specify both L4 and T4 chips, Deadline Cloud will use Amazon EC2 instances that have either the L4 or the T4 chip installed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selections(java.util.List<? extends java.lang.Object> selections) {
                this.selections = selections;
                return this;
            }

            /**
             * Sets the value of {@link AcceleratorCapabilitiesProperty#getCount}
             * @param count The number of GPU accelerators specified for worker hosts in this fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder count(software.amazon.awscdk.IResolvable count) {
                this.count = count;
                return this;
            }

            /**
             * Sets the value of {@link AcceleratorCapabilitiesProperty#getCount}
             * @param count The number of GPU accelerators specified for worker hosts in this fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder count(software.amazon.awscdk.services.deadline.CfnFleet.AcceleratorCountRangeProperty count) {
                this.count = count;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AcceleratorCapabilitiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AcceleratorCapabilitiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AcceleratorCapabilitiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AcceleratorCapabilitiesProperty {
            private final java.lang.Object selections;
            private final java.lang.Object count;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.selections = software.amazon.jsii.Kernel.get(this, "selections", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.selections = java.util.Objects.requireNonNull(builder.selections, "selections is required");
                this.count = builder.count;
            }

            @Override
            public final java.lang.Object getSelections() {
                return this.selections;
            }

            @Override
            public final java.lang.Object getCount() {
                return this.count;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("selections", om.valueToTree(this.getSelections()));
                if (this.getCount() != null) {
                    data.set("count", om.valueToTree(this.getCount()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnFleet.AcceleratorCapabilitiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AcceleratorCapabilitiesProperty.Jsii$Proxy that = (AcceleratorCapabilitiesProperty.Jsii$Proxy) o;

                if (!selections.equals(that.selections)) return false;
                return this.count != null ? this.count.equals(that.count) : that.count == null;
            }

            @Override
            public final int hashCode() {
                int result = this.selections.hashCode();
                result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the maximum and minimum number of GPU accelerators required for a worker instance..
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.deadline.*;
     * AcceleratorCountRangeProperty acceleratorCountRangeProperty = AcceleratorCountRangeProperty.builder()
     *         .min(123)
     *         // the properties below are optional
     *         .max(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-acceleratorcountrange.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-acceleratorcountrange.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnFleet.AcceleratorCountRangeProperty")
    @software.amazon.jsii.Jsii.Proxy(AcceleratorCountRangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AcceleratorCountRangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The minimum number of GPU accelerators in the worker host.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-acceleratorcountrange.html#cfn-deadline-fleet-acceleratorcountrange-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-acceleratorcountrange.html#cfn-deadline-fleet-acceleratorcountrange-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMin();

        /**
         * The maximum number of GPU accelerators in the worker host.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-acceleratorcountrange.html#cfn-deadline-fleet-acceleratorcountrange-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-acceleratorcountrange.html#cfn-deadline-fleet-acceleratorcountrange-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AcceleratorCountRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AcceleratorCountRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AcceleratorCountRangeProperty> {
            java.lang.Number min;
            java.lang.Number max;

            /**
             * Sets the value of {@link AcceleratorCountRangeProperty#getMin}
             * @param min The minimum number of GPU accelerators in the worker host. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Sets the value of {@link AcceleratorCountRangeProperty#getMax}
             * @param max The maximum number of GPU accelerators in the worker host.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AcceleratorCountRangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AcceleratorCountRangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AcceleratorCountRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AcceleratorCountRangeProperty {
            private final java.lang.Number min;
            private final java.lang.Number max;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.min = java.util.Objects.requireNonNull(builder.min, "min is required");
                this.max = builder.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("min", om.valueToTree(this.getMin()));
                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnFleet.AcceleratorCountRangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AcceleratorCountRangeProperty.Jsii$Proxy that = (AcceleratorCountRangeProperty.Jsii$Proxy) o;

                if (!min.equals(that.min)) return false;
                return this.max != null ? this.max.equals(that.max) : that.max == null;
            }

            @Override
            public final int hashCode() {
                int result = this.min.hashCode();
                result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a specific GPU accelerator required for an Amazon Elastic Compute Cloud worker host.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.deadline.*;
     * AcceleratorSelectionProperty acceleratorSelectionProperty = AcceleratorSelectionProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .runtime("runtime")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-acceleratorselection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-acceleratorselection.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnFleet.AcceleratorSelectionProperty")
    @software.amazon.jsii.Jsii.Proxy(AcceleratorSelectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AcceleratorSelectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the chip used by the GPU accelerator.
         * <p>
         * If you specify <code>l4</code> as the name of the accelerator, you must specify <code>latest</code> or <code>grid:r550</code> as the runtime.
         * <p>
         * The available GPU accelerators are:
         * <p>
         * <ul>
         * <li><code>t4</code> - NVIDIA T4 Tensor Core GPU</li>
         * <li><code>a10g</code> - NVIDIA A10G Tensor Core GPU</li>
         * <li><code>l4</code> - NVIDIA L4 Tensor Core GPU</li>
         * <li><code>l40s</code> - NVIDIA L40S Tensor Core GPU</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-acceleratorselection.html#cfn-deadline-fleet-acceleratorselection-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-acceleratorselection.html#cfn-deadline-fleet-acceleratorselection-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Specifies the runtime driver to use for the GPU accelerator. You must use the same runtime for all GPUs.
         * <p>
         * You can choose from the following runtimes:
         * <p>
         * <ul>
         * <li><code>latest</code> - Use the latest runtime available for the chip. If you specify <code>latest</code> and a new version of the runtime is released, the new version of the runtime is used.</li>
         * <li><code>grid:r550</code> - <a href="https://docs.aws.amazon.com/https://docs.nvidia.com/vgpu/17.0/index.html">NVIDIA vGPU software 17</a></li>
         * <li><code>grid:r535</code> - <a href="https://docs.aws.amazon.com/https://docs.nvidia.com/vgpu/16.0/index.html">NVIDIA vGPU software 16</a></li>
         * </ul>
         * <p>
         * If you don't specify a runtime, Deadline Cloud uses <code>latest</code> as the default. However, if you have multiple accelerators and specify <code>latest</code> for some and leave others blank, Deadline Cloud raises an exception.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-acceleratorselection.html#cfn-deadline-fleet-acceleratorselection-runtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-acceleratorselection.html#cfn-deadline-fleet-acceleratorselection-runtime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRuntime() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AcceleratorSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AcceleratorSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AcceleratorSelectionProperty> {
            java.lang.String name;
            java.lang.String runtime;

            /**
             * Sets the value of {@link AcceleratorSelectionProperty#getName}
             * @param name The name of the chip used by the GPU accelerator. This parameter is required.
             *             If you specify <code>l4</code> as the name of the accelerator, you must specify <code>latest</code> or <code>grid:r550</code> as the runtime.
             *             <p>
             *             The available GPU accelerators are:
             *             <p>
             *             <ul>
             *             <li><code>t4</code> - NVIDIA T4 Tensor Core GPU</li>
             *             <li><code>a10g</code> - NVIDIA A10G Tensor Core GPU</li>
             *             <li><code>l4</code> - NVIDIA L4 Tensor Core GPU</li>
             *             <li><code>l40s</code> - NVIDIA L40S Tensor Core GPU</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link AcceleratorSelectionProperty#getRuntime}
             * @param runtime Specifies the runtime driver to use for the GPU accelerator. You must use the same runtime for all GPUs.
             *                You can choose from the following runtimes:
             *                <p>
             *                <ul>
             *                <li><code>latest</code> - Use the latest runtime available for the chip. If you specify <code>latest</code> and a new version of the runtime is released, the new version of the runtime is used.</li>
             *                <li><code>grid:r550</code> - <a href="https://docs.aws.amazon.com/https://docs.nvidia.com/vgpu/17.0/index.html">NVIDIA vGPU software 17</a></li>
             *                <li><code>grid:r535</code> - <a href="https://docs.aws.amazon.com/https://docs.nvidia.com/vgpu/16.0/index.html">NVIDIA vGPU software 16</a></li>
             *                </ul>
             *                <p>
             *                If you don't specify a runtime, Deadline Cloud uses <code>latest</code> as the default. However, if you have multiple accelerators and specify <code>latest</code> for some and leave others blank, Deadline Cloud raises an exception.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runtime(java.lang.String runtime) {
                this.runtime = runtime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AcceleratorSelectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AcceleratorSelectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AcceleratorSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AcceleratorSelectionProperty {
            private final java.lang.String name;
            private final java.lang.String runtime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.runtime = software.amazon.jsii.Kernel.get(this, "runtime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.runtime = builder.runtime;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getRuntime() {
                return this.runtime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getRuntime() != null) {
                    data.set("runtime", om.valueToTree(this.getRuntime()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnFleet.AcceleratorSelectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AcceleratorSelectionProperty.Jsii$Proxy that = (AcceleratorSelectionProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.runtime != null ? this.runtime.equals(that.runtime) : that.runtime == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.runtime != null ? this.runtime.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the maximum and minimum amount of memory, in MiB, to use for the accelerator.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.deadline.*;
     * AcceleratorTotalMemoryMiBRangeProperty acceleratorTotalMemoryMiBRangeProperty = AcceleratorTotalMemoryMiBRangeProperty.builder()
     *         .min(123)
     *         // the properties below are optional
     *         .max(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-acceleratortotalmemorymibrange.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-acceleratortotalmemorymibrange.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnFleet.AcceleratorTotalMemoryMiBRangeProperty")
    @software.amazon.jsii.Jsii.Proxy(AcceleratorTotalMemoryMiBRangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AcceleratorTotalMemoryMiBRangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The minimum amount of memory to use for the accelerator, measured in MiB.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-acceleratortotalmemorymibrange.html#cfn-deadline-fleet-acceleratortotalmemorymibrange-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-acceleratortotalmemorymibrange.html#cfn-deadline-fleet-acceleratortotalmemorymibrange-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMin();

        /**
         * The maximum amount of memory to use for the accelerator, measured in MiB.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-acceleratortotalmemorymibrange.html#cfn-deadline-fleet-acceleratortotalmemorymibrange-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-acceleratortotalmemorymibrange.html#cfn-deadline-fleet-acceleratortotalmemorymibrange-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AcceleratorTotalMemoryMiBRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AcceleratorTotalMemoryMiBRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AcceleratorTotalMemoryMiBRangeProperty> {
            java.lang.Number min;
            java.lang.Number max;

            /**
             * Sets the value of {@link AcceleratorTotalMemoryMiBRangeProperty#getMin}
             * @param min The minimum amount of memory to use for the accelerator, measured in MiB. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Sets the value of {@link AcceleratorTotalMemoryMiBRangeProperty#getMax}
             * @param max The maximum amount of memory to use for the accelerator, measured in MiB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AcceleratorTotalMemoryMiBRangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AcceleratorTotalMemoryMiBRangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AcceleratorTotalMemoryMiBRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AcceleratorTotalMemoryMiBRangeProperty {
            private final java.lang.Number min;
            private final java.lang.Number max;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.min = java.util.Objects.requireNonNull(builder.min, "min is required");
                this.max = builder.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("min", om.valueToTree(this.getMin()));
                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnFleet.AcceleratorTotalMemoryMiBRangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AcceleratorTotalMemoryMiBRangeProperty.Jsii$Proxy that = (AcceleratorTotalMemoryMiBRangeProperty.Jsii$Proxy) o;

                if (!min.equals(that.min)) return false;
                return this.max != null ? this.max.equals(that.max) : that.max == null;
            }

            @Override
            public final int hashCode() {
                int result = this.min.hashCode();
                result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The details of a customer managed fleet configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.deadline.*;
     * CustomerManagedFleetConfigurationProperty customerManagedFleetConfigurationProperty = CustomerManagedFleetConfigurationProperty.builder()
     *         .mode("mode")
     *         .workerCapabilities(CustomerManagedWorkerCapabilitiesProperty.builder()
     *                 .cpuArchitectureType("cpuArchitectureType")
     *                 .memoryMiB(MemoryMiBRangeProperty.builder()
     *                         .min(123)
     *                         // the properties below are optional
     *                         .max(123)
     *                         .build())
     *                 .osFamily("osFamily")
     *                 .vCpuCount(VCpuCountRangeProperty.builder()
     *                         .min(123)
     *                         // the properties below are optional
     *                         .max(123)
     *                         .build())
     *                 // the properties below are optional
     *                 .acceleratorCount(AcceleratorCountRangeProperty.builder()
     *                         .min(123)
     *                         // the properties below are optional
     *                         .max(123)
     *                         .build())
     *                 .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRangeProperty.builder()
     *                         .min(123)
     *                         // the properties below are optional
     *                         .max(123)
     *                         .build())
     *                 .acceleratorTypes(List.of("acceleratorTypes"))
     *                 .customAmounts(List.of(FleetAmountCapabilityProperty.builder()
     *                         .min(123)
     *                         .name("name")
     *                         // the properties below are optional
     *                         .max(123)
     *                         .build()))
     *                 .customAttributes(List.of(FleetAttributeCapabilityProperty.builder()
     *                         .name("name")
     *                         .values(List.of("values"))
     *                         .build()))
     *                 .build())
     *         // the properties below are optional
     *         .storageProfileId("storageProfileId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedfleetconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedfleetconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnFleet.CustomerManagedFleetConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomerManagedFleetConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomerManagedFleetConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS Auto Scaling mode for the customer managed fleet configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedfleetconfiguration.html#cfn-deadline-fleet-customermanagedfleetconfiguration-mode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedfleetconfiguration.html#cfn-deadline-fleet-customermanagedfleetconfiguration-mode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMode();

        /**
         * The worker capabilities for a customer managed fleet configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedfleetconfiguration.html#cfn-deadline-fleet-customermanagedfleetconfiguration-workercapabilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedfleetconfiguration.html#cfn-deadline-fleet-customermanagedfleetconfiguration-workercapabilities</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getWorkerCapabilities();

        /**
         * The storage profile ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedfleetconfiguration.html#cfn-deadline-fleet-customermanagedfleetconfiguration-storageprofileid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedfleetconfiguration.html#cfn-deadline-fleet-customermanagedfleetconfiguration-storageprofileid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStorageProfileId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomerManagedFleetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomerManagedFleetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomerManagedFleetConfigurationProperty> {
            java.lang.String mode;
            java.lang.Object workerCapabilities;
            java.lang.String storageProfileId;

            /**
             * Sets the value of {@link CustomerManagedFleetConfigurationProperty#getMode}
             * @param mode The AWS Auto Scaling mode for the customer managed fleet configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mode(java.lang.String mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Sets the value of {@link CustomerManagedFleetConfigurationProperty#getWorkerCapabilities}
             * @param workerCapabilities The worker capabilities for a customer managed fleet configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workerCapabilities(software.amazon.awscdk.IResolvable workerCapabilities) {
                this.workerCapabilities = workerCapabilities;
                return this;
            }

            /**
             * Sets the value of {@link CustomerManagedFleetConfigurationProperty#getWorkerCapabilities}
             * @param workerCapabilities The worker capabilities for a customer managed fleet configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workerCapabilities(software.amazon.awscdk.services.deadline.CfnFleet.CustomerManagedWorkerCapabilitiesProperty workerCapabilities) {
                this.workerCapabilities = workerCapabilities;
                return this;
            }

            /**
             * Sets the value of {@link CustomerManagedFleetConfigurationProperty#getStorageProfileId}
             * @param storageProfileId The storage profile ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageProfileId(java.lang.String storageProfileId) {
                this.storageProfileId = storageProfileId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomerManagedFleetConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomerManagedFleetConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomerManagedFleetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomerManagedFleetConfigurationProperty {
            private final java.lang.String mode;
            private final java.lang.Object workerCapabilities;
            private final java.lang.String storageProfileId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.workerCapabilities = software.amazon.jsii.Kernel.get(this, "workerCapabilities", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.storageProfileId = software.amazon.jsii.Kernel.get(this, "storageProfileId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mode = java.util.Objects.requireNonNull(builder.mode, "mode is required");
                this.workerCapabilities = java.util.Objects.requireNonNull(builder.workerCapabilities, "workerCapabilities is required");
                this.storageProfileId = builder.storageProfileId;
            }

            @Override
            public final java.lang.String getMode() {
                return this.mode;
            }

            @Override
            public final java.lang.Object getWorkerCapabilities() {
                return this.workerCapabilities;
            }

            @Override
            public final java.lang.String getStorageProfileId() {
                return this.storageProfileId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mode", om.valueToTree(this.getMode()));
                data.set("workerCapabilities", om.valueToTree(this.getWorkerCapabilities()));
                if (this.getStorageProfileId() != null) {
                    data.set("storageProfileId", om.valueToTree(this.getStorageProfileId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnFleet.CustomerManagedFleetConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomerManagedFleetConfigurationProperty.Jsii$Proxy that = (CustomerManagedFleetConfigurationProperty.Jsii$Proxy) o;

                if (!mode.equals(that.mode)) return false;
                if (!workerCapabilities.equals(that.workerCapabilities)) return false;
                return this.storageProfileId != null ? this.storageProfileId.equals(that.storageProfileId) : that.storageProfileId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.mode.hashCode();
                result = 31 * result + (this.workerCapabilities.hashCode());
                result = 31 * result + (this.storageProfileId != null ? this.storageProfileId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The worker capabilities for a customer managed workflow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.deadline.*;
     * CustomerManagedWorkerCapabilitiesProperty customerManagedWorkerCapabilitiesProperty = CustomerManagedWorkerCapabilitiesProperty.builder()
     *         .cpuArchitectureType("cpuArchitectureType")
     *         .memoryMiB(MemoryMiBRangeProperty.builder()
     *                 .min(123)
     *                 // the properties below are optional
     *                 .max(123)
     *                 .build())
     *         .osFamily("osFamily")
     *         .vCpuCount(VCpuCountRangeProperty.builder()
     *                 .min(123)
     *                 // the properties below are optional
     *                 .max(123)
     *                 .build())
     *         // the properties below are optional
     *         .acceleratorCount(AcceleratorCountRangeProperty.builder()
     *                 .min(123)
     *                 // the properties below are optional
     *                 .max(123)
     *                 .build())
     *         .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRangeProperty.builder()
     *                 .min(123)
     *                 // the properties below are optional
     *                 .max(123)
     *                 .build())
     *         .acceleratorTypes(List.of("acceleratorTypes"))
     *         .customAmounts(List.of(FleetAmountCapabilityProperty.builder()
     *                 .min(123)
     *                 .name("name")
     *                 // the properties below are optional
     *                 .max(123)
     *                 .build()))
     *         .customAttributes(List.of(FleetAttributeCapabilityProperty.builder()
     *                 .name("name")
     *                 .values(List.of("values"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedworkercapabilities.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedworkercapabilities.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnFleet.CustomerManagedWorkerCapabilitiesProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomerManagedWorkerCapabilitiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomerManagedWorkerCapabilitiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The CPU architecture type for the customer managed worker capabilities.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedworkercapabilities.html#cfn-deadline-fleet-customermanagedworkercapabilities-cpuarchitecturetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedworkercapabilities.html#cfn-deadline-fleet-customermanagedworkercapabilities-cpuarchitecturetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCpuArchitectureType();

        /**
         * The memory (MiB).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedworkercapabilities.html#cfn-deadline-fleet-customermanagedworkercapabilities-memorymib">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedworkercapabilities.html#cfn-deadline-fleet-customermanagedworkercapabilities-memorymib</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMemoryMiB();

        /**
         * The operating system (OS) family.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedworkercapabilities.html#cfn-deadline-fleet-customermanagedworkercapabilities-osfamily">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedworkercapabilities.html#cfn-deadline-fleet-customermanagedworkercapabilities-osfamily</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOsFamily();

        /**
         * The vCPU count for the customer manged worker capabilities.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedworkercapabilities.html#cfn-deadline-fleet-customermanagedworkercapabilities-vcpucount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedworkercapabilities.html#cfn-deadline-fleet-customermanagedworkercapabilities-vcpucount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getVCpuCount();

        /**
         * The range of the accelerator.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedworkercapabilities.html#cfn-deadline-fleet-customermanagedworkercapabilities-acceleratorcount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedworkercapabilities.html#cfn-deadline-fleet-customermanagedworkercapabilities-acceleratorcount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAcceleratorCount() {
            return null;
        }

        /**
         * The total memory (MiB) for the customer managed worker capabilities.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedworkercapabilities.html#cfn-deadline-fleet-customermanagedworkercapabilities-acceleratortotalmemorymib">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedworkercapabilities.html#cfn-deadline-fleet-customermanagedworkercapabilities-acceleratortotalmemorymib</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAcceleratorTotalMemoryMiB() {
            return null;
        }

        /**
         * The accelerator types for the customer managed worker capabilities.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedworkercapabilities.html#cfn-deadline-fleet-customermanagedworkercapabilities-acceleratortypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedworkercapabilities.html#cfn-deadline-fleet-customermanagedworkercapabilities-acceleratortypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAcceleratorTypes() {
            return null;
        }

        /**
         * Custom requirement ranges for customer managed worker capabilities.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedworkercapabilities.html#cfn-deadline-fleet-customermanagedworkercapabilities-customamounts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedworkercapabilities.html#cfn-deadline-fleet-customermanagedworkercapabilities-customamounts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomAmounts() {
            return null;
        }

        /**
         * Custom attributes for the customer manged worker capabilities.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedworkercapabilities.html#cfn-deadline-fleet-customermanagedworkercapabilities-customattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-customermanagedworkercapabilities.html#cfn-deadline-fleet-customermanagedworkercapabilities-customattributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomAttributes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomerManagedWorkerCapabilitiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomerManagedWorkerCapabilitiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomerManagedWorkerCapabilitiesProperty> {
            java.lang.String cpuArchitectureType;
            java.lang.Object memoryMiB;
            java.lang.String osFamily;
            java.lang.Object vCpuCount;
            java.lang.Object acceleratorCount;
            java.lang.Object acceleratorTotalMemoryMiB;
            java.util.List<java.lang.String> acceleratorTypes;
            java.lang.Object customAmounts;
            java.lang.Object customAttributes;

            /**
             * Sets the value of {@link CustomerManagedWorkerCapabilitiesProperty#getCpuArchitectureType}
             * @param cpuArchitectureType The CPU architecture type for the customer managed worker capabilities. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpuArchitectureType(java.lang.String cpuArchitectureType) {
                this.cpuArchitectureType = cpuArchitectureType;
                return this;
            }

            /**
             * Sets the value of {@link CustomerManagedWorkerCapabilitiesProperty#getMemoryMiB}
             * @param memoryMiB The memory (MiB). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryMiB(software.amazon.awscdk.IResolvable memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link CustomerManagedWorkerCapabilitiesProperty#getMemoryMiB}
             * @param memoryMiB The memory (MiB). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryMiB(software.amazon.awscdk.services.deadline.CfnFleet.MemoryMiBRangeProperty memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link CustomerManagedWorkerCapabilitiesProperty#getOsFamily}
             * @param osFamily The operating system (OS) family. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder osFamily(java.lang.String osFamily) {
                this.osFamily = osFamily;
                return this;
            }

            /**
             * Sets the value of {@link CustomerManagedWorkerCapabilitiesProperty#getVCpuCount}
             * @param vCpuCount The vCPU count for the customer manged worker capabilities. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vCpuCount(software.amazon.awscdk.IResolvable vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            /**
             * Sets the value of {@link CustomerManagedWorkerCapabilitiesProperty#getVCpuCount}
             * @param vCpuCount The vCPU count for the customer manged worker capabilities. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vCpuCount(software.amazon.awscdk.services.deadline.CfnFleet.VCpuCountRangeProperty vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            /**
             * Sets the value of {@link CustomerManagedWorkerCapabilitiesProperty#getAcceleratorCount}
             * @param acceleratorCount The range of the accelerator.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorCount(software.amazon.awscdk.IResolvable acceleratorCount) {
                this.acceleratorCount = acceleratorCount;
                return this;
            }

            /**
             * Sets the value of {@link CustomerManagedWorkerCapabilitiesProperty#getAcceleratorCount}
             * @param acceleratorCount The range of the accelerator.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorCount(software.amazon.awscdk.services.deadline.CfnFleet.AcceleratorCountRangeProperty acceleratorCount) {
                this.acceleratorCount = acceleratorCount;
                return this;
            }

            /**
             * Sets the value of {@link CustomerManagedWorkerCapabilitiesProperty#getAcceleratorTotalMemoryMiB}
             * @param acceleratorTotalMemoryMiB The total memory (MiB) for the customer managed worker capabilities.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorTotalMemoryMiB(software.amazon.awscdk.IResolvable acceleratorTotalMemoryMiB) {
                this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link CustomerManagedWorkerCapabilitiesProperty#getAcceleratorTotalMemoryMiB}
             * @param acceleratorTotalMemoryMiB The total memory (MiB) for the customer managed worker capabilities.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorTotalMemoryMiB(software.amazon.awscdk.services.deadline.CfnFleet.AcceleratorTotalMemoryMiBRangeProperty acceleratorTotalMemoryMiB) {
                this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link CustomerManagedWorkerCapabilitiesProperty#getAcceleratorTypes}
             * @param acceleratorTypes The accelerator types for the customer managed worker capabilities.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorTypes(java.util.List<java.lang.String> acceleratorTypes) {
                this.acceleratorTypes = acceleratorTypes;
                return this;
            }

            /**
             * Sets the value of {@link CustomerManagedWorkerCapabilitiesProperty#getCustomAmounts}
             * @param customAmounts Custom requirement ranges for customer managed worker capabilities.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customAmounts(software.amazon.awscdk.IResolvable customAmounts) {
                this.customAmounts = customAmounts;
                return this;
            }

            /**
             * Sets the value of {@link CustomerManagedWorkerCapabilitiesProperty#getCustomAmounts}
             * @param customAmounts Custom requirement ranges for customer managed worker capabilities.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customAmounts(java.util.List<? extends java.lang.Object> customAmounts) {
                this.customAmounts = customAmounts;
                return this;
            }

            /**
             * Sets the value of {@link CustomerManagedWorkerCapabilitiesProperty#getCustomAttributes}
             * @param customAttributes Custom attributes for the customer manged worker capabilities.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customAttributes(software.amazon.awscdk.IResolvable customAttributes) {
                this.customAttributes = customAttributes;
                return this;
            }

            /**
             * Sets the value of {@link CustomerManagedWorkerCapabilitiesProperty#getCustomAttributes}
             * @param customAttributes Custom attributes for the customer manged worker capabilities.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customAttributes(java.util.List<? extends java.lang.Object> customAttributes) {
                this.customAttributes = customAttributes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomerManagedWorkerCapabilitiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomerManagedWorkerCapabilitiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomerManagedWorkerCapabilitiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomerManagedWorkerCapabilitiesProperty {
            private final java.lang.String cpuArchitectureType;
            private final java.lang.Object memoryMiB;
            private final java.lang.String osFamily;
            private final java.lang.Object vCpuCount;
            private final java.lang.Object acceleratorCount;
            private final java.lang.Object acceleratorTotalMemoryMiB;
            private final java.util.List<java.lang.String> acceleratorTypes;
            private final java.lang.Object customAmounts;
            private final java.lang.Object customAttributes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cpuArchitectureType = software.amazon.jsii.Kernel.get(this, "cpuArchitectureType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.memoryMiB = software.amazon.jsii.Kernel.get(this, "memoryMiB", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.osFamily = software.amazon.jsii.Kernel.get(this, "osFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vCpuCount = software.amazon.jsii.Kernel.get(this, "vCpuCount", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.acceleratorCount = software.amazon.jsii.Kernel.get(this, "acceleratorCount", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.acceleratorTotalMemoryMiB = software.amazon.jsii.Kernel.get(this, "acceleratorTotalMemoryMiB", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.acceleratorTypes = software.amazon.jsii.Kernel.get(this, "acceleratorTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.customAmounts = software.amazon.jsii.Kernel.get(this, "customAmounts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customAttributes = software.amazon.jsii.Kernel.get(this, "customAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cpuArchitectureType = java.util.Objects.requireNonNull(builder.cpuArchitectureType, "cpuArchitectureType is required");
                this.memoryMiB = java.util.Objects.requireNonNull(builder.memoryMiB, "memoryMiB is required");
                this.osFamily = java.util.Objects.requireNonNull(builder.osFamily, "osFamily is required");
                this.vCpuCount = java.util.Objects.requireNonNull(builder.vCpuCount, "vCpuCount is required");
                this.acceleratorCount = builder.acceleratorCount;
                this.acceleratorTotalMemoryMiB = builder.acceleratorTotalMemoryMiB;
                this.acceleratorTypes = builder.acceleratorTypes;
                this.customAmounts = builder.customAmounts;
                this.customAttributes = builder.customAttributes;
            }

            @Override
            public final java.lang.String getCpuArchitectureType() {
                return this.cpuArchitectureType;
            }

            @Override
            public final java.lang.Object getMemoryMiB() {
                return this.memoryMiB;
            }

            @Override
            public final java.lang.String getOsFamily() {
                return this.osFamily;
            }

            @Override
            public final java.lang.Object getVCpuCount() {
                return this.vCpuCount;
            }

            @Override
            public final java.lang.Object getAcceleratorCount() {
                return this.acceleratorCount;
            }

            @Override
            public final java.lang.Object getAcceleratorTotalMemoryMiB() {
                return this.acceleratorTotalMemoryMiB;
            }

            @Override
            public final java.util.List<java.lang.String> getAcceleratorTypes() {
                return this.acceleratorTypes;
            }

            @Override
            public final java.lang.Object getCustomAmounts() {
                return this.customAmounts;
            }

            @Override
            public final java.lang.Object getCustomAttributes() {
                return this.customAttributes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cpuArchitectureType", om.valueToTree(this.getCpuArchitectureType()));
                data.set("memoryMiB", om.valueToTree(this.getMemoryMiB()));
                data.set("osFamily", om.valueToTree(this.getOsFamily()));
                data.set("vCpuCount", om.valueToTree(this.getVCpuCount()));
                if (this.getAcceleratorCount() != null) {
                    data.set("acceleratorCount", om.valueToTree(this.getAcceleratorCount()));
                }
                if (this.getAcceleratorTotalMemoryMiB() != null) {
                    data.set("acceleratorTotalMemoryMiB", om.valueToTree(this.getAcceleratorTotalMemoryMiB()));
                }
                if (this.getAcceleratorTypes() != null) {
                    data.set("acceleratorTypes", om.valueToTree(this.getAcceleratorTypes()));
                }
                if (this.getCustomAmounts() != null) {
                    data.set("customAmounts", om.valueToTree(this.getCustomAmounts()));
                }
                if (this.getCustomAttributes() != null) {
                    data.set("customAttributes", om.valueToTree(this.getCustomAttributes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnFleet.CustomerManagedWorkerCapabilitiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomerManagedWorkerCapabilitiesProperty.Jsii$Proxy that = (CustomerManagedWorkerCapabilitiesProperty.Jsii$Proxy) o;

                if (!cpuArchitectureType.equals(that.cpuArchitectureType)) return false;
                if (!memoryMiB.equals(that.memoryMiB)) return false;
                if (!osFamily.equals(that.osFamily)) return false;
                if (!vCpuCount.equals(that.vCpuCount)) return false;
                if (this.acceleratorCount != null ? !this.acceleratorCount.equals(that.acceleratorCount) : that.acceleratorCount != null) return false;
                if (this.acceleratorTotalMemoryMiB != null ? !this.acceleratorTotalMemoryMiB.equals(that.acceleratorTotalMemoryMiB) : that.acceleratorTotalMemoryMiB != null) return false;
                if (this.acceleratorTypes != null ? !this.acceleratorTypes.equals(that.acceleratorTypes) : that.acceleratorTypes != null) return false;
                if (this.customAmounts != null ? !this.customAmounts.equals(that.customAmounts) : that.customAmounts != null) return false;
                return this.customAttributes != null ? this.customAttributes.equals(that.customAttributes) : that.customAttributes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cpuArchitectureType.hashCode();
                result = 31 * result + (this.memoryMiB.hashCode());
                result = 31 * result + (this.osFamily.hashCode());
                result = 31 * result + (this.vCpuCount.hashCode());
                result = 31 * result + (this.acceleratorCount != null ? this.acceleratorCount.hashCode() : 0);
                result = 31 * result + (this.acceleratorTotalMemoryMiB != null ? this.acceleratorTotalMemoryMiB.hashCode() : 0);
                result = 31 * result + (this.acceleratorTypes != null ? this.acceleratorTypes.hashCode() : 0);
                result = 31 * result + (this.customAmounts != null ? this.customAmounts.hashCode() : 0);
                result = 31 * result + (this.customAttributes != null ? this.customAttributes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the EBS volume.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.deadline.*;
     * Ec2EbsVolumeProperty ec2EbsVolumeProperty = Ec2EbsVolumeProperty.builder()
     *         .iops(123)
     *         .sizeGiB(123)
     *         .throughputMiB(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-ec2ebsvolume.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-ec2ebsvolume.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnFleet.Ec2EbsVolumeProperty")
    @software.amazon.jsii.Jsii.Proxy(Ec2EbsVolumeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Ec2EbsVolumeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IOPS per volume.
         * <p>
         * Default: - 3000
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-ec2ebsvolume.html#cfn-deadline-fleet-ec2ebsvolume-iops">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-ec2ebsvolume.html#cfn-deadline-fleet-ec2ebsvolume-iops</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
            return null;
        }

        /**
         * The EBS volume size in GiB.
         * <p>
         * Default: - 250
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-ec2ebsvolume.html#cfn-deadline-fleet-ec2ebsvolume-sizegib">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-ec2ebsvolume.html#cfn-deadline-fleet-ec2ebsvolume-sizegib</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSizeGiB() {
            return null;
        }

        /**
         * The throughput per volume in MiB.
         * <p>
         * Default: - 125
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-ec2ebsvolume.html#cfn-deadline-fleet-ec2ebsvolume-throughputmib">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-ec2ebsvolume.html#cfn-deadline-fleet-ec2ebsvolume-throughputmib</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThroughputMiB() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Ec2EbsVolumeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Ec2EbsVolumeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Ec2EbsVolumeProperty> {
            java.lang.Number iops;
            java.lang.Number sizeGiB;
            java.lang.Number throughputMiB;

            /**
             * Sets the value of {@link Ec2EbsVolumeProperty#getIops}
             * @param iops The IOPS per volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iops(java.lang.Number iops) {
                this.iops = iops;
                return this;
            }

            /**
             * Sets the value of {@link Ec2EbsVolumeProperty#getSizeGiB}
             * @param sizeGiB The EBS volume size in GiB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeGiB(java.lang.Number sizeGiB) {
                this.sizeGiB = sizeGiB;
                return this;
            }

            /**
             * Sets the value of {@link Ec2EbsVolumeProperty#getThroughputMiB}
             * @param throughputMiB The throughput per volume in MiB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throughputMiB(java.lang.Number throughputMiB) {
                this.throughputMiB = throughputMiB;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Ec2EbsVolumeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Ec2EbsVolumeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Ec2EbsVolumeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Ec2EbsVolumeProperty {
            private final java.lang.Number iops;
            private final java.lang.Number sizeGiB;
            private final java.lang.Number throughputMiB;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sizeGiB = software.amazon.jsii.Kernel.get(this, "sizeGiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.throughputMiB = software.amazon.jsii.Kernel.get(this, "throughputMiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.iops = builder.iops;
                this.sizeGiB = builder.sizeGiB;
                this.throughputMiB = builder.throughputMiB;
            }

            @Override
            public final java.lang.Number getIops() {
                return this.iops;
            }

            @Override
            public final java.lang.Number getSizeGiB() {
                return this.sizeGiB;
            }

            @Override
            public final java.lang.Number getThroughputMiB() {
                return this.throughputMiB;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIops() != null) {
                    data.set("iops", om.valueToTree(this.getIops()));
                }
                if (this.getSizeGiB() != null) {
                    data.set("sizeGiB", om.valueToTree(this.getSizeGiB()));
                }
                if (this.getThroughputMiB() != null) {
                    data.set("throughputMiB", om.valueToTree(this.getThroughputMiB()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnFleet.Ec2EbsVolumeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Ec2EbsVolumeProperty.Jsii$Proxy that = (Ec2EbsVolumeProperty.Jsii$Proxy) o;

                if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
                if (this.sizeGiB != null ? !this.sizeGiB.equals(that.sizeGiB) : that.sizeGiB != null) return false;
                return this.throughputMiB != null ? this.throughputMiB.equals(that.throughputMiB) : that.throughputMiB == null;
            }

            @Override
            public final int hashCode() {
                int result = this.iops != null ? this.iops.hashCode() : 0;
                result = 31 * result + (this.sizeGiB != null ? this.sizeGiB.hashCode() : 0);
                result = 31 * result + (this.throughputMiB != null ? this.throughputMiB.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The fleet amount and attribute capabilities.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.deadline.*;
     * FleetAmountCapabilityProperty fleetAmountCapabilityProperty = FleetAmountCapabilityProperty.builder()
     *         .min(123)
     *         .name("name")
     *         // the properties below are optional
     *         .max(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetamountcapability.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetamountcapability.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnFleet.FleetAmountCapabilityProperty")
    @software.amazon.jsii.Jsii.Proxy(FleetAmountCapabilityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FleetAmountCapabilityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The minimum amount of fleet worker capability.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetamountcapability.html#cfn-deadline-fleet-fleetamountcapability-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetamountcapability.html#cfn-deadline-fleet-fleetamountcapability-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMin();

        /**
         * The name of the fleet capability.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetamountcapability.html#cfn-deadline-fleet-fleetamountcapability-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetamountcapability.html#cfn-deadline-fleet-fleetamountcapability-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The maximum amount of the fleet worker capability.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetamountcapability.html#cfn-deadline-fleet-fleetamountcapability-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetamountcapability.html#cfn-deadline-fleet-fleetamountcapability-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FleetAmountCapabilityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FleetAmountCapabilityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FleetAmountCapabilityProperty> {
            java.lang.Number min;
            java.lang.String name;
            java.lang.Number max;

            /**
             * Sets the value of {@link FleetAmountCapabilityProperty#getMin}
             * @param min The minimum amount of fleet worker capability. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Sets the value of {@link FleetAmountCapabilityProperty#getName}
             * @param name The name of the fleet capability. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link FleetAmountCapabilityProperty#getMax}
             * @param max The maximum amount of the fleet worker capability.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetAmountCapabilityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FleetAmountCapabilityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FleetAmountCapabilityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FleetAmountCapabilityProperty {
            private final java.lang.Number min;
            private final java.lang.String name;
            private final java.lang.Number max;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.min = java.util.Objects.requireNonNull(builder.min, "min is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.max = builder.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("min", om.valueToTree(this.getMin()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnFleet.FleetAmountCapabilityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FleetAmountCapabilityProperty.Jsii$Proxy that = (FleetAmountCapabilityProperty.Jsii$Proxy) o;

                if (!min.equals(that.min)) return false;
                if (!name.equals(that.name)) return false;
                return this.max != null ? this.max.equals(that.max) : that.max == null;
            }

            @Override
            public final int hashCode() {
                int result = this.min.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the fleet's capability name, minimum, and maximum.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.deadline.*;
     * FleetAttributeCapabilityProperty fleetAttributeCapabilityProperty = FleetAttributeCapabilityProperty.builder()
     *         .name("name")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetattributecapability.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetattributecapability.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnFleet.FleetAttributeCapabilityProperty")
    @software.amazon.jsii.Jsii.Proxy(FleetAttributeCapabilityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FleetAttributeCapabilityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the fleet attribute capability for the worker.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetattributecapability.html#cfn-deadline-fleet-fleetattributecapability-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetattributecapability.html#cfn-deadline-fleet-fleetattributecapability-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The number of fleet attribute capabilities.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetattributecapability.html#cfn-deadline-fleet-fleetattributecapability-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetattributecapability.html#cfn-deadline-fleet-fleetattributecapability-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link FleetAttributeCapabilityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FleetAttributeCapabilityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FleetAttributeCapabilityProperty> {
            java.lang.String name;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link FleetAttributeCapabilityProperty#getName}
             * @param name The name of the fleet attribute capability for the worker. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link FleetAttributeCapabilityProperty#getValues}
             * @param values The number of fleet attribute capabilities. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetAttributeCapabilityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FleetAttributeCapabilityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FleetAttributeCapabilityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FleetAttributeCapabilityProperty {
            private final java.lang.String name;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnFleet.FleetAttributeCapabilityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FleetAttributeCapabilityProperty.Jsii$Proxy that = (FleetAttributeCapabilityProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }
    /**
     * The amounts and attributes of fleets.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.deadline.*;
     * FleetCapabilitiesProperty fleetCapabilitiesProperty = FleetCapabilitiesProperty.builder()
     *         .amounts(List.of(FleetAmountCapabilityProperty.builder()
     *                 .min(123)
     *                 .name("name")
     *                 // the properties below are optional
     *                 .max(123)
     *                 .build()))
     *         .attributes(List.of(FleetAttributeCapabilityProperty.builder()
     *                 .name("name")
     *                 .values(List.of("values"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetcapabilities.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetcapabilities.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnFleet.FleetCapabilitiesProperty")
    @software.amazon.jsii.Jsii.Proxy(FleetCapabilitiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FleetCapabilitiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Amount capabilities of the fleet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetcapabilities.html#cfn-deadline-fleet-fleetcapabilities-amounts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetcapabilities.html#cfn-deadline-fleet-fleetcapabilities-amounts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAmounts() {
            return null;
        }

        /**
         * Attribute capabilities of the fleet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetcapabilities.html#cfn-deadline-fleet-fleetcapabilities-attributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetcapabilities.html#cfn-deadline-fleet-fleetcapabilities-attributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAttributes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FleetCapabilitiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FleetCapabilitiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FleetCapabilitiesProperty> {
            java.lang.Object amounts;
            java.lang.Object attributes;

            /**
             * Sets the value of {@link FleetCapabilitiesProperty#getAmounts}
             * @param amounts Amount capabilities of the fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amounts(software.amazon.awscdk.IResolvable amounts) {
                this.amounts = amounts;
                return this;
            }

            /**
             * Sets the value of {@link FleetCapabilitiesProperty#getAmounts}
             * @param amounts Amount capabilities of the fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amounts(java.util.List<? extends java.lang.Object> amounts) {
                this.amounts = amounts;
                return this;
            }

            /**
             * Sets the value of {@link FleetCapabilitiesProperty#getAttributes}
             * @param attributes Attribute capabilities of the fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(software.amazon.awscdk.IResolvable attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of {@link FleetCapabilitiesProperty#getAttributes}
             * @param attributes Attribute capabilities of the fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(java.util.List<? extends java.lang.Object> attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetCapabilitiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FleetCapabilitiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FleetCapabilitiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FleetCapabilitiesProperty {
            private final java.lang.Object amounts;
            private final java.lang.Object attributes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.amounts = software.amazon.jsii.Kernel.get(this, "amounts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.attributes = software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.amounts = builder.amounts;
                this.attributes = builder.attributes;
            }

            @Override
            public final java.lang.Object getAmounts() {
                return this.amounts;
            }

            @Override
            public final java.lang.Object getAttributes() {
                return this.attributes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAmounts() != null) {
                    data.set("amounts", om.valueToTree(this.getAmounts()));
                }
                if (this.getAttributes() != null) {
                    data.set("attributes", om.valueToTree(this.getAttributes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnFleet.FleetCapabilitiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FleetCapabilitiesProperty.Jsii$Proxy that = (FleetCapabilitiesProperty.Jsii$Proxy) o;

                if (this.amounts != null ? !this.amounts.equals(that.amounts) : that.amounts != null) return false;
                return this.attributes != null ? this.attributes.equals(that.attributes) : that.attributes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.amounts != null ? this.amounts.hashCode() : 0;
                result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Fleet configuration details.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.deadline.*;
     * FleetConfigurationProperty fleetConfigurationProperty = FleetConfigurationProperty.builder()
     *         .customerManaged(CustomerManagedFleetConfigurationProperty.builder()
     *                 .mode("mode")
     *                 .workerCapabilities(CustomerManagedWorkerCapabilitiesProperty.builder()
     *                         .cpuArchitectureType("cpuArchitectureType")
     *                         .memoryMiB(MemoryMiBRangeProperty.builder()
     *                                 .min(123)
     *                                 // the properties below are optional
     *                                 .max(123)
     *                                 .build())
     *                         .osFamily("osFamily")
     *                         .vCpuCount(VCpuCountRangeProperty.builder()
     *                                 .min(123)
     *                                 // the properties below are optional
     *                                 .max(123)
     *                                 .build())
     *                         // the properties below are optional
     *                         .acceleratorCount(AcceleratorCountRangeProperty.builder()
     *                                 .min(123)
     *                                 // the properties below are optional
     *                                 .max(123)
     *                                 .build())
     *                         .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRangeProperty.builder()
     *                                 .min(123)
     *                                 // the properties below are optional
     *                                 .max(123)
     *                                 .build())
     *                         .acceleratorTypes(List.of("acceleratorTypes"))
     *                         .customAmounts(List.of(FleetAmountCapabilityProperty.builder()
     *                                 .min(123)
     *                                 .name("name")
     *                                 // the properties below are optional
     *                                 .max(123)
     *                                 .build()))
     *                         .customAttributes(List.of(FleetAttributeCapabilityProperty.builder()
     *                                 .name("name")
     *                                 .values(List.of("values"))
     *                                 .build()))
     *                         .build())
     *                 // the properties below are optional
     *                 .storageProfileId("storageProfileId")
     *                 .build())
     *         .serviceManagedEc2(ServiceManagedEc2FleetConfigurationProperty.builder()
     *                 .instanceCapabilities(ServiceManagedEc2InstanceCapabilitiesProperty.builder()
     *                         .cpuArchitectureType("cpuArchitectureType")
     *                         .memoryMiB(MemoryMiBRangeProperty.builder()
     *                                 .min(123)
     *                                 // the properties below are optional
     *                                 .max(123)
     *                                 .build())
     *                         .osFamily("osFamily")
     *                         .vCpuCount(VCpuCountRangeProperty.builder()
     *                                 .min(123)
     *                                 // the properties below are optional
     *                                 .max(123)
     *                                 .build())
     *                         // the properties below are optional
     *                         .acceleratorCapabilities(AcceleratorCapabilitiesProperty.builder()
     *                                 .selections(List.of(AcceleratorSelectionProperty.builder()
     *                                         .name("name")
     *                                         // the properties below are optional
     *                                         .runtime("runtime")
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .count(AcceleratorCountRangeProperty.builder()
     *                                         .min(123)
     *                                         // the properties below are optional
     *                                         .max(123)
     *                                         .build())
     *                                 .build())
     *                         .allowedInstanceTypes(List.of("allowedInstanceTypes"))
     *                         .customAmounts(List.of(FleetAmountCapabilityProperty.builder()
     *                                 .min(123)
     *                                 .name("name")
     *                                 // the properties below are optional
     *                                 .max(123)
     *                                 .build()))
     *                         .customAttributes(List.of(FleetAttributeCapabilityProperty.builder()
     *                                 .name("name")
     *                                 .values(List.of("values"))
     *                                 .build()))
     *                         .excludedInstanceTypes(List.of("excludedInstanceTypes"))
     *                         .rootEbsVolume(Ec2EbsVolumeProperty.builder()
     *                                 .iops(123)
     *                                 .sizeGiB(123)
     *                                 .throughputMiB(123)
     *                                 .build())
     *                         .build())
     *                 .instanceMarketOptions(ServiceManagedEc2InstanceMarketOptionsProperty.builder()
     *                         .type("type")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnFleet.FleetConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FleetConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FleetConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The customer managed fleets within a fleet configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetconfiguration.html#cfn-deadline-fleet-fleetconfiguration-customermanaged">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetconfiguration.html#cfn-deadline-fleet-fleetconfiguration-customermanaged</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomerManaged() {
            return null;
        }

        /**
         * The service managed Amazon EC2 instances for a fleet configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetconfiguration.html#cfn-deadline-fleet-fleetconfiguration-servicemanagedec2">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-fleetconfiguration.html#cfn-deadline-fleet-fleetconfiguration-servicemanagedec2</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServiceManagedEc2() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FleetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FleetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FleetConfigurationProperty> {
            java.lang.Object customerManaged;
            java.lang.Object serviceManagedEc2;

            /**
             * Sets the value of {@link FleetConfigurationProperty#getCustomerManaged}
             * @param customerManaged The customer managed fleets within a fleet configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customerManaged(software.amazon.awscdk.IResolvable customerManaged) {
                this.customerManaged = customerManaged;
                return this;
            }

            /**
             * Sets the value of {@link FleetConfigurationProperty#getCustomerManaged}
             * @param customerManaged The customer managed fleets within a fleet configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customerManaged(software.amazon.awscdk.services.deadline.CfnFleet.CustomerManagedFleetConfigurationProperty customerManaged) {
                this.customerManaged = customerManaged;
                return this;
            }

            /**
             * Sets the value of {@link FleetConfigurationProperty#getServiceManagedEc2}
             * @param serviceManagedEc2 The service managed Amazon EC2 instances for a fleet configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceManagedEc2(software.amazon.awscdk.IResolvable serviceManagedEc2) {
                this.serviceManagedEc2 = serviceManagedEc2;
                return this;
            }

            /**
             * Sets the value of {@link FleetConfigurationProperty#getServiceManagedEc2}
             * @param serviceManagedEc2 The service managed Amazon EC2 instances for a fleet configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceManagedEc2(software.amazon.awscdk.services.deadline.CfnFleet.ServiceManagedEc2FleetConfigurationProperty serviceManagedEc2) {
                this.serviceManagedEc2 = serviceManagedEc2;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FleetConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FleetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FleetConfigurationProperty {
            private final java.lang.Object customerManaged;
            private final java.lang.Object serviceManagedEc2;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customerManaged = software.amazon.jsii.Kernel.get(this, "customerManaged", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceManagedEc2 = software.amazon.jsii.Kernel.get(this, "serviceManagedEc2", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customerManaged = builder.customerManaged;
                this.serviceManagedEc2 = builder.serviceManagedEc2;
            }

            @Override
            public final java.lang.Object getCustomerManaged() {
                return this.customerManaged;
            }

            @Override
            public final java.lang.Object getServiceManagedEc2() {
                return this.serviceManagedEc2;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomerManaged() != null) {
                    data.set("customerManaged", om.valueToTree(this.getCustomerManaged()));
                }
                if (this.getServiceManagedEc2() != null) {
                    data.set("serviceManagedEc2", om.valueToTree(this.getServiceManagedEc2()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnFleet.FleetConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FleetConfigurationProperty.Jsii$Proxy that = (FleetConfigurationProperty.Jsii$Proxy) o;

                if (this.customerManaged != null ? !this.customerManaged.equals(that.customerManaged) : that.customerManaged != null) return false;
                return this.serviceManagedEc2 != null ? this.serviceManagedEc2.equals(that.serviceManagedEc2) : that.serviceManagedEc2 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customerManaged != null ? this.customerManaged.hashCode() : 0;
                result = 31 * result + (this.serviceManagedEc2 != null ? this.serviceManagedEc2.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The range of memory in MiB.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.deadline.*;
     * MemoryMiBRangeProperty memoryMiBRangeProperty = MemoryMiBRangeProperty.builder()
     *         .min(123)
     *         // the properties below are optional
     *         .max(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-memorymibrange.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-memorymibrange.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnFleet.MemoryMiBRangeProperty")
    @software.amazon.jsii.Jsii.Proxy(MemoryMiBRangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MemoryMiBRangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The minimum amount of memory (in MiB).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-memorymibrange.html#cfn-deadline-fleet-memorymibrange-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-memorymibrange.html#cfn-deadline-fleet-memorymibrange-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMin();

        /**
         * The maximum amount of memory (in MiB).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-memorymibrange.html#cfn-deadline-fleet-memorymibrange-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-memorymibrange.html#cfn-deadline-fleet-memorymibrange-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MemoryMiBRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemoryMiBRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MemoryMiBRangeProperty> {
            java.lang.Number min;
            java.lang.Number max;

            /**
             * Sets the value of {@link MemoryMiBRangeProperty#getMin}
             * @param min The minimum amount of memory (in MiB). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Sets the value of {@link MemoryMiBRangeProperty#getMax}
             * @param max The maximum amount of memory (in MiB).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemoryMiBRangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MemoryMiBRangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MemoryMiBRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemoryMiBRangeProperty {
            private final java.lang.Number min;
            private final java.lang.Number max;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.min = java.util.Objects.requireNonNull(builder.min, "min is required");
                this.max = builder.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("min", om.valueToTree(this.getMin()));
                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnFleet.MemoryMiBRangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemoryMiBRangeProperty.Jsii$Proxy that = (MemoryMiBRangeProperty.Jsii$Proxy) o;

                if (!min.equals(that.min)) return false;
                return this.max != null ? this.max.equals(that.max) : that.max == null;
            }

            @Override
            public final int hashCode() {
                int result = this.min.hashCode();
                result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration details for a service managed Amazon EC2 fleet.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.deadline.*;
     * ServiceManagedEc2FleetConfigurationProperty serviceManagedEc2FleetConfigurationProperty = ServiceManagedEc2FleetConfigurationProperty.builder()
     *         .instanceCapabilities(ServiceManagedEc2InstanceCapabilitiesProperty.builder()
     *                 .cpuArchitectureType("cpuArchitectureType")
     *                 .memoryMiB(MemoryMiBRangeProperty.builder()
     *                         .min(123)
     *                         // the properties below are optional
     *                         .max(123)
     *                         .build())
     *                 .osFamily("osFamily")
     *                 .vCpuCount(VCpuCountRangeProperty.builder()
     *                         .min(123)
     *                         // the properties below are optional
     *                         .max(123)
     *                         .build())
     *                 // the properties below are optional
     *                 .acceleratorCapabilities(AcceleratorCapabilitiesProperty.builder()
     *                         .selections(List.of(AcceleratorSelectionProperty.builder()
     *                                 .name("name")
     *                                 // the properties below are optional
     *                                 .runtime("runtime")
     *                                 .build()))
     *                         // the properties below are optional
     *                         .count(AcceleratorCountRangeProperty.builder()
     *                                 .min(123)
     *                                 // the properties below are optional
     *                                 .max(123)
     *                                 .build())
     *                         .build())
     *                 .allowedInstanceTypes(List.of("allowedInstanceTypes"))
     *                 .customAmounts(List.of(FleetAmountCapabilityProperty.builder()
     *                         .min(123)
     *                         .name("name")
     *                         // the properties below are optional
     *                         .max(123)
     *                         .build()))
     *                 .customAttributes(List.of(FleetAttributeCapabilityProperty.builder()
     *                         .name("name")
     *                         .values(List.of("values"))
     *                         .build()))
     *                 .excludedInstanceTypes(List.of("excludedInstanceTypes"))
     *                 .rootEbsVolume(Ec2EbsVolumeProperty.builder()
     *                         .iops(123)
     *                         .sizeGiB(123)
     *                         .throughputMiB(123)
     *                         .build())
     *                 .build())
     *         .instanceMarketOptions(ServiceManagedEc2InstanceMarketOptionsProperty.builder()
     *                 .type("type")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2fleetconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2fleetconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnFleet.ServiceManagedEc2FleetConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceManagedEc2FleetConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceManagedEc2FleetConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon EC2 instance capabilities.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2fleetconfiguration.html#cfn-deadline-fleet-servicemanagedec2fleetconfiguration-instancecapabilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2fleetconfiguration.html#cfn-deadline-fleet-servicemanagedec2fleetconfiguration-instancecapabilities</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getInstanceCapabilities();

        /**
         * The Amazon EC2 market type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2fleetconfiguration.html#cfn-deadline-fleet-servicemanagedec2fleetconfiguration-instancemarketoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2fleetconfiguration.html#cfn-deadline-fleet-servicemanagedec2fleetconfiguration-instancemarketoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getInstanceMarketOptions();

        /**
         * @return a {@link Builder} of {@link ServiceManagedEc2FleetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceManagedEc2FleetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceManagedEc2FleetConfigurationProperty> {
            java.lang.Object instanceCapabilities;
            java.lang.Object instanceMarketOptions;

            /**
             * Sets the value of {@link ServiceManagedEc2FleetConfigurationProperty#getInstanceCapabilities}
             * @param instanceCapabilities The Amazon EC2 instance capabilities. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceCapabilities(software.amazon.awscdk.IResolvable instanceCapabilities) {
                this.instanceCapabilities = instanceCapabilities;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEc2FleetConfigurationProperty#getInstanceCapabilities}
             * @param instanceCapabilities The Amazon EC2 instance capabilities. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceCapabilities(software.amazon.awscdk.services.deadline.CfnFleet.ServiceManagedEc2InstanceCapabilitiesProperty instanceCapabilities) {
                this.instanceCapabilities = instanceCapabilities;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEc2FleetConfigurationProperty#getInstanceMarketOptions}
             * @param instanceMarketOptions The Amazon EC2 market type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceMarketOptions(software.amazon.awscdk.IResolvable instanceMarketOptions) {
                this.instanceMarketOptions = instanceMarketOptions;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEc2FleetConfigurationProperty#getInstanceMarketOptions}
             * @param instanceMarketOptions The Amazon EC2 market type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceMarketOptions(software.amazon.awscdk.services.deadline.CfnFleet.ServiceManagedEc2InstanceMarketOptionsProperty instanceMarketOptions) {
                this.instanceMarketOptions = instanceMarketOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceManagedEc2FleetConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceManagedEc2FleetConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceManagedEc2FleetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceManagedEc2FleetConfigurationProperty {
            private final java.lang.Object instanceCapabilities;
            private final java.lang.Object instanceMarketOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceCapabilities = software.amazon.jsii.Kernel.get(this, "instanceCapabilities", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.instanceMarketOptions = software.amazon.jsii.Kernel.get(this, "instanceMarketOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceCapabilities = java.util.Objects.requireNonNull(builder.instanceCapabilities, "instanceCapabilities is required");
                this.instanceMarketOptions = java.util.Objects.requireNonNull(builder.instanceMarketOptions, "instanceMarketOptions is required");
            }

            @Override
            public final java.lang.Object getInstanceCapabilities() {
                return this.instanceCapabilities;
            }

            @Override
            public final java.lang.Object getInstanceMarketOptions() {
                return this.instanceMarketOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceCapabilities", om.valueToTree(this.getInstanceCapabilities()));
                data.set("instanceMarketOptions", om.valueToTree(this.getInstanceMarketOptions()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnFleet.ServiceManagedEc2FleetConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceManagedEc2FleetConfigurationProperty.Jsii$Proxy that = (ServiceManagedEc2FleetConfigurationProperty.Jsii$Proxy) o;

                if (!instanceCapabilities.equals(that.instanceCapabilities)) return false;
                return this.instanceMarketOptions.equals(that.instanceMarketOptions);
            }

            @Override
            public final int hashCode() {
                int result = this.instanceCapabilities.hashCode();
                result = 31 * result + (this.instanceMarketOptions.hashCode());
                return result;
            }
        }
    }
    /**
     * The Amazon EC2 instance capabilities.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.deadline.*;
     * ServiceManagedEc2InstanceCapabilitiesProperty serviceManagedEc2InstanceCapabilitiesProperty = ServiceManagedEc2InstanceCapabilitiesProperty.builder()
     *         .cpuArchitectureType("cpuArchitectureType")
     *         .memoryMiB(MemoryMiBRangeProperty.builder()
     *                 .min(123)
     *                 // the properties below are optional
     *                 .max(123)
     *                 .build())
     *         .osFamily("osFamily")
     *         .vCpuCount(VCpuCountRangeProperty.builder()
     *                 .min(123)
     *                 // the properties below are optional
     *                 .max(123)
     *                 .build())
     *         // the properties below are optional
     *         .acceleratorCapabilities(AcceleratorCapabilitiesProperty.builder()
     *                 .selections(List.of(AcceleratorSelectionProperty.builder()
     *                         .name("name")
     *                         // the properties below are optional
     *                         .runtime("runtime")
     *                         .build()))
     *                 // the properties below are optional
     *                 .count(AcceleratorCountRangeProperty.builder()
     *                         .min(123)
     *                         // the properties below are optional
     *                         .max(123)
     *                         .build())
     *                 .build())
     *         .allowedInstanceTypes(List.of("allowedInstanceTypes"))
     *         .customAmounts(List.of(FleetAmountCapabilityProperty.builder()
     *                 .min(123)
     *                 .name("name")
     *                 // the properties below are optional
     *                 .max(123)
     *                 .build()))
     *         .customAttributes(List.of(FleetAttributeCapabilityProperty.builder()
     *                 .name("name")
     *                 .values(List.of("values"))
     *                 .build()))
     *         .excludedInstanceTypes(List.of("excludedInstanceTypes"))
     *         .rootEbsVolume(Ec2EbsVolumeProperty.builder()
     *                 .iops(123)
     *                 .sizeGiB(123)
     *                 .throughputMiB(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancecapabilities.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancecapabilities.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnFleet.ServiceManagedEc2InstanceCapabilitiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceManagedEc2InstanceCapabilitiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceManagedEc2InstanceCapabilitiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The CPU architecture type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancecapabilities.html#cfn-deadline-fleet-servicemanagedec2instancecapabilities-cpuarchitecturetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancecapabilities.html#cfn-deadline-fleet-servicemanagedec2instancecapabilities-cpuarchitecturetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCpuArchitectureType();

        /**
         * The memory, as MiB, for the Amazon EC2 instance type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancecapabilities.html#cfn-deadline-fleet-servicemanagedec2instancecapabilities-memorymib">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancecapabilities.html#cfn-deadline-fleet-servicemanagedec2instancecapabilities-memorymib</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMemoryMiB();

        /**
         * The operating system (OS) family.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancecapabilities.html#cfn-deadline-fleet-servicemanagedec2instancecapabilities-osfamily">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancecapabilities.html#cfn-deadline-fleet-servicemanagedec2instancecapabilities-osfamily</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOsFamily();

        /**
         * The amount of vCPU to require for instances in this fleet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancecapabilities.html#cfn-deadline-fleet-servicemanagedec2instancecapabilities-vcpucount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancecapabilities.html#cfn-deadline-fleet-servicemanagedec2instancecapabilities-vcpucount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getVCpuCount();

        /**
         * Describes the GPU accelerator capabilities required for worker host instances in this fleet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancecapabilities.html#cfn-deadline-fleet-servicemanagedec2instancecapabilities-acceleratorcapabilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancecapabilities.html#cfn-deadline-fleet-servicemanagedec2instancecapabilities-acceleratorcapabilities</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAcceleratorCapabilities() {
            return null;
        }

        /**
         * The allowable Amazon EC2 instance types.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancecapabilities.html#cfn-deadline-fleet-servicemanagedec2instancecapabilities-allowedinstancetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancecapabilities.html#cfn-deadline-fleet-servicemanagedec2instancecapabilities-allowedinstancetypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedInstanceTypes() {
            return null;
        }

        /**
         * The custom capability amounts to require for instances in this fleet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancecapabilities.html#cfn-deadline-fleet-servicemanagedec2instancecapabilities-customamounts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancecapabilities.html#cfn-deadline-fleet-servicemanagedec2instancecapabilities-customamounts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomAmounts() {
            return null;
        }

        /**
         * The custom capability attributes to require for instances in this fleet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancecapabilities.html#cfn-deadline-fleet-servicemanagedec2instancecapabilities-customattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancecapabilities.html#cfn-deadline-fleet-servicemanagedec2instancecapabilities-customattributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomAttributes() {
            return null;
        }

        /**
         * The instance types to exclude from the fleet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancecapabilities.html#cfn-deadline-fleet-servicemanagedec2instancecapabilities-excludedinstancetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancecapabilities.html#cfn-deadline-fleet-servicemanagedec2instancecapabilities-excludedinstancetypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludedInstanceTypes() {
            return null;
        }

        /**
         * The root EBS volume.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancecapabilities.html#cfn-deadline-fleet-servicemanagedec2instancecapabilities-rootebsvolume">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancecapabilities.html#cfn-deadline-fleet-servicemanagedec2instancecapabilities-rootebsvolume</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRootEbsVolume() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServiceManagedEc2InstanceCapabilitiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceManagedEc2InstanceCapabilitiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceManagedEc2InstanceCapabilitiesProperty> {
            java.lang.String cpuArchitectureType;
            java.lang.Object memoryMiB;
            java.lang.String osFamily;
            java.lang.Object vCpuCount;
            java.lang.Object acceleratorCapabilities;
            java.util.List<java.lang.String> allowedInstanceTypes;
            java.lang.Object customAmounts;
            java.lang.Object customAttributes;
            java.util.List<java.lang.String> excludedInstanceTypes;
            java.lang.Object rootEbsVolume;

            /**
             * Sets the value of {@link ServiceManagedEc2InstanceCapabilitiesProperty#getCpuArchitectureType}
             * @param cpuArchitectureType The CPU architecture type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpuArchitectureType(java.lang.String cpuArchitectureType) {
                this.cpuArchitectureType = cpuArchitectureType;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEc2InstanceCapabilitiesProperty#getMemoryMiB}
             * @param memoryMiB The memory, as MiB, for the Amazon EC2 instance type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryMiB(software.amazon.awscdk.IResolvable memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEc2InstanceCapabilitiesProperty#getMemoryMiB}
             * @param memoryMiB The memory, as MiB, for the Amazon EC2 instance type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryMiB(software.amazon.awscdk.services.deadline.CfnFleet.MemoryMiBRangeProperty memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEc2InstanceCapabilitiesProperty#getOsFamily}
             * @param osFamily The operating system (OS) family. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder osFamily(java.lang.String osFamily) {
                this.osFamily = osFamily;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEc2InstanceCapabilitiesProperty#getVCpuCount}
             * @param vCpuCount The amount of vCPU to require for instances in this fleet. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vCpuCount(software.amazon.awscdk.IResolvable vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEc2InstanceCapabilitiesProperty#getVCpuCount}
             * @param vCpuCount The amount of vCPU to require for instances in this fleet. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vCpuCount(software.amazon.awscdk.services.deadline.CfnFleet.VCpuCountRangeProperty vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEc2InstanceCapabilitiesProperty#getAcceleratorCapabilities}
             * @param acceleratorCapabilities Describes the GPU accelerator capabilities required for worker host instances in this fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorCapabilities(software.amazon.awscdk.IResolvable acceleratorCapabilities) {
                this.acceleratorCapabilities = acceleratorCapabilities;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEc2InstanceCapabilitiesProperty#getAcceleratorCapabilities}
             * @param acceleratorCapabilities Describes the GPU accelerator capabilities required for worker host instances in this fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorCapabilities(software.amazon.awscdk.services.deadline.CfnFleet.AcceleratorCapabilitiesProperty acceleratorCapabilities) {
                this.acceleratorCapabilities = acceleratorCapabilities;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEc2InstanceCapabilitiesProperty#getAllowedInstanceTypes}
             * @param allowedInstanceTypes The allowable Amazon EC2 instance types.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedInstanceTypes(java.util.List<java.lang.String> allowedInstanceTypes) {
                this.allowedInstanceTypes = allowedInstanceTypes;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEc2InstanceCapabilitiesProperty#getCustomAmounts}
             * @param customAmounts The custom capability amounts to require for instances in this fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customAmounts(software.amazon.awscdk.IResolvable customAmounts) {
                this.customAmounts = customAmounts;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEc2InstanceCapabilitiesProperty#getCustomAmounts}
             * @param customAmounts The custom capability amounts to require for instances in this fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customAmounts(java.util.List<? extends java.lang.Object> customAmounts) {
                this.customAmounts = customAmounts;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEc2InstanceCapabilitiesProperty#getCustomAttributes}
             * @param customAttributes The custom capability attributes to require for instances in this fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customAttributes(software.amazon.awscdk.IResolvable customAttributes) {
                this.customAttributes = customAttributes;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEc2InstanceCapabilitiesProperty#getCustomAttributes}
             * @param customAttributes The custom capability attributes to require for instances in this fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customAttributes(java.util.List<? extends java.lang.Object> customAttributes) {
                this.customAttributes = customAttributes;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEc2InstanceCapabilitiesProperty#getExcludedInstanceTypes}
             * @param excludedInstanceTypes The instance types to exclude from the fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludedInstanceTypes(java.util.List<java.lang.String> excludedInstanceTypes) {
                this.excludedInstanceTypes = excludedInstanceTypes;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEc2InstanceCapabilitiesProperty#getRootEbsVolume}
             * @param rootEbsVolume The root EBS volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rootEbsVolume(software.amazon.awscdk.IResolvable rootEbsVolume) {
                this.rootEbsVolume = rootEbsVolume;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEc2InstanceCapabilitiesProperty#getRootEbsVolume}
             * @param rootEbsVolume The root EBS volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rootEbsVolume(software.amazon.awscdk.services.deadline.CfnFleet.Ec2EbsVolumeProperty rootEbsVolume) {
                this.rootEbsVolume = rootEbsVolume;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceManagedEc2InstanceCapabilitiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceManagedEc2InstanceCapabilitiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceManagedEc2InstanceCapabilitiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceManagedEc2InstanceCapabilitiesProperty {
            private final java.lang.String cpuArchitectureType;
            private final java.lang.Object memoryMiB;
            private final java.lang.String osFamily;
            private final java.lang.Object vCpuCount;
            private final java.lang.Object acceleratorCapabilities;
            private final java.util.List<java.lang.String> allowedInstanceTypes;
            private final java.lang.Object customAmounts;
            private final java.lang.Object customAttributes;
            private final java.util.List<java.lang.String> excludedInstanceTypes;
            private final java.lang.Object rootEbsVolume;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cpuArchitectureType = software.amazon.jsii.Kernel.get(this, "cpuArchitectureType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.memoryMiB = software.amazon.jsii.Kernel.get(this, "memoryMiB", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.osFamily = software.amazon.jsii.Kernel.get(this, "osFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vCpuCount = software.amazon.jsii.Kernel.get(this, "vCpuCount", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.acceleratorCapabilities = software.amazon.jsii.Kernel.get(this, "acceleratorCapabilities", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.allowedInstanceTypes = software.amazon.jsii.Kernel.get(this, "allowedInstanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.customAmounts = software.amazon.jsii.Kernel.get(this, "customAmounts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customAttributes = software.amazon.jsii.Kernel.get(this, "customAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.excludedInstanceTypes = software.amazon.jsii.Kernel.get(this, "excludedInstanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.rootEbsVolume = software.amazon.jsii.Kernel.get(this, "rootEbsVolume", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cpuArchitectureType = java.util.Objects.requireNonNull(builder.cpuArchitectureType, "cpuArchitectureType is required");
                this.memoryMiB = java.util.Objects.requireNonNull(builder.memoryMiB, "memoryMiB is required");
                this.osFamily = java.util.Objects.requireNonNull(builder.osFamily, "osFamily is required");
                this.vCpuCount = java.util.Objects.requireNonNull(builder.vCpuCount, "vCpuCount is required");
                this.acceleratorCapabilities = builder.acceleratorCapabilities;
                this.allowedInstanceTypes = builder.allowedInstanceTypes;
                this.customAmounts = builder.customAmounts;
                this.customAttributes = builder.customAttributes;
                this.excludedInstanceTypes = builder.excludedInstanceTypes;
                this.rootEbsVolume = builder.rootEbsVolume;
            }

            @Override
            public final java.lang.String getCpuArchitectureType() {
                return this.cpuArchitectureType;
            }

            @Override
            public final java.lang.Object getMemoryMiB() {
                return this.memoryMiB;
            }

            @Override
            public final java.lang.String getOsFamily() {
                return this.osFamily;
            }

            @Override
            public final java.lang.Object getVCpuCount() {
                return this.vCpuCount;
            }

            @Override
            public final java.lang.Object getAcceleratorCapabilities() {
                return this.acceleratorCapabilities;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedInstanceTypes() {
                return this.allowedInstanceTypes;
            }

            @Override
            public final java.lang.Object getCustomAmounts() {
                return this.customAmounts;
            }

            @Override
            public final java.lang.Object getCustomAttributes() {
                return this.customAttributes;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludedInstanceTypes() {
                return this.excludedInstanceTypes;
            }

            @Override
            public final java.lang.Object getRootEbsVolume() {
                return this.rootEbsVolume;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cpuArchitectureType", om.valueToTree(this.getCpuArchitectureType()));
                data.set("memoryMiB", om.valueToTree(this.getMemoryMiB()));
                data.set("osFamily", om.valueToTree(this.getOsFamily()));
                data.set("vCpuCount", om.valueToTree(this.getVCpuCount()));
                if (this.getAcceleratorCapabilities() != null) {
                    data.set("acceleratorCapabilities", om.valueToTree(this.getAcceleratorCapabilities()));
                }
                if (this.getAllowedInstanceTypes() != null) {
                    data.set("allowedInstanceTypes", om.valueToTree(this.getAllowedInstanceTypes()));
                }
                if (this.getCustomAmounts() != null) {
                    data.set("customAmounts", om.valueToTree(this.getCustomAmounts()));
                }
                if (this.getCustomAttributes() != null) {
                    data.set("customAttributes", om.valueToTree(this.getCustomAttributes()));
                }
                if (this.getExcludedInstanceTypes() != null) {
                    data.set("excludedInstanceTypes", om.valueToTree(this.getExcludedInstanceTypes()));
                }
                if (this.getRootEbsVolume() != null) {
                    data.set("rootEbsVolume", om.valueToTree(this.getRootEbsVolume()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnFleet.ServiceManagedEc2InstanceCapabilitiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceManagedEc2InstanceCapabilitiesProperty.Jsii$Proxy that = (ServiceManagedEc2InstanceCapabilitiesProperty.Jsii$Proxy) o;

                if (!cpuArchitectureType.equals(that.cpuArchitectureType)) return false;
                if (!memoryMiB.equals(that.memoryMiB)) return false;
                if (!osFamily.equals(that.osFamily)) return false;
                if (!vCpuCount.equals(that.vCpuCount)) return false;
                if (this.acceleratorCapabilities != null ? !this.acceleratorCapabilities.equals(that.acceleratorCapabilities) : that.acceleratorCapabilities != null) return false;
                if (this.allowedInstanceTypes != null ? !this.allowedInstanceTypes.equals(that.allowedInstanceTypes) : that.allowedInstanceTypes != null) return false;
                if (this.customAmounts != null ? !this.customAmounts.equals(that.customAmounts) : that.customAmounts != null) return false;
                if (this.customAttributes != null ? !this.customAttributes.equals(that.customAttributes) : that.customAttributes != null) return false;
                if (this.excludedInstanceTypes != null ? !this.excludedInstanceTypes.equals(that.excludedInstanceTypes) : that.excludedInstanceTypes != null) return false;
                return this.rootEbsVolume != null ? this.rootEbsVolume.equals(that.rootEbsVolume) : that.rootEbsVolume == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cpuArchitectureType.hashCode();
                result = 31 * result + (this.memoryMiB.hashCode());
                result = 31 * result + (this.osFamily.hashCode());
                result = 31 * result + (this.vCpuCount.hashCode());
                result = 31 * result + (this.acceleratorCapabilities != null ? this.acceleratorCapabilities.hashCode() : 0);
                result = 31 * result + (this.allowedInstanceTypes != null ? this.allowedInstanceTypes.hashCode() : 0);
                result = 31 * result + (this.customAmounts != null ? this.customAmounts.hashCode() : 0);
                result = 31 * result + (this.customAttributes != null ? this.customAttributes.hashCode() : 0);
                result = 31 * result + (this.excludedInstanceTypes != null ? this.excludedInstanceTypes.hashCode() : 0);
                result = 31 * result + (this.rootEbsVolume != null ? this.rootEbsVolume.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The details of the Amazon EC2 instance market options for a service managed fleet.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.deadline.*;
     * ServiceManagedEc2InstanceMarketOptionsProperty serviceManagedEc2InstanceMarketOptionsProperty = ServiceManagedEc2InstanceMarketOptionsProperty.builder()
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancemarketoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancemarketoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnFleet.ServiceManagedEc2InstanceMarketOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceManagedEc2InstanceMarketOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceManagedEc2InstanceMarketOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon EC2 instance type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancemarketoptions.html#cfn-deadline-fleet-servicemanagedec2instancemarketoptions-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-servicemanagedec2instancemarketoptions.html#cfn-deadline-fleet-servicemanagedec2instancemarketoptions-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link ServiceManagedEc2InstanceMarketOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceManagedEc2InstanceMarketOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceManagedEc2InstanceMarketOptionsProperty> {
            java.lang.String type;

            /**
             * Sets the value of {@link ServiceManagedEc2InstanceMarketOptionsProperty#getType}
             * @param type The Amazon EC2 instance type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceManagedEc2InstanceMarketOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceManagedEc2InstanceMarketOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceManagedEc2InstanceMarketOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceManagedEc2InstanceMarketOptionsProperty {
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnFleet.ServiceManagedEc2InstanceMarketOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceManagedEc2InstanceMarketOptionsProperty.Jsii$Proxy that = (ServiceManagedEc2InstanceMarketOptionsProperty.Jsii$Proxy) o;

                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                return result;
            }
        }
    }
    /**
     * The allowable range of vCPU processing power for the fleet.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.deadline.*;
     * VCpuCountRangeProperty vCpuCountRangeProperty = VCpuCountRangeProperty.builder()
     *         .min(123)
     *         // the properties below are optional
     *         .max(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-vcpucountrange.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-vcpucountrange.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnFleet.VCpuCountRangeProperty")
    @software.amazon.jsii.Jsii.Proxy(VCpuCountRangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VCpuCountRangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The minimum amount of vCPU.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-vcpucountrange.html#cfn-deadline-fleet-vcpucountrange-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-vcpucountrange.html#cfn-deadline-fleet-vcpucountrange-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMin();

        /**
         * The maximum amount of vCPU.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-vcpucountrange.html#cfn-deadline-fleet-vcpucountrange-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-fleet-vcpucountrange.html#cfn-deadline-fleet-vcpucountrange-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VCpuCountRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VCpuCountRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VCpuCountRangeProperty> {
            java.lang.Number min;
            java.lang.Number max;

            /**
             * Sets the value of {@link VCpuCountRangeProperty#getMin}
             * @param min The minimum amount of vCPU. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Sets the value of {@link VCpuCountRangeProperty#getMax}
             * @param max The maximum amount of vCPU.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VCpuCountRangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VCpuCountRangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VCpuCountRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VCpuCountRangeProperty {
            private final java.lang.Number min;
            private final java.lang.Number max;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.min = java.util.Objects.requireNonNull(builder.min, "min is required");
                this.max = builder.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("min", om.valueToTree(this.getMin()));
                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnFleet.VCpuCountRangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VCpuCountRangeProperty.Jsii$Proxy that = (VCpuCountRangeProperty.Jsii$Proxy) o;

                if (!min.equals(that.min)) return false;
                return this.max != null ? this.max.equals(that.max) : that.max == null;
            }

            @Override
            public final int hashCode() {
                int result = this.min.hashCode();
                result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.deadline.CfnFleet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.deadline.CfnFleet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.deadline.CfnFleetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.deadline.CfnFleetProps.Builder();
        }

        /**
         * The configuration details for the fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-configuration</a>
         * @param configuration The configuration details for the fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.IResolvable configuration) {
            this.props.configuration(configuration);
            return this;
        }
        /**
         * The configuration details for the fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-configuration</a>
         * @param configuration The configuration details for the fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.services.deadline.CfnFleet.FleetConfigurationProperty configuration) {
            this.props.configuration(configuration);
            return this;
        }

        /**
         * The display name of the fleet summary to update.
         * <p>
         * <blockquote>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-displayname</a>
         * @param displayName The display name of the fleet summary to update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(final java.lang.String displayName) {
            this.props.displayName(displayName);
            return this;
        }

        /**
         * The farm ID.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-farmid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-farmid</a>
         * @param farmId The farm ID. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder farmId(final java.lang.String farmId) {
            this.props.farmId(farmId);
            return this;
        }

        /**
         * The maximum number of workers specified in the fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-maxworkercount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-maxworkercount</a>
         * @param maxWorkerCount The maximum number of workers specified in the fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxWorkerCount(final java.lang.Number maxWorkerCount) {
            this.props.maxWorkerCount(maxWorkerCount);
            return this;
        }

        /**
         * The IAM role that workers in the fleet use when processing jobs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-rolearn</a>
         * @param roleArn The IAM role that workers in the fleet use when processing jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * A description that helps identify what the fleet is used for.
         * <p>
         * <blockquote>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
         * <p>
         * </blockquote>
         * <p>
         * Default: - ""
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-description</a>
         * @param description A description that helps identify what the fleet is used for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The minimum number of workers in the fleet.
         * <p>
         * Default: - 0
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-minworkercount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-minworkercount</a>
         * @param minWorkerCount The minimum number of workers in the fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minWorkerCount(final java.lang.Number minWorkerCount) {
            this.props.minWorkerCount(minWorkerCount);
            return this;
        }

        /**
         * The tags to add to your fleet.
         * <p>
         * Each tag consists of a tag key and a tag value. Tag keys and values are both required, but tag values can be empty strings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-tags</a>
         * @param tags The tags to add to your fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.deadline.CfnFleet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.deadline.CfnFleet build() {
            return new software.amazon.awscdk.services.deadline.CfnFleet(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
