package software.amazon.awscdk.services.dynamodb;

/**
 * The options for imported source files in CSV format.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.s3.*;
 * IBucket bucket;
 * App app = new App();
 * Stack stack = new Stack(app, "Stack");
 * Table.Builder.create(stack, "Table")
 *         .partitionKey(Attribute.builder()
 *                 .name("id")
 *                 .type(AttributeType.STRING)
 *                 .build())
 *         .importSource(ImportSourceSpecification.builder()
 *                 .compressionType(InputCompressionType.GZIP)
 *                 .inputFormat(InputFormat.csv(CsvOptions.builder()
 *                         .delimiter(",")
 *                         .headerList(List.of("id", "name"))
 *                         .build()))
 *                 .bucket(bucket)
 *                 .keyPrefix("prefix")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:22.781Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CsvOptions")
@software.amazon.jsii.Jsii.Proxy(CsvOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CsvOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The delimiter used for separating items in the CSV file being imported.
     * <p>
     * Valid delimiters are as follows:
     * <p>
     * <ul>
     * <li>comma (<code>,</code>)</li>
     * <li>tab (<code>\t</code>)</li>
     * <li>colon (<code>:</code>)</li>
     * <li>semicolon (<code>;</code>)</li>
     * <li>pipe (<code>|</code>)</li>
     * <li>space (<code> </code>)</li>
     * </ul>
     * <p>
     * Default: - use comma as a delimiter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDelimiter() {
        return null;
    }

    /**
     * List of the headers used to specify a common header for all source CSV files being imported.
     * <p>
     * <strong>NOTE</strong>: If this field is specified then the first line of each CSV file is treated as data instead of the header.
     * If this field is not specified the the first line of each CSV file is treated as the header.
     * <p>
     * Default: - the first line of the CSV file is treated as the header
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHeaderList() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CsvOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CsvOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CsvOptions> {
        java.lang.String delimiter;
        java.util.List<java.lang.String> headerList;

        /**
         * Sets the value of {@link CsvOptions#getDelimiter}
         * @param delimiter The delimiter used for separating items in the CSV file being imported.
         *                  Valid delimiters are as follows:
         *                  <p>
         *                  <ul>
         *                  <li>comma (<code>,</code>)</li>
         *                  <li>tab (<code>\t</code>)</li>
         *                  <li>colon (<code>:</code>)</li>
         *                  <li>semicolon (<code>;</code>)</li>
         *                  <li>pipe (<code>|</code>)</li>
         *                  <li>space (<code> </code>)</li>
         *                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder delimiter(java.lang.String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        /**
         * Sets the value of {@link CsvOptions#getHeaderList}
         * @param headerList List of the headers used to specify a common header for all source CSV files being imported.
         *                   <strong>NOTE</strong>: If this field is specified then the first line of each CSV file is treated as data instead of the header.
         *                   If this field is not specified the the first line of each CSV file is treated as the header.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder headerList(java.util.List<java.lang.String> headerList) {
            this.headerList = headerList;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CsvOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CsvOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CsvOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CsvOptions {
        private final java.lang.String delimiter;
        private final java.util.List<java.lang.String> headerList;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.delimiter = software.amazon.jsii.Kernel.get(this, "delimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.headerList = software.amazon.jsii.Kernel.get(this, "headerList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.delimiter = builder.delimiter;
            this.headerList = builder.headerList;
        }

        @Override
        public final java.lang.String getDelimiter() {
            return this.delimiter;
        }

        @Override
        public final java.util.List<java.lang.String> getHeaderList() {
            return this.headerList;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDelimiter() != null) {
                data.set("delimiter", om.valueToTree(this.getDelimiter()));
            }
            if (this.getHeaderList() != null) {
                data.set("headerList", om.valueToTree(this.getHeaderList()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CsvOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CsvOptions.Jsii$Proxy that = (CsvOptions.Jsii$Proxy) o;

            if (this.delimiter != null ? !this.delimiter.equals(that.delimiter) : that.delimiter != null) return false;
            return this.headerList != null ? this.headerList.equals(that.headerList) : that.headerList == null;
        }

        @Override
        public final int hashCode() {
            int result = this.delimiter != null ? this.delimiter.hashCode() : 0;
            result = 31 * result + (this.headerList != null ? this.headerList.hashCode() : 0);
            return result;
        }
    }
}
