package software.amazon.awscdk.services.dynamodb;

/**
 * Attributes of a DynamoDB table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dynamodb.*;
 * import software.amazon.awscdk.services.kms.*;
 * Key key;
 * TableAttributesV2 tableAttributesV2 = TableAttributesV2.builder()
 *         .encryptionKey(key)
 *         .globalIndexes(List.of("globalIndexes"))
 *         .grantIndexPermissions(false)
 *         .localIndexes(List.of("localIndexes"))
 *         .tableArn("tableArn")
 *         .tableId("tableId")
 *         .tableName("tableName")
 *         .tableStreamArn("tableStreamArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:22.799Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.TableAttributesV2")
@software.amazon.jsii.Jsii.Proxy(TableAttributesV2.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TableAttributesV2 extends software.amazon.jsii.JsiiSerializable {

    /**
     * KMS encryption key for the table.
     * <p>
     * Default: - no KMS encryption key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * The name of the global indexes set for the table.
     * <p>
     * Note: You must set either this property or <code>localIndexes</code> if you want permissions
     * to be granted for indexes as well as the table itself.
     * <p>
     * Default: - no global indexes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGlobalIndexes() {
        return null;
    }

    /**
     * Whether or not to grant permissions for all indexes of the table.
     * <p>
     * Note: If false, permissions will only be granted to indexes when <code>globalIndexes</code>
     * or <code>localIndexes</code> is specified.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getGrantIndexPermissions() {
        return null;
    }

    /**
     * The name of the local indexes set for the table.
     * <p>
     * Note: You must set either this property or <code>globalIndexes</code> if you want permissions
     * to be granted for indexes as well as the table itself.
     * <p>
     * Default: - no local indexes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLocalIndexes() {
        return null;
    }

    /**
     * The ARN of the table.
     * <p>
     * Note: You must specify this or the <code>tableName</code>.
     * <p>
     * Default: - table arn generated using `tableName` and region of stack
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTableArn() {
        return null;
    }

    /**
     * The ID of the table.
     * <p>
     * Default: - no table id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTableId() {
        return null;
    }

    /**
     * The name of the table.
     * <p>
     * Note: You must specify this or the <code>tableArn</code>.
     * <p>
     * Default: - table name retrieved from provided `tableArn`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
        return null;
    }

    /**
     * The stream ARN of the table.
     * <p>
     * Default: - no table stream ARN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTableStreamArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TableAttributesV2}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TableAttributesV2}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TableAttributesV2> {
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        java.util.List<java.lang.String> globalIndexes;
        java.lang.Boolean grantIndexPermissions;
        java.util.List<java.lang.String> localIndexes;
        java.lang.String tableArn;
        java.lang.String tableId;
        java.lang.String tableName;
        java.lang.String tableStreamArn;

        /**
         * Sets the value of {@link TableAttributesV2#getEncryptionKey}
         * @param encryptionKey KMS encryption key for the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link TableAttributesV2#getGlobalIndexes}
         * @param globalIndexes The name of the global indexes set for the table.
         *                      Note: You must set either this property or <code>localIndexes</code> if you want permissions
         *                      to be granted for indexes as well as the table itself.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalIndexes(java.util.List<java.lang.String> globalIndexes) {
            this.globalIndexes = globalIndexes;
            return this;
        }

        /**
         * Sets the value of {@link TableAttributesV2#getGrantIndexPermissions}
         * @param grantIndexPermissions Whether or not to grant permissions for all indexes of the table.
         *                              Note: If false, permissions will only be granted to indexes when <code>globalIndexes</code>
         *                              or <code>localIndexes</code> is specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder grantIndexPermissions(java.lang.Boolean grantIndexPermissions) {
            this.grantIndexPermissions = grantIndexPermissions;
            return this;
        }

        /**
         * Sets the value of {@link TableAttributesV2#getLocalIndexes}
         * @param localIndexes The name of the local indexes set for the table.
         *                     Note: You must set either this property or <code>globalIndexes</code> if you want permissions
         *                     to be granted for indexes as well as the table itself.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localIndexes(java.util.List<java.lang.String> localIndexes) {
            this.localIndexes = localIndexes;
            return this;
        }

        /**
         * Sets the value of {@link TableAttributesV2#getTableArn}
         * @param tableArn The ARN of the table.
         *                 Note: You must specify this or the <code>tableName</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableArn(java.lang.String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        /**
         * Sets the value of {@link TableAttributesV2#getTableId}
         * @param tableId The ID of the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableId(java.lang.String tableId) {
            this.tableId = tableId;
            return this;
        }

        /**
         * Sets the value of {@link TableAttributesV2#getTableName}
         * @param tableName The name of the table.
         *                  Note: You must specify this or the <code>tableArn</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Sets the value of {@link TableAttributesV2#getTableStreamArn}
         * @param tableStreamArn The stream ARN of the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableStreamArn(java.lang.String tableStreamArn) {
            this.tableStreamArn = tableStreamArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TableAttributesV2}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TableAttributesV2 build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TableAttributesV2}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableAttributesV2 {
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final java.util.List<java.lang.String> globalIndexes;
        private final java.lang.Boolean grantIndexPermissions;
        private final java.util.List<java.lang.String> localIndexes;
        private final java.lang.String tableArn;
        private final java.lang.String tableId;
        private final java.lang.String tableName;
        private final java.lang.String tableStreamArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.globalIndexes = software.amazon.jsii.Kernel.get(this, "globalIndexes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.grantIndexPermissions = software.amazon.jsii.Kernel.get(this, "grantIndexPermissions", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.localIndexes = software.amazon.jsii.Kernel.get(this, "localIndexes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tableArn = software.amazon.jsii.Kernel.get(this, "tableArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tableId = software.amazon.jsii.Kernel.get(this, "tableId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tableStreamArn = software.amazon.jsii.Kernel.get(this, "tableStreamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.encryptionKey = builder.encryptionKey;
            this.globalIndexes = builder.globalIndexes;
            this.grantIndexPermissions = builder.grantIndexPermissions;
            this.localIndexes = builder.localIndexes;
            this.tableArn = builder.tableArn;
            this.tableId = builder.tableId;
            this.tableName = builder.tableName;
            this.tableStreamArn = builder.tableStreamArn;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final java.util.List<java.lang.String> getGlobalIndexes() {
            return this.globalIndexes;
        }

        @Override
        public final java.lang.Boolean getGrantIndexPermissions() {
            return this.grantIndexPermissions;
        }

        @Override
        public final java.util.List<java.lang.String> getLocalIndexes() {
            return this.localIndexes;
        }

        @Override
        public final java.lang.String getTableArn() {
            return this.tableArn;
        }

        @Override
        public final java.lang.String getTableId() {
            return this.tableId;
        }

        @Override
        public final java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        public final java.lang.String getTableStreamArn() {
            return this.tableStreamArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getGlobalIndexes() != null) {
                data.set("globalIndexes", om.valueToTree(this.getGlobalIndexes()));
            }
            if (this.getGrantIndexPermissions() != null) {
                data.set("grantIndexPermissions", om.valueToTree(this.getGrantIndexPermissions()));
            }
            if (this.getLocalIndexes() != null) {
                data.set("localIndexes", om.valueToTree(this.getLocalIndexes()));
            }
            if (this.getTableArn() != null) {
                data.set("tableArn", om.valueToTree(this.getTableArn()));
            }
            if (this.getTableId() != null) {
                data.set("tableId", om.valueToTree(this.getTableId()));
            }
            if (this.getTableName() != null) {
                data.set("tableName", om.valueToTree(this.getTableName()));
            }
            if (this.getTableStreamArn() != null) {
                data.set("tableStreamArn", om.valueToTree(this.getTableStreamArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.TableAttributesV2"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TableAttributesV2.Jsii$Proxy that = (TableAttributesV2.Jsii$Proxy) o;

            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.globalIndexes != null ? !this.globalIndexes.equals(that.globalIndexes) : that.globalIndexes != null) return false;
            if (this.grantIndexPermissions != null ? !this.grantIndexPermissions.equals(that.grantIndexPermissions) : that.grantIndexPermissions != null) return false;
            if (this.localIndexes != null ? !this.localIndexes.equals(that.localIndexes) : that.localIndexes != null) return false;
            if (this.tableArn != null ? !this.tableArn.equals(that.tableArn) : that.tableArn != null) return false;
            if (this.tableId != null ? !this.tableId.equals(that.tableId) : that.tableId != null) return false;
            if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) return false;
            return this.tableStreamArn != null ? this.tableStreamArn.equals(that.tableStreamArn) : that.tableStreamArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.encryptionKey != null ? this.encryptionKey.hashCode() : 0;
            result = 31 * result + (this.globalIndexes != null ? this.globalIndexes.hashCode() : 0);
            result = 31 * result + (this.grantIndexPermissions != null ? this.grantIndexPermissions.hashCode() : 0);
            result = 31 * result + (this.localIndexes != null ? this.localIndexes.hashCode() : 0);
            result = 31 * result + (this.tableArn != null ? this.tableArn.hashCode() : 0);
            result = 31 * result + (this.tableId != null ? this.tableId.hashCode() : 0);
            result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
            result = 31 * result + (this.tableStreamArn != null ? this.tableStreamArn.hashCode() : 0);
            return result;
        }
    }
}
