package software.amazon.awscdk.services.ec2;

/**
 * Amazon Linux 2022 kernel versions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * AmazonLinux2022Kernel amazonLinux2022Kernel = AmazonLinux2022Kernel.CDK_LATEST;
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:22.872Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.AmazonLinux2022Kernel")
public class AmazonLinux2022Kernel extends software.amazon.jsii.JsiiObject {

    protected AmazonLinux2022Kernel(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AmazonLinux2022Kernel(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CDK_LATEST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.AmazonLinux2022Kernel.class, "CDK_LATEST", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AmazonLinux2022Kernel.class));
        DEFAULT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.AmazonLinux2022Kernel.class, "DEFAULT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AmazonLinux2022Kernel.class));
        KERNEL_5_15 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.AmazonLinux2022Kernel.class, "KERNEL_5_15", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AmazonLinux2022Kernel.class));
    }

    /**
     * @param version This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AmazonLinux2022Kernel(final @org.jetbrains.annotations.NotNull java.lang.String version) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * Generate a string representation of the kernel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The latest kernel version currently available in a published AMI.
     * <p>
     * When a new kernel version is available for an al2022 AMI this will be
     * updated to contain the latest kernel version and will cause your instances
     * to be replaced. Do not store stateful information on the instance if you are
     * using this version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.AmazonLinux2022Kernel CDK_LATEST;

    /**
     * The default kernel version for Amazon Linux 2022 is 5.15 and the SSM parameter does not include it in the name (i.e. /aws/service/ami-amazon-linux-latest/amzn2022-ami-kernel-default-x86_64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.AmazonLinux2022Kernel DEFAULT;

    /**
     * Kernel version 5.15.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.AmazonLinux2022Kernel KERNEL_5_15;
}
