package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnEIP</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Instance instance;
 * HostedZone myZone;
 * CfnEIP elasticIp = CfnEIP.Builder.create(this, "EIP")
 *         .domain("vpc")
 *         .instanceId(instance.getInstanceId())
 *         .build();
 * ARecord.Builder.create(this, "ARecord")
 *         .zone(myZone)
 *         .target(RecordTarget.fromIpAddresses(elasticIp.getRef()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-eip.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-eip.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:22.974Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnEIPProps")
@software.amazon.jsii.Jsii.Proxy(CfnEIPProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEIPProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * An Elastic IP address or a carrier IP address in a Wavelength Zone.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-eip.html#cfn-ec2-eip-address">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-eip.html#cfn-ec2-eip-address</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAddress() {
        return null;
    }

    /**
     * The network ( <code>vpc</code> ).
     * <p>
     * If you define an Elastic IP address and associate it with a VPC that is defined in the same template, you must declare a dependency on the VPC-gateway attachment by using the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> on this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-eip.html#cfn-ec2-eip-domain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-eip.html#cfn-ec2-eip-domain</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomain() {
        return null;
    }

    /**
     * The ID of the instance.
     * <p>
     * <blockquote>
     * <p>
     * Updates to the <code>InstanceId</code> property may require <em>some interruptions</em> . Updates on an EIP reassociates the address on its associated resource.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-eip.html#cfn-ec2-eip-instanceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-eip.html#cfn-ec2-eip-instanceid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceId() {
        return null;
    }

    /**
     * The ID of an IPAM pool which has an Amazon-provided or BYOIP public IPv4 CIDR provisioned to it.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-eip-pool.html">Allocate sequential Elastic IP addresses from an IPAM pool</a> in the <em>Amazon VPC IPAM User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-eip.html#cfn-ec2-eip-ipampoolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-eip.html#cfn-ec2-eip-ipampoolid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpamPoolId() {
        return null;
    }

    /**
     * A unique set of Availability Zones, Local Zones, or Wavelength Zones from which AWS advertises IP addresses.
     * <p>
     * Use this parameter to limit the IP address to this location. IP addresses cannot move between network border groups.
     * <p>
     * Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html">DescribeAvailabilityZones</a> to view the network border groups.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-eip.html#cfn-ec2-eip-networkbordergroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-eip.html#cfn-ec2-eip-networkbordergroup</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNetworkBorderGroup() {
        return null;
    }

    /**
     * The ID of an address pool that you own.
     * <p>
     * Use this parameter to let Amazon EC2 select an address from the address pool.
     * <p>
     * <blockquote>
     * <p>
     * Updates to the <code>PublicIpv4Pool</code> property may require <em>some interruptions</em> . Updates on an EIP reassociates the address on its associated resource.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-eip.html#cfn-ec2-eip-publicipv4pool">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-eip.html#cfn-ec2-eip-publicipv4pool</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPublicIpv4Pool() {
        return null;
    }

    /**
     * Any tags assigned to the Elastic IP address.
     * <p>
     * <blockquote>
     * <p>
     * Updates to the <code>Tags</code> property may require <em>some interruptions</em> . Updates on an EIP reassociates the address on its associated resource.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-eip.html#cfn-ec2-eip-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-eip.html#cfn-ec2-eip-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The Elastic IP address you are accepting for transfer.
     * <p>
     * You can only accept one transferred address. For more information on Elastic IP address transfers, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#transfer-EIPs-intro">Transfer Elastic IP addresses</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-eip.html#cfn-ec2-eip-transferaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-eip.html#cfn-ec2-eip-transferaddress</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTransferAddress() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEIPProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEIPProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEIPProps> {
        java.lang.String address;
        java.lang.String domain;
        java.lang.String instanceId;
        java.lang.String ipamPoolId;
        java.lang.String networkBorderGroup;
        java.lang.String publicIpv4Pool;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String transferAddress;

        /**
         * Sets the value of {@link CfnEIPProps#getAddress}
         * @param address An Elastic IP address or a carrier IP address in a Wavelength Zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder address(java.lang.String address) {
            this.address = address;
            return this;
        }

        /**
         * Sets the value of {@link CfnEIPProps#getDomain}
         * @param domain The network ( <code>vpc</code> ).
         *               If you define an Elastic IP address and associate it with a VPC that is defined in the same template, you must declare a dependency on the VPC-gateway attachment by using the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> on this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(java.lang.String domain) {
            this.domain = domain;
            return this;
        }

        /**
         * Sets the value of {@link CfnEIPProps#getInstanceId}
         * @param instanceId The ID of the instance.
         *                   <blockquote>
         *                   <p>
         *                   Updates to the <code>InstanceId</code> property may require <em>some interruptions</em> . Updates on an EIP reassociates the address on its associated resource.
         *                   <p>
         *                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceId(java.lang.String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEIPProps#getIpamPoolId}
         * @param ipamPoolId The ID of an IPAM pool which has an Amazon-provided or BYOIP public IPv4 CIDR provisioned to it.
         *                   For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-eip-pool.html">Allocate sequential Elastic IP addresses from an IPAM pool</a> in the <em>Amazon VPC IPAM User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipamPoolId(java.lang.String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEIPProps#getNetworkBorderGroup}
         * @param networkBorderGroup A unique set of Availability Zones, Local Zones, or Wavelength Zones from which AWS advertises IP addresses.
         *                           Use this parameter to limit the IP address to this location. IP addresses cannot move between network border groups.
         *                           <p>
         *                           Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html">DescribeAvailabilityZones</a> to view the network border groups.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkBorderGroup(java.lang.String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
            return this;
        }

        /**
         * Sets the value of {@link CfnEIPProps#getPublicIpv4Pool}
         * @param publicIpv4Pool The ID of an address pool that you own.
         *                       Use this parameter to let Amazon EC2 select an address from the address pool.
         *                       <p>
         *                       <blockquote>
         *                       <p>
         *                       Updates to the <code>PublicIpv4Pool</code> property may require <em>some interruptions</em> . Updates on an EIP reassociates the address on its associated resource.
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicIpv4Pool(java.lang.String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
            return this;
        }

        /**
         * Sets the value of {@link CfnEIPProps#getTags}
         * @param tags Any tags assigned to the Elastic IP address.
         *             <blockquote>
         *             <p>
         *             Updates to the <code>Tags</code> property may require <em>some interruptions</em> . Updates on an EIP reassociates the address on its associated resource.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnEIPProps#getTransferAddress}
         * @param transferAddress The Elastic IP address you are accepting for transfer.
         *                        You can only accept one transferred address. For more information on Elastic IP address transfers, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#transfer-EIPs-intro">Transfer Elastic IP addresses</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transferAddress(java.lang.String transferAddress) {
            this.transferAddress = transferAddress;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEIPProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEIPProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEIPProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEIPProps {
        private final java.lang.String address;
        private final java.lang.String domain;
        private final java.lang.String instanceId;
        private final java.lang.String ipamPoolId;
        private final java.lang.String networkBorderGroup;
        private final java.lang.String publicIpv4Pool;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String transferAddress;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.address = software.amazon.jsii.Kernel.get(this, "address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domain = software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceId = software.amazon.jsii.Kernel.get(this, "instanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipamPoolId = software.amazon.jsii.Kernel.get(this, "ipamPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkBorderGroup = software.amazon.jsii.Kernel.get(this, "networkBorderGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publicIpv4Pool = software.amazon.jsii.Kernel.get(this, "publicIpv4Pool", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.transferAddress = software.amazon.jsii.Kernel.get(this, "transferAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.address = builder.address;
            this.domain = builder.domain;
            this.instanceId = builder.instanceId;
            this.ipamPoolId = builder.ipamPoolId;
            this.networkBorderGroup = builder.networkBorderGroup;
            this.publicIpv4Pool = builder.publicIpv4Pool;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.transferAddress = builder.transferAddress;
        }

        @Override
        public final java.lang.String getAddress() {
            return this.address;
        }

        @Override
        public final java.lang.String getDomain() {
            return this.domain;
        }

        @Override
        public final java.lang.String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final java.lang.String getIpamPoolId() {
            return this.ipamPoolId;
        }

        @Override
        public final java.lang.String getNetworkBorderGroup() {
            return this.networkBorderGroup;
        }

        @Override
        public final java.lang.String getPublicIpv4Pool() {
            return this.publicIpv4Pool;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTransferAddress() {
            return this.transferAddress;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAddress() != null) {
                data.set("address", om.valueToTree(this.getAddress()));
            }
            if (this.getDomain() != null) {
                data.set("domain", om.valueToTree(this.getDomain()));
            }
            if (this.getInstanceId() != null) {
                data.set("instanceId", om.valueToTree(this.getInstanceId()));
            }
            if (this.getIpamPoolId() != null) {
                data.set("ipamPoolId", om.valueToTree(this.getIpamPoolId()));
            }
            if (this.getNetworkBorderGroup() != null) {
                data.set("networkBorderGroup", om.valueToTree(this.getNetworkBorderGroup()));
            }
            if (this.getPublicIpv4Pool() != null) {
                data.set("publicIpv4Pool", om.valueToTree(this.getPublicIpv4Pool()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTransferAddress() != null) {
                data.set("transferAddress", om.valueToTree(this.getTransferAddress()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnEIPProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEIPProps.Jsii$Proxy that = (CfnEIPProps.Jsii$Proxy) o;

            if (this.address != null ? !this.address.equals(that.address) : that.address != null) return false;
            if (this.domain != null ? !this.domain.equals(that.domain) : that.domain != null) return false;
            if (this.instanceId != null ? !this.instanceId.equals(that.instanceId) : that.instanceId != null) return false;
            if (this.ipamPoolId != null ? !this.ipamPoolId.equals(that.ipamPoolId) : that.ipamPoolId != null) return false;
            if (this.networkBorderGroup != null ? !this.networkBorderGroup.equals(that.networkBorderGroup) : that.networkBorderGroup != null) return false;
            if (this.publicIpv4Pool != null ? !this.publicIpv4Pool.equals(that.publicIpv4Pool) : that.publicIpv4Pool != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.transferAddress != null ? this.transferAddress.equals(that.transferAddress) : that.transferAddress == null;
        }

        @Override
        public final int hashCode() {
            int result = this.address != null ? this.address.hashCode() : 0;
            result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
            result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
            result = 31 * result + (this.ipamPoolId != null ? this.ipamPoolId.hashCode() : 0);
            result = 31 * result + (this.networkBorderGroup != null ? this.networkBorderGroup.hashCode() : 0);
            result = 31 * result + (this.publicIpv4Pool != null ? this.publicIpv4Pool.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.transferAddress != null ? this.transferAddress.hashCode() : 0);
            return result;
        }
    }
}
