package software.amazon.awscdk.services.ec2;

/**
 * Determines where your instances are placed on the underlying hardware according to the specified PlacementGroupStrategy.
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:23.412Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.IPlacementGroup")
@software.amazon.jsii.Jsii.Proxy(IPlacementGroup.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IPlacementGroup extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.IResource {

    /**
     * The name of this placement group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPlacementGroupName();

    /**
     * The number of partitions.
     * <p>
     * Valid only when Strategy is set to PARTITION.
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPartitions() {
        return null;
    }

    /**
     * Places instances on distinct hardware.
     * <p>
     * Spread placement groups are recommended for applications
     * that have a small number of critical instances that should be kept separate from each other.
     * Launching instances in a spread level placement group reduces the risk of simultaneous failures
     * that might occur when instances share the same equipment.
     * Spread level placement groups provide access to distinct hardware,
     * and are therefore suitable for mixing instance types or launching instances over time.
     * If you start or launch an instance in a spread placement group and there is insufficient
     * unique hardware to fulfill the request, the request fails. Amazon EC2 makes more distinct hardware
     * available over time, so you can try your request again later.
     * Placement groups can spread instances across racks or hosts.
     * You can use host level spread placement groups only with AWS Outposts.
     * <p>
     * Default: - no spread level
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.PlacementGroupSpreadLevel getSpreadLevel() {
        return null;
    }

    /**
     * Which strategy to use when launching instances.
     * <p>
     * Default: - `PlacementGroupStrategy.PARTITION` if `partitions` is defined, `CLUSTER` otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.PlacementGroupStrategy getStrategy() {
        return null;
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IPlacementGroup.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * The name of this placement group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getPlacementGroupName() {
            return software.amazon.jsii.Kernel.get(this, "placementGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The number of partitions.
         * <p>
         * Valid only when Strategy is set to PARTITION.
         * <p>
         * Default: 0
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Number getPartitions() {
            return software.amazon.jsii.Kernel.get(this, "partitions", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Places instances on distinct hardware.
         * <p>
         * Spread placement groups are recommended for applications
         * that have a small number of critical instances that should be kept separate from each other.
         * Launching instances in a spread level placement group reduces the risk of simultaneous failures
         * that might occur when instances share the same equipment.
         * Spread level placement groups provide access to distinct hardware,
         * and are therefore suitable for mixing instance types or launching instances over time.
         * If you start or launch an instance in a spread placement group and there is insufficient
         * unique hardware to fulfill the request, the request fails. Amazon EC2 makes more distinct hardware
         * available over time, so you can try your request again later.
         * Placement groups can spread instances across racks or hosts.
         * You can use host level spread placement groups only with AWS Outposts.
         * <p>
         * Default: - no spread level
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.PlacementGroupSpreadLevel getSpreadLevel() {
            return software.amazon.jsii.Kernel.get(this, "spreadLevel", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.PlacementGroupSpreadLevel.class));
        }

        /**
         * Which strategy to use when launching instances.
         * <p>
         * Default: - `PlacementGroupStrategy.PARTITION` if `partitions` is defined, `CLUSTER` otherwise
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.PlacementGroupStrategy getStrategy() {
            return software.amazon.jsii.Kernel.get(this, "strategy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.PlacementGroupStrategy.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }
    }

    /**
     * Internal default implementation for {@link IPlacementGroup}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IPlacementGroup, software.amazon.awscdk.IResource.Jsii$Default {

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * The name of this placement group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getPlacementGroupName() {
            return software.amazon.jsii.Kernel.get(this, "placementGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The number of partitions.
         * <p>
         * Valid only when Strategy is set to PARTITION.
         * <p>
         * Default: 0
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPartitions() {
            return software.amazon.jsii.Kernel.get(this, "partitions", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Places instances on distinct hardware.
         * <p>
         * Spread placement groups are recommended for applications
         * that have a small number of critical instances that should be kept separate from each other.
         * Launching instances in a spread level placement group reduces the risk of simultaneous failures
         * that might occur when instances share the same equipment.
         * Spread level placement groups provide access to distinct hardware,
         * and are therefore suitable for mixing instance types or launching instances over time.
         * If you start or launch an instance in a spread placement group and there is insufficient
         * unique hardware to fulfill the request, the request fails. Amazon EC2 makes more distinct hardware
         * available over time, so you can try your request again later.
         * Placement groups can spread instances across racks or hosts.
         * You can use host level spread placement groups only with AWS Outposts.
         * <p>
         * Default: - no spread level
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.PlacementGroupSpreadLevel getSpreadLevel() {
            return software.amazon.jsii.Kernel.get(this, "spreadLevel", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.PlacementGroupSpreadLevel.class));
        }

        /**
         * Which strategy to use when launching instances.
         * <p>
         * Default: - `PlacementGroupStrategy.PARTITION` if `partitions` is defined, `CLUSTER` otherwise
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.PlacementGroupStrategy getStrategy() {
            return software.amazon.jsii.Kernel.get(this, "strategy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.PlacementGroupStrategy.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }
    }
}
