package software.amazon.awscdk.services.ec2;

/**
 * Options for an InitService.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket myBucket;
 * InitServiceRestartHandle handle = new InitServiceRestartHandle();
 * CloudFormationInit.fromElements(InitFile.fromString("/etc/nginx/nginx.conf", "...", InitFileOptions.builder().serviceRestartHandles(List.of(handle)).build()), InitSource.fromS3Object("/var/www/html", myBucket, "html.zip", InitSourceOptions.builder().serviceRestartHandles(List.of(handle)).build()), InitService.enable("nginx", InitServiceOptions.builder()
 *         .serviceRestartHandle(handle)
 *         .build()));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:23.440Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.InitServiceOptions")
@software.amazon.jsii.Jsii.Proxy(InitServiceOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InitServiceOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Enable or disable this service.
     * <p>
     * Set to true to ensure that the service will be started automatically upon boot.
     * <p>
     * Set to false to ensure that the service will not be started automatically upon boot.
     * <p>
     * Default: - true if used in `InitService.enable()`, no change to service
     * state if used in `InitService.fromOptions()`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * Make sure this service is running or not running after cfn-init finishes.
     * <p>
     * Set to true to ensure that the service is running after cfn-init finishes.
     * <p>
     * Set to false to ensure that the service is not running after cfn-init finishes.
     * <p>
     * Default: - same value as `enabled`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnsureRunning() {
        return null;
    }

    /**
     * What service manager to use.
     * <p>
     * This needs to match the actual service manager on your Operating System.
     * For example, Amazon Linux 1 uses SysVinit, but Amazon Linux 2 uses Systemd.
     * <p>
     * Default: ServiceManager.SYSVINIT for Linux images, ServiceManager.WINDOWS for Windows images
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ServiceManager getServiceManager() {
        return null;
    }

    /**
     * Restart service when the actions registered into the restartHandle have been performed.
     * <p>
     * Register actions into the restartHandle by passing it to <code>InitFile</code>, <code>InitCommand</code>,
     * <code>InitPackage</code> and <code>InitSource</code> objects.
     * <p>
     * Default: - No files trigger restart
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InitServiceRestartHandle getServiceRestartHandle() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link InitServiceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InitServiceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InitServiceOptions> {
        java.lang.Boolean enabled;
        java.lang.Boolean ensureRunning;
        software.amazon.awscdk.services.ec2.ServiceManager serviceManager;
        software.amazon.awscdk.services.ec2.InitServiceRestartHandle serviceRestartHandle;

        /**
         * Sets the value of {@link InitServiceOptions#getEnabled}
         * @param enabled Enable or disable this service.
         *                Set to true to ensure that the service will be started automatically upon boot.
         *                <p>
         *                Set to false to ensure that the service will not be started automatically upon boot.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link InitServiceOptions#getEnsureRunning}
         * @param ensureRunning Make sure this service is running or not running after cfn-init finishes.
         *                      Set to true to ensure that the service is running after cfn-init finishes.
         *                      <p>
         *                      Set to false to ensure that the service is not running after cfn-init finishes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ensureRunning(java.lang.Boolean ensureRunning) {
            this.ensureRunning = ensureRunning;
            return this;
        }

        /**
         * Sets the value of {@link InitServiceOptions#getServiceManager}
         * @param serviceManager What service manager to use.
         *                       This needs to match the actual service manager on your Operating System.
         *                       For example, Amazon Linux 1 uses SysVinit, but Amazon Linux 2 uses Systemd.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceManager(software.amazon.awscdk.services.ec2.ServiceManager serviceManager) {
            this.serviceManager = serviceManager;
            return this;
        }

        /**
         * Sets the value of {@link InitServiceOptions#getServiceRestartHandle}
         * @param serviceRestartHandle Restart service when the actions registered into the restartHandle have been performed.
         *                             Register actions into the restartHandle by passing it to <code>InitFile</code>, <code>InitCommand</code>,
         *                             <code>InitPackage</code> and <code>InitSource</code> objects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRestartHandle(software.amazon.awscdk.services.ec2.InitServiceRestartHandle serviceRestartHandle) {
            this.serviceRestartHandle = serviceRestartHandle;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InitServiceOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InitServiceOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InitServiceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InitServiceOptions {
        private final java.lang.Boolean enabled;
        private final java.lang.Boolean ensureRunning;
        private final software.amazon.awscdk.services.ec2.ServiceManager serviceManager;
        private final software.amazon.awscdk.services.ec2.InitServiceRestartHandle serviceRestartHandle;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ensureRunning = software.amazon.jsii.Kernel.get(this, "ensureRunning", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.serviceManager = software.amazon.jsii.Kernel.get(this, "serviceManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ServiceManager.class));
            this.serviceRestartHandle = software.amazon.jsii.Kernel.get(this, "serviceRestartHandle", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitServiceRestartHandle.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.enabled = builder.enabled;
            this.ensureRunning = builder.ensureRunning;
            this.serviceManager = builder.serviceManager;
            this.serviceRestartHandle = builder.serviceRestartHandle;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.Boolean getEnsureRunning() {
            return this.ensureRunning;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ServiceManager getServiceManager() {
            return this.serviceManager;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InitServiceRestartHandle getServiceRestartHandle() {
            return this.serviceRestartHandle;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getEnsureRunning() != null) {
                data.set("ensureRunning", om.valueToTree(this.getEnsureRunning()));
            }
            if (this.getServiceManager() != null) {
                data.set("serviceManager", om.valueToTree(this.getServiceManager()));
            }
            if (this.getServiceRestartHandle() != null) {
                data.set("serviceRestartHandle", om.valueToTree(this.getServiceRestartHandle()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.InitServiceOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InitServiceOptions.Jsii$Proxy that = (InitServiceOptions.Jsii$Proxy) o;

            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.ensureRunning != null ? !this.ensureRunning.equals(that.ensureRunning) : that.ensureRunning != null) return false;
            if (this.serviceManager != null ? !this.serviceManager.equals(that.serviceManager) : that.serviceManager != null) return false;
            return this.serviceRestartHandle != null ? this.serviceRestartHandle.equals(that.serviceRestartHandle) : that.serviceRestartHandle == null;
        }

        @Override
        public final int hashCode() {
            int result = this.enabled != null ? this.enabled.hashCode() : 0;
            result = 31 * result + (this.ensureRunning != null ? this.ensureRunning.hashCode() : 0);
            result = 31 * result + (this.serviceManager != null ? this.serviceManager.hashCode() : 0);
            result = 31 * result + (this.serviceRestartHandle != null ? this.serviceRestartHandle.hashCode() : 0);
            return result;
        }
    }
}
