package software.amazon.awscdk.services.ecr.assets;

/**
 * An asset that represents a Docker image.
 * <p>
 * The image will be created in build time and uploaded to an ECR repository.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ecr.assets.DockerImageAsset;
 * DockerImageAsset asset = DockerImageAsset.Builder.create(this, "MyBuildImage")
 *         .directory(join(__dirname, "my-image"))
 *         .buildArgs(Map.of(
 *                 "HTTP_PROXY", "http://10.20.30.2:1234"))
 *         .invalidation(DockerImageAssetInvalidationOptions.builder()
 *                 .buildArgs(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:23.607Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecr_assets.DockerImageAsset")
public class DockerImageAsset extends software.constructs.Construct {

    protected DockerImageAsset(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DockerImageAsset(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DockerImageAsset(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.assets.DockerImageAssetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds CloudFormation template metadata to the specified resource with information that indicates which resource property is mapped to this local asset.
     * <p>
     * This can be used by tools such as SAM CLI to provide local
     * experience such as local invocation and debugging of Lambda functions.
     * <p>
     * Asset metadata will only be included if the stack is synthesized with the
     * "aws:cdk:enable-asset-metadata" context key defined, which is the default
     * behavior when synthesizing via the CDK Toolkit.
     * <p>
     * @see <a href="https://github.com/aws/aws-cdk/issues/1432">https://github.com/aws/aws-cdk/issues/1432</a>
     * @param resource The CloudFormation resource which is using this asset [disable-awslint:ref-via-interface]. This parameter is required.
     * @param resourceProperty The property name where this asset is referenced. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addResourceMetadata(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnResource resource, final @org.jetbrains.annotations.NotNull java.lang.String resourceProperty) {
        software.amazon.jsii.Kernel.call(this, "addResourceMetadata", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(resource, "resource is required"), java.util.Objects.requireNonNull(resourceProperty, "resourceProperty is required") });
    }

    /**
     * A hash of this asset, which is available at construction time.
     * <p>
     * As this is a plain string, it
     * can be used in construct IDs in order to enforce creation of a new resource when the content
     * hash has changed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssetHash() {
        return software.amazon.jsii.Kernel.get(this, "assetHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The tag of this asset when it is uploaded to ECR.
     * <p>
     * The tag may differ from the assetHash if a stack synthesizer adds a dockerTagPrefix.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getImageTag() {
        return software.amazon.jsii.Kernel.get(this, "imageTag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The full URI of the image (including a tag).
     * <p>
     * Use this reference to pull
     * the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getImageUri() {
        return software.amazon.jsii.Kernel.get(this, "imageUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The full URI of the image (including a tag).
     * <p>
     * Use this reference to pull
     * the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImageUri(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "imageUri", java.util.Objects.requireNonNull(value, "imageUri is required"));
    }

    /**
     * Repository where the image is stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository getRepository() {
        return software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.IRepository.class));
    }

    /**
     * Repository where the image is stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository value) {
        software.amazon.jsii.Kernel.set(this, "repository", java.util.Objects.requireNonNull(value, "repository is required"));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecr.assets.DockerImageAsset}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecr.assets.DockerImageAsset> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ecr.assets.DockerImageAssetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ecr.assets.DockerImageAssetProps.Builder();
        }

        /**
         * File paths matching the patterns will be excluded.
         * <p>
         * See <code>ignoreMode</code> to set the matching behavior.
         * Has no effect on Assets bundled using the <code>bundling</code> property.
         * <p>
         * Default: - nothing is excluded
         * <p>
         * @return {@code this}
         * @param exclude File paths matching the patterns will be excluded. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclude(final java.util.List<java.lang.String> exclude) {
            this.props.exclude(exclude);
            return this;
        }

        /**
         * A strategy for how to handle symlinks.
         * <p>
         * Default: SymlinkFollowMode.NEVER
         * <p>
         * @return {@code this}
         * @param followSymlinks A strategy for how to handle symlinks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder followSymlinks(final software.amazon.awscdk.SymlinkFollowMode followSymlinks) {
            this.props.followSymlinks(followSymlinks);
            return this;
        }

        /**
         * The ignore behavior to use for <code>exclude</code> patterns.
         * <p>
         * Default: IgnoreMode.GLOB
         * <p>
         * @return {@code this}
         * @param ignoreMode The ignore behavior to use for <code>exclude</code> patterns. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreMode(final software.amazon.awscdk.IgnoreMode ignoreMode) {
            this.props.ignoreMode(ignoreMode);
            return this;
        }

        /**
         * Extra information to encode into the fingerprint (e.g. build instructions and other inputs).
         * <p>
         * Default: - hash is only based on source content
         * <p>
         * @return {@code this}
         * @param extraHash Extra information to encode into the fingerprint (e.g. build instructions and other inputs). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extraHash(final java.lang.String extraHash) {
            this.props.extraHash(extraHash);
            return this;
        }

        /**
         * Unique identifier of the docker image asset and its potential revisions.
         * <p>
         * Required if using AppScopedStagingSynthesizer.
         * <p>
         * Default: - no asset name
         * <p>
         * @return {@code this}
         * @param assetName Unique identifier of the docker image asset and its potential revisions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetName(final java.lang.String assetName) {
            this.props.assetName(assetName);
            return this;
        }

        /**
         * Build args to pass to the <code>docker build</code> command.
         * <p>
         * Since Docker build arguments are resolved before deployment, keys and
         * values cannot refer to unresolved tokens (such as <code>lambda.functionArn</code> or
         * <code>queue.queueUrl</code>).
         * <p>
         * Default: - no build args are passed
         * <p>
         * @return {@code this}
         * @param buildArgs Build args to pass to the <code>docker build</code> command. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildArgs(final java.util.Map<java.lang.String, java.lang.String> buildArgs) {
            this.props.buildArgs(buildArgs);
            return this;
        }

        /**
         * Build secrets.
         * <p>
         * Docker BuildKit must be enabled to use build secrets.
         * <p>
         * Default: - no build secrets
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * import software.amazon.awscdk.DockerBuildSecret;
         * Map&lt;String, String&gt; buildSecrets = Map.of(
         *         "MY_SECRET", DockerBuildSecret.fromSrc("file.txt"));
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.docker.com/build/buildkit/">https://docs.docker.com/build/buildkit/</a>
         * @param buildSecrets Build secrets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildSecrets(final java.util.Map<java.lang.String, java.lang.String> buildSecrets) {
            this.props.buildSecrets(buildSecrets);
            return this;
        }

        /**
         * SSH agent socket or keys to pass to the <code>docker build</code> command.
         * <p>
         * Docker BuildKit must be enabled to use the ssh flag
         * <p>
         * Default: - no --ssh flag
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.docker.com/build/buildkit/">https://docs.docker.com/build/buildkit/</a>
         * @param buildSsh SSH agent socket or keys to pass to the <code>docker build</code> command. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildSsh(final java.lang.String buildSsh) {
            this.props.buildSsh(buildSsh);
            return this;
        }

        /**
         * Disable the cache and pass <code>--no-cache</code> to the <code>docker build</code> command.
         * <p>
         * Default: - cache is used
         * <p>
         * @return {@code this}
         * @param cacheDisabled Disable the cache and pass <code>--no-cache</code> to the <code>docker build</code> command. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheDisabled(final java.lang.Boolean cacheDisabled) {
            this.props.cacheDisabled(cacheDisabled);
            return this;
        }

        /**
         * Cache from options to pass to the <code>docker build</code> command.
         * <p>
         * Default: - no cache from options are passed to the build command
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.docker.com/build/cache/backends/">https://docs.docker.com/build/cache/backends/</a>
         * @param cacheFrom Cache from options to pass to the <code>docker build</code> command. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheFrom(final java.util.List<? extends software.amazon.awscdk.services.ecr.assets.DockerCacheOption> cacheFrom) {
            this.props.cacheFrom(cacheFrom);
            return this;
        }

        /**
         * Cache to options to pass to the <code>docker build</code> command.
         * <p>
         * Default: - no cache to options are passed to the build command
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.docker.com/build/cache/backends/">https://docs.docker.com/build/cache/backends/</a>
         * @param cacheTo Cache to options to pass to the <code>docker build</code> command. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheTo(final software.amazon.awscdk.services.ecr.assets.DockerCacheOption cacheTo) {
            this.props.cacheTo(cacheTo);
            return this;
        }

        /**
         * Path to the Dockerfile (relative to the directory).
         * <p>
         * Default: 'Dockerfile'
         * <p>
         * @return {@code this}
         * @param file Path to the Dockerfile (relative to the directory). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder file(final java.lang.String file) {
            this.props.file(file);
            return this;
        }

        /**
         * Options to control which parameters are used to invalidate the asset hash.
         * <p>
         * Default: - hash all parameters
         * <p>
         * @return {@code this}
         * @param invalidation Options to control which parameters are used to invalidate the asset hash. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invalidation(final software.amazon.awscdk.services.ecr.assets.DockerImageAssetInvalidationOptions invalidation) {
            this.props.invalidation(invalidation);
            return this;
        }

        /**
         * Networking mode for the RUN commands during build.
         * <p>
         * Support docker API 1.25+.
         * <p>
         * Default: - no networking mode specified (the default networking mode `NetworkMode.DEFAULT` will be used)
         * <p>
         * @return {@code this}
         * @param networkMode Networking mode for the RUN commands during build. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkMode(final software.amazon.awscdk.services.ecr.assets.NetworkMode networkMode) {
            this.props.networkMode(networkMode);
            return this;
        }

        /**
         * Outputs to pass to the <code>docker build</code> command.
         * <p>
         * Default: - no outputs are passed to the build command (default outputs are used)
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.docker.com/engine/reference/commandline/build/#custom-build-outputs">https://docs.docker.com/engine/reference/commandline/build/#custom-build-outputs</a>
         * @param outputs Outputs to pass to the <code>docker build</code> command. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(final java.util.List<java.lang.String> outputs) {
            this.props.outputs(outputs);
            return this;
        }

        /**
         * Platform to build for.
         * <p>
         * <em>Requires Docker Buildx</em>.
         * <p>
         * Default: - no platform specified (the current machine architecture will be used)
         * <p>
         * @return {@code this}
         * @param platform Platform to build for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platform(final software.amazon.awscdk.services.ecr.assets.Platform platform) {
            this.props.platform(platform);
            return this;
        }

        /**
         * Docker target to build to.
         * <p>
         * Default: - no target
         * <p>
         * @return {@code this}
         * @param target Docker target to build to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(final java.lang.String target) {
            this.props.target(target);
            return this;
        }

        /**
         * The directory where the Dockerfile is stored.
         * <p>
         * Any directory inside with a name that matches the CDK output folder (cdk.out by default) will be excluded from the asset
         * <p>
         * @return {@code this}
         * @param directory The directory where the Dockerfile is stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder directory(final java.lang.String directory) {
            this.props.directory(directory);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecr.assets.DockerImageAsset}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecr.assets.DockerImageAsset build() {
            return new software.amazon.awscdk.services.ecr.assets.DockerImageAsset(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
