package software.amazon.awscdk.services.ecs;

/**
 * The <code>AWS::ECS::Cluster</code> resource creates an Amazon Elastic Container Service (Amazon ECS) cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * CfnCluster cfnCluster = CfnCluster.Builder.create(this, "MyCfnCluster")
 *         .capacityProviders(List.of("capacityProviders"))
 *         .clusterName("clusterName")
 *         .clusterSettings(List.of(ClusterSettingsProperty.builder()
 *                 .name("name")
 *                 .value("value")
 *                 .build()))
 *         .configuration(ClusterConfigurationProperty.builder()
 *                 .executeCommandConfiguration(ExecuteCommandConfigurationProperty.builder()
 *                         .kmsKeyId("kmsKeyId")
 *                         .logConfiguration(ExecuteCommandLogConfigurationProperty.builder()
 *                                 .cloudWatchEncryptionEnabled(false)
 *                                 .cloudWatchLogGroupName("cloudWatchLogGroupName")
 *                                 .s3BucketName("s3BucketName")
 *                                 .s3EncryptionEnabled(false)
 *                                 .s3KeyPrefix("s3KeyPrefix")
 *                                 .build())
 *                         .logging("logging")
 *                         .build())
 *                 .managedStorageConfiguration(ManagedStorageConfigurationProperty.builder()
 *                         .fargateEphemeralStorageKmsKeyId("fargateEphemeralStorageKmsKeyId")
 *                         .kmsKeyId("kmsKeyId")
 *                         .build())
 *                 .build())
 *         .defaultCapacityProviderStrategy(List.of(CapacityProviderStrategyItemProperty.builder()
 *                 .base(123)
 *                 .capacityProvider("capacityProvider")
 *                 .weight(123)
 *                 .build()))
 *         .serviceConnectDefaults(ServiceConnectDefaultsProperty.builder()
 *                 .namespace("namespace")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:23.682Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCluster")
public class CfnCluster extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnCluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecs.CfnCluster.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the Amazon ECS cluster, such as <code>arn:aws:ecs:us-east-2:123456789012:cluster/MyECSCluster</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The short name of one or more capacity providers to associate with the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCapacityProviders() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "capacityProviders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The short name of one or more capacity providers to associate with the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCapacityProviders(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "capacityProviders", value);
    }

    /**
     * A user-generated string that you use to identify your cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getClusterName() {
        return software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A user-generated string that you use to identify your cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusterName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clusterName", value);
    }

    /**
     * The settings to use when creating a cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getClusterSettings() {
        return software.amazon.jsii.Kernel.get(this, "clusterSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The settings to use when creating a cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusterSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "clusterSettings", value);
    }

    /**
     * The settings to use when creating a cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusterSettings(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ecs.CfnCluster.ClusterSettingsProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ecs.CfnCluster.ClusterSettingsProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "clusterSettings", value);
    }

    /**
     * The execute command and managed storage configuration for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The execute command and managed storage configuration for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configuration", value);
    }

    /**
     * The execute command and managed storage configuration for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnCluster.ClusterConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "configuration", value);
    }

    /**
     * The default capacity provider strategy for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDefaultCapacityProviderStrategy() {
        return software.amazon.jsii.Kernel.get(this, "defaultCapacityProviderStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The default capacity provider strategy for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultCapacityProviderStrategy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "defaultCapacityProviderStrategy", value);
    }

    /**
     * The default capacity provider strategy for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultCapacityProviderStrategy(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ecs.CfnCluster.CapacityProviderStrategyItemProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ecs.CfnCluster.CapacityProviderStrategyItemProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "defaultCapacityProviderStrategy", value);
    }

    /**
     * Use this parameter to set a default Service Connect namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getServiceConnectDefaults() {
        return software.amazon.jsii.Kernel.get(this, "serviceConnectDefaults", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Use this parameter to set a default Service Connect namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceConnectDefaults(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "serviceConnectDefaults", value);
    }

    /**
     * Use this parameter to set a default Service Connect namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceConnectDefaults(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnCluster.ServiceConnectDefaultsProperty value) {
        software.amazon.jsii.Kernel.set(this, "serviceConnectDefaults", value);
    }

    /**
     * The metadata that you apply to the cluster to help you categorize and organize them.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The metadata that you apply to the cluster to help you categorize and organize them.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * The <code>CapacityProviderStrategyItem</code> property specifies the details of the default capacity provider strategy for the cluster.
     * <p>
     * When services or tasks are run in the cluster with no launch type or capacity provider strategy specified, the default capacity provider strategy is used.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * CapacityProviderStrategyItemProperty capacityProviderStrategyItemProperty = CapacityProviderStrategyItemProperty.builder()
     *         .base(123)
     *         .capacityProvider("capacityProvider")
     *         .weight(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-capacityproviderstrategyitem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-capacityproviderstrategyitem.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCluster.CapacityProviderStrategyItemProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacityProviderStrategyItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacityProviderStrategyItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The <em>base</em> value designates how many tasks, at a minimum, to run on the specified capacity provider.
         * <p>
         * Only one capacity provider in a capacity provider strategy can have a <em>base</em> defined. If no value is specified, the default value of <code>0</code> is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-capacityproviderstrategyitem.html#cfn-ecs-cluster-capacityproviderstrategyitem-base">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-capacityproviderstrategyitem.html#cfn-ecs-cluster-capacityproviderstrategyitem-base</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBase() {
            return null;
        }

        /**
         * The short name of the capacity provider.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-capacityproviderstrategyitem.html#cfn-ecs-cluster-capacityproviderstrategyitem-capacityprovider">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-capacityproviderstrategyitem.html#cfn-ecs-cluster-capacityproviderstrategyitem-capacityprovider</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCapacityProvider() {
            return null;
        }

        /**
         * The <em>weight</em> value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider.
         * <p>
         * The <code>weight</code> value is taken into consideration after the <code>base</code> value, if defined, is satisfied.
         * <p>
         * If no <code>weight</code> value is specified, the default value of <code>0</code> is used. When multiple capacity providers are specified within a capacity provider strategy, at least one of the capacity providers must have a weight value greater than zero and any capacity providers with a weight of <code>0</code> can't be used to place tasks. If you specify multiple capacity providers in a strategy that all have a weight of <code>0</code> , any <code>RunTask</code> or <code>CreateService</code> actions using the capacity provider strategy will fail.
         * <p>
         * An example scenario for using weights is defining a strategy that contains two capacity providers and both have a weight of <code>1</code> , then when the <code>base</code> is satisfied, the tasks will be split evenly across the two capacity providers. Using that same logic, if you specify a weight of <code>1</code> for <em>capacityProviderA</em> and a weight of <code>4</code> for <em>capacityProviderB</em> , then for every one task that's run using <em>capacityProviderA</em> , four tasks would use <em>capacityProviderB</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-capacityproviderstrategyitem.html#cfn-ecs-cluster-capacityproviderstrategyitem-weight">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-capacityproviderstrategyitem.html#cfn-ecs-cluster-capacityproviderstrategyitem-weight</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeight() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CapacityProviderStrategyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacityProviderStrategyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacityProviderStrategyItemProperty> {
            java.lang.Number base;
            java.lang.String capacityProvider;
            java.lang.Number weight;

            /**
             * Sets the value of {@link CapacityProviderStrategyItemProperty#getBase}
             * @param base The <em>base</em> value designates how many tasks, at a minimum, to run on the specified capacity provider.
             *             Only one capacity provider in a capacity provider strategy can have a <em>base</em> defined. If no value is specified, the default value of <code>0</code> is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder base(java.lang.Number base) {
                this.base = base;
                return this;
            }

            /**
             * Sets the value of {@link CapacityProviderStrategyItemProperty#getCapacityProvider}
             * @param capacityProvider The short name of the capacity provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityProvider(java.lang.String capacityProvider) {
                this.capacityProvider = capacityProvider;
                return this;
            }

            /**
             * Sets the value of {@link CapacityProviderStrategyItemProperty#getWeight}
             * @param weight The <em>weight</em> value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider.
             *               The <code>weight</code> value is taken into consideration after the <code>base</code> value, if defined, is satisfied.
             *               <p>
             *               If no <code>weight</code> value is specified, the default value of <code>0</code> is used. When multiple capacity providers are specified within a capacity provider strategy, at least one of the capacity providers must have a weight value greater than zero and any capacity providers with a weight of <code>0</code> can't be used to place tasks. If you specify multiple capacity providers in a strategy that all have a weight of <code>0</code> , any <code>RunTask</code> or <code>CreateService</code> actions using the capacity provider strategy will fail.
             *               <p>
             *               An example scenario for using weights is defining a strategy that contains two capacity providers and both have a weight of <code>1</code> , then when the <code>base</code> is satisfied, the tasks will be split evenly across the two capacity providers. Using that same logic, if you specify a weight of <code>1</code> for <em>capacityProviderA</em> and a weight of <code>4</code> for <em>capacityProviderB</em> , then for every one task that's run using <em>capacityProviderA</em> , four tasks would use <em>capacityProviderB</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weight(java.lang.Number weight) {
                this.weight = weight;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityProviderStrategyItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacityProviderStrategyItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapacityProviderStrategyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityProviderStrategyItemProperty {
            private final java.lang.Number base;
            private final java.lang.String capacityProvider;
            private final java.lang.Number weight;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.base = software.amazon.jsii.Kernel.get(this, "base", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.capacityProvider = software.amazon.jsii.Kernel.get(this, "capacityProvider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.weight = software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.base = builder.base;
                this.capacityProvider = builder.capacityProvider;
                this.weight = builder.weight;
            }

            @Override
            public final java.lang.Number getBase() {
                return this.base;
            }

            @Override
            public final java.lang.String getCapacityProvider() {
                return this.capacityProvider;
            }

            @Override
            public final java.lang.Number getWeight() {
                return this.weight;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBase() != null) {
                    data.set("base", om.valueToTree(this.getBase()));
                }
                if (this.getCapacityProvider() != null) {
                    data.set("capacityProvider", om.valueToTree(this.getCapacityProvider()));
                }
                if (this.getWeight() != null) {
                    data.set("weight", om.valueToTree(this.getWeight()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCluster.CapacityProviderStrategyItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityProviderStrategyItemProperty.Jsii$Proxy that = (CapacityProviderStrategyItemProperty.Jsii$Proxy) o;

                if (this.base != null ? !this.base.equals(that.base) : that.base != null) return false;
                if (this.capacityProvider != null ? !this.capacityProvider.equals(that.capacityProvider) : that.capacityProvider != null) return false;
                return this.weight != null ? this.weight.equals(that.weight) : that.weight == null;
            }

            @Override
            public final int hashCode() {
                int result = this.base != null ? this.base.hashCode() : 0;
                result = 31 * result + (this.capacityProvider != null ? this.capacityProvider.hashCode() : 0);
                result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The execute command and managed storage configuration for the cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ClusterConfigurationProperty clusterConfigurationProperty = ClusterConfigurationProperty.builder()
     *         .executeCommandConfiguration(ExecuteCommandConfigurationProperty.builder()
     *                 .kmsKeyId("kmsKeyId")
     *                 .logConfiguration(ExecuteCommandLogConfigurationProperty.builder()
     *                         .cloudWatchEncryptionEnabled(false)
     *                         .cloudWatchLogGroupName("cloudWatchLogGroupName")
     *                         .s3BucketName("s3BucketName")
     *                         .s3EncryptionEnabled(false)
     *                         .s3KeyPrefix("s3KeyPrefix")
     *                         .build())
     *                 .logging("logging")
     *                 .build())
     *         .managedStorageConfiguration(ManagedStorageConfigurationProperty.builder()
     *                 .fargateEphemeralStorageKmsKeyId("fargateEphemeralStorageKmsKeyId")
     *                 .kmsKeyId("kmsKeyId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-clusterconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-clusterconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCluster.ClusterConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusterConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusterConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The details of the execute command configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-clusterconfiguration.html#cfn-ecs-cluster-clusterconfiguration-executecommandconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-clusterconfiguration.html#cfn-ecs-cluster-clusterconfiguration-executecommandconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExecuteCommandConfiguration() {
            return null;
        }

        /**
         * The details of the managed storage configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-clusterconfiguration.html#cfn-ecs-cluster-clusterconfiguration-managedstorageconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-clusterconfiguration.html#cfn-ecs-cluster-clusterconfiguration-managedstorageconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getManagedStorageConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClusterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusterConfigurationProperty> {
            java.lang.Object executeCommandConfiguration;
            java.lang.Object managedStorageConfiguration;

            /**
             * Sets the value of {@link ClusterConfigurationProperty#getExecuteCommandConfiguration}
             * @param executeCommandConfiguration The details of the execute command configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executeCommandConfiguration(software.amazon.awscdk.IResolvable executeCommandConfiguration) {
                this.executeCommandConfiguration = executeCommandConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigurationProperty#getExecuteCommandConfiguration}
             * @param executeCommandConfiguration The details of the execute command configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executeCommandConfiguration(software.amazon.awscdk.services.ecs.CfnCluster.ExecuteCommandConfigurationProperty executeCommandConfiguration) {
                this.executeCommandConfiguration = executeCommandConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigurationProperty#getManagedStorageConfiguration}
             * @param managedStorageConfiguration The details of the managed storage configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedStorageConfiguration(software.amazon.awscdk.IResolvable managedStorageConfiguration) {
                this.managedStorageConfiguration = managedStorageConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigurationProperty#getManagedStorageConfiguration}
             * @param managedStorageConfiguration The details of the managed storage configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedStorageConfiguration(software.amazon.awscdk.services.ecs.CfnCluster.ManagedStorageConfigurationProperty managedStorageConfiguration) {
                this.managedStorageConfiguration = managedStorageConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusterConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusterConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterConfigurationProperty {
            private final java.lang.Object executeCommandConfiguration;
            private final java.lang.Object managedStorageConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.executeCommandConfiguration = software.amazon.jsii.Kernel.get(this, "executeCommandConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.managedStorageConfiguration = software.amazon.jsii.Kernel.get(this, "managedStorageConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.executeCommandConfiguration = builder.executeCommandConfiguration;
                this.managedStorageConfiguration = builder.managedStorageConfiguration;
            }

            @Override
            public final java.lang.Object getExecuteCommandConfiguration() {
                return this.executeCommandConfiguration;
            }

            @Override
            public final java.lang.Object getManagedStorageConfiguration() {
                return this.managedStorageConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExecuteCommandConfiguration() != null) {
                    data.set("executeCommandConfiguration", om.valueToTree(this.getExecuteCommandConfiguration()));
                }
                if (this.getManagedStorageConfiguration() != null) {
                    data.set("managedStorageConfiguration", om.valueToTree(this.getManagedStorageConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCluster.ClusterConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusterConfigurationProperty.Jsii$Proxy that = (ClusterConfigurationProperty.Jsii$Proxy) o;

                if (this.executeCommandConfiguration != null ? !this.executeCommandConfiguration.equals(that.executeCommandConfiguration) : that.executeCommandConfiguration != null) return false;
                return this.managedStorageConfiguration != null ? this.managedStorageConfiguration.equals(that.managedStorageConfiguration) : that.managedStorageConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.executeCommandConfiguration != null ? this.executeCommandConfiguration.hashCode() : 0;
                result = 31 * result + (this.managedStorageConfiguration != null ? this.managedStorageConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings to use when creating a cluster.
     * <p>
     * This parameter is used to turn on CloudWatch Container Insights with enhanced observability or CloudWatch Container Insights for a cluster.
     * <p>
     * Container Insights with enhanced observability provides all the Container Insights metrics, plus additional task and container metrics. This version supports enhanced observability for Amazon ECS clusters using the Amazon EC2 and Fargate launch types. After you configure Container Insights with enhanced observability on Amazon ECS, Container Insights auto-collects detailed infrastructure telemetry from the cluster level down to the container level in your environment and displays these critical performance data in curated dashboards removing the heavy lifting in observability set-up.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cloudwatch-container-insights.html">Monitor Amazon ECS containers using Container Insights with enhanced observability</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ClusterSettingsProperty clusterSettingsProperty = ClusterSettingsProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-clustersettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-clustersettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCluster.ClusterSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusterSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusterSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the cluster setting.
         * <p>
         * The value is <code>containerInsights</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-clustersettings.html#cfn-ecs-cluster-clustersettings-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-clustersettings.html#cfn-ecs-cluster-clustersettings-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The value to set for the cluster setting. The supported values are <code>enhanced</code> , <code>enabled</code> , and <code>disabled</code> .
         * <p>
         * To use Container Insights with enhanced observability, set the <code>containerInsights</code> account setting to <code>enhanced</code> .
         * <p>
         * To use Container Insights, set the <code>containerInsights</code> account setting to <code>enabled</code> .
         * <p>
         * If a cluster value is specified, it will override the <code>containerInsights</code> value set with <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html">PutAccountSetting</a> or <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html">PutAccountSettingDefault</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-clustersettings.html#cfn-ecs-cluster-clustersettings-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-clustersettings.html#cfn-ecs-cluster-clustersettings-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClusterSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusterSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusterSettingsProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link ClusterSettingsProperty#getName}
             * @param name The name of the cluster setting.
             *             The value is <code>containerInsights</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ClusterSettingsProperty#getValue}
             * @param value The value to set for the cluster setting. The supported values are <code>enhanced</code> , <code>enabled</code> , and <code>disabled</code> .
             *              To use Container Insights with enhanced observability, set the <code>containerInsights</code> account setting to <code>enhanced</code> .
             *              <p>
             *              To use Container Insights, set the <code>containerInsights</code> account setting to <code>enabled</code> .
             *              <p>
             *              If a cluster value is specified, it will override the <code>containerInsights</code> value set with <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html">PutAccountSetting</a> or <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html">PutAccountSettingDefault</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusterSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusterSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusterSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterSettingsProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCluster.ClusterSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusterSettingsProperty.Jsii$Proxy that = (ClusterSettingsProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The details of the execute command configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ExecuteCommandConfigurationProperty executeCommandConfigurationProperty = ExecuteCommandConfigurationProperty.builder()
     *         .kmsKeyId("kmsKeyId")
     *         .logConfiguration(ExecuteCommandLogConfigurationProperty.builder()
     *                 .cloudWatchEncryptionEnabled(false)
     *                 .cloudWatchLogGroupName("cloudWatchLogGroupName")
     *                 .s3BucketName("s3BucketName")
     *                 .s3EncryptionEnabled(false)
     *                 .s3KeyPrefix("s3KeyPrefix")
     *                 .build())
     *         .logging("logging")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-executecommandconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-executecommandconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCluster.ExecuteCommandConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ExecuteCommandConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExecuteCommandConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specify an AWS Key Management Service key ID to encrypt the data between the local client and the container.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-executecommandconfiguration.html#cfn-ecs-cluster-executecommandconfiguration-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-executecommandconfiguration.html#cfn-ecs-cluster-executecommandconfiguration-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * The log configuration for the results of the execute command actions.
         * <p>
         * The logs can be sent to CloudWatch Logs or an Amazon S3 bucket. When <code>logging=OVERRIDE</code> is specified, a <code>logConfiguration</code> must be provided.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-executecommandconfiguration.html#cfn-ecs-cluster-executecommandconfiguration-logconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-executecommandconfiguration.html#cfn-ecs-cluster-executecommandconfiguration-logconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLogConfiguration() {
            return null;
        }

        /**
         * The log setting to use for redirecting logs for your execute command results. The following log settings are available.
         * <p>
         * <ul>
         * <li><code>NONE</code> : The execute command session is not logged.</li>
         * <li><code>DEFAULT</code> : The <code>awslogs</code> configuration in the task definition is used. If no logging parameter is specified, it defaults to this value. If no <code>awslogs</code> log driver is configured in the task definition, the output won't be logged.</li>
         * <li><code>OVERRIDE</code> : Specify the logging details as a part of <code>logConfiguration</code> . If the <code>OVERRIDE</code> logging option is specified, the <code>logConfiguration</code> is required.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-executecommandconfiguration.html#cfn-ecs-cluster-executecommandconfiguration-logging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-executecommandconfiguration.html#cfn-ecs-cluster-executecommandconfiguration-logging</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogging() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExecuteCommandConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExecuteCommandConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExecuteCommandConfigurationProperty> {
            java.lang.String kmsKeyId;
            java.lang.Object logConfiguration;
            java.lang.String logging;

            /**
             * Sets the value of {@link ExecuteCommandConfigurationProperty#getKmsKeyId}
             * @param kmsKeyId Specify an AWS Key Management Service key ID to encrypt the data between the local client and the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link ExecuteCommandConfigurationProperty#getLogConfiguration}
             * @param logConfiguration The log configuration for the results of the execute command actions.
             *                         The logs can be sent to CloudWatch Logs or an Amazon S3 bucket. When <code>logging=OVERRIDE</code> is specified, a <code>logConfiguration</code> must be provided.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logConfiguration(software.amazon.awscdk.IResolvable logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExecuteCommandConfigurationProperty#getLogConfiguration}
             * @param logConfiguration The log configuration for the results of the execute command actions.
             *                         The logs can be sent to CloudWatch Logs or an Amazon S3 bucket. When <code>logging=OVERRIDE</code> is specified, a <code>logConfiguration</code> must be provided.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logConfiguration(software.amazon.awscdk.services.ecs.CfnCluster.ExecuteCommandLogConfigurationProperty logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExecuteCommandConfigurationProperty#getLogging}
             * @param logging The log setting to use for redirecting logs for your execute command results. The following log settings are available.
             *                <ul>
             *                <li><code>NONE</code> : The execute command session is not logged.</li>
             *                <li><code>DEFAULT</code> : The <code>awslogs</code> configuration in the task definition is used. If no logging parameter is specified, it defaults to this value. If no <code>awslogs</code> log driver is configured in the task definition, the output won't be logged.</li>
             *                <li><code>OVERRIDE</code> : Specify the logging details as a part of <code>logConfiguration</code> . If the <code>OVERRIDE</code> logging option is specified, the <code>logConfiguration</code> is required.</li>
             *                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logging(java.lang.String logging) {
                this.logging = logging;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExecuteCommandConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExecuteCommandConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExecuteCommandConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExecuteCommandConfigurationProperty {
            private final java.lang.String kmsKeyId;
            private final java.lang.Object logConfiguration;
            private final java.lang.String logging;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logConfiguration = software.amazon.jsii.Kernel.get(this, "logConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kmsKeyId = builder.kmsKeyId;
                this.logConfiguration = builder.logConfiguration;
                this.logging = builder.logging;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            public final java.lang.Object getLogConfiguration() {
                return this.logConfiguration;
            }

            @Override
            public final java.lang.String getLogging() {
                return this.logging;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }
                if (this.getLogConfiguration() != null) {
                    data.set("logConfiguration", om.valueToTree(this.getLogConfiguration()));
                }
                if (this.getLogging() != null) {
                    data.set("logging", om.valueToTree(this.getLogging()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCluster.ExecuteCommandConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExecuteCommandConfigurationProperty.Jsii$Proxy that = (ExecuteCommandConfigurationProperty.Jsii$Proxy) o;

                if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
                if (this.logConfiguration != null ? !this.logConfiguration.equals(that.logConfiguration) : that.logConfiguration != null) return false;
                return this.logging != null ? this.logging.equals(that.logging) : that.logging == null;
            }

            @Override
            public final int hashCode() {
                int result = this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0;
                result = 31 * result + (this.logConfiguration != null ? this.logConfiguration.hashCode() : 0);
                result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The log configuration for the results of the execute command actions.
     * <p>
     * The logs can be sent to CloudWatch Logs or an Amazon S3 bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ExecuteCommandLogConfigurationProperty executeCommandLogConfigurationProperty = ExecuteCommandLogConfigurationProperty.builder()
     *         .cloudWatchEncryptionEnabled(false)
     *         .cloudWatchLogGroupName("cloudWatchLogGroupName")
     *         .s3BucketName("s3BucketName")
     *         .s3EncryptionEnabled(false)
     *         .s3KeyPrefix("s3KeyPrefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-executecommandlogconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-executecommandlogconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCluster.ExecuteCommandLogConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ExecuteCommandLogConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExecuteCommandLogConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines whether to use encryption on the CloudWatch logs.
         * <p>
         * If not specified, encryption will be off.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-executecommandlogconfiguration.html#cfn-ecs-cluster-executecommandlogconfiguration-cloudwatchencryptionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-executecommandlogconfiguration.html#cfn-ecs-cluster-executecommandlogconfiguration-cloudwatchencryptionenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchEncryptionEnabled() {
            return null;
        }

        /**
         * The name of the CloudWatch log group to send logs to.
         * <p>
         * <blockquote>
         * <p>
         * The CloudWatch log group must already be created.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-executecommandlogconfiguration.html#cfn-ecs-cluster-executecommandlogconfiguration-cloudwatchloggroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-executecommandlogconfiguration.html#cfn-ecs-cluster-executecommandlogconfiguration-cloudwatchloggroupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCloudWatchLogGroupName() {
            return null;
        }

        /**
         * The name of the S3 bucket to send logs to.
         * <p>
         * <blockquote>
         * <p>
         * The S3 bucket must already be created.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-executecommandlogconfiguration.html#cfn-ecs-cluster-executecommandlogconfiguration-s3bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-executecommandlogconfiguration.html#cfn-ecs-cluster-executecommandlogconfiguration-s3bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BucketName() {
            return null;
        }

        /**
         * Determines whether to use encryption on the S3 logs.
         * <p>
         * If not specified, encryption is not used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-executecommandlogconfiguration.html#cfn-ecs-cluster-executecommandlogconfiguration-s3encryptionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-executecommandlogconfiguration.html#cfn-ecs-cluster-executecommandlogconfiguration-s3encryptionenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3EncryptionEnabled() {
            return null;
        }

        /**
         * An optional folder in the S3 bucket to place logs in.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-executecommandlogconfiguration.html#cfn-ecs-cluster-executecommandlogconfiguration-s3keyprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-executecommandlogconfiguration.html#cfn-ecs-cluster-executecommandlogconfiguration-s3keyprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3KeyPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExecuteCommandLogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExecuteCommandLogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExecuteCommandLogConfigurationProperty> {
            java.lang.Object cloudWatchEncryptionEnabled;
            java.lang.String cloudWatchLogGroupName;
            java.lang.String s3BucketName;
            java.lang.Object s3EncryptionEnabled;
            java.lang.String s3KeyPrefix;

            /**
             * Sets the value of {@link ExecuteCommandLogConfigurationProperty#getCloudWatchEncryptionEnabled}
             * @param cloudWatchEncryptionEnabled Determines whether to use encryption on the CloudWatch logs.
             *                                    If not specified, encryption will be off.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchEncryptionEnabled(java.lang.Boolean cloudWatchEncryptionEnabled) {
                this.cloudWatchEncryptionEnabled = cloudWatchEncryptionEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ExecuteCommandLogConfigurationProperty#getCloudWatchEncryptionEnabled}
             * @param cloudWatchEncryptionEnabled Determines whether to use encryption on the CloudWatch logs.
             *                                    If not specified, encryption will be off.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchEncryptionEnabled(software.amazon.awscdk.IResolvable cloudWatchEncryptionEnabled) {
                this.cloudWatchEncryptionEnabled = cloudWatchEncryptionEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ExecuteCommandLogConfigurationProperty#getCloudWatchLogGroupName}
             * @param cloudWatchLogGroupName The name of the CloudWatch log group to send logs to.
             *                               <blockquote>
             *                               <p>
             *                               The CloudWatch log group must already be created.
             *                               <p>
             *                               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogGroupName(java.lang.String cloudWatchLogGroupName) {
                this.cloudWatchLogGroupName = cloudWatchLogGroupName;
                return this;
            }

            /**
             * Sets the value of {@link ExecuteCommandLogConfigurationProperty#getS3BucketName}
             * @param s3BucketName The name of the S3 bucket to send logs to.
             *                     <blockquote>
             *                     <p>
             *                     The S3 bucket must already be created.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketName(java.lang.String s3BucketName) {
                this.s3BucketName = s3BucketName;
                return this;
            }

            /**
             * Sets the value of {@link ExecuteCommandLogConfigurationProperty#getS3EncryptionEnabled}
             * @param s3EncryptionEnabled Determines whether to use encryption on the S3 logs.
             *                            If not specified, encryption is not used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3EncryptionEnabled(java.lang.Boolean s3EncryptionEnabled) {
                this.s3EncryptionEnabled = s3EncryptionEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ExecuteCommandLogConfigurationProperty#getS3EncryptionEnabled}
             * @param s3EncryptionEnabled Determines whether to use encryption on the S3 logs.
             *                            If not specified, encryption is not used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3EncryptionEnabled(software.amazon.awscdk.IResolvable s3EncryptionEnabled) {
                this.s3EncryptionEnabled = s3EncryptionEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ExecuteCommandLogConfigurationProperty#getS3KeyPrefix}
             * @param s3KeyPrefix An optional folder in the S3 bucket to place logs in.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3KeyPrefix(java.lang.String s3KeyPrefix) {
                this.s3KeyPrefix = s3KeyPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExecuteCommandLogConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExecuteCommandLogConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExecuteCommandLogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExecuteCommandLogConfigurationProperty {
            private final java.lang.Object cloudWatchEncryptionEnabled;
            private final java.lang.String cloudWatchLogGroupName;
            private final java.lang.String s3BucketName;
            private final java.lang.Object s3EncryptionEnabled;
            private final java.lang.String s3KeyPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchEncryptionEnabled = software.amazon.jsii.Kernel.get(this, "cloudWatchEncryptionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudWatchLogGroupName = software.amazon.jsii.Kernel.get(this, "cloudWatchLogGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3BucketName = software.amazon.jsii.Kernel.get(this, "s3BucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3EncryptionEnabled = software.amazon.jsii.Kernel.get(this, "s3EncryptionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3KeyPrefix = software.amazon.jsii.Kernel.get(this, "s3KeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchEncryptionEnabled = builder.cloudWatchEncryptionEnabled;
                this.cloudWatchLogGroupName = builder.cloudWatchLogGroupName;
                this.s3BucketName = builder.s3BucketName;
                this.s3EncryptionEnabled = builder.s3EncryptionEnabled;
                this.s3KeyPrefix = builder.s3KeyPrefix;
            }

            @Override
            public final java.lang.Object getCloudWatchEncryptionEnabled() {
                return this.cloudWatchEncryptionEnabled;
            }

            @Override
            public final java.lang.String getCloudWatchLogGroupName() {
                return this.cloudWatchLogGroupName;
            }

            @Override
            public final java.lang.String getS3BucketName() {
                return this.s3BucketName;
            }

            @Override
            public final java.lang.Object getS3EncryptionEnabled() {
                return this.s3EncryptionEnabled;
            }

            @Override
            public final java.lang.String getS3KeyPrefix() {
                return this.s3KeyPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudWatchEncryptionEnabled() != null) {
                    data.set("cloudWatchEncryptionEnabled", om.valueToTree(this.getCloudWatchEncryptionEnabled()));
                }
                if (this.getCloudWatchLogGroupName() != null) {
                    data.set("cloudWatchLogGroupName", om.valueToTree(this.getCloudWatchLogGroupName()));
                }
                if (this.getS3BucketName() != null) {
                    data.set("s3BucketName", om.valueToTree(this.getS3BucketName()));
                }
                if (this.getS3EncryptionEnabled() != null) {
                    data.set("s3EncryptionEnabled", om.valueToTree(this.getS3EncryptionEnabled()));
                }
                if (this.getS3KeyPrefix() != null) {
                    data.set("s3KeyPrefix", om.valueToTree(this.getS3KeyPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCluster.ExecuteCommandLogConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExecuteCommandLogConfigurationProperty.Jsii$Proxy that = (ExecuteCommandLogConfigurationProperty.Jsii$Proxy) o;

                if (this.cloudWatchEncryptionEnabled != null ? !this.cloudWatchEncryptionEnabled.equals(that.cloudWatchEncryptionEnabled) : that.cloudWatchEncryptionEnabled != null) return false;
                if (this.cloudWatchLogGroupName != null ? !this.cloudWatchLogGroupName.equals(that.cloudWatchLogGroupName) : that.cloudWatchLogGroupName != null) return false;
                if (this.s3BucketName != null ? !this.s3BucketName.equals(that.s3BucketName) : that.s3BucketName != null) return false;
                if (this.s3EncryptionEnabled != null ? !this.s3EncryptionEnabled.equals(that.s3EncryptionEnabled) : that.s3EncryptionEnabled != null) return false;
                return this.s3KeyPrefix != null ? this.s3KeyPrefix.equals(that.s3KeyPrefix) : that.s3KeyPrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchEncryptionEnabled != null ? this.cloudWatchEncryptionEnabled.hashCode() : 0;
                result = 31 * result + (this.cloudWatchLogGroupName != null ? this.cloudWatchLogGroupName.hashCode() : 0);
                result = 31 * result + (this.s3BucketName != null ? this.s3BucketName.hashCode() : 0);
                result = 31 * result + (this.s3EncryptionEnabled != null ? this.s3EncryptionEnabled.hashCode() : 0);
                result = 31 * result + (this.s3KeyPrefix != null ? this.s3KeyPrefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The managed storage configuration for the cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ManagedStorageConfigurationProperty managedStorageConfigurationProperty = ManagedStorageConfigurationProperty.builder()
     *         .fargateEphemeralStorageKmsKeyId("fargateEphemeralStorageKmsKeyId")
     *         .kmsKeyId("kmsKeyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-managedstorageconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-managedstorageconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCluster.ManagedStorageConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ManagedStorageConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManagedStorageConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specify the AWS Key Management Service key ID for the Fargate ephemeral storage.
         * <p>
         * The key must be a single Region key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-managedstorageconfiguration.html#cfn-ecs-cluster-managedstorageconfiguration-fargateephemeralstoragekmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-managedstorageconfiguration.html#cfn-ecs-cluster-managedstorageconfiguration-fargateephemeralstoragekmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFargateEphemeralStorageKmsKeyId() {
            return null;
        }

        /**
         * Specify a AWS Key Management Service key ID to encrypt the managed storage.
         * <p>
         * The key must be a single Region key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-managedstorageconfiguration.html#cfn-ecs-cluster-managedstorageconfiguration-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-managedstorageconfiguration.html#cfn-ecs-cluster-managedstorageconfiguration-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ManagedStorageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManagedStorageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManagedStorageConfigurationProperty> {
            java.lang.String fargateEphemeralStorageKmsKeyId;
            java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link ManagedStorageConfigurationProperty#getFargateEphemeralStorageKmsKeyId}
             * @param fargateEphemeralStorageKmsKeyId Specify the AWS Key Management Service key ID for the Fargate ephemeral storage.
             *                                        The key must be a single Region key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fargateEphemeralStorageKmsKeyId(java.lang.String fargateEphemeralStorageKmsKeyId) {
                this.fargateEphemeralStorageKmsKeyId = fargateEphemeralStorageKmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link ManagedStorageConfigurationProperty#getKmsKeyId}
             * @param kmsKeyId Specify a AWS Key Management Service key ID to encrypt the managed storage.
             *                 The key must be a single Region key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManagedStorageConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManagedStorageConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManagedStorageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedStorageConfigurationProperty {
            private final java.lang.String fargateEphemeralStorageKmsKeyId;
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fargateEphemeralStorageKmsKeyId = software.amazon.jsii.Kernel.get(this, "fargateEphemeralStorageKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fargateEphemeralStorageKmsKeyId = builder.fargateEphemeralStorageKmsKeyId;
                this.kmsKeyId = builder.kmsKeyId;
            }

            @Override
            public final java.lang.String getFargateEphemeralStorageKmsKeyId() {
                return this.fargateEphemeralStorageKmsKeyId;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFargateEphemeralStorageKmsKeyId() != null) {
                    data.set("fargateEphemeralStorageKmsKeyId", om.valueToTree(this.getFargateEphemeralStorageKmsKeyId()));
                }
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCluster.ManagedStorageConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManagedStorageConfigurationProperty.Jsii$Proxy that = (ManagedStorageConfigurationProperty.Jsii$Proxy) o;

                if (this.fargateEphemeralStorageKmsKeyId != null ? !this.fargateEphemeralStorageKmsKeyId.equals(that.fargateEphemeralStorageKmsKeyId) : that.fargateEphemeralStorageKmsKeyId != null) return false;
                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fargateEphemeralStorageKmsKeyId != null ? this.fargateEphemeralStorageKmsKeyId.hashCode() : 0;
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Use this parameter to set a default Service Connect namespace.
     * <p>
     * After you set a default Service Connect namespace, any new services with Service Connect turned on that are created in the cluster are added as client services in the namespace. This setting only applies to new services that set the <code>enabled</code> parameter to <code>true</code> in the <code>ServiceConnectConfiguration</code> . You can set the namespace of each service individually in the <code>ServiceConnectConfiguration</code> to override this default parameter.
     * <p>
     * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ServiceConnectDefaultsProperty serviceConnectDefaultsProperty = ServiceConnectDefaultsProperty.builder()
     *         .namespace("namespace")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-serviceconnectdefaults.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-serviceconnectdefaults.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCluster.ServiceConnectDefaultsProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceConnectDefaultsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceConnectDefaultsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The namespace name or full Amazon Resource Name (ARN) of the AWS Cloud Map namespace that's used when you create a service and don't specify a Service Connect configuration.
         * <p>
         * The namespace name can include up to 1024 characters. The name is case-sensitive. The name can't include greater than (&gt;), less than (&lt;), double quotation marks ("), or slash (/).
         * <p>
         * If you enter an existing namespace name or ARN, then that namespace will be used. Any namespace type is supported. The namespace must be in this account and this AWS Region.
         * <p>
         * If you enter a new name, a AWS Cloud Map namespace will be created. Amazon ECS creates a AWS Cloud Map namespace with the "API calls" method of instance discovery only. This instance discovery method is the "HTTP" namespace type in the AWS Command Line Interface . Other types of instance discovery aren't used by Service Connect.
         * <p>
         * If you update the cluster with an empty string <code>""</code> for the namespace name, the cluster configuration for Service Connect is removed. Note that the namespace will remain in AWS Cloud Map and must be deleted separately.
         * <p>
         * For more information about AWS Cloud Map , see <a href="https://docs.aws.amazon.com/cloud-map/latest/dg/working-with-services.html">Working with Services</a> in the <em>AWS Cloud Map Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-serviceconnectdefaults.html#cfn-ecs-cluster-serviceconnectdefaults-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-serviceconnectdefaults.html#cfn-ecs-cluster-serviceconnectdefaults-namespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServiceConnectDefaultsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceConnectDefaultsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceConnectDefaultsProperty> {
            java.lang.String namespace;

            /**
             * Sets the value of {@link ServiceConnectDefaultsProperty#getNamespace}
             * @param namespace The namespace name or full Amazon Resource Name (ARN) of the AWS Cloud Map namespace that's used when you create a service and don't specify a Service Connect configuration.
             *                  The namespace name can include up to 1024 characters. The name is case-sensitive. The name can't include greater than (&gt;), less than (&lt;), double quotation marks ("), or slash (/).
             *                  <p>
             *                  If you enter an existing namespace name or ARN, then that namespace will be used. Any namespace type is supported. The namespace must be in this account and this AWS Region.
             *                  <p>
             *                  If you enter a new name, a AWS Cloud Map namespace will be created. Amazon ECS creates a AWS Cloud Map namespace with the "API calls" method of instance discovery only. This instance discovery method is the "HTTP" namespace type in the AWS Command Line Interface . Other types of instance discovery aren't used by Service Connect.
             *                  <p>
             *                  If you update the cluster with an empty string <code>""</code> for the namespace name, the cluster configuration for Service Connect is removed. Note that the namespace will remain in AWS Cloud Map and must be deleted separately.
             *                  <p>
             *                  For more information about AWS Cloud Map , see <a href="https://docs.aws.amazon.com/cloud-map/latest/dg/working-with-services.html">Working with Services</a> in the <em>AWS Cloud Map Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceConnectDefaultsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceConnectDefaultsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceConnectDefaultsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceConnectDefaultsProperty {
            private final java.lang.String namespace;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.namespace = builder.namespace;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNamespace() != null) {
                    data.set("namespace", om.valueToTree(this.getNamespace()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCluster.ServiceConnectDefaultsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceConnectDefaultsProperty.Jsii$Proxy that = (ServiceConnectDefaultsProperty.Jsii$Proxy) o;

                return this.namespace != null ? this.namespace.equals(that.namespace) : that.namespace == null;
            }

            @Override
            public final int hashCode() {
                int result = this.namespace != null ? this.namespace.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.CfnCluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.CfnCluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ecs.CfnClusterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The short name of one or more capacity providers to associate with the cluster.
         * <p>
         * A capacity provider must be associated with a cluster before it can be included as part of the default capacity provider strategy of the cluster or used in a capacity provider strategy when calling the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html">CreateService</a> or <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html">RunTask</a> actions.
         * <p>
         * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must be created but not associated with another cluster. New Auto Scaling group capacity providers can be created with the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateCapacityProvider.html">CreateCapacityProvider</a> API operation.
         * <p>
         * To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.
         * <p>
         * The <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutCapacityProvider.html">PutCapacityProvider</a> API operation is used to update the list of available capacity providers for a cluster after the cluster is created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-capacityproviders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-capacityproviders</a>
         * @param capacityProviders The short name of one or more capacity providers to associate with the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviders(final java.util.List<java.lang.String> capacityProviders) {
            this.props().capacityProviders(capacityProviders);
            return this;
        }

        /**
         * A user-generated string that you use to identify your cluster.
         * <p>
         * If you don't specify a name, AWS CloudFormation generates a unique physical ID for the name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-clustername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-clustername</a>
         * @param clusterName A user-generated string that you use to identify your cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(final java.lang.String clusterName) {
            this.props().clusterName(clusterName);
            return this;
        }

        /**
         * The settings to use when creating a cluster.
         * <p>
         * This parameter is used to turn on CloudWatch Container Insights with enhanced observability or CloudWatch Container Insights for a cluster.
         * <p>
         * Container Insights with enhanced observability provides all the Container Insights metrics, plus additional task and container metrics. This version supports enhanced observability for Amazon ECS clusters using the Amazon EC2 and Fargate launch types. After you configure Container Insights with enhanced observability on Amazon ECS, Container Insights auto-collects detailed infrastructure telemetry from the cluster level down to the container level in your environment and displays these critical performance data in curated dashboards removing the heavy lifting in observability set-up.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cloudwatch-container-insights.html">Monitor Amazon ECS containers using Container Insights with enhanced observability</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-clustersettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-clustersettings</a>
         * @param clusterSettings The settings to use when creating a cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterSettings(final software.amazon.awscdk.IResolvable clusterSettings) {
            this.props().clusterSettings(clusterSettings);
            return this;
        }
        /**
         * The settings to use when creating a cluster.
         * <p>
         * This parameter is used to turn on CloudWatch Container Insights with enhanced observability or CloudWatch Container Insights for a cluster.
         * <p>
         * Container Insights with enhanced observability provides all the Container Insights metrics, plus additional task and container metrics. This version supports enhanced observability for Amazon ECS clusters using the Amazon EC2 and Fargate launch types. After you configure Container Insights with enhanced observability on Amazon ECS, Container Insights auto-collects detailed infrastructure telemetry from the cluster level down to the container level in your environment and displays these critical performance data in curated dashboards removing the heavy lifting in observability set-up.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cloudwatch-container-insights.html">Monitor Amazon ECS containers using Container Insights with enhanced observability</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-clustersettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-clustersettings</a>
         * @param clusterSettings The settings to use when creating a cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterSettings(final java.util.List<? extends java.lang.Object> clusterSettings) {
            this.props().clusterSettings(clusterSettings);
            return this;
        }

        /**
         * The execute command and managed storage configuration for the cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-configuration</a>
         * @param configuration The execute command and managed storage configuration for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.IResolvable configuration) {
            this.props().configuration(configuration);
            return this;
        }
        /**
         * The execute command and managed storage configuration for the cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-configuration</a>
         * @param configuration The execute command and managed storage configuration for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.services.ecs.CfnCluster.ClusterConfigurationProperty configuration) {
            this.props().configuration(configuration);
            return this;
        }

        /**
         * The default capacity provider strategy for the cluster.
         * <p>
         * When services or tasks are run in the cluster with no launch type or capacity provider strategy specified, the default capacity provider strategy is used.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-defaultcapacityproviderstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-defaultcapacityproviderstrategy</a>
         * @param defaultCapacityProviderStrategy The default capacity provider strategy for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCapacityProviderStrategy(final software.amazon.awscdk.IResolvable defaultCapacityProviderStrategy) {
            this.props().defaultCapacityProviderStrategy(defaultCapacityProviderStrategy);
            return this;
        }
        /**
         * The default capacity provider strategy for the cluster.
         * <p>
         * When services or tasks are run in the cluster with no launch type or capacity provider strategy specified, the default capacity provider strategy is used.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-defaultcapacityproviderstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-defaultcapacityproviderstrategy</a>
         * @param defaultCapacityProviderStrategy The default capacity provider strategy for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCapacityProviderStrategy(final java.util.List<? extends java.lang.Object> defaultCapacityProviderStrategy) {
            this.props().defaultCapacityProviderStrategy(defaultCapacityProviderStrategy);
            return this;
        }

        /**
         * Use this parameter to set a default Service Connect namespace.
         * <p>
         * After you set a default Service Connect namespace, any new services with Service Connect turned on that are created in the cluster are added as client services in the namespace. This setting only applies to new services that set the <code>enabled</code> parameter to <code>true</code> in the <code>ServiceConnectConfiguration</code> . You can set the namespace of each service individually in the <code>ServiceConnectConfiguration</code> to override this default parameter.
         * <p>
         * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-serviceconnectdefaults">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-serviceconnectdefaults</a>
         * @param serviceConnectDefaults Use this parameter to set a default Service Connect namespace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceConnectDefaults(final software.amazon.awscdk.IResolvable serviceConnectDefaults) {
            this.props().serviceConnectDefaults(serviceConnectDefaults);
            return this;
        }
        /**
         * Use this parameter to set a default Service Connect namespace.
         * <p>
         * After you set a default Service Connect namespace, any new services with Service Connect turned on that are created in the cluster are added as client services in the namespace. This setting only applies to new services that set the <code>enabled</code> parameter to <code>true</code> in the <code>ServiceConnectConfiguration</code> . You can set the namespace of each service individually in the <code>ServiceConnectConfiguration</code> to override this default parameter.
         * <p>
         * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-serviceconnectdefaults">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-serviceconnectdefaults</a>
         * @param serviceConnectDefaults Use this parameter to set a default Service Connect namespace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceConnectDefaults(final software.amazon.awscdk.services.ecs.CfnCluster.ServiceConnectDefaultsProperty serviceConnectDefaults) {
            this.props().serviceConnectDefaults(serviceConnectDefaults);
            return this;
        }

        /**
         * The metadata that you apply to the cluster to help you categorize and organize them.
         * <p>
         * Each tag consists of a key and an optional value. You define both.
         * <p>
         * The following basic restrictions apply to tags:
         * <p>
         * <ul>
         * <li>Maximum number of tags per resource - 50</li>
         * <li>For each resource, each tag key must be unique, and each tag key can have only one value.</li>
         * <li>Maximum key length - 128 Unicode characters in UTF-8</li>
         * <li>Maximum value length - 256 Unicode characters in UTF-8</li>
         * <li>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : /</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-tags</a>
         * @param tags The metadata that you apply to the cluster to help you categorize and organize them. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.CfnCluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.CfnCluster build() {
            return new software.amazon.awscdk.services.ecs.CfnCluster(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecs.CfnClusterProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecs.CfnClusterProps.Builder();
            }
            return this.props;
        }
    }
}
