package software.amazon.awscdk.services.ecs;

/**
 * A container instance host device.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * Device device = Device.builder()
 *         .hostPath("hostPath")
 *         // the properties below are optional
 *         .containerPath("containerPath")
 *         .permissions(List.of(DevicePermission.READ))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:23.833Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.Device")
@software.amazon.jsii.Jsii.Proxy(Device.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Device extends software.amazon.jsii.JsiiSerializable {

    /**
     * The path for the device on the host container instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHostPath();

    /**
     * The path inside the container at which to expose the host device.
     * <p>
     * Default: Same path as the host
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContainerPath() {
        return null;
    }

    /**
     * The explicit permissions to provide to the container for the device.
     * <p>
     * By default, the container has permissions for read, write, and mknod for the device.
     * <p>
     * Default: Readonly
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecs.DevicePermission> getPermissions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Device}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Device}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<Device> {
        java.lang.String hostPath;
        java.lang.String containerPath;
        java.util.List<software.amazon.awscdk.services.ecs.DevicePermission> permissions;

        /**
         * Sets the value of {@link Device#getHostPath}
         * @param hostPath The path for the device on the host container instance. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostPath(java.lang.String hostPath) {
            this.hostPath = hostPath;
            return this;
        }

        /**
         * Sets the value of {@link Device#getContainerPath}
         * @param containerPath The path inside the container at which to expose the host device.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerPath(java.lang.String containerPath) {
            this.containerPath = containerPath;
            return this;
        }

        /**
         * Sets the value of {@link Device#getPermissions}
         * @param permissions The explicit permissions to provide to the container for the device.
         *                    By default, the container has permissions for read, write, and mknod for the device.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder permissions(java.util.List<? extends software.amazon.awscdk.services.ecs.DevicePermission> permissions) {
            this.permissions = (java.util.List<software.amazon.awscdk.services.ecs.DevicePermission>)permissions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Device}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public Device build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Device}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Device {
        private final java.lang.String hostPath;
        private final java.lang.String containerPath;
        private final java.util.List<software.amazon.awscdk.services.ecs.DevicePermission> permissions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hostPath = software.amazon.jsii.Kernel.get(this, "hostPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.containerPath = software.amazon.jsii.Kernel.get(this, "containerPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.permissions = software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.DevicePermission.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hostPath = java.util.Objects.requireNonNull(builder.hostPath, "hostPath is required");
            this.containerPath = builder.containerPath;
            this.permissions = (java.util.List<software.amazon.awscdk.services.ecs.DevicePermission>)builder.permissions;
        }

        @Override
        public final java.lang.String getHostPath() {
            return this.hostPath;
        }

        @Override
        public final java.lang.String getContainerPath() {
            return this.containerPath;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.DevicePermission> getPermissions() {
            return this.permissions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("hostPath", om.valueToTree(this.getHostPath()));
            if (this.getContainerPath() != null) {
                data.set("containerPath", om.valueToTree(this.getContainerPath()));
            }
            if (this.getPermissions() != null) {
                data.set("permissions", om.valueToTree(this.getPermissions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.Device"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Device.Jsii$Proxy that = (Device.Jsii$Proxy) o;

            if (!hostPath.equals(that.hostPath)) return false;
            if (this.containerPath != null ? !this.containerPath.equals(that.containerPath) : that.containerPath != null) return false;
            return this.permissions != null ? this.permissions.equals(that.permissions) : that.permissions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.hostPath.hashCode();
            result = 31 * result + (this.containerPath != null ? this.containerPath.hashCode() : 0);
            result = 31 * result + (this.permissions != null ? this.permissions.hashCode() : 0);
            return result;
        }
    }
}
