package software.amazon.awscdk.services.ecs;

/**
 * The networking mode to use for the containers in the task.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Ec2TaskDefinition ec2TaskDefinition = Ec2TaskDefinition.Builder.create(this, "TaskDef")
 *         .networkMode(NetworkMode.BRIDGE)
 *         .build();
 * ContainerDefinition container = ec2TaskDefinition.addContainer("WebContainer", ContainerDefinitionOptions.builder()
 *         // Use an image from DockerHub
 *         .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *         .memoryLimitMiB(1024)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:23.913Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.NetworkMode")
public enum NetworkMode {
    /**
     * The task's containers do not have external connectivity and port mappings can't be specified in the container definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NONE,
    /**
     * The task utilizes Docker's built-in virtual network which runs inside each container instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BRIDGE,
    /**
     * The task is allocated an elastic network interface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AWS_VPC,
    /**
     * The task bypasses Docker's built-in virtual network and maps container ports directly to the EC2 instance's network interface directly.
     * <p>
     * In this mode, you can't run multiple instantiations of the same task on a
     * single container instance when port mappings are used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HOST,
    /**
     * The task utilizes NAT network mode required by Windows containers.
     * <p>
     * This is the only supported network mode for Windows containers. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#network_mode">Task Definition Parameters</a>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NAT,
}
