package software.amazon.awscdk.services.ecs.patterns;

/**
 * The base class for ApplicationLoadBalancedEc2Service and ApplicationLoadBalancedFargateService services.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:23.994Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs_patterns.ApplicationLoadBalancedServiceBase")
public abstract class ApplicationLoadBalancedServiceBase extends software.constructs.Construct {

    protected ApplicationLoadBalancedServiceBase(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApplicationLoadBalancedServiceBase(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the ApplicationLoadBalancedServiceBase class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected ApplicationLoadBalancedServiceBase(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedServiceBaseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Constructs a new instance of the ApplicationLoadBalancedServiceBase class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected ApplicationLoadBalancedServiceBase(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Adds service as a target of the target group.
     * <p>
     * @param service This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void addServiceAsTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.BaseService service) {
        software.amazon.jsii.Kernel.call(this, "addServiceAsTarget", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(service, "service is required") });
    }

    /**
     * @param prefix This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.AwsLogDriver createAWSLogDriver(final @org.jetbrains.annotations.NotNull java.lang.String prefix) {
        return software.amazon.jsii.Kernel.call(this, "createAWSLogDriver", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.AwsLogDriver.class), new Object[] { java.util.Objects.requireNonNull(prefix, "prefix is required") });
    }

    /**
     * Returns the default cluster.
     * <p>
     * @param scope This parameter is required.
     * @param vpc
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Cluster getDefaultCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc vpc) {
        return software.amazon.jsii.Kernel.call(this, "getDefaultCluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Cluster.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), vpc });
    }

    /**
     * Returns the default cluster.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Cluster getDefaultCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
        return software.amazon.jsii.Kernel.call(this, "getDefaultCluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Cluster.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * The cluster that hosts the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ICluster getCluster() {
        return software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ICluster.class));
    }

    /**
     * The listener for the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener getListener() {
        return software.amazon.jsii.Kernel.get(this, "listener", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener.class));
    }

    /**
     * The Application Load Balancer for the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer getLoadBalancer() {
        return software.amazon.jsii.Kernel.get(this, "loadBalancer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer.class));
    }

    /**
     * The target group for the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup getTargetGroup() {
        return software.amazon.jsii.Kernel.get(this, "targetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup.class));
    }

    /**
     * Certificate Manager certificate to associate with the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
        return software.amazon.jsii.Kernel.get(this, "certificate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.ICertificate.class));
    }

    /**
     * The desired number of instantiations of the task definition to keep running on the service.
     * <p>
     * The default is 1 for all new services and uses the existing services desired count
     * when updating an existing service if one is not provided.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getInternalDesiredCount() {
        return software.amazon.jsii.Kernel.get(this, "internalDesiredCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The redirect listener for the service if redirectHTTP is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener getRedirectListener() {
        return software.amazon.jsii.Kernel.get(this, "redirectListener", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedServiceBase implements software.constructs.IConstruct.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
