package software.amazon.awscdk.services.elasticache;

/**
 * Properties for defining a <code>CfnServerlessCache</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticache.*;
 * CfnServerlessCacheProps cfnServerlessCacheProps = CfnServerlessCacheProps.builder()
 *         .engine("engine")
 *         .serverlessCacheName("serverlessCacheName")
 *         // the properties below are optional
 *         .cacheUsageLimits(CacheUsageLimitsProperty.builder()
 *                 .dataStorage(DataStorageProperty.builder()
 *                         .unit("unit")
 *                         // the properties below are optional
 *                         .maximum(123)
 *                         .minimum(123)
 *                         .build())
 *                 .ecpuPerSecond(ECPUPerSecondProperty.builder()
 *                         .maximum(123)
 *                         .minimum(123)
 *                         .build())
 *                 .build())
 *         .dailySnapshotTime("dailySnapshotTime")
 *         .description("description")
 *         .endpoint(EndpointProperty.builder()
 *                 .address("address")
 *                 .port("port")
 *                 .build())
 *         .finalSnapshotName("finalSnapshotName")
 *         .kmsKeyId("kmsKeyId")
 *         .majorEngineVersion("majorEngineVersion")
 *         .readerEndpoint(EndpointProperty.builder()
 *                 .address("address")
 *                 .port("port")
 *                 .build())
 *         .securityGroupIds(List.of("securityGroupIds"))
 *         .snapshotArnsToRestore(List.of("snapshotArnsToRestore"))
 *         .snapshotRetentionLimit(123)
 *         .subnetIds(List.of("subnetIds"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .userGroupId("userGroupId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:24.341Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnServerlessCacheProps")
@software.amazon.jsii.Jsii.Proxy(CfnServerlessCacheProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnServerlessCacheProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The engine the serverless cache is compatible with.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-engine">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-engine</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEngine();

    /**
     * The unique identifier of the serverless cache.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-serverlesscachename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-serverlesscachename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServerlessCacheName();

    /**
     * The cache usage limit for the serverless cache.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-cacheusagelimits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-cacheusagelimits</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCacheUsageLimits() {
        return null;
    }

    /**
     * The daily time that a cache snapshot will be created.
     * <p>
     * Default is NULL, i.e. snapshots will not be created at a specific time on a daily basis. Available for Valkey, Redis OSS and Serverless Memcached only.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-dailysnapshottime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-dailysnapshottime</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDailySnapshotTime() {
        return null;
    }

    /**
     * A description of the serverless cache.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Represents the information required for client programs to connect to a cache node.
     * <p>
     * This value is read-only.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-endpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-endpoint</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEndpoint() {
        return null;
    }

    /**
     * The name of the final snapshot taken of a cache before the cache is deleted.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-finalsnapshotname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-finalsnapshotname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFinalSnapshotName() {
        return null;
    }

    /**
     * The ID of the AWS Key Management Service (KMS) key that is used to encrypt data at rest in the serverless cache.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * The version number of the engine the serverless cache is compatible with.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-majorengineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-majorengineversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMajorEngineVersion() {
        return null;
    }

    /**
     * Represents the information required for client programs to connect to a cache node.
     * <p>
     * This value is read-only.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-readerendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-readerendpoint</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getReaderEndpoint() {
        return null;
    }

    /**
     * The IDs of the EC2 security groups associated with the serverless cache.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-securitygroupids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return null;
    }

    /**
     * The ARN of the snapshot from which to restore data into the new cache.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-snapshotarnstorestore">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-snapshotarnstorestore</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSnapshotArnsToRestore() {
        return null;
    }

    /**
     * The current setting for the number of serverless cache snapshots the system will retain.
     * <p>
     * Available for Valkey, Redis OSS and Serverless Memcached only.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-snapshotretentionlimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-snapshotretentionlimit</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSnapshotRetentionLimit() {
        return null;
    }

    /**
     * If no subnet IDs are given and your VPC is in us-west-1, then ElastiCache will select 2 default subnets across AZs in your VPC.
     * <p>
     * For all other Regions, if no subnet IDs are given then ElastiCache will select 3 default subnets across AZs in your default VPC.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-subnetids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnetIds() {
        return null;
    }

    /**
     * A list of tags to be added to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The identifier of the user group associated with the serverless cache.
     * <p>
     * Available for Valkey and Redis OSS only. Default is NULL.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-usergroupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-usergroupid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUserGroupId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnServerlessCacheProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnServerlessCacheProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnServerlessCacheProps> {
        java.lang.String engine;
        java.lang.String serverlessCacheName;
        java.lang.Object cacheUsageLimits;
        java.lang.String dailySnapshotTime;
        java.lang.String description;
        java.lang.Object endpoint;
        java.lang.String finalSnapshotName;
        java.lang.String kmsKeyId;
        java.lang.String majorEngineVersion;
        java.lang.Object readerEndpoint;
        java.util.List<java.lang.String> securityGroupIds;
        java.util.List<java.lang.String> snapshotArnsToRestore;
        java.lang.Number snapshotRetentionLimit;
        java.util.List<java.lang.String> subnetIds;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String userGroupId;

        /**
         * Sets the value of {@link CfnServerlessCacheProps#getEngine}
         * @param engine The engine the serverless cache is compatible with. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(java.lang.String engine) {
            this.engine = engine;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerlessCacheProps#getServerlessCacheName}
         * @param serverlessCacheName The unique identifier of the serverless cache. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverlessCacheName(java.lang.String serverlessCacheName) {
            this.serverlessCacheName = serverlessCacheName;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerlessCacheProps#getCacheUsageLimits}
         * @param cacheUsageLimits The cache usage limit for the serverless cache.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheUsageLimits(software.amazon.awscdk.IResolvable cacheUsageLimits) {
            this.cacheUsageLimits = cacheUsageLimits;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerlessCacheProps#getCacheUsageLimits}
         * @param cacheUsageLimits The cache usage limit for the serverless cache.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheUsageLimits(software.amazon.awscdk.services.elasticache.CfnServerlessCache.CacheUsageLimitsProperty cacheUsageLimits) {
            this.cacheUsageLimits = cacheUsageLimits;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerlessCacheProps#getDailySnapshotTime}
         * @param dailySnapshotTime The daily time that a cache snapshot will be created.
         *                          Default is NULL, i.e. snapshots will not be created at a specific time on a daily basis. Available for Valkey, Redis OSS and Serverless Memcached only.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dailySnapshotTime(java.lang.String dailySnapshotTime) {
            this.dailySnapshotTime = dailySnapshotTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerlessCacheProps#getDescription}
         * @param description A description of the serverless cache.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerlessCacheProps#getEndpoint}
         * @param endpoint Represents the information required for client programs to connect to a cache node.
         *                 This value is read-only.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(software.amazon.awscdk.IResolvable endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerlessCacheProps#getEndpoint}
         * @param endpoint Represents the information required for client programs to connect to a cache node.
         *                 This value is read-only.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(software.amazon.awscdk.services.elasticache.CfnServerlessCache.EndpointProperty endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerlessCacheProps#getFinalSnapshotName}
         * @param finalSnapshotName The name of the final snapshot taken of a cache before the cache is deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder finalSnapshotName(java.lang.String finalSnapshotName) {
            this.finalSnapshotName = finalSnapshotName;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerlessCacheProps#getKmsKeyId}
         * @param kmsKeyId The ID of the AWS Key Management Service (KMS) key that is used to encrypt data at rest in the serverless cache.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerlessCacheProps#getMajorEngineVersion}
         * @param majorEngineVersion The version number of the engine the serverless cache is compatible with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder majorEngineVersion(java.lang.String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerlessCacheProps#getReaderEndpoint}
         * @param readerEndpoint Represents the information required for client programs to connect to a cache node.
         *                       This value is read-only.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readerEndpoint(software.amazon.awscdk.IResolvable readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerlessCacheProps#getReaderEndpoint}
         * @param readerEndpoint Represents the information required for client programs to connect to a cache node.
         *                       This value is read-only.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readerEndpoint(software.amazon.awscdk.services.elasticache.CfnServerlessCache.EndpointProperty readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerlessCacheProps#getSecurityGroupIds}
         * @param securityGroupIds The IDs of the EC2 security groups associated with the serverless cache.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerlessCacheProps#getSnapshotArnsToRestore}
         * @param snapshotArnsToRestore The ARN of the snapshot from which to restore data into the new cache.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotArnsToRestore(java.util.List<java.lang.String> snapshotArnsToRestore) {
            this.snapshotArnsToRestore = snapshotArnsToRestore;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerlessCacheProps#getSnapshotRetentionLimit}
         * @param snapshotRetentionLimit The current setting for the number of serverless cache snapshots the system will retain.
         *                               Available for Valkey, Redis OSS and Serverless Memcached only.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotRetentionLimit(java.lang.Number snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerlessCacheProps#getSubnetIds}
         * @param subnetIds If no subnet IDs are given and your VPC is in us-west-1, then ElastiCache will select 2 default subnets across AZs in your VPC.
         *                  For all other Regions, if no subnet IDs are given then ElastiCache will select 3 default subnets across AZs in your default VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
            this.subnetIds = subnetIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerlessCacheProps#getTags}
         * @param tags A list of tags to be added to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerlessCacheProps#getUserGroupId}
         * @param userGroupId The identifier of the user group associated with the serverless cache.
         *                    Available for Valkey and Redis OSS only. Default is NULL.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userGroupId(java.lang.String userGroupId) {
            this.userGroupId = userGroupId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnServerlessCacheProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnServerlessCacheProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnServerlessCacheProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnServerlessCacheProps {
        private final java.lang.String engine;
        private final java.lang.String serverlessCacheName;
        private final java.lang.Object cacheUsageLimits;
        private final java.lang.String dailySnapshotTime;
        private final java.lang.String description;
        private final java.lang.Object endpoint;
        private final java.lang.String finalSnapshotName;
        private final java.lang.String kmsKeyId;
        private final java.lang.String majorEngineVersion;
        private final java.lang.Object readerEndpoint;
        private final java.util.List<java.lang.String> securityGroupIds;
        private final java.util.List<java.lang.String> snapshotArnsToRestore;
        private final java.lang.Number snapshotRetentionLimit;
        private final java.util.List<java.lang.String> subnetIds;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String userGroupId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.engine = software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serverlessCacheName = software.amazon.jsii.Kernel.get(this, "serverlessCacheName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cacheUsageLimits = software.amazon.jsii.Kernel.get(this, "cacheUsageLimits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dailySnapshotTime = software.amazon.jsii.Kernel.get(this, "dailySnapshotTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.finalSnapshotName = software.amazon.jsii.Kernel.get(this, "finalSnapshotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.majorEngineVersion = software.amazon.jsii.Kernel.get(this, "majorEngineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.readerEndpoint = software.amazon.jsii.Kernel.get(this, "readerEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.snapshotArnsToRestore = software.amazon.jsii.Kernel.get(this, "snapshotArnsToRestore", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.snapshotRetentionLimit = software.amazon.jsii.Kernel.get(this, "snapshotRetentionLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.userGroupId = software.amazon.jsii.Kernel.get(this, "userGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.engine = java.util.Objects.requireNonNull(builder.engine, "engine is required");
            this.serverlessCacheName = java.util.Objects.requireNonNull(builder.serverlessCacheName, "serverlessCacheName is required");
            this.cacheUsageLimits = builder.cacheUsageLimits;
            this.dailySnapshotTime = builder.dailySnapshotTime;
            this.description = builder.description;
            this.endpoint = builder.endpoint;
            this.finalSnapshotName = builder.finalSnapshotName;
            this.kmsKeyId = builder.kmsKeyId;
            this.majorEngineVersion = builder.majorEngineVersion;
            this.readerEndpoint = builder.readerEndpoint;
            this.securityGroupIds = builder.securityGroupIds;
            this.snapshotArnsToRestore = builder.snapshotArnsToRestore;
            this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
            this.subnetIds = builder.subnetIds;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.userGroupId = builder.userGroupId;
        }

        @Override
        public final java.lang.String getEngine() {
            return this.engine;
        }

        @Override
        public final java.lang.String getServerlessCacheName() {
            return this.serverlessCacheName;
        }

        @Override
        public final java.lang.Object getCacheUsageLimits() {
            return this.cacheUsageLimits;
        }

        @Override
        public final java.lang.String getDailySnapshotTime() {
            return this.dailySnapshotTime;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final java.lang.String getFinalSnapshotName() {
            return this.finalSnapshotName;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.String getMajorEngineVersion() {
            return this.majorEngineVersion;
        }

        @Override
        public final java.lang.Object getReaderEndpoint() {
            return this.readerEndpoint;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final java.util.List<java.lang.String> getSnapshotArnsToRestore() {
            return this.snapshotArnsToRestore;
        }

        @Override
        public final java.lang.Number getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        @Override
        public final java.util.List<java.lang.String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getUserGroupId() {
            return this.userGroupId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("engine", om.valueToTree(this.getEngine()));
            data.set("serverlessCacheName", om.valueToTree(this.getServerlessCacheName()));
            if (this.getCacheUsageLimits() != null) {
                data.set("cacheUsageLimits", om.valueToTree(this.getCacheUsageLimits()));
            }
            if (this.getDailySnapshotTime() != null) {
                data.set("dailySnapshotTime", om.valueToTree(this.getDailySnapshotTime()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEndpoint() != null) {
                data.set("endpoint", om.valueToTree(this.getEndpoint()));
            }
            if (this.getFinalSnapshotName() != null) {
                data.set("finalSnapshotName", om.valueToTree(this.getFinalSnapshotName()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getMajorEngineVersion() != null) {
                data.set("majorEngineVersion", om.valueToTree(this.getMajorEngineVersion()));
            }
            if (this.getReaderEndpoint() != null) {
                data.set("readerEndpoint", om.valueToTree(this.getReaderEndpoint()));
            }
            if (this.getSecurityGroupIds() != null) {
                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
            }
            if (this.getSnapshotArnsToRestore() != null) {
                data.set("snapshotArnsToRestore", om.valueToTree(this.getSnapshotArnsToRestore()));
            }
            if (this.getSnapshotRetentionLimit() != null) {
                data.set("snapshotRetentionLimit", om.valueToTree(this.getSnapshotRetentionLimit()));
            }
            if (this.getSubnetIds() != null) {
                data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUserGroupId() != null) {
                data.set("userGroupId", om.valueToTree(this.getUserGroupId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticache.CfnServerlessCacheProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnServerlessCacheProps.Jsii$Proxy that = (CfnServerlessCacheProps.Jsii$Proxy) o;

            if (!engine.equals(that.engine)) return false;
            if (!serverlessCacheName.equals(that.serverlessCacheName)) return false;
            if (this.cacheUsageLimits != null ? !this.cacheUsageLimits.equals(that.cacheUsageLimits) : that.cacheUsageLimits != null) return false;
            if (this.dailySnapshotTime != null ? !this.dailySnapshotTime.equals(that.dailySnapshotTime) : that.dailySnapshotTime != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.endpoint != null ? !this.endpoint.equals(that.endpoint) : that.endpoint != null) return false;
            if (this.finalSnapshotName != null ? !this.finalSnapshotName.equals(that.finalSnapshotName) : that.finalSnapshotName != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.majorEngineVersion != null ? !this.majorEngineVersion.equals(that.majorEngineVersion) : that.majorEngineVersion != null) return false;
            if (this.readerEndpoint != null ? !this.readerEndpoint.equals(that.readerEndpoint) : that.readerEndpoint != null) return false;
            if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
            if (this.snapshotArnsToRestore != null ? !this.snapshotArnsToRestore.equals(that.snapshotArnsToRestore) : that.snapshotArnsToRestore != null) return false;
            if (this.snapshotRetentionLimit != null ? !this.snapshotRetentionLimit.equals(that.snapshotRetentionLimit) : that.snapshotRetentionLimit != null) return false;
            if (this.subnetIds != null ? !this.subnetIds.equals(that.subnetIds) : that.subnetIds != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.userGroupId != null ? this.userGroupId.equals(that.userGroupId) : that.userGroupId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.engine.hashCode();
            result = 31 * result + (this.serverlessCacheName.hashCode());
            result = 31 * result + (this.cacheUsageLimits != null ? this.cacheUsageLimits.hashCode() : 0);
            result = 31 * result + (this.dailySnapshotTime != null ? this.dailySnapshotTime.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.endpoint != null ? this.endpoint.hashCode() : 0);
            result = 31 * result + (this.finalSnapshotName != null ? this.finalSnapshotName.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.majorEngineVersion != null ? this.majorEngineVersion.hashCode() : 0);
            result = 31 * result + (this.readerEndpoint != null ? this.readerEndpoint.hashCode() : 0);
            result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
            result = 31 * result + (this.snapshotArnsToRestore != null ? this.snapshotArnsToRestore.hashCode() : 0);
            result = 31 * result + (this.snapshotRetentionLimit != null ? this.snapshotRetentionLimit.hashCode() : 0);
            result = 31 * result + (this.subnetIds != null ? this.subnetIds.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.userGroupId != null ? this.userGroupId.hashCode() : 0);
            return result;
        }
    }
}
