package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Load balancing protocol for application load balancers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.certificatemanager.*;
 * Certificate certificate;
 * ApplicationLoadBalancer lb;
 * Bucket bucket;
 * TrustStore trustStore = TrustStore.Builder.create(this, "Store")
 *         .bucket(bucket)
 *         .key("rootCA_cert.pem")
 *         .build();
 * lb.addListener("Listener", BaseApplicationListenerProps.builder()
 *         .port(443)
 *         .protocol(ApplicationProtocol.HTTPS)
 *         .certificates(List.of(certificate))
 *         // mTLS settings
 *         .mutualAuthentication(MutualAuthentication.builder()
 *                 .advertiseTrustStoreCaNames(true)
 *                 .ignoreClientCertificateExpiry(false)
 *                 .mutualAuthenticationMode(MutualAuthenticationMode.VERIFY)
 *                 .trustStore(trustStore)
 *                 .build())
 *         .defaultAction(ListenerAction.fixedResponse(200, FixedResponseOptions.builder().contentType("text/plain").messageBody("Success mTLS").build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:24.422Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationProtocol")
public enum ApplicationProtocol {
    /**
     * HTTP.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTP,
    /**
     * HTTPS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTPS,
}
