package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * The IP address type of targets registered with a target group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * ApplicationTargetGroup ipv4ApplicationTargetGroup = ApplicationTargetGroup.Builder.create(this, "IPv4ApplicationTargetGroup")
 *         .vpc(vpc)
 *         .port(80)
 *         .targetType(TargetType.INSTANCE)
 *         .ipAddressType(TargetGroupIpAddressType.IPV4)
 *         .build();
 * ApplicationTargetGroup ipv6ApplicationTargetGroup = ApplicationTargetGroup.Builder.create(this, "Ipv6ApplicationTargetGroup")
 *         .vpc(vpc)
 *         .port(80)
 *         .targetType(TargetType.INSTANCE)
 *         .ipAddressType(TargetGroupIpAddressType.IPV6)
 *         .build();
 * NetworkTargetGroup ipv4NetworkTargetGroup = NetworkTargetGroup.Builder.create(this, "IPv4NetworkTargetGroup")
 *         .vpc(vpc)
 *         .port(80)
 *         .targetType(TargetType.INSTANCE)
 *         .ipAddressType(TargetGroupIpAddressType.IPV4)
 *         .build();
 * NetworkTargetGroup ipv6NetworkTargetGroup = NetworkTargetGroup.Builder.create(this, "Ipv6NetworkTargetGroup")
 *         .vpc(vpc)
 *         .port(80)
 *         .targetType(TargetType.INSTANCE)
 *         .ipAddressType(TargetGroupIpAddressType.IPV6)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:24.553Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.TargetGroupIpAddressType")
public enum TargetGroupIpAddressType {
    /**
     * IPv4 addresses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IPV4,
    /**
     * IPv6 addresses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IPV6,
}
