package software.amazon.awscdk.services.events;

/**
 * Define an EventBridge Api Destination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Connection connection = Connection.Builder.create(this, "Connection")
 *         .authorization(Authorization.apiKey("x-api-key", SecretValue.secretsManager("ApiSecretName")))
 *         .description("Connection with API Key x-api-key")
 *         .build();
 * ApiDestination destination = ApiDestination.Builder.create(this, "Destination")
 *         .connection(connection)
 *         .endpoint("https://example.com")
 *         .description("Calling example.com with API key x-api-key")
 *         .build();
 * Rule rule = Rule.Builder.create(this, "Rule")
 *         .schedule(Schedule.rate(Duration.minutes(1)))
 *         .targets(List.of(new ApiDestination(destination)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:24.750Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.ApiDestination")
public class ApiDestination extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.events.IApiDestination {

    protected ApiDestination(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApiDestination(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ApiDestination(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.ApiDestinationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Create an Api Destination construct from an existing Api Destination ARN.
     * <p>
     * @param scope The scope creating construct (usually <code>this</code>). This parameter is required.
     * @param id The construct's id. This parameter is required.
     * @param attrs The Api Destination import attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.ApiDestination fromApiDestinationAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.ApiDestinationAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.ApiDestination.class, "fromApiDestinationAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.ApiDestination.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * The ARN of the Api Destination created.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApiDestinationArn() {
        return software.amazon.jsii.Kernel.get(this, "apiDestinationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Name of the Api Destination created.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApiDestinationName() {
        return software.amazon.jsii.Kernel.get(this, "apiDestinationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Connection to associate with Api Destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IConnection getConnection() {
        return software.amazon.jsii.Kernel.get(this, "connection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.IConnection.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.events.ApiDestination}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.events.ApiDestination> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.events.ApiDestinationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.events.ApiDestinationProps.Builder();
        }

        /**
         * The ARN of the connection to use for the API destination.
         * <p>
         * @return {@code this}
         * @param connection The ARN of the connection to use for the API destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connection(final software.amazon.awscdk.services.events.IConnection connection) {
            this.props.connection(connection);
            return this;
        }

        /**
         * The URL to the HTTP invocation endpoint for the API destination..
         * <p>
         * @return {@code this}
         * @param endpoint The URL to the HTTP invocation endpoint for the API destination.. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(final java.lang.String endpoint) {
            this.props.endpoint(endpoint);
            return this;
        }

        /**
         * The name for the API destination.
         * <p>
         * Default: - A unique name will be generated
         * <p>
         * @return {@code this}
         * @param apiDestinationName The name for the API destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiDestinationName(final java.lang.String apiDestinationName) {
            this.props.apiDestinationName(apiDestinationName);
            return this;
        }

        /**
         * A description for the API destination.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param description A description for the API destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The method to use for the request to the HTTP invocation endpoint.
         * <p>
         * Default: HttpMethod.POST
         * <p>
         * @return {@code this}
         * @param httpMethod The method to use for the request to the HTTP invocation endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpMethod(final software.amazon.awscdk.services.events.HttpMethod httpMethod) {
            this.props.httpMethod(httpMethod);
            return this;
        }

        /**
         * The maximum number of requests per second to send to the HTTP invocation endpoint.
         * <p>
         * Default: - Not rate limited
         * <p>
         * @return {@code this}
         * @param rateLimitPerSecond The maximum number of requests per second to send to the HTTP invocation endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rateLimitPerSecond(final java.lang.Number rateLimitPerSecond) {
            this.props.rateLimitPerSecond(rateLimitPerSecond);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.events.ApiDestination}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.events.ApiDestination build() {
            return new software.amazon.awscdk.services.events.ApiDestination(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
