package software.amazon.awscdk.services.globalaccelerator;

/**
 * Construct properties of the Accelerator.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Accelerator accelerator = Accelerator.Builder.create(this, "Accelerator")
 *         .ipAddresses(List.of("1.1.1.1", "2.2.2.2"))
 *         .ipAddressType(IpAddressType.IPV4)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:25.170Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_globalaccelerator.AcceleratorProps")
@software.amazon.jsii.Jsii.Proxy(AcceleratorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AcceleratorProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the accelerator.
     * <p>
     * Default: - resource ID
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAcceleratorName() {
        return null;
    }

    /**
     * Indicates whether the accelerator is enabled.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * IP addresses associated with the accelerator.
     * <p>
     * Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP
     * addresses from your own pool to use for the accelerator's static IP addresses when you create an accelerator.
     * You can specify one or two addresses, separated by a comma. Do not include the /32 suffix.
     * <p>
     * Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify
     * only one IP address from your IP address range, Global Accelerator assigns a second static IP address for
     * the accelerator from the AWS IP address pool.
     * <p>
     * Note that you can't update IP addresses for an existing accelerator. To change them, you must create a
     * new accelerator with the new addresses.
     * <p>
     * Default: - undefined. IP addresses will be from Amazon's pool of IP addresses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIpAddresses() {
        return null;
    }

    /**
     * The IP address type that an accelerator supports.
     * <p>
     * For a standard accelerator, the value can be IPV4 or DUAL_STACK.
     * <p>
     * Default: - "IPV4"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.globalaccelerator.IpAddressType getIpAddressType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AcceleratorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AcceleratorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AcceleratorProps> {
        java.lang.String acceleratorName;
        java.lang.Boolean enabled;
        java.util.List<java.lang.String> ipAddresses;
        software.amazon.awscdk.services.globalaccelerator.IpAddressType ipAddressType;

        /**
         * Sets the value of {@link AcceleratorProps#getAcceleratorName}
         * @param acceleratorName The name of the accelerator.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceleratorName(java.lang.String acceleratorName) {
            this.acceleratorName = acceleratorName;
            return this;
        }

        /**
         * Sets the value of {@link AcceleratorProps#getEnabled}
         * @param enabled Indicates whether the accelerator is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link AcceleratorProps#getIpAddresses}
         * @param ipAddresses IP addresses associated with the accelerator.
         *                    Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP
         *                    addresses from your own pool to use for the accelerator's static IP addresses when you create an accelerator.
         *                    You can specify one or two addresses, separated by a comma. Do not include the /32 suffix.
         *                    <p>
         *                    Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify
         *                    only one IP address from your IP address range, Global Accelerator assigns a second static IP address for
         *                    the accelerator from the AWS IP address pool.
         *                    <p>
         *                    Note that you can't update IP addresses for an existing accelerator. To change them, you must create a
         *                    new accelerator with the new addresses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddresses(java.util.List<java.lang.String> ipAddresses) {
            this.ipAddresses = ipAddresses;
            return this;
        }

        /**
         * Sets the value of {@link AcceleratorProps#getIpAddressType}
         * @param ipAddressType The IP address type that an accelerator supports.
         *                      For a standard accelerator, the value can be IPV4 or DUAL_STACK.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(software.amazon.awscdk.services.globalaccelerator.IpAddressType ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AcceleratorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AcceleratorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AcceleratorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AcceleratorProps {
        private final java.lang.String acceleratorName;
        private final java.lang.Boolean enabled;
        private final java.util.List<java.lang.String> ipAddresses;
        private final software.amazon.awscdk.services.globalaccelerator.IpAddressType ipAddressType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.acceleratorName = software.amazon.jsii.Kernel.get(this, "acceleratorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ipAddresses = software.amazon.jsii.Kernel.get(this, "ipAddresses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.ipAddressType = software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.globalaccelerator.IpAddressType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.acceleratorName = builder.acceleratorName;
            this.enabled = builder.enabled;
            this.ipAddresses = builder.ipAddresses;
            this.ipAddressType = builder.ipAddressType;
        }

        @Override
        public final java.lang.String getAcceleratorName() {
            return this.acceleratorName;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.util.List<java.lang.String> getIpAddresses() {
            return this.ipAddresses;
        }

        @Override
        public final software.amazon.awscdk.services.globalaccelerator.IpAddressType getIpAddressType() {
            return this.ipAddressType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAcceleratorName() != null) {
                data.set("acceleratorName", om.valueToTree(this.getAcceleratorName()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getIpAddresses() != null) {
                data.set("ipAddresses", om.valueToTree(this.getIpAddresses()));
            }
            if (this.getIpAddressType() != null) {
                data.set("ipAddressType", om.valueToTree(this.getIpAddressType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_globalaccelerator.AcceleratorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AcceleratorProps.Jsii$Proxy that = (AcceleratorProps.Jsii$Proxy) o;

            if (this.acceleratorName != null ? !this.acceleratorName.equals(that.acceleratorName) : that.acceleratorName != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.ipAddresses != null ? !this.ipAddresses.equals(that.ipAddresses) : that.ipAddresses != null) return false;
            return this.ipAddressType != null ? this.ipAddressType.equals(that.ipAddressType) : that.ipAddressType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.acceleratorName != null ? this.acceleratorName.hashCode() : 0;
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.ipAddresses != null ? this.ipAddresses.hashCode() : 0);
            result = 31 * result + (this.ipAddressType != null ? this.ipAddressType.hashCode() : 0);
            return result;
        }
    }
}
