package software.amazon.awscdk.services.globalaccelerator.endpoints;

/**
 * Use an EC2 Instance as a Global Accelerator Endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Listener listener;
 * Instance instance;
 * listener.addEndpointGroup("Group", EndpointGroupOptions.builder()
 *         .endpoints(List.of(
 *             InstanceEndpoint.Builder.create(instance)
 *                     .weight(128)
 *                     .preserveClientIp(true)
 *                     .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:25.190Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_globalaccelerator_endpoints.InstanceEndpoint")
public class InstanceEndpoint extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.globalaccelerator.IEndpoint {

    protected InstanceEndpoint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InstanceEndpoint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param instance This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InstanceEndpoint(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IInstance instance, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.globalaccelerator.endpoints.InstanceEndpointProps options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(instance, "instance is required"), options });
    }

    /**
     * @param instance This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InstanceEndpoint(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IInstance instance) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(instance, "instance is required") });
    }

    /**
     * Render the endpoint to an endpoint configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object renderEndpointConfiguration() {
        return software.amazon.jsii.Kernel.call(this, "renderEndpointConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The region where the endpoint is located.
     * <p>
     * If the region cannot be determined, <code>undefined</code> is returned
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.globalaccelerator.endpoints.InstanceEndpoint}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.globalaccelerator.endpoints.InstanceEndpoint> {
        /**
         * @return a new instance of {@link Builder}.
         * @param instance This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.ec2.IInstance instance) {
            return new Builder(instance);
        }

        private final software.amazon.awscdk.services.ec2.IInstance instance;
        private software.amazon.awscdk.services.globalaccelerator.endpoints.InstanceEndpointProps.Builder options;

        private Builder(final software.amazon.awscdk.services.ec2.IInstance instance) {
            this.instance = instance;
        }

        /**
         * Forward the client IP address.
         * <p>
         * GlobalAccelerator will create Network Interfaces in your VPC in order
         * to preserve the client IP address.
         * <p>
         * Client IP address preservation is supported only in specific AWS Regions.
         * See the GlobalAccelerator Developer Guide for a list.
         * <p>
         * Default: true if available
         * <p>
         * @return {@code this}
         * @param preserveClientIp Forward the client IP address. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preserveClientIp(final java.lang.Boolean preserveClientIp) {
            this.options().preserveClientIp(preserveClientIp);
            return this;
        }

        /**
         * Endpoint weight across all endpoints in the group.
         * <p>
         * Must be a value between 0 and 255.
         * <p>
         * Default: 128
         * <p>
         * @return {@code this}
         * @param weight Endpoint weight across all endpoints in the group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder weight(final java.lang.Number weight) {
            this.options().weight(weight);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.globalaccelerator.endpoints.InstanceEndpoint}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.globalaccelerator.endpoints.InstanceEndpoint build() {
            return new software.amazon.awscdk.services.globalaccelerator.endpoints.InstanceEndpoint(
                this.instance,
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.services.globalaccelerator.endpoints.InstanceEndpointProps.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.services.globalaccelerator.endpoints.InstanceEndpointProps.Builder();
            }
            return this.options;
        }
    }
}
