package software.amazon.awscdk.services.imagebuilder;

/**
 * Properties for defining a <code>CfnImageRecipe</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.imagebuilder.*;
 * CfnImageRecipeProps cfnImageRecipeProps = CfnImageRecipeProps.builder()
 *         .components(List.of(ComponentConfigurationProperty.builder()
 *                 .componentArn("componentArn")
 *                 .parameters(List.of(ComponentParameterProperty.builder()
 *                         .name("name")
 *                         .value(List.of("value"))
 *                         .build()))
 *                 .build()))
 *         .name("name")
 *         .parentImage("parentImage")
 *         .version("version")
 *         // the properties below are optional
 *         .additionalInstanceConfiguration(AdditionalInstanceConfigurationProperty.builder()
 *                 .systemsManagerAgent(SystemsManagerAgentProperty.builder()
 *                         .uninstallAfterBuild(false)
 *                         .build())
 *                 .userDataOverride("userDataOverride")
 *                 .build())
 *         .blockDeviceMappings(List.of(InstanceBlockDeviceMappingProperty.builder()
 *                 .deviceName("deviceName")
 *                 .ebs(EbsInstanceBlockDeviceSpecificationProperty.builder()
 *                         .deleteOnTermination(false)
 *                         .encrypted(false)
 *                         .iops(123)
 *                         .kmsKeyId("kmsKeyId")
 *                         .snapshotId("snapshotId")
 *                         .throughput(123)
 *                         .volumeSize(123)
 *                         .volumeType("volumeType")
 *                         .build())
 *                 .noDevice("noDevice")
 *                 .virtualName("virtualName")
 *                 .build()))
 *         .description("description")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .workingDirectory("workingDirectory")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:25.683Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnImageRecipeProps")
@software.amazon.jsii.Jsii.Proxy(CfnImageRecipeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnImageRecipeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The components of the image recipe.
     * <p>
     * Components are orchestration documents that define a sequence of steps for downloading, installing, configuring, and testing software packages. They also define validation and security hardening steps. A component is defined using a YAML document format.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-components">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-components</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getComponents();

    /**
     * The name of the image recipe.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The parent image of the image recipe.
     * <p>
     * The string must be either an Image ARN or an AMI ID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-parentimage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-parentimage</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getParentImage();

    /**
     * The semantic version of the image recipe.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-version">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-version</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVersion();

    /**
     * Before you create a new AMI, Image Builder launches temporary Amazon EC2 instances to build and test your image configuration.
     * <p>
     * Instance configuration adds a layer of control over those instances. You can define settings and add scripts to run when an instance is launched from your AMI.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-additionalinstanceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-additionalinstanceconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalInstanceConfiguration() {
        return null;
    }

    /**
     * The block device mappings to apply when creating images from this recipe.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-blockdevicemappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-blockdevicemappings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBlockDeviceMappings() {
        return null;
    }

    /**
     * The description of the image recipe.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The tags of the image recipe.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * The working directory to be used during build and test workflows.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-workingdirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-workingdirectory</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWorkingDirectory() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnImageRecipeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnImageRecipeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnImageRecipeProps> {
        java.lang.Object components;
        java.lang.String name;
        java.lang.String parentImage;
        java.lang.String version;
        java.lang.Object additionalInstanceConfiguration;
        java.lang.Object blockDeviceMappings;
        java.lang.String description;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.String workingDirectory;

        /**
         * Sets the value of {@link CfnImageRecipeProps#getComponents}
         * @param components The components of the image recipe. This parameter is required.
         *                   Components are orchestration documents that define a sequence of steps for downloading, installing, configuring, and testing software packages. They also define validation and security hardening steps. A component is defined using a YAML document format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder components(software.amazon.awscdk.IResolvable components) {
            this.components = components;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageRecipeProps#getComponents}
         * @param components The components of the image recipe. This parameter is required.
         *                   Components are orchestration documents that define a sequence of steps for downloading, installing, configuring, and testing software packages. They also define validation and security hardening steps. A component is defined using a YAML document format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder components(java.util.List<? extends java.lang.Object> components) {
            this.components = components;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageRecipeProps#getName}
         * @param name The name of the image recipe. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageRecipeProps#getParentImage}
         * @param parentImage The parent image of the image recipe. This parameter is required.
         *                    The string must be either an Image ARN or an AMI ID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parentImage(java.lang.String parentImage) {
            this.parentImage = parentImage;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageRecipeProps#getVersion}
         * @param version The semantic version of the image recipe. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageRecipeProps#getAdditionalInstanceConfiguration}
         * @param additionalInstanceConfiguration Before you create a new AMI, Image Builder launches temporary Amazon EC2 instances to build and test your image configuration.
         *                                        Instance configuration adds a layer of control over those instances. You can define settings and add scripts to run when an instance is launched from your AMI.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalInstanceConfiguration(software.amazon.awscdk.IResolvable additionalInstanceConfiguration) {
            this.additionalInstanceConfiguration = additionalInstanceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageRecipeProps#getAdditionalInstanceConfiguration}
         * @param additionalInstanceConfiguration Before you create a new AMI, Image Builder launches temporary Amazon EC2 instances to build and test your image configuration.
         *                                        Instance configuration adds a layer of control over those instances. You can define settings and add scripts to run when an instance is launched from your AMI.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalInstanceConfiguration(software.amazon.awscdk.services.imagebuilder.CfnImageRecipe.AdditionalInstanceConfigurationProperty additionalInstanceConfiguration) {
            this.additionalInstanceConfiguration = additionalInstanceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageRecipeProps#getBlockDeviceMappings}
         * @param blockDeviceMappings The block device mappings to apply when creating images from this recipe.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockDeviceMappings(software.amazon.awscdk.IResolvable blockDeviceMappings) {
            this.blockDeviceMappings = blockDeviceMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageRecipeProps#getBlockDeviceMappings}
         * @param blockDeviceMappings The block device mappings to apply when creating images from this recipe.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockDeviceMappings(java.util.List<? extends java.lang.Object> blockDeviceMappings) {
            this.blockDeviceMappings = blockDeviceMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageRecipeProps#getDescription}
         * @param description The description of the image recipe.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageRecipeProps#getTags}
         * @param tags The tags of the image recipe.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageRecipeProps#getWorkingDirectory}
         * @param workingDirectory The working directory to be used during build and test workflows.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workingDirectory(java.lang.String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnImageRecipeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnImageRecipeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnImageRecipeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnImageRecipeProps {
        private final java.lang.Object components;
        private final java.lang.String name;
        private final java.lang.String parentImage;
        private final java.lang.String version;
        private final java.lang.Object additionalInstanceConfiguration;
        private final java.lang.Object blockDeviceMappings;
        private final java.lang.String description;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.String workingDirectory;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.components = software.amazon.jsii.Kernel.get(this, "components", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parentImage = software.amazon.jsii.Kernel.get(this, "parentImage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.additionalInstanceConfiguration = software.amazon.jsii.Kernel.get(this, "additionalInstanceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.blockDeviceMappings = software.amazon.jsii.Kernel.get(this, "blockDeviceMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.workingDirectory = software.amazon.jsii.Kernel.get(this, "workingDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.components = java.util.Objects.requireNonNull(builder.components, "components is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.parentImage = java.util.Objects.requireNonNull(builder.parentImage, "parentImage is required");
            this.version = java.util.Objects.requireNonNull(builder.version, "version is required");
            this.additionalInstanceConfiguration = builder.additionalInstanceConfiguration;
            this.blockDeviceMappings = builder.blockDeviceMappings;
            this.description = builder.description;
            this.tags = builder.tags;
            this.workingDirectory = builder.workingDirectory;
        }

        @Override
        public final java.lang.Object getComponents() {
            return this.components;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getParentImage() {
            return this.parentImage;
        }

        @Override
        public final java.lang.String getVersion() {
            return this.version;
        }

        @Override
        public final java.lang.Object getAdditionalInstanceConfiguration() {
            return this.additionalInstanceConfiguration;
        }

        @Override
        public final java.lang.Object getBlockDeviceMappings() {
            return this.blockDeviceMappings;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getWorkingDirectory() {
            return this.workingDirectory;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("components", om.valueToTree(this.getComponents()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("parentImage", om.valueToTree(this.getParentImage()));
            data.set("version", om.valueToTree(this.getVersion()));
            if (this.getAdditionalInstanceConfiguration() != null) {
                data.set("additionalInstanceConfiguration", om.valueToTree(this.getAdditionalInstanceConfiguration()));
            }
            if (this.getBlockDeviceMappings() != null) {
                data.set("blockDeviceMappings", om.valueToTree(this.getBlockDeviceMappings()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getWorkingDirectory() != null) {
                data.set("workingDirectory", om.valueToTree(this.getWorkingDirectory()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnImageRecipeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnImageRecipeProps.Jsii$Proxy that = (CfnImageRecipeProps.Jsii$Proxy) o;

            if (!components.equals(that.components)) return false;
            if (!name.equals(that.name)) return false;
            if (!parentImage.equals(that.parentImage)) return false;
            if (!version.equals(that.version)) return false;
            if (this.additionalInstanceConfiguration != null ? !this.additionalInstanceConfiguration.equals(that.additionalInstanceConfiguration) : that.additionalInstanceConfiguration != null) return false;
            if (this.blockDeviceMappings != null ? !this.blockDeviceMappings.equals(that.blockDeviceMappings) : that.blockDeviceMappings != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.workingDirectory != null ? this.workingDirectory.equals(that.workingDirectory) : that.workingDirectory == null;
        }

        @Override
        public final int hashCode() {
            int result = this.components.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.parentImage.hashCode());
            result = 31 * result + (this.version.hashCode());
            result = 31 * result + (this.additionalInstanceConfiguration != null ? this.additionalInstanceConfiguration.hashCode() : 0);
            result = 31 * result + (this.blockDeviceMappings != null ? this.blockDeviceMappings.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.workingDirectory != null ? this.workingDirectory.hashCode() : 0);
            return result;
        }
    }
}
