package software.amazon.awscdk.services.iot;

/**
 * Properties for defining a <code>CfnCommand</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnCommandProps cfnCommandProps = CfnCommandProps.builder()
 *         .commandId("commandId")
 *         // the properties below are optional
 *         .createdAt("createdAt")
 *         .deprecated(false)
 *         .description("description")
 *         .displayName("displayName")
 *         .lastUpdatedAt("lastUpdatedAt")
 *         .mandatoryParameters(List.of(CommandParameterProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .defaultValue(CommandParameterValueProperty.builder()
 *                         .b(false)
 *                         .bin("bin")
 *                         .d(123)
 *                         .i(123)
 *                         .l("l")
 *                         .s("s")
 *                         .ul("ul")
 *                         .build())
 *                 .description("description")
 *                 .value(CommandParameterValueProperty.builder()
 *                         .b(false)
 *                         .bin("bin")
 *                         .d(123)
 *                         .i(123)
 *                         .l("l")
 *                         .s("s")
 *                         .ul("ul")
 *                         .build())
 *                 .build()))
 *         .namespace("namespace")
 *         .payload(CommandPayloadProperty.builder()
 *                 .content("content")
 *                 .contentType("contentType")
 *                 .build())
 *         .pendingDeletion(false)
 *         .roleArn("roleArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:25.777Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnCommandProps")
@software.amazon.jsii.Jsii.Proxy(CfnCommandProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCommandProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique identifier of the command.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html#cfn-iot-command-commandid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html#cfn-iot-command-commandid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCommandId();

    /**
     * The timestamp, when the command was created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html#cfn-iot-command-createdat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html#cfn-iot-command-createdat</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCreatedAt() {
        return null;
    }

    /**
     * Indicates whether the command has been deprecated.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html#cfn-iot-command-deprecated">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html#cfn-iot-command-deprecated</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeprecated() {
        return null;
    }

    /**
     * The description of the command parameter.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html#cfn-iot-command-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html#cfn-iot-command-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The display name of the command.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html#cfn-iot-command-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html#cfn-iot-command-displayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return null;
    }

    /**
     * The timestamp, when the command was last updated.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html#cfn-iot-command-lastupdatedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html#cfn-iot-command-lastupdatedat</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLastUpdatedAt() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html#cfn-iot-command-mandatoryparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html#cfn-iot-command-mandatoryparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMandatoryParameters() {
        return null;
    }

    /**
     * The namespace to which the command belongs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html#cfn-iot-command-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html#cfn-iot-command-namespace</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html#cfn-iot-command-payload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html#cfn-iot-command-payload</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPayload() {
        return null;
    }

    /**
     * Indicates whether the command is pending deletion.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html#cfn-iot-command-pendingdeletion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html#cfn-iot-command-pendingdeletion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPendingDeletion() {
        return null;
    }

    /**
     * The customer role associated with the command.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html#cfn-iot-command-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html#cfn-iot-command-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return null;
    }

    /**
     * The tags to be associated with the command.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html#cfn-iot-command-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-command.html#cfn-iot-command-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCommandProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCommandProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCommandProps> {
        java.lang.String commandId;
        java.lang.String createdAt;
        java.lang.Object deprecated;
        java.lang.String description;
        java.lang.String displayName;
        java.lang.String lastUpdatedAt;
        java.lang.Object mandatoryParameters;
        java.lang.String namespace;
        java.lang.Object payload;
        java.lang.Object pendingDeletion;
        java.lang.String roleArn;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnCommandProps#getCommandId}
         * @param commandId The unique identifier of the command. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder commandId(java.lang.String commandId) {
            this.commandId = commandId;
            return this;
        }

        /**
         * Sets the value of {@link CfnCommandProps#getCreatedAt}
         * @param createdAt The timestamp, when the command was created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createdAt(java.lang.String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        /**
         * Sets the value of {@link CfnCommandProps#getDeprecated}
         * @param deprecated Indicates whether the command has been deprecated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deprecated(java.lang.Boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        /**
         * Sets the value of {@link CfnCommandProps#getDeprecated}
         * @param deprecated Indicates whether the command has been deprecated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deprecated(software.amazon.awscdk.IResolvable deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        /**
         * Sets the value of {@link CfnCommandProps#getDescription}
         * @param description The description of the command parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnCommandProps#getDisplayName}
         * @param displayName The display name of the command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCommandProps#getLastUpdatedAt}
         * @param lastUpdatedAt The timestamp, when the command was last updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lastUpdatedAt(java.lang.String lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        /**
         * Sets the value of {@link CfnCommandProps#getMandatoryParameters}
         * @param mandatoryParameters the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mandatoryParameters(software.amazon.awscdk.IResolvable mandatoryParameters) {
            this.mandatoryParameters = mandatoryParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnCommandProps#getMandatoryParameters}
         * @param mandatoryParameters the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mandatoryParameters(java.util.List<? extends java.lang.Object> mandatoryParameters) {
            this.mandatoryParameters = mandatoryParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnCommandProps#getNamespace}
         * @param namespace The namespace to which the command belongs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespace(java.lang.String namespace) {
            this.namespace = namespace;
            return this;
        }

        /**
         * Sets the value of {@link CfnCommandProps#getPayload}
         * @param payload the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder payload(software.amazon.awscdk.IResolvable payload) {
            this.payload = payload;
            return this;
        }

        /**
         * Sets the value of {@link CfnCommandProps#getPayload}
         * @param payload the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder payload(software.amazon.awscdk.services.iot.CfnCommand.CommandPayloadProperty payload) {
            this.payload = payload;
            return this;
        }

        /**
         * Sets the value of {@link CfnCommandProps#getPendingDeletion}
         * @param pendingDeletion Indicates whether the command is pending deletion.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pendingDeletion(java.lang.Boolean pendingDeletion) {
            this.pendingDeletion = pendingDeletion;
            return this;
        }

        /**
         * Sets the value of {@link CfnCommandProps#getPendingDeletion}
         * @param pendingDeletion Indicates whether the command is pending deletion.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pendingDeletion(software.amazon.awscdk.IResolvable pendingDeletion) {
            this.pendingDeletion = pendingDeletion;
            return this;
        }

        /**
         * Sets the value of {@link CfnCommandProps#getRoleArn}
         * @param roleArn The customer role associated with the command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnCommandProps#getTags}
         * @param tags The tags to be associated with the command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCommandProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCommandProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCommandProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCommandProps {
        private final java.lang.String commandId;
        private final java.lang.String createdAt;
        private final java.lang.Object deprecated;
        private final java.lang.String description;
        private final java.lang.String displayName;
        private final java.lang.String lastUpdatedAt;
        private final java.lang.Object mandatoryParameters;
        private final java.lang.String namespace;
        private final java.lang.Object payload;
        private final java.lang.Object pendingDeletion;
        private final java.lang.String roleArn;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.commandId = software.amazon.jsii.Kernel.get(this, "commandId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.createdAt = software.amazon.jsii.Kernel.get(this, "createdAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deprecated = software.amazon.jsii.Kernel.get(this, "deprecated", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lastUpdatedAt = software.amazon.jsii.Kernel.get(this, "lastUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mandatoryParameters = software.amazon.jsii.Kernel.get(this, "mandatoryParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.payload = software.amazon.jsii.Kernel.get(this, "payload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.pendingDeletion = software.amazon.jsii.Kernel.get(this, "pendingDeletion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.commandId = java.util.Objects.requireNonNull(builder.commandId, "commandId is required");
            this.createdAt = builder.createdAt;
            this.deprecated = builder.deprecated;
            this.description = builder.description;
            this.displayName = builder.displayName;
            this.lastUpdatedAt = builder.lastUpdatedAt;
            this.mandatoryParameters = builder.mandatoryParameters;
            this.namespace = builder.namespace;
            this.payload = builder.payload;
            this.pendingDeletion = builder.pendingDeletion;
            this.roleArn = builder.roleArn;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getCommandId() {
            return this.commandId;
        }

        @Override
        public final java.lang.String getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final java.lang.Object getDeprecated() {
            return this.deprecated;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.lang.String getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        public final java.lang.Object getMandatoryParameters() {
            return this.mandatoryParameters;
        }

        @Override
        public final java.lang.String getNamespace() {
            return this.namespace;
        }

        @Override
        public final java.lang.Object getPayload() {
            return this.payload;
        }

        @Override
        public final java.lang.Object getPendingDeletion() {
            return this.pendingDeletion;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("commandId", om.valueToTree(this.getCommandId()));
            if (this.getCreatedAt() != null) {
                data.set("createdAt", om.valueToTree(this.getCreatedAt()));
            }
            if (this.getDeprecated() != null) {
                data.set("deprecated", om.valueToTree(this.getDeprecated()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDisplayName() != null) {
                data.set("displayName", om.valueToTree(this.getDisplayName()));
            }
            if (this.getLastUpdatedAt() != null) {
                data.set("lastUpdatedAt", om.valueToTree(this.getLastUpdatedAt()));
            }
            if (this.getMandatoryParameters() != null) {
                data.set("mandatoryParameters", om.valueToTree(this.getMandatoryParameters()));
            }
            if (this.getNamespace() != null) {
                data.set("namespace", om.valueToTree(this.getNamespace()));
            }
            if (this.getPayload() != null) {
                data.set("payload", om.valueToTree(this.getPayload()));
            }
            if (this.getPendingDeletion() != null) {
                data.set("pendingDeletion", om.valueToTree(this.getPendingDeletion()));
            }
            if (this.getRoleArn() != null) {
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnCommandProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCommandProps.Jsii$Proxy that = (CfnCommandProps.Jsii$Proxy) o;

            if (!commandId.equals(that.commandId)) return false;
            if (this.createdAt != null ? !this.createdAt.equals(that.createdAt) : that.createdAt != null) return false;
            if (this.deprecated != null ? !this.deprecated.equals(that.deprecated) : that.deprecated != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) return false;
            if (this.lastUpdatedAt != null ? !this.lastUpdatedAt.equals(that.lastUpdatedAt) : that.lastUpdatedAt != null) return false;
            if (this.mandatoryParameters != null ? !this.mandatoryParameters.equals(that.mandatoryParameters) : that.mandatoryParameters != null) return false;
            if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) return false;
            if (this.payload != null ? !this.payload.equals(that.payload) : that.payload != null) return false;
            if (this.pendingDeletion != null ? !this.pendingDeletion.equals(that.pendingDeletion) : that.pendingDeletion != null) return false;
            if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.commandId.hashCode();
            result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
            result = 31 * result + (this.deprecated != null ? this.deprecated.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            result = 31 * result + (this.lastUpdatedAt != null ? this.lastUpdatedAt.hashCode() : 0);
            result = 31 * result + (this.mandatoryParameters != null ? this.mandatoryParameters.hashCode() : 0);
            result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
            result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
            result = 31 * result + (this.pendingDeletion != null ? this.pendingDeletion.hashCode() : 0);
            result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
