package software.amazon.awscdk.services.iot;

/**
 * Represents a job template.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * Object abortConfig;
 * Object jobExecutionsRolloutConfig;
 * Object presignedUrlConfig;
 * Object timeoutConfig;
 * CfnJobTemplate cfnJobTemplate = CfnJobTemplate.Builder.create(this, "MyCfnJobTemplate")
 *         .description("description")
 *         .jobTemplateId("jobTemplateId")
 *         // the properties below are optional
 *         .abortConfig(abortConfig)
 *         .destinationPackageVersions(List.of("destinationPackageVersions"))
 *         .document("document")
 *         .documentSource("documentSource")
 *         .jobArn("jobArn")
 *         .jobExecutionsRetryConfig(JobExecutionsRetryConfigProperty.builder()
 *                 .retryCriteriaList(List.of(RetryCriteriaProperty.builder()
 *                         .failureType("failureType")
 *                         .numberOfRetries(123)
 *                         .build()))
 *                 .build())
 *         .jobExecutionsRolloutConfig(jobExecutionsRolloutConfig)
 *         .maintenanceWindows(List.of(MaintenanceWindowProperty.builder()
 *                 .durationInMinutes(123)
 *                 .startTime("startTime")
 *                 .build()))
 *         .presignedUrlConfig(presignedUrlConfig)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .timeoutConfig(timeoutConfig)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:25.788Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnJobTemplate")
public class CfnJobTemplate extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnJobTemplate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnJobTemplate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iot.CfnJobTemplate.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnJobTemplate(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.CfnJobTemplateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the job to use as the basis for the job template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A description of the job template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the job template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", java.util.Objects.requireNonNull(value, "description is required"));
    }

    /**
     * A unique identifier for the job template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getJobTemplateId() {
        return software.amazon.jsii.Kernel.get(this, "jobTemplateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A unique identifier for the job template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobTemplateId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "jobTemplateId", java.util.Objects.requireNonNull(value, "jobTemplateId is required"));
    }

    /**
     * The criteria that determine when and how a job abort takes place.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAbortConfig() {
        return software.amazon.jsii.Kernel.get(this, "abortConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The criteria that determine when and how a job abort takes place.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAbortConfig(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "abortConfig", value);
    }

    /**
     * The package version Amazon Resource Names (ARNs) that are installed on the device’s reserved named shadow ( <code>$package</code> ) when the job successfully completes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDestinationPackageVersions() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "destinationPackageVersions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The package version Amazon Resource Names (ARNs) that are installed on the device’s reserved named shadow ( <code>$package</code> ) when the job successfully completes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDestinationPackageVersions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "destinationPackageVersions", value);
    }

    /**
     * The job document.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDocument() {
        return software.amazon.jsii.Kernel.get(this, "document", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The job document.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDocument(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "document", value);
    }

    /**
     * An S3 link, or S3 object URL, to the job document.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDocumentSource() {
        return software.amazon.jsii.Kernel.get(this, "documentSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An S3 link, or S3 object URL, to the job document.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDocumentSource(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "documentSource", value);
    }

    /**
     * The ARN of the job to use as the basis for the job template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getJobArn() {
        return software.amazon.jsii.Kernel.get(this, "jobArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the job to use as the basis for the job template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "jobArn", value);
    }

    /**
     * Allows you to create the criteria to retry a job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getJobExecutionsRetryConfig() {
        return software.amazon.jsii.Kernel.get(this, "jobExecutionsRetryConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Allows you to create the criteria to retry a job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobExecutionsRetryConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "jobExecutionsRetryConfig", value);
    }

    /**
     * Allows you to create the criteria to retry a job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobExecutionsRetryConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.CfnJobTemplate.JobExecutionsRetryConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "jobExecutionsRetryConfig", value);
    }

    /**
     * Allows you to create a staged rollout of a job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getJobExecutionsRolloutConfig() {
        return software.amazon.jsii.Kernel.get(this, "jobExecutionsRolloutConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Allows you to create a staged rollout of a job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobExecutionsRolloutConfig(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "jobExecutionsRolloutConfig", value);
    }

    /**
     * An optional configuration within the SchedulingConfig to setup a recurring maintenance window with a predetermined start time and duration for the rollout of a job document to all devices in a target group for a job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMaintenanceWindows() {
        return software.amazon.jsii.Kernel.get(this, "maintenanceWindows", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An optional configuration within the SchedulingConfig to setup a recurring maintenance window with a predetermined start time and duration for the rollout of a job document to all devices in a target group for a job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaintenanceWindows(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "maintenanceWindows", value);
    }

    /**
     * An optional configuration within the SchedulingConfig to setup a recurring maintenance window with a predetermined start time and duration for the rollout of a job document to all devices in a target group for a job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaintenanceWindows(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iot.CfnJobTemplate.MaintenanceWindowProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iot.CfnJobTemplate.MaintenanceWindowProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "maintenanceWindows", value);
    }

    /**
     * Configuration for pre-signed S3 URLs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPresignedUrlConfig() {
        return software.amazon.jsii.Kernel.get(this, "presignedUrlConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration for pre-signed S3 URLs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPresignedUrlConfig(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "presignedUrlConfig", value);
    }

    /**
     * Metadata that can be used to manage the job template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Metadata that can be used to manage the job template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * Specifies the amount of time each device has to finish its execution of the job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTimeoutConfig() {
        return software.amazon.jsii.Kernel.get(this, "timeoutConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the amount of time each device has to finish its execution of the job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeoutConfig(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "timeoutConfig", value);
    }
    /**
     * The criteria that determine when and how a job abort takes place.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * AbortConfigProperty abortConfigProperty = AbortConfigProperty.builder()
     *         .criteriaList(List.of(AbortCriteriaProperty.builder()
     *                 .action("action")
     *                 .failureType("failureType")
     *                 .minNumberOfExecutedThings(123)
     *                 .thresholdPercentage(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-abortconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-abortconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnJobTemplate.AbortConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AbortConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AbortConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of criteria that determine when and how to abort the job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-abortconfig.html#cfn-iot-jobtemplate-abortconfig-criterialist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-abortconfig.html#cfn-iot-jobtemplate-abortconfig-criterialist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCriteriaList();

        /**
         * @return a {@link Builder} of {@link AbortConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AbortConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AbortConfigProperty> {
            java.lang.Object criteriaList;

            /**
             * Sets the value of {@link AbortConfigProperty#getCriteriaList}
             * @param criteriaList The list of criteria that determine when and how to abort the job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder criteriaList(software.amazon.awscdk.IResolvable criteriaList) {
                this.criteriaList = criteriaList;
                return this;
            }

            /**
             * Sets the value of {@link AbortConfigProperty#getCriteriaList}
             * @param criteriaList The list of criteria that determine when and how to abort the job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder criteriaList(java.util.List<? extends java.lang.Object> criteriaList) {
                this.criteriaList = criteriaList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AbortConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AbortConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AbortConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AbortConfigProperty {
            private final java.lang.Object criteriaList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.criteriaList = software.amazon.jsii.Kernel.get(this, "criteriaList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.criteriaList = java.util.Objects.requireNonNull(builder.criteriaList, "criteriaList is required");
            }

            @Override
            public final java.lang.Object getCriteriaList() {
                return this.criteriaList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("criteriaList", om.valueToTree(this.getCriteriaList()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnJobTemplate.AbortConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AbortConfigProperty.Jsii$Proxy that = (AbortConfigProperty.Jsii$Proxy) o;

                return this.criteriaList.equals(that.criteriaList);
            }

            @Override
            public final int hashCode() {
                int result = this.criteriaList.hashCode();
                return result;
            }
        }
    }
    /**
     * The criteria that determine when and how a job abort takes place.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * AbortCriteriaProperty abortCriteriaProperty = AbortCriteriaProperty.builder()
     *         .action("action")
     *         .failureType("failureType")
     *         .minNumberOfExecutedThings(123)
     *         .thresholdPercentage(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-abortcriteria.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-abortcriteria.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnJobTemplate.AbortCriteriaProperty")
    @software.amazon.jsii.Jsii.Proxy(AbortCriteriaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AbortCriteriaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of job action to take to initiate the job abort.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-abortcriteria.html#cfn-iot-jobtemplate-abortcriteria-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-abortcriteria.html#cfn-iot-jobtemplate-abortcriteria-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAction();

        /**
         * The type of job execution failures that can initiate a job abort.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-abortcriteria.html#cfn-iot-jobtemplate-abortcriteria-failuretype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-abortcriteria.html#cfn-iot-jobtemplate-abortcriteria-failuretype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFailureType();

        /**
         * The minimum number of things which must receive job execution notifications before the job can be aborted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-abortcriteria.html#cfn-iot-jobtemplate-abortcriteria-minnumberofexecutedthings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-abortcriteria.html#cfn-iot-jobtemplate-abortcriteria-minnumberofexecutedthings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinNumberOfExecutedThings();

        /**
         * The minimum percentage of job execution failures that must occur to initiate the job abort.
         * <p>
         * AWS IoT Core supports up to two digits after the decimal (for example, 10.9 and 10.99, but not 10.999).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-abortcriteria.html#cfn-iot-jobtemplate-abortcriteria-thresholdpercentage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-abortcriteria.html#cfn-iot-jobtemplate-abortcriteria-thresholdpercentage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getThresholdPercentage();

        /**
         * @return a {@link Builder} of {@link AbortCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AbortCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AbortCriteriaProperty> {
            java.lang.String action;
            java.lang.String failureType;
            java.lang.Number minNumberOfExecutedThings;
            java.lang.Number thresholdPercentage;

            /**
             * Sets the value of {@link AbortCriteriaProperty#getAction}
             * @param action The type of job action to take to initiate the job abort. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link AbortCriteriaProperty#getFailureType}
             * @param failureType The type of job execution failures that can initiate a job abort. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureType(java.lang.String failureType) {
                this.failureType = failureType;
                return this;
            }

            /**
             * Sets the value of {@link AbortCriteriaProperty#getMinNumberOfExecutedThings}
             * @param minNumberOfExecutedThings The minimum number of things which must receive job execution notifications before the job can be aborted. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minNumberOfExecutedThings(java.lang.Number minNumberOfExecutedThings) {
                this.minNumberOfExecutedThings = minNumberOfExecutedThings;
                return this;
            }

            /**
             * Sets the value of {@link AbortCriteriaProperty#getThresholdPercentage}
             * @param thresholdPercentage The minimum percentage of job execution failures that must occur to initiate the job abort. This parameter is required.
             *                            AWS IoT Core supports up to two digits after the decimal (for example, 10.9 and 10.99, but not 10.999).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder thresholdPercentage(java.lang.Number thresholdPercentage) {
                this.thresholdPercentage = thresholdPercentage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AbortCriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AbortCriteriaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AbortCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AbortCriteriaProperty {
            private final java.lang.String action;
            private final java.lang.String failureType;
            private final java.lang.Number minNumberOfExecutedThings;
            private final java.lang.Number thresholdPercentage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.failureType = software.amazon.jsii.Kernel.get(this, "failureType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.minNumberOfExecutedThings = software.amazon.jsii.Kernel.get(this, "minNumberOfExecutedThings", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.thresholdPercentage = software.amazon.jsii.Kernel.get(this, "thresholdPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.failureType = java.util.Objects.requireNonNull(builder.failureType, "failureType is required");
                this.minNumberOfExecutedThings = java.util.Objects.requireNonNull(builder.minNumberOfExecutedThings, "minNumberOfExecutedThings is required");
                this.thresholdPercentage = java.util.Objects.requireNonNull(builder.thresholdPercentage, "thresholdPercentage is required");
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.String getFailureType() {
                return this.failureType;
            }

            @Override
            public final java.lang.Number getMinNumberOfExecutedThings() {
                return this.minNumberOfExecutedThings;
            }

            @Override
            public final java.lang.Number getThresholdPercentage() {
                return this.thresholdPercentage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                data.set("failureType", om.valueToTree(this.getFailureType()));
                data.set("minNumberOfExecutedThings", om.valueToTree(this.getMinNumberOfExecutedThings()));
                data.set("thresholdPercentage", om.valueToTree(this.getThresholdPercentage()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnJobTemplate.AbortCriteriaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AbortCriteriaProperty.Jsii$Proxy that = (AbortCriteriaProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                if (!failureType.equals(that.failureType)) return false;
                if (!minNumberOfExecutedThings.equals(that.minNumberOfExecutedThings)) return false;
                return this.thresholdPercentage.equals(that.thresholdPercentage);
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.failureType.hashCode());
                result = 31 * result + (this.minNumberOfExecutedThings.hashCode());
                result = 31 * result + (this.thresholdPercentage.hashCode());
                return result;
            }
        }
    }
    /**
     * Allows you to create an exponential rate of rollout for a job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * ExponentialRolloutRateProperty exponentialRolloutRateProperty = ExponentialRolloutRateProperty.builder()
     *         .baseRatePerMinute(123)
     *         .incrementFactor(123)
     *         .rateIncreaseCriteria(RateIncreaseCriteriaProperty.builder()
     *                 .numberOfNotifiedThings(123)
     *                 .numberOfSucceededThings(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-exponentialrolloutrate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-exponentialrolloutrate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnJobTemplate.ExponentialRolloutRateProperty")
    @software.amazon.jsii.Jsii.Proxy(ExponentialRolloutRateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExponentialRolloutRateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The minimum number of things that will be notified of a pending job, per minute at the start of job rollout.
         * <p>
         * This parameter allows you to define the initial rate of rollout.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-exponentialrolloutrate.html#cfn-iot-jobtemplate-exponentialrolloutrate-baserateperminute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-exponentialrolloutrate.html#cfn-iot-jobtemplate-exponentialrolloutrate-baserateperminute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getBaseRatePerMinute();

        /**
         * The exponential factor to increase the rate of rollout for a job.
         * <p>
         * AWS IoT Core supports up to one digit after the decimal (for example, 1.5, but not 1.55).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-exponentialrolloutrate.html#cfn-iot-jobtemplate-exponentialrolloutrate-incrementfactor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-exponentialrolloutrate.html#cfn-iot-jobtemplate-exponentialrolloutrate-incrementfactor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getIncrementFactor();

        /**
         * The criteria to initiate the increase in rate of rollout for a job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-exponentialrolloutrate.html#cfn-iot-jobtemplate-exponentialrolloutrate-rateincreasecriteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-exponentialrolloutrate.html#cfn-iot-jobtemplate-exponentialrolloutrate-rateincreasecriteria</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRateIncreaseCriteria();

        /**
         * @return a {@link Builder} of {@link ExponentialRolloutRateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExponentialRolloutRateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExponentialRolloutRateProperty> {
            java.lang.Number baseRatePerMinute;
            java.lang.Number incrementFactor;
            java.lang.Object rateIncreaseCriteria;

            /**
             * Sets the value of {@link ExponentialRolloutRateProperty#getBaseRatePerMinute}
             * @param baseRatePerMinute The minimum number of things that will be notified of a pending job, per minute at the start of job rollout. This parameter is required.
             *                          This parameter allows you to define the initial rate of rollout.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baseRatePerMinute(java.lang.Number baseRatePerMinute) {
                this.baseRatePerMinute = baseRatePerMinute;
                return this;
            }

            /**
             * Sets the value of {@link ExponentialRolloutRateProperty#getIncrementFactor}
             * @param incrementFactor The exponential factor to increase the rate of rollout for a job. This parameter is required.
             *                        AWS IoT Core supports up to one digit after the decimal (for example, 1.5, but not 1.55).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder incrementFactor(java.lang.Number incrementFactor) {
                this.incrementFactor = incrementFactor;
                return this;
            }

            /**
             * Sets the value of {@link ExponentialRolloutRateProperty#getRateIncreaseCriteria}
             * @param rateIncreaseCriteria The criteria to initiate the increase in rate of rollout for a job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rateIncreaseCriteria(software.amazon.awscdk.IResolvable rateIncreaseCriteria) {
                this.rateIncreaseCriteria = rateIncreaseCriteria;
                return this;
            }

            /**
             * Sets the value of {@link ExponentialRolloutRateProperty#getRateIncreaseCriteria}
             * @param rateIncreaseCriteria The criteria to initiate the increase in rate of rollout for a job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rateIncreaseCriteria(software.amazon.awscdk.services.iot.CfnJobTemplate.RateIncreaseCriteriaProperty rateIncreaseCriteria) {
                this.rateIncreaseCriteria = rateIncreaseCriteria;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExponentialRolloutRateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExponentialRolloutRateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExponentialRolloutRateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExponentialRolloutRateProperty {
            private final java.lang.Number baseRatePerMinute;
            private final java.lang.Number incrementFactor;
            private final java.lang.Object rateIncreaseCriteria;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.baseRatePerMinute = software.amazon.jsii.Kernel.get(this, "baseRatePerMinute", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.incrementFactor = software.amazon.jsii.Kernel.get(this, "incrementFactor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.rateIncreaseCriteria = software.amazon.jsii.Kernel.get(this, "rateIncreaseCriteria", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.baseRatePerMinute = java.util.Objects.requireNonNull(builder.baseRatePerMinute, "baseRatePerMinute is required");
                this.incrementFactor = java.util.Objects.requireNonNull(builder.incrementFactor, "incrementFactor is required");
                this.rateIncreaseCriteria = java.util.Objects.requireNonNull(builder.rateIncreaseCriteria, "rateIncreaseCriteria is required");
            }

            @Override
            public final java.lang.Number getBaseRatePerMinute() {
                return this.baseRatePerMinute;
            }

            @Override
            public final java.lang.Number getIncrementFactor() {
                return this.incrementFactor;
            }

            @Override
            public final java.lang.Object getRateIncreaseCriteria() {
                return this.rateIncreaseCriteria;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("baseRatePerMinute", om.valueToTree(this.getBaseRatePerMinute()));
                data.set("incrementFactor", om.valueToTree(this.getIncrementFactor()));
                data.set("rateIncreaseCriteria", om.valueToTree(this.getRateIncreaseCriteria()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnJobTemplate.ExponentialRolloutRateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExponentialRolloutRateProperty.Jsii$Proxy that = (ExponentialRolloutRateProperty.Jsii$Proxy) o;

                if (!baseRatePerMinute.equals(that.baseRatePerMinute)) return false;
                if (!incrementFactor.equals(that.incrementFactor)) return false;
                return this.rateIncreaseCriteria.equals(that.rateIncreaseCriteria);
            }

            @Override
            public final int hashCode() {
                int result = this.baseRatePerMinute.hashCode();
                result = 31 * result + (this.incrementFactor.hashCode());
                result = 31 * result + (this.rateIncreaseCriteria.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration that determines how many retries are allowed for each failure type for a job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * JobExecutionsRetryConfigProperty jobExecutionsRetryConfigProperty = JobExecutionsRetryConfigProperty.builder()
     *         .retryCriteriaList(List.of(RetryCriteriaProperty.builder()
     *                 .failureType("failureType")
     *                 .numberOfRetries(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-jobexecutionsretryconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-jobexecutionsretryconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnJobTemplate.JobExecutionsRetryConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(JobExecutionsRetryConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JobExecutionsRetryConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of criteria that determines how many retries are allowed for each failure type for a job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-jobexecutionsretryconfig.html#cfn-iot-jobtemplate-jobexecutionsretryconfig-retrycriterialist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-jobexecutionsretryconfig.html#cfn-iot-jobtemplate-jobexecutionsretryconfig-retrycriterialist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetryCriteriaList() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JobExecutionsRetryConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JobExecutionsRetryConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JobExecutionsRetryConfigProperty> {
            java.lang.Object retryCriteriaList;

            /**
             * Sets the value of {@link JobExecutionsRetryConfigProperty#getRetryCriteriaList}
             * @param retryCriteriaList The list of criteria that determines how many retries are allowed for each failure type for a job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryCriteriaList(software.amazon.awscdk.IResolvable retryCriteriaList) {
                this.retryCriteriaList = retryCriteriaList;
                return this;
            }

            /**
             * Sets the value of {@link JobExecutionsRetryConfigProperty#getRetryCriteriaList}
             * @param retryCriteriaList The list of criteria that determines how many retries are allowed for each failure type for a job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryCriteriaList(java.util.List<? extends java.lang.Object> retryCriteriaList) {
                this.retryCriteriaList = retryCriteriaList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JobExecutionsRetryConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JobExecutionsRetryConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JobExecutionsRetryConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JobExecutionsRetryConfigProperty {
            private final java.lang.Object retryCriteriaList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.retryCriteriaList = software.amazon.jsii.Kernel.get(this, "retryCriteriaList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.retryCriteriaList = builder.retryCriteriaList;
            }

            @Override
            public final java.lang.Object getRetryCriteriaList() {
                return this.retryCriteriaList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRetryCriteriaList() != null) {
                    data.set("retryCriteriaList", om.valueToTree(this.getRetryCriteriaList()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnJobTemplate.JobExecutionsRetryConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JobExecutionsRetryConfigProperty.Jsii$Proxy that = (JobExecutionsRetryConfigProperty.Jsii$Proxy) o;

                return this.retryCriteriaList != null ? this.retryCriteriaList.equals(that.retryCriteriaList) : that.retryCriteriaList == null;
            }

            @Override
            public final int hashCode() {
                int result = this.retryCriteriaList != null ? this.retryCriteriaList.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Allows you to create a staged rollout of a job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * JobExecutionsRolloutConfigProperty jobExecutionsRolloutConfigProperty = JobExecutionsRolloutConfigProperty.builder()
     *         .exponentialRolloutRate(ExponentialRolloutRateProperty.builder()
     *                 .baseRatePerMinute(123)
     *                 .incrementFactor(123)
     *                 .rateIncreaseCriteria(RateIncreaseCriteriaProperty.builder()
     *                         .numberOfNotifiedThings(123)
     *                         .numberOfSucceededThings(123)
     *                         .build())
     *                 .build())
     *         .maximumPerMinute(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-jobexecutionsrolloutconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-jobexecutionsrolloutconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnJobTemplate.JobExecutionsRolloutConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(JobExecutionsRolloutConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JobExecutionsRolloutConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The rate of increase for a job rollout.
         * <p>
         * This parameter allows you to define an exponential rate for a job rollout.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-jobexecutionsrolloutconfig.html#cfn-iot-jobtemplate-jobexecutionsrolloutconfig-exponentialrolloutrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-jobexecutionsrolloutconfig.html#cfn-iot-jobtemplate-jobexecutionsrolloutconfig-exponentialrolloutrate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExponentialRolloutRate() {
            return null;
        }

        /**
         * The maximum number of things that will be notified of a pending job, per minute.
         * <p>
         * This parameter allows you to create a staged rollout.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-jobexecutionsrolloutconfig.html#cfn-iot-jobtemplate-jobexecutionsrolloutconfig-maximumperminute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-jobexecutionsrolloutconfig.html#cfn-iot-jobtemplate-jobexecutionsrolloutconfig-maximumperminute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumPerMinute() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JobExecutionsRolloutConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JobExecutionsRolloutConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JobExecutionsRolloutConfigProperty> {
            java.lang.Object exponentialRolloutRate;
            java.lang.Number maximumPerMinute;

            /**
             * Sets the value of {@link JobExecutionsRolloutConfigProperty#getExponentialRolloutRate}
             * @param exponentialRolloutRate The rate of increase for a job rollout.
             *                               This parameter allows you to define an exponential rate for a job rollout.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exponentialRolloutRate(software.amazon.awscdk.IResolvable exponentialRolloutRate) {
                this.exponentialRolloutRate = exponentialRolloutRate;
                return this;
            }

            /**
             * Sets the value of {@link JobExecutionsRolloutConfigProperty#getExponentialRolloutRate}
             * @param exponentialRolloutRate The rate of increase for a job rollout.
             *                               This parameter allows you to define an exponential rate for a job rollout.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exponentialRolloutRate(software.amazon.awscdk.services.iot.CfnJobTemplate.ExponentialRolloutRateProperty exponentialRolloutRate) {
                this.exponentialRolloutRate = exponentialRolloutRate;
                return this;
            }

            /**
             * Sets the value of {@link JobExecutionsRolloutConfigProperty#getMaximumPerMinute}
             * @param maximumPerMinute The maximum number of things that will be notified of a pending job, per minute.
             *                         This parameter allows you to create a staged rollout.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumPerMinute(java.lang.Number maximumPerMinute) {
                this.maximumPerMinute = maximumPerMinute;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JobExecutionsRolloutConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JobExecutionsRolloutConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JobExecutionsRolloutConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JobExecutionsRolloutConfigProperty {
            private final java.lang.Object exponentialRolloutRate;
            private final java.lang.Number maximumPerMinute;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.exponentialRolloutRate = software.amazon.jsii.Kernel.get(this, "exponentialRolloutRate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maximumPerMinute = software.amazon.jsii.Kernel.get(this, "maximumPerMinute", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.exponentialRolloutRate = builder.exponentialRolloutRate;
                this.maximumPerMinute = builder.maximumPerMinute;
            }

            @Override
            public final java.lang.Object getExponentialRolloutRate() {
                return this.exponentialRolloutRate;
            }

            @Override
            public final java.lang.Number getMaximumPerMinute() {
                return this.maximumPerMinute;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExponentialRolloutRate() != null) {
                    data.set("exponentialRolloutRate", om.valueToTree(this.getExponentialRolloutRate()));
                }
                if (this.getMaximumPerMinute() != null) {
                    data.set("maximumPerMinute", om.valueToTree(this.getMaximumPerMinute()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnJobTemplate.JobExecutionsRolloutConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JobExecutionsRolloutConfigProperty.Jsii$Proxy that = (JobExecutionsRolloutConfigProperty.Jsii$Proxy) o;

                if (this.exponentialRolloutRate != null ? !this.exponentialRolloutRate.equals(that.exponentialRolloutRate) : that.exponentialRolloutRate != null) return false;
                return this.maximumPerMinute != null ? this.maximumPerMinute.equals(that.maximumPerMinute) : that.maximumPerMinute == null;
            }

            @Override
            public final int hashCode() {
                int result = this.exponentialRolloutRate != null ? this.exponentialRolloutRate.hashCode() : 0;
                result = 31 * result + (this.maximumPerMinute != null ? this.maximumPerMinute.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An optional configuration within the <code>SchedulingConfig</code> to setup a recurring maintenance window with a predetermined start time and duration for the rollout of a job document to all devices in a target group for a job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * MaintenanceWindowProperty maintenanceWindowProperty = MaintenanceWindowProperty.builder()
     *         .durationInMinutes(123)
     *         .startTime("startTime")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-maintenancewindow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-maintenancewindow.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnJobTemplate.MaintenanceWindowProperty")
    @software.amazon.jsii.Jsii.Proxy(MaintenanceWindowProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MaintenanceWindowProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Displays the duration of the next maintenance window.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-maintenancewindow.html#cfn-iot-jobtemplate-maintenancewindow-durationinminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-maintenancewindow.html#cfn-iot-jobtemplate-maintenancewindow-durationinminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDurationInMinutes() {
            return null;
        }

        /**
         * Displays the start time of the next maintenance window.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-maintenancewindow.html#cfn-iot-jobtemplate-maintenancewindow-starttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-maintenancewindow.html#cfn-iot-jobtemplate-maintenancewindow-starttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStartTime() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MaintenanceWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MaintenanceWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MaintenanceWindowProperty> {
            java.lang.Number durationInMinutes;
            java.lang.String startTime;

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getDurationInMinutes}
             * @param durationInMinutes Displays the duration of the next maintenance window.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder durationInMinutes(java.lang.Number durationInMinutes) {
                this.durationInMinutes = durationInMinutes;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getStartTime}
             * @param startTime Displays the start time of the next maintenance window.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTime(java.lang.String startTime) {
                this.startTime = startTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MaintenanceWindowProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MaintenanceWindowProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MaintenanceWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MaintenanceWindowProperty {
            private final java.lang.Number durationInMinutes;
            private final java.lang.String startTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.durationInMinutes = software.amazon.jsii.Kernel.get(this, "durationInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.startTime = software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.durationInMinutes = builder.durationInMinutes;
                this.startTime = builder.startTime;
            }

            @Override
            public final java.lang.Number getDurationInMinutes() {
                return this.durationInMinutes;
            }

            @Override
            public final java.lang.String getStartTime() {
                return this.startTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDurationInMinutes() != null) {
                    data.set("durationInMinutes", om.valueToTree(this.getDurationInMinutes()));
                }
                if (this.getStartTime() != null) {
                    data.set("startTime", om.valueToTree(this.getStartTime()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnJobTemplate.MaintenanceWindowProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MaintenanceWindowProperty.Jsii$Proxy that = (MaintenanceWindowProperty.Jsii$Proxy) o;

                if (this.durationInMinutes != null ? !this.durationInMinutes.equals(that.durationInMinutes) : that.durationInMinutes != null) return false;
                return this.startTime != null ? this.startTime.equals(that.startTime) : that.startTime == null;
            }

            @Override
            public final int hashCode() {
                int result = this.durationInMinutes != null ? this.durationInMinutes.hashCode() : 0;
                result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for pre-signed S3 URLs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * PresignedUrlConfigProperty presignedUrlConfigProperty = PresignedUrlConfigProperty.builder()
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .expiresInSec(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-presignedurlconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-presignedurlconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnJobTemplate.PresignedUrlConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(PresignedUrlConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PresignedUrlConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of an IAM role that grants grants permission to download files from the S3 bucket where the job data/updates are stored.
         * <p>
         * The role must also grant permission for IoT to download the files.
         * <p>
         * <blockquote>
         * <p>
         * For information about addressing the confused deputy problem, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/cross-service-confused-deputy-prevention.html">cross-service confused deputy prevention</a> in the <em>AWS IoT Core developer guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-presignedurlconfig.html#cfn-iot-jobtemplate-presignedurlconfig-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-presignedurlconfig.html#cfn-iot-jobtemplate-presignedurlconfig-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * How long (in seconds) pre-signed URLs are valid.
         * <p>
         * Valid values are 60 - 3600, the default value is 3600 seconds. Pre-signed URLs are generated when Jobs receives an MQTT request for the job document.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-presignedurlconfig.html#cfn-iot-jobtemplate-presignedurlconfig-expiresinsec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-presignedurlconfig.html#cfn-iot-jobtemplate-presignedurlconfig-expiresinsec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getExpiresInSec() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PresignedUrlConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PresignedUrlConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PresignedUrlConfigProperty> {
            java.lang.String roleArn;
            java.lang.Number expiresInSec;

            /**
             * Sets the value of {@link PresignedUrlConfigProperty#getRoleArn}
             * @param roleArn The ARN of an IAM role that grants grants permission to download files from the S3 bucket where the job data/updates are stored. This parameter is required.
             *                The role must also grant permission for IoT to download the files.
             *                <p>
             *                <blockquote>
             *                <p>
             *                For information about addressing the confused deputy problem, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/cross-service-confused-deputy-prevention.html">cross-service confused deputy prevention</a> in the <em>AWS IoT Core developer guide</em> .
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link PresignedUrlConfigProperty#getExpiresInSec}
             * @param expiresInSec How long (in seconds) pre-signed URLs are valid.
             *                     Valid values are 60 - 3600, the default value is 3600 seconds. Pre-signed URLs are generated when Jobs receives an MQTT request for the job document.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expiresInSec(java.lang.Number expiresInSec) {
                this.expiresInSec = expiresInSec;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PresignedUrlConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PresignedUrlConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PresignedUrlConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PresignedUrlConfigProperty {
            private final java.lang.String roleArn;
            private final java.lang.Number expiresInSec;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.expiresInSec = software.amazon.jsii.Kernel.get(this, "expiresInSec", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.expiresInSec = builder.expiresInSec;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Number getExpiresInSec() {
                return this.expiresInSec;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getExpiresInSec() != null) {
                    data.set("expiresInSec", om.valueToTree(this.getExpiresInSec()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnJobTemplate.PresignedUrlConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PresignedUrlConfigProperty.Jsii$Proxy that = (PresignedUrlConfigProperty.Jsii$Proxy) o;

                if (!roleArn.equals(that.roleArn)) return false;
                return this.expiresInSec != null ? this.expiresInSec.equals(that.expiresInSec) : that.expiresInSec == null;
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                result = 31 * result + (this.expiresInSec != null ? this.expiresInSec.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Allows you to define a criteria to initiate the increase in rate of rollout for a job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * RateIncreaseCriteriaProperty rateIncreaseCriteriaProperty = RateIncreaseCriteriaProperty.builder()
     *         .numberOfNotifiedThings(123)
     *         .numberOfSucceededThings(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-rateincreasecriteria.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-rateincreasecriteria.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnJobTemplate.RateIncreaseCriteriaProperty")
    @software.amazon.jsii.Jsii.Proxy(RateIncreaseCriteriaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RateIncreaseCriteriaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The threshold for number of notified things that will initiate the increase in rate of rollout.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-rateincreasecriteria.html#cfn-iot-jobtemplate-rateincreasecriteria-numberofnotifiedthings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-rateincreasecriteria.html#cfn-iot-jobtemplate-rateincreasecriteria-numberofnotifiedthings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfNotifiedThings() {
            return null;
        }

        /**
         * The threshold for number of succeeded things that will initiate the increase in rate of rollout.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-rateincreasecriteria.html#cfn-iot-jobtemplate-rateincreasecriteria-numberofsucceededthings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-rateincreasecriteria.html#cfn-iot-jobtemplate-rateincreasecriteria-numberofsucceededthings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfSucceededThings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RateIncreaseCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RateIncreaseCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RateIncreaseCriteriaProperty> {
            java.lang.Number numberOfNotifiedThings;
            java.lang.Number numberOfSucceededThings;

            /**
             * Sets the value of {@link RateIncreaseCriteriaProperty#getNumberOfNotifiedThings}
             * @param numberOfNotifiedThings The threshold for number of notified things that will initiate the increase in rate of rollout.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberOfNotifiedThings(java.lang.Number numberOfNotifiedThings) {
                this.numberOfNotifiedThings = numberOfNotifiedThings;
                return this;
            }

            /**
             * Sets the value of {@link RateIncreaseCriteriaProperty#getNumberOfSucceededThings}
             * @param numberOfSucceededThings The threshold for number of succeeded things that will initiate the increase in rate of rollout.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberOfSucceededThings(java.lang.Number numberOfSucceededThings) {
                this.numberOfSucceededThings = numberOfSucceededThings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RateIncreaseCriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RateIncreaseCriteriaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RateIncreaseCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RateIncreaseCriteriaProperty {
            private final java.lang.Number numberOfNotifiedThings;
            private final java.lang.Number numberOfSucceededThings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.numberOfNotifiedThings = software.amazon.jsii.Kernel.get(this, "numberOfNotifiedThings", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.numberOfSucceededThings = software.amazon.jsii.Kernel.get(this, "numberOfSucceededThings", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.numberOfNotifiedThings = builder.numberOfNotifiedThings;
                this.numberOfSucceededThings = builder.numberOfSucceededThings;
            }

            @Override
            public final java.lang.Number getNumberOfNotifiedThings() {
                return this.numberOfNotifiedThings;
            }

            @Override
            public final java.lang.Number getNumberOfSucceededThings() {
                return this.numberOfSucceededThings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNumberOfNotifiedThings() != null) {
                    data.set("numberOfNotifiedThings", om.valueToTree(this.getNumberOfNotifiedThings()));
                }
                if (this.getNumberOfSucceededThings() != null) {
                    data.set("numberOfSucceededThings", om.valueToTree(this.getNumberOfSucceededThings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnJobTemplate.RateIncreaseCriteriaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RateIncreaseCriteriaProperty.Jsii$Proxy that = (RateIncreaseCriteriaProperty.Jsii$Proxy) o;

                if (this.numberOfNotifiedThings != null ? !this.numberOfNotifiedThings.equals(that.numberOfNotifiedThings) : that.numberOfNotifiedThings != null) return false;
                return this.numberOfSucceededThings != null ? this.numberOfSucceededThings.equals(that.numberOfSucceededThings) : that.numberOfSucceededThings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.numberOfNotifiedThings != null ? this.numberOfNotifiedThings.hashCode() : 0;
                result = 31 * result + (this.numberOfSucceededThings != null ? this.numberOfSucceededThings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The criteria that determines how many retries are allowed for each failure type for a job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * RetryCriteriaProperty retryCriteriaProperty = RetryCriteriaProperty.builder()
     *         .failureType("failureType")
     *         .numberOfRetries(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-retrycriteria.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-retrycriteria.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnJobTemplate.RetryCriteriaProperty")
    @software.amazon.jsii.Jsii.Proxy(RetryCriteriaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetryCriteriaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of job execution failures that can initiate a job retry.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-retrycriteria.html#cfn-iot-jobtemplate-retrycriteria-failuretype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-retrycriteria.html#cfn-iot-jobtemplate-retrycriteria-failuretype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFailureType() {
            return null;
        }

        /**
         * The number of retries allowed for a failure type for the job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-retrycriteria.html#cfn-iot-jobtemplate-retrycriteria-numberofretries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-retrycriteria.html#cfn-iot-jobtemplate-retrycriteria-numberofretries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfRetries() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RetryCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetryCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetryCriteriaProperty> {
            java.lang.String failureType;
            java.lang.Number numberOfRetries;

            /**
             * Sets the value of {@link RetryCriteriaProperty#getFailureType}
             * @param failureType The type of job execution failures that can initiate a job retry.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureType(java.lang.String failureType) {
                this.failureType = failureType;
                return this;
            }

            /**
             * Sets the value of {@link RetryCriteriaProperty#getNumberOfRetries}
             * @param numberOfRetries The number of retries allowed for a failure type for the job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberOfRetries(java.lang.Number numberOfRetries) {
                this.numberOfRetries = numberOfRetries;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetryCriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetryCriteriaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RetryCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetryCriteriaProperty {
            private final java.lang.String failureType;
            private final java.lang.Number numberOfRetries;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.failureType = software.amazon.jsii.Kernel.get(this, "failureType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.numberOfRetries = software.amazon.jsii.Kernel.get(this, "numberOfRetries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.failureType = builder.failureType;
                this.numberOfRetries = builder.numberOfRetries;
            }

            @Override
            public final java.lang.String getFailureType() {
                return this.failureType;
            }

            @Override
            public final java.lang.Number getNumberOfRetries() {
                return this.numberOfRetries;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFailureType() != null) {
                    data.set("failureType", om.valueToTree(this.getFailureType()));
                }
                if (this.getNumberOfRetries() != null) {
                    data.set("numberOfRetries", om.valueToTree(this.getNumberOfRetries()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnJobTemplate.RetryCriteriaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetryCriteriaProperty.Jsii$Proxy that = (RetryCriteriaProperty.Jsii$Proxy) o;

                if (this.failureType != null ? !this.failureType.equals(that.failureType) : that.failureType != null) return false;
                return this.numberOfRetries != null ? this.numberOfRetries.equals(that.numberOfRetries) : that.numberOfRetries == null;
            }

            @Override
            public final int hashCode() {
                int result = this.failureType != null ? this.failureType.hashCode() : 0;
                result = 31 * result + (this.numberOfRetries != null ? this.numberOfRetries.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the amount of time each device has to finish its execution of the job.
     * <p>
     * A timer is started when the job execution status is set to <code>IN_PROGRESS</code> . If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * TimeoutConfigProperty timeoutConfigProperty = TimeoutConfigProperty.builder()
     *         .inProgressTimeoutInMinutes(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-timeoutconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-timeoutconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnJobTemplate.TimeoutConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(TimeoutConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimeoutConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the amount of time, in minutes, this device has to finish execution of this job.
         * <p>
         * The timeout interval can be anywhere between 1 minute and 7 days (1 to 10080 minutes). The in progress timer can't be updated and will apply to all job executions for the job. Whenever a job execution remains in the IN_PROGRESS status for longer than this interval, the job execution will fail and switch to the terminal <code>TIMED_OUT</code> status.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-timeoutconfig.html#cfn-iot-jobtemplate-timeoutconfig-inprogresstimeoutinminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-jobtemplate-timeoutconfig.html#cfn-iot-jobtemplate-timeoutconfig-inprogresstimeoutinminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getInProgressTimeoutInMinutes();

        /**
         * @return a {@link Builder} of {@link TimeoutConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimeoutConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimeoutConfigProperty> {
            java.lang.Number inProgressTimeoutInMinutes;

            /**
             * Sets the value of {@link TimeoutConfigProperty#getInProgressTimeoutInMinutes}
             * @param inProgressTimeoutInMinutes Specifies the amount of time, in minutes, this device has to finish execution of this job. This parameter is required.
             *                                   The timeout interval can be anywhere between 1 minute and 7 days (1 to 10080 minutes). The in progress timer can't be updated and will apply to all job executions for the job. Whenever a job execution remains in the IN_PROGRESS status for longer than this interval, the job execution will fail and switch to the terminal <code>TIMED_OUT</code> status.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inProgressTimeoutInMinutes(java.lang.Number inProgressTimeoutInMinutes) {
                this.inProgressTimeoutInMinutes = inProgressTimeoutInMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimeoutConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimeoutConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimeoutConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimeoutConfigProperty {
            private final java.lang.Number inProgressTimeoutInMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inProgressTimeoutInMinutes = software.amazon.jsii.Kernel.get(this, "inProgressTimeoutInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inProgressTimeoutInMinutes = java.util.Objects.requireNonNull(builder.inProgressTimeoutInMinutes, "inProgressTimeoutInMinutes is required");
            }

            @Override
            public final java.lang.Number getInProgressTimeoutInMinutes() {
                return this.inProgressTimeoutInMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("inProgressTimeoutInMinutes", om.valueToTree(this.getInProgressTimeoutInMinutes()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnJobTemplate.TimeoutConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimeoutConfigProperty.Jsii$Proxy that = (TimeoutConfigProperty.Jsii$Proxy) o;

                return this.inProgressTimeoutInMinutes.equals(that.inProgressTimeoutInMinutes);
            }

            @Override
            public final int hashCode() {
                int result = this.inProgressTimeoutInMinutes.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iot.CfnJobTemplate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iot.CfnJobTemplate> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iot.CfnJobTemplateProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iot.CfnJobTemplateProps.Builder();
        }

        /**
         * A description of the job template.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-description</a>
         * @param description A description of the job template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * A unique identifier for the job template.
         * <p>
         * We recommend using a UUID. Alpha-numeric characters, "-", and "_" are valid for use here.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobtemplateid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobtemplateid</a>
         * @param jobTemplateId A unique identifier for the job template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobTemplateId(final java.lang.String jobTemplateId) {
            this.props.jobTemplateId(jobTemplateId);
            return this;
        }

        /**
         * The criteria that determine when and how a job abort takes place.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-abortconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-abortconfig</a>
         * @param abortConfig The criteria that determine when and how a job abort takes place. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder abortConfig(final java.lang.Object abortConfig) {
            this.props.abortConfig(abortConfig);
            return this;
        }

        /**
         * The package version Amazon Resource Names (ARNs) that are installed on the device’s reserved named shadow ( <code>$package</code> ) when the job successfully completes.
         * <p>
         * <em>Note:</em> Up to 25 package version ARNS are allowed.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-destinationpackageversions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-destinationpackageversions</a>
         * @param destinationPackageVersions The package version Amazon Resource Names (ARNs) that are installed on the device’s reserved named shadow ( <code>$package</code> ) when the job successfully completes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationPackageVersions(final java.util.List<java.lang.String> destinationPackageVersions) {
            this.props.destinationPackageVersions(destinationPackageVersions);
            return this;
        }

        /**
         * The job document.
         * <p>
         * Required if you don't specify a value for <code>documentSource</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-document">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-document</a>
         * @param document The job document. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder document(final java.lang.String document) {
            this.props.document(document);
            return this;
        }

        /**
         * An S3 link, or S3 object URL, to the job document.
         * <p>
         * The link is an Amazon S3 object URL and is required if you don't specify a value for <code>document</code> .
         * <p>
         * For example, <code>--document-source https://s3. *region-code* .amazonaws.com/example-firmware/device-firmware.1.0</code>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-bucket-intro.html">Methods for accessing a bucket</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-documentsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-documentsource</a>
         * @param documentSource An S3 link, or S3 object URL, to the job document. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentSource(final java.lang.String documentSource) {
            this.props.documentSource(documentSource);
            return this;
        }

        /**
         * The ARN of the job to use as the basis for the job template.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobarn</a>
         * @param jobArn The ARN of the job to use as the basis for the job template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobArn(final java.lang.String jobArn) {
            this.props.jobArn(jobArn);
            return this;
        }

        /**
         * Allows you to create the criteria to retry a job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobexecutionsretryconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobexecutionsretryconfig</a>
         * @param jobExecutionsRetryConfig Allows you to create the criteria to retry a job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobExecutionsRetryConfig(final software.amazon.awscdk.IResolvable jobExecutionsRetryConfig) {
            this.props.jobExecutionsRetryConfig(jobExecutionsRetryConfig);
            return this;
        }
        /**
         * Allows you to create the criteria to retry a job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobexecutionsretryconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobexecutionsretryconfig</a>
         * @param jobExecutionsRetryConfig Allows you to create the criteria to retry a job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobExecutionsRetryConfig(final software.amazon.awscdk.services.iot.CfnJobTemplate.JobExecutionsRetryConfigProperty jobExecutionsRetryConfig) {
            this.props.jobExecutionsRetryConfig(jobExecutionsRetryConfig);
            return this;
        }

        /**
         * Allows you to create a staged rollout of a job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobexecutionsrolloutconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobexecutionsrolloutconfig</a>
         * @param jobExecutionsRolloutConfig Allows you to create a staged rollout of a job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobExecutionsRolloutConfig(final java.lang.Object jobExecutionsRolloutConfig) {
            this.props.jobExecutionsRolloutConfig(jobExecutionsRolloutConfig);
            return this;
        }

        /**
         * An optional configuration within the SchedulingConfig to setup a recurring maintenance window with a predetermined start time and duration for the rollout of a job document to all devices in a target group for a job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-maintenancewindows">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-maintenancewindows</a>
         * @param maintenanceWindows An optional configuration within the SchedulingConfig to setup a recurring maintenance window with a predetermined start time and duration for the rollout of a job document to all devices in a target group for a job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceWindows(final software.amazon.awscdk.IResolvable maintenanceWindows) {
            this.props.maintenanceWindows(maintenanceWindows);
            return this;
        }
        /**
         * An optional configuration within the SchedulingConfig to setup a recurring maintenance window with a predetermined start time and duration for the rollout of a job document to all devices in a target group for a job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-maintenancewindows">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-maintenancewindows</a>
         * @param maintenanceWindows An optional configuration within the SchedulingConfig to setup a recurring maintenance window with a predetermined start time and duration for the rollout of a job document to all devices in a target group for a job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceWindows(final java.util.List<? extends java.lang.Object> maintenanceWindows) {
            this.props.maintenanceWindows(maintenanceWindows);
            return this;
        }

        /**
         * Configuration for pre-signed S3 URLs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-presignedurlconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-presignedurlconfig</a>
         * @param presignedUrlConfig Configuration for pre-signed S3 URLs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder presignedUrlConfig(final java.lang.Object presignedUrlConfig) {
            this.props.presignedUrlConfig(presignedUrlConfig);
            return this;
        }

        /**
         * Metadata that can be used to manage the job template.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-tags</a>
         * @param tags Metadata that can be used to manage the job template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Specifies the amount of time each device has to finish its execution of the job.
         * <p>
         * A timer is started when the job execution status is set to <code>IN_PROGRESS</code> . If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-timeoutconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-timeoutconfig</a>
         * @param timeoutConfig Specifies the amount of time each device has to finish its execution of the job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeoutConfig(final java.lang.Object timeoutConfig) {
            this.props.timeoutConfig(timeoutConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iot.CfnJobTemplate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iot.CfnJobTemplate build() {
            return new software.amazon.awscdk.services.iot.CfnJobTemplate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
