package software.amazon.awscdk.services.iotanalytics;

/**
 * Properties for defining a <code>CfnDataset</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotanalytics.*;
 * CfnDatasetProps cfnDatasetProps = CfnDatasetProps.builder()
 *         .actions(List.of(ActionProperty.builder()
 *                 .actionName("actionName")
 *                 // the properties below are optional
 *                 .containerAction(ContainerActionProperty.builder()
 *                         .executionRoleArn("executionRoleArn")
 *                         .image("image")
 *                         .resourceConfiguration(ResourceConfigurationProperty.builder()
 *                                 .computeType("computeType")
 *                                 .volumeSizeInGb(123)
 *                                 .build())
 *                         // the properties below are optional
 *                         .variables(List.of(VariableProperty.builder()
 *                                 .variableName("variableName")
 *                                 // the properties below are optional
 *                                 .datasetContentVersionValue(DatasetContentVersionValueProperty.builder()
 *                                         .datasetName("datasetName")
 *                                         .build())
 *                                 .doubleValue(123)
 *                                 .outputFileUriValue(OutputFileUriValueProperty.builder()
 *                                         .fileName("fileName")
 *                                         .build())
 *                                 .stringValue("stringValue")
 *                                 .build()))
 *                         .build())
 *                 .queryAction(QueryActionProperty.builder()
 *                         .sqlQuery("sqlQuery")
 *                         // the properties below are optional
 *                         .filters(List.of(FilterProperty.builder()
 *                                 .deltaTime(DeltaTimeProperty.builder()
 *                                         .offsetSeconds(123)
 *                                         .timeExpression("timeExpression")
 *                                         .build())
 *                                 .build()))
 *                         .build())
 *                 .build()))
 *         // the properties below are optional
 *         .contentDeliveryRules(List.of(DatasetContentDeliveryRuleProperty.builder()
 *                 .destination(DatasetContentDeliveryRuleDestinationProperty.builder()
 *                         .iotEventsDestinationConfiguration(IotEventsDestinationConfigurationProperty.builder()
 *                                 .inputName("inputName")
 *                                 .roleArn("roleArn")
 *                                 .build())
 *                         .s3DestinationConfiguration(S3DestinationConfigurationProperty.builder()
 *                                 .bucket("bucket")
 *                                 .key("key")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .glueConfiguration(GlueConfigurationProperty.builder()
 *                                         .databaseName("databaseName")
 *                                         .tableName("tableName")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .entryName("entryName")
 *                 .build()))
 *         .datasetName("datasetName")
 *         .lateDataRules(List.of(LateDataRuleProperty.builder()
 *                 .ruleConfiguration(LateDataRuleConfigurationProperty.builder()
 *                         .deltaTimeSessionWindowConfiguration(DeltaTimeSessionWindowConfigurationProperty.builder()
 *                                 .timeoutInMinutes(123)
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .ruleName("ruleName")
 *                 .build()))
 *         .retentionPeriod(RetentionPeriodProperty.builder()
 *                 .numberOfDays(123)
 *                 .unlimited(false)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .triggers(List.of(TriggerProperty.builder()
 *                 .schedule(ScheduleProperty.builder()
 *                         .scheduleExpression("scheduleExpression")
 *                         .build())
 *                 .triggeringDataset(TriggeringDatasetProperty.builder()
 *                         .datasetName("datasetName")
 *                         .build())
 *                 .build()))
 *         .versioningConfiguration(VersioningConfigurationProperty.builder()
 *                 .maxVersions(123)
 *                 .unlimited(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:25.909Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDatasetProps")
@software.amazon.jsii.Jsii.Proxy(CfnDatasetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDatasetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The <code>DatasetAction</code> objects that automatically create the dataset contents.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-actions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getActions();

    /**
     * When dataset contents are created they are delivered to destinations specified here.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-contentdeliveryrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-contentdeliveryrules</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getContentDeliveryRules() {
        return null;
    }

    /**
     * The name of the dataset.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-datasetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-datasetname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDatasetName() {
        return null;
    }

    /**
     * A list of data rules that send notifications to CloudWatch, when data arrives late.
     * <p>
     * To specify <code>lateDataRules</code> , the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-latedatarules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-latedatarules</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLateDataRules() {
        return null;
    }

    /**
     * Optional.
     * <p>
     * How long, in days, message data is kept for the dataset.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-retentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-retentionperiod</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRetentionPeriod() {
        return null;
    }

    /**
     * Metadata which can be used to manage the data set.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The <code>DatasetTrigger</code> objects that specify when the dataset is automatically updated.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-triggers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-triggers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTriggers() {
        return null;
    }

    /**
     * Optional.
     * <p>
     * How many versions of dataset contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the <code>retentionPeriod</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">Keeping Multiple Versions of AWS IoT Analytics datasets</a> in the <em>AWS IoT Analytics User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-versioningconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-versioningconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVersioningConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDatasetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDatasetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDatasetProps> {
        java.lang.Object actions;
        java.lang.Object contentDeliveryRules;
        java.lang.String datasetName;
        java.lang.Object lateDataRules;
        java.lang.Object retentionPeriod;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object triggers;
        java.lang.Object versioningConfiguration;

        /**
         * Sets the value of {@link CfnDatasetProps#getActions}
         * @param actions The <code>DatasetAction</code> objects that automatically create the dataset contents. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(software.amazon.awscdk.IResolvable actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatasetProps#getActions}
         * @param actions The <code>DatasetAction</code> objects that automatically create the dataset contents. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(java.util.List<? extends java.lang.Object> actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatasetProps#getContentDeliveryRules}
         * @param contentDeliveryRules When dataset contents are created they are delivered to destinations specified here.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentDeliveryRules(software.amazon.awscdk.IResolvable contentDeliveryRules) {
            this.contentDeliveryRules = contentDeliveryRules;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatasetProps#getContentDeliveryRules}
         * @param contentDeliveryRules When dataset contents are created they are delivered to destinations specified here.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentDeliveryRules(java.util.List<? extends java.lang.Object> contentDeliveryRules) {
            this.contentDeliveryRules = contentDeliveryRules;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatasetProps#getDatasetName}
         * @param datasetName The name of the dataset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datasetName(java.lang.String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatasetProps#getLateDataRules}
         * @param lateDataRules A list of data rules that send notifications to CloudWatch, when data arrives late.
         *                      To specify <code>lateDataRules</code> , the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lateDataRules(software.amazon.awscdk.IResolvable lateDataRules) {
            this.lateDataRules = lateDataRules;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatasetProps#getLateDataRules}
         * @param lateDataRules A list of data rules that send notifications to CloudWatch, when data arrives late.
         *                      To specify <code>lateDataRules</code> , the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lateDataRules(java.util.List<? extends java.lang.Object> lateDataRules) {
            this.lateDataRules = lateDataRules;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatasetProps#getRetentionPeriod}
         * @param retentionPeriod Optional.
         *                        How long, in days, message data is kept for the dataset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(software.amazon.awscdk.IResolvable retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatasetProps#getRetentionPeriod}
         * @param retentionPeriod Optional.
         *                        How long, in days, message data is kept for the dataset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(software.amazon.awscdk.services.iotanalytics.CfnDataset.RetentionPeriodProperty retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatasetProps#getTags}
         * @param tags Metadata which can be used to manage the data set.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatasetProps#getTriggers}
         * @param triggers The <code>DatasetTrigger</code> objects that specify when the dataset is automatically updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggers(software.amazon.awscdk.IResolvable triggers) {
            this.triggers = triggers;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatasetProps#getTriggers}
         * @param triggers The <code>DatasetTrigger</code> objects that specify when the dataset is automatically updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggers(java.util.List<? extends java.lang.Object> triggers) {
            this.triggers = triggers;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatasetProps#getVersioningConfiguration}
         * @param versioningConfiguration Optional.
         *                                How many versions of dataset contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the <code>retentionPeriod</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">Keeping Multiple Versions of AWS IoT Analytics datasets</a> in the <em>AWS IoT Analytics User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versioningConfiguration(software.amazon.awscdk.IResolvable versioningConfiguration) {
            this.versioningConfiguration = versioningConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatasetProps#getVersioningConfiguration}
         * @param versioningConfiguration Optional.
         *                                How many versions of dataset contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the <code>retentionPeriod</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">Keeping Multiple Versions of AWS IoT Analytics datasets</a> in the <em>AWS IoT Analytics User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versioningConfiguration(software.amazon.awscdk.services.iotanalytics.CfnDataset.VersioningConfigurationProperty versioningConfiguration) {
            this.versioningConfiguration = versioningConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDatasetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDatasetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDatasetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDatasetProps {
        private final java.lang.Object actions;
        private final java.lang.Object contentDeliveryRules;
        private final java.lang.String datasetName;
        private final java.lang.Object lateDataRules;
        private final java.lang.Object retentionPeriod;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object triggers;
        private final java.lang.Object versioningConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.contentDeliveryRules = software.amazon.jsii.Kernel.get(this, "contentDeliveryRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.datasetName = software.amazon.jsii.Kernel.get(this, "datasetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lateDataRules = software.amazon.jsii.Kernel.get(this, "lateDataRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.retentionPeriod = software.amazon.jsii.Kernel.get(this, "retentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.triggers = software.amazon.jsii.Kernel.get(this, "triggers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.versioningConfiguration = software.amazon.jsii.Kernel.get(this, "versioningConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
            this.contentDeliveryRules = builder.contentDeliveryRules;
            this.datasetName = builder.datasetName;
            this.lateDataRules = builder.lateDataRules;
            this.retentionPeriod = builder.retentionPeriod;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.triggers = builder.triggers;
            this.versioningConfiguration = builder.versioningConfiguration;
        }

        @Override
        public final java.lang.Object getActions() {
            return this.actions;
        }

        @Override
        public final java.lang.Object getContentDeliveryRules() {
            return this.contentDeliveryRules;
        }

        @Override
        public final java.lang.String getDatasetName() {
            return this.datasetName;
        }

        @Override
        public final java.lang.Object getLateDataRules() {
            return this.lateDataRules;
        }

        @Override
        public final java.lang.Object getRetentionPeriod() {
            return this.retentionPeriod;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTriggers() {
            return this.triggers;
        }

        @Override
        public final java.lang.Object getVersioningConfiguration() {
            return this.versioningConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("actions", om.valueToTree(this.getActions()));
            if (this.getContentDeliveryRules() != null) {
                data.set("contentDeliveryRules", om.valueToTree(this.getContentDeliveryRules()));
            }
            if (this.getDatasetName() != null) {
                data.set("datasetName", om.valueToTree(this.getDatasetName()));
            }
            if (this.getLateDataRules() != null) {
                data.set("lateDataRules", om.valueToTree(this.getLateDataRules()));
            }
            if (this.getRetentionPeriod() != null) {
                data.set("retentionPeriod", om.valueToTree(this.getRetentionPeriod()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTriggers() != null) {
                data.set("triggers", om.valueToTree(this.getTriggers()));
            }
            if (this.getVersioningConfiguration() != null) {
                data.set("versioningConfiguration", om.valueToTree(this.getVersioningConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDatasetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDatasetProps.Jsii$Proxy that = (CfnDatasetProps.Jsii$Proxy) o;

            if (!actions.equals(that.actions)) return false;
            if (this.contentDeliveryRules != null ? !this.contentDeliveryRules.equals(that.contentDeliveryRules) : that.contentDeliveryRules != null) return false;
            if (this.datasetName != null ? !this.datasetName.equals(that.datasetName) : that.datasetName != null) return false;
            if (this.lateDataRules != null ? !this.lateDataRules.equals(that.lateDataRules) : that.lateDataRules != null) return false;
            if (this.retentionPeriod != null ? !this.retentionPeriod.equals(that.retentionPeriod) : that.retentionPeriod != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.triggers != null ? !this.triggers.equals(that.triggers) : that.triggers != null) return false;
            return this.versioningConfiguration != null ? this.versioningConfiguration.equals(that.versioningConfiguration) : that.versioningConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.actions.hashCode();
            result = 31 * result + (this.contentDeliveryRules != null ? this.contentDeliveryRules.hashCode() : 0);
            result = 31 * result + (this.datasetName != null ? this.datasetName.hashCode() : 0);
            result = 31 * result + (this.lateDataRules != null ? this.lateDataRules.hashCode() : 0);
            result = 31 * result + (this.retentionPeriod != null ? this.retentionPeriod.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.triggers != null ? this.triggers.hashCode() : 0);
            result = 31 * result + (this.versioningConfiguration != null ? this.versioningConfiguration.hashCode() : 0);
            return result;
        }
    }
}
