package software.amazon.awscdk.services.lambda.eventsources;

/**
 * Use an Amazon SQS queue as an event source for AWS Lambda.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.eventsources.*;
 * import software.amazon.awscdk.services.sqs.*;
 * Function fn;
 * Queue queue = new Queue(this, "Queue");
 * fn.addEventSource(new SqsEventSource(queue));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:26.900Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda_event_sources.SqsEventSource")
public class SqsEventSource extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.IEventSource {

    protected SqsEventSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SqsEventSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param queue This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SqsEventSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue queue, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.eventsources.SqsEventSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(queue, "queue is required"), props });
    }

    /**
     * @param queue This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SqsEventSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue queue) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(queue, "queue is required") });
    }

    /**
     * Called by <code>lambda.addEventSource</code> to allow the event source to bind to this function.
     * <p>
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction target) {
        software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * The ARN for this EventSourceMapping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEventSourceMappingArn() {
        return software.amazon.jsii.Kernel.get(this, "eventSourceMappingArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier for this EventSourceMapping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEventSourceMappingId() {
        return software.amazon.jsii.Kernel.get(this, "eventSourceMappingId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue getQueue() {
        return software.amazon.jsii.Kernel.get(this, "queue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.eventsources.SqsEventSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.eventsources.SqsEventSource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param queue This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.sqs.IQueue queue) {
            return new Builder(queue);
        }

        private final software.amazon.awscdk.services.sqs.IQueue queue;
        private software.amazon.awscdk.services.lambda.eventsources.SqsEventSourceProps.Builder props;

        private Builder(final software.amazon.awscdk.services.sqs.IQueue queue) {
            this.queue = queue;
        }

        /**
         * The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
         * <p>
         * Your function receives an
         * event with all the retrieved records.
         * <p>
         * Valid Range: Minimum value of 1. Maximum value of 10.
         * If <code>maxBatchingWindow</code> is configured, this value can go up to 10,000.
         * <p>
         * Default: 10
         * <p>
         * @return {@code this}
         * @param batchSize The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchSize(final java.lang.Number batchSize) {
            this.props().batchSize(batchSize);
            return this;
        }

        /**
         * If the SQS event source mapping should be enabled.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled If the SQS event source mapping should be enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props().enabled(enabled);
            return this;
        }

        /**
         * Add Customer managed KMS key to encrypt Filter Criteria.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk</a>
         * @param filterEncryption Add Customer managed KMS key to encrypt Filter Criteria. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterEncryption(final software.amazon.awscdk.services.kms.IKey filterEncryption) {
            this.props().filterEncryption(filterEncryption);
            return this;
        }

        /**
         * Add filter criteria option.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param filters Add filter criteria option. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filters(final java.util.List<? extends java.util.Map<java.lang.String, ? extends java.lang.Object>> filters) {
            this.props().filters(filters);
            return this;
        }

        /**
         * The maximum amount of time to gather records before invoking the function.
         * <p>
         * Valid Range: Minimum value of 0 minutes. Maximum value of 5 minutes.
         * <p>
         * Default: - no batching window. The lambda function will be invoked immediately with the records that are available.
         * <p>
         * @return {@code this}
         * @param maxBatchingWindow The maximum amount of time to gather records before invoking the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatchingWindow(final software.amazon.awscdk.Duration maxBatchingWindow) {
            this.props().maxBatchingWindow(maxBatchingWindow);
            return this;
        }

        /**
         * The maximum concurrency setting limits the number of concurrent instances of the function that an Amazon SQS event source can invoke.
         * <p>
         * Default: - No specific limit.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency
         * Valid Range: Minimum value of 2. Maximum value of 1000.">https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency
         * Valid Range: Minimum value of 2. Maximum value of 1000.</a>
         * @param maxConcurrency The maximum concurrency setting limits the number of concurrent instances of the function that an Amazon SQS event source can invoke. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConcurrency(final java.lang.Number maxConcurrency) {
            this.props().maxConcurrency(maxConcurrency);
            return this;
        }

        /**
         * Configuration for enhanced monitoring metrics collection When specified, enables collection of additional metrics for the stream event source.
         * <p>
         * Default: - Enhanced monitoring is disabled
         * <p>
         * @return {@code this}
         * @param metricsConfig Configuration for enhanced monitoring metrics collection When specified, enables collection of additional metrics for the stream event source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricsConfig(final software.amazon.awscdk.services.lambda.MetricsConfig metricsConfig) {
            this.props().metricsConfig(metricsConfig);
            return this;
        }

        /**
         * Allow functions to return partially successful responses for a batch of records.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-batchfailurereporting">https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-batchfailurereporting</a>
         * @param reportBatchItemFailures Allow functions to return partially successful responses for a batch of records. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportBatchItemFailures(final java.lang.Boolean reportBatchItemFailures) {
            this.props().reportBatchItemFailures(reportBatchItemFailures);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.lambda.eventsources.SqsEventSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.eventsources.SqsEventSource build() {
            return new software.amazon.awscdk.services.lambda.eventsources.SqsEventSource(
                this.queue,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.lambda.eventsources.SqsEventSourceProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.lambda.eventsources.SqsEventSourceProps.Builder();
            }
            return this.props;
        }
    }
}
