package software.amazon.awscdk.services.logs;

/**
 * Properties for a LogGroup.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kinesisfirehose.alpha.*;
 * import software.amazon.awscdk.services.kinesisfirehose.destinations.alpha.*;
 * LogGroup logGroupDestination = LogGroup.Builder.create(this, "LogGroupLambdaAudit")
 *         .logGroupName("auditDestinationForCDK")
 *         .build();
 * Bucket bucket = new Bucket(this, "audit-bucket");
 * S3Bucket s3Destination = new S3Bucket(bucket);
 * DeliveryStream deliveryStream = DeliveryStream.Builder.create(this, "Delivery Stream")
 *         .destination(s3Destination)
 *         .build();
 * DataProtectionPolicy dataProtectionPolicy = DataProtectionPolicy.Builder.create()
 *         .name("data protection policy")
 *         .description("policy description")
 *         .identifiers(List.of(DataIdentifier.DRIVERSLICENSE_US,  // managed data identifier
 *             new DataIdentifier("EmailAddress"),  // forward compatibility for new managed data identifiers
 *             new CustomDataIdentifier("EmployeeId", "EmployeeId-\\d{9}"))) // custom data identifier
 *         .logGroupAuditDestination(logGroupDestination)
 *         .s3BucketAuditDestination(bucket)
 *         .deliveryStreamNameAuditDestination(deliveryStream.getDeliveryStreamName())
 *         .build();
 * LogGroup.Builder.create(this, "LogGroupLambda")
 *         .logGroupName("cdkIntegLogGroup")
 *         .dataProtectionPolicy(dataProtectionPolicy)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:27.201Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.LogGroupProps")
@software.amazon.jsii.Jsii.Proxy(LogGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LogGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Data Protection Policy for this log group.
     * <p>
     * Default: - no data protection policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.DataProtectionPolicy getDataProtectionPolicy() {
        return null;
    }

    /**
     * The KMS customer managed key to encrypt the log group with.
     * <p>
     * Default: Server-side encryption managed by the CloudWatch Logs service
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * The class of the log group. Possible values are: STANDARD and INFREQUENT_ACCESS.
     * <p>
     * INFREQUENT_ACCESS class provides customers a cost-effective way to consolidate
     * logs which supports querying using Logs Insights. The logGroupClass property cannot
     * be changed once the log group is created.
     * <p>
     * Default: LogGroupClass.STANDARD
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.LogGroupClass getLogGroupClass() {
        return null;
    }

    /**
     * Name of the log group.
     * <p>
     * Default: Automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogGroupName() {
        return null;
    }

    /**
     * Determine the removal policy of this log group.
     * <p>
     * Normally you want to retain the log group so you can diagnose issues
     * from logs even after a deployment that no longer includes the log group.
     * In that case, use the normal date-based retention policy to age out your
     * logs.
     * <p>
     * Default: RemovalPolicy.Retain
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * How long, in days, the log contents will be retained.
     * <p>
     * To retain all logs, set this value to RetentionDays.INFINITE.
     * <p>
     * Default: RetentionDays.TWO_YEARS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.RetentionDays getRetention() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LogGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LogGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LogGroupProps> {
        software.amazon.awscdk.services.logs.DataProtectionPolicy dataProtectionPolicy;
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        software.amazon.awscdk.services.logs.LogGroupClass logGroupClass;
        java.lang.String logGroupName;
        software.amazon.awscdk.RemovalPolicy removalPolicy;
        software.amazon.awscdk.services.logs.RetentionDays retention;

        /**
         * Sets the value of {@link LogGroupProps#getDataProtectionPolicy}
         * @param dataProtectionPolicy Data Protection Policy for this log group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataProtectionPolicy(software.amazon.awscdk.services.logs.DataProtectionPolicy dataProtectionPolicy) {
            this.dataProtectionPolicy = dataProtectionPolicy;
            return this;
        }

        /**
         * Sets the value of {@link LogGroupProps#getEncryptionKey}
         * @param encryptionKey The KMS customer managed key to encrypt the log group with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link LogGroupProps#getLogGroupClass}
         * @param logGroupClass The class of the log group. Possible values are: STANDARD and INFREQUENT_ACCESS.
         *                      INFREQUENT_ACCESS class provides customers a cost-effective way to consolidate
         *                      logs which supports querying using Logs Insights. The logGroupClass property cannot
         *                      be changed once the log group is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupClass(software.amazon.awscdk.services.logs.LogGroupClass logGroupClass) {
            this.logGroupClass = logGroupClass;
            return this;
        }

        /**
         * Sets the value of {@link LogGroupProps#getLogGroupName}
         * @param logGroupName Name of the log group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupName(java.lang.String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        /**
         * Sets the value of {@link LogGroupProps#getRemovalPolicy}
         * @param removalPolicy Determine the removal policy of this log group.
         *                      Normally you want to retain the log group so you can diagnose issues
         *                      from logs even after a deployment that no longer includes the log group.
         *                      In that case, use the normal date-based retention policy to age out your
         *                      logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link LogGroupProps#getRetention}
         * @param retention How long, in days, the log contents will be retained.
         *                  To retain all logs, set this value to RetentionDays.INFINITE.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retention(software.amazon.awscdk.services.logs.RetentionDays retention) {
            this.retention = retention;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LogGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LogGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LogGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogGroupProps {
        private final software.amazon.awscdk.services.logs.DataProtectionPolicy dataProtectionPolicy;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final software.amazon.awscdk.services.logs.LogGroupClass logGroupClass;
        private final java.lang.String logGroupName;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;
        private final software.amazon.awscdk.services.logs.RetentionDays retention;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataProtectionPolicy = software.amazon.jsii.Kernel.get(this, "dataProtectionPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataProtectionPolicy.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.logGroupClass = software.amazon.jsii.Kernel.get(this, "logGroupClass", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.LogGroupClass.class));
            this.logGroupName = software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.retention = software.amazon.jsii.Kernel.get(this, "retention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.RetentionDays.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataProtectionPolicy = builder.dataProtectionPolicy;
            this.encryptionKey = builder.encryptionKey;
            this.logGroupClass = builder.logGroupClass;
            this.logGroupName = builder.logGroupName;
            this.removalPolicy = builder.removalPolicy;
            this.retention = builder.retention;
        }

        @Override
        public final software.amazon.awscdk.services.logs.DataProtectionPolicy getDataProtectionPolicy() {
            return this.dataProtectionPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final software.amazon.awscdk.services.logs.LogGroupClass getLogGroupClass() {
            return this.logGroupClass;
        }

        @Override
        public final java.lang.String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.logs.RetentionDays getRetention() {
            return this.retention;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDataProtectionPolicy() != null) {
                data.set("dataProtectionPolicy", om.valueToTree(this.getDataProtectionPolicy()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getLogGroupClass() != null) {
                data.set("logGroupClass", om.valueToTree(this.getLogGroupClass()));
            }
            if (this.getLogGroupName() != null) {
                data.set("logGroupName", om.valueToTree(this.getLogGroupName()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getRetention() != null) {
                data.set("retention", om.valueToTree(this.getRetention()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.LogGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LogGroupProps.Jsii$Proxy that = (LogGroupProps.Jsii$Proxy) o;

            if (this.dataProtectionPolicy != null ? !this.dataProtectionPolicy.equals(that.dataProtectionPolicy) : that.dataProtectionPolicy != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.logGroupClass != null ? !this.logGroupClass.equals(that.logGroupClass) : that.logGroupClass != null) return false;
            if (this.logGroupName != null ? !this.logGroupName.equals(that.logGroupName) : that.logGroupName != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            return this.retention != null ? this.retention.equals(that.retention) : that.retention == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dataProtectionPolicy != null ? this.dataProtectionPolicy.hashCode() : 0;
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.logGroupClass != null ? this.logGroupClass.hashCode() : 0);
            result = 31 * result + (this.logGroupName != null ? this.logGroupName.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.retention != null ? this.retention.hashCode() : 0);
            return result;
        }
    }
}
