package software.amazon.awscdk.services.rds;

/**
 * Construction properties for a DatabaseInstanceNew.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.services.logs.*;
 * import software.amazon.awscdk.services.rds.*;
 * import software.amazon.awscdk.services.s3.*;
 * Bucket bucket;
 * CaCertificate caCertificate;
 * Key key;
 * OptionGroup optionGroup;
 * ParameterGroup parameterGroup;
 * Role role;
 * SecurityGroup securityGroup;
 * Subnet subnet;
 * SubnetFilter subnetFilter;
 * SubnetGroup subnetGroup;
 * Vpc vpc;
 * DatabaseInstanceNewProps databaseInstanceNewProps = DatabaseInstanceNewProps.builder()
 *         .vpc(vpc)
 *         // the properties below are optional
 *         .applyImmediately(false)
 *         .autoMinorVersionUpgrade(false)
 *         .availabilityZone("availabilityZone")
 *         .backupRetention(Duration.minutes(30))
 *         .caCertificate(caCertificate)
 *         .cloudwatchLogsExports(List.of("cloudwatchLogsExports"))
 *         .cloudwatchLogsRetention(RetentionDays.ONE_DAY)
 *         .cloudwatchLogsRetentionRole(role)
 *         .copyTagsToSnapshot(false)
 *         .deleteAutomatedBackups(false)
 *         .deletionProtection(false)
 *         .domain("domain")
 *         .domainRole(role)
 *         .enablePerformanceInsights(false)
 *         .iamAuthentication(false)
 *         .instanceIdentifier("instanceIdentifier")
 *         .iops(123)
 *         .maxAllocatedStorage(123)
 *         .monitoringInterval(Duration.minutes(30))
 *         .monitoringRole(role)
 *         .multiAz(false)
 *         .networkType(NetworkType.IPV4)
 *         .optionGroup(optionGroup)
 *         .parameterGroup(parameterGroup)
 *         .performanceInsightEncryptionKey(key)
 *         .performanceInsightRetention(PerformanceInsightRetention.DEFAULT)
 *         .port(123)
 *         .preferredBackupWindow("preferredBackupWindow")
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .processorFeatures(ProcessorFeatures.builder()
 *                 .coreCount(123)
 *                 .threadsPerCore(123)
 *                 .build())
 *         .publiclyAccessible(false)
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .s3ExportBuckets(List.of(bucket))
 *         .s3ExportRole(role)
 *         .s3ImportBuckets(List.of(bucket))
 *         .s3ImportRole(role)
 *         .securityGroups(List.of(securityGroup))
 *         .storageThroughput(123)
 *         .storageType(StorageType.STANDARD)
 *         .subnetGroup(subnetGroup)
 *         .vpcSubnets(SubnetSelection.builder()
 *                 .availabilityZones(List.of("availabilityZones"))
 *                 .onePerAz(false)
 *                 .subnetFilters(List.of(subnetFilter))
 *                 .subnetGroupName("subnetGroupName")
 *                 .subnets(List.of(subnet))
 *                 .subnetType(SubnetType.PRIVATE_ISOLATED)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:31.588Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.DatabaseInstanceNewProps")
@software.amazon.jsii.Jsii.Proxy(DatabaseInstanceNewProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DatabaseInstanceNewProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The VPC network where the DB subnet group should be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * Specifies whether changes to the DB instance and any pending modifications are applied immediately, regardless of the <code>preferredMaintenanceWindow</code> setting.
     * <p>
     * If set to <code>false</code>, changes are applied during the next maintenance window.
     * <p>
     * Until RDS applies the changes, the DB instance remains in a drift state.
     * As a result, the configuration doesn't fully reflect the requested modifications and temporarily diverges from the intended state.
     * <p>
     * This property also determines whether the DB instance reboots when a static parameter is modified in the associated DB parameter group.
     * <p>
     * Default: - Changes will be applied immediately
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html">https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getApplyImmediately() {
        return null;
    }

    /**
     * Indicates that minor engine upgrades are applied automatically to the DB instance during the maintenance window.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAutoMinorVersionUpgrade() {
        return null;
    }

    /**
     * The name of the Availability Zone where the DB instance will be located.
     * <p>
     * Default: - no preference
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return null;
    }

    /**
     * The number of days during which automatic DB snapshots are retained.
     * <p>
     * Set to zero to disable backups.
     * When creating a read replica, you must enable automatic backups on the source
     * database instance by setting the backup retention to a value other than zero.
     * <p>
     * Default: - Duration.days(1) for source instances, disabled for read replicas
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getBackupRetention() {
        return null;
    }

    /**
     * The identifier of the CA certificate for this DB instance.
     * <p>
     * Specifying or updating this property triggers a reboot.
     * <p>
     * For RDS DB engines:
     * <p>
     * Default: - RDS will choose a certificate authority
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.CaCertificate getCaCertificate() {
        return null;
    }

    /**
     * The list of log types that need to be enabled for exporting to CloudWatch Logs.
     * <p>
     * Default: - no log exports
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCloudwatchLogsExports() {
        return null;
    }

    /**
     * The number of days log events are kept in CloudWatch Logs.
     * <p>
     * When updating
     * this property, unsetting it doesn't remove the log retention policy. To
     * remove the retention policy, set the value to <code>Infinity</code>.
     * <p>
     * Default: - logs never expire
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.RetentionDays getCloudwatchLogsRetention() {
        return null;
    }

    /**
     * The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
     * <p>
     * Default: - a new role is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getCloudwatchLogsRetentionRole() {
        return null;
    }

    /**
     * Indicates whether to copy all of the user-defined tags from the DB instance to snapshots of the DB instance.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCopyTagsToSnapshot() {
        return null;
    }

    /**
     * Indicates whether automated backups should be deleted or retained when you delete a DB instance.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDeleteAutomatedBackups() {
        return null;
    }

    /**
     * Indicates whether the DB instance should have deletion protection enabled.
     * <p>
     * Default: - true if ``removalPolicy`` is RETAIN, false otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDeletionProtection() {
        return null;
    }

    /**
     * The Active Directory directory ID to create the DB instance in.
     * <p>
     * Default: - Do not join domain
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomain() {
        return null;
    }

    /**
     * The IAM role to be used when making API calls to the Directory Service.
     * <p>
     * The role needs the AWS-managed policy
     * AmazonRDSDirectoryServiceAccess or equivalent.
     * <p>
     * Default: - The role will be created for you if `DatabaseInstanceNewProps#domain` is specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getDomainRole() {
        return null;
    }

    /**
     * Whether to enable Performance Insights for the DB instance.
     * <p>
     * Default: - false, unless ``performanceInsightRetention`` or ``performanceInsightEncryptionKey`` is set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnablePerformanceInsights() {
        return null;
    }

    /**
     * Whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIamAuthentication() {
        return null;
    }

    /**
     * A name for the DB instance.
     * <p>
     * If you specify a name, AWS CloudFormation
     * converts it to lowercase.
     * <p>
     * Default: - a CloudFormation generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceIdentifier() {
        return null;
    }

    /**
     * The number of I/O operations per second (IOPS) that the database provisions.
     * <p>
     * The value must be equal to or greater than 1000.
     * <p>
     * Default: - no provisioned iops if storage type is not specified. For GP3: 3,000 IOPS if allocated
     * storage is less than 400 GiB for MariaDB, MySQL, and PostgreSQL, less than 200 GiB for Oracle and
     * less than 20 GiB for SQL Server. 12,000 IOPS otherwise (except for SQL Server where the default is
     * always 3,000 IOPS).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
        return null;
    }

    /**
     * Upper limit to which RDS can scale the storage in GiB(Gibibyte).
     * <p>
     * Default: - No autoscaling of RDS instance
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxAllocatedStorage() {
        return null;
    }

    /**
     * The interval, in seconds, between points when Amazon RDS collects enhanced monitoring metrics for the DB instance.
     * <p>
     * Default: - no enhanced monitoring
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMonitoringInterval() {
        return null;
    }

    /**
     * Role that will be used to manage DB instance monitoring.
     * <p>
     * Default: - A role is automatically created for you
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getMonitoringRole() {
        return null;
    }

    /**
     * Specifies if the database instance is a multiple Availability Zone deployment.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMultiAz() {
        return null;
    }

    /**
     * The network type of the DB instance.
     * <p>
     * Default: - IPV4
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.NetworkType getNetworkType() {
        return null;
    }

    /**
     * The option group to associate with the instance.
     * <p>
     * Default: - no option group
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.IOptionGroup getOptionGroup() {
        return null;
    }

    /**
     * The DB parameter group to associate with the instance.
     * <p>
     * Default: - no parameter group
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.IParameterGroup getParameterGroup() {
        return null;
    }

    /**
     * The AWS KMS key for encryption of Performance Insights data.
     * <p>
     * Default: - default master key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getPerformanceInsightEncryptionKey() {
        return null;
    }

    /**
     * The amount of time, in days, to retain Performance Insights data.
     * <p>
     * Default: 7 this is the free tier
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.PerformanceInsightRetention getPerformanceInsightRetention() {
        return null;
    }

    /**
     * The port for the instance.
     * <p>
     * Default: - the default port for the chosen engine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * The daily time range during which automated backups are performed.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be in the format <code>hh24:mi-hh24:mi</code>.</li>
     * <li>Must be in Universal Coordinated Time (UTC).</li>
     * <li>Must not conflict with the preferred maintenance window.</li>
     * <li>Must be at least 30 minutes.</li>
     * </ul>
     * <p>
     * Default: - a 30-minute window selected at random from an 8-hour block of
     * time for each AWS Region. To see the time blocks available, see
     * https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredBackupWindow() {
        return null;
    }

    /**
     * The weekly time range (in UTC) during which system maintenance can occur.
     * <p>
     * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * Constraint: Minimum 30-minute window
     * <p>
     * Default: - a 30-minute window selected at random from an 8-hour block of
     * time for each AWS Region, occurring on a random day of the week. To see
     * the time blocks available, see https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return null;
    }

    /**
     * The number of CPU cores and the number of threads per core.
     * <p>
     * Default: - the default number of CPU cores and threads per core for the
     * chosen instance class.
     * See https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.ProcessorFeatures getProcessorFeatures() {
        return null;
    }

    /**
     * Indicates whether the DB instance is an internet-facing instance.
     * <p>
     * If not specified,
     * the instance's vpcSubnets will be used to determine if the instance is internet-facing
     * or not.
     * <p>
     * Default: - `true` if the instance's `vpcSubnets` is `subnetType: SubnetType.PUBLIC`, `false` otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPubliclyAccessible() {
        return null;
    }

    /**
     * The CloudFormation policy to apply when the instance is removed from the stack or replaced during an update.
     * <p>
     * Default: - RemovalPolicy.SNAPSHOT (remove the resource, but retain a snapshot of the data)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * S3 buckets that you want to load data into.
     * <p>
     * This property must not be used if <code>s3ExportRole</code> is used.
     * <p>
     * For Microsoft SQL Server:
     * <p>
     * Default: - None
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-s3-integration.html">https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-s3-integration.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.s3.IBucket> getS3ExportBuckets() {
        return null;
    }

    /**
     * Role that will be associated with this DB instance to enable S3 export.
     * <p>
     * This property must not be used if <code>s3ExportBuckets</code> is used.
     * <p>
     * For Microsoft SQL Server:
     * <p>
     * Default: - New role is created if `s3ExportBuckets` is set, no role is defined otherwise
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-s3-integration.html">https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-s3-integration.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getS3ExportRole() {
        return null;
    }

    /**
     * S3 buckets that you want to load data from.
     * <p>
     * This feature is only supported by the Microsoft SQL Server, Oracle, and PostgreSQL engines.
     * <p>
     * This property must not be used if <code>s3ImportRole</code> is used.
     * <p>
     * For Microsoft SQL Server:
     * <p>
     * Default: - None
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/PostgreSQL.Procedural.Importing.html">https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/PostgreSQL.Procedural.Importing.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.s3.IBucket> getS3ImportBuckets() {
        return null;
    }

    /**
     * Role that will be associated with this DB instance to enable S3 import.
     * <p>
     * This feature is only supported by the Microsoft SQL Server, Oracle, and PostgreSQL engines.
     * <p>
     * This property must not be used if <code>s3ImportBuckets</code> is used.
     * <p>
     * For Microsoft SQL Server:
     * <p>
     * Default: - New role is created if `s3ImportBuckets` is set, no role is defined otherwise
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/PostgreSQL.Procedural.Importing.html">https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/PostgreSQL.Procedural.Importing.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getS3ImportRole() {
        return null;
    }

    /**
     * The security groups to assign to the DB instance.
     * <p>
     * Default: - a new security group is created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * The storage throughput, specified in mebibytes per second (MiBps).
     * <p>
     * Only applicable for GP3.
     * <p>
     * Default: - 125 MiBps if allocated storage is less than 400 GiB for MariaDB, MySQL, and PostgreSQL,
     * less than 200 GiB for Oracle and less than 20 GiB for SQL Server. 500 MiBps otherwise (except for
     * SQL Server where the default is always 125 MiBps).
     * <p>
     * @see <a href="https://docs.aws.amazon.com//AmazonRDS/latest/UserGuide/CHAP_Storage.html#gp3-storage">https://docs.aws.amazon.com//AmazonRDS/latest/UserGuide/CHAP_Storage.html#gp3-storage</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getStorageThroughput() {
        return null;
    }

    /**
     * The storage type.
     * <p>
     * Storage types supported are gp2, io1, standard.
     * <p>
     * Default: GP2
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#Concepts.Storage.GeneralSSD">https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#Concepts.Storage.GeneralSSD</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.StorageType getStorageType() {
        return null;
    }

    /**
     * Existing subnet group for the instance.
     * <p>
     * Default: - a new subnet group will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.ISubnetGroup getSubnetGroup() {
        return null;
    }

    /**
     * The type of subnets to add to the created DB subnet group.
     * <p>
     * Default: - private subnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DatabaseInstanceNewProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DatabaseInstanceNewProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DatabaseInstanceNewProps> {
        software.amazon.awscdk.services.ec2.IVpc vpc;
        java.lang.Boolean applyImmediately;
        java.lang.Boolean autoMinorVersionUpgrade;
        java.lang.String availabilityZone;
        software.amazon.awscdk.Duration backupRetention;
        software.amazon.awscdk.services.rds.CaCertificate caCertificate;
        java.util.List<java.lang.String> cloudwatchLogsExports;
        software.amazon.awscdk.services.logs.RetentionDays cloudwatchLogsRetention;
        software.amazon.awscdk.services.iam.IRole cloudwatchLogsRetentionRole;
        java.lang.Boolean copyTagsToSnapshot;
        java.lang.Boolean deleteAutomatedBackups;
        java.lang.Boolean deletionProtection;
        java.lang.String domain;
        software.amazon.awscdk.services.iam.IRole domainRole;
        java.lang.Boolean enablePerformanceInsights;
        java.lang.Boolean iamAuthentication;
        java.lang.String instanceIdentifier;
        java.lang.Number iops;
        java.lang.Number maxAllocatedStorage;
        software.amazon.awscdk.Duration monitoringInterval;
        software.amazon.awscdk.services.iam.IRole monitoringRole;
        java.lang.Boolean multiAz;
        software.amazon.awscdk.services.rds.NetworkType networkType;
        software.amazon.awscdk.services.rds.IOptionGroup optionGroup;
        software.amazon.awscdk.services.rds.IParameterGroup parameterGroup;
        software.amazon.awscdk.services.kms.IKey performanceInsightEncryptionKey;
        software.amazon.awscdk.services.rds.PerformanceInsightRetention performanceInsightRetention;
        java.lang.Number port;
        java.lang.String preferredBackupWindow;
        java.lang.String preferredMaintenanceWindow;
        software.amazon.awscdk.services.rds.ProcessorFeatures processorFeatures;
        java.lang.Boolean publiclyAccessible;
        software.amazon.awscdk.RemovalPolicy removalPolicy;
        java.util.List<software.amazon.awscdk.services.s3.IBucket> s3ExportBuckets;
        software.amazon.awscdk.services.iam.IRole s3ExportRole;
        java.util.List<software.amazon.awscdk.services.s3.IBucket> s3ImportBuckets;
        software.amazon.awscdk.services.iam.IRole s3ImportRole;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        java.lang.Number storageThroughput;
        software.amazon.awscdk.services.rds.StorageType storageType;
        software.amazon.awscdk.services.rds.ISubnetGroup subnetGroup;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getVpc}
         * @param vpc The VPC network where the DB subnet group should be created. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getApplyImmediately}
         * @param applyImmediately Specifies whether changes to the DB instance and any pending modifications are applied immediately, regardless of the <code>preferredMaintenanceWindow</code> setting.
         *                         If set to <code>false</code>, changes are applied during the next maintenance window.
         *                         <p>
         *                         Until RDS applies the changes, the DB instance remains in a drift state.
         *                         As a result, the configuration doesn't fully reflect the requested modifications and temporarily diverges from the intended state.
         *                         <p>
         *                         This property also determines whether the DB instance reboots when a static parameter is modified in the associated DB parameter group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applyImmediately(java.lang.Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getAutoMinorVersionUpgrade}
         * @param autoMinorVersionUpgrade Indicates that minor engine upgrades are applied automatically to the DB instance during the maintenance window.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(java.lang.Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getAvailabilityZone}
         * @param availabilityZone The name of the Availability Zone where the DB instance will be located.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getBackupRetention}
         * @param backupRetention The number of days during which automatic DB snapshots are retained.
         *                        Set to zero to disable backups.
         *                        When creating a read replica, you must enable automatic backups on the source
         *                        database instance by setting the backup retention to a value other than zero.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupRetention(software.amazon.awscdk.Duration backupRetention) {
            this.backupRetention = backupRetention;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getCaCertificate}
         * @param caCertificate The identifier of the CA certificate for this DB instance.
         *                      Specifying or updating this property triggers a reboot.
         *                      <p>
         *                      For RDS DB engines:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caCertificate(software.amazon.awscdk.services.rds.CaCertificate caCertificate) {
            this.caCertificate = caCertificate;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getCloudwatchLogsExports}
         * @param cloudwatchLogsExports The list of log types that need to be enabled for exporting to CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudwatchLogsExports(java.util.List<java.lang.String> cloudwatchLogsExports) {
            this.cloudwatchLogsExports = cloudwatchLogsExports;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getCloudwatchLogsRetention}
         * @param cloudwatchLogsRetention The number of days log events are kept in CloudWatch Logs.
         *                                When updating
         *                                this property, unsetting it doesn't remove the log retention policy. To
         *                                remove the retention policy, set the value to <code>Infinity</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudwatchLogsRetention(software.amazon.awscdk.services.logs.RetentionDays cloudwatchLogsRetention) {
            this.cloudwatchLogsRetention = cloudwatchLogsRetention;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getCloudwatchLogsRetentionRole}
         * @param cloudwatchLogsRetentionRole The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudwatchLogsRetentionRole(software.amazon.awscdk.services.iam.IRole cloudwatchLogsRetentionRole) {
            this.cloudwatchLogsRetentionRole = cloudwatchLogsRetentionRole;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getCopyTagsToSnapshot}
         * @param copyTagsToSnapshot Indicates whether to copy all of the user-defined tags from the DB instance to snapshots of the DB instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(java.lang.Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getDeleteAutomatedBackups}
         * @param deleteAutomatedBackups Indicates whether automated backups should be deleted or retained when you delete a DB instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteAutomatedBackups(java.lang.Boolean deleteAutomatedBackups) {
            this.deleteAutomatedBackups = deleteAutomatedBackups;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getDeletionProtection}
         * @param deletionProtection Indicates whether the DB instance should have deletion protection enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(java.lang.Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getDomain}
         * @param domain The Active Directory directory ID to create the DB instance in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(java.lang.String domain) {
            this.domain = domain;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getDomainRole}
         * @param domainRole The IAM role to be used when making API calls to the Directory Service.
         *                   The role needs the AWS-managed policy
         *                   AmazonRDSDirectoryServiceAccess or equivalent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainRole(software.amazon.awscdk.services.iam.IRole domainRole) {
            this.domainRole = domainRole;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getEnablePerformanceInsights}
         * @param enablePerformanceInsights Whether to enable Performance Insights for the DB instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePerformanceInsights(java.lang.Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getIamAuthentication}
         * @param iamAuthentication Whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamAuthentication(java.lang.Boolean iamAuthentication) {
            this.iamAuthentication = iamAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getInstanceIdentifier}
         * @param instanceIdentifier A name for the DB instance.
         *                           If you specify a name, AWS CloudFormation
         *                           converts it to lowercase.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceIdentifier(java.lang.String instanceIdentifier) {
            this.instanceIdentifier = instanceIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getIops}
         * @param iops The number of I/O operations per second (IOPS) that the database provisions.
         *             The value must be equal to or greater than 1000.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iops(java.lang.Number iops) {
            this.iops = iops;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getMaxAllocatedStorage}
         * @param maxAllocatedStorage Upper limit to which RDS can scale the storage in GiB(Gibibyte).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAllocatedStorage(java.lang.Number maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getMonitoringInterval}
         * @param monitoringInterval The interval, in seconds, between points when Amazon RDS collects enhanced monitoring metrics for the DB instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringInterval(software.amazon.awscdk.Duration monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getMonitoringRole}
         * @param monitoringRole Role that will be used to manage DB instance monitoring.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringRole(software.amazon.awscdk.services.iam.IRole monitoringRole) {
            this.monitoringRole = monitoringRole;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getMultiAz}
         * @param multiAz Specifies if the database instance is a multiple Availability Zone deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiAz(java.lang.Boolean multiAz) {
            this.multiAz = multiAz;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getNetworkType}
         * @param networkType The network type of the DB instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkType(software.amazon.awscdk.services.rds.NetworkType networkType) {
            this.networkType = networkType;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getOptionGroup}
         * @param optionGroup The option group to associate with the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optionGroup(software.amazon.awscdk.services.rds.IOptionGroup optionGroup) {
            this.optionGroup = optionGroup;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getParameterGroup}
         * @param parameterGroup The DB parameter group to associate with the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterGroup(software.amazon.awscdk.services.rds.IParameterGroup parameterGroup) {
            this.parameterGroup = parameterGroup;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getPerformanceInsightEncryptionKey}
         * @param performanceInsightEncryptionKey The AWS KMS key for encryption of Performance Insights data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceInsightEncryptionKey(software.amazon.awscdk.services.kms.IKey performanceInsightEncryptionKey) {
            this.performanceInsightEncryptionKey = performanceInsightEncryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getPerformanceInsightRetention}
         * @param performanceInsightRetention The amount of time, in days, to retain Performance Insights data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceInsightRetention(software.amazon.awscdk.services.rds.PerformanceInsightRetention performanceInsightRetention) {
            this.performanceInsightRetention = performanceInsightRetention;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getPort}
         * @param port The port for the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getPreferredBackupWindow}
         * @param preferredBackupWindow The daily time range during which automated backups are performed.
         *                              Constraints:
         *                              <p>
         *                              <ul>
         *                              <li>Must be in the format <code>hh24:mi-hh24:mi</code>.</li>
         *                              <li>Must be in Universal Coordinated Time (UTC).</li>
         *                              <li>Must not conflict with the preferred maintenance window.</li>
         *                              <li>Must be at least 30 minutes.</li>
         *                              </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredBackupWindow(java.lang.String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getPreferredMaintenanceWindow}
         * @param preferredMaintenanceWindow The weekly time range (in UTC) during which system maintenance can occur.
         *                                   Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         *                                   Constraint: Minimum 30-minute window
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(java.lang.String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getProcessorFeatures}
         * @param processorFeatures The number of CPU cores and the number of threads per core.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processorFeatures(software.amazon.awscdk.services.rds.ProcessorFeatures processorFeatures) {
            this.processorFeatures = processorFeatures;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getPubliclyAccessible}
         * @param publiclyAccessible Indicates whether the DB instance is an internet-facing instance.
         *                           If not specified,
         *                           the instance's vpcSubnets will be used to determine if the instance is internet-facing
         *                           or not.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(java.lang.Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getRemovalPolicy}
         * @param removalPolicy The CloudFormation policy to apply when the instance is removed from the stack or replaced during an update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getS3ExportBuckets}
         * @param s3ExportBuckets S3 buckets that you want to load data into.
         *                        This property must not be used if <code>s3ExportRole</code> is used.
         *                        <p>
         *                        For Microsoft SQL Server:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder s3ExportBuckets(java.util.List<? extends software.amazon.awscdk.services.s3.IBucket> s3ExportBuckets) {
            this.s3ExportBuckets = (java.util.List<software.amazon.awscdk.services.s3.IBucket>)s3ExportBuckets;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getS3ExportRole}
         * @param s3ExportRole Role that will be associated with this DB instance to enable S3 export.
         *                     This property must not be used if <code>s3ExportBuckets</code> is used.
         *                     <p>
         *                     For Microsoft SQL Server:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3ExportRole(software.amazon.awscdk.services.iam.IRole s3ExportRole) {
            this.s3ExportRole = s3ExportRole;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getS3ImportBuckets}
         * @param s3ImportBuckets S3 buckets that you want to load data from.
         *                        This feature is only supported by the Microsoft SQL Server, Oracle, and PostgreSQL engines.
         *                        <p>
         *                        This property must not be used if <code>s3ImportRole</code> is used.
         *                        <p>
         *                        For Microsoft SQL Server:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder s3ImportBuckets(java.util.List<? extends software.amazon.awscdk.services.s3.IBucket> s3ImportBuckets) {
            this.s3ImportBuckets = (java.util.List<software.amazon.awscdk.services.s3.IBucket>)s3ImportBuckets;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getS3ImportRole}
         * @param s3ImportRole Role that will be associated with this DB instance to enable S3 import.
         *                     This feature is only supported by the Microsoft SQL Server, Oracle, and PostgreSQL engines.
         *                     <p>
         *                     This property must not be used if <code>s3ImportBuckets</code> is used.
         *                     <p>
         *                     For Microsoft SQL Server:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3ImportRole(software.amazon.awscdk.services.iam.IRole s3ImportRole) {
            this.s3ImportRole = s3ImportRole;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getSecurityGroups}
         * @param securityGroups The security groups to assign to the DB instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getStorageThroughput}
         * @param storageThroughput The storage throughput, specified in mebibytes per second (MiBps).
         *                          Only applicable for GP3.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageThroughput(java.lang.Number storageThroughput) {
            this.storageThroughput = storageThroughput;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getStorageType}
         * @param storageType The storage type.
         *                    Storage types supported are gp2, io1, standard.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageType(software.amazon.awscdk.services.rds.StorageType storageType) {
            this.storageType = storageType;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getSubnetGroup}
         * @param subnetGroup Existing subnet group for the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetGroup(software.amazon.awscdk.services.rds.ISubnetGroup subnetGroup) {
            this.subnetGroup = subnetGroup;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceNewProps#getVpcSubnets}
         * @param vpcSubnets The type of subnets to add to the created DB subnet group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DatabaseInstanceNewProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DatabaseInstanceNewProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DatabaseInstanceNewProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseInstanceNewProps {
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.lang.Boolean applyImmediately;
        private final java.lang.Boolean autoMinorVersionUpgrade;
        private final java.lang.String availabilityZone;
        private final software.amazon.awscdk.Duration backupRetention;
        private final software.amazon.awscdk.services.rds.CaCertificate caCertificate;
        private final java.util.List<java.lang.String> cloudwatchLogsExports;
        private final software.amazon.awscdk.services.logs.RetentionDays cloudwatchLogsRetention;
        private final software.amazon.awscdk.services.iam.IRole cloudwatchLogsRetentionRole;
        private final java.lang.Boolean copyTagsToSnapshot;
        private final java.lang.Boolean deleteAutomatedBackups;
        private final java.lang.Boolean deletionProtection;
        private final java.lang.String domain;
        private final software.amazon.awscdk.services.iam.IRole domainRole;
        private final java.lang.Boolean enablePerformanceInsights;
        private final java.lang.Boolean iamAuthentication;
        private final java.lang.String instanceIdentifier;
        private final java.lang.Number iops;
        private final java.lang.Number maxAllocatedStorage;
        private final software.amazon.awscdk.Duration monitoringInterval;
        private final software.amazon.awscdk.services.iam.IRole monitoringRole;
        private final java.lang.Boolean multiAz;
        private final software.amazon.awscdk.services.rds.NetworkType networkType;
        private final software.amazon.awscdk.services.rds.IOptionGroup optionGroup;
        private final software.amazon.awscdk.services.rds.IParameterGroup parameterGroup;
        private final software.amazon.awscdk.services.kms.IKey performanceInsightEncryptionKey;
        private final software.amazon.awscdk.services.rds.PerformanceInsightRetention performanceInsightRetention;
        private final java.lang.Number port;
        private final java.lang.String preferredBackupWindow;
        private final java.lang.String preferredMaintenanceWindow;
        private final software.amazon.awscdk.services.rds.ProcessorFeatures processorFeatures;
        private final java.lang.Boolean publiclyAccessible;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;
        private final java.util.List<software.amazon.awscdk.services.s3.IBucket> s3ExportBuckets;
        private final software.amazon.awscdk.services.iam.IRole s3ExportRole;
        private final java.util.List<software.amazon.awscdk.services.s3.IBucket> s3ImportBuckets;
        private final software.amazon.awscdk.services.iam.IRole s3ImportRole;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final java.lang.Number storageThroughput;
        private final software.amazon.awscdk.services.rds.StorageType storageType;
        private final software.amazon.awscdk.services.rds.ISubnetGroup subnetGroup;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.applyImmediately = software.amazon.jsii.Kernel.get(this, "applyImmediately", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.autoMinorVersionUpgrade = software.amazon.jsii.Kernel.get(this, "autoMinorVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.backupRetention = software.amazon.jsii.Kernel.get(this, "backupRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.caCertificate = software.amazon.jsii.Kernel.get(this, "caCertificate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.CaCertificate.class));
            this.cloudwatchLogsExports = software.amazon.jsii.Kernel.get(this, "cloudwatchLogsExports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cloudwatchLogsRetention = software.amazon.jsii.Kernel.get(this, "cloudwatchLogsRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.RetentionDays.class));
            this.cloudwatchLogsRetentionRole = software.amazon.jsii.Kernel.get(this, "cloudwatchLogsRetentionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.copyTagsToSnapshot = software.amazon.jsii.Kernel.get(this, "copyTagsToSnapshot", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.deleteAutomatedBackups = software.amazon.jsii.Kernel.get(this, "deleteAutomatedBackups", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.deletionProtection = software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.domain = software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainRole = software.amazon.jsii.Kernel.get(this, "domainRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.enablePerformanceInsights = software.amazon.jsii.Kernel.get(this, "enablePerformanceInsights", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.iamAuthentication = software.amazon.jsii.Kernel.get(this, "iamAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.instanceIdentifier = software.amazon.jsii.Kernel.get(this, "instanceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxAllocatedStorage = software.amazon.jsii.Kernel.get(this, "maxAllocatedStorage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.monitoringInterval = software.amazon.jsii.Kernel.get(this, "monitoringInterval", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.monitoringRole = software.amazon.jsii.Kernel.get(this, "monitoringRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.multiAz = software.amazon.jsii.Kernel.get(this, "multiAz", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.networkType = software.amazon.jsii.Kernel.get(this, "networkType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.NetworkType.class));
            this.optionGroup = software.amazon.jsii.Kernel.get(this, "optionGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IOptionGroup.class));
            this.parameterGroup = software.amazon.jsii.Kernel.get(this, "parameterGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IParameterGroup.class));
            this.performanceInsightEncryptionKey = software.amazon.jsii.Kernel.get(this, "performanceInsightEncryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.performanceInsightRetention = software.amazon.jsii.Kernel.get(this, "performanceInsightRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PerformanceInsightRetention.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.preferredBackupWindow = software.amazon.jsii.Kernel.get(this, "preferredBackupWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.preferredMaintenanceWindow = software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.processorFeatures = software.amazon.jsii.Kernel.get(this, "processorFeatures", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.ProcessorFeatures.class));
            this.publiclyAccessible = software.amazon.jsii.Kernel.get(this, "publiclyAccessible", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.s3ExportBuckets = software.amazon.jsii.Kernel.get(this, "s3ExportBuckets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class)));
            this.s3ExportRole = software.amazon.jsii.Kernel.get(this, "s3ExportRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.s3ImportBuckets = software.amazon.jsii.Kernel.get(this, "s3ImportBuckets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class)));
            this.s3ImportRole = software.amazon.jsii.Kernel.get(this, "s3ImportRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.storageThroughput = software.amazon.jsii.Kernel.get(this, "storageThroughput", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.storageType = software.amazon.jsii.Kernel.get(this, "storageType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.StorageType.class));
            this.subnetGroup = software.amazon.jsii.Kernel.get(this, "subnetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.ISubnetGroup.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
            this.applyImmediately = builder.applyImmediately;
            this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
            this.availabilityZone = builder.availabilityZone;
            this.backupRetention = builder.backupRetention;
            this.caCertificate = builder.caCertificate;
            this.cloudwatchLogsExports = builder.cloudwatchLogsExports;
            this.cloudwatchLogsRetention = builder.cloudwatchLogsRetention;
            this.cloudwatchLogsRetentionRole = builder.cloudwatchLogsRetentionRole;
            this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
            this.deleteAutomatedBackups = builder.deleteAutomatedBackups;
            this.deletionProtection = builder.deletionProtection;
            this.domain = builder.domain;
            this.domainRole = builder.domainRole;
            this.enablePerformanceInsights = builder.enablePerformanceInsights;
            this.iamAuthentication = builder.iamAuthentication;
            this.instanceIdentifier = builder.instanceIdentifier;
            this.iops = builder.iops;
            this.maxAllocatedStorage = builder.maxAllocatedStorage;
            this.monitoringInterval = builder.monitoringInterval;
            this.monitoringRole = builder.monitoringRole;
            this.multiAz = builder.multiAz;
            this.networkType = builder.networkType;
            this.optionGroup = builder.optionGroup;
            this.parameterGroup = builder.parameterGroup;
            this.performanceInsightEncryptionKey = builder.performanceInsightEncryptionKey;
            this.performanceInsightRetention = builder.performanceInsightRetention;
            this.port = builder.port;
            this.preferredBackupWindow = builder.preferredBackupWindow;
            this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
            this.processorFeatures = builder.processorFeatures;
            this.publiclyAccessible = builder.publiclyAccessible;
            this.removalPolicy = builder.removalPolicy;
            this.s3ExportBuckets = (java.util.List<software.amazon.awscdk.services.s3.IBucket>)builder.s3ExportBuckets;
            this.s3ExportRole = builder.s3ExportRole;
            this.s3ImportBuckets = (java.util.List<software.amazon.awscdk.services.s3.IBucket>)builder.s3ImportBuckets;
            this.s3ImportRole = builder.s3ImportRole;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.storageThroughput = builder.storageThroughput;
            this.storageType = builder.storageType;
            this.subnetGroup = builder.subnetGroup;
            this.vpcSubnets = builder.vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final java.lang.Boolean getApplyImmediately() {
            return this.applyImmediately;
        }

        @Override
        public final java.lang.Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final software.amazon.awscdk.Duration getBackupRetention() {
            return this.backupRetention;
        }

        @Override
        public final software.amazon.awscdk.services.rds.CaCertificate getCaCertificate() {
            return this.caCertificate;
        }

        @Override
        public final java.util.List<java.lang.String> getCloudwatchLogsExports() {
            return this.cloudwatchLogsExports;
        }

        @Override
        public final software.amazon.awscdk.services.logs.RetentionDays getCloudwatchLogsRetention() {
            return this.cloudwatchLogsRetention;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getCloudwatchLogsRetentionRole() {
            return this.cloudwatchLogsRetentionRole;
        }

        @Override
        public final java.lang.Boolean getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        @Override
        public final java.lang.Boolean getDeleteAutomatedBackups() {
            return this.deleteAutomatedBackups;
        }

        @Override
        public final java.lang.Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final java.lang.String getDomain() {
            return this.domain;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getDomainRole() {
            return this.domainRole;
        }

        @Override
        public final java.lang.Boolean getEnablePerformanceInsights() {
            return this.enablePerformanceInsights;
        }

        @Override
        public final java.lang.Boolean getIamAuthentication() {
            return this.iamAuthentication;
        }

        @Override
        public final java.lang.String getInstanceIdentifier() {
            return this.instanceIdentifier;
        }

        @Override
        public final java.lang.Number getIops() {
            return this.iops;
        }

        @Override
        public final java.lang.Number getMaxAllocatedStorage() {
            return this.maxAllocatedStorage;
        }

        @Override
        public final software.amazon.awscdk.Duration getMonitoringInterval() {
            return this.monitoringInterval;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getMonitoringRole() {
            return this.monitoringRole;
        }

        @Override
        public final java.lang.Boolean getMultiAz() {
            return this.multiAz;
        }

        @Override
        public final software.amazon.awscdk.services.rds.NetworkType getNetworkType() {
            return this.networkType;
        }

        @Override
        public final software.amazon.awscdk.services.rds.IOptionGroup getOptionGroup() {
            return this.optionGroup;
        }

        @Override
        public final software.amazon.awscdk.services.rds.IParameterGroup getParameterGroup() {
            return this.parameterGroup;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getPerformanceInsightEncryptionKey() {
            return this.performanceInsightEncryptionKey;
        }

        @Override
        public final software.amazon.awscdk.services.rds.PerformanceInsightRetention getPerformanceInsightRetention() {
            return this.performanceInsightRetention;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final java.lang.String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final software.amazon.awscdk.services.rds.ProcessorFeatures getProcessorFeatures() {
            return this.processorFeatures;
        }

        @Override
        public final java.lang.Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.s3.IBucket> getS3ExportBuckets() {
            return this.s3ExportBuckets;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getS3ExportRole() {
            return this.s3ExportRole;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.s3.IBucket> getS3ImportBuckets() {
            return this.s3ImportBuckets;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getS3ImportRole() {
            return this.s3ImportRole;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final java.lang.Number getStorageThroughput() {
            return this.storageThroughput;
        }

        @Override
        public final software.amazon.awscdk.services.rds.StorageType getStorageType() {
            return this.storageType;
        }

        @Override
        public final software.amazon.awscdk.services.rds.ISubnetGroup getSubnetGroup() {
            return this.subnetGroup;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getApplyImmediately() != null) {
                data.set("applyImmediately", om.valueToTree(this.getApplyImmediately()));
            }
            if (this.getAutoMinorVersionUpgrade() != null) {
                data.set("autoMinorVersionUpgrade", om.valueToTree(this.getAutoMinorVersionUpgrade()));
            }
            if (this.getAvailabilityZone() != null) {
                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getBackupRetention() != null) {
                data.set("backupRetention", om.valueToTree(this.getBackupRetention()));
            }
            if (this.getCaCertificate() != null) {
                data.set("caCertificate", om.valueToTree(this.getCaCertificate()));
            }
            if (this.getCloudwatchLogsExports() != null) {
                data.set("cloudwatchLogsExports", om.valueToTree(this.getCloudwatchLogsExports()));
            }
            if (this.getCloudwatchLogsRetention() != null) {
                data.set("cloudwatchLogsRetention", om.valueToTree(this.getCloudwatchLogsRetention()));
            }
            if (this.getCloudwatchLogsRetentionRole() != null) {
                data.set("cloudwatchLogsRetentionRole", om.valueToTree(this.getCloudwatchLogsRetentionRole()));
            }
            if (this.getCopyTagsToSnapshot() != null) {
                data.set("copyTagsToSnapshot", om.valueToTree(this.getCopyTagsToSnapshot()));
            }
            if (this.getDeleteAutomatedBackups() != null) {
                data.set("deleteAutomatedBackups", om.valueToTree(this.getDeleteAutomatedBackups()));
            }
            if (this.getDeletionProtection() != null) {
                data.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
            }
            if (this.getDomain() != null) {
                data.set("domain", om.valueToTree(this.getDomain()));
            }
            if (this.getDomainRole() != null) {
                data.set("domainRole", om.valueToTree(this.getDomainRole()));
            }
            if (this.getEnablePerformanceInsights() != null) {
                data.set("enablePerformanceInsights", om.valueToTree(this.getEnablePerformanceInsights()));
            }
            if (this.getIamAuthentication() != null) {
                data.set("iamAuthentication", om.valueToTree(this.getIamAuthentication()));
            }
            if (this.getInstanceIdentifier() != null) {
                data.set("instanceIdentifier", om.valueToTree(this.getInstanceIdentifier()));
            }
            if (this.getIops() != null) {
                data.set("iops", om.valueToTree(this.getIops()));
            }
            if (this.getMaxAllocatedStorage() != null) {
                data.set("maxAllocatedStorage", om.valueToTree(this.getMaxAllocatedStorage()));
            }
            if (this.getMonitoringInterval() != null) {
                data.set("monitoringInterval", om.valueToTree(this.getMonitoringInterval()));
            }
            if (this.getMonitoringRole() != null) {
                data.set("monitoringRole", om.valueToTree(this.getMonitoringRole()));
            }
            if (this.getMultiAz() != null) {
                data.set("multiAz", om.valueToTree(this.getMultiAz()));
            }
            if (this.getNetworkType() != null) {
                data.set("networkType", om.valueToTree(this.getNetworkType()));
            }
            if (this.getOptionGroup() != null) {
                data.set("optionGroup", om.valueToTree(this.getOptionGroup()));
            }
            if (this.getParameterGroup() != null) {
                data.set("parameterGroup", om.valueToTree(this.getParameterGroup()));
            }
            if (this.getPerformanceInsightEncryptionKey() != null) {
                data.set("performanceInsightEncryptionKey", om.valueToTree(this.getPerformanceInsightEncryptionKey()));
            }
            if (this.getPerformanceInsightRetention() != null) {
                data.set("performanceInsightRetention", om.valueToTree(this.getPerformanceInsightRetention()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getPreferredBackupWindow() != null) {
                data.set("preferredBackupWindow", om.valueToTree(this.getPreferredBackupWindow()));
            }
            if (this.getPreferredMaintenanceWindow() != null) {
                data.set("preferredMaintenanceWindow", om.valueToTree(this.getPreferredMaintenanceWindow()));
            }
            if (this.getProcessorFeatures() != null) {
                data.set("processorFeatures", om.valueToTree(this.getProcessorFeatures()));
            }
            if (this.getPubliclyAccessible() != null) {
                data.set("publiclyAccessible", om.valueToTree(this.getPubliclyAccessible()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getS3ExportBuckets() != null) {
                data.set("s3ExportBuckets", om.valueToTree(this.getS3ExportBuckets()));
            }
            if (this.getS3ExportRole() != null) {
                data.set("s3ExportRole", om.valueToTree(this.getS3ExportRole()));
            }
            if (this.getS3ImportBuckets() != null) {
                data.set("s3ImportBuckets", om.valueToTree(this.getS3ImportBuckets()));
            }
            if (this.getS3ImportRole() != null) {
                data.set("s3ImportRole", om.valueToTree(this.getS3ImportRole()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getStorageThroughput() != null) {
                data.set("storageThroughput", om.valueToTree(this.getStorageThroughput()));
            }
            if (this.getStorageType() != null) {
                data.set("storageType", om.valueToTree(this.getStorageType()));
            }
            if (this.getSubnetGroup() != null) {
                data.set("subnetGroup", om.valueToTree(this.getSubnetGroup()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.DatabaseInstanceNewProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DatabaseInstanceNewProps.Jsii$Proxy that = (DatabaseInstanceNewProps.Jsii$Proxy) o;

            if (!vpc.equals(that.vpc)) return false;
            if (this.applyImmediately != null ? !this.applyImmediately.equals(that.applyImmediately) : that.applyImmediately != null) return false;
            if (this.autoMinorVersionUpgrade != null ? !this.autoMinorVersionUpgrade.equals(that.autoMinorVersionUpgrade) : that.autoMinorVersionUpgrade != null) return false;
            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.backupRetention != null ? !this.backupRetention.equals(that.backupRetention) : that.backupRetention != null) return false;
            if (this.caCertificate != null ? !this.caCertificate.equals(that.caCertificate) : that.caCertificate != null) return false;
            if (this.cloudwatchLogsExports != null ? !this.cloudwatchLogsExports.equals(that.cloudwatchLogsExports) : that.cloudwatchLogsExports != null) return false;
            if (this.cloudwatchLogsRetention != null ? !this.cloudwatchLogsRetention.equals(that.cloudwatchLogsRetention) : that.cloudwatchLogsRetention != null) return false;
            if (this.cloudwatchLogsRetentionRole != null ? !this.cloudwatchLogsRetentionRole.equals(that.cloudwatchLogsRetentionRole) : that.cloudwatchLogsRetentionRole != null) return false;
            if (this.copyTagsToSnapshot != null ? !this.copyTagsToSnapshot.equals(that.copyTagsToSnapshot) : that.copyTagsToSnapshot != null) return false;
            if (this.deleteAutomatedBackups != null ? !this.deleteAutomatedBackups.equals(that.deleteAutomatedBackups) : that.deleteAutomatedBackups != null) return false;
            if (this.deletionProtection != null ? !this.deletionProtection.equals(that.deletionProtection) : that.deletionProtection != null) return false;
            if (this.domain != null ? !this.domain.equals(that.domain) : that.domain != null) return false;
            if (this.domainRole != null ? !this.domainRole.equals(that.domainRole) : that.domainRole != null) return false;
            if (this.enablePerformanceInsights != null ? !this.enablePerformanceInsights.equals(that.enablePerformanceInsights) : that.enablePerformanceInsights != null) return false;
            if (this.iamAuthentication != null ? !this.iamAuthentication.equals(that.iamAuthentication) : that.iamAuthentication != null) return false;
            if (this.instanceIdentifier != null ? !this.instanceIdentifier.equals(that.instanceIdentifier) : that.instanceIdentifier != null) return false;
            if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
            if (this.maxAllocatedStorage != null ? !this.maxAllocatedStorage.equals(that.maxAllocatedStorage) : that.maxAllocatedStorage != null) return false;
            if (this.monitoringInterval != null ? !this.monitoringInterval.equals(that.monitoringInterval) : that.monitoringInterval != null) return false;
            if (this.monitoringRole != null ? !this.monitoringRole.equals(that.monitoringRole) : that.monitoringRole != null) return false;
            if (this.multiAz != null ? !this.multiAz.equals(that.multiAz) : that.multiAz != null) return false;
            if (this.networkType != null ? !this.networkType.equals(that.networkType) : that.networkType != null) return false;
            if (this.optionGroup != null ? !this.optionGroup.equals(that.optionGroup) : that.optionGroup != null) return false;
            if (this.parameterGroup != null ? !this.parameterGroup.equals(that.parameterGroup) : that.parameterGroup != null) return false;
            if (this.performanceInsightEncryptionKey != null ? !this.performanceInsightEncryptionKey.equals(that.performanceInsightEncryptionKey) : that.performanceInsightEncryptionKey != null) return false;
            if (this.performanceInsightRetention != null ? !this.performanceInsightRetention.equals(that.performanceInsightRetention) : that.performanceInsightRetention != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.preferredBackupWindow != null ? !this.preferredBackupWindow.equals(that.preferredBackupWindow) : that.preferredBackupWindow != null) return false;
            if (this.preferredMaintenanceWindow != null ? !this.preferredMaintenanceWindow.equals(that.preferredMaintenanceWindow) : that.preferredMaintenanceWindow != null) return false;
            if (this.processorFeatures != null ? !this.processorFeatures.equals(that.processorFeatures) : that.processorFeatures != null) return false;
            if (this.publiclyAccessible != null ? !this.publiclyAccessible.equals(that.publiclyAccessible) : that.publiclyAccessible != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.s3ExportBuckets != null ? !this.s3ExportBuckets.equals(that.s3ExportBuckets) : that.s3ExportBuckets != null) return false;
            if (this.s3ExportRole != null ? !this.s3ExportRole.equals(that.s3ExportRole) : that.s3ExportRole != null) return false;
            if (this.s3ImportBuckets != null ? !this.s3ImportBuckets.equals(that.s3ImportBuckets) : that.s3ImportBuckets != null) return false;
            if (this.s3ImportRole != null ? !this.s3ImportRole.equals(that.s3ImportRole) : that.s3ImportRole != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.storageThroughput != null ? !this.storageThroughput.equals(that.storageThroughput) : that.storageThroughput != null) return false;
            if (this.storageType != null ? !this.storageType.equals(that.storageType) : that.storageType != null) return false;
            if (this.subnetGroup != null ? !this.subnetGroup.equals(that.subnetGroup) : that.subnetGroup != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.vpc.hashCode();
            result = 31 * result + (this.applyImmediately != null ? this.applyImmediately.hashCode() : 0);
            result = 31 * result + (this.autoMinorVersionUpgrade != null ? this.autoMinorVersionUpgrade.hashCode() : 0);
            result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
            result = 31 * result + (this.backupRetention != null ? this.backupRetention.hashCode() : 0);
            result = 31 * result + (this.caCertificate != null ? this.caCertificate.hashCode() : 0);
            result = 31 * result + (this.cloudwatchLogsExports != null ? this.cloudwatchLogsExports.hashCode() : 0);
            result = 31 * result + (this.cloudwatchLogsRetention != null ? this.cloudwatchLogsRetention.hashCode() : 0);
            result = 31 * result + (this.cloudwatchLogsRetentionRole != null ? this.cloudwatchLogsRetentionRole.hashCode() : 0);
            result = 31 * result + (this.copyTagsToSnapshot != null ? this.copyTagsToSnapshot.hashCode() : 0);
            result = 31 * result + (this.deleteAutomatedBackups != null ? this.deleteAutomatedBackups.hashCode() : 0);
            result = 31 * result + (this.deletionProtection != null ? this.deletionProtection.hashCode() : 0);
            result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
            result = 31 * result + (this.domainRole != null ? this.domainRole.hashCode() : 0);
            result = 31 * result + (this.enablePerformanceInsights != null ? this.enablePerformanceInsights.hashCode() : 0);
            result = 31 * result + (this.iamAuthentication != null ? this.iamAuthentication.hashCode() : 0);
            result = 31 * result + (this.instanceIdentifier != null ? this.instanceIdentifier.hashCode() : 0);
            result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
            result = 31 * result + (this.maxAllocatedStorage != null ? this.maxAllocatedStorage.hashCode() : 0);
            result = 31 * result + (this.monitoringInterval != null ? this.monitoringInterval.hashCode() : 0);
            result = 31 * result + (this.monitoringRole != null ? this.monitoringRole.hashCode() : 0);
            result = 31 * result + (this.multiAz != null ? this.multiAz.hashCode() : 0);
            result = 31 * result + (this.networkType != null ? this.networkType.hashCode() : 0);
            result = 31 * result + (this.optionGroup != null ? this.optionGroup.hashCode() : 0);
            result = 31 * result + (this.parameterGroup != null ? this.parameterGroup.hashCode() : 0);
            result = 31 * result + (this.performanceInsightEncryptionKey != null ? this.performanceInsightEncryptionKey.hashCode() : 0);
            result = 31 * result + (this.performanceInsightRetention != null ? this.performanceInsightRetention.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.preferredBackupWindow != null ? this.preferredBackupWindow.hashCode() : 0);
            result = 31 * result + (this.preferredMaintenanceWindow != null ? this.preferredMaintenanceWindow.hashCode() : 0);
            result = 31 * result + (this.processorFeatures != null ? this.processorFeatures.hashCode() : 0);
            result = 31 * result + (this.publiclyAccessible != null ? this.publiclyAccessible.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.s3ExportBuckets != null ? this.s3ExportBuckets.hashCode() : 0);
            result = 31 * result + (this.s3ExportRole != null ? this.s3ExportRole.hashCode() : 0);
            result = 31 * result + (this.s3ImportBuckets != null ? this.s3ImportBuckets.hashCode() : 0);
            result = 31 * result + (this.s3ImportRole != null ? this.s3ImportRole.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.storageThroughput != null ? this.storageThroughput.hashCode() : 0);
            result = 31 * result + (this.storageType != null ? this.storageType.hashCode() : 0);
            result = 31 * result + (this.subnetGroup != null ? this.subnetGroup.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
