package software.amazon.awscdk.services.rds;

/**
 * The versions for the Oracle instance engines.
 * <p>
 * Those returned by the following list.
 * <p>
 * <ul>
 * <li><code>DatabaseInstanceEngine.oracleSe2</code></li>
 * <li><code>DatabaseInstanceEngine.oracleSe2Cdb</code></li>
 * <li><code>DatabaseInstanceEngine.oracleEe</code></li>
 * <li><code>DatabaseInstanceEngine.oracleEeCdb</code>.</li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseInstance instance = DatabaseInstance.Builder.create(this, "Instance")
 *         .engine(DatabaseInstanceEngine.oracleSe2(OracleSe2InstanceEngineProps.builder().version(OracleEngineVersion.VER_19_0_0_0_2020_04_R1).build()))
 *         // optional, defaults to m5.large
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE3, InstanceSize.SMALL))
 *         .credentials(Credentials.fromGeneratedSecret("syscdk")) // Optional - will default to 'admin' username and generated password
 *         .vpc(vpc)
 *         .vpcSubnets(SubnetSelection.builder()
 *                 .subnetType(SubnetType.PRIVATE_WITH_EGRESS)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:31.651Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.OracleEngineVersion")
public class OracleEngineVersion extends software.amazon.jsii.JsiiObject {

    protected OracleEngineVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected OracleEngineVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        VER_12_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V15 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V15", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V16 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V16", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V17 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V17", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V18 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V18", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V19 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V19", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V20 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V20", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V21 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V21", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V22 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V22", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V23 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V23", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V24 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V24", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V25 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V25", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V26 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V26", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V27 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V27", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V28 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V28", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V29 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V29", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2018_10_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2018_10_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2019_01_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2019_01_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2019_04_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2019_04_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2019_07_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2019_07_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2019_10_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2019_10_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2020_01_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2020_01_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2020_04_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2020_04_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2020_07_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2020_07_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2020_10_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2020_10_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2021_01_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2021_01_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2021_04_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2021_04_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2021_07_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2021_07_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2021_10_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2021_10_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2022_01_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2022_01_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_18 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_18", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_18_0_0_0_2019_07_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_18_0_0_0_2019_07_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_18_0_0_0_2019_10_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_18_0_0_0_2019_10_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_18_0_0_0_2020_01_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_18_0_0_0_2020_01_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_18_0_0_0_2020_04_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_18_0_0_0_2020_04_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_18_0_0_0_2020_07_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_18_0_0_0_2020_07_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_18_0_0_0_2020_10_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_18_0_0_0_2020_10_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_18_0_0_0_2021_01_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_18_0_0_0_2021_01_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_18_0_0_0_2021_04_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_18_0_0_0_2021_04_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2019_07_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2019_07_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2019_10_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2019_10_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2020_01_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2020_01_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2020_04_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2020_04_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2020_07_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2020_07_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2020_10_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2020_10_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2021_01_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2021_01_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2021_01_R2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2021_01_R2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2021_04_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2021_04_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2021_07_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2021_07_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2021_10_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2021_10_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2022_01_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2022_01_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2022_04_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2022_04_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2022_07_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2022_07_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2022_10_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2022_10_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2023_01_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2023_01_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2023_01_R2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2023_01_R2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2023_04_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2023_04_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2023_07_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2023_07_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2023_10_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2023_10_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2024_01_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2024_01_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2024_04_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2024_04_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2024_07_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2024_07_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2024_10_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2024_10_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2025_01_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2025_01_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_21 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_21", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_21_0_0_0_2022_01_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_21_0_0_0_2022_01_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_21_0_0_0_2022_04_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_21_0_0_0_2022_04_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_21_0_0_0_2022_07_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_21_0_0_0_2022_07_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_21_0_0_0_2022_10_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_21_0_0_0_2022_10_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_21_0_0_0_2023_01_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_21_0_0_0_2023_01_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_21_0_0_0_2023_01_R2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_21_0_0_0_2023_01_R2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_21_0_0_0_2023_04_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_21_0_0_0_2023_04_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_21_0_0_0_2023_07_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_21_0_0_0_2023_07_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_21_0_0_0_2023_10_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_21_0_0_0_2023_10_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_21_0_0_0_2024_01_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_21_0_0_0_2024_01_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_21_0_0_0_2024_04_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_21_0_0_0_2024_04_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_21_0_0_0_2024_07_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_21_0_0_0_2024_07_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_21_0_0_0_2024_10_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_21_0_0_0_2024_10_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_21_0_0_0_2025_01_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_21_0_0_0_2025_01_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
    }

    /**
     * Creates a new OracleEngineVersion with an arbitrary version.
     * <p>
     * @param oracleFullVersion the full version string, for example "19.0.0.0.ru-2019-10.rur-2019-10.r1". This parameter is required.
     * @param oracleMajorVersion the major version of the engine, for example "19". This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.OracleEngineVersion of(final @org.jetbrains.annotations.NotNull java.lang.String oracleFullVersion, final @org.jetbrains.annotations.NotNull java.lang.String oracleMajorVersion) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class), new Object[] { java.util.Objects.requireNonNull(oracleFullVersion, "oracleFullVersion is required"), java.util.Objects.requireNonNull(oracleMajorVersion, "oracleMajorVersion is required") });
    }

    /**
     * (deprecated) Version "12.1" (only a major version, without a specific minor version).
     * <p>
     * @deprecated Oracle 12.1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1;

    /**
     * (deprecated) Version "12.1.0.2.v1".
     * <p>
     * @deprecated Oracle 12.1.0.2.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V1;

    /**
     * (deprecated) Version "12.1.0.2.v10".
     * <p>
     * @deprecated Oracle 12.1.0.2.v10 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V10;

    /**
     * (deprecated) Version "12.1.0.2.v11".
     * <p>
     * @deprecated Oracle 12.1.0.2.v11 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V11;

    /**
     * (deprecated) Version "12.1.0.2.v12".
     * <p>
     * @deprecated Oracle 12.1.0.2.v12 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V12;

    /**
     * (deprecated) Version "12.1.0.2.v13".
     * <p>
     * @deprecated Oracle 12.1.0.2.v13 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V13;

    /**
     * (deprecated) Version "12.1.0.2.v14".
     * <p>
     * @deprecated Oracle 12.1.0.2.v14 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V14;

    /**
     * (deprecated) Version "12.1.0.2.v15".
     * <p>
     * @deprecated Oracle 12.1.0.2.v15 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V15;

    /**
     * (deprecated) Version "12.1.0.2.v16".
     * <p>
     * @deprecated Oracle 12.1.0.2.v16 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V16;

    /**
     * (deprecated) Version "12.1.0.2.v17".
     * <p>
     * @deprecated Oracle 12.1.0.2.v17 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V17;

    /**
     * (deprecated) Version "12.1.0.2.v18".
     * <p>
     * @deprecated Oracle 12.1.0.2.v18 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V18;

    /**
     * (deprecated) Version "12.1.0.2.v19".
     * <p>
     * @deprecated Oracle 12.1.0.2.v19 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V19;

    /**
     * (deprecated) Version "12.1.0.2.v2".
     * <p>
     * @deprecated Oracle 12.1.0.2.v2 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V2;

    /**
     * (deprecated) Version "12.1.0.2.v20".
     * <p>
     * @deprecated Oracle 12.1.0.2.v20 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V20;

    /**
     * (deprecated) Version "12.1.0.2.v21".
     * <p>
     * @deprecated Oracle 12.1.0.2.v21 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V21;

    /**
     * (deprecated) Version "12.1.0.2.v22".
     * <p>
     * @deprecated Oracle 12.1.0.2.v22 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V22;

    /**
     * (deprecated) Version "12.1.0.2.v23".
     * <p>
     * @deprecated Oracle 12.1.0.2.v23 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V23;

    /**
     * (deprecated) Version "12.1.0.2.v24".
     * <p>
     * @deprecated Oracle 12.1.0.2.v24 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V24;

    /**
     * (deprecated) Version "12.1.0.2.v25".
     * <p>
     * @deprecated Oracle 12.1.0.2.v25 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V25;

    /**
     * (deprecated) Version "12.1.0.2.v26".
     * <p>
     * @deprecated Oracle 12.1.0.2.v26 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V26;

    /**
     * (deprecated) Version "12.1.0.2.v27".
     * <p>
     * @deprecated Oracle 12.1.0.2.v27 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V27;

    /**
     * (deprecated) Version "12.1.0.2.v28".
     * <p>
     * @deprecated Oracle 12.1.0.2.v28 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V28;

    /**
     * (deprecated) Version "12.1.0.2.v29".
     * <p>
     * @deprecated Oracle 12.1.0.2.v29 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V29;

    /**
     * (deprecated) Version "12.1.0.2.v3".
     * <p>
     * @deprecated Oracle 12.1.0.2.v3 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V3;

    /**
     * (deprecated) Version "12.1.0.2.v4".
     * <p>
     * @deprecated Oracle 12.1.0.2.v4 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V4;

    /**
     * (deprecated) Version "12.1.0.2.v5".
     * <p>
     * @deprecated Oracle 12.1.0.2.v5 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V5;

    /**
     * (deprecated) Version "12.1.0.2.v6".
     * <p>
     * @deprecated Oracle 12.1.0.2.v6 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V6;

    /**
     * (deprecated) Version "12.1.0.2.v7".
     * <p>
     * @deprecated Oracle 12.1.0.2.v7 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V7;

    /**
     * (deprecated) Version "12.1.0.2.v8".
     * <p>
     * @deprecated Oracle 12.1.0.2.v8 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V8;

    /**
     * (deprecated) Version "12.1.0.2.v9".
     * <p>
     * @deprecated Oracle 12.1.0.2.v9 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V9;

    /**
     * (deprecated) Version "12.1" (only a major version, without a specific minor version).
     * <p>
     * @deprecated Oracle 12.1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2;

    /**
     * (deprecated) Version "12.2.0.1.ru-2018-10.rur-2018-10.r1".
     * <p>
     * @deprecated Oracle 12.2.0.1.ru-2018-10.rur-2018-10.r1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2018_10_R1;

    /**
     * (deprecated) Version "12.2.0.1.ru-2019-01.rur-2019-01.r1".
     * <p>
     * @deprecated Oracle 12.2.0.1.ru-2019-01.rur-2019-01.r1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2019_01_R1;

    /**
     * (deprecated) Version "12.2.0.1.ru-2019-04.rur-2019-04.r1".
     * <p>
     * @deprecated Oracle 12.2.0.1.ru-2019-04.rur-2019-04.r1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2019_04_R1;

    /**
     * (deprecated) Version "12.2.0.1.ru-2019-07.rur-2019-07.r1".
     * <p>
     * @deprecated Oracle 12.2.0.1.ru-2019-07.rur-2019-07.r1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2019_07_R1;

    /**
     * (deprecated) Version "12.2.0.1.ru-2019-10.rur-2019-10.r1".
     * <p>
     * @deprecated Oracle 12.2.0.1.ru-2019-10.rur-2019-10.r1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2019_10_R1;

    /**
     * (deprecated) Version "12.2.0.1.ru-2020-01.rur-2020-01.r1".
     * <p>
     * @deprecated Oracle 12.2.0.1.ru-2020-01.rur-2020-01.r1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2020_01_R1;

    /**
     * (deprecated) Version "12.2.0.1.ru-2020-04.rur-2020-04.r1".
     * <p>
     * @deprecated Oracle 12.2.0.1.ru-2020-04.rur-2020-04.r1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2020_04_R1;

    /**
     * (deprecated) Version "12.2.0.1.ru-2020-07.rur-2020-07.r1".
     * <p>
     * @deprecated Oracle 12.2.0.1.ru-2020-07.rur-2020-07.r1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2020_07_R1;

    /**
     * (deprecated) Version "12.2.0.1.ru-2021-10.rur-2020-10.r1".
     * <p>
     * @deprecated Oracle 12.2.0.1.ru-2021-10.rur-2020-10.r1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2020_10_R1;

    /**
     * (deprecated) Version "12.2.0.1.ru-2021-01.rur-2021-01.r1".
     * <p>
     * @deprecated Oracle 12.2.0.1.ru-2021-01.rur-2021-01.r1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2021_01_R1;

    /**
     * (deprecated) Version "12.2.0.1.ru-2021-04.rur-2021-04.r1".
     * <p>
     * @deprecated Oracle 12.2.0.1.ru-2021-04.rur-2021-04.r1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2021_04_R1;

    /**
     * (deprecated) Version "12.2.0.1.ru-2021-07.rur-2021-07.r1".
     * <p>
     * @deprecated Oracle 12.2.0.1.ru-2021-07.rur-2021-07.r1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2021_07_R1;

    /**
     * (deprecated) Version "12.2.0.1.ru-2021-10.rur-2021-10.r1".
     * <p>
     * @deprecated Oracle 12.2.0.1.ru-2021-10.rur-2021-10.r1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2021_10_R1;

    /**
     * (deprecated) Version "12.2.0.1.ru-2022-01.rur-2022-01.r1".
     * <p>
     * @deprecated Oracle 12.2.0.1.ru-2022-01.rur-2022-01.r1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2022_01_R1;

    /**
     * (deprecated) Version "18" (only a major version, without a specific minor version).
     * <p>
     * @deprecated Oracle 18 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_18;

    /**
     * (deprecated) Version "18.0.0.0.ru-2019-07.rur-2019-07.r1".
     * <p>
     * @deprecated Oracle 18.0.0.0.ru-2019-07.rur-2019-07.r1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_18_0_0_0_2019_07_R1;

    /**
     * (deprecated) Version "18.0.0.0.ru-2019-10.rur-2019-10.r1".
     * <p>
     * @deprecated Oracle 18.0.0.0.ru-2019-10.rur-2019-10.r1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_18_0_0_0_2019_10_R1;

    /**
     * (deprecated) Version "18.0.0.0.ru-2020-01.rur-2020-01.r1".
     * <p>
     * @deprecated Oracle 18.0.0.0.ru-2020-01.rur-2020-01.r1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_18_0_0_0_2020_01_R1;

    /**
     * (deprecated) Version "18.0.0.0.ru-2020-04.rur-2020-04.r1".
     * <p>
     * @deprecated Oracle 18.0.0.0.ru-2020-04.rur-2020-04.r1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_18_0_0_0_2020_04_R1;

    /**
     * (deprecated) Version "18.0.0.0.ru-2020-07.rur-2020-07.r1".
     * <p>
     * @deprecated Oracle 18.0.0.0.ru-2020-07.rur-2020-07.r1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_18_0_0_0_2020_07_R1;

    /**
     * (deprecated) Version "18.0.0.0.ru-2020-10.rur-2020-10.r1".
     * <p>
     * @deprecated Oracle 18.0.0.0.ru-2020-10.rur-2020-10.r1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_18_0_0_0_2020_10_R1;

    /**
     * (deprecated) Version "18.0.0.0.ru-2021-01.rur-2021-01.r1".
     * <p>
     * @deprecated Oracle 18.0.0.0.ru-2021-01.rur-2021-01.r1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_18_0_0_0_2021_01_R1;

    /**
     * (deprecated) Version "18.0.0.0.ru-2021-04.rur-2021-04.r1".
     * <p>
     * @deprecated Oracle 18.0.0.0.ru-2021-04.rur-2021-04.r1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_18_0_0_0_2021_04_R1;

    /**
     * Version "19" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19;

    /**
     * Version "19.0.0.0.ru-2019-07.rur-2019-07.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2019_07_R1;

    /**
     * Version "19.0.0.0.ru-2019-10.rur-2019-10.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2019_10_R1;

    /**
     * Version "19.0.0.0.ru-2020-01.rur-2020-01.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2020_01_R1;

    /**
     * Version "19.0.0.0.ru-2020-04.rur-2020-04.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2020_04_R1;

    /**
     * Version "19.0.0.0.ru-2020-07.rur-2020-07.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2020_07_R1;

    /**
     * Version "19.0.0.0.ru-2020-07.rur-2020-10.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2020_10_R1;

    /**
     * Version "19.0.0.0.ru-2021-01.rur-2021-01.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2021_01_R1;

    /**
     * Version "19.0.0.0.ru-2021-01.rur-2021-01.r2".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2021_01_R2;

    /**
     * Version "19.0.0.0.ru-2021-01.rur-2021-04.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2021_04_R1;

    /**
     * Version "19.0.0.0.ru-2021-07.rur-2021-07.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2021_07_R1;

    /**
     * Version "19.0.0.0.ru-2021-10.rur-2021-10.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2021_10_R1;

    /**
     * Version "19.0.0.0.ru-2022-01.rur-2022-01.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2022_01_R1;

    /**
     * Version "19.0.0.0.ru-2022-04.rur-2022-04.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2022_04_R1;

    /**
     * Version "19.0.0.0.ru-2022-07.rur-2022-07.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2022_07_R1;

    /**
     * Version "19.0.0.0.ru-2022-10.rur-2022-10.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2022_10_R1;

    /**
     * Version "19.0.0.0.ru-2023-01.rur-2023-01.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2023_01_R1;

    /**
     * Version "19.0.0.0.ru-2023-01.rur-2023-01.r2".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2023_01_R2;

    /**
     * Version "19.0.0.0.ru-2023-04.rur-2023-04.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2023_04_R1;

    /**
     * Version "19.0.0.0.ru-2023-07.rur-2023-07.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2023_07_R1;

    /**
     * Version "19.0.0.0.ru-2023-10.rur-2023-10.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2023_10_R1;

    /**
     * Version "19.0.0.0.ru-2024-01.rur-2024-01.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2024_01_R1;

    /**
     * Version "19.0.0.0.ru-2024-04.rur-2024-04.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2024_04_R1;

    /**
     * Version "19.0.0.0.ru-2024-07.rur-2024-07.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2024_07_R1;

    /**
     * Version "19.0.0.0.ru-2024-10.rur-2024-10.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2024_10_R1;

    /**
     * Version "19.0.0.0.ru-2025-01.rur-2025-01.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2025_01_R1;

    /**
     * Version "21" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_21;

    /**
     * Version "21.0.0.0.ru-2022-01.rur-2022-01.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_21_0_0_0_2022_01_R1;

    /**
     * Version "21.0.0.0.ru-2022-04.rur-2022-04.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_21_0_0_0_2022_04_R1;

    /**
     * Version "21.0.0.0.ru-2022-07.rur-2022-07.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_21_0_0_0_2022_07_R1;

    /**
     * Version "21.0.0.0.ru-2022-10.rur-2022-10.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_21_0_0_0_2022_10_R1;

    /**
     * Version "21.0.0.0.ru-2023-01.rur-2023-01.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_21_0_0_0_2023_01_R1;

    /**
     * Version "21.0.0.0.ru-2023-01.rur-2023-01.r2".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_21_0_0_0_2023_01_R2;

    /**
     * Version "21.0.0.0.ru-2023-04.rur-2023-04.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_21_0_0_0_2023_04_R1;

    /**
     * Version "21.0.0.0.ru-2023-07.rur-2023-07.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_21_0_0_0_2023_07_R1;

    /**
     * Version "21.0.0.0.ru-2023-10.rur-2023-10.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_21_0_0_0_2023_10_R1;

    /**
     * Version "21.0.0.0.ru-2024-01.rur-2024-01.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_21_0_0_0_2024_01_R1;

    /**
     * Version "21.0.0.0.ru-2024-04.rur-2024-04.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_21_0_0_0_2024_04_R1;

    /**
     * Version "21.0.0.0.ru-2024-07.rur-2024-07.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_21_0_0_0_2024_07_R1;

    /**
     * Version "21.0.0.0.ru-2024-10.rur-2024-10.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_21_0_0_0_2024_10_R1;

    /**
     * Version "21.0.0.0.ru-2025-01.rur-2025-01.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_21_0_0_0_2025_01_R1;

    /**
     * The full version string, for example, "19.0.0.0.ru-2019-10.rur-2019-10.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOracleFullVersion() {
        return software.amazon.jsii.Kernel.get(this, "oracleFullVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The major version of the engine, for example, "19".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOracleMajorVersion() {
        return software.amazon.jsii.Kernel.get(this, "oracleMajorVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
