package software.amazon.awscdk.services.rds;

/**
 * Options for configuring scaling on an Aurora Serverless v1 Cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * ServerlessCluster cluster = ServerlessCluster.Builder.create(this, "AnotherCluster")
 *         .engine(DatabaseClusterEngine.AURORA_POSTGRESQL)
 *         .copyTagsToSnapshot(true) // whether to save the cluster tags when creating the snapshot. Default is 'true'
 *         .parameterGroup(ParameterGroup.fromParameterGroupName(this, "ParameterGroup", "default.aurora-postgresql11"))
 *         .vpc(vpc)
 *         .scaling(ServerlessScalingOptions.builder()
 *                 .autoPause(Duration.minutes(10)) // default is to pause after 5 minutes of idle time
 *                 .minCapacity(AuroraCapacityUnit.ACU_8) // default is 2 Aurora capacity units (ACUs)
 *                 .maxCapacity(AuroraCapacityUnit.ACU_32) // default is 16 Aurora capacity units (ACUs)
 *                 .timeout(Duration.seconds(100)) // default is 5 minutes
 *                 .timeoutAction(TimeoutAction.FORCE_APPLY_CAPACITY_CHANGE)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:31.668Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.ServerlessScalingOptions")
@software.amazon.jsii.Jsii.Proxy(ServerlessScalingOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServerlessScalingOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The time before an Aurora Serverless database cluster is paused.
     * <p>
     * A database cluster can be paused only when it is idle (it has no connections).
     * Auto pause time must be between 5 minutes and 1 day.
     * <p>
     * If a DB cluster is paused for more than seven days, the DB cluster might be
     * backed up with a snapshot. In this case, the DB cluster is restored when there
     * is a request to connect to it.
     * <p>
     * Set to 0 to disable
     * <p>
     * Default: - automatic pause enabled after 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getAutoPause() {
        return null;
    }

    /**
     * The maximum capacity for an Aurora Serverless database cluster.
     * <p>
     * Default: - determined by Aurora based on database engine
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.AuroraCapacityUnit getMaxCapacity() {
        return null;
    }

    /**
     * The minimum capacity for an Aurora Serverless database cluster.
     * <p>
     * Default: - determined by Aurora based on database engine
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.AuroraCapacityUnit getMinCapacity() {
        return null;
    }

    /**
     * The amount of time that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action.
     * <p>
     * Default: - 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return null;
    }

    /**
     * The action to take when the timeout is reached.
     * <p>
     * Selecting ForceApplyCapacityChange will force the capacity to the specified value as soon as possible, even without a scaling point.
     * Selecting RollbackCapacityChange will ignore the capacity change if a scaling point is not found. This is the default behavior.
     * <p>
     * Default: - TimeoutAction.ROLLBACK_CAPACITY_CHANGE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.TimeoutAction getTimeoutAction() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ServerlessScalingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServerlessScalingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ServerlessScalingOptions> {
        software.amazon.awscdk.Duration autoPause;
        software.amazon.awscdk.services.rds.AuroraCapacityUnit maxCapacity;
        software.amazon.awscdk.services.rds.AuroraCapacityUnit minCapacity;
        software.amazon.awscdk.Duration timeout;
        software.amazon.awscdk.services.rds.TimeoutAction timeoutAction;

        /**
         * Sets the value of {@link ServerlessScalingOptions#getAutoPause}
         * @param autoPause The time before an Aurora Serverless database cluster is paused.
         *                  A database cluster can be paused only when it is idle (it has no connections).
         *                  Auto pause time must be between 5 minutes and 1 day.
         *                  <p>
         *                  If a DB cluster is paused for more than seven days, the DB cluster might be
         *                  backed up with a snapshot. In this case, the DB cluster is restored when there
         *                  is a request to connect to it.
         *                  <p>
         *                  Set to 0 to disable
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoPause(software.amazon.awscdk.Duration autoPause) {
            this.autoPause = autoPause;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessScalingOptions#getMaxCapacity}
         * @param maxCapacity The maximum capacity for an Aurora Serverless database cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCapacity(software.amazon.awscdk.services.rds.AuroraCapacityUnit maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessScalingOptions#getMinCapacity}
         * @param minCapacity The minimum capacity for an Aurora Serverless database cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minCapacity(software.amazon.awscdk.services.rds.AuroraCapacityUnit minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessScalingOptions#getTimeout}
         * @param timeout The amount of time that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessScalingOptions#getTimeoutAction}
         * @param timeoutAction The action to take when the timeout is reached.
         *                      Selecting ForceApplyCapacityChange will force the capacity to the specified value as soon as possible, even without a scaling point.
         *                      Selecting RollbackCapacityChange will ignore the capacity change if a scaling point is not found. This is the default behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeoutAction(software.amazon.awscdk.services.rds.TimeoutAction timeoutAction) {
            this.timeoutAction = timeoutAction;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServerlessScalingOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ServerlessScalingOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ServerlessScalingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerlessScalingOptions {
        private final software.amazon.awscdk.Duration autoPause;
        private final software.amazon.awscdk.services.rds.AuroraCapacityUnit maxCapacity;
        private final software.amazon.awscdk.services.rds.AuroraCapacityUnit minCapacity;
        private final software.amazon.awscdk.Duration timeout;
        private final software.amazon.awscdk.services.rds.TimeoutAction timeoutAction;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoPause = software.amazon.jsii.Kernel.get(this, "autoPause", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraCapacityUnit.class));
            this.minCapacity = software.amazon.jsii.Kernel.get(this, "minCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraCapacityUnit.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.timeoutAction = software.amazon.jsii.Kernel.get(this, "timeoutAction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.TimeoutAction.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoPause = builder.autoPause;
            this.maxCapacity = builder.maxCapacity;
            this.minCapacity = builder.minCapacity;
            this.timeout = builder.timeout;
            this.timeoutAction = builder.timeoutAction;
        }

        @Override
        public final software.amazon.awscdk.Duration getAutoPause() {
            return this.autoPause;
        }

        @Override
        public final software.amazon.awscdk.services.rds.AuroraCapacityUnit getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final software.amazon.awscdk.services.rds.AuroraCapacityUnit getMinCapacity() {
            return this.minCapacity;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final software.amazon.awscdk.services.rds.TimeoutAction getTimeoutAction() {
            return this.timeoutAction;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAutoPause() != null) {
                data.set("autoPause", om.valueToTree(this.getAutoPause()));
            }
            if (this.getMaxCapacity() != null) {
                data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
            }
            if (this.getMinCapacity() != null) {
                data.set("minCapacity", om.valueToTree(this.getMinCapacity()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getTimeoutAction() != null) {
                data.set("timeoutAction", om.valueToTree(this.getTimeoutAction()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.ServerlessScalingOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServerlessScalingOptions.Jsii$Proxy that = (ServerlessScalingOptions.Jsii$Proxy) o;

            if (this.autoPause != null ? !this.autoPause.equals(that.autoPause) : that.autoPause != null) return false;
            if (this.maxCapacity != null ? !this.maxCapacity.equals(that.maxCapacity) : that.maxCapacity != null) return false;
            if (this.minCapacity != null ? !this.minCapacity.equals(that.minCapacity) : that.minCapacity != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            return this.timeoutAction != null ? this.timeoutAction.equals(that.timeoutAction) : that.timeoutAction == null;
        }

        @Override
        public final int hashCode() {
            int result = this.autoPause != null ? this.autoPause.hashCode() : 0;
            result = 31 * result + (this.maxCapacity != null ? this.maxCapacity.hashCode() : 0);
            result = 31 * result + (this.minCapacity != null ? this.minCapacity.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.timeoutAction != null ? this.timeoutAction.hashCode() : 0);
            return result;
        }
    }
}
