package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a <code>CfnImageVersion</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnImageVersionProps cfnImageVersionProps = CfnImageVersionProps.builder()
 *         .baseImage("baseImage")
 *         .imageName("imageName")
 *         // the properties below are optional
 *         .alias("alias")
 *         .aliases(List.of("aliases"))
 *         .horovod(false)
 *         .jobType("jobType")
 *         .mlFramework("mlFramework")
 *         .processor("processor")
 *         .programmingLang("programmingLang")
 *         .releaseNotes("releaseNotes")
 *         .vendorGuidance("vendorGuidance")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:32.400Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnImageVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnImageVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnImageVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The container image that the SageMaker image version is based on.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-baseimage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-baseimage</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBaseImage();

    /**
     * The name of the parent image.
     * <p>
     * <em>Length Constraints</em> : Minimum length of 1. Maximum length of 63.
     * <p>
     * <em>Pattern</em> : <code>^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-imagename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-imagename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getImageName();

    /**
     * The alias of the image version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-alias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-alias</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAlias() {
        return null;
    }

    /**
     * List of aliases for the image version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-aliases">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-aliases</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAliases() {
        return null;
    }

    /**
     * Indicates Horovod compatibility.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-horovod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-horovod</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHorovod() {
        return null;
    }

    /**
     * Indicates SageMaker job type compatibility.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-jobtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-jobtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getJobType() {
        return null;
    }

    /**
     * The machine learning framework vended in the image version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-mlframework">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-mlframework</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMlFramework() {
        return null;
    }

    /**
     * Indicates CPU or GPU compatibility.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-processor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-processor</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProcessor() {
        return null;
    }

    /**
     * The supported programming language and its version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-programminglang">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-programminglang</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProgrammingLang() {
        return null;
    }

    /**
     * The maintainer description of the image version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-releasenotes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-releasenotes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReleaseNotes() {
        return null;
    }

    /**
     * The availability of the image version specified by the maintainer.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-vendorguidance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-vendorguidance</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVendorGuidance() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnImageVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnImageVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnImageVersionProps> {
        java.lang.String baseImage;
        java.lang.String imageName;
        java.lang.String alias;
        java.util.List<java.lang.String> aliases;
        java.lang.Object horovod;
        java.lang.String jobType;
        java.lang.String mlFramework;
        java.lang.String processor;
        java.lang.String programmingLang;
        java.lang.String releaseNotes;
        java.lang.String vendorGuidance;

        /**
         * Sets the value of {@link CfnImageVersionProps#getBaseImage}
         * @param baseImage The container image that the SageMaker image version is based on. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder baseImage(java.lang.String baseImage) {
            this.baseImage = baseImage;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageVersionProps#getImageName}
         * @param imageName The name of the parent image. This parameter is required.
         *                  <em>Length Constraints</em> : Minimum length of 1. Maximum length of 63.
         *                  <p>
         *                  <em>Pattern</em> : <code>^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageName(java.lang.String imageName) {
            this.imageName = imageName;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageVersionProps#getAlias}
         * @param alias The alias of the image version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alias(java.lang.String alias) {
            this.alias = alias;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageVersionProps#getAliases}
         * @param aliases List of aliases for the image version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aliases(java.util.List<java.lang.String> aliases) {
            this.aliases = aliases;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageVersionProps#getHorovod}
         * @param horovod Indicates Horovod compatibility.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder horovod(java.lang.Boolean horovod) {
            this.horovod = horovod;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageVersionProps#getHorovod}
         * @param horovod Indicates Horovod compatibility.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder horovod(software.amazon.awscdk.IResolvable horovod) {
            this.horovod = horovod;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageVersionProps#getJobType}
         * @param jobType Indicates SageMaker job type compatibility.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobType(java.lang.String jobType) {
            this.jobType = jobType;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageVersionProps#getMlFramework}
         * @param mlFramework The machine learning framework vended in the image version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mlFramework(java.lang.String mlFramework) {
            this.mlFramework = mlFramework;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageVersionProps#getProcessor}
         * @param processor Indicates CPU or GPU compatibility.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processor(java.lang.String processor) {
            this.processor = processor;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageVersionProps#getProgrammingLang}
         * @param programmingLang The supported programming language and its version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder programmingLang(java.lang.String programmingLang) {
            this.programmingLang = programmingLang;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageVersionProps#getReleaseNotes}
         * @param releaseNotes The maintainer description of the image version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder releaseNotes(java.lang.String releaseNotes) {
            this.releaseNotes = releaseNotes;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageVersionProps#getVendorGuidance}
         * @param vendorGuidance The availability of the image version specified by the maintainer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vendorGuidance(java.lang.String vendorGuidance) {
            this.vendorGuidance = vendorGuidance;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnImageVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnImageVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnImageVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnImageVersionProps {
        private final java.lang.String baseImage;
        private final java.lang.String imageName;
        private final java.lang.String alias;
        private final java.util.List<java.lang.String> aliases;
        private final java.lang.Object horovod;
        private final java.lang.String jobType;
        private final java.lang.String mlFramework;
        private final java.lang.String processor;
        private final java.lang.String programmingLang;
        private final java.lang.String releaseNotes;
        private final java.lang.String vendorGuidance;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.baseImage = software.amazon.jsii.Kernel.get(this, "baseImage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageName = software.amazon.jsii.Kernel.get(this, "imageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.alias = software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.aliases = software.amazon.jsii.Kernel.get(this, "aliases", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.horovod = software.amazon.jsii.Kernel.get(this, "horovod", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.jobType = software.amazon.jsii.Kernel.get(this, "jobType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mlFramework = software.amazon.jsii.Kernel.get(this, "mlFramework", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.processor = software.amazon.jsii.Kernel.get(this, "processor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.programmingLang = software.amazon.jsii.Kernel.get(this, "programmingLang", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.releaseNotes = software.amazon.jsii.Kernel.get(this, "releaseNotes", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vendorGuidance = software.amazon.jsii.Kernel.get(this, "vendorGuidance", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.baseImage = java.util.Objects.requireNonNull(builder.baseImage, "baseImage is required");
            this.imageName = java.util.Objects.requireNonNull(builder.imageName, "imageName is required");
            this.alias = builder.alias;
            this.aliases = builder.aliases;
            this.horovod = builder.horovod;
            this.jobType = builder.jobType;
            this.mlFramework = builder.mlFramework;
            this.processor = builder.processor;
            this.programmingLang = builder.programmingLang;
            this.releaseNotes = builder.releaseNotes;
            this.vendorGuidance = builder.vendorGuidance;
        }

        @Override
        public final java.lang.String getBaseImage() {
            return this.baseImage;
        }

        @Override
        public final java.lang.String getImageName() {
            return this.imageName;
        }

        @Override
        public final java.lang.String getAlias() {
            return this.alias;
        }

        @Override
        public final java.util.List<java.lang.String> getAliases() {
            return this.aliases;
        }

        @Override
        public final java.lang.Object getHorovod() {
            return this.horovod;
        }

        @Override
        public final java.lang.String getJobType() {
            return this.jobType;
        }

        @Override
        public final java.lang.String getMlFramework() {
            return this.mlFramework;
        }

        @Override
        public final java.lang.String getProcessor() {
            return this.processor;
        }

        @Override
        public final java.lang.String getProgrammingLang() {
            return this.programmingLang;
        }

        @Override
        public final java.lang.String getReleaseNotes() {
            return this.releaseNotes;
        }

        @Override
        public final java.lang.String getVendorGuidance() {
            return this.vendorGuidance;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("baseImage", om.valueToTree(this.getBaseImage()));
            data.set("imageName", om.valueToTree(this.getImageName()));
            if (this.getAlias() != null) {
                data.set("alias", om.valueToTree(this.getAlias()));
            }
            if (this.getAliases() != null) {
                data.set("aliases", om.valueToTree(this.getAliases()));
            }
            if (this.getHorovod() != null) {
                data.set("horovod", om.valueToTree(this.getHorovod()));
            }
            if (this.getJobType() != null) {
                data.set("jobType", om.valueToTree(this.getJobType()));
            }
            if (this.getMlFramework() != null) {
                data.set("mlFramework", om.valueToTree(this.getMlFramework()));
            }
            if (this.getProcessor() != null) {
                data.set("processor", om.valueToTree(this.getProcessor()));
            }
            if (this.getProgrammingLang() != null) {
                data.set("programmingLang", om.valueToTree(this.getProgrammingLang()));
            }
            if (this.getReleaseNotes() != null) {
                data.set("releaseNotes", om.valueToTree(this.getReleaseNotes()));
            }
            if (this.getVendorGuidance() != null) {
                data.set("vendorGuidance", om.valueToTree(this.getVendorGuidance()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnImageVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnImageVersionProps.Jsii$Proxy that = (CfnImageVersionProps.Jsii$Proxy) o;

            if (!baseImage.equals(that.baseImage)) return false;
            if (!imageName.equals(that.imageName)) return false;
            if (this.alias != null ? !this.alias.equals(that.alias) : that.alias != null) return false;
            if (this.aliases != null ? !this.aliases.equals(that.aliases) : that.aliases != null) return false;
            if (this.horovod != null ? !this.horovod.equals(that.horovod) : that.horovod != null) return false;
            if (this.jobType != null ? !this.jobType.equals(that.jobType) : that.jobType != null) return false;
            if (this.mlFramework != null ? !this.mlFramework.equals(that.mlFramework) : that.mlFramework != null) return false;
            if (this.processor != null ? !this.processor.equals(that.processor) : that.processor != null) return false;
            if (this.programmingLang != null ? !this.programmingLang.equals(that.programmingLang) : that.programmingLang != null) return false;
            if (this.releaseNotes != null ? !this.releaseNotes.equals(that.releaseNotes) : that.releaseNotes != null) return false;
            return this.vendorGuidance != null ? this.vendorGuidance.equals(that.vendorGuidance) : that.vendorGuidance == null;
        }

        @Override
        public final int hashCode() {
            int result = this.baseImage.hashCode();
            result = 31 * result + (this.imageName.hashCode());
            result = 31 * result + (this.alias != null ? this.alias.hashCode() : 0);
            result = 31 * result + (this.aliases != null ? this.aliases.hashCode() : 0);
            result = 31 * result + (this.horovod != null ? this.horovod.hashCode() : 0);
            result = 31 * result + (this.jobType != null ? this.jobType.hashCode() : 0);
            result = 31 * result + (this.mlFramework != null ? this.mlFramework.hashCode() : 0);
            result = 31 * result + (this.processor != null ? this.processor.hashCode() : 0);
            result = 31 * result + (this.programmingLang != null ? this.programmingLang.hashCode() : 0);
            result = 31 * result + (this.releaseNotes != null ? this.releaseNotes.hashCode() : 0);
            result = 31 * result + (this.vendorGuidance != null ? this.vendorGuidance.hashCode() : 0);
            return result;
        }
    }
}
