package software.amazon.awscdk.services.sam;

/**
 * Properties for defining a <code>CfnApi</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sam.*;
 * Object authorizers;
 * Object definitionBody;
 * Object gatewayResponses;
 * Object methodSettings;
 * Object models;
 * CfnApiProps cfnApiProps = CfnApiProps.builder()
 *         .stageName("stageName")
 *         // the properties below are optional
 *         .accessLogSetting(AccessLogSettingProperty.builder()
 *                 .destinationArn("destinationArn")
 *                 .format("format")
 *                 .build())
 *         .alwaysDeploy(false)
 *         .auth(AuthProperty.builder()
 *                 .addDefaultAuthorizerToCorsPreflight(false)
 *                 .authorizers(authorizers)
 *                 .defaultAuthorizer("defaultAuthorizer")
 *                 .build())
 *         .binaryMediaTypes(List.of("binaryMediaTypes"))
 *         .cacheClusterEnabled(false)
 *         .cacheClusterSize("cacheClusterSize")
 *         .canarySetting(CanarySettingProperty.builder()
 *                 .deploymentId("deploymentId")
 *                 .percentTraffic(123)
 *                 .stageVariableOverrides(Map.of(
 *                         "stageVariableOverridesKey", "stageVariableOverrides"))
 *                 .useStageCache(false)
 *                 .build())
 *         .cors("cors")
 *         .definitionBody(definitionBody)
 *         .definitionUri("definitionUri")
 *         .description("description")
 *         .disableExecuteApiEndpoint(false)
 *         .domain(DomainConfigurationProperty.builder()
 *                 .certificateArn("certificateArn")
 *                 .domainName("domainName")
 *                 // the properties below are optional
 *                 .basePath(List.of("basePath"))
 *                 .endpointConfiguration("endpointConfiguration")
 *                 .mutualTlsAuthentication(MutualTlsAuthenticationProperty.builder()
 *                         .truststoreUri("truststoreUri")
 *                         .truststoreVersion("truststoreVersion")
 *                         .build())
 *                 .ownershipVerificationCertificateArn("ownershipVerificationCertificateArn")
 *                 .route53(Route53ConfigurationProperty.builder()
 *                         .distributedDomainName("distributedDomainName")
 *                         .evaluateTargetHealth(false)
 *                         .hostedZoneId("hostedZoneId")
 *                         .hostedZoneName("hostedZoneName")
 *                         .ipV6(false)
 *                         .build())
 *                 .securityPolicy("securityPolicy")
 *                 .build())
 *         .endpointConfiguration("endpointConfiguration")
 *         .gatewayResponses(gatewayResponses)
 *         .methodSettings(List.of(methodSettings))
 *         .minimumCompressionSize(123)
 *         .models(models)
 *         .name("name")
 *         .openApiVersion("openApiVersion")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .tracingEnabled(false)
 *         .variables(Map.of(
 *                 "variablesKey", "variables"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:32.636Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnApiProps")
@software.amazon.jsii.Jsii.Proxy(CfnApiProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApiProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-stagename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-stagename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStageName();

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-accesslogsetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-accesslogsetting</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAccessLogSetting() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-alwaysdeploy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-alwaysdeploy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAlwaysDeploy() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-auth">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-auth</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAuth() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-binarymediatypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-binarymediatypes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getBinaryMediaTypes() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-cacheclusterenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-cacheclusterenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCacheClusterEnabled() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-cacheclustersize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-cacheclustersize</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCacheClusterSize() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-canarysetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-canarysetting</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCanarySetting() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-cors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-cors</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCors() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-definitionbody">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-definitionbody</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefinitionBody() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-definitionuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-definitionuri</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefinitionUri() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-disableexecuteapiendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-disableexecuteapiendpoint</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDisableExecuteApiEndpoint() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-domain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-domain</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDomain() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-endpointconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-endpointconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEndpointConfiguration() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-gatewayresponses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-gatewayresponses</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getGatewayResponses() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-methodsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-methodsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMethodSettings() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-minimumcompressionsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-minimumcompressionsize</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinimumCompressionSize() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-models">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-models</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getModels() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-openapiversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-openapiversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOpenApiVersion() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-tracingenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-tracingenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTracingEnabled() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-variables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-api.html#cfn-serverless-api-variables</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVariables() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnApiProps> {
        java.lang.String stageName;
        java.lang.Object accessLogSetting;
        java.lang.Object alwaysDeploy;
        java.lang.Object auth;
        java.util.List<java.lang.String> binaryMediaTypes;
        java.lang.Object cacheClusterEnabled;
        java.lang.String cacheClusterSize;
        java.lang.Object canarySetting;
        java.lang.Object cors;
        java.lang.Object definitionBody;
        java.lang.Object definitionUri;
        java.lang.String description;
        java.lang.Object disableExecuteApiEndpoint;
        java.lang.Object domain;
        java.lang.Object endpointConfiguration;
        java.lang.Object gatewayResponses;
        java.lang.Object methodSettings;
        java.lang.Number minimumCompressionSize;
        java.lang.Object models;
        java.lang.String name;
        java.lang.String openApiVersion;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.Object tracingEnabled;
        java.lang.Object variables;

        /**
         * Sets the value of {@link CfnApiProps#getStageName}
         * @param stageName the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageName(java.lang.String stageName) {
            this.stageName = stageName;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getAccessLogSetting}
         * @param accessLogSetting the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLogSetting(software.amazon.awscdk.IResolvable accessLogSetting) {
            this.accessLogSetting = accessLogSetting;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getAccessLogSetting}
         * @param accessLogSetting the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLogSetting(software.amazon.awscdk.services.sam.CfnApi.AccessLogSettingProperty accessLogSetting) {
            this.accessLogSetting = accessLogSetting;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getAlwaysDeploy}
         * @param alwaysDeploy the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alwaysDeploy(java.lang.Boolean alwaysDeploy) {
            this.alwaysDeploy = alwaysDeploy;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getAlwaysDeploy}
         * @param alwaysDeploy the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alwaysDeploy(software.amazon.awscdk.IResolvable alwaysDeploy) {
            this.alwaysDeploy = alwaysDeploy;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getAuth}
         * @param auth the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder auth(software.amazon.awscdk.IResolvable auth) {
            this.auth = auth;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getAuth}
         * @param auth the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder auth(software.amazon.awscdk.services.sam.CfnApi.AuthProperty auth) {
            this.auth = auth;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getBinaryMediaTypes}
         * @param binaryMediaTypes the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder binaryMediaTypes(java.util.List<java.lang.String> binaryMediaTypes) {
            this.binaryMediaTypes = binaryMediaTypes;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getCacheClusterEnabled}
         * @param cacheClusterEnabled the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheClusterEnabled(java.lang.Boolean cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getCacheClusterEnabled}
         * @param cacheClusterEnabled the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheClusterEnabled(software.amazon.awscdk.IResolvable cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getCacheClusterSize}
         * @param cacheClusterSize the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheClusterSize(java.lang.String cacheClusterSize) {
            this.cacheClusterSize = cacheClusterSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getCanarySetting}
         * @param canarySetting the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder canarySetting(software.amazon.awscdk.IResolvable canarySetting) {
            this.canarySetting = canarySetting;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getCanarySetting}
         * @param canarySetting the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder canarySetting(software.amazon.awscdk.services.sam.CfnApi.CanarySettingProperty canarySetting) {
            this.canarySetting = canarySetting;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getCors}
         * @param cors the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cors(java.lang.String cors) {
            this.cors = cors;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getCors}
         * @param cors the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cors(software.amazon.awscdk.IResolvable cors) {
            this.cors = cors;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getCors}
         * @param cors the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cors(software.amazon.awscdk.services.sam.CfnApi.CorsConfigurationProperty cors) {
            this.cors = cors;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getDefinitionBody}
         * @param definitionBody the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionBody(java.lang.Object definitionBody) {
            this.definitionBody = definitionBody;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getDefinitionUri}
         * @param definitionUri the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionUri(java.lang.String definitionUri) {
            this.definitionUri = definitionUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getDefinitionUri}
         * @param definitionUri the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionUri(software.amazon.awscdk.IResolvable definitionUri) {
            this.definitionUri = definitionUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getDefinitionUri}
         * @param definitionUri the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionUri(software.amazon.awscdk.services.sam.CfnApi.S3LocationProperty definitionUri) {
            this.definitionUri = definitionUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getDescription}
         * @param description the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getDisableExecuteApiEndpoint}
         * @param disableExecuteApiEndpoint the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableExecuteApiEndpoint(java.lang.Boolean disableExecuteApiEndpoint) {
            this.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getDisableExecuteApiEndpoint}
         * @param disableExecuteApiEndpoint the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableExecuteApiEndpoint(software.amazon.awscdk.IResolvable disableExecuteApiEndpoint) {
            this.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getDomain}
         * @param domain the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(software.amazon.awscdk.IResolvable domain) {
            this.domain = domain;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getDomain}
         * @param domain the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(software.amazon.awscdk.services.sam.CfnApi.DomainConfigurationProperty domain) {
            this.domain = domain;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getEndpointConfiguration}
         * @param endpointConfiguration the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointConfiguration(java.lang.String endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getEndpointConfiguration}
         * @param endpointConfiguration the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointConfiguration(software.amazon.awscdk.IResolvable endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getEndpointConfiguration}
         * @param endpointConfiguration the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointConfiguration(software.amazon.awscdk.services.sam.CfnApi.EndpointConfigurationProperty endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getGatewayResponses}
         * @param gatewayResponses the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayResponses(java.lang.Object gatewayResponses) {
            this.gatewayResponses = gatewayResponses;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getMethodSettings}
         * @param methodSettings the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder methodSettings(java.util.List<? extends java.lang.Object> methodSettings) {
            this.methodSettings = methodSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getMethodSettings}
         * @param methodSettings the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder methodSettings(software.amazon.awscdk.IResolvable methodSettings) {
            this.methodSettings = methodSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getMinimumCompressionSize}
         * @param minimumCompressionSize the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumCompressionSize(java.lang.Number minimumCompressionSize) {
            this.minimumCompressionSize = minimumCompressionSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getModels}
         * @param models the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder models(java.lang.Object models) {
            this.models = models;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getName}
         * @param name the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getOpenApiVersion}
         * @param openApiVersion the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openApiVersion(java.lang.String openApiVersion) {
            this.openApiVersion = openApiVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getTags}
         * @param tags the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getTracingEnabled}
         * @param tracingEnabled the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracingEnabled(java.lang.Boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getTracingEnabled}
         * @param tracingEnabled the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracingEnabled(software.amazon.awscdk.IResolvable tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getVariables}
         * @param variables the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variables(java.util.Map<java.lang.String, java.lang.String> variables) {
            this.variables = variables;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getVariables}
         * @param variables the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variables(software.amazon.awscdk.IResolvable variables) {
            this.variables = variables;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApiProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnApiProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApiProps {
        private final java.lang.String stageName;
        private final java.lang.Object accessLogSetting;
        private final java.lang.Object alwaysDeploy;
        private final java.lang.Object auth;
        private final java.util.List<java.lang.String> binaryMediaTypes;
        private final java.lang.Object cacheClusterEnabled;
        private final java.lang.String cacheClusterSize;
        private final java.lang.Object canarySetting;
        private final java.lang.Object cors;
        private final java.lang.Object definitionBody;
        private final java.lang.Object definitionUri;
        private final java.lang.String description;
        private final java.lang.Object disableExecuteApiEndpoint;
        private final java.lang.Object domain;
        private final java.lang.Object endpointConfiguration;
        private final java.lang.Object gatewayResponses;
        private final java.lang.Object methodSettings;
        private final java.lang.Number minimumCompressionSize;
        private final java.lang.Object models;
        private final java.lang.String name;
        private final java.lang.String openApiVersion;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.Object tracingEnabled;
        private final java.lang.Object variables;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stageName = software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessLogSetting = software.amazon.jsii.Kernel.get(this, "accessLogSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.alwaysDeploy = software.amazon.jsii.Kernel.get(this, "alwaysDeploy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.auth = software.amazon.jsii.Kernel.get(this, "auth", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.binaryMediaTypes = software.amazon.jsii.Kernel.get(this, "binaryMediaTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cacheClusterEnabled = software.amazon.jsii.Kernel.get(this, "cacheClusterEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cacheClusterSize = software.amazon.jsii.Kernel.get(this, "cacheClusterSize", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.canarySetting = software.amazon.jsii.Kernel.get(this, "canarySetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cors = software.amazon.jsii.Kernel.get(this, "cors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.definitionBody = software.amazon.jsii.Kernel.get(this, "definitionBody", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.definitionUri = software.amazon.jsii.Kernel.get(this, "definitionUri", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.disableExecuteApiEndpoint = software.amazon.jsii.Kernel.get(this, "disableExecuteApiEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.domain = software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.endpointConfiguration = software.amazon.jsii.Kernel.get(this, "endpointConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.gatewayResponses = software.amazon.jsii.Kernel.get(this, "gatewayResponses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.methodSettings = software.amazon.jsii.Kernel.get(this, "methodSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.minimumCompressionSize = software.amazon.jsii.Kernel.get(this, "minimumCompressionSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.models = software.amazon.jsii.Kernel.get(this, "models", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.openApiVersion = software.amazon.jsii.Kernel.get(this, "openApiVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tracingEnabled = software.amazon.jsii.Kernel.get(this, "tracingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.variables = software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stageName = java.util.Objects.requireNonNull(builder.stageName, "stageName is required");
            this.accessLogSetting = builder.accessLogSetting;
            this.alwaysDeploy = builder.alwaysDeploy;
            this.auth = builder.auth;
            this.binaryMediaTypes = builder.binaryMediaTypes;
            this.cacheClusterEnabled = builder.cacheClusterEnabled;
            this.cacheClusterSize = builder.cacheClusterSize;
            this.canarySetting = builder.canarySetting;
            this.cors = builder.cors;
            this.definitionBody = builder.definitionBody;
            this.definitionUri = builder.definitionUri;
            this.description = builder.description;
            this.disableExecuteApiEndpoint = builder.disableExecuteApiEndpoint;
            this.domain = builder.domain;
            this.endpointConfiguration = builder.endpointConfiguration;
            this.gatewayResponses = builder.gatewayResponses;
            this.methodSettings = builder.methodSettings;
            this.minimumCompressionSize = builder.minimumCompressionSize;
            this.models = builder.models;
            this.name = builder.name;
            this.openApiVersion = builder.openApiVersion;
            this.tags = builder.tags;
            this.tracingEnabled = builder.tracingEnabled;
            this.variables = builder.variables;
        }

        @Override
        public final java.lang.String getStageName() {
            return this.stageName;
        }

        @Override
        public final java.lang.Object getAccessLogSetting() {
            return this.accessLogSetting;
        }

        @Override
        public final java.lang.Object getAlwaysDeploy() {
            return this.alwaysDeploy;
        }

        @Override
        public final java.lang.Object getAuth() {
            return this.auth;
        }

        @Override
        public final java.util.List<java.lang.String> getBinaryMediaTypes() {
            return this.binaryMediaTypes;
        }

        @Override
        public final java.lang.Object getCacheClusterEnabled() {
            return this.cacheClusterEnabled;
        }

        @Override
        public final java.lang.String getCacheClusterSize() {
            return this.cacheClusterSize;
        }

        @Override
        public final java.lang.Object getCanarySetting() {
            return this.canarySetting;
        }

        @Override
        public final java.lang.Object getCors() {
            return this.cors;
        }

        @Override
        public final java.lang.Object getDefinitionBody() {
            return this.definitionBody;
        }

        @Override
        public final java.lang.Object getDefinitionUri() {
            return this.definitionUri;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getDisableExecuteApiEndpoint() {
            return this.disableExecuteApiEndpoint;
        }

        @Override
        public final java.lang.Object getDomain() {
            return this.domain;
        }

        @Override
        public final java.lang.Object getEndpointConfiguration() {
            return this.endpointConfiguration;
        }

        @Override
        public final java.lang.Object getGatewayResponses() {
            return this.gatewayResponses;
        }

        @Override
        public final java.lang.Object getMethodSettings() {
            return this.methodSettings;
        }

        @Override
        public final java.lang.Number getMinimumCompressionSize() {
            return this.minimumCompressionSize;
        }

        @Override
        public final java.lang.Object getModels() {
            return this.models;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getOpenApiVersion() {
            return this.openApiVersion;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTracingEnabled() {
            return this.tracingEnabled;
        }

        @Override
        public final java.lang.Object getVariables() {
            return this.variables;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("stageName", om.valueToTree(this.getStageName()));
            if (this.getAccessLogSetting() != null) {
                data.set("accessLogSetting", om.valueToTree(this.getAccessLogSetting()));
            }
            if (this.getAlwaysDeploy() != null) {
                data.set("alwaysDeploy", om.valueToTree(this.getAlwaysDeploy()));
            }
            if (this.getAuth() != null) {
                data.set("auth", om.valueToTree(this.getAuth()));
            }
            if (this.getBinaryMediaTypes() != null) {
                data.set("binaryMediaTypes", om.valueToTree(this.getBinaryMediaTypes()));
            }
            if (this.getCacheClusterEnabled() != null) {
                data.set("cacheClusterEnabled", om.valueToTree(this.getCacheClusterEnabled()));
            }
            if (this.getCacheClusterSize() != null) {
                data.set("cacheClusterSize", om.valueToTree(this.getCacheClusterSize()));
            }
            if (this.getCanarySetting() != null) {
                data.set("canarySetting", om.valueToTree(this.getCanarySetting()));
            }
            if (this.getCors() != null) {
                data.set("cors", om.valueToTree(this.getCors()));
            }
            if (this.getDefinitionBody() != null) {
                data.set("definitionBody", om.valueToTree(this.getDefinitionBody()));
            }
            if (this.getDefinitionUri() != null) {
                data.set("definitionUri", om.valueToTree(this.getDefinitionUri()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDisableExecuteApiEndpoint() != null) {
                data.set("disableExecuteApiEndpoint", om.valueToTree(this.getDisableExecuteApiEndpoint()));
            }
            if (this.getDomain() != null) {
                data.set("domain", om.valueToTree(this.getDomain()));
            }
            if (this.getEndpointConfiguration() != null) {
                data.set("endpointConfiguration", om.valueToTree(this.getEndpointConfiguration()));
            }
            if (this.getGatewayResponses() != null) {
                data.set("gatewayResponses", om.valueToTree(this.getGatewayResponses()));
            }
            if (this.getMethodSettings() != null) {
                data.set("methodSettings", om.valueToTree(this.getMethodSettings()));
            }
            if (this.getMinimumCompressionSize() != null) {
                data.set("minimumCompressionSize", om.valueToTree(this.getMinimumCompressionSize()));
            }
            if (this.getModels() != null) {
                data.set("models", om.valueToTree(this.getModels()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getOpenApiVersion() != null) {
                data.set("openApiVersion", om.valueToTree(this.getOpenApiVersion()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTracingEnabled() != null) {
                data.set("tracingEnabled", om.valueToTree(this.getTracingEnabled()));
            }
            if (this.getVariables() != null) {
                data.set("variables", om.valueToTree(this.getVariables()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnApiProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApiProps.Jsii$Proxy that = (CfnApiProps.Jsii$Proxy) o;

            if (!stageName.equals(that.stageName)) return false;
            if (this.accessLogSetting != null ? !this.accessLogSetting.equals(that.accessLogSetting) : that.accessLogSetting != null) return false;
            if (this.alwaysDeploy != null ? !this.alwaysDeploy.equals(that.alwaysDeploy) : that.alwaysDeploy != null) return false;
            if (this.auth != null ? !this.auth.equals(that.auth) : that.auth != null) return false;
            if (this.binaryMediaTypes != null ? !this.binaryMediaTypes.equals(that.binaryMediaTypes) : that.binaryMediaTypes != null) return false;
            if (this.cacheClusterEnabled != null ? !this.cacheClusterEnabled.equals(that.cacheClusterEnabled) : that.cacheClusterEnabled != null) return false;
            if (this.cacheClusterSize != null ? !this.cacheClusterSize.equals(that.cacheClusterSize) : that.cacheClusterSize != null) return false;
            if (this.canarySetting != null ? !this.canarySetting.equals(that.canarySetting) : that.canarySetting != null) return false;
            if (this.cors != null ? !this.cors.equals(that.cors) : that.cors != null) return false;
            if (this.definitionBody != null ? !this.definitionBody.equals(that.definitionBody) : that.definitionBody != null) return false;
            if (this.definitionUri != null ? !this.definitionUri.equals(that.definitionUri) : that.definitionUri != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.disableExecuteApiEndpoint != null ? !this.disableExecuteApiEndpoint.equals(that.disableExecuteApiEndpoint) : that.disableExecuteApiEndpoint != null) return false;
            if (this.domain != null ? !this.domain.equals(that.domain) : that.domain != null) return false;
            if (this.endpointConfiguration != null ? !this.endpointConfiguration.equals(that.endpointConfiguration) : that.endpointConfiguration != null) return false;
            if (this.gatewayResponses != null ? !this.gatewayResponses.equals(that.gatewayResponses) : that.gatewayResponses != null) return false;
            if (this.methodSettings != null ? !this.methodSettings.equals(that.methodSettings) : that.methodSettings != null) return false;
            if (this.minimumCompressionSize != null ? !this.minimumCompressionSize.equals(that.minimumCompressionSize) : that.minimumCompressionSize != null) return false;
            if (this.models != null ? !this.models.equals(that.models) : that.models != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.openApiVersion != null ? !this.openApiVersion.equals(that.openApiVersion) : that.openApiVersion != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.tracingEnabled != null ? !this.tracingEnabled.equals(that.tracingEnabled) : that.tracingEnabled != null) return false;
            return this.variables != null ? this.variables.equals(that.variables) : that.variables == null;
        }

        @Override
        public final int hashCode() {
            int result = this.stageName.hashCode();
            result = 31 * result + (this.accessLogSetting != null ? this.accessLogSetting.hashCode() : 0);
            result = 31 * result + (this.alwaysDeploy != null ? this.alwaysDeploy.hashCode() : 0);
            result = 31 * result + (this.auth != null ? this.auth.hashCode() : 0);
            result = 31 * result + (this.binaryMediaTypes != null ? this.binaryMediaTypes.hashCode() : 0);
            result = 31 * result + (this.cacheClusterEnabled != null ? this.cacheClusterEnabled.hashCode() : 0);
            result = 31 * result + (this.cacheClusterSize != null ? this.cacheClusterSize.hashCode() : 0);
            result = 31 * result + (this.canarySetting != null ? this.canarySetting.hashCode() : 0);
            result = 31 * result + (this.cors != null ? this.cors.hashCode() : 0);
            result = 31 * result + (this.definitionBody != null ? this.definitionBody.hashCode() : 0);
            result = 31 * result + (this.definitionUri != null ? this.definitionUri.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.disableExecuteApiEndpoint != null ? this.disableExecuteApiEndpoint.hashCode() : 0);
            result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
            result = 31 * result + (this.endpointConfiguration != null ? this.endpointConfiguration.hashCode() : 0);
            result = 31 * result + (this.gatewayResponses != null ? this.gatewayResponses.hashCode() : 0);
            result = 31 * result + (this.methodSettings != null ? this.methodSettings.hashCode() : 0);
            result = 31 * result + (this.minimumCompressionSize != null ? this.minimumCompressionSize.hashCode() : 0);
            result = 31 * result + (this.models != null ? this.models.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.openApiVersion != null ? this.openApiVersion.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.tracingEnabled != null ? this.tracingEnabled.hashCode() : 0);
            result = 31 * result + (this.variables != null ? this.variables.hashCode() : 0);
            return result;
        }
    }
}
