package software.amazon.awscdk.services.stepfunctions;

/**
 * Error handler details.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * Object assign;
 * Object outputs;
 * CatchProps catchProps = CatchProps.builder()
 *         .assign(Map.of(
 *                 "assignKey", assign))
 *         .errors(List.of("errors"))
 *         .outputs(outputs)
 *         .resultPath("resultPath")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:33.429Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.CatchProps")
@software.amazon.jsii.Jsii.Proxy(CatchProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CatchProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Workflow variables to store in this step.
     * <p>
     * Using workflow variables, you can store data in a step and retrieve that data in future steps.
     * <p>
     * Default: - Not assign variables
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/workflow-variables.html">https://docs.aws.amazon.com/step-functions/latest/dg/workflow-variables.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getAssign() {
        return null;
    }

    /**
     * Errors to recover from by going to the given state.
     * <p>
     * A list of error strings to retry, which can be either predefined errors
     * (for example Errors.NoChoiceMatched) or a self-defined error.
     * <p>
     * Default: All errors
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getErrors() {
        return null;
    }

    /**
     * This option for JSONata only.
     * <p>
     * When you use JSONPath, then the state ignores this property.
     * Used to specify and transform output from the state.
     * When specified, the value overrides the state output default.
     * The output field accepts any JSON value (object, array, string, number, boolean, null).
     * Any string value, including those inside objects or arrays,
     * will be evaluated as JSONata if surrounded by {% %} characters.
     * Output also accepts a JSONata expression directly.
     * <p>
     * Default: - $states.result or $states.errorOutput
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-input-output-filtering.html">https://docs.aws.amazon.com/step-functions/latest/dg/concepts-input-output-filtering.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOutputs() {
        return null;
    }

    /**
     * JSONPath expression to indicate where to inject the error data.
     * <p>
     * May also be the special value JsonPath.DISCARD, which will cause the error
     * data to be discarded.
     * <p>
     * Default: $
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResultPath() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CatchProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CatchProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CatchProps> {
        java.util.Map<java.lang.String, java.lang.Object> assign;
        java.util.List<java.lang.String> errors;
        java.lang.Object outputs;
        java.lang.String resultPath;

        /**
         * Sets the value of {@link CatchProps#getAssign}
         * @param assign Workflow variables to store in this step.
         *               Using workflow variables, you can store data in a step and retrieve that data in future steps.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assign(java.util.Map<java.lang.String, ? extends java.lang.Object> assign) {
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)assign;
            return this;
        }

        /**
         * Sets the value of {@link CatchProps#getErrors}
         * @param errors Errors to recover from by going to the given state.
         *               A list of error strings to retry, which can be either predefined errors
         *               (for example Errors.NoChoiceMatched) or a self-defined error.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder errors(java.util.List<java.lang.String> errors) {
            this.errors = errors;
            return this;
        }

        /**
         * Sets the value of {@link CatchProps#getOutputs}
         * @param outputs This option for JSONata only.
         *                When you use JSONPath, then the state ignores this property.
         *                Used to specify and transform output from the state.
         *                When specified, the value overrides the state output default.
         *                The output field accepts any JSON value (object, array, string, number, boolean, null).
         *                Any string value, including those inside objects or arrays,
         *                will be evaluated as JSONata if surrounded by {% %} characters.
         *                Output also accepts a JSONata expression directly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(java.lang.Object outputs) {
            this.outputs = outputs;
            return this;
        }

        /**
         * Sets the value of {@link CatchProps#getResultPath}
         * @param resultPath JSONPath expression to indicate where to inject the error data.
         *                   May also be the special value JsonPath.DISCARD, which will cause the error
         *                   data to be discarded.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(java.lang.String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CatchProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CatchProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CatchProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CatchProps {
        private final java.util.Map<java.lang.String, java.lang.Object> assign;
        private final java.util.List<java.lang.String> errors;
        private final java.lang.Object outputs;
        private final java.lang.String resultPath;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assign = software.amazon.jsii.Kernel.get(this, "assign", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.errors = software.amazon.jsii.Kernel.get(this, "errors", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resultPath = software.amazon.jsii.Kernel.get(this, "resultPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)builder.assign;
            this.errors = builder.errors;
            this.outputs = builder.outputs;
            this.resultPath = builder.resultPath;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getAssign() {
            return this.assign;
        }

        @Override
        public final java.util.List<java.lang.String> getErrors() {
            return this.errors;
        }

        @Override
        public final java.lang.Object getOutputs() {
            return this.outputs;
        }

        @Override
        public final java.lang.String getResultPath() {
            return this.resultPath;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAssign() != null) {
                data.set("assign", om.valueToTree(this.getAssign()));
            }
            if (this.getErrors() != null) {
                data.set("errors", om.valueToTree(this.getErrors()));
            }
            if (this.getOutputs() != null) {
                data.set("outputs", om.valueToTree(this.getOutputs()));
            }
            if (this.getResultPath() != null) {
                data.set("resultPath", om.valueToTree(this.getResultPath()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.CatchProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CatchProps.Jsii$Proxy that = (CatchProps.Jsii$Proxy) o;

            if (this.assign != null ? !this.assign.equals(that.assign) : that.assign != null) return false;
            if (this.errors != null ? !this.errors.equals(that.errors) : that.errors != null) return false;
            if (this.outputs != null ? !this.outputs.equals(that.outputs) : that.outputs != null) return false;
            return this.resultPath != null ? this.resultPath.equals(that.resultPath) : that.resultPath == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assign != null ? this.assign.hashCode() : 0;
            result = 31 * result + (this.errors != null ? this.errors.hashCode() : 0);
            result = 31 * result + (this.outputs != null ? this.outputs.hashCode() : 0);
            result = 31 * result + (this.resultPath != null ? this.resultPath.hashCode() : 0);
            return result;
        }
    }
}
