package software.amazon.awscdk.services.stepfunctions;

/**
 * Base class for reusable state machine fragments.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.Stack;
 * import software.constructs.Construct;
 * import software.amazon.awscdk.services.stepfunctions.*;
 * public class MyJobProps {
 *     private String jobFlavor;
 *     public String getJobFlavor() {
 *         return this.jobFlavor;
 *     }
 *     public MyJobProps jobFlavor(String jobFlavor) {
 *         this.jobFlavor = jobFlavor;
 *         return this;
 *     }
 * }
 * public class MyJob extends StateMachineFragment {
 *     public final State startState;
 *     public final INextable[] endStates;
 *     public MyJob(Construct parent, String id, MyJobProps props) {
 *         super(parent, id);
 *         Choice choice = new Choice(this, "Choice").when(Condition.stringEquals("$.branch", "left"), new Pass(this, "Left Branch")).when(Condition.stringEquals("$.branch", "right"), new Pass(this, "Right Branch"));
 *         // ...
 *         this.startState = choice;
 *         this.endStates = choice.afterwards().getEndStates();
 *     }
 * }
 * public class MyStack extends Stack {
 *     public MyStack(Construct scope, String id) {
 *         super(scope, id);
 *         // Do 3 different variants of MyJob in parallel
 *         Parallel parallel = new Parallel(this, "All jobs").branch(new MyJob(this, "Quick", new MyJobProps().jobFlavor("quick")).prefixStates()).branch(new MyJob(this, "Medium", new MyJobProps().jobFlavor("medium")).prefixStates()).branch(new MyJob(this, "Slow", new MyJobProps().jobFlavor("slow")).prefixStates());
 *         StateMachine.Builder.create(this, "MyStateMachine")
 *                 .definitionBody(DefinitionBody.fromChainable(parallel))
 *                 .build();
 *     }
 * }
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:33.543Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.StateMachineFragment")
public abstract class StateMachineFragment extends software.constructs.Construct implements software.amazon.awscdk.services.stepfunctions.IChainable {

    protected StateMachineFragment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StateMachineFragment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates a new construct node.
     * <p>
     * @param scope The scope in which to define this construct. This parameter is required.
     * @param id The scoped construct ID. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected StateMachineFragment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Continue normal execution with the given state.
     * <p>
     * @param next This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Chain next(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable next) {
        return software.amazon.jsii.Kernel.call(this, "next", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Chain.class), new Object[] { java.util.Objects.requireNonNull(next, "next is required") });
    }

    /**
     * Prefix the IDs of all states in this state machine fragment.
     * <p>
     * Use this to avoid multiple copies of the state machine all having the
     * same state IDs.
     * <p>
     * @param prefix The prefix to add.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateMachineFragment prefixStates(final @org.jetbrains.annotations.Nullable java.lang.String prefix) {
        return software.amazon.jsii.Kernel.call(this, "prefixStates", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.StateMachineFragment.class), new Object[] { prefix });
    }

    /**
     * Prefix the IDs of all states in this state machine fragment.
     * <p>
     * Use this to avoid multiple copies of the state machine all having the
     * same state IDs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateMachineFragment prefixStates() {
        return software.amazon.jsii.Kernel.call(this, "prefixStates", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.StateMachineFragment.class));
    }

    /**
     * Wrap all states in this state machine fragment up into a single state.
     * <p>
     * This can be used to add retry or error handling onto this state
     * machine fragment.
     * <p>
     * Be aware that this changes the result of the inner state machine
     * to be an array with the result of the state machine in it. Adjust
     * your paths accordingly. For example, change 'outputPath' to
     * '$[0]'.
     * <p>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Parallel toSingleState(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.SingleStateOptions options) {
        return software.amazon.jsii.Kernel.call(this, "toSingleState", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Parallel.class), new Object[] { options });
    }

    /**
     * Wrap all states in this state machine fragment up into a single state.
     * <p>
     * This can be used to add retry or error handling onto this state
     * machine fragment.
     * <p>
     * Be aware that this changes the result of the inner state machine
     * to be an array with the result of the state machine in it. Adjust
     * your paths accordingly. For example, change 'outputPath' to
     * '$[0]'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Parallel toSingleState() {
        return software.amazon.jsii.Kernel.call(this, "toSingleState", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Parallel.class));
    }

    /**
     * The states to chain onto if this fragment is used.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> getEndStates();

    /**
     * Descriptive identifier for this chainable.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getId() {
        return software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The start state of this state machine fragment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State getStartState();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.stepfunctions.StateMachineFragment implements software.amazon.awscdk.services.stepfunctions.IChainable.Jsii$Default, software.constructs.IConstruct.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The states to chain onto if this fragment is used.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> getEndStates() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "endStates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.INextable.class))));
        }

        /**
         * The start state of this state machine fragment.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State getStartState() {
            return software.amazon.jsii.Kernel.get(this, "startState", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.State.class));
        }
    }
}
