package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Base properties for calling an HTTP API Endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.stepfunctions.tasks.*;
 * Stack stack;
 * CallApiGatewayHttpApiEndpointOptions callApiGatewayHttpApiEndpointOptions = CallApiGatewayHttpApiEndpointOptions.builder()
 *         .apiId("apiId")
 *         .apiStack(stack)
 *         // the properties below are optional
 *         .stageName("stageName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:33.647Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.CallApiGatewayHttpApiEndpointOptions")
@software.amazon.jsii.Jsii.Proxy(CallApiGatewayHttpApiEndpointOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CallApiGatewayHttpApiEndpointOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the API to call.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiId();

    /**
     * The Stack in which the API is defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getApiStack();

    /**
     * Name of the stage where the API is deployed to in API Gateway.
     * <p>
     * Default: '$default'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStageName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CallApiGatewayHttpApiEndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CallApiGatewayHttpApiEndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CallApiGatewayHttpApiEndpointOptions> {
        java.lang.String apiId;
        software.amazon.awscdk.Stack apiStack;
        java.lang.String stageName;

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointOptions#getApiId}
         * @param apiId The Id of the API to call. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiId(java.lang.String apiId) {
            this.apiId = apiId;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointOptions#getApiStack}
         * @param apiStack The Stack in which the API is defined. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiStack(software.amazon.awscdk.Stack apiStack) {
            this.apiStack = apiStack;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointOptions#getStageName}
         * @param stageName Name of the stage where the API is deployed to in API Gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageName(java.lang.String stageName) {
            this.stageName = stageName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CallApiGatewayHttpApiEndpointOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CallApiGatewayHttpApiEndpointOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CallApiGatewayHttpApiEndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CallApiGatewayHttpApiEndpointOptions {
        private final java.lang.String apiId;
        private final software.amazon.awscdk.Stack apiStack;
        private final java.lang.String stageName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiId = software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.apiStack = software.amazon.jsii.Kernel.get(this, "apiStack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
            this.stageName = software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiId = java.util.Objects.requireNonNull(builder.apiId, "apiId is required");
            this.apiStack = java.util.Objects.requireNonNull(builder.apiStack, "apiStack is required");
            this.stageName = builder.stageName;
        }

        @Override
        public final java.lang.String getApiId() {
            return this.apiId;
        }

        @Override
        public final software.amazon.awscdk.Stack getApiStack() {
            return this.apiStack;
        }

        @Override
        public final java.lang.String getStageName() {
            return this.stageName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiId", om.valueToTree(this.getApiId()));
            data.set("apiStack", om.valueToTree(this.getApiStack()));
            if (this.getStageName() != null) {
                data.set("stageName", om.valueToTree(this.getStageName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.CallApiGatewayHttpApiEndpointOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CallApiGatewayHttpApiEndpointOptions.Jsii$Proxy that = (CallApiGatewayHttpApiEndpointOptions.Jsii$Proxy) o;

            if (!apiId.equals(that.apiId)) return false;
            if (!apiStack.equals(that.apiStack)) return false;
            return this.stageName != null ? this.stageName.equals(that.stageName) : that.stageName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiId.hashCode();
            result = 31 * result + (this.apiStack.hashCode());
            result = 31 * result + (this.stageName != null ? this.stageName.hashCode() : 0);
            return result;
        }
    }
}
