package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Method type of a EKS call.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.eks.*;
 * import software.amazon.awscdk.cdk.lambdalayer.kubectl.v32.KubectlV32Layer;
 * Cluster myEksCluster = Cluster.Builder.create(this, "my sample cluster")
 *         .version(KubernetesVersion.V1_32)
 *         .clusterName("myEksCluster")
 *         .kubectlLayer(new KubectlV32Layer(this, "kubectl"))
 *         .build();
 * EksCall.Builder.create(this, "Call a EKS Endpoint")
 *         .cluster(myEksCluster)
 *         .httpMethod(HttpMethods.GET)
 *         .httpPath("/api/v1/namespaces/default/pods")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:33.914Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.HttpMethods")
public enum HttpMethods {
    /**
     * Retrieve data from a server at the specified resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GET,
    /**
     * Send data to the API endpoint to create or update a resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    POST,
    /**
     * Send data to the API endpoint to update or create a resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PUT,
    /**
     * Delete the resource at the specified endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DELETE,
    /**
     * Apply partial modifications to the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PATCH,
    /**
     * Retrieve data from a server at the specified resource without the response body.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HEAD,
}
