package software.amazon.awscdk.services.synthetics;

/**
 * Define a new Canary.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * Canary canary = Canary.Builder.create(this, "MyCanary")
 *         .schedule(Schedule.rate(Duration.minutes(5)))
 *         .test(Test.custom(CustomTestOptions.builder()
 *                 .code(Code.fromAsset(join(__dirname, "canary")))
 *                 .handler("index.handler")
 *                 .build()))
 *         .runtime(Runtime.SYNTHETICS_NODEJS_PUPPETEER_6_2)
 *         .memory(Size.mebibytes(1024))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:34.043Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_synthetics.Canary")
public class Canary extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.ec2.IConnectable {

    protected Canary(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Canary(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Canary(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.CanaryProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Measure the Duration of a single canary run, in seconds.
     * <p>
     * Default: avg over 5 minutes
     * <p>
     * @param options <ul><li>configuration options for the metric.</li></ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDuration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions options) {
        return software.amazon.jsii.Kernel.call(this, "metricDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { options });
    }

    /**
     * Measure the Duration of a single canary run, in seconds.
     * <p>
     * Default: avg over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDuration() {
        return software.amazon.jsii.Kernel.call(this, "metricDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Measure the number of failed canary runs over a given time period.
     * <p>
     * Default: sum over 5 minutes
     * <p>
     * @param options <ul><li>configuration options for the metric.</li></ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFailed(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions options) {
        return software.amazon.jsii.Kernel.call(this, "metricFailed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { options });
    }

    /**
     * Measure the number of failed canary runs over a given time period.
     * <p>
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFailed() {
        return software.amazon.jsii.Kernel.call(this, "metricFailed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Measure the percentage of successful canary runs.
     * <p>
     * Default: avg over 5 minutes
     * <p>
     * @param options <ul><li>configuration options for the metric.</li></ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSuccessPercent(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions options) {
        return software.amazon.jsii.Kernel.call(this, "metricSuccessPercent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { options });
    }

    /**
     * Measure the percentage of successful canary runs.
     * <p>
     * Default: avg over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSuccessPercent() {
        return software.amazon.jsii.Kernel.call(this, "metricSuccessPercent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Bucket where data from each canary run is stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getArtifactsBucket() {
        return software.amazon.jsii.Kernel.get(this, "artifactsBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
    }

    /**
     * The canary ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCanaryId() {
        return software.amazon.jsii.Kernel.get(this, "canaryId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The canary Name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCanaryName() {
        return software.amazon.jsii.Kernel.get(this, "canaryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The state of the canary.
     * <p>
     * For example, 'RUNNING', 'STOPPED', 'NOT STARTED', or 'ERROR'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCanaryState() {
        return software.amazon.jsii.Kernel.get(this, "canaryState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Access the Connections object.
     * <p>
     * Will fail if not a VPC-enabled Canary
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * Execution role associated with this Canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.synthetics.Canary}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.synthetics.Canary> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.synthetics.CanaryProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.synthetics.CanaryProps.Builder();
        }

        /**
         * Specify the runtime version to use for the canary.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html</a>
         * @param runtime Specify the runtime version to use for the canary. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtime(final software.amazon.awscdk.services.synthetics.Runtime runtime) {
            this.props.runtime(runtime);
            return this;
        }

        /**
         * The type of test that you want your canary to run.
         * <p>
         * Use <code>Test.custom()</code> to specify the test to run.
         * <p>
         * @return {@code this}
         * @param test The type of test that you want your canary to run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder test(final software.amazon.awscdk.services.synthetics.Test test) {
            this.props.test(test);
            return this;
        }

        /**
         * Specifies whether this canary is to use active AWS X-Ray tracing when it runs.
         * <p>
         * Active tracing enables this canary run to be displayed in the ServiceLens and X-Ray service maps even if the
         * canary does not hit an endpoint that has X-Ray tracing enabled. Using X-Ray tracing incurs charges.
         * <p>
         * You can enable active tracing only for canaries that use version <code>syn-nodejs-2.0</code> or later for their canary runtime.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_tracing.html">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_tracing.html</a>
         * @param activeTracing Specifies whether this canary is to use active AWS X-Ray tracing when it runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder activeTracing(final java.lang.Boolean activeTracing) {
            this.props.activeTracing(activeTracing);
            return this;
        }

        /**
         * Canary Artifacts in S3 encryption mode.
         * <p>
         * Artifact encryption is only supported for canaries that use Synthetics runtime
         * version <code>syn-nodejs-puppeteer-3.3</code> or later.
         * <p>
         * Default: - Artifacts are encrypted at rest using an AWS managed key. `ArtifactsEncryptionMode.KMS` is set if you specify `artifactS3KmsKey`.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_artifact_encryption.html">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_artifact_encryption.html</a>
         * @param artifactS3EncryptionMode Canary Artifacts in S3 encryption mode. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactS3EncryptionMode(final software.amazon.awscdk.services.synthetics.ArtifactsEncryptionMode artifactS3EncryptionMode) {
            this.props.artifactS3EncryptionMode(artifactS3EncryptionMode);
            return this;
        }

        /**
         * The KMS key used to encrypt canary artifacts.
         * <p>
         * Default: - no kms key if `artifactS3EncryptionMode` is set to `S3_MANAGED`. A key will be created if one is not provided and `artifactS3EncryptionMode` is set to `KMS`.
         * <p>
         * @return {@code this}
         * @param artifactS3KmsKey The KMS key used to encrypt canary artifacts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactS3KmsKey(final software.amazon.awscdk.services.kms.IKey artifactS3KmsKey) {
            this.props.artifactS3KmsKey(artifactS3KmsKey);
            return this;
        }

        /**
         * Lifecycle rules for the generated canary artifact bucket.
         * <p>
         * Has no effect
         * if a bucket is passed to <code>artifactsBucketLocation</code>. If you pass a bucket
         * to <code>artifactsBucketLocation</code>, you can add lifecycle rules to the bucket
         * itself.
         * <p>
         * Default: - no rules applied to the generated bucket.
         * <p>
         * @return {@code this}
         * @param artifactsBucketLifecycleRules Lifecycle rules for the generated canary artifact bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactsBucketLifecycleRules(final java.util.List<? extends software.amazon.awscdk.services.s3.LifecycleRule> artifactsBucketLifecycleRules) {
            this.props.artifactsBucketLifecycleRules(artifactsBucketLifecycleRules);
            return this;
        }

        /**
         * The s3 location that stores the data of the canary runs.
         * <p>
         * Default: - A new s3 bucket will be created without a prefix.
         * <p>
         * @return {@code this}
         * @param artifactsBucketLocation The s3 location that stores the data of the canary runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactsBucketLocation(final software.amazon.awscdk.services.synthetics.ArtifactsBucketLocation artifactsBucketLocation) {
            this.props.artifactsBucketLocation(artifactsBucketLocation);
            return this;
        }

        /**
         * The name of the canary.
         * <p>
         * Be sure to give it a descriptive name that distinguishes it from
         * other canaries in your account.
         * <p>
         * Do not include secrets or proprietary information in your canary name. The canary name
         * makes up part of the canary ARN, which is included in outbound calls over the internet.
         * <p>
         * Default: - A unique name will be generated from the construct ID
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html</a>
         * @param canaryName The name of the canary. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder canaryName(final java.lang.String canaryName) {
            this.props.canaryName(canaryName);
            return this;
        }

        /**
         * (deprecated) Specify the underlying resources to be cleaned up when the canary is deleted.
         * <p>
         * Using <code>Cleanup.LAMBDA</code> will create a Custom Resource to achieve this.
         * <p>
         * Default: Cleanup.NOTHING
         * <p>
         * @return {@code this}
         * @deprecated use provisionedResourceCleanup
         * @param cleanup Specify the underlying resources to be cleaned up when the canary is deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder cleanup(final software.amazon.awscdk.services.synthetics.Cleanup cleanup) {
            this.props.cleanup(cleanup);
            return this;
        }

        /**
         * Key-value pairs that the Synthetics caches and makes available for your canary scripts.
         * <p>
         * Use environment variables
         * to apply configuration changes, such as test and production environment configurations, without changing your
         * Canary script source code.
         * <p>
         * Default: - No environment variables.
         * <p>
         * @return {@code this}
         * @param environmentVariables Key-value pairs that the Synthetics caches and makes available for your canary scripts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentVariables(final java.util.Map<java.lang.String, java.lang.String> environmentVariables) {
            this.props.environmentVariables(environmentVariables);
            return this;
        }

        /**
         * How many days should failed runs be retained.
         * <p>
         * Default: Duration.days(31)
         * <p>
         * @return {@code this}
         * @param failureRetentionPeriod How many days should failed runs be retained. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failureRetentionPeriod(final software.amazon.awscdk.Duration failureRetentionPeriod) {
            this.props.failureRetentionPeriod(failureRetentionPeriod);
            return this;
        }

        /**
         * The maximum amount of memory that the canary can use while running.
         * <p>
         * This value must be a multiple of 64 Mib.
         * The range is 960 MiB to 3008 MiB.
         * <p>
         * Default: Size.mebibytes(1024)
         * <p>
         * @return {@code this}
         * @param memory The maximum amount of memory that the canary can use while running. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memory(final software.amazon.awscdk.Size memory) {
            this.props.memory(memory);
            return this;
        }

        /**
         * Whether to also delete the Lambda functions and layers used by this canary when the canary is deleted.
         * <p>
         * Default: undefined - the default behavior is to not delete the Lambda functions and layers
         * <p>
         * @return {@code this}
         * @param provisionedResourceCleanup Whether to also delete the Lambda functions and layers used by this canary when the canary is deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedResourceCleanup(final java.lang.Boolean provisionedResourceCleanup) {
            this.props.provisionedResourceCleanup(provisionedResourceCleanup);
            return this;
        }

        /**
         * Canary execution role.
         * <p>
         * This is the role that will be assumed by the canary upon execution.
         * It controls the permissions that the canary will have. The role must
         * be assumable by the AWS Lambda service principal.
         * <p>
         * If not supplied, a role will be created with all the required permissions.
         * If you provide a Role, you must add the required permissions.
         * <p>
         * Default: - A unique role will be generated for this canary.
         * You can add permissions to roles by calling 'addToRolePolicy'.
         * <p>
         * @return {@code this}
         * @see <a href="required permissions: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-executionrolearn">required permissions: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-executionrolearn</a>
         * @param role Canary execution role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * Specify the schedule for how often the canary runs.
         * <p>
         * For example, if you set <code>schedule</code> to <code>rate(10 minutes)</code>, then the canary will run every 10 minutes.
         * You can set the schedule with <code>Schedule.rate(Duration)</code> (recommended) or you can specify an expression using <code>Schedule.expression()</code>.
         * <p>
         * Default: 'rate(5 minutes)'
         * <p>
         * @return {@code this}
         * @param schedule Specify the schedule for how often the canary runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.services.synthetics.Schedule schedule) {
            this.props.schedule(schedule);
            return this;
        }

        /**
         * The list of security groups to associate with the canary's network interfaces.
         * <p>
         * You must provide <code>vpc</code> when using this prop.
         * <p>
         * Default: - If the canary is placed within a VPC and a security group is
         * not specified a dedicated security group will be created for this canary.
         * <p>
         * @return {@code this}
         * @param securityGroups The list of security groups to associate with the canary's network interfaces. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * Whether or not the canary should start after creation.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param startAfterCreation Whether or not the canary should start after creation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startAfterCreation(final java.lang.Boolean startAfterCreation) {
            this.props.startAfterCreation(startAfterCreation);
            return this;
        }

        /**
         * How many days should successful runs be retained.
         * <p>
         * Default: Duration.days(31)
         * <p>
         * @return {@code this}
         * @param successRetentionPeriod How many days should successful runs be retained. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder successRetentionPeriod(final software.amazon.awscdk.Duration successRetentionPeriod) {
            this.props.successRetentionPeriod(successRetentionPeriod);
            return this;
        }

        /**
         * How long the canary is allowed to run before it must stop.
         * <p>
         * You can't set this time to be longer than the frequency of the runs of this canary.
         * <p>
         * The minimum allowed value is 3 seconds.
         * The maximum allowed value is 840 seconds (14 minutes).
         * <p>
         * Default: - the frequency of the canary is used as this value, up to a maximum of 900 seconds.
         * <p>
         * @return {@code this}
         * @param timeout How long the canary is allowed to run before it must stop. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * How long the canary will be in a 'RUNNING' state.
         * <p>
         * For example, if you set <code>timeToLive</code> to be 1 hour and <code>schedule</code> to be <code>rate(10 minutes)</code>,
         * your canary will run at 10 minute intervals for an hour, for a total of 6 times.
         * <p>
         * Default: - no limit
         * <p>
         * @return {@code this}
         * @param timeToLive How long the canary will be in a 'RUNNING' state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeToLive(final software.amazon.awscdk.Duration timeToLive) {
            this.props.timeToLive(timeToLive);
            return this;
        }

        /**
         * The VPC where this canary is run.
         * <p>
         * Specify this if the canary needs to access resources in a VPC.
         * <p>
         * Default: - Not in VPC
         * <p>
         * @return {@code this}
         * @param vpc The VPC where this canary is run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Where to place the network interfaces within the VPC.
         * <p>
         * You must provide <code>vpc</code> when using this prop.
         * <p>
         * Default: - the Vpc default strategy if not specified
         * <p>
         * @return {@code this}
         * @param vpcSubnets Where to place the network interfaces within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.synthetics.Canary}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.synthetics.Canary build() {
            return new software.amazon.awscdk.services.synthetics.Canary(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
