package software.amazon.awscdk;

/**
 * Default resolver implementation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * IFragmentConcatenator fragmentConcatenator;
 * DefaultTokenResolver defaultTokenResolver = new DefaultTokenResolver(fragmentConcatenator);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:30.964Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.DefaultTokenResolver")
public class DefaultTokenResolver extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.ITokenResolver {

    protected DefaultTokenResolver(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DefaultTokenResolver(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param concat This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DefaultTokenResolver(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IFragmentConcatenator concat) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(concat, "concat is required") });
    }

    /**
     * Resolve a tokenized list.
     * <p>
     * @param xs This parameter is required.
     * @param context This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object resolveList(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> xs, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolveContext context) {
        return software.amazon.jsii.Kernel.call(this, "resolveList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { java.util.Objects.requireNonNull(xs, "xs is required"), java.util.Objects.requireNonNull(context, "context is required") });
    }

    /**
     * Resolve string fragments to Tokens.
     * <p>
     * @param fragments This parameter is required.
     * @param context This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object resolveString(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TokenizedStringFragments fragments, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolveContext context) {
        return software.amazon.jsii.Kernel.call(this, "resolveString", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { java.util.Objects.requireNonNull(fragments, "fragments is required"), java.util.Objects.requireNonNull(context, "context is required") });
    }

    /**
     * Default Token resolution.
     * <p>
     * Resolve the Token, recurse into whatever it returns,
     * then finally post-process it.
     * <p>
     * @param t This parameter is required.
     * @param context This parameter is required.
     * @param postProcessor This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object resolveToken(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable t, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolveContext context, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IPostProcessor postProcessor) {
        return software.amazon.jsii.Kernel.call(this, "resolveToken", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { java.util.Objects.requireNonNull(t, "t is required"), java.util.Objects.requireNonNull(context, "context is required"), java.util.Objects.requireNonNull(postProcessor, "postProcessor is required") });
    }
}
