package software.amazon.awscdk;

/**
 * A collection of validation results.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * ValidationResult validationResult;
 * ValidationResults validationResults = new ValidationResults(List.of(validationResult));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:31.081Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.ValidationResults")
public class ValidationResults extends software.amazon.jsii.JsiiObject {

    protected ValidationResults(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ValidationResults(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param results
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ValidationResults(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.ValidationResult> results) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { results });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ValidationResults() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * @param result This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void collect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ValidationResult result) {
        software.amazon.jsii.Kernel.call(this, "collect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(result, "result is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String errorTreeList() {
        return software.amazon.jsii.Kernel.call(this, "errorTreeList", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Wrap up all validation results into a single tree node.
     * <p>
     * If there are failures in the collection, add a message, otherwise
     * return a success.
     * <p>
     * @param message This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.ValidationResult wrap(final @org.jetbrains.annotations.NotNull java.lang.String message) {
        return software.amazon.jsii.Kernel.call(this, "wrap", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ValidationResult.class), new Object[] { java.util.Objects.requireNonNull(message, "message is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsSuccess() {
        return software.amazon.jsii.Kernel.get(this, "isSuccess", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.ValidationResult> getResults() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "results", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ValidationResult.class))));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResults(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.ValidationResult> value) {
        software.amazon.jsii.Kernel.set(this, "results", java.util.Objects.requireNonNull(value, "results is required"));
    }
}
