package software.amazon.awscdk.assertions;

/**
 * Represents a matcher that can perform special data matching capabilities between a given pattern and a target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Given a template -
 * // {
 * //   "Resources": {
 * //     "MyBar": {
 * //       "Type": "Foo::Bar",
 * //       "Properties": {
 * //         "Fred": {
 * //           "Wobble": ["Flob", "Flib"],
 * //         }
 * //       }
 * //     }
 * //   }
 * // }
 * // The following will NOT throw an assertion error
 * template.hasResourceProperties("Foo::Bar", Map.of(
 *         "Fred", Map.of(
 *                 "Wobble", List.of(Match.anyValue(), Match.anyValue()))));
 * // The following will throw an assertion error
 * template.hasResourceProperties("Foo::Bar", Map.of(
 *         "Fred", Map.of(
 *                 "Wimble", Match.anyValue())));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:31.105Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.assertions.Matcher")
public abstract class Matcher extends software.amazon.jsii.JsiiObject {

    protected Matcher(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Matcher(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Matcher() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Check whether the provided object is a subtype of the <code>IMatcher</code>.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isMatcher(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.assertions.Matcher.class, "isMatcher", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Test whether a target matches the provided pattern.
     * <p>
     * Every Matcher must implement this method.
     * This method will be invoked by the assertions framework. Do not call this method directly.
     * <p>
     * @return the list of match failures. An empty array denotes a successful match.
     * @param actual the target to match. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.MatchResult test(final @org.jetbrains.annotations.NotNull java.lang.Object actual);

    /**
     * A name for the matcher.
     * <p>
     * This is collected as part of the result and may be presented to the user.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.assertions.Matcher {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * A name for the matcher.
         * <p>
         * This is collected as part of the result and may be presented to the user.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getName() {
            return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Test whether a target matches the provided pattern.
         * <p>
         * Every Matcher must implement this method.
         * This method will be invoked by the assertions framework. Do not call this method directly.
         * <p>
         * @return the list of match failures. An empty array denotes a successful match.
         * @param actual the target to match. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.MatchResult test(final @org.jetbrains.annotations.NotNull java.lang.Object actual) {
            return software.amazon.jsii.Kernel.call(this, "test", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.assertions.MatchResult.class), new Object[] { actual });
        }
    }
}
